/*	
 *	supp.c
 *
 *	VvCuT|[g[`W
 *	Copyright (C) 2002-2006 Naoyuki Sawa
 *
 *	* Sat Sep  7 18:26:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Dec  1 19:12:00 JST 2002 Naoyuki Sawa
 *	- bgdisp()ǉ܂B
 *	* Sun Dec  1 21:22:00 JST 2002 Naoyuki Sawa
 *	- symbolf()ǉ܂B
 *	* Sun Dec  2 07:11:00 JST 2002 Naoyuki Sawa
 *	- fxput()/fxputstr()/fxprintf()ǉ܂B
 *	  ǋL:->grfont()/grputstr()/grprintf()ɖ̕ύXB
 *	* Sun Dec  2 19:00:00 JST 2002 Naoyuki Sawa
 *	- XvCgn֐̃vtBNXsp*Ach*ɓB
 *	  afn֐̃vtBNXbg*ɓB
 *	  OtBbNn֐̃vtBNXgr*ɓB
 *	* Tue Dec  3 05:54:00 JST 2002 Naoyuki Sawa
 *	- die()ǉB
 *	* Wed Dec  4 05:52:00 JST 2002 Naoyuki Sawa
 *	- bgcls()/bgput()ǉB
 *	* Fri Dec 27 12:15:00 JST 2002 Naoyuki Sawa
 *	- grfont()tHg𕪗Afntadr()ǉB
 *	- pausedisp()ǉB
 *	* Wed Jan  1 11:02:00 JST 2003 Naoyuki Sawa
 *	- grfont()ɔwiFwǉB
 *	  grputstr()/grprintf()̐FwdlƂȂ܂B
 *	* Mon May 24 19:00:00 JST 2004 Naoyuki Sawa
 *	- hFLbgv1.00v2.10ɕύX܂B
 *	- die()֐̃RgɁARpCxɊւRgǋL܂B
 *	- CLiPCuvsprintf()NƁAɂ낢KvɂȂĂ܂̂ŁA
 *	  P/ECEpcevsprintf()I悤A֐𖾎܂B
 *	* Sat Dec 18 17:00:00 JST 2004 Naoyuki Sawa
 *	- die()֐̃RpCxɊւRgǉ܂B
 *	- turbo()֐̎ǉ܂B
 *	  pceAppNotify()ɂāAIɊmturbo[h悤ɂ܂B
 *	* Wed Mar 29 04:35:00 JST 2006 Naoyuki Sawa
 *	- turbo()֐ACLiPCu{̂ɍ킹čXV܂B
 *	- errnoϐ̒`AeAvP[VʂA{W[ֈړ܂B
 *	* Sat Apr 01 04:15:00 JST 2006 Naoyuki Sawa
 *	- BGʂ̃XN[ʒuݒ肷֐ bgscrl()bghome() ɉ܂B
 *	- BGʂ̃XN[ʒu擾֐ bghomex()Abghomey() ǉ܂B
 *	* Sat Apr 22 19:24:00 JST 2006 Naoyuki Sawa
 *	- rnd_range()ǉ܂B
 */
#include "supp.h"

/*****************************************************************************
 *	O[oϐ
 *****************************************************************************/

/* S1C33 Family CRpCpbP[Wł́Aerrno̓AvP[VŒ`Kv܂B
 * [S5U1C33000C_J.pdf p.140]
 */
int errno;

/****************************************************************************
 *	die
 ****************************************************************************/

/* CLiPdie()Ɠ@\֐́AVvCuł̎łB
 * ̂悤Ȍxo܂AĂB
 *
 *	supp.c: In function `die':
 *	supp.c:51: warning: `noreturn' function does return
 */
void
die(const char* fmt, ...)
{
extern void simple_error(char* fmt, ...); /* VvCu̔JAPI */

	va_list ap;

	va_start(ap, fmt);
	pcevsprintf(_def_vbuff, fmt, ap); /* VXepzʂ𗘗p!! */
	va_end(ap);

	simple_error(_def_vbuff);
	thread_return();

	/* * Sat Dec 18 17:00:00 JST 2004 Naoyuki Sawa
	 * - thread_return()̐錾__attribute__((noreturn))߁A
	 *   RpCx"warning: `noreturn' function does return"\܂B
	 *   ۂɂthread_return()͏ԂȂ̂ŁA̖͂܂B
	 *   RpČx͖ĂB
	 */
}

/****************************************************************************
 *	fntadr
 ****************************************************************************/

/* tHgf[^AhX擾܂B
 * [in]
 *	code		R[h(0`255Abit31-8͖܂)
 * [out]
 *	߂l		tHgf[^AhX
 * [note]
 *	* tHgf[^́A1C1oCgŁA1`8C̏ɕł܂B
 */
const unsigned char*
fntadr(int code)
{
extern unsigned char FONT[];
	static unsigned char* font; /* rs`shbłI */

	PBMP_FILEHEADER* header;
	unsigned char tmp[128]; /* 傫̂ŁAX^bNɎ̂͊댯H */
	unsigned char* dst;
	unsigned char a, b;
	int row, col, line, bit;

	/* ̂݁AtHgf[^܂B */
	if(font == NULL) {
		/* tHgOtBbNf[^擾B */
		header = (PBMP_FILEHEADER*)FONT;
		if((strncmp((char*)&header->head, "PMBP", 4) != 0) ||	/* VOl` */
		   (header->bpp != 1 || header->mask != 0) ||		/* 1bit}XNȂH */
		   (header->w != 128 || header->h != 128)) DIE();	/* 128x128H */
		font = (unsigned char*)(header + 1);
		/* OtBbNf[^(CP)LN^f[^(P)ɕёւB */
		dst = font;
		for(row = 0; row < 16; row++) {				/* 16s[v */
			memcpy(tmp, dst, 128);				/* ݍs̃OtBbNf[^ꎞobt@ɃRs[ */
			for(col = 0; col < 16; col++) {			/* 16[v */
				for(line = 0; line < 8; line++) {	/* 8C[v */
					a = tmp[line * 16 + col];	/* ݕ̃Cf[^擾 */
					b = 0;
					for(bit = 0; bit < 8; bit++) {
						b <<= 1;		/* Erbg](Drawn->XvCgnϊ) */
						b |= a & 1;
						a >>= 1;
					}
					*dst++ = b;			/* ݕ̃Cf[^i[ */
				}
			}
		}
	}

	/* ̃tHgAhX擾B(tHgf[^́APʕтŁAꕶ8oCgł) */
	return font + (code & 0xff) * 8;
}

/****************************************************************************
 *	spcls
 ****************************************************************************/

void
spcls(int obj)
{
	while(obj < N_OBJS) sppos(obj++, -8, -8);
}

/****************************************************************************
 *	chdisp
 ****************************************************************************/

/* ̃XvCg\AL\܂B
 * [in]
 *	obj		ŏ̃XvCgv[ԍ
 *	x, y		L̒SW
 *	chr		L\̂ւ̃|C^
 * [out]
 *	߂l		Ō̃XvCgv[ԍ{P
 * [note]
 *	* spdisp()ւ̈64zXvCgv[ԍw肵ꍇA
 *	  spdisp()ɏԂdlɈˑĂ܂B
 *	  chdisp()֐g̓XvCgv[ԍ͈̔͂lĂ܂B
 */
int
chdisp(int obj, int x, int y, const CHR* chr)
{
	int col, row, pno;

	/* SWւ̃ItZbgA_W炵܂B */
	x -= chr->x;
	y -= chr->y;

	/* L\AeXvCg\܂B */
	for(row = 0; row < chr->h; row++) {
		for(col = 0; col < chr->w; col++) {
			pno = chr->pno + 0x10 * row + col;
			spdisp(obj++, x + col * 8, y + row * 8, pno);
		}
	}

	return obj;
}

/****************************************************************************
 *	sphit
 ****************************************************************************/

/* XvCgm̃sNZPʂ̓蔻s܂B
 * [in]
 *	(x1,y1),pno1	XvCg1̍Wƃp^[ԍ
 *	(x2,y2),pno2	XvCg2̍Wƃp^[ԍ
 * [out]
 *	߂l		Ȃ1AOȂ0Ԃ܂B
 * [note]
 *	* 蔻́AXvCgp^[̃}XNgčs܂B
 *	  ̃XvCgp^[̃}XN1sNZłdȂĂ΁A
 *	  ƌȂ܂B
 */
int
sphit(int x1, int y1, int pno1, int x2, int y2, int pno2)
{
	extern unsigned char PAT[];

	int i;
	unsigned char *p1, *p2;
	unsigned short mask1, mask2;

	/* ܂ȔB */
	if(x1 + 8 - 1 < x2) return 0; /* XvCg1XvCg2荶 */
	if(y1 + 8 - 1 < y2) return 0; /* XvCg1XvCg2 */
	if(x2 + 8 - 1 < x1) return 0; /* XvCg1XvCg2E */
	if(y2 + 8 - 1 < y1) return 0; /* XvCg1XvCg2艺 */

	/* XvCgp^[AhXvZB */
	p1 = &PAT[(pno1 & 0xff/*Ô*/) * 8 * 3/*bit1,bit0,mask*/];
	p2 = &PAT[(pno2 & 0xff/*Ô*/) * 8 * 3/*bit1,bit0,mask*/];

	/* eCł̃sNZPʂ̓蔻B */
	if(y1 <= y2) {
		i = y2 - y1;
		p1 += i * 3;
	} else {
		i = y1 - y2;
		p2 += i * 3;
	}
	if(x1 <= x2) {
		x2 -= x1;
		      x1 = 0;
	} else {
		x1 -= x2;
		      x2 = 0;
	}
	do {
		/* ӁFXvCgf[^0:s/1: */
		mask1 = (p1[2/*mask*/] ^ 0xff) << x1;
		mask2 = (p2[2/*mask*/] ^ 0xff) << x2;
		if(mask1 & mask2) return 1;
		p1 += 3;
		p2 += 3;
	} while(++i < 8);

	return 0;
}

/****************************************************************************
 *	chhit
 ****************************************************************************/

/* Lm̃sNZPʂ̓蔻s܂B
 * [in]
 *	(x1,y1),chr1	L1̍Wƃp^[ԍ
 *	(x2,y2),chr1	L2̍Wƃp^[ԍ
 * [out]
 *	߂l		Ȃ1AOȂ0Ԃ܂B
 * [note]
 *	* sphit()[note]QƂĂB
 */
int
chhit(int x1, int y1, const CHR* chr1, int x2, int y2, const CHR* chr2)
{
	int col1, row1, pno1, col2, row2, pno2;

	/* SWւ̃ItZbgA_W炵܂B */
	x1 -= chr1->x;
	y1 -= chr1->y;
	x2 -= chr2->x;
	y2 -= chr2->y;

	/* ܂ȔB */
	if(x1 + chr1->w * 8 - 1 < x2) return 0; /* L1L2荶 */
	if(y1 + chr1->h * 8 - 1 < y2) return 0; /* L1L2 */
	if(x2 + chr2->w * 8 - 1 < x1) return 0; /* L1L2E */
	if(y2 + chr2->h * 8 - 1 < y1) return 0; /* L1L2艺 */

	/* L1ƃL2̑SXvCg̑蔻B */
	for(row1 = 0; row1 < chr1->h; row1++) {
		for(col1 = 0; col1 < chr1->w; col1++) {
			pno1 = chr1->pno + 0x10 * row1 + col1;
			for(row2 = 0; row2 < chr2->h; row2++) {
				for(col2 = 0; col2 < chr2->w; col2++) {
					pno2 = chr2->pno + 0x10 * row2 + col2;
					if(sphit(x1 + col1 * 8, y1 + row1 * 8, pno1,
						 x2 + col2 * 8, y2 + row2 * 8, pno2)) return 1;
				}
			}
		}
	}

	return 0;
}

/****************************************************************************
 *	bgcls
 ****************************************************************************/

/* BGLN^0ŃNA܂B
 * [note]
 *	* VvCucls()ĝł́A16x11͈̔͂NAł܂B
 *	  cls()AȈՃR\[pclSpriteBGClear()𗘗pĂ邩łB
 *	  ŁA32x32͈̔͑SĂNA֐pӂ܂B
 */
void
bgcls()
{
	memset(pclSpriteBGGetAdr(0), 0, sizeof(short) * BG_CX * BG_CY);
}

/****************************************************************************
 *	bgput
 ****************************************************************************/

/* BG1LN^u܂B
 * [in]
 *	x, y		]̍ʒu(0`31)
 *	ch		LN^R[hB
 * [note]
 *	* VvCulocate()printstr()/siprintf()ĝł́A
 *	  16x11͈̔͊OɃLN^u܂B(sNZXN[ɑΉłȂ)
 *	  ܂A(15,10)̈ʒuɃLN^uƁALN^XN[Ă܂܂B
 *	  printstr()AȈՃR\[֐pclSpriteBGPutCharacter()𗘗pĂ邩łB
 *	  ŁApclSpriteBGSetCharacter()̊֐pӂ܂B
 */
void
bgput(int x, int y, int code)
{
	pclSpriteBGSetCharacter(0, x & 31, y & 31, code);
}

/****************************************************************************
 *	bgdisp
 ****************************************************************************/

/* ̃XvCg\LABGɕ\܂B
 * [in]
 *	x, y		]̍ʒu(0`31)
 *	chr		L\̂ւ̃|C^
 * [note]
 *	* L\̂̒SItZbg(x,y)͎QƂ܂B
 */
void
bgdisp(int x, int y, const CHR* chr)
{
	int col, row, pno;

	/* L\AeXvCg\܂B */
	for(row = 0; row < chr->h; row++) {
		for(col = 0; col < chr->w; col++) {
			pno = chr->pno + 0x10 * row + col;
			pclSpriteBGSetCharacter(0, (x + col) & 31, (y + row) & 31, pno);
		}
	}

}

/****************************************************************************
 *	bghome
 ****************************************************************************/

/* BGʂ̃XN[ʒuݒ肵܂B
 * [in]
 *	x, y		XN[ʒu
 * [note]
 *	* VvCuɂ́AOtBbNʂ̃XN[ʒuݒ肷
 *	  home()֐͂̂łABGʂ̃XN[ʒuݒ肷֐
 *	  Ȃ̂ŁAOŗpӂ܂B
 */
void
bghome(int x, int y)
{
	pclSpriteBGSetPosition(0, x, y);
}

/****************************************************************************
 *	bghomex
 ****************************************************************************/

/* BGʂ̐XN[ʒu擾܂B
 * [out]
 *	߂l		XN[ʒu
 * [note]
 *	* VvCuɂ́AOtBbNʂ̐XN[ʒu擾
 *	  homex()֐͂̂łABGʂ̐XN[ʒu擾֐
 *	  Ȃ̂ŁAOŗpӂ܂B
 */
int
bghomex()
{
	return pclSpriteBGGetX(0);
}

/****************************************************************************
 *	bghomey
 ****************************************************************************/

/* BGʂ̐XN[ʒu擾܂B
 * [out]
 *	߂l		XN[ʒu
 * [note]
 *	* VvCuɂ́AOtBbNʂ̐XN[ʒu擾
 *	  homey()֐͂̂łABGʂ̐XN[ʒu擾֐
 *	  Ȃ̂ŁAOŗpӂ܂B
 */
int
bghomey()
{
	return pclSpriteBGGetY(0);
}

/****************************************************************************
 *	grcls
 ****************************************************************************/

void
grcls(int color)
{
	unsigned char mask, bit1, bit0;
	unsigned char* p;
	int y;

	switch(color) {
	case  0: bit1 = 0x00; bit0 = 0x00; mask = 0x00; break;
	case  1: bit1 = 0x00; bit0 = 0xff; mask = 0x00; break;
	case  2: bit1 = 0xff; bit0 = 0x00; mask = 0x00; break;
	case  3: bit1 = 0xff; bit0 = 0xff; mask = 0x00; break;
	default: bit1 = 0x00; bit0 = 0x00; mask = 0xff; break;
	}
	p = pclSpriteBGGetFrameAdr(1);
	for(y = 0; y < 256; y++) {
		memset(p, bit1, 256 / 8); p += 256 / 8;
		memset(p, bit0, 256 / 8); p += 256 / 8;
		memset(p, mask, 256 / 8); p += 256 / 8;
	}
}

/****************************************************************************
 *	paint
 ****************************************************************************/

/* * Sat Jul 20 08:18:00 JST 2002 Naoyuki Sawa
 * - L^CX^v̎_łrender_paint()x[XɁAVvCupɈڐA܂B
 *   ڐAɍۂăRg͏CĂ܂̂ŁAꕔAAPIgpz肵RgcĂ܂B
 * - hԂFێϐucv̌^ɒӁI
 *   APIprender_paint()łunsigned charłAVvCułintłB
 *   point()͓lƂ-1Ԃ̂ŁAintŕێĂȂƓ̓hԂł܂B
 */

/* SĂ܂BxłB
 * Q[ł́AhԂvʂ͏ȂƎv̂ŁA
 * ̂܂܂łɖ͂ȂƎv܂B
 */
void
paint(int x0, int y0, int color)
{
/* hԂ_X^bNTCYF
 * ƂAȂ蕡GȓhԂł24xłA
 * Ô߁A]TŁA傫߂ɎĂƂɂ܂B
 * ܂傫ƁAP/ECEł̓X^bNӂ̂ŁAӂB
 */
#define RENDER_PAINT_STACK_SIZE	64

/* r[|[gTCYF
 * ʂɌĂ镔(DISP_X~DISP_Y)ł͂ȂA
 * OtBbNʑŜ̃TCY(256~256)Ƃ܂B
 */
#define VP_LEFT		  0
#define VP_RIGHT	256
#define VP_TOP		  0
#define VP_BOTTOM	256

	short stack[RENDER_PAINT_STACK_SIZE][2]; /* ߖ̂short */
	int i_stack, x, y, x1, x2;
	int c; /* APIłunsigned charłAVvCułintłĨRgQ */

	/* hԂJn_r[|[gOȂA܂B */
	if(x0 < VP_LEFT || VP_RIGHT  - 1 < x0) return;
	if(y0 < VP_TOP  || VP_BOTTOM - 1 < y0) return;

	/* hԂF擾܂B */
	c = point(x0, y0);

	/* hԂJn_ɓhԂFȂA܂B */
	/* if(c == color) return; */
	/* ->悭lÃ`FbN͕svłB
	 *   hԂJn_ɓhԂFȂA
	 *   1. X^bNɍŏ(x0,y0)ςށB
	 *   2. while()[v̒(x0,y0)oB
	 *   3. ɓhĂ̂ŁAcontinueŔ΂B
	 *   4. X^bN͋Ȃ̂ŁAIB
	 *   ƂȂAɏI܂B
	 */

	/* hԂJn_X^bNɐς݂܂B */
	stack[0][0] = x0;
	stack[0][1] = y0;
	i_stack = 1;

	/* hԂ_ȂȂ܂... */
	while(i_stack != 0) {
		/* hԂ_o܂B */
		i_stack--;
		x0 = stack[i_stack][0];
		y0 = stack[i_stack][1];

		/* ɓhĂA΂܂B */
		if(point(x0, y0) == color) continue;

		/* hF̍[T܂B */
		x1 = x0;
		for(;;) {
			x1--;
			if(x1 < VP_LEFT) break; /* r[|[gO */
			if(point(x1, y0) != c) break; /* ʐF */
		}
		x1++; /* s߂Ă̂Ŗ߂ */

		/* hF̉E[T܂B */
		x2 = x0;
		for(;;) {
			x2++;
			if(x2 > VP_RIGHT - 1) break; /* r[|[gO */
			if(point(x2, y0) != c) break; /* ʐF */
		}
		x2--; /* s߂Ă̂Ŗ߂ */

		/* E̊ԂhԂ܂B */
		for(x = x1; x <= x2; x++) {
			pset(x, y0, color);
			/* pceLCDTrans()ĂԂƁAhԂ̗lq1sNZPʂŊώ@ł܂B */
			/* pceLCDTrans() */
		}
		/* pceLCDTrans()ĂԂƁAhԂ̗lq1CPʂŊώ@ł܂B */
		/* pceLCDTrans() */

		/* ̃C̒B */
		if(y0 != VP_TOP) {
			y = y0 - 1;
			x = x1;
			for(;;) {
				/* hF̎n܂T܂B */
				for(;;) {
					if(x > x2) break;
					if(point(x, y) == c) break;
					x++;
				}
				if(x > x2) break; /* Ȃ */

				/* hF̏IT܂B */
				for(;;) {
					if(x > x2) break;
					if(point(x, y) != c) break;
					x++;
				}

				/* hF̏ÏʒuX^bNɐς݂܂B */
				if(i_stack < RENDER_PAINT_STACK_SIZE) {
					stack[i_stack][0] = x - 1; /* s߂Ă̂Ŗ߂ */
					stack[i_stack][1] = y;
					i_stack++;
				}
			}
		}

		/* ̃C̒B */
		if(y0 != VP_BOTTOM - 1) {
			y = y0 + 1;
			x = x1;
			for(;;) {
				/* hF̎n܂T܂B */
				for(;;) {
					if(x > x2) break;
					if(point(x, y) == c) break;
					x++;
				}
				if(x > x2) break; /* Ȃ */

				/* hF̏IT܂B */
				for(;;) {
					if(x > x2) break;
					if(point(x, y) != c) break;
					x++;
				}

				/* hF̏ÏʒuX^bNɐς݂܂B */
				if(i_stack < RENDER_PAINT_STACK_SIZE) {
					stack[i_stack][0] = x - 1; /* s߂Ă̂Ŗ߂ */
					stack[i_stack][1] = y;
					i_stack++;
				}
			}
		}
	}

#undef RENDER_PAINT_STACK_SIZE
#undef VP_LEFT
#undef VP_RIGHT
#undef VP_TOP
#undef VP_BOTTOM
}

/****************************************************************************
 *	symbolf
 ****************************************************************************/

/* OtBbNʂɏt`悵܂B
 * [in]
 *	x, y		̍W(sNZPʁA0`255)
 *	type		\tHg(0`2)
 *	color		F(-1`3)
 *	fmt		
 *	...		p[^
 * [note]
 *	* ̊֐́AWĴ߂ɁAVXepzʗ̈𗘗p܂B
 */
void
symbolf(int x, int y, int type, int color, char* fmt, ...)
{
	va_list ap;

	/* tWJ܂B */
	va_start(ap, fmt);
	pcevsprintf(_def_vbuff, fmt, ap); /* VXepzʂ𗘗p!! */
	va_end(ap);

	/* WJ`悵܂B */
	symbol(x, y, _def_vbuff, type, color);
}

/****************************************************************************
 *	grfont
 ****************************************************************************/

/* OtBbNʂ8~8sNZtHg`܂B
 * [in]
 *	x, y		̍W(LN^PʁA0`31)
 *	code		R[h(0`255)
 *	color		bit3`0: OiF(0:/1:/2:/3:/4`15:)
 *			bit7`4: wiF(0:/1:/2:/3:/4`15:)
 * [note]
 *	* OiFEwiFɓw肵ĂÃsNZc킯ł͂܂B
 *	  Fŕ`悳邾Ȃ̂ŁAɂ̃sNZ͏㏑܂B
 */
void
grfont(int x, int y, int code, int color)
{
	const unsigned char* src;
	unsigned char *dst, mask, t1, t0, tm, b1, b0, bm;
	int line;

	/* ]tHgAhXE]t[obt@AhX擾܂B */
	src = fntadr(code);
	dst = pclSpriteBGGetFrameAdr(1)
	    + (256/*[pixel]*/ / 8/*[bit]*/ * 3/*[plane]*/ * 8/*[line]*/) * (y & 31) + (x & 31);

	/* OiFEwiFݒ肵܂B */
	switch(color & 0x0f) {
	case 0x00: t1 = 0x00; t0 = 0x00; tm = 0x00; break;
	case 0x01: t1 = 0x00; t0 = 0xff; tm = 0x00; break;
	case 0x02: t1 = 0xff; t0 = 0x00; tm = 0x00; break;
	case 0x03: t1 = 0xff; t0 = 0xff; tm = 0x00; break;
	default  : t1 = 0x00; t0 = 0x00; tm = 0xff; break;
	}
	switch(color & 0xf0) {
	case 0x00: b1 = 0x00; b0 = 0x00; bm = 0x00; break;
	case 0x10: b1 = 0x00; b0 = 0xff; bm = 0x00; break;
	case 0x20: b1 = 0xff; b0 = 0x00; bm = 0x00; break;
	case 0x30: b1 = 0xff; b0 = 0xff; bm = 0x00; break;
	default  : b1 = 0x00; b0 = 0x00; bm = 0xff; break;
	}

	for(line = 0; line < 8; line++) {
		mask = *src++; /* fntadr()ł̃tHgf[^ɁAPʂɕёւς */
		dst[256/*[pixe]*/ / 8/*[bit]*/ * 0] = (t1 & mask) | (b1 & ~mask); /* bit1 */ 
		dst[256/*[pixe]*/ / 8/*[bit]*/ * 1] = (t0 & mask) | (b0 & ~mask); /* bit0 */ 
		dst[256/*[pixe]*/ / 8/*[bit]*/ * 2] = (tm & mask) | (bm & ~mask); /* mask */ 
		dst += 256/*[pixe]*/ / 8/*[bit]*/ * 3/*[plane]*/;
	}
}

/****************************************************************************
 *	grputstr
 ****************************************************************************/

/* OtBbNʂ8~8sNZtHgŕ`܂B
 * [in]
 *	x, y		̍W(LN^PʁA0`31)
 *	str		
 *	color		bit3`0: OiF(0:/1:/2:/3:/4`15:)
 *			bit7`4: wiF(0:/1:/2:/3:/4`15:)
 * [note]
 *	* 񒆂SO(\x0e)uƁASI(\x0f)܂ł̊ԁA
 *	  񒆂̔pJ^Ji𔼊pЂ炪ȂƂĕ\܂B
 *	  Ⴆ΁A
 *		str = ""
 *	  ́A
 *		ACEGITVXZ\
 *	  ƕ\܂B
 *	* GۃGfB^ȂASÓuCtrl+PCtrl+Nvœ͂ł܂B
 *	  ܂ASÍuCtrl+PCtrl+Ovœ͂ł܂B
 *	* VtgAEgԂ́Asł͉܂B
 *	  ֐ԂƃVtgAEgԂ͉A͕KVtgCԂn܂܂B
 *	* SO/SỈ߂͓ƎłASOœꃂ[hESIŒʏ탂[hƂ͖̂{̈ӖƓłB
 *	  ȂƂȂAuVtgCœꃂ[h**vuVtgAEgœꃂ[h**v
 *	  ƎvĂ܂ACƃAEg̈Ӗ͋t悤łB
 *	  uVtgAEgœꃂ[h**vuVtgCœꃂ[h**v悤łB
 *	  SIR[h14ASOR[h15Ȃ̂ŁAԂ猾ĂԂ񂻂Ȃ̂ł傤B
 *	  ڂ͖mFȂ̂ŁAvmFłBƎ߂AǂłȂ̂ł(^^;
 */
void
grputstr(int x, int y, const char* str, int color)
{
	int x0, so, c;

	x0 = x; /* sɂ֖̌߂܂ */
	so = 0; /* 0:J^Ji/1:Ђ炪 */

	while((c = *str++) != '\0') {
		/* R[h̏B(\܂) */
		switch(c) {
		case '\n': /* LF(s) */
			x = x0;
			y++;
			continue;
		case '\x0e': /* SO(VtgAEg) */
			so = 1;
			continue;
		case '\x0f': /* SI(VtgC) */
			so = 0;
			continue;
		}

		/* J^JiЂ炪ȕϊB(font.bmpQ) */
		if(so) {
			if('' <= c && c <= '') {
				c -= 0x20;
			} else if('' <= c && c <= '') {
				c += 0x20;
			}
		}

		/* ꕶ\B */
		grfont(x, y, c, color);
		x++;
	}
}

/****************************************************************************
 *	grrintf
 ****************************************************************************/

/* OtBbNʂ8~8sNZtHgŏt`܂B
 * [in]
 *	x, y		̍W(LN^PʁA0`31)
 *	color		bit3`0: OiF(0:/1:/2:/3:/4`15:)
 *			bit7`4: wiF(0:/1:/2:/3:/4`15:)
 *	fmt		
 *	...		p[^
 * [note]
 *	* ̊֐́AWĴ߂ɁAVXepzʗ̈𗘗p܂B
 */
void
grprintf(int x, int y, int color, const char* fmt, ...)
{
	va_list ap;

	/* tWJ܂B */
	va_start(ap, fmt);
	pcevsprintf(_def_vbuff, fmt, ap); /* VXepzʂ𗘗p!! */
	va_end(ap);

	/* WJ`悵܂B */
	grputstr(x, y, _def_vbuff, color);
}

/****************************************************************************
 *	pausedisp
 ****************************************************************************/

static void (*old_LCDTransDirect)(const unsigned char* lcd);

/* ʓ]̒OtbNāAuPAUSEvd˕`܂B
 * VvCu͖Sʓ]ŝŁAd˕`̑ޔE͕svłB
 */
static void
new_LCDTransDirect(const unsigned char* lcd)
{
	static const char msg[] = "PAUSE";
	const unsigned char* src;
	unsigned char* dst;
	int i, j;

	/* ʂ̂قڒɁuPAUSEv\B */
	for(i = 0; i < 5; i++) {
		src = fntadr(msg[i]);
		dst = (unsigned char*)lcd + (2 * 88) * (5 + i) + (2 * 40);
		for(j = 0; j < 8; j++) {
			*dst++ = *src; /* bit1 */
			*dst++ = *src; /* bit0 */
			src++;
		}
	}

	/* {̉ʓ]֗܂B */
	old_LCDTransDirect(lcd);
}

/* |[Y܂START+SELECTŏIƁApceLCDTransDirect()̃tbN܂B
 * ̖h߁AIʒmnhOAmpceLCDTransDirect()̃tbNs܂B
 */
int
pceAppNotify(int type, int param)
{
extern unsigned char _def_vbuff[];

	switch(type) {
	/*{{C:\usr\PIECE\lib\src\defnotify.c*/
	case APPNF_SMSTART:
		return APPNR_ACCEPT;
	case APPNF_SMREQVBUF:
		pceLCDSetBuffer(_def_vbuff);
		return APPNR_ACCEPT;
	/*}}C:\usr\PIECE\lib\src\defnotify.c*/
	case APPNF_EXITREQ:
		pausedisp(0); /* mpceLCDTransDirect()̃tbN */
		turbo(0); /* mturbo[h */
		return APPNR_ACCEPT;
	}
	return APPNR_IGNORE;
}

void
pausedisp(int pause)
{
	thread_lock();
	if(pause) {
		if(old_LCDTransDirect == NULL) {
			old_LCDTransDirect = pceVectorSetKs(KSNO_LCDTransDirect, new_LCDTransDirect);
		}
	} else {
		if(old_LCDTransDirect != NULL) {
			pceVectorSetKs(KSNO_LCDTransDirect, old_LCDTransDirect);
			old_LCDTransDirect = NULL; /* tbNĂȂƂ}[N */
		}
	}
	thread_unlock();
}

/****************************************************************************
 *	rnd_range
 ****************************************************************************/

int
rnd_range(int min_value, int max_plus1)
{
	return rnd(max_plus1 - min_value) + min_value;
}

/*{{2006/03/29_clippce.cRs[܂*/
/****************************************************************************
 *	24MHz/48Mhz[h؂ւ
 ****************************************************************************/

/* * uP/ECE hackingv(http://junkbox.info/piece/)
 *   wP/ECE48MHzœ(1`3/3)x(http://junkbox.info/diary/dy200202.htm)QlɂĒ܂B
 * * SRAM/FLASH̃I[o[NbN͍sĂ܂B
 *   ̖ڕW͂܂Ŋei̎dlŁACPÛ48MHz삳邱ƂłB
 * * 48MHz쒆ɗpłȂAPÍÂƂłB
 *	      pceCPUSetSpeed()			OSC3̔{ݒ肪z肳ĂȂ
 *	      pcePowerEnterStandby()		 8bit^C}1ݒ肵Ă邽
 *	      pceTimerGetPrecisionCount()	q
 *	      pceTimerAdjustPrecisionCount()	q
 *	dv! pceFileCreate/Delete/WriteSec()	q
 *	      pceIRnAPIS			16bit^C}5ݒ肵Ă邽
 *   API𗘗pꍇ́A24MHz[hɖ߂Ă痘pĂB
 * * pcePowerEnterStandby()́AAvP[V疾IɌĂ΂ꍇɉāA
 *   dr쓮EܕԖ쎞ɃVXe玩IɌĂ΂ꍇ܂B
 *   {́A 48MHzւ̐؂ւɁApcePowerEnterStandby()̓tbNĂ̂łA
 *   VXepcePowerEnterStandby()Ăяo̓tbNoRĂȂ̂ŁAł܂łB
 *   dȂ̂ŁA48MHz[hgAvP[VɎ̂悤ȃR[hǉđΏĂB
 *	int pceAppNotify(int type, int param) {
 *		int m;
 *		switch(type) {
 *		case APPNF_SMSTART:	return APPNR_ACCEPT;
 *		case APPNF_SMREQVBUF:	pceLCDSetBuffer(_def_vbuff); return APPNR_ACCEPT;
 *		case APPNF_STANDBY:	m = turbo(0); pcePowerEnterStandby(0); turbo(m); return APPNR_REJECT;
 *		}
 *		return APPNR_IGNORE;
 *	}
 *   ƂApcePowerEnterStandby()ł8bit^C}1pړÍA
 *   X^oCAOSC3U҂̂߂łAقǏdvł͂܂B
 *   AdvƂΏdvȂ̂łA҂Ԃɂ͏[ȃ}[WĂ͂Ȃ̂ŁA
 *   ҂ԂɂȂxł͔͑ȂƎv̂łB
 *   ƂƁÃJ[lł͑҂Ԃ̐ݒ肪sĂȂAɂւ炸ȂĂ̂ŁA
 *   ܂CɂȂĂ̂܂B
 *   Ƃ킯ŁA_ƂẮAAvP[VŏLR[h(pceAppNotify)ɂ΍قSA
 *   ΍􂵂ȂĂ܂ȁHAƂ_ɂȂ܂B
 *   Ȃ݂ɁAȂCLiPCuɏLR[h(pceAppNotify)܂߂Ă܂ȂƂƁA
 *   pceAppNotify()͂ƑړIɗp̂ŁAAvP[VŒ`łȂȂĂ܂͖̂肾ƎvłB
 *   2004/11/05ǋL
 *   pceAppNotify()CuɊ܂߂܂B
 *   AvP[VNotifyKvƂꍇ́Aatnotify()ĂяoĊ֐o^ĂB
 * * 48MHz[hł́AP/ECEJ[l̃EFCg֐pdwait(\usr\PIECE\sysdev\pcekn\critical.c)̃^C~O
 *   ςĂ܂̂SzłA܂̂ƂƂ肠v݂łB
 *   pdwait()̃^C~Ȏ唼́ACPUg̖ߎsԂł͂ȂAGA11(0x1000000`)ւ̃ANZXԂɂČ肳܂B
 *   GA11̃ANZX^C~ÓAŒᑬɐݒ肳Ă܂B(\usr\PIECE\sysdev\pcekn\hard.c 143s)
 *   OoXւ̃ANZXȂ̂ŁA24MHz/48MHz̈Ⴂɂ͉eꂸAGA11̃ANZX͂ǂłłB
 *   GA11̃ANZXԂɊrׂ΁ACPUg̖ߎsԂ͏̂ŁAe͏͂łB
 *   mpdwait()̃^C~O͑ȂĂ܂܂A肬̒ȂĂȂȂƎv܂B
 *   BSzȂ̂́AtbV̏҂[vł̗płB(\usr\PIECE\sysdev\pcekn\fmacc1.c 69s)
 *   pceFileCreate/Delete/WriteSec()ṕA24MHz[hɖ߂ĂSł傤B
 *   (؂łB48MHzłȂg邩܂)
 *   ƌ؂Ă݂܂BP/ECẼtbVSST39VF400Ał́A1ZN^ɗvő厞Ԃ32[~b]łB
 *   \usr\PIECE\sysdev\pcekn\fmacc1.c 63`76śApdwait(5)~ꖜ̌ĂяoȓɏȂƁA^CAEg܂B
 *   ȒP̂߂ɁAmacߌܖ񕪂̑҂ԂƉ肵܂B(ۂ͂Ƃ܂)
 *   mac߈񖈂ɃGA11̓ǂݏoŝŁA(1({[h){7(EFCg))~216NbN܂B
 *   OoXANZXł̂ŁAł̃NbNPʂ́A48MHzł͂Ȃ24MHzłB
 *   1b/24MHz~16NbN~ܖ33~bƂȂA1ZN^ɗv鎞Ԃ𖞂Ă܂B
 *   ۂɂpdwait()̌ĂяoԂmacȊO̖ߎsԂ܂܂̂ŁAƑ̃EFCgĂ͂łB
 *   ȏ̌؂A48MHz[hpceFileCreate/Delete/WriteSec()gĂԂv낤Ǝv܂B
 *   ȂAtbVւ̃[h(\usr\PIECE\sysdev\pcekn\fmacc2.c)́A
 *   ^CAEgȂŏ݊܂ő҂܂̂ŁApdwait()̃^C~Oɂ͊֌W܂B
 *   Ǝv̂łAĂ݂ƁA48MHz[hł͂Ȃ̍mpceFileWriteSct()Ɏs悤łBdv
 *   ꎞIturbo(0)24MHzɖ߂ApceFileWriteCreate/Open/WriteSct/CloseAturbo(1)48MHz𕜌A
 *   Ƃ΁A܂̂Ƃ뎸s͂܂B
 *   ςA48MHz[hł̃tbV݂͂߂ق悤łB
 *   2002/12/10ǋL: 48MHz[hpceFileCreate/WriteSecgƃnOAbvĂR킩܂B
 *   tbVւ݂̏Ȃ̂ł͂ȂALAPIpceCPUSetSpeed()ĂяoĂ̂łB
 *   \usr\PIECE\sysdev\pcekn\file.c̃tbV/ݗp⏕֐̒pceCPUSetSpeed(3)ĂяoA
 *   3MHz[hɂătbV/݂sĂ܂B
 *   āApceCPUSetSpeed()ɂāAUSBCGÃANZXXs[hlɖ߂Ă܂̂AnOAbv̌łB
 *   48MHz[hpceFileCreate/WriteSecgĂAUSBʐM܂ł͌nOAbvȂ悤ł̂ŁA
 *   L̐͂ԂԈႢȂƎv܂B
 *   _ƂāA48MHz[hpceFileCreate/WriteSecgȂƂɂ͕ς肠܂B
 * * 16bit^C}0(1ms^C})̍ĐݒɂāB
 *   16bit^C}ĐݒƈāAꂾvXP[ł͂Ȃ[hlĐݒ肵Ă܂B
 *   ̂悤ɂŔAP/ECEJ[l(BIOS 1.18)ɂ镪ݒ(=4)̔{(=8)̐ݒ肪ȂłB
 *   ~ނ𓾂A[hl{(599911999)ɂĂ܂B
 *   16bit^C}0̃JEgĺAԃx[X24MHz̔{ŕω邱ƂɂȂA
 *   ܂AJEgl̍ől24MHz̔{̒l܂ŃJEgAbv܂B
 *   ̂߁ApceTimerGetPrecisionCount()/pceTimerAdjustPrecisionCount()͐lԂ܂B
 *   KAP/ECEJ[lł́A16bit^C}0̃JEglLAPI͗pĂ܂B
 *   AvP[VłA48MHz쒆16bit^C}0̃JEglLAPI𗘗pȂ悤ӂB
 *   (pceTimerGetPrecisionCount()tbNĖ߂l𔼕ɂA[I24MHz݊̒lԂƂ͉\łA
 *    ͂܂łȂƂɂ܂B)
 *   2004/12/02ǋL: pceTimerGetPrecisionCount()͂̂܂܂ŁApceTimerAdjustPrecisionCount()Turbo[hΉɒu܂B
 *                     ̃W[̉̕ɂApceTimerAdjustPrecisionCount()̎QƂĂB
 * * USBC̃ANZX^C~OݒɂāB
 *   {A48MHz[hɂĂOoXւ̃ANZX^C~O͕ςȂ̂ŁA
 *   USBC̃ANZX^C~OxKv͂Ȃ͂łB
 *   ۂɂ́A݂P/ECEJ[l(BIOS 1.18)ł́AUSBCւ̃ANZX^C~ÓA
 *   USBC̋Klݒ肵ĂACPUł̏Ԃ܂߂ėv^C~O𖞂Ă܂B
 *   (ႦΒʏ24MHz[hłAAUSBC̃|[gǂݏƐANZXł܂B)
 *   48MHz[hłCPȔԂZȂ̂ŁÂ܂܂ł͗v^C~O𖞂A
 *   USBʐMłȂȂĂ܂܂B
 *   ̖h߁AUSBC̃ANZX^C~Ox邱Ƃɂ܂B
 *   ݒĺAS1C33209BCUŉ\ȈԒxݒɂĂ܂B(ݒľ؂͂܂sĂ܂)
 * * 8bit^C}5(LCD])̍Đݒ͍sĂ܂B
 *   ݂P/ECEJ[l(BIOS 1.18)́ALCDCւ̃^C~OȂx߂ɐݒ肵Ă邩łB
 *   P/ECELCDCAS6B0741̃f[^V[g(66y[W)ɂƁASPIڑE2.7VȏŎgꍇA
 *   S6B0741͖17MHz܂łSCLKɂĂ悤łB
 *   P/ECEJ[ĺALCDC]x6MHzɐݒ肵Ă܂B(\usr\PIECE\sysdev\pcekn\lcd.c 701`705s)
 *   {ɂȂĂ12MHzł̂ŁA[e͈͂łB
 *   ɁA]xxƁApceLCDTrans()̃Cǂz蔭鋰܂B(܂ł)
 *   ȏ̗RɂA8bit^C}5(LCD])̍Đݒ͍sȂƂɂ܂B
 * * āA24MHz48MHz[hɐ؂ւ邱ƂɂAǂꂮ炢Ȃ邩AłB
 *   R[hRAMɁAf[^ƃX^bNSRAMɒuꍇz肵܂B
 *   ̓Iɂ́ARAMɒunew_LCDDrawObject()̘AĂяoŁA24MHz48MHz̎sԂr܂B
 *   ̌ʁA24MHzɊrׁA20`30%x̍ƂȂ悤łB
 *   AvP[VŜ̎sԂ20`30%ƂƁAMODĐԂ܂܂ׂ邮炢̎ԂłB
 *   A24MHzBGMȂ̏ꍇƁA48MHzMODɂBGMĐtꍇ̏̏dAƂƂłB
 *   ȂɎg݂͂肻łBB
 */
static int
turbo_CLOCK(int mode)
{
	int old_mode = !bP0_P0D_P07D;		/* Õ[hۑ(0<->1tł邱Ƃɒ!) */

	mode = mode != 0;			/* V[h̎wm01ɂ */
	if(old_mode == mode) return old_mode;	/* ωȂȂ牽Ȃ */

	/* * 48MHz[hɐ؂ւOɁA݂̐ݒ肪P/ECEJ[l(BIOS 1.18)̋KlǂĂ܂B
	 *   P/ECEJ[l̋KlƈقȂĂꍇ́AAT[g܂B
	 *   AJ[l̃o[WAbvɂċKlωꍇ́ACKvłB
	 * * DI`EIDIE()ꍇAG[ʂ͕\܂ASELECTɂI͂ł܂B
	 *   Iɂ́Awʂ̃Zbg{^ĂB
	 *   DIE()OEI𔭍sđΏ邱Ƃ͉\łA킴ƂȂƂɂ܂B
	 *   r[Ȑݒԃj[ɖ߂Ă܂ƔɊ댯Ȃ̂ŁA
	 *   Zbg{^ł̊SZbgSłB
	 *   2004/12/18 Naoyuki Sawa ύX
	 *   荞݋֎~/̐́AĂяoturbo()֐ōs悤ɕύX܂B
	 */
	if(mode) {
		/* 16bit^C}0(1ms^C}) */
		if(!bT16_CTL0_PRUN0) DIE();		bT16_CTL0_PRUN0 = 0;
		if(pT16_CR0B != 5999) DIE();		pT16_CR0B = 11999;
							bT16_CTL0_PRUN0 = 1; /* PRESETȂłvȁH */

		/* 16bit^C}1(TEhĐ) */
		if(!bT16_CTL1_PRUN1) DIE();		bT16_CTL1_PRUN1 = 0;
		if(bCLKCTL_T16_1_P16TS1 != 0) DIE();	bCLKCTL_T16_1_P16TS1 = 1;
							bT16_CTL1_PRUN1 = 1; /* PRESETȂłvȁH */

		/* 16bit^C}4(USB 6MHz) */
		if(!bT16_CTL4_PRUN4) DIE();		bT16_CTL4_PRUN4 = 0;
		if(bCLKCTL_T16_4_P16TS4 != 0) DIE();	bCLKCTL_T16_4_P16TS4 = 1;
							bT16_CTL4_PRUN4 = 1; /* PRESETȂłvȁH */

		/* USBRg[̃ANZX^C~O */
		if(bA8_7_A8WT != 4) DIE();		bA8_7_A8WT = 7; /* 6łꉞ悤ł */
		if(bA8_7_A8DF != 2) DIE();		bA8_7_A8DF = 3; /* 2łꉞ悤ł */

		/* o͌p|[g7(OSC3NbN) */
		if(bP0_P0D_P07D != 1) DIE();		bP0_P0D_P07D = 0;

	} else {
		/* 16bit^C}0(1ms^C}) */
		if(!bT16_CTL0_PRUN0) DIE();		bT16_CTL0_PRUN0 = 0;
		if(pT16_CR0B != 11999) DIE();		pT16_CR0B = 5999;
							bT16_CTL0_PRUN0 = 1; /* PRESETȂłvȁH */

		/* 16bit^C}1(TEhĐ) */
		if(!bT16_CTL1_PRUN1) DIE();		bT16_CTL1_PRUN1 = 0;
		if(bCLKCTL_T16_1_P16TS1 != 1) DIE();	bCLKCTL_T16_1_P16TS1 = 0;
							bT16_CTL1_PRUN1 = 1; /* PRESETȂłvȁH */

		/* 16bit^C}4(USB 6MHz) */
		if(!bT16_CTL4_PRUN4) DIE();		bT16_CTL4_PRUN4 = 0;
		if(bCLKCTL_T16_4_P16TS4 != 1) DIE();	bCLKCTL_T16_4_P16TS4 = 0;
							bT16_CTL4_PRUN4 = 1; /* PRESETȂłvȁH */

		/* USBRg[̃ANZX^C~O */
		if(bA8_7_A8WT != 7) DIE();		bA8_7_A8WT = 4;
		if(bA8_7_A8DF != 3) DIE();		bA8_7_A8DF = 2;

		/* o͌p|[g7(OSC3NbN) */
		if(bP0_P0D_P07D != 0) DIE();		bP0_P0D_P07D = 1;
	}

	return old_mode;
}

static int
turbo_FLASH_WAIT(int mode)
{
	/* ݂̃[h擾܂B */
	int old_mode = bA10_9_A10WT == 1;	/* 1WAITȂ烂[h1A2WAITȂ烂[h0B肦ȂA1or2WAITȊO[h0ƌȂ */

	/* V[hwm01Ƃ܂B */
	mode = mode != 0;

	/* [hωȂȂA܂B */
	if(old_mode == mode) return old_mode;

	/* V[hɉEFCgݒ肵܂B */
	bA10_9_A10WT = mode ? /*[h1*/1 : /*[h0*/2;

	return old_mode;
}

static int
turbo_SRAM_WAIT(int mode)
{
	/* ݂̃[h擾܂B */
	int old_mode = bA6_4_A5WT == 1;		/* 1WAITȂ烂[h1A2WAITȂ烂[h0B肦ȂA1or2WAITȊO[h0ƌȂ */

	/* V[hwm01Ƃ܂B */
	mode = mode != 0;

	/* [hωȂȂA܂B */
	if(old_mode == mode) return old_mode;

	/* V[hɉEFCgݒ肵܂B */
	bA6_4_A5WT = mode ? /*[h1*/1 : /*[h0*/2;

	return old_mode;
}

static int
turbo_FLASH_OUTPUT_DISABLE(int mode)
{
	/* ݂̃[h擾܂B */
	int old_mode = bA10_9_A10DF == 0;	/* 0.5CycleȂ烂[h1A1.5CycleȂ烂[h0B肦ȂA0.5or1.5CycleȊO[h0ƌȂ */

	/* V[hwm01Ƃ܂B */
	mode = mode != 0;

	/* [hωȂȂA܂B */
	if(old_mode == mode) return old_mode;

	/* V[hɉo̓fBZ[uxԂݒ肵܂B */
	bA10_9_A10DF = mode ? /*[h1*/0 : /*[h0*/1;

	return old_mode;
}

static int
turbo_SRAM_OUTPUT_DISABLE(int mode)
{
	/* ݂̃[h擾܂B */
	int old_mode = bA6_4_A5DF == 0;		/* 0.5CycleȂ烂[h1A1.5CycleȂ烂[h0B肦ȂA0.5or1.5CycleȊO[h0ƌȂ */

	/* V[hwm01Ƃ܂B */
	mode = mode != 0;

	/* [hωȂȂA܂B */
	if(old_mode == mode) return old_mode;

	/* V[hɉo̓fBZ[uxԂݒ肵܂B */
	bA6_4_A5DF = mode ? /*[h1*/0 : /*[h0*/1;

	return old_mode;
}

int
turbo(int mode)
{
	int old_mode = 0;

ENTER_CS;
									/* ---cffss */
	old_mode |= turbo_CLOCK               ((mode >> 4) & 1) << 4;	/* ---c---- */
	old_mode |= turbo_FLASH_OUTPUT_DISABLE((mode >> 3) & 1) << 3;	/* ----f--- */
	old_mode |= turbo_FLASH_WAIT          ((mode >> 2) & 1) << 2;	/* -----f-- */
	old_mode |= turbo_SRAM_OUTPUT_DISABLE ((mode >> 1) & 1) << 1;	/* ------s- */
	old_mode |= turbo_SRAM_WAIT           ((mode >> 0) & 1) << 0;	/* -------s */

LEAVE_CS;

	return old_mode;
}
/*}}2006/03/29_clippce.cRs[܂*/
