// * Sun Jul 19 17:54:39 JST 2015 Naoyuki Sawa
// - Win32vWFNgpSQLiteT|[gW[łB
//   test.win/extclip.hQƂĂB
// - _ł́AP/ECEvWFNgł͎gp܂B
//   AP/ECESQLite삷悤ɏoAgp邩m܂B
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
//SQLiteɂsqlite_compile()vprintfł̂ŁA֐̂߂ɒǉB
int sqlite_compile_vprintf(sqlite* db, const char* sqlFormat, const char** pzTail, sqlite_vm** ppVm, char** pzErrmsg, va_list ap) {
	int rc;
	char* zSql;
	zSql = sqlite_vmprintf(sqlFormat, ap);
	rc = sqlite_compile(db, zSql, pzTail, ppVm, pzErrmsg);
	sqlite_freemem(zSql);
	return rc;
}
/*--------------------------------------------------------------------------*/
//SQLiteɂsqlite_compile()printfł̂ŁA֐̂߂ɒǉB
int sqlite_compile_printf(sqlite* db, const char* sqlFormat, const char** pzTail, sqlite_vm** ppVm, char** pzErrmsg, ...) {
	int rc;
	va_list ap;
	va_start(ap, pzErrmsg);
	rc = sqlite_compile_vprintf(db, sqlFormat, pzTail, ppVm, pzErrmsg, ap);
	va_end(ap);
	return rc;
}
/****************************************************************************
 *	
 ****************************************************************************/
//R[hZbgJAŏ̃R[hԂB
//ŏ̃R[hꍇ́ANULLԂB
ST_Recordset_r* Recordset_Open(sqlite* db, const char* sSql, ...) {
	int rc;
	char* sErr;
	va_list ap;
	//R[hZbg̃mۂB
	ST_Recordset_r* rs = calloc(1, sizeof(ST_Recordset_r));
	if(!rs) { DIE(); }
	//z}V쐬B
	va_start(ap, sSql);
	rc = sqlite_compile_vprintf(db, sSql, NULL, &rs->vm, &sErr, ap);
	if(rc) { die("Recordset_Open:%s", sErr); }	//SQLG[
	va_end(ap);
	//ŏ̃R[h擾B
	//ŏ̃R[hL΁AR[hZbgԂB
	//ŏ̃R[hZbg΁AR[hZbg폜NULLԂB
	return Recordset_Next(rs);
}
/*--------------------------------------------------------------------------*/
//R[hZbgB
//Recordset_Next()NULLԂOɒ~ꍇ́A֐ĂяoĉB
void Recordset_Close(ST_Recordset_r* rs) {
	int rc;
	char* sErr;
	//NULL|C^ɑ΂ČĂяoꂽꍇ́AȂB
	if(!rs) { return; }
	//z}V폜B
	rc = sqlite_finalize(rs->vm, &sErr);
	if(rc) { die("Recordset_Close:%s", sErr); }
	//R[hZbg̃JB
	free(rs);
}
/*--------------------------------------------------------------------------*/
//̃R[hԂB
//̃R[h΁AR[hZbg폜ANULLԂB
ST_Recordset_r* Recordset_Next(ST_Recordset_r* rs) {
	int rc;
	char* sErr;
	//̃R[h擾B
	rc = sqlite_step(rs->vm, &rs->nCol, &rs->aVal, &rs->aCol);
	//̃R[hL΁AR[hZbgԂB
	if(rc == SQLITE_ROW) { return rs; }
	//̃R[h΁c
	if(rc == SQLITE_DONE) {
		//R[hZbg폜ANULLԂB
		Recordset_Close(rs);
		return NULL;
	}
	//ȊOȂ΁AG[łB
	//G[bZ[W擾邽߂ɉz}V폜AG[bZ[W\B
	rc = sqlite_finalize(rs->vm, &sErr);
	if(!rc) { DIE(); }	//sqlite_step()G[Ԃ̂ɁAsqlite_finalize()鎖́AN蓾Ȃ͂B
	die("Recordset_Next:%s", sErr);
}
/*--------------------------------------------------------------------------*/
//JԂB
int Recordset_Count(ST_Recordset_r* rs) {
	//JԂB
	return rs->nCol;
}
/*--------------------------------------------------------------------------*/
//JɑΉAJCfNX擾B
int Recordset_ColNI(ST_Recordset_r* rs, const char* sNam) {			//NameIndex
	int iIdx;
	//JvJB
	for(iIdx = 0; iIdx < rs->nCol; iIdx++) {
		//JvJAJCfNXԂB
		if(!strcasecmp(rs->aCol[iIdx], sNam)) { return iIdx; }
	}
	DIE();	//JvJȂAG[~B
}
/*--------------------------------------------------------------------------*/
//ψXgɂ鏑tJɑΉAJCfNX擾B
int Recordset_ColVI(ST_Recordset_r* rs, const char* sFmt, va_list ap) {		//va_listIndex
	int iIdx;
	//J쐬B
	sFmt = strdup_vprintf(sFmt, ap);
	//JCfNX擾B
	iIdx = Recordset_ColNI(rs, sFmt);
	//JJB
	free((char*)sFmt);
	//JCfNXԂB
	return iIdx;
}
/*--------------------------------------------------------------------------*/
//tJɑΉAJCfNX擾B
int Recordset_ColFI(ST_Recordset_r* rs, const char* sNam, ...) {		//FormatIndex
	int iIdx;
	va_list ap;
	//JCfNX擾B
	va_start(ap, sNam);
	iIdx = Recordset_ColVI(rs, sNam, ap);
	va_end(ap);
	//JCfNXԂB
	return iIdx;
}
/*--------------------------------------------------------------------------*/
//JCfNXɑΉAJ擾B
const char* Recordset_ColIN(ST_Recordset_r* rs, int iIdx) {			//IndexName
	//J͈̔͊OȂ΁AG[~B
	if((unsigned)iIdx >= (unsigned)rs->nCol) { DIE(); }
	//JԂB
	return rs->aCol[iIdx];
}
/*--------------------------------------------------------------------------*/
//JCfNXwŁAl擾B
int Recordset_GetIN(ST_Recordset_r* rs, int iIdx) {				//IndexNumeric
	const char* sTxt;
	//eLXg擾BNULL̉\LB
	sTxt = Recordset_GetIT(rs, iIdx);
	//eLXg𐔒lɕϊĕԂB
	//NULL,,lƂĉ߂łȂꍇ́A(0)ԂB
	return sTxt ? atoi(sTxt) : 0;
}
/*--------------------------------------------------------------------------*/
//JwŁAl擾B
int Recordset_GetNN(ST_Recordset_r* rs, const char* sNam) {			//NameNumeric
	const char* sTxt;
	//eLXg擾BNULL̉\LB
	sTxt = Recordset_GetNT(rs, sNam);
	//eLXg𐔒lɕϊĕԂB
	//NULL,,lƂĉ߂łȂꍇ́A(0)ԂB
	return sTxt ? atoi(sTxt) : 0;
}
/*--------------------------------------------------------------------------*/
//ψXgɂ鏑tJwŁAl擾B
int Recordset_GetVN(ST_Recordset_r* rs, const char* sFmt, va_list ap) {		//va_listNumeric
	int iNum;
	//J쐬B
	sFmt = strdup_vprintf(sFmt, ap);
	//l擾B
	iNum = Recordset_GetNN(rs, sFmt);
	//JJB
	free((char*)sFmt);
	//lԂB
	return iNum;
}
/*--------------------------------------------------------------------------*/
//tJwŁAl擾B
int Recordset_GetFN(ST_Recordset_r* rs, const char* sFmt, ...) {		//FormatNumeric
	int iNum;
	va_list ap;
	//l擾B
	va_start(ap, sFmt);
	iNum = Recordset_GetVN(rs, sFmt, ap);
	va_end(ap);
	//lԂB
	return iNum;
}
/*--------------------------------------------------------------------------*/
//JCfNXwŁAeLXg擾B
//NULLԂ\LB
const char* Recordset_GetIT(ST_Recordset_r* rs, int iIdx) {			//IndexText
	//J͈̔͊OȂ΁AG[~B
	if((unsigned)iIdx >= (unsigned)rs->nCol) { DIE(); }
	//eLXgԂBNULL̉\LB
	return rs->aVal[iIdx];
}
/*--------------------------------------------------------------------------*/
//JwŁAeLXg擾B
//NULLԂ\LB
const char* Recordset_GetNT(ST_Recordset_r* rs, const char* sNam) {		//NameText
	//JɑΉAJCfNX擾B
	int iIdx = Recordset_ColNI(rs, sNam);
	//eLXgԂBNULL̉\LB
	return Recordset_GetIT(rs, iIdx);
}
/*--------------------------------------------------------------------------*/
//ψXgɂ鏑tJwŁAeLXg擾B
//NULLԂ\LB
const char* Recordset_GetVT(ST_Recordset_r* rs, const char* sFmt, va_list ap) {	//va_listText
	const char* sTxt;
	//J쐬B
	sFmt = strdup_vprintf(sFmt, ap);
	//eLXg擾B
	sTxt = Recordset_GetNT(rs, sFmt);
	//JJB
	free((char*)sFmt);
	//eLXgԂB
	return sTxt;
}
/*--------------------------------------------------------------------------*/
//tJwŁAeLXg擾B
//NULLԂ\LB
const char* Recordset_GetFT(ST_Recordset_r* rs, const char* sFmt, ...) {	//FormatText
	const char* sTxt;
	va_list ap;
	//eLXg擾B
	va_start(ap, sFmt);
	sTxt = Recordset_GetVT(rs, sFmt, ap);
	va_end(ap);
	//eLXgԂB
	return sTxt;
}
/****************************************************************************
 *	
 ****************************************************************************/
//R[hǉ,,XV邽߂́ÃR[hZbg쐬B
//e[uw肷B
ST_Recordset_w* Recordset_New(sqlite* db, const char* sTbl) {
	//R[hZbg̃mۂB
	ST_Recordset_w* rs = calloc(1, sizeof(ST_Recordset_w));
	if(!rs) { DIE(); }
	//f[^x[XƃJi[B
	rs->db   = db;
	rs->sTbl = strdup(sTbl);
	//nbVe[u쐬B
	rs->ht   = ght_create(0);	//TCYw薳
	ght_set_rehash(rs->ht, 1);	//TCYL
	//R[hZbgԂB
	return rs;
}
/*--------------------------------------------------------------------------*/
//R[h̒ǉ,,XVLZB
//Recordset_Insert(),,Recordset_Update()ĂяoȂꍇ́A֐ĂяoĉB
void Recordset_Cancel(ST_Recordset_w* rs) {
	ght_iterator_t it;
	char *sTxt, *sNam;
	//sqlite_mprintf()ō쐬eLXgJB
	for(sTxt = ght_first(rs->ht, &it, (const void**)&sNam);
	    sTxt;
	    sTxt = ght_next( rs->ht, &it, (const void**)&sNam)) { sqlite_freemem(sTxt); }
	//nbVe[u폜B
	ght_finalize(rs->ht);
	//J폜B
	free(rs->sTbl);
	//R[hZbg̃JB
	free(rs);
}
/*--------------------------------------------------------------------------*/
//VKR[hǉB
void Recordset_Insert(ST_Recordset_w* rs) {
	int rc;
	ght_iterator_t it;
	char *sSql, *sSep, *sTmp;
	char *sTxt, *sNam, *sErr;
	//SQL쐬B
	sSql = strdup_printf("INSERT INTO %s (", rs->sTbl);			//m1
	sSep = "";
	for(sTxt = ght_first(rs->ht, &it, (const void**)&sNam);
	    sTxt;
	    sTxt = ght_next( rs->ht, &it, (const void**)&sNam)) {
		sTmp = strconcat(sSql, sSep, sNam, NULL);			//m2
		free(sSql);							//J1
		sSql = sTmp;
		sSep = ",";
	}
	sTmp = strconcat(sSql, ") VALUES (", NULL);				//m3
	free(sSql);								//J2
	sSql = sTmp;
	sSep = "";
	for(sTxt = ght_first(rs->ht, &it, (const void**)&sNam);
	    sTxt;
	    sTxt = ght_next( rs->ht, &it, (const void**)&sNam)) {
		sTmp = strconcat(sSql, sSep, sTxt, NULL);			//m4
		free(sSql);							//J3
		sSql = sTmp;
		sSep = ",";
	}
	sTmp = strconcat(sSql, ")", NULL);					//m5
	free(sSql);								//J4
	sSql = sTmp;
	//SQLsB
	rc = sqlite_exec(rs->db, sSql, NULL, NULL, &sErr);
	if(rc) { die("Recordset_Insert:%s", sErr); }	//SQLG[
	free(sSql);								//J5
	//R[hZbgJB
	Recordset_Cancel(rs);
}
/*--------------------------------------------------------------------------*/
//R[hXVB
void Recordset_Update(ST_Recordset_w* rs, const char* sWhere/*NULL*/, ...) {
	int rc;
	ght_iterator_t it;
	char *sSql, *sSep, *sTmp;
	char *sTxt, *sNam, *sErr;
	va_list ap;
	//SQL쐬B
	sSql = strdup_printf("UPDATE %s SET ", rs->sTbl);			//m1
	sSep = "";
	for(sTxt = ght_first(rs->ht, &it, (const void**)&sNam);
	    sTxt;
	    sTxt = ght_next( rs->ht, &it, (const void**)&sNam)) {
		sTmp = strconcat(sSql, sSep, sNam, "=", sTxt, NULL);		//m2
		free(sSql);							//J1
		sSql = sTmp;
		sSep = ",";
	}
	if(sWhere) {	//WHERE̎w肪L΁c
		va_start(ap, sWhere);
		sWhere = sqlite_vmprintf(sWhere, ap);				//m3
		va_end(ap);
		sTmp = strconcat(sSql, " WHERE ", sWhere, NULL);		//m4
		sqlite_freemem((char*)sWhere);					//m3
		free(sSql);							//J2
		sSql = sTmp;
	}
	//SQLsB
	rc = sqlite_exec(rs->db, sSql, NULL, NULL, &sErr);
	if(rc) { die("Recordset_Insert:%s", sErr); }	//SQLG[
	free(sSql);								//J4
	//R[hZbgJB
	Recordset_Cancel(rs);
}
/*--------------------------------------------------------------------------*/
//JwŁAlݒ肷B
void Recordset_SetNN(ST_Recordset_w* rs, int iNum, const char* sNam) {					//NameNumeric
	//l̕쐬B
	char* s = sqlite_mprintf("%d", iNum);
	//J̒擾B(I[̃k܂)
	int n = strlen(sNam) + 1/*nul*/;
	//JɑΉ镶ݒ肷Bݒo炱܂ŁB
	if(!ght_insert(rs->ht, s, n, sNam)) { return; }
	//JɑΉ镶񂪊ɗL΁AuB
	s = ght_replace(rs->ht, s, n, sNam);
	//ÂJB
	sqlite_freemem(s);
}
/*--------------------------------------------------------------------------*/
//ψXgɂ鏑tJwŁAlݒ肷B
void Recordset_SetVN(ST_Recordset_w* rs, int iNum, const char* sFmt, va_list ap) {			//va_listNumeric
	//J쐬B
	sFmt = strdup_vprintf(sFmt, ap);
	//lݒ肷B
	Recordset_SetNN(rs, iNum, sFmt);
	//JJB
	free((char*)sFmt);
}
/*--------------------------------------------------------------------------*/
//tJwŁAlݒ肷B
void Recordset_SetFN(ST_Recordset_w* rs, int iNum, const char* sFmt, ...) {				//FormatNumeric
	va_list ap;
	//lݒ肷B
	va_start(ap, sFmt);
	Recordset_SetVN(rs, iNum, sFmt, ap);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
//JwŁAeLXgݒ肷B
void Recordset_SetNT(ST_Recordset_w* rs, const char* sTxt/*NULL*/, const char* sNam) {		//NameText
	//'eLXg',,NULLƂ쐬B
	char* s = sqlite_mprintf("%Q", sTxt);
	//J̒擾B(I[̃k܂)
	int n = strlen(sNam) + 1/*nul*/;
	//JɑΉ镶ݒ肷Bݒo炱܂ŁB
	if(!ght_insert(rs->ht, s, n, sNam)) { return; }
	//JɑΉ镶񂪊ɗL΁AuB
	s = ght_replace(rs->ht, s, n, sNam);
	//ÂJB
	sqlite_freemem(s);
}
/*--------------------------------------------------------------------------*/
//ψXgɂ鏑tJwŁAeLXgݒ肷B
void Recordset_SetVT(ST_Recordset_w* rs, const char* sTxt/*NULL*/, const char* sFmt, va_list ap) {	//va_listText
	//J쐬B
	sFmt = strdup_vprintf(sFmt, ap);
	//eLXgݒ肷B
	Recordset_SetNT(rs, sTxt, sFmt);
	//JJB
	free((char*)sFmt);
}
/*--------------------------------------------------------------------------*/
//tJwŁAeLXgݒ肷B
void Recordset_SetFT(ST_Recordset_w* rs, const char* sTxt/*NULL*/, const char* sFmt, ...) {		//FormatText
	va_list ap;
	//eLXgݒ肷B
	va_start(ap, sFmt);
	Recordset_SetVT(rs, sTxt, sFmt, ap);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
//JwŁAݒ肷B
void Recordset_SetNE(ST_Recordset_w* rs, const char* sExp, const char* sNam) {				//NameExpr
	//̕쐬B
	char* s = sqlite_mprintf("%s", sExp);	//"%q"ł͂ȂɒӂB"%q"ɂƗႦ΁uRecordset_SetNE(rs,"val||'.'","val")v̎uval||''.''vɓWJĂ܂G[ɂȂB
	//J̒擾B(I[̃k܂)
	int n = strlen(sNam) + 1/*nul*/;
	//JɑΉ镶ݒ肷Bݒo炱܂ŁB
	if(!ght_insert(rs->ht, s, n, sNam)) { return; }
	//JɑΉ镶񂪊ɗL΁AuB
	s = ght_replace(rs->ht, s, n, sNam);
	//ÂJB
	sqlite_freemem(s);
}
/*--------------------------------------------------------------------------*/
//ψXgɂ鏑tJwŁAݒ肷B
void Recordset_SetVE(ST_Recordset_w* rs, const char* sExp, const char* sFmt, va_list ap) {		//va_listExpr
	//J쐬B
	sFmt = strdup_vprintf(sFmt, ap);
	//ݒ肷B
	Recordset_SetNE(rs, sExp, sFmt);
	//JJB
	free((char*)sFmt);
}
/*--------------------------------------------------------------------------*/
//tJwŁAݒ肷B
void Recordset_SetFE(ST_Recordset_w* rs, const char* sExp, const char* sFmt, ...) {			//FormatExpr
	va_list ap;
	//ݒ肷B
	va_start(ap, sFmt);
	Recordset_SetVE(rs, sExp, sFmt, ap);
	va_end(ap);
}
