#include "clip.h"

typedef struct _DRIVER {
	M6502 m6502;
	unsigned char mem[0x10000];
} DRIVER;
DRIVER driver;

typedef struct _ROM {
	const char* name;
	unsigned short base;
	unsigned short size;
} ROM;
ROM roms[] = {
	{ "circus.1a", 0x1000, 0x0200 },
	{ "circus.2a", 0x1200, 0x0200 },
	{ "circus.3a", 0x1400, 0x0200 },
	{ "circus.5a", 0x1600, 0x0200 },
	{ "circus.6a", 0x1800, 0x0200 },
	{ "circus.7a", 0x1a00, 0x0200 },
	{ "circus.8a", 0x1c00, 0x0200 },
	{ "circus.9a", 0x1e00, 0x0200 },
	{ "circus.9a", 0xfe00, 0x0200 }, /*RELOAD*/
	{ NULL },
};

unsigned char
m6502_read(M6502* m6502, unsigned short addr)
{
	DRIVER* driver = (DRIVER*)m6502;

	static unsigned char vblank = 0;
	if(addr == 0xc000) {
		vblank ^= 0x80;
printf("%02x\n", vblank);
		return vblank;
	}
	return driver->mem[addr];
}

int
main(int argc, char* argv[])
{
	M6502* m6502 = &driver.m6502;
	unsigned char* mem = driver.mem;

	int retval;
	char buf[1024];
	FILE* fp;
	ROM* rom;

	rom = roms;
	while(rom->name) {
		strcpy(buf, "rom/");
		strcat(buf, rom->name);
		fp = fopen(buf, "rb");
		assert(fp);
		retval = fread(mem + rom->base, 1, rom->size, fp);
		assert(retval == rom->size);
		fclose(fp);
		rom++;
	}

	m6502_reset(m6502);
	m6502->read = m6502_read;
	for(;;) {
		mem[0xc000] ^= 0x80;
		m6502_run(m6502, 705562/60);
	}

	return 0;
}
