#include "app.h"

/****************************************************************************
 *	ԊOʐMT|[g
 ****************************************************************************/

#define CPUCLK		24000000		/* CPUNbN */
#define IRFREQ		   37900		/* ԊOLAg */
#define IRCNT		(CPUCLK / IRFREQ)	/* 16bit^C}5ݒl(ԊOLAp) */
#define USEC(u)		((u) * 24 >> 4)		/* }CNb16bit^C}3JEg(/16ŋ쓮) */

void
ir_init()
{
	/* ԊOW[̓dONɂ܂B
	 * * P34(Vcc)GND̊ԂɂRfT̉eŁAP341ɂĂP34CHixɏオ܂B
	 *   KAo̓|[gI/OǂݍނƁAo͕̐ݒɊւ炸݂̃|[gdx擾ł܂B
	 *   P341ɐݒ肵AP34̓dx{HixɂȂ܂ŁA󃋁[vő҂Ƃɂ܂B
	 * * ꂾł͕s\łB
	 *   fW^IɂHiłAԊOW[ւ̓dxƂĂ͂܂Ⴂ\܂B
	 *   ԊOW[̏o(K52)̓ANeBuLowȂ̂ŁAʏ1o͂Ă܂B
	 *   ܂AɂƁAdĂȂƂ0o͂Ă悤łB
	 *   iԊOW[OFFɂĂƁAK52CɓdĂĂ...Hj
	 *   ŁAԊOW[̓dONɂAo͂1ɂȂ܂ŁA󃋁[vő҂Ƃɂ܂B
	 * ύX
	 * * wUSBdł̋쓮ɁAԊŐ߂ɕiwȂǁjxƁAԊOMĂȂĂA
	 *   ԊOW[̏o͂pɂ0(=ԊOM)ɂȂĂ܂悤łB(^^;䂾`I)
	 *   ȏ󋵂ň҂Ă܂ӖȂ̂ŁAԊOW[̈҂͂߂܂B
	 *   sȎMf[^́AM̂ƂŒeƂɂ܂B
	 *   iȂAdrł̋쓮́AL̂悤ȏǏ͋N܂BUSBd̃mCYȂ̂ł傤Hj
	 */
	bP3_P3D_P34D = 1;
	while(!bP3_P3D_P34D) { /* d҂ */ }
	/* ԊOW[̈҂͍s܂ */

	/* 16bit^C}5LApɐݒ肵܂B
	 * * bP2_CFP2_CFP27=1(P27=NbNo)bT16_CTL5_PTM5=0(NbNo͂Ȃ)ɐݒ肷ƁA
	 *   P27̏o̓xbT16_CTL5_OUTINV5̐ݒɏ]CANeBuxƂȂ܂B
	 *   bT16_CTL5_OUTINV5=1(o͔])Ƃ̂ŁAL̐ݒłHio͂܂B
	 * * Ă΁AbT16_CTL5_PTM501ɐ؂ւ邾ŁALED̓_(37.9KHz)؂ւ܂B
	 *   bT16_CTL5_OUTINV5=1(o͔])ƂŔAbT16_CTL5_PTM5=0P27=Hi(LED)Ƃ邽߂Ȃ̂łB
	 */
	pT16_CTL5 = 0x10;		/* ^C}~(OUTINV) */
	bCLKCTL_T16_5_P16TON5 = 0;	/* vXP[~ */
	bCLKCTL_T16_5_P16TS5 = 0;	/* 1/ */
	bCLKCTL_T16_5_P16TON5 = 1;	/* vXP[N */
	pT16_CR5A = IRCNT / 2 - 1;	/* NbN^C~Oݒ(:OUTINV) */
	pT16_CR5B = IRCNT     - 1;	/* NbNオ^C~Oݒ(:OUTINV) */
	pT16_CTL5 = 0x13;		/* ^C}N(OUTINV|PRESET|PRUN) ܂PTM̓Zbg܂ */
	bP2_CFP2_CFP27 = 1;		/* P27=16bit^C}5NbNo */

	/* 16bit^C}3rbgNbNpɐݒ肵܂B */
	pT16_CTL3 = 0x00;		/* ^C}~ */
	bCLKCTL_T16_3_P16TON3 = 0;	/* vXP[~ */
	bCLKCTL_T16_3_P16TS3 = 3;	/* 1/16(=1.5MHz) */
	bCLKCTL_T16_3_P16TON3 = 1;	/* vXP[N */
	pT16_CR3A = 0xffff;		/* (֌W܂) */
	pT16_CR3B = 0xffff;		/* 0`0xffffŃ[v */
	pT16_CTL3 = 0x03;		/* ^C}N(PRESET|PRUN) */
}

void
ir_free()
{
	/* ԊOW[̓dOFFɂ܂B */
	bP3_P3D_P34D = 0;

	/* 16bit^C}5~܂B */
	pT16_CTL5 = 0x00;		/* ^C}~ */
	bCLKCTL_T16_5_P16TON5 = 0;	/* vXP[~ */
	bP2_CFP2_CFP27 = 0;		/* P27=o̓|[g */
	bP2_P2D_P27D = 1;		/* LED */

	/* 16bit^C}3~܂B */
	pT16_CTL3 = 0x00;		/* ^C}~ */
	bCLKCTL_T16_3_P16TON3 = 0;	/* vXP[~ */
}

/****************************************************************************
 *	eXgvO
 ****************************************************************************/

unsigned char vbuff[DISP_X * DISP_Y];

int ON = 500;
int OFF = 1500;

void send();
void recv();

int
main()
{
	int joy;

	pceLCDDispStop();
	pceLCDSetBuffer(vbuff);
	pceAppSetProcPeriod(10);
	pceLCDDispStart();

	ir_init();

	for(;;) {
		yield();

		joy = pcePadGet();
		if(joy & TRG_SELECT) break;

		if(joy & TRG_A) send();
		if(joy & TRG_B) recv();

		if((joy & TRG_LF) && 100 < ON) ON -= 50;
		if((joy & TRG_RI) && ON < 100000) ON += 50;
		if((joy & TRG_DN) && 100 < OFF) OFF -= 50;
		if((joy & TRG_UP) && OFF < 100000) OFF += 50;

		memset(vbuff, 0, sizeof vbuff);
		pceFontSetPos(0, 0);
		pceFontPrintf("ON =%4d\nOFF=%4d", ON, OFF);
		pceLCDTrans();
	}

	ir_free();

	return 0;
}


void
send()
{
	int n, T0, T1;
	int u_on = USEC(ON);
	int u_off = USEC(OFF);

	memset(vbuff, 0, sizeof vbuff);
	pceFontSetPos(0, 0);
	pceFontPrintf("send");
	pceLCDTrans();

DI;
	n = 0;
	T1 = pT16_TC3;
	while(!(pcePadGetDirect() & PAD_SELECT)) {
		bT16_CTL5_PTM5 = 1;
		T0 = T1; do { T1 = pT16_TC3; } while(((T1 - T0) & 0xffff) < u_on);
		bT16_CTL5_PTM5 = 0;
		T0 = T1; do { T1 = pT16_TC3; } while(((T1 - T0) & 0xffff) < u_off);
		n++;
	}
EI;

	memset(vbuff, 0, sizeof vbuff);
	pceFontSetPos(0, 0);
	pceFontPrintf("%d", n);
	pceLCDTrans();

	yield();
	for(;;) {
		yield();
		if(pcePadGet() & TRG_SELECT) break;
	}
}

void
recv()
{
	int na, nb, T0, T1, dT, prev, cur;
	unsigned a, b;

	memset(vbuff, 0, sizeof vbuff);
	pceFontSetPos(0, 0);
	pceFontPrintf("recv");
	pceLCDTrans();

DI;
	na = 0, nb = 0;
	a = 0, b = 0;
	do {
		T0 = pT16_TC3;
		prev = bK5_K5D_K52D;
	} while(prev && !(pcePadGetDirect() & PAD_SELECT));
	while(!(pcePadGetDirect() & PAD_SELECT)) {
		cur = bK5_K5D_K52D;
		if(prev == cur) continue;
		T1 = pT16_TC3;
		dT = (T1 - T0) & 0xffff;
		T0 = T1;
		if(cur) { /* _ */
			a += dT;
			na++;
		} else {  /* _ */
			b += dT;
			nb++;
		}
		prev = cur;
	}
EI;

	memset(vbuff, 0, sizeof vbuff);
	pceFontSetPos(0, 0);
	pceFontPrintf("%d:%d\n%d/%d", na, nb, a * 16 / 24 / na, b * 16 / 24 / nb);
	pceLCDTrans();

	yield();
	for(;;) {
		yield();
		if(pcePadGet() & TRG_SELECT) break;
	}
}


