/*
 *	token.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	TOKEN
 *****************************************************************************/

typedef struct _TOKEN {
	int refcnt;
	TOKEN_INTERFACE* token_interface;
	//
	int type;			/* ^Cv (TOKEN_TYPE_*) */
	JTCODE_INTERFACE** code;	/* l */
} TOKEN;

IMPLEMENT_TOKEN_INTERFACE(TOKEN, token)

const INTERFACE_MAP token_interface_map[] = {
	{ TOKEN_INTERFACE_ID, offsetof(TOKEN, token_interface), &token_interface },
	{ 0/*I[*/ },
};

TOKEN_INTERFACE**
token_create(int type, JTCODE_INTERFACE** code)
{
	TOKEN* this = calloc(1, sizeof(TOKEN));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, token_interface_map);

	/* ^CvAli[܂B */
	this->type = type;
	safe_assign(this->code, code);

	return &this->token_interface;
}

static void
token_delete(TOKEN* this)
{
	/* l܂B */
	safe_release(this->code);

	free(this);
}

/*****************************************************************************
 *	TOKEN_INTERFACE
 *****************************************************************************/

static int
token_get_type(TOKEN_INTERFACE** intf)
{
	TOKEN* this = CONTAINING_RECORD(intf, TOKEN, token_interface);

	/* ^CvԂ܂B */
	return this->type;
}

static JTCODE_INTERFACE**
token_get_code(TOKEN_INTERFACE** intf)
{
	TOKEN* this = CONTAINING_RECORD(intf, TOKEN, token_interface);

	/* lԂ܂B */
	return safe_addref(this->code); /* Ăяô߂+1 */
}

