/*
 *	string_buffer.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	STRING_BUFFER
 *****************************************************************************/

typedef struct _STRING_BUFFER {
	int refcnt;
	STRING_BUFFER_INTERFACE* string_buffer_interface;
	//
	char* str;	/* obt@ */
} STRING_BUFFER;

IMPLEMENT_STRING_BUFFER_INTERFACE(STRING_BUFFER, string_buffer)

const INTERFACE_MAP string_buffer_interface_map[] = {
	{ STRING_BUFFER_INTERFACE_ID, offsetof(STRING_BUFFER, string_buffer_interface), &string_buffer_interface },
	{ 0/*I[*/ },
};

STRING_BUFFER_INTERFACE**
string_buffer_create()
{
	STRING_BUFFER* this = calloc(1, sizeof(STRING_BUFFER));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, string_buffer_interface_map);

	/* obt@̏Ԃ́A󕶎Ƃ܂B */
	string_buffer_empty(&this->string_buffer_interface);

	return &this->string_buffer_interface;
}

static void
string_buffer_delete(STRING_BUFFER* this)
{
	/* obt@J܂B */
	free(this->str);

	free(this);
}

/*****************************************************************************
 *	STRING_BUFFER_INTERFACE
 *****************************************************************************/

static void
string_buffer_empty(STRING_BUFFER_INTERFACE** intf)
{
	STRING_BUFFER* this = CONTAINING_RECORD(intf, STRING_BUFFER, string_buffer_interface);

	/* obt@̓eA󕶎Ƃ܂B */
	this->str = realloc(this->str, 0 + 1/*nul*/);
	if(!this->str) {
		DIE(); /* s */
	}
	this->str[0] = '\0';
}

static void
string_buffer_append_char(STRING_BUFFER_INTERFACE** intf, int c)
{
	/* 1̕ƂĒǉ܂B */
	char str[2] = { c, '\0' };
	(*intf)->append_string(intf, str);
}

static void
string_buffer_append_string(STRING_BUFFER_INTERFACE** intf, const char* str)
{
	STRING_BUFFER* this = CONTAINING_RECORD(intf, STRING_BUFFER, string_buffer_interface);
	//
	int len1;
	int len2;
	int new_len;

	/* ̍v߂܂B */
	len1 = strlen(this->str);
	len2 = strlen(str);
	new_len = len1 + len2;

	/* obt@g܂B */
	this->str = realloc(this->str, new_len + 1/*nul*/);
	if(!this->str) {
		DIE(); /* s */
	}

	/* ǉ܂B */
	strcat(this->str, str);
}

static char*
string_buffer_lock(STRING_BUFFER_INTERFACE** intf, int min_len)
{
	STRING_BUFFER* this = CONTAINING_RECORD(intf, STRING_BUFFER, string_buffer_interface);
	//
	int len;

	/* ݂̕񒷂Avꂽ傫... */
	len = strlen(this->str);
	if(min_len > len) {

		/* obt@g܂B */
		this->str = realloc(this->str, min_len + 1/*nul*/);
		if(!this->str) {
			DIE(); /* s */
		}
		this->str[min_len] = '\0';
	}

	return this->str;
}

static void
string_buffer_unlock(STRING_BUFFER_INTERFACE** intf, int new_len)
{
	STRING_BUFFER* this = CONTAINING_RECORD(intf, STRING_BUFFER, string_buffer_interface);

	/* 񒷂ĂȂ΁Aۂ̕񒷂߂܂B */
	if(new_len < 0) {
		new_len = strlen(this->str);
	}

	/* obt@TCY܂B(ȍ~̕sv؂l) */
	this->str = realloc(this->str, new_len + 1/*nul*/);
	if(!this->str) {
		DIE(); /* s */
	}
	this->str[new_len] = '\0';
}

