/*
 *	parser.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	PARSER
 *****************************************************************************/

typedef struct _PARSER {
	int refcnt;
	PARSER_INTERFACE* parser_interface;
	//
	LEXER_INTERFACE** lexer;	/* Lexer(͊) */
} PARSER;

IMPLEMENT_PARSER_INTERFACE(PARSER, parser)

const INTERFACE_MAP parser_interface_map[] = {
	{ PARSER_INTERFACE_ID, offsetof(PARSER, parser_interface), &parser_interface },
	{ 0/*I[*/ },
};

PARSER_INTERFACE**
parser_create(LEXER_INTERFACE** lexer)
{
	PARSER* this = calloc(1, sizeof(PARSER));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, parser_interface_map);

	/* Lexeri[܂B */
	safe_assign(this->lexer, lexer);

	return &this->parser_interface;
}

static void
parser_delete(PARSER* this)
{
	/* Lexer܂B */
	safe_release(this->lexer);

	free(this);
}

/*****************************************************************************
 *	PARSER_INTERFACE
 *****************************************************************************/

/* vO̍\vfǂݍރTu[` */
static JTCODE_INTERFACE** parser_program(PARSER* this);			/* vO */
static JTCODE_INTERFACE** parser_stmt(PARSER* this);			/*  */
static JTCODE_INTERFACE** parser_expr(PARSER* this);			/*  */
static JTCODE_INTERFACE** parser_simple_expr(PARSER* this);		/* P */
static JTCODE_INTERFACE** parser_term(PARSER* this);			/*  */
static JTCODE_INTERFACE** parser_factor(PARSER* this);			/* q */

/* L̃Tu[`痘pTu[` */
static JTCODE_INTERFACE** parser_var(PARSER* this);			/* ϐ` */
static JTCODE_INTERFACE** parser_fun(PARSER* this, int method);		/* ֐` */
static JTCODE_INTERFACE** parser_block(PARSER* this);			/* ubN */
static JTCODE_INTERFACE** parser_object(PARSER* this);			/* IuWFNg` */
static JTCODE_INTERFACE** parser_new(PARSER* this);			/* IuWFNg */
static LIST/*<JTCODE_INTERFACE**>*/ * parser_args(PARSER* this);	/* Xg ("argument"́A""ƂӖł) */
static LIST/*<JTSYMBOL_INTERFACE**>*/ * parser_params(PARSER* this);	/* Xg ("parameter"́A""ƂӖł) */

/*---------------------------------------------------------------------------*/

static JTCODE_INTERFACE**
parser_parse(PARSER_INTERFACE** intf)
{
	PARSER* this = CONTAINING_RECORD(intf, PARSER, parser_interface);
	return parser_program(this);
}

static JTCODE_INTERFACE**
parser_program(PARSER* this)
{
	return parser_stmt(this);
}

static JTCODE_INTERFACE**
parser_stmt(PARSER* this)
{
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code1 = NULL;
	JTCODE_INTERFACE** code2 = NULL;
	JTCODE_INTERFACE** code3 = NULL;
	//
	int type;

	/* g[N... */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(token) {

		/* g[Ñ^Cvɂ... */
		type = (*token)->get_type(token);
		switch(type) {
		case TOKEN_TYPE_IF:
			/* ŏ̃g[N'if'Ȃ΁A"if ()  [ else  ]"ǂݍ݂܂B
			 * ŏ̃g[N'if'́AsvȂ̂ŁAȂɂɁAj܂B
			 */

			/* '('ǂݍ݂܂B */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token || ((*token)->get_type(token) != '(')) {
				DIE(); /* 'if'̌'(' */
			}

			/* ǂݍ݂܂B */
			safe_attach(code1, parser_expr(this));
			if(!code1) {
				DIE(); /* 'if' '(' ̌Ɏ */
			}

			/* ')'ǂݍ݂܂B */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token || ((*token)->get_type(token) != ')')) {
				DIE(); /* 'if' '('  ̌')' */
			}

			/* ^̂ƂɎs镶ǂݍ݂܂B */
			safe_attach(code2, parser_stmt(this));
			if(!code2) {
				DIE(); /* 'if' '('  ')' ̌ɕ */
			}

			/* ̃g[N'else'Ȃ... */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(token) {
				if((*token)->get_type(token) == TOKEN_TYPE_ELSE) {
					/* ÛƂɎs镶ǂݍ݂܂B */
					safe_attach(code3, parser_stmt(this));
					if(!code3) {
						DIE(); /* 'if' '('  ')' 'else' ̌ɕ */
					}
				} else {
					/* 'else'ȊOȂ΁Ag[N߂܂B */
					(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */
				}
			}

			/* " <- if (  )  [ else  ]" Ƃ܂B */
			safe_attach(code1, jtif_create(code1, code2, code3));

			break;

		case TOKEN_TYPE_WHILE:
			/* ŏ̃g[N'while'Ȃ΁A"while () "ǂݍ݂܂B
			 * ŏ̃g[N'while'́AsvȂ̂ŁAȂɂɁAj܂B
			 */

			/* '('ǂݍ݂܂B */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token || ((*token)->get_type(token) != '(')) {
				DIE(); /* 'while'̌'(' */
			}

			/* ǂݍ݂܂B */
			safe_attach(code1, parser_expr(this));
			if(!code1) {
				DIE(); /* 'while' '(' ̌Ɏ */
			}

			/* ')'ǂݍ݂܂B */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token || ((*token)->get_type(token) != ')')) {
				DIE(); /* 'while' '('  ̌')' */
			}

			/* ^̊ԁAs镶ǂݍ݂܂B */
			safe_attach(code2, parser_stmt(this));
			if(!code2) {
				DIE(); /* 'while' '('  ')' ̌ɕ */
			}

			/* " <- while (  ) " Ƃ܂B */
			safe_attach(code1, jtwhile_create(code1, code2));

			break;

		case TOKEN_TYPE_FUN:
			/* ŏ̃g[N'fun'Ȃ΁A"fun V{ ( V{, ... ) ubN"ǂݍ݂܂B */

			/* A'fun'߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

			/* ֐`ǂݍ݂܂B */
			safe_attach(code1, parser_fun(this, 0/*ʏ̊֐*/));

			break;

		case '{':
			/* ŏ̃g[N'{'Ȃ΁A"{  ... }"ǂݍ݂܂B */

			/* A'{'߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

			/* ubNǂݍ݂܂B */
			safe_attach(code1, parser_block(this));

			break;

		default:
			/* ŏ̃g[NLȊOȂ΁Aǂݍ݂܂B */

			/* ŏ̃g[ŃÄꕔȂ̂ŁA܂A߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

			/* " <- " Ƃ܂B */
			safe_attach(code1, parser_expr(this));

			/* ЂƂ̎琬镶́A';'ŏI[Ă邱ƂmFAǂݔ΂܂B */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token || ((*token)->get_type(token) != ';')) {
				DIE(); /* \Ȃt@CI[A܂́A';' */
			}

			break;
		}
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(code2);
	safe_release(code3);

	return code1;
}

static JTCODE_INTERFACE**
parser_expr(PARSER* this)
{
	int type;
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code1 = NULL;
	JTCODE_INTERFACE** code2 = NULL;

	/* P... */
	safe_attach(code1, parser_simple_expr(this));
	if(code1) {
		for(;;) {
			/* ̃g[Nǂݍ݂܂B */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token) {
				DIE(); /* \Ȃt@CI[ */
			}

			/* ̃g[N̉ZqȂ... */
			type = (*token)->get_type(token);
			if((type == '<') ||
			   (type == '>') ||
			   (type == TOKEN_TYPE_EQ) ||
			   (type == TOKEN_TYPE_NE) ||
			   (type == TOKEN_TYPE_LE) ||
			   (type == TOKEN_TYPE_GE)) {

				/* ̒Pǂݍ݂܂B */
				safe_attach(code2, parser_simple_expr(this));
				if(!code2) {
					DIE(); /* P */
				}

				/* " <- P Zq P" Ƃ܂B */
				safe_attach(code1, jtbinexpr_create(type, code1, code2));

			/* ̃g[N̉ZqłȂ... */
			} else {

				/* ̃g[N߂Ĕ܂B */
				(*this->lexer)->unget_token(this->lexer, token);
				break;
			}
		}
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(code2);

	return code1;
}

static JTCODE_INTERFACE**
parser_simple_expr(PARSER* this)
{
	int type;
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code1 = NULL;
	JTCODE_INTERFACE** code2 = NULL;

	/* ... */
	safe_attach(code1, parser_term(this));
	if(code1) {
		for(;;) {
			/* ̃g[Nǂݍ݂܂B */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token) {
				DIE(); /* \Ȃt@CI[ */
			}

			/* ̃g[N̉ZqȂ... */
			type = (*token)->get_type(token);
			if((type == '+') ||
			   (type == '-') ||
			   (type == TOKEN_TYPE_OR)) {

				/* ̍ǂݍ݂܂B */
				safe_attach(code2, parser_term(this));
				if(!code2) {
					DIE(); /*  */
				}

				/* " <-  Zq " Ƃ܂B */
				safe_attach(code1, jtbinexpr_create(type, code1, code2));

			/* ̃g[N̉ZqłȂ... */
			} else {

				/* ̃g[N߂Ĕ܂B */
				(*this->lexer)->unget_token(this->lexer, token);
				break;
			}
		}
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(code2);

	return code1;
}

static JTCODE_INTERFACE**
parser_term(PARSER* this)
{
	int type;
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code1 = NULL;
	JTCODE_INTERFACE** code2 = NULL;

	/* q... */
	safe_attach(code1, parser_factor(this));
	if(code1) {
		for(;;) {
			/* ̃g[Nǂݍ݂܂B */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token) {
				DIE(); /* \Ȃt@CI[ */
			}

			/* ̃g[N̉ZqȂ... */
			type = (*token)->get_type(token);
			if((type == '*') ||
			   (type == '/') ||
			   (type == TOKEN_TYPE_AND)) {

				/* ̈qǂݍ݂܂B */
				safe_attach(code2, parser_factor(this));
				if(!code2) {
					DIE(); /* q */
				}

				/* " <- q Zq q" Ƃ܂B */
				safe_attach(code1, jtbinexpr_create(type, code1, code2));

			/* ̃g[N̉ZqłȂ... */
			} else {

				/* ̃g[N߂Ĕ܂B */
				(*this->lexer)->unget_token(this->lexer, token);
				break;
			}
		}
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(code2);

	return code1;
}

static JTCODE_INTERFACE**
parser_factor(PARSER* this)
{
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code1 = NULL;
	JTCODE_INTERFACE** code2 = NULL;
	JTSYMBOL_INTERFACE** symbol = NULL;
	//
	int type;
	LIST/*<JTCODE_INTERFACE**>*/ * args_list;

	/* g[N... */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(token) {

		/* ^CvAl擾܂B */
		type = (*token)->get_type(token);
		safe_attach(code1, (*token)->get_code(token));

		/* g[Ñ^Cvɂ... */
		switch(type) {
		case TOKEN_TYPE_INT:
			/** no job **/
			goto L_EXIT;

		case TOKEN_TYPE_STRING:
			/** no job **/
			goto L_EXIT;

		case TOKEN_TYPE_SYMBOL:
			safe_assign_interface(symbol, code1, JTSYMBOL_INTERFACE);
			if(!symbol) {
				DIE(); /* L蓾Ȃ */
			}
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(token) {
				type = (*token)->get_type(token);
				switch(type) {
				case '=':
					/* V{ '='  */
					safe_attach(code2, parser_expr(this));
					if(!code2) {
						DIE(); /* V{ '=' ̌Ɏ */
					}
					safe_attach(code1, jtbinexpr_create(type, code1, code2));
					break;

				case '(':
					/* V{ '(' Xg ')' */

					/* A'('߂܂B */
					(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

					/* Xgǂݍ݂܂B */
					args_list = parser_args(this);

					/* ֐Ăяo쐬܂B */
					safe_attach(code1, jtfuncall_create(symbol, args_list));

					/* Xg폜܂B */
					list_delete(args_list);

					break;

				default:
					/* V{ */
					(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */
					break;
				}
			}
			goto L_EXIT;

		case TOKEN_TYPE_TRUE:
			safe_attach(code1, jtbool_create(1));
			goto L_EXIT;

		case TOKEN_TYPE_FALSE:
			safe_attach(code1, jtbool_create(0));
			goto L_EXIT;

		case TOKEN_TYPE_VAR:
			/* ŏ̃g[N'var'Ȃ΁A"var V{"A܂́A"var V{ = "ǂݍ݂܂B */

			/* A'var'߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

			/* ϐ`ǂݍ݂܂B */
			safe_attach(code1, parser_var(this));

			goto L_EXIT;

		case TOKEN_TYPE_OBJECT:
			/* ŏ̃g[N'object'Ȃ΁A"object { Xbg }"ǂݍ݂܂B */

			/* A'object'߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

			/* IuWFNg`ǂݍ݂܂B */
			safe_attach(code1, parser_object(this));

			goto L_EXIT;

		case TOKEN_TYPE_NEW:
			/* ŏ̃g[N"new"Ȃ΁A"new V{"A܂́A"new V{ { ubN }"ǂݍ݂܂B */

			/* A'new'߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

			/* IuWFNgǂݍ݂܂B */
			safe_attach(code1, parser_new(this));

			goto L_EXIT;

		case '-':
		case '!':
			safe_attach(code1, parser_factor(this));
			if(!code1) {
				DIE(); /* '-'A'!'̌Ɉq */
			}
			safe_attach(code1, jtunexpr_create(type, code1));
			goto L_EXIT;

		case '(':
			safe_attach(code1, parser_expr(this));
			if(!code1) {
				DIE(); /* '('̌Ɏ */
			}
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			type = (*token)->get_type(token);
			if(type != ')') {
				DIE(); /* '('  ̌')' */
			}
			goto L_EXIT;

		default:
			DIE(); /* sȃg[N */
		}
L_EXIT:
		/*{{bZ[W̏*/
		for(;;) {

			/* q̌'.'L... */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token) {
				break;
			}
			if((*token)->get_type(token) != '.') {
				(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */
				break;
			}

			/* q '.' V{ */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token || ((*token)->get_type(token) != TOKEN_TYPE_SYMBOL)) {
				DIE(); /* q '.' ̌ɃV{ */
			}
			safe_attach(code2, (*token)->get_code(token));
			safe_assign_interface(symbol, code2, JTSYMBOL_INTERFACE);
			if(!symbol) {
				DIE(); /* L蓾Ȃ */
			}

			/* q '.' V{ ̌ɁA'('A܂́A'='L... */
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(token && ((*token)->get_type(token) == '(')) {
				/* "q <- q.V{(Xg)" Ƃ܂B */
				(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */
				args_list = parser_args(this);
				safe_attach(code1, jtdotcall_create(code1, symbol, args_list));
				list_delete(args_list);
			} else if(token && ((*token)->get_type(token) == '=')) {
				/* "q <- q.V{ = " Ƃ܂B */
				safe_attach(code2, parser_expr(this));
				if(!code2) {
					DIE(); /* q '.' V{ '=' ̌Ɏ */
				}
				safe_attach(code1, jtdotassign_create(code1, symbol, code2));
			} else {
				/* "q <- q.V{" Ƃ܂B */
				if(token) {
					(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */
				}
				safe_attach(code1, jtdotexpr_create(code1, symbol));
			}
		}
		/*}}bZ[W̏*/
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(code2);
	safe_release(symbol);

	return code1;
}

static JTCODE_INTERFACE**
parser_var(PARSER* this)
{
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code = NULL;
	JTSYMBOL_INTERFACE** symbol = NULL;

	/* ŏ̃g[N'var'ł邱ƂmFAǂݔ΂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != TOKEN_TYPE_VAR)) {
		DIE(); /* \Ȃt@CI[A܂́A'var' */
	}

	/* ϐ\V{ǂݍ݂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != TOKEN_TYPE_SYMBOL)) {
		DIE(); /* 'var'̌ɃV{ */
	}
	safe_attach(code, (*token)->get_code(token));
	safe_assign_interface(symbol, code, JTSYMBOL_INTERFACE);
	if(!symbol) {
		DIE(); /* L蓾Ȃ */
	}

	/* ϐ̏lǂݍ݂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(token && ((*token)->get_type(token) == '=')) {
		/* 'var' V{ ̌'='L΁Aϐ̏l\ǂݍ݂܂B */
		safe_attach(code, parser_expr(this));
		if(!code) {
			DIE(); /* V{ '=' ̌Ɏ */
		}
	} else {
		/* 'var' V{ ̌'='΁AÖق̏l^܂B
		 * - Öق̏lƂāAfalsep邱Ƃɂ܂B
		 *   ɗR͂Ȃ̂ŁA0""ɕύXĂ\܂B
		 */
		safe_attach(code, jtbool_create(0));
		(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */
	}

	/* ϐ`쐬܂B */
	safe_attach(code, jtvar_create(symbol, code));

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(symbol);

	return code;
}

static JTCODE_INTERFACE**
parser_fun(PARSER* this, int method)
{
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code = NULL;
	JTSYMBOL_INTERFACE** symbol = NULL;
	//
	LIST/*<JTSYMBOL_INTERFACE**>*/ * params_list;

	/* ŏ̃g[N'fun'ł邱ƂmFAǂݔ΂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != TOKEN_TYPE_FUN)) {
		DIE(); /* \Ȃt@CI[A܂́A'fun' */
	}

	/* ֐\V{ǂݍ݂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != TOKEN_TYPE_SYMBOL)) {
		DIE(); /* 'fun'̌ɃV{ */
	}
	safe_attach(code, (*token)->get_code(token));
	safe_assign_interface(symbol, code, JTSYMBOL_INTERFACE);
	if(!symbol) {
		DIE(); /* L蓾Ȃ */
	}

	/* Xgǂݍ݂܂B */
	params_list = parser_params(this);

	/* ubNǂݍ݂܂B */
	safe_attach(code, parser_block(this));

	/* ֐`쐬܂B */
	safe_attach(code, jtfun_create(symbol, params_list, code, method));

	/* Xg폜܂B */
	list_delete(params_list);

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(symbol);

	return code;
}

static JTCODE_INTERFACE**
parser_block(PARSER* this)
{
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code = NULL;
	//
	LIST/*<JTCODE_INTERFACE**>*/ * stmt_list;

	/* ŏ̃g[N'{'ł邱ƂmFAǂݔ΂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != '{')) {
		DIE(); /* \Ȃt@CI[A܂́A'{' */
	}

	/* ̕Xg쐬܂B */
	stmt_list = list_create(&jtcode_list_info);

	/* ubNI܂... */
	for(;;) {
		/* ̃g[N'}'Ȃ΁A'}'ǂݔ΂AubNI܂B */
		safe_attach(token, (*this->lexer)->get_token(this->lexer));
		if(!token) {
			DIE(); /* \Ȃt@CI[ */
		}
		if((*token)->get_type(token) == '}') {
			break;
		}
		(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

		/* ǂݍ݁AXgɒǉ܂B */
		safe_attach(code, parser_stmt(this));
		if(!code) {
			DIE(); /* \Ȃt@CI[A܂́A */
		}
		list_add(stmt_list, code);
	}

	/* ubN쐬܂B */
	safe_attach(code, jtblock_create(stmt_list));

	/* Xg폜܂B */
	list_delete(stmt_list);

	/* svɂȂC^[tFCX܂B */
	safe_release(token);

	return code;
}

static JTCODE_INTERFACE**
parser_object(PARSER* this)
{
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code = NULL;
	JTVAR_INTERFACE** field = NULL;
	JTFUN_INTERFACE** method = NULL;
	JTSYMBOL_INTERFACE** name = NULL;
	//
	int type;
	MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * slots_table;

	/* ŏ̃g[N'object'ł邱ƂmFAǂݔ΂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != TOKEN_TYPE_OBJECT)) {
		DIE(); /* \Ȃt@CI[A܂́A'object' */
	}

	/* ̃g[N'{'ł邱ƂmFAǂݔ΂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != '{')) {
		DIE(); /* \Ȃt@CI[A܂́A'{' */
	}

	/* ̃Xbge[u쐬܂B */
	slots_table = map_create(&jtsymbol_to_jtcode_map_info);

	/* XbgтI܂... */
	for(;;) {
		/* ̃g[Nǂݍ݁A'}'Ȃ΁AXbgтI܂B */
		safe_attach(token, (*this->lexer)->get_token(this->lexer));
		if(!token) {
			DIE(); /* \Ȃt@CI[ */
		}
		type = (*token)->get_type(token);
		if(type == '}') {
			break; /* ubNI */
		}

		/* A'var'A܂́A'fun'߂܂B */
		(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

		/* XbgAǂݍ݂܂B */
		switch(type) {
		case TOKEN_TYPE_VAR:
			/* tB[hϐ`"var V{ [ =  ] ;"ǂݍ݂܂B */
			safe_attach(code, parser_var(this));
			safe_attach(token, (*this->lexer)->get_token(this->lexer));
			if(!token || ((*token)->get_type(token) != ';')) {
				DIE(); /* \Ȃt@CI[A܂́A';' */
			}

			/* tB[hϐXbge[uɓo^邽߂́AO擾܂B */
			safe_assign_interface(field, code, JTVAR_INTERFACE);
			if(!field) {
				DIE(); /* L蓾Ȃ */
			}
			safe_attach(name, (*field)->get_name(field));

			break;

		case TOKEN_TYPE_FUN:
			/* \bh`"fun V{(...) { ... }"ǂݍ݂܂B */
			safe_attach(code, parser_fun(this, 1/*\bh*/));
			/* \bȟɂ́A';'͕svłB */

			/* \bhXbge[uɓo^邽߂́AO擾܂B */
			safe_assign_interface(method, code, JTFUN_INTERFACE);
			if(!method) {
				DIE(); /* L蓾Ȃ */
			}
			safe_attach(name, (*method)->get_name(method));

			break;

		default:
			DIE(); /* sȃg[N */
		}

		/* XbgAXbge[uɓo^܂B */
		if(map_contains(slots_table, name)) {
			DIE(); /* d` */
		}
		map_put(slots_table, name, code);
	}

	/* IuWFNg쐬܂B */
	safe_attach(code, jtobject_create(slots_table));

	/* Xbge[u폜܂B */
	map_delete(slots_table);

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(field);
	safe_release(method);
	safe_release(name);

	return code;
}

static JTCODE_INTERFACE**
parser_new(PARSER* this)
{
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code = NULL;
	JTCODE_INTERFACE** body = NULL;
	JTSYMBOL_INTERFACE** symbol = NULL;

	/* ŏ̃g[N'new'ł邱ƂmFAǂݔ΂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != TOKEN_TYPE_NEW)) {
		DIE(); /* \Ȃt@CI[A܂́A'new' */
	}

	/* ̃IuWFNg\V{ǂݍ݂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != TOKEN_TYPE_SYMBOL)) {
		DIE(); /* 'new'̌ɃV{ */
	}
	safe_attach(code, (*token)->get_code(token));
	safe_assign_interface(symbol, code, JTSYMBOL_INTERFACE);
	if(!symbol) {
		DIE(); /* L蓾Ȃ */
	}

	/* 'new' V{ ̌ '{' L΁AubNǂݍ݂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(token) {
		if((*token)->get_type(token) == '{') {
			/* A'{'߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */
			/* ubNǂݍ݂܂B */
			safe_attach(body, parser_block(this));
		} else {
			/* '{'ȊOȂ΁Ag[N߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */
		}
	}

	/* IuWFNg쐬܂B */
	safe_attach(code, jtnew_create(symbol, body/*ubNNULL*/));

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(body);
	safe_release(symbol);

	return code;
}

static LIST/*<JTCODE_INTERFACE**>*/ *
parser_args(PARSER* this)
{
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code = NULL;
	//
	int i;
	int type;
	LIST/*<JTCODE_INTERFACE**>*/ * args_list;

	/* ŏ̃g[N'('ł邱ƂmFAǂݔ΂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != '(')) {
		DIE(); /* \Ȃt@CI[A܂́A'(' */
	}

	/* ̎Xg쐬܂B */
	args_list = list_create(&jtcode_list_info);

	/* XgI܂... */
	for(i = 0; /** no job **/; i++) {
		safe_attach(token, (*this->lexer)->get_token(this->lexer));
		if(!token) {
			DIE(); /* \Ȃt@CI[ */
		}
		type = (*token)->get_type(token);

		/* '('̒ɂ́A')'邩A܂́A܂B */
		if(!i) {
			if(type == ')') {
				/* ')'ǂݔ΂AXgI܂B */
				break;
			}
			/* ')'łȂ΁ÄꕔȂ̂ŁA߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

		/* '('  ̌́A')'ŎXgI邩A܂́A','Ōp܂B */
		} else { /* '('  ̌ */
			if(type == ')') {
				/* ')'ǂݔ΂AXgI܂B */
				break;
			} else if(type == ',') {
				/* ','ǂݔ΂AXgp܂B */
				/** no job **/
			} else {
				DIE(); /* ̌ɁA')'A܂́A',' */
			}
		}

		/* ǂݍ݁AXgɒǉ܂B */
		safe_attach(code, parser_expr(this));
		if(!code) {
			DIE(); /* \Ȃt@CI[A܂́A */
		}
		list_add(args_list, code);
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(code);

	return args_list;
}

static LIST/*<JTSYMBOL_INTERFACE**>*/ *
parser_params(PARSER* this)
{
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code = NULL;
	JTSYMBOL_INTERFACE** symbol = NULL;
	//
	int i;
	int type;
	LIST/*<JTSYMBOL_INTERFACE**>*/ * params_list;

	/* ŏ̃g[N'('ł邱ƂmFAǂݔ΂܂B */
	safe_attach(token, (*this->lexer)->get_token(this->lexer));
	if(!token || ((*token)->get_type(token) != '(')) {
		DIE(); /* \Ȃt@CI[A܂́A'(' */
	}

	/* ̉Xg쐬܂B */
	params_list = list_create(&jtsymbol_list_info);

	/* XgI܂... */
	for(i = 0; /** no job **/; i++) {
		safe_attach(token, (*this->lexer)->get_token(this->lexer));
		if(!token) {
			DIE(); /* \Ȃt@CI[ */
		}
		type = (*token)->get_type(token);

		/* '('̒ɂ́A')'邩A܂́AV{܂B */
		if(!i) {
			if(type == ')') {
				/* ')'ǂݔ΂AXgI܂B */
				break;
			}
			/* ')'łȂ΁AV{̈ꕔȂ̂ŁA߂܂B */
			(*this->lexer)->unget_token(this->lexer, token); /* YȂ!! */

		/* '(' V{ ̌́A')'ŉXgI邩A܂́A','Ōp܂B */
		} else { /* '(' V{ ̌ */
			if(type == ')') {
				/* ')'ǂݔ΂AXgI܂B */
				break;
			} else if(type == ',') {
				/* ','ǂݔ΂AXgp܂B */
				/** no job **/
			} else {
				DIE(); /* V{̌ɁA')'A܂́A',' */
			}
		}

		/* V{ǂݍ݁AXgɒǉ܂B */
		safe_attach(token, (*this->lexer)->get_token(this->lexer));
		if(!token || ((*token)->get_type(token) != TOKEN_TYPE_SYMBOL)) {
			DIE(); /* \Ȃt@CI[A܂́AV{ */
		}
		safe_attach(code, (*token)->get_code(token));
		safe_assign_interface(symbol, code, JTSYMBOL_INTERFACE);
		if(!symbol) {
			DIE(); /* L蓾Ȃ */
		}
		list_add(params_list, symbol);
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(token);
	safe_release(code);
	safe_release(symbol);

	return params_list;
}

