/*
 *	jtvar.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTVAR
 *****************************************************************************/

typedef struct _JTVAR {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	JTVAR_INTERFACE* jtvar_interface;
	//
	JTSYMBOL_INTERFACE** name;	/* ϐ\V{ */
	JTCODE_INTERFACE** code;	/* ϐ̏l */
} JTVAR;

IMPLEMENT_JTCODE_INTERFACE(JTVAR, jtvar)
IMPLEMENT_JTVAR_INTERFACE(JTVAR, jtvar)

const INTERFACE_MAP jtvar_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTVAR, jtcode_interface), &jtcode_interface },
	{ JTVAR_INTERFACE_ID, offsetof(JTVAR, jtvar_interface), &jtvar_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtvar_create(JTSYMBOL_INTERFACE** name, JTCODE_INTERFACE** code)
{
	JTVAR* this = calloc(1, sizeof(JTVAR));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtvar_interface_map);

	/* ϐ\V{i[܂B */
	safe_assign(this->name, name);

	/* ϐ̏li[܂B */
	safe_assign(this->code, code);

	return &this->jtcode_interface;
}

static void
jtvar_delete(JTVAR* this)
{
	/* ϐ\V{܂B */
	safe_release(this->name);

	/* ϐ̏l܂B */
	safe_release(this->code);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTVAR* this = CONTAINING_RECORD(intf, JTVAR, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;

	/* ϐ̏l܂B */
	safe_attach(code, (*this->code)->run(this->code));

	/* ϐ`܂B */
	joytoy_def_symbol_value(this->name, code);

	return code;
}

/*****************************************************************************
 *	JTVAR_INTERFACE
 *****************************************************************************/

static JTSYMBOL_INTERFACE**
jtvar_get_name(JTVAR_INTERFACE** intf)
{
	JTVAR* this = CONTAINING_RECORD(intf, JTVAR, jtvar_interface);

	/* ϐ\V{Ԃ܂B */
	return safe_addref(this->name); /* Ăяô߂+1 */
}

static JTCODE_INTERFACE**
jtvar_get_code(JTVAR_INTERFACE** intf)
{
	JTVAR* this = CONTAINING_RECORD(intf, JTVAR, jtvar_interface);

	/* ϐ̏lԂ܂B */
	return safe_addref(this->code); /* Ăяô߂+1 */
}
