/*
 *	jtstring.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTSTRING
 *****************************************************************************/

typedef struct _JTSTRING {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	JTSTRING_INTERFACE* jtstring_interface;
	ARITHMETIC_INTERFACE* arithmetic_interface;
	COMPARE_INTERFACE* compare_interface;
	//
	char* str;	/*  */
} JTSTRING;

IMPLEMENT_JTCODE_INTERFACE(JTSTRING, jtstring)
IMPLEMENT_JTSTRING_INTERFACE(JTSTRING, jtstring)
IMPLEMENT_ARITHMETIC_INTERFACE(JTSTRING, jtstring)
IMPLEMENT_COMPARE_INTERFACE(JTSTRING, jtstring)

const INTERFACE_MAP jtstring_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTSTRING, jtcode_interface), &jtcode_interface },
	{ JTSTRING_INTERFACE_ID, offsetof(JTSTRING, jtstring_interface), &jtstring_interface },
	{ ARITHMETIC_INTERFACE_ID, offsetof(JTSTRING, arithmetic_interface), &arithmetic_interface },
	{ COMPARE_INTERFACE_ID, offsetof(JTSTRING, compare_interface), &compare_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtstring_create(const char* str)
{
	JTSTRING* this = calloc(1, sizeof(JTSTRING));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtstring_interface_map);

	/* 𕡐āAi[܂B */
	this->str = strdup(str);
	if(!this->str) {
		DIE(); /* s */
	}

	return &this->jtcode_interface;
}

static void
jtstring_delete(JTSTRING* this)
{
	/* ܂B */
	free(this->str);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	return safe_addref(intf); /* Ăяô߂+1 */
}

/*****************************************************************************
 *	JTSTRING_INTERFACE
 *****************************************************************************/

static const char*
jtstring_get_string(JTSTRING_INTERFACE** intf)
{
	JTSTRING* this = CONTAINING_RECORD(intf, JTSTRING, jtstring_interface);

	/* Ԃ܂B */
	return this->str;
}

/*****************************************************************************
 *	ARITHMETIC_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
arithmetic_neg(ARITHMETIC_INTERFACE** intf)
{
	DIE(); /* Kps */
}

static JTCODE_INTERFACE**
arithmetic_add(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code)
{
	JTSTRING* this = CONTAINING_RECORD(intf, JTSTRING, arithmetic_interface);
	//
	JTSTRING_INTERFACE** jtstring = NULL;
	STRING_BUFFER_INTERFACE** string_buffer = NULL;

	/* obt@쐬܂B */
	safe_attach(string_buffer, string_buffer_create());

	/* ǉ镶e擾܂B */
	safe_assign_interface(jtstring, code, JTSTRING_INTERFACE);
	if(!jtstring) {
		DIE(); /* JTSTRING_INTERFACEKv */
	}

	/* obt@ɂāA̕eA܂B */
	(*string_buffer)->append_string(string_buffer, this->str);
	(*string_buffer)->append_string(string_buffer, (*jtstring)->get_string(jtstring));

	/* obt@̓eAVR[h쐬܂B */
	code = NULL; /* code̎QƃJEg炳Ȃ߂ɕKv! */
	safe_attach(code, jtstring_create((*string_buffer)->lock(string_buffer, 0)));

	/* svɂȂC^[tFCX܂B */
	safe_release(jtstring);
	safe_release(string_buffer);

	return code;
}

static JTCODE_INTERFACE**
arithmetic_sub(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code)
{
	DIE(); /* Kps */
}

static JTCODE_INTERFACE**
arithmetic_mul(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code)
{
	JTSTRING* this = CONTAINING_RECORD(intf, JTSTRING, arithmetic_interface);
	//
	JTINT_INTERFACE** jtint = NULL;
	STRING_BUFFER_INTERFACE** string_buffer = NULL;
	//
	int i;
	int cnt;
	int len;
	int total_len;
	char* buf;

	/* obt@쐬܂B */
	safe_attach(string_buffer, string_buffer_create());

	/* JԂ񐔂擾܂B */
	safe_assign_interface(jtint, code, JTINT_INTERFACE);
	if(!jtint) {
		DIE(); /* JTINT_INTERFACEKv */
	}
	cnt = (*jtint)->get_value(jtint);

	/* obt@ɂāA̕eAJԂ񐔕AA܂B */
	len = strlen(this->str);
	total_len = len * cnt;
	buf = (*string_buffer)->lock(string_buffer, total_len);
	for(i = 0; i < cnt; i++) {
		memcpy(buf, this->str, len);
		buf += len;
	}
	(*string_buffer)->unlock(string_buffer, total_len);

	/* obt@̓eAVR[h쐬܂B */
	code = NULL; /* code̎QƃJEg炳Ȃ߂ɕKv! */
	safe_attach(code, jtstring_create((*string_buffer)->lock(string_buffer, 0)));

	/* svɂȂC^[tFCX܂B */
	safe_release(jtint);
	safe_release(string_buffer);

	return code;
}

static JTCODE_INTERFACE**
arithmetic_div(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code)
{
	DIE(); /* Kps */
}

/*****************************************************************************
 *	COMPARE_INTERFACE
 *****************************************************************************/

static int
compare_compare(COMPARE_INTERFACE** intf, JTCODE_INTERFACE** code)
{
	JTSTRING* this = CONTAINING_RECORD(intf, JTSTRING, compare_interface);
	//
	JTSTRING_INTERFACE** jtstring = NULL;
	//
	const char* str;

	/* ̕e擾܂B */
	safe_assign_interface(jtstring, code, JTSTRING_INTERFACE);
	if(!jtstring) {
		DIE(); /* JTSTRING_INTERFACEKv */
	}
	str = (*jtstring)->get_string(jtstring);

	/* svɂȂC^[tFCX܂B */
	safe_release(jtstring);

	/* ̕eƁA̕éArʂԂ܂B */
	return strcmp(this->str, str);
}

