/*
 *	jtobject.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTOBJECT
 *****************************************************************************/

typedef struct _JTOBJECT {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	JTOBJECT_INTERFACE* jtobject_interface;
	ARITHMETIC_INTERFACE* arithmetic_interface;
	//
	MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * slots_table;	/* Xbge[u */
} JTOBJECT;

IMPLEMENT_JTCODE_INTERFACE(JTOBJECT, jtobject)
IMPLEMENT_JTOBJECT_INTERFACE(JTOBJECT, jtobject)
IMPLEMENT_ARITHMETIC_INTERFACE(JTOBJECT, jtobject)

const INTERFACE_MAP jtobject_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTOBJECT, jtcode_interface), &jtcode_interface },
	{ JTOBJECT_INTERFACE_ID, offsetof(JTOBJECT, jtobject_interface), &jtobject_interface },
	{ ARITHMETIC_INTERFACE_ID, offsetof(JTOBJECT, arithmetic_interface), &arithmetic_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtobject_create(MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * slots_table)
{
	JTOBJECT* this = calloc(1, sizeof(JTOBJECT));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtobject_interface_map);

	/* Xbge[u𕡐āAi[܂B */
	this->slots_table = map_duplicate(slots_table);

	return &this->jtcode_interface;
}

JTCODE_INTERFACE**
jtobject_clone(JTOBJECT_INTERFACE** object)
{
	JTOBJECT* a = CONTAINING_RECORD(object, JTOBJECT, jtobject_interface);

	/* ̃IuWFNgƓXbge[u̕AVIuWFNg쐬܂B */
	return jtobject_create(a->slots_table);
}

JTCODE_INTERFACE**
jtobject_merge(JTOBJECT_INTERFACE** object1, JTOBJECT_INTERFACE** object2)
{
	JTOBJECT* a = CONTAINING_RECORD(object1, JTOBJECT, jtobject_interface);
	JTOBJECT* b = CONTAINING_RECORD(object2, JTOBJECT, jtobject_interface);
	//
	JTCODE_INTERFACE** value = NULL;
	JTSYMBOL_INTERFACE** symbol = NULL;
	//
	int i;
	int count;
	LIST/*<JTSYMBOL*>*/ * symbol_list;

	/* ̃Xbge[uAVIuWFNg쐬܂B */
	JTOBJECT* this = calloc(1, sizeof(JTOBJECT));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtobject_interface_map);
	//
	this->slots_table = map_create(&jtsymbol_to_jtcode_map_info);

	/* ߂̃IuWFNg̑SXbgAVIuWFNgɒǉ܂B */
	symbol_list = map_keys(a->slots_table);
	count = list_size(symbol_list);
	for(i = 0; i < count; i++) {
		safe_attach(symbol, list_get(symbol_list, i));
		safe_attach(value, map_get(a->slots_table, symbol));
		map_put(this->slots_table, symbol, value);
	}
	list_delete(symbol_list);

	/* ߂̃IuWFNg̑SXbgAVIuWFNgɒǉ܂B(d͏㏑) */
	symbol_list = map_keys(b->slots_table);
	count = list_size(symbol_list);
	for(i = 0; i < count; i++) {
		safe_attach(symbol, list_get(symbol_list, i));
		safe_attach(value, map_get(b->slots_table, symbol));
		map_put(this->slots_table, symbol, value);
	}
	list_delete(symbol_list);

	/* svɂȂC^[tFCX܂B */
	safe_release(value);
	safe_release(symbol);

	return &this->jtcode_interface;
}

static void
jtobject_delete(JTOBJECT* this)
{
	/* Xbge[u폜܂B */
	map_delete(this->slots_table);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTOBJECT* this = CONTAINING_RECORD(intf, JTOBJECT, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;
	JTSYMBOL_INTERFACE** name = NULL;
	JTVAR_INTERFACE** var = NULL;
	//
	int i;
	int count;
	LIST/*<JTSYMBOL_INTERFACE**>*/ * name_list;

	/* IuWFNg̏Ɋւ钍:
	 *
	 * * Xbg̏́AIuWFNg`ꂽʒů֐t[Ŏs܂B
	 *   IuWFNgsΏۂƂAV֐t[́A쐬܂B
	 * - ]āAtB[hϐ̏ƂāAIuWFNgg̃tB[hϐA\bhQƂ邱Ƃ͂ł܂B
	 *   <>
	 *	var o1 = object {
	 *		var v1 = 1;
	 *		fun f1(x) { x * 2; }
	 *		var v2 = v1;     // G[!! v1͎QƂł܂B
	 *		var v3 = f1(10); // G[!! f1͎QƂł܂B
	 *	};
	 * - ̑ɁAIuWFNg`ꂽʒů֐t[́A[JϐA֐QƂ邱Ƃł܂B
	 *   <>
	 *	var v1 = 1;
	 *	fun f1(x) { x * 2; }
	 *	var o1 = object {
	 *		var v2 = v1;     // OK!! v2 = 1
	 *		var v3 = f1(10); // OK!! v3 = 20
	 *	};
	 */

	/* ׂẴXbg𑖍... */
	name_list = map_keys(this->slots_table);
	count = list_size(name_list);
	for(i = 0; i < count; i++) {
		safe_attach(name, list_get(name_list, i)); /* tB[hϐA܂́A\bh̖O擾 */
		safe_attach(code, map_get(this->slots_table, name)); /* tB[hϐA܂́A\bh擾 */

		/* tB[hϐȂ΁Al]āA]̒lA炽߂ēo^܂B
		 * run()s̃Xbge[uɂ́A(JTVAR_INTERFACE**)͎cĂ܂B
		 */
		safe_assign_interface(var, code, JTVAR_INTERFACE);
		if(var) { /* tB[hϐ? */
			safe_attach(code, (*var)->get_code(var));
			safe_attach(code, (*code)->run(code));
			map_put(this->slots_table, name, code);
		}
	}
	list_delete(name_list); /* YȂ!! */

	/* svɂȂC^[tFCX܂B */
	safe_release(code);
	safe_release(name);
	safe_release(var);

	return safe_addref(intf); /* Ăяô߂+1 */
}

/*****************************************************************************
 *	JTOBJECT_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtobject_get_field_value(JTOBJECT_INTERFACE** intf, JTSYMBOL_INTERFACE** symbol)
{
	JTOBJECT* this = CONTAINING_RECORD(intf, JTOBJECT, jtobject_interface);
	//
	JTCODE_INTERFACE** value = NULL;

	/* tB[hϐ`Ă... */
	if(map_contains(this->slots_table, symbol)) {

		/* tB[hϐ̒l擾܂B */
		safe_attach(value, map_get(this->slots_table, symbol));
	}

	return value;
}

static void
jtobject_set_field_value(JTOBJECT_INTERFACE** intf, JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value)
{
	JTOBJECT* this = CONTAINING_RECORD(intf, JTOBJECT, jtobject_interface);

	/* tB[hϐ̒lݒ肵܂B */
	if(!map_contains(this->slots_table, symbol)) {
		DIE(); /* tB[hϐ`ĂȂ */
	}
	map_put(this->slots_table, symbol, value);
}

/*****************************************************************************
 *	ARITHMETIC_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
arithmetic_neg(ARITHMETIC_INTERFACE** intf)
{
	DIE(); /* Kps */
}

static JTCODE_INTERFACE**
arithmetic_add(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code)
{
	JTCODE_INTERFACE** result = NULL;
	JTOBJECT_INTERFACE** object1 = NULL;
	JTOBJECT_INTERFACE** object2 = NULL;

	/* ǵAJTOBJECT_INTERFACEC^[tFCX擾܂B */
	safe_assign_interface(object1, intf, JTOBJECT_INTERFACE);
	if(!object1) {
		DIE(); /* L蓾Ȃ */
	}

	/* IuWFNǵAJTOBJECT_INTERFACEC^[tFCX擾܂B */
	safe_assign_interface(object2, code, JTOBJECT_INTERFACE);
	if(!object2) {
		DIE(); /* IuWFNgȊO悤Ƃ (ǂݍ񂾃vÕG[) */
	}

	/* ̃IuWFNg܂B */
	safe_attach(result, jtobject_merge(object1, object2));

	/* svɂȂC^[tFCX܂B */
	safe_release(object1);
	safe_release(object2);

	return result;
}

static JTCODE_INTERFACE**
arithmetic_sub(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code)
{
	DIE(); /* Kps */
}

static JTCODE_INTERFACE**
arithmetic_mul(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code)
{
	DIE(); /* Kps */
}

static JTCODE_INTERFACE**
arithmetic_div(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code)
{
	DIE(); /* Kps */
}

