/*
 *	jtfun.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTFUN
 *****************************************************************************/

typedef struct _JTFUN {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	JTFUN_INTERFACE* jtfun_interface;
	//
	JTSYMBOL_INTERFACE** name;			/* ֐\V{ */
	LIST/*<JTSYMBOL_INTERFACE**>*/ * params_list;	/* Xg */
	JTCODE_INTERFACE** body;			/* ֐̖{ */
	int method;					/* ʏ̊֐Ȃ0A\bhȂ0ȊO̒l */
} JTFUN;

IMPLEMENT_JTCODE_INTERFACE(JTFUN, jtfun)
IMPLEMENT_JTFUN_INTERFACE(JTFUN, jtfun)

const INTERFACE_MAP jtfun_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTFUN, jtcode_interface), &jtcode_interface },
	{ JTFUN_INTERFACE_ID, offsetof(JTFUN, jtfun_interface), &jtfun_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtfun_create(JTSYMBOL_INTERFACE** name, LIST/*<JTSYMBOL_INTERFACE**>*/ * params_list, JTCODE_INTERFACE** body, int method)
{
	JTFUN* this = calloc(1, sizeof(JTFUN));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtfun_interface_map);

	/* ֐\V{i[܂B */
	safe_assign(this->name, name);

	/* Xg𕡐āAi[܂B */
	this->params_list = list_duplicate(params_list);

	/* ֐̖{̂i[܂B */
	safe_assign(this->body, body);

	/* ʏ̊֐A܂́A\bh̎ʂi[܂B */
	this->method = method;

	return &this->jtcode_interface;
}

static void
jtfun_delete(JTFUN* this)
{
	/* ֐\V{܂B */
	safe_release(this->name);

	/* Xg𕡐āA܂B */
	list_delete(this->params_list);

	/* ֐̖{̂܂B */
	safe_release(this->body);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTFUN* this = CONTAINING_RECORD(intf, JTFUN, jtcode_interface);

	/* [Jϐe[uA܂́AO[oϐe[uɁA֐o^܂B */
	joytoy_def_symbol_value(this->name, intf);

	return safe_addref(intf); /* Ăяô߂+1 */
}

/*****************************************************************************
 *	JTFUN_INTERFACE
 *****************************************************************************/

static JTSYMBOL_INTERFACE**
jtfun_get_name(JTFUN_INTERFACE** intf)
{
	JTFUN* this = CONTAINING_RECORD(intf, JTFUN, jtfun_interface);

	/* ֐\V{Ԃ܂B */
	return safe_addref(this->name); /* Ăяô߂+1 */
}

static JTCODE_INTERFACE**
jtfun_call(JTFUN_INTERFACE** intf, LIST/*<JTCODE_INTERFACE**>*/ * args_list, JTOBJECT_INTERFACE** object)
{
	JTFUN* this = CONTAINING_RECORD(intf, JTFUN, jtfun_interface);
	//
	JTSYMBOL_INTERFACE** symbol = NULL;
	JTCODE_INTERFACE** code = NULL;
	//
	int i;
	int argc;

	/* ֐t[ɓ܂B */
	joytoy_enter();

	/* Ǝ̐ł邱ƂAmF܂B */
	argc = list_size(args_list);
	if(list_size(this->params_list) != argc) {
		DIE(); /* Ǝ̐Ⴄ */
	}

	/* ̃V{ƁA̒lA[Jϐe[uɓo^܂B */
	for(i = 0; i < argc; i++) {
		safe_attach(symbol, list_get(this->params_list, i));
		safe_attach(code, list_get(args_list, i));
		joytoy_def_symbol_value(symbol, code);
	}

	/* \bhȂ΁AsΏۃIuWFNgݒ肵܂B */
	if(this->method) {
		if(!object) {
			DIE(); /* IuWFNgw肳ĂȂ */
		}
		joytoy_set_object(object);
	}

	/* ֐̖{̂s܂B */
	safe_attach(code, (*this->body)->run(this->body));

	/* ֐t[𔲂܂B */
	joytoy_leave();

	/* svɂȂC^[tFCX܂B */
	safe_release(symbol);

	return code;
}

