/*
 *	jtblock.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTBLOCK
 *****************************************************************************/

typedef struct _JTBLOCK {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	LIST/*<JTCODE_INTERFACE**>*/ * stmt_list;	/* Xg */
} JTBLOCK;

IMPLEMENT_JTCODE_INTERFACE(JTBLOCK, jtblock)

const INTERFACE_MAP jtblock_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTBLOCK, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtblock_create(LIST/*<JTCODE_INTERFACE**>*/ * stmt_list)
{
	JTBLOCK* this = calloc(1, sizeof(JTBLOCK));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtblock_interface_map);

	/* Xg𕡐āAi[܂B */
	this->stmt_list = list_duplicate(stmt_list);

	return &this->jtcode_interface;
}

static void
jtblock_delete(JTBLOCK* this)
{
	/* Xg폜܂B */
	list_delete(this->stmt_list);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTBLOCK* this = CONTAINING_RECORD(intf, JTBLOCK, jtcode_interface);
	//
	JTCODE_INTERFACE** stmt = NULL;
	//
	int i;
	int count;

	/* ׂĂ̕s܂B */
	count = list_size(this->stmt_list);
	for(i = 0; i < count; i++) {
		safe_attach(stmt, list_get(this->stmt_list, i));
		safe_attach(stmt, (*stmt)->run(stmt));
	}

	/* ŌɎsԂ܂B
	 * XgȂ΁ANULLԂ܂B
	 */
	return stmt;
}

