/*
 *	joytoy.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/*****************************************************************************
 *	
 *****************************************************************************/

const LIST_INFO ptr_list_info = {
	/* val = (void*) */
	ptr_copy,	/*  */
	ptr_delete,	/* 폜 */
};

const LIST_INFO jtcode_list_info = {
	/* val = (JTCODE_INTERFACE**) */
	unk_copy,	/*  */
	unk_delete,	/* 폜 */
};

const LIST_INFO jtsymbol_list_info = {
	/* val = (JTSYMBOL_INTERFACE**) */
	unk_copy,	/*  */
	unk_delete,	/* 폜 */
};

const MAP_INFO str_to_int_map_info = {
	/* key = (char*) */
	str_copy,	/*  */
	str_delete,	/* 폜 */
	str_equals,	/* r */
	/* value = (int) */
	ptr_copy,	/*  */
	ptr_delete,	/* 폜 */
};

const MAP_INFO jtsymbol_to_jtcode_map_info = {
	/* key = (JTSYMBOL_INTERFACE**) */
	unk_copy,	/*  */
	unk_delete,	/* 폜 */
	unk_equals,	/* r */
	/* value = (JTCODE_INTERFACE**) */
	unk_copy,	/*  */
	unk_delete,	/* 폜 */
};

/*****************************************************************************
 *	JOYTOY
 *****************************************************************************/

typedef struct _JOYTOY {
	MAP/*<char*,int>*/ * reserved_table;					/* \e[u */
	MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * global_table;	/* O[oϐe[u */
	LIST/*<MAP*>*/ * local_table_stack;					/* [Jϐe[ũX^bN */
} JOYTOY;

static JOYTOY* joytoy;

/*---------------------------------------------------------------------------*/

static void
init_reserved_table()
{
	static const struct {
		const char* name;	/* \ */
		int type;		/* g[N^Cv */
	} name_type[] = {
		{ "true", TOKEN_TYPE_TRUE },
		{ "false", TOKEN_TYPE_FALSE },
		{ "if", TOKEN_TYPE_IF },
		{ "else", TOKEN_TYPE_ELSE },
		{ "while", TOKEN_TYPE_WHILE },
		{ "fun", TOKEN_TYPE_FUN },
		{ "var", TOKEN_TYPE_VAR },
		{ "object", TOKEN_TYPE_OBJECT },
		{ "new", TOKEN_TYPE_NEW },
		/* TODO: \ꂪAɒǉĂB */
	};
	int i;

	/* \e[u쐬܂B */
	joytoy->reserved_table = map_create(&str_to_int_map_info);

	/* \o^܂B */
	for(i = 0; i < ARRAY_SIZE(name_type); i++) {
		map_put(joytoy->reserved_table, (void*)name_type[i].name, (void*)name_type[i].type);
	}
}

static void
free_reserved_table()
{
	/* \e[u폜܂B */
	map_delete(joytoy->reserved_table);
}

static void
init_global_table()
{
	/* O[oϐe[u쐬܂B */
	joytoy->global_table = map_create(&jtsymbol_to_jtcode_map_info);
}

static void
free_global_table()
{
	/* O[oϐe[u폜܂B */
	map_delete(joytoy->global_table);
}

static void
init_local_table_stack()
{
	/* [Jϐe[ũX^bN쐬܂B */
	joytoy->local_table_stack = list_create(&ptr_list_info);
}

static void
free_local_table_stack()
{
	/* [Jϐe[ucĂA폜܂B
	 * ֐̒ŏIƂӖAʏAL蓾Ȃ͂łA
	 * AIsgݍ݊֐ǉꍇɔāAĂ܂B
	 */
	while(list_size(joytoy->local_table_stack)) {
		joytoy_leave();
	}

	/* [Jϐe[ũX^bN폜܂B */
	list_delete(joytoy->local_table_stack);
}

static void
prim_init()
{
	/* gݍ݊֐o^܂B */
	JTCODE_INTERFACE** prim[] = {
		jtprim_print_create(),
		jtprim_max_create(),
		/* TODO: gݍ݊֐AɒǉĂB */
	};
	int i;
	for(i = 0; i < ARRAY_SIZE(prim); i++) {
		safe_attach(prim[i], (*prim[i])->run(prim[i])); /* o^ */
		safe_release(prim[i]);
	}
}

static void
joytoy_init()
{
	joytoy = calloc(1, sizeof(JOYTOY));
	if(!joytoy) {
		DIE(); /* s */
	}

	/* \e[u쐬܂B */
	init_reserved_table();

	/* O[oϐe[u쐬܂B */
	init_global_table();

	/* [Jϐe[ũX^bN쐬܂B */
	init_local_table_stack();

	/* gݍ݊֐o^܂B */
	prim_init();
}

static void
joytoy_exit()
{
	/* \e[u폜܂B */
	free_reserved_table();

	/* O[oϐe[u폜܂B */
	free_global_table();

	/* [Jϐe[ũX^bN폜܂B */
	free_local_table_stack();

	free(joytoy);
}

/* O[oϐ̒l擾܂B
 * O[oϐ`ĂȂ΁ANULLԂ܂B
 */
static JTCODE_INTERFACE**
joytoy_get_global_value(JTSYMBOL_INTERFACE** symbol)
{
	JTCODE_INTERFACE** value = NULL;

	/* O[oϐ`Ă... */
	if(map_contains(joytoy->global_table, symbol)) {

		/* O[oϐ̒l擾܂B */
		safe_attach(value, map_get(joytoy->global_table, symbol));
	}

	return value;
}

/* O[oϐ̒lݒ肵܂B
 * O[oϐ`ĂȂ΁AV`܂B
 */
static void
joytoy_set_global_value(JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value)
{
	/* O[oϐ̒lݒ肵܂B */
	map_put(joytoy->global_table, symbol, value);
}

/* [Jϐ̒l擾܂B
 * [Jϐ`ĂȂ΁ANULLԂ܂B
 */
static JTCODE_INTERFACE**
joytoy_get_local_value(JTSYMBOL_INTERFACE** symbol)
{
	MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * local_table;
	//
	JTCODE_INTERFACE** value = NULL;

	/* ֐̒Ȃ... */
	if(list_size(joytoy->local_table_stack)) {
		local_table = list_get(joytoy->local_table_stack, 0);

		/* [Jϐ`Ă... */
		if(map_contains(local_table, symbol)) {

			/* [Jϐ̒l擾܂B */
			safe_attach(value, map_get(local_table, symbol));
		}
	}

	return value;
}

/* [Jϐ̒lݒ肵܂B
 * [Jϐ`ĂȂ΁AV`܂B
 */
static void
joytoy_set_local_value(JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value)
{
	MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * local_table;

	/* [Jϐ̒lݒ肵܂B */
	if(!list_size(joytoy->local_table_stack)) {
		DIE(); /* ֐̒łȂ */
	}
	local_table = list_get(joytoy->local_table_stack, 0);
	map_put(local_table, symbol, value);
}

/* tB[hϐ̒lݒ肵܂B
 * tB[hϐ`ĂȂ΁AV`܂B
 */
static JTCODE_INTERFACE**
joytoy_get_field_value(JTSYMBOL_INTERFACE** symbol)
{
	JTCODE_INTERFACE** value = NULL;
	JTOBJECT_INTERFACE** object = NULL;

	/* \bh̒Ȃ... */
	safe_attach(object, joytoy_get_object());
	if(object) {

		/* tB[hϐ̒lA܂́ANULL(`)擾܂B */
		safe_attach(value, (*object)->get_field_value(object, symbol));
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(object);

	return value;
}

static void
joytoy_set_field_value(JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value)
{
	JTOBJECT_INTERFACE** object = NULL;

	/* tB[hϐ̒lݒ肵܂B */
	safe_attach(object, joytoy_get_object());
	if(!object) {
		DIE(); /* \bh̒łȂ */
	}
	(*object)->set_field_value(object, symbol, value);

	/* svɂȂC^[tFCX܂B */
	safe_release(object);
}

/*---------------------------------------------------------------------------*/

void
joytoy_main(FILE* in)
{
	LEXER_INTERFACE** lexer = NULL;
	PARSER_INTERFACE** parser = NULL;
	JTCODE_INTERFACE** code = NULL;

	/* JoyToy쐬܂B */
	joytoy_init();

	/* LexerAParser쐬܂B */
	safe_attach(lexer, lexer_create(in));
	safe_attach(parser, parser_create(lexer));

	for(;;) {
#ifdef WIN32
		/* L[{[h̓͂Ȃ΁Avvg\܂B */
		if(_isatty(_fileno(in))) {
			printf("JoyToy: ");
		}
#endif /*WIN32*/
		/* vOǂݍ݁A܂B */
		safe_attach(code, (*parser)->parse(parser));
		if(!code) {
			break; /* vOI */
		}
		safe_attach(code, (*code)->run(code));
#if 0
		/* lA\܂B */
		printf("result = ");
		joytoy_print(code);
		printf("\n");
#endif
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(lexer);
	safe_release(parser);
	safe_release(code);

	/* JoyToy܂B */
	joytoy_exit();
}

void
joytoy_print(JTCODE_INTERFACE** code)
{
	JTINT_INTERFACE** jtint = NULL;
	JTSTRING_INTERFACE** jtstring = NULL;
	JTBOOL_INTERFACE** jtbool = NULL;

	/* NULL */
	if(!code) {
		printf("NULL");
		goto L_EXIT;
	}

	/* l */
	safe_assign_interface(jtint, code, JTINT_INTERFACE);
	if(jtint) {
		printf("%d", (*jtint)->get_value(jtint));
		goto L_EXIT;
	}

	/*  */
	safe_assign_interface(jtstring, code, JTSTRING_INTERFACE);
	if(jtstring) {
		printf("\"%s\"", (*jtstring)->get_string(jtstring));
		goto L_EXIT;
	}

	/* ^Ul */
	safe_assign_interface(jtbool, code, JTBOOL_INTERFACE);
	if(jtbool) {
		printf("%s", (*jtbool)->get_value(jtbool) ? "true" : "false");
		goto L_EXIT;
	}

	/* TODO: \\ȃR[hAɒǉĂB */

	DIE(); /* sȃR[h */

L_EXIT:
	/* svɂȂC^[tFCX܂B */
	safe_release(jtint);
	safe_release(jtstring);
	safe_release(jtbool);
}

int
joytoy_get_reserved(const char* name)
{
	/* \e[u܂B */
	if(map_contains(joytoy->reserved_table, (void*)name)) {
		return (int)map_get(joytoy->reserved_table, (void*)name);
	}

	return -1; /* \ꂪo^ĂȂ */
}

void
joytoy_enter()
{
	MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * local_table;

	/* [Jϐe[u쐬܂B */
	local_table = map_create(&jtsymbol_to_jtcode_map_info);

	/* [Jϐe[uAX^bN̐擪ɒǉ܂B */
	list_insert(joytoy->local_table_stack, 0, local_table);
}

void
joytoy_leave()
{
	MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * local_table;

	/* X^bN̐擪ɗLA[Jϐe[u擾܂B */
	if(!list_size(joytoy->local_table_stack)) {
		DIE(); /* [Jϐe[u */
	}
	local_table = list_get(joytoy->local_table_stack, 0);

	/* t[X^bÑgbv폜܂B */
	list_remove(joytoy->local_table_stack, 0);

	/* [Jϐe[u폜܂B */
	map_delete(local_table);
}

JTOBJECT_INTERFACE**
joytoy_get_object()
{
	JTCODE_INTERFACE** code = NULL;
	JTSYMBOL_INTERFACE** symbol = NULL;
	JTOBJECT_INTERFACE** object = NULL;

	/* [Jϐme̒lA܂́ANULL(`)擾܂B */
	safe_attach(code, jtsymbol_intern("me"));
	safe_assign_interface(symbol, code, JTSYMBOL_INTERFACE);
	if(!symbol) {
		DIE(); /* L蓾Ȃ */
	}
	safe_attach(code, joytoy_get_local_value(symbol));
	safe_assign_interface(object, code, JTOBJECT_INTERFACE);

	/* svɂȂC^[tFCX܂B */
	safe_release(code);
	safe_release(symbol);

	return object;
}

void
joytoy_set_object(JTOBJECT_INTERFACE** object)
{
	JTCODE_INTERFACE** code = NULL;
	JTSYMBOL_INTERFACE** symbol = NULL;

	/* [JϐmeɁAsΏۂ̃IuWFNgo^܂B */
	safe_attach(code, jtsymbol_intern("me"));
	safe_assign_interface(symbol, code, JTSYMBOL_INTERFACE);
	if(!symbol) {
		DIE(); /* L蓾Ȃ */
	}
	safe_assign_interface(code, object, JTCODE_INTERFACE);
	if(!code) {
		DIE(); /* L蓾Ȃ */
	}
	joytoy_set_local_value(symbol, code);

	/* svɂȂC^[tFCX܂B */
	safe_release(code);
	safe_release(symbol);
}

JTCODE_INTERFACE**
joytoy_get_symbol_value(JTSYMBOL_INTERFACE** symbol)
{
	JTCODE_INTERFACE** value = NULL;

	/* [Jϐ`ĂA[Jϐ̒l擾܂B */
	safe_attach(value, joytoy_get_local_value(symbol));
	if(value) {
		goto L_EXIT;
	}

	/* tB[hϐ`ĂAtB[hϐ̒l擾܂B */
	safe_attach(value, joytoy_get_field_value(symbol));
	if(value) {
		goto L_EXIT;
	}

	/* O[oϐ`ĂAO[oϐ̒l擾܂B */
	safe_attach(value, joytoy_get_global_value(symbol));
	if(value) {
		goto L_EXIT;
	}

L_EXIT:
	return value;
}

void
joytoy_set_symbol_value(JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value)
{
	JTCODE_INTERFACE** code = NULL;

	/* [Jϐ`ĂA[Jϐ̒lݒ肵܂B */
	safe_attach(code, joytoy_get_local_value(symbol));
	if(code) {
		joytoy_set_local_value(symbol, value);
		goto L_EXIT;
	}

	/* tB[hϐ`ĂAtB[hϐ̒lݒ肵܂B */
	safe_attach(code, joytoy_get_field_value(symbol));
	if(code) {
		joytoy_set_field_value(symbol, value);
		goto L_EXIT;
	}

	/* O[oϐ`ĂAO[oϐ̒lݒ肵܂B */
	safe_attach(code, joytoy_get_global_value(symbol));
	if(code) {
		joytoy_set_global_value(symbol, value);
		goto L_EXIT;
	}

	DIE(); /* ϐ`ĂȂ */

L_EXIT:
	/* svɂȂC^[tFCX܂B */
	safe_release(code);
}

void
joytoy_def_symbol_value(JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value)
{
	MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * table;

	/* ֐̒Ȃ΁AV[Jϐ`܂B
	 * ֐̒łȂ΁AVO[oϐ`܂B
	 */
	if(list_size(joytoy->local_table_stack)) {
		table = list_get(joytoy->local_table_stack, 0);
	} else {
		table = joytoy->global_table;
	}
	if(map_contains(table, symbol)) {
		DIE(); /* d` */
	}
	map_put(table, symbol, value);
}

