/*
 *	sys/statvfs.h
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2014 Naoyuki Sawa
 *
 *	* Sun Sep 07 20:09:27 JST 2014 Naoyuki Sawa
 *	- VK쐬B
 */
#ifndef __SYS_STATVFS_H__
#define __SYS_STATVFS_H__

struct statvfs {
	unsigned long	f_bsize;	/* file system block size */			//(BLOCKSIZE)Œ
	unsigned long	f_frsize;	/* fundamental file system block size */	//(BLOCKSIZE)Œ
	fsblkcnt_t	f_blocks;	/* number of blocks (unit f_frsize) */		//(MAXFAT)ȉ
	fsblkcnt_t	f_bfree;	/* free blocks in file system */		//(f_blocks)ȉ
	fsblkcnt_t	f_bavail;	/* free blocks for non-root */			//(f_bfree)Ɠ
	fsfilcnt_t	f_files;	/* total file inodes */				//(MAXDIR)Œ
	fsfilcnt_t	f_ffree;	/* free file inodes */				//(f_files)ȉ
	fsfilcnt_t	f_favail;	/* free file inodes for to non-root */		//(f_ffree)Ɠ
	unsigned long	f_fsid;		/* file system id */				//(0)Œ
	unsigned long	f_flag;		/* bit mask of f_flag values */			//(0)Œ
	unsigned long	f_namemax;	/* maximum filename length */			//(FIELD_SIZEOF(DIRECTORY,name)-1)Œ	(24-1)=23łBP/ECE APIňt@C(8+1+3)=12ȉłADIRECTORY\̂ɂ23i[ł̂ŁA23Ƃ邱Ƃɂ܂B
};

/* statvfs.f_flag */
#define ST_RDONLY	0x0001UL	/* read-only filesystem */
#define ST_NOSUID	0x0002UL	/* nosuid flag set */

int statvfs(const char* path, struct statvfs* buf);	//clipio.c
int fstatvfs(int fd, struct statvfs* buf);		//clipio.c

#endif/*__SYS_STATVFS_H__*/
