/*
 *	sys/stat.h
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2013-2014 Naoyuki Sawa
 *
 *	* Fri Mar 22 00:29:55 JST 2013 Naoyuki Sawa
 *	- VK쐬B
 *	* Sun Sep 07 20:09:27 JST 2014 Naoyuki Sawa
 *	- stat.st_blksize,stat.st_blocksǉ܂B
 */
#ifndef __SYS_STAT_H__
#define __SYS_STAT_H__

#define S_IFMT   0170000	/* bit mask for the file type bit fields */
#define S_IFREG  0100000	/* regular file */
#define S_IFDIR  0040000	/* directory */
#define S_IFCHR  0020000	/* character device */
#define S_IFIFO  0010000	/* FIFO */
#define S_ISUID  0004000	/* set UID bit */
#define S_ISGID  0002000	/* set GID bit */
#define S_ISVTX  0001000	/* sticky bit */
#define S_IRWXU  0000700	/* mask for file owner permissions */
#define S_IRUSR  0000400	/* owner has read permission */
#define S_IWUSR  0000200	/* owner has write permission */
#define S_IXUSR  0000100	/* owner has execute permission */
#define S_IRWXG  0000070	/* mask for group permissions */
#define S_IRGRP  0000040	/* group has read permission */
#define S_IWGRP  0000020	/* group has write permission */
#define S_IXGRP  0000010	/* group has execute permission */
#define S_IRWXO  0000007	/* mask for permissions for others */
#define S_IROTH  0000004	/* others have read permission */
#define S_IWOTH  0000002	/* others have write permission */
#define S_IXOTH  0000001	/* others have execute permission */
#define S_IREAD  S_IRUSR
#define S_IWRITE S_IWUSR
#define S_IEXEC  S_IXUSR

#define S_ISREG(m)  (((m)&S_IFMT)==S_IFREG)	/* is it a regular file? */
#define S_ISDIR(m)  (((m)&S_IFMT)==S_IFDIR)	/* is it a directory? */
#define S_ISCHR(m)  (((m)&S_IFMT)==S_IFCHR)	/* is it a character device? */
#define S_ISFIFO(m) (((m)&S_IFMT)==S_IFIFO)	/* is it a FIFO? */

struct stat {
	dev_t     st_dev;	/* ID of device containing file */	/* Always 0 */
	ino_t     st_ino;	/* inode number */			/* Always 0 */
	mode_t    st_mode;	/* protection */
	nlink_t   st_nlink;	/* number of hard links */		/* Always 1 */
	uid_t     st_uid;	/* user ID of owner */			/* Always 0 */
	gid_t     st_gid;	/* group ID of owner */			/* Always 0 */
	dev_t     st_rdev;	/* device ID (if special file) */	/* Always 0 */
	off_t     st_size;	/* total size, in bytes */
	blksize_t st_blksize;	/* blocksize for file system I/O */	/* Always BLOCKSIZE */	/*{{2014/09/07ύX:stat.st_blksize,stat.st_blocksǉ܂B}}*/
	blkcnt_t  st_blocks;	/* number of 512B blocks allocated */	/* (st_size+511)>>9 */	/*{{2014/09/07ύX:stat.st_blksize,stat.st_blocksǉ܂B}}*/
	time_t    st_atime;	/* time of last access */		/* Always 0 */
	time_t    st_mtime;	/* time of last modification */		/* Always 0 */
	time_t    st_ctime;	/* time of last status change */	/* Always 0 */
};

int stat(const char* path, struct stat* buf);	/* clipio.c */
int fstat(int fd, struct stat* buf);		/* clipio.c */

#endif/*__SYS_STAT_H__*/
