	/********************************************************************/
	/*                                                                  */
	/*  math.h                                                          */
	/*       version 0          1992/08/31        K.Shinozuka           */
    	/*       modified	    1997/03/17	      T.Katahira	    */
    	/*		change function declaration to the ANSI style	    */
	/*                                                                  */
	/*  math.h contains followings.                                     */
	/*    extern declarations of math-functions                         */
	/*    extern declarations of special codes and useful numbers       */
	/*                                                                  */
	/*       modify for P/ECE   2015/07/25        Naoyuki Sawa          */
	/*		- /usr/PIECE/include ɂt@CÃt@CD悳悤Aclip.mkɂāACN[hpXݒ肵Ă܂B	*/
	/*		- log2()ǉ܂B́Acliplibc.cɂ܂Blog2()́AC99Œǉꂽ֐łBuLua 5.3.1vAgpĂ܂B	*/
	/*		  EPSONCuɂAVisual C++ 6.0ɂAlog2()͊܂܂Ă܂B								*/
	/*                                                                  */
	/********************************************************************/

#ifndef MATH_H 
#define MATH_H

#ifdef UNIX
#include "errno.h"
#else
#include <errno.h>
#endif

extern double acos( double );
extern double asin( double );
extern double atan( double );
extern double atan2( double, double );
extern double ceil( double );
extern double cos( double );
extern double cosh( double );
extern double exp( double );
extern double fabs( double );
extern double floor( double );
extern double fmod( double, double );
extern double frexp( double, int * );
extern double ldexp( double, int );
extern double log( double );
extern double log10( double );
extern double modf( double, double * );
extern double pow( double, double );
extern double sin( double );
extern double sinh( double );
extern double sqrt( double );
extern double tan( double );
extern double tanh( double );

#ifndef DBL_LNG_TYPE 

#define DBL_LNG_TYPE 

typedef union {
    struct {
#ifdef BIG_ENDIAN
        unsigned long _LL;
        unsigned long _LH;
#else  
        unsigned long _LH;
        unsigned long _LL;
#endif 
    } st;
    double _D;
} DBL_LNG;

#endif

//{{2015/07/25ǉ:log2()ǉ܂B́Acliplibc.cɂ܂Blog2()́AC99Œǉꂽ֐łBuLua 5.3.1vAgpĂ܂B
double log2(double x);
//}}2015/07/25ǉ:log2()ǉ܂B́Acliplibc.cɂ܂Blog2()́AC99Œǉꂽ֐łBuLua 5.3.1vAgpĂ܂B

#endif
