/*	
 *	framxm.c
 *
 *	P/ECE XM Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Tue Nov 9 19:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/* * G[R[h̒ĺAsԍ𕉒lɂ̂łB
 *   vOCƁAG[R[hς\܂B
 *   G[R[h̒ĺAfobÔ߂ɗpĂB
 */
#define ERRNO	(-__LINE__)

/****************************************************************************
 *	P/ECE XM Driver
 ****************************************************************************/

int
xm_run(XMDRIVER* driver)
{
	XMNOTE note;
	int flags;
	int i_pattern;
	int i_channel;
	int real_note;
	int period;
	int volume_envelope_progress;
	XMCHANNEL* channel;
	XMINSTRUMENT* instrument;
	XMSAMPLE* sample;
	XMENVELOPEPOINT* volume_envelope_position;

	if(driver->stat) goto L_EXIT;

	/* 1[Tick]̎Ԍo߂JEgAbv܂B
	 * BPM̐ݒl125̏ꍇɁA1[Tick]=1/50[Sec]ƂȂ܂B
	 */
	driver->progress += driver->bpm;
	while(driver->progress >= 125) {
		driver->progress -= 125;

		/* 1[Tick]o߂܂B
		 * oTickTempo̐ݒlɒBA1[Row]i݂܂B
		 */
		driver->tick++;
		while(driver->tick >= driver->tempo) {
			driver->tick -= driver->tempo;

			/* Position jumpvĂ... */
			if(driver->position_jump != -1) {

				/* Orderݒ肵܂B */
				driver->order = driver->position_jump;
				if((driver->order < 0) ||
				   (driver->order > driver->song_length - 1)) {
					driver->stat = ERRNO; /* Position jumps */
					goto L_EXIT;
				}
				driver->row = 0; /* Kv!! */

				/* Pattern擾܂B */
				i_pattern = driver->pattern_order_table[driver->order];
				if((i_pattern < 0) ||
				   (i_pattern > driver->number_of_patterns - 1)) {
					driver->stat = ERRNO; /* Patterns */
					goto L_EXIT;
				}
				driver->pattern = &driver->patterns[i_pattern];

				/* Packed pattern data̐擪AhX擾܂B */
				driver->packed_pattern_position = driver->pattern->packed_pattern_data;

				/* Position jump܂B */
				driver->position_jump = -1;
			}

			/* Pattern breakvĂ邩A܂PatternI... */
			if((driver->pattern_break != -1) ||
			   (driver->row >= driver->pattern->number_of_rows_in_pattern)) {

				/* Order̐擪Row֐i߂܂B */
				driver->order++;
				driver->row = 0;

				/* SongIoA[vs܂B */
				if(driver->order >= driver->song_length) {
					driver->order = driver->restart_position;

					/* [vJnʒuSong͈̔͊OȂ΁A񃋁[vȂƌȂ܂B */
					if((driver->order < 0) ||
					   (driver->order > driver->song_length - 1)) {
						driver->stat = ERRNO; /* 񃋁[v */
						goto L_EXIT;
					}
				}

				/* Pattern擾܂B */
				i_pattern = driver->pattern_order_table[driver->order];
				if((i_pattern < 0) ||
				   (i_pattern > driver->number_of_patterns - 1)) {
					driver->stat = ERRNO; /* Patterns */
					goto L_EXIT;
				}
				driver->pattern = &driver->patterns[i_pattern];

				/* Packed pattern data̐擪AhX擾܂B */
				driver->packed_pattern_position = driver->pattern->packed_pattern_data;

				/* Pattern breakvĂ... */
				if(driver->pattern_break != -1) {

					/* Pattern breakɂĎw肳ꂽRow܂Ői߂܂B */
					if((driver->pattern_break < 0) ||
					 //(driver->pattern_break > driver->pattern->number_of_rows_in_pattern)) {
					 //2004/11/16 Naoyuki Sawa C
					   (driver->pattern_break > driver->pattern->number_of_rows_in_pattern - 1)) {
						driver->stat = ERRNO; /* Pattern breaks */
						goto L_EXIT;
					}
					while(driver->row < driver->pattern_break) {
						for(i_channel = 0; i_channel < driver->number_of_channels; i_channel++) {
							flags = *driver->packed_pattern_position++;
							if(flags & 0x80) {
								if(flags & (1 << 0)) driver->packed_pattern_position++; /* Note */
								if(flags & (1 << 1)) driver->packed_pattern_position++; /* Instrument */
								if(flags & (1 << 2)) driver->packed_pattern_position++; /* Volume column byte */
								if(flags & (1 << 3)) driver->packed_pattern_position++; /* Effect type */
								if(flags & (1 << 4)) driver->packed_pattern_position++; /* Effect parameter */
							} else {
								driver->packed_pattern_position += 5 - 1/*Note͎擾ς*/;
							}
						}
						driver->row++;
					}

					/* Pattern break܂B */
					driver->pattern_break = -1;
				}
			}

			/* ̂߂ɁARowi߂Ă܂B */
			driver->row++;

			/* e`lɂ... */
			for(i_channel = 0, channel = driver->channels;
			    i_channel < driver->number_of_channels;
			    i_channel++, channel++) {

				/* ܂AmVolume column byteEffect܂B */
				channel->volume_column_byte = 0; /*  */
				channel->effect_type = 0; /*  */
				/* Effect parameter͌p\̂ŁANAĂ̓_!! */

				/* Packed pattern dataA1`lNote擾܂B */
				flags = *driver->packed_pattern_position++;
				if(flags & 0x80) {
					memset(&note, 0, sizeof note);
					if(flags & (1 << 0)) note.note               = *driver->packed_pattern_position++;
					if(flags & (1 << 1)) note.instrument         = *driver->packed_pattern_position++;
					if(flags & (1 << 2)) note.volume_column_byte = *driver->packed_pattern_position++;
					if(flags & (1 << 3)) note.effect_type        = *driver->packed_pattern_position++;
					if(flags & (1 << 4)) note.effect_parameter   = *driver->packed_pattern_position++;
				} else {
					note.note               = flags;
					note.instrument         = *driver->packed_pattern_position++;
					note.volume_column_byte = *driver->packed_pattern_position++;
					note.effect_type        = *driver->packed_pattern_position++;
					note.effect_parameter   = *driver->packed_pattern_position++;
				}

				/* InstrumentLȂ... */
				if(note.instrument) {

					/* LInstrumentȂ΁Ai[܂B */
					if((note.instrument >= 1) &&
					   (note.instrument <= driver->number_of_instruments)) {
						channel->pending_instrument = &driver->instruments[note.instrument - 1/*YȂ!!*/];
					}
				}

				/* NoteLȂ... */
				if(note.note) {

					if((note.note >= 1) && (note.note <= 96)) { /* C-0..B-7 */

						/* ȂƂȏSampleInstrumentł̔v̂ݎ󂯕t܂B
						 * XMGfBbg̐l׃~XƎv܂AHSamplêȂInstrumentł̔v܂B
						 * SamplêȂInstrumentł̔v́A邱Ƃɂ܂B(Ǝf)
						 */
						instrument = channel->pending_instrument;
						if(instrument->number_of_samples_in_instrument) {

							/* NoteɑΉSample擾܂B
							 * Sample number for all noteśARelative note numberZONoteɑΉĂ܂!!
							 */
							sample = &instrument->samples[
								  instrument->sample_number_for_all_notes[note.note - 1/*YȂ!!*/]];

							/* Relative note numberZAReal note߂܂B */
							real_note = (note.note - 1/*YȂ!!*/) + sample->relative_note_number;
							if((real_note >= 0) && (real_note <= 118)) { /* (dl) */

								/* Period߂܂B */
								period = real_note << 8;

								/* Tone portaƕpꍇ́AڕWPeriodݒ肵A݂̔p܂B
								 * * InstrumentSampleAeSampleقȂRelative noteĂƁA
								 *   NoteɂPeriod̊Ⴄ߁ATone portaȂƂ܂B
								 * *  Effect type 0x05 : Tone porta+Volume slide 肵Ă܂A
								 *   2004/11/14݂̂ƂATone porta+Volume slide͖łB
								 *   (Tone porta+Volume slideɔEffect parameterVolume slideɓKpA
								 *    Tone portaɑ΂Effect parameter͑OlpAƂAϑIȎdl̂߁B)
								 */
								if((note.volume_column_byte >> 4 == 0xf) ||	/* Tone porta */
								   (note.effect_type == 0x03) ||		/* Tone porta */
								   (note.effect_type == 0x05)) {		/* Tone porta+Volume slide */
								/*0-H*/	//̂܂
								/*I*/	channel->tone_porta = period;

									/* Instrumentݒpꍇ́ATone portaƋɔJns܂B */
									if(note.instrument) {
/**/goto TONE_PORTA_WITH_INSTRUMENT;
/**/									}
/**/
/**/								/* ȊÓAʏ̔JnłB */
/**/								} else {
/**/								/*8*/	channel->period = period;
TONE_PORTA_WITH_INSTRUMENT: /*----------------------------------------------------------------------------------------------------------------------------*/
								/*0*/	channel->stat = XMCHANNEL_NOTEON;
								/*1*/	//channel->pending_instrument = ̂܂
								/*2*/	channel->playing_instrument = instrument;
								/*3*/	channel->playing_sample = sample;
								/*4*/	channel->sample_position = sample->sample_data;
								/*5*/	channel->sample_direction = 0;
								/*6*/	channel->sample_output = 0;
								/*7*/	channel->volume = channel->playing_sample->volume;
								/*8*/	//channel->period = Őݒ
								/*9*/	channel->finetune = sample->finetune;
								/*A*/	channel->progress = 0;
								/*B*/	channel->volume_envelope_position = instrument->points_for_volume_envelope;
								/*C*/	channel->volume_envelope_progress = 0;
								/*D*/	channel->envelope_volume = 64;
								/*E*/	channel->fadeout_volume = 1 << 16;
								/*F*/	//channel->volume_column_byte = ɉĂ܂
								/*G*/	//channel->effect_type = ɉĂ܂
								/*H*/	//channel->effect_parameter = ̂܂
								/*I*/	//channel->tone_porta = ݒsvA܂͏ifubNŐݒς
								}
							}
						}

					} else { /* NoteOff */

						/* NoteOnȂ΁ANoteOffֈڍs܂B */
						if(channel->stat == XMCHANNEL_NOTEON) {
							channel->stat = XMCHANNEL_NOTEOFF;
						}
					}
				}

				/* Volume column byteLȂ΁Ai[܂B */
				if(note.volume_column_byte) {
					channel->volume_column_byte = note.volume_column_byte;
				}

				/* Effect typeLȂ΁Ai[܂B */
				if(note.effect_type) {
					channel->effect_type = note.effect_type;

					/* Effect parameter0ȊOȂ΁AŊi[܂B */
					if(note.effect_parameter) {
						channel->effect_parameter = note.effect_parameter;

					/* Effect parameter0Ȃ΁AOlp邩A܂0i[܂B
					 * ȉswitch`caseŁARgAEgā@遚Effect typéAOlp܂B
					 *                       RgAEgāȂEffect typéA0i[܂B
					 */
					} else {
						switch(note.effect_type) {
						case 0x00: /* Arpeggio */
						//case 0x01: /* Porta up */
						//case 0x02: /* Porta down */
						//case 0x03: /* Tone porta */
						//case 0x04: /* Vibrato */
						//case 0x05: /* Tone porta+Volume slide */
						//case 0x06: /* Vibrato+Volume slide */
						//case 0x07: /* Tremolo */
						case 0x08: /* Set panning */
						case 0x09: /* Sample offset */
						//case 0x0a: /* Volume slide */
						case 0x0b: /* Position jump */
						case 0x0c: /* Set volume */
						case 0x0d: /* Pattern break */
						case 0x0e: /* Extended effects */ /* 4bit0ۂɂďׂłA2004/11/14ݖΉł */
						case 0x0f: /* Set tempo/BPM */
						case 0x10: /* Set global volume */
						//case 0x11: /* Global volume slide */
						case 0x12: /* Unused */
						case 0x13: /* Unused */
						case 0x14: /* Unused */
						case 0x15: /* Set envelope position */
						case 0x16: /* Unused */
						case 0x17: /* Unused */
						case 0x18: /* Unused */
						//case 0x19: /* Panning slide */
						case 0x1a: /* Unused */
						//case 0x1b: /* Multi retrig note */
						case 0x1c: /* Unused */
						case 0x1d: /* Tremor */
						case 0x1e: /* Unused */
						case 0x1f: /* Unused */
						case 0x20: /* Unused */
						//case 0x21: /* Extra fine porta up/down */
							channel->effect_parameter = note.effect_parameter;
							break;
						}
					}
				}
			}
		}

		/* e`lɂ... */
		for(i_channel = 0, channel = driver->channels;
		    i_channel < driver->number_of_channels;
		    i_channel++, channel++) {

			/* v!! Volume column byteEffect́ASilent/NoteOn/NoteOffɂ炸s܂B */

			/* Volume column byteLȂ΁As܂B */
			if(channel->volume_column_byte) {
				switch(channel->volume_column_byte >> 4) {
				case 0x1: /* Set volume value - $10 */
				case 0x2: /* Set volume value - $10 */
				case 0x3: /* Set volume value - $10 */
				case 0x4: /* Set volume value - $10 */
				case 0x5: /* Set volume value - $10 */
					/* 0x10..0x50 = Vol 0..64
					 * 0x51..0x5f͖`łAVol 65..79Ɖ߂邱Ƃɂ܂B(Ǝf)
					 */
					channel->volume = channel->volume_column_byte - 0x10;
					channel->volume_column_byte = 0; /*  */
					break;
				case 0x6: /* Volume slide down */
					channel->volume -= channel->volume_column_byte & 0xf;
					if(channel->volume < 0) {
						channel->volume = 0;
					}
					break;
				case 0x7: /* Volume slide up */
					channel->volume += channel->volume_column_byte & 0xf;
					if(channel->volume > 64) {
						channel->volume = 64;
					}
					break;
				case 0x8: /* Fine volume slide down */
					channel->volume -= channel->volume_column_byte & 0xf;
					if(channel->volume < 0) {
						channel->volume = 0;
					}
					channel->volume_column_byte = 0; /*  */
					break;
				case 0x9: /* Fine volume slide up */
					channel->volume += channel->volume_column_byte & 0xf;
					if(channel->volume > 64) {
						channel->volume = 64;
					}
					channel->volume_column_byte = 0; /*  */
					break;
				//case 0xa: /* Set vibrato speed */
				//case 0xb: /* Vibrato */
				//case 0xc: /* Set panning */
				//case 0xd: /* Panning slide left */
				//case 0xe: /* Panning slide right */
				case 0xf: /* Tone porta */
					if(channel->period < channel->tone_porta) {
						channel->period += (channel->volume_column_byte & 0xf) << ((2 + 4)/*dlH*/ + 2/**/);
						if(channel->period >= channel->tone_porta) {
							channel->period = channel->tone_porta;
						}
					}
					if(channel->period > channel->tone_porta) {
						channel->period -= (channel->volume_column_byte & 0xf) << ((2 + 4)/*dlH*/ + 2/**/);
						if(channel->period <= channel->tone_porta) {
							channel->period = channel->tone_porta;
						}
					}
					break;
				}
			}

			/* Effect typeLȂ΁As܂B */
			if(channel->effect_type) {
				switch(channel->effect_type) {
				//case 0x00: /* Arpeggio */
				case 0x01: /* Porta up */
					channel->period += channel->effect_parameter << (2/*dlH*/ + 2/**/);
					if(channel->period > 118 << 8) {
						channel->period = 118 << 8;
					}
					break;
				case 0x02: /* Porta down */
					channel->period -= channel->effect_parameter << (2/*dlH*/ + 2/**/);
					if(channel->period < 0) {
						channel->period = 0;
					}
					break;
				case 0x03: /* Tone porta */
					if(channel->period < channel->tone_porta) {
						channel->period += channel->effect_parameter << (2/*dlH*/ + 2/**/);
						if(channel->period >= channel->tone_porta) {
							channel->period = channel->tone_porta;
						}
					}
					if(channel->period > channel->tone_porta) {
						channel->period -= channel->effect_parameter << (2/*dlH*/ + 2/**/);
						if(channel->period <= channel->tone_porta) {
							channel->period = channel->tone_porta;
						}
					}
					break;
				//case 0x04: /* Vibrato */
				//case 0x05: /* Tone porta+Volume slide */
				//case 0x06: /* Vibrato+Volume slide */
				//case 0x07: /* Tremolo */
				//case 0x08: /* Set panning */
				//case 0x09: /* Sample offset */
				case 0x0a: /* Volume slide */
					channel->volume += channel->effect_parameter >> 4;
					if(channel->volume > 64) {
						channel->volume = 64;
					}
					channel->volume -= channel->effect_parameter & 0xf;
					if(channel->volume < 0) {
						channel->volume = 0;
					}
					break;
				case 0x0b: /* Position jump */
					driver->position_jump = channel->effect_parameter;
					channel->effect_type = 0; /*  */
					break;
				case 0x0c: /* Set volume */
					channel->volume = channel->effect_parameter;
					channel->effect_type = 0; /*  */
					break;
				case 0x0d: /* Pattern break */
					driver->pattern_break = channel->effect_parameter;
					channel->effect_type = 0; /*  */
					break;
				case 0x0e: /* Extended effects */
					switch(channel->effect_parameter >> 4) {
					case 0x1: /* Fine porta up */
						channel->period += (channel->effect_parameter & 0xf) << (2/*dlH*/ + 2/**/);
						if(channel->period > 118 << 8) {
							channel->period = 118 << 8;
						}
						break;
					case 0x2: /* Fine porta down */
						channel->period -= (channel->effect_parameter & 0xf) << (2/*dlH*/ + 2/**/);
						if(channel->period < 0) {
							channel->period = 0;
						}
						break;
					//case 0x3: /* Set gliss control */
					//case 0x4: /* Set vibrato control */
					//case 0x5: /* Set finetune */ /* MOD`ł̂݋@\܂BXM`ł͎g܂B */
					//case 0x6: /* Set loop begin/loop */
					//case 0x7: /* Set tremolo control */
					//case 0x9: /* Retrig note */
					case 0xa: /* Fine volume slide up */
						channel->volume += channel->effect_parameter & 0xf;
						if(channel->volume > 64) {
							channel->volume = 64;
						}
						break;
					case 0xb: /* Fine volume slide down */
						channel->volume -= channel->effect_parameter & 0xf;
						if(channel->volume < 0) {
							channel->volume = 0;
						}
						break;
					//case 0xc: /* Note cut */
					//case 0xd: /* Note delay */
					//case 0xe: /* Pattern delay */
					}
					break;
				case 0x0f: /* Set tempo/BPM */
					if(!channel->effect_parameter) {
						driver->stat = ERRNO;
						goto L_EXIT;
					}
					if(channel->effect_parameter < 0x20) {
						driver->tempo = channel->effect_parameter;
					} else {
						driver->bpm = channel->effect_parameter;
					}
					channel->effect_type = 0; /*  */
					break;
				case 0x10: /* Set global volume */
					driver->global_volume = channel->effect_parameter;
					channel->effect_type = 0; /*  */
					break;
				case 0x11: /* Global volume slide */
					driver->global_volume += channel->effect_parameter >> 4;
					if(driver->global_volume > 64) {
						driver->global_volume = 64;
					}
					driver->global_volume -= channel->effect_parameter & 0xf;
					if(driver->global_volume < 0) {
						driver->global_volume = 0;
					}
					break;
				//case 0x12: /* Unused */
				//case 0x13: /* Unused */
				//case 0x14: /* Unused */
				//case 0x15: /* Set envelope position */
				//case 0x16: /* Unused */
				//case 0x17: /* Unused */
				//case 0x18: /* Unused */
				//case 0x19: /* Panning slide */
				//case 0x1a: /* Unused */
				//case 0x1b: /* Multi retrig note */
				//case 0x1c: /* Unused */
				//case 0x1d: /* Tremor */
				//case 0x1e: /* Unused */
				//case 0x1f: /* Unused */
				//case 0x20: /* Unused */
				//case 0x21: /* Extra fine porta up/down */
				}
			}

			/* SilentłȂ... */
			if(channel->stat) {
				instrument = channel->playing_instrument;

				/* Volume envelopeLȂ΁As܂B */
				volume_envelope_position = channel->volume_envelope_position; /* o */
				if(volume_envelope_position) {
					volume_envelope_progress = channel->volume_envelope_progress; /* o */

					/* NoteOnŁASustain pointɒBĂAEnvelope volumeێ܂B */
					if((channel->stat == XMCHANNEL_NOTEON) &&
					   (volume_envelope_position == instrument->volume_sustain_point)) {
						channel->envelope_volume = volume_envelope_position->y;

					/* ȉ́ANoteOn/NoteOffʂłB */
					} else {
ENVELOPE_LOOP:
						/* ŌPointɓB邩A܂݂͌Progress傫xPoint̒O܂Ői߂܂B
						 * ɂAxPoint̕тXLbv̂ŁAȍ~̏Ń[Z̐Sz͂܂B
						 */
						while((volume_envelope_position < instrument->volume_loop_end_point) &&
						      (volume_envelope_progress >= (volume_envelope_position + 1)->x)) {
							volume_envelope_position++;
						}

						/* ŌPointɓBꍇA[vJnʒuƍŌPointxłȂ΁A[v܂B
						 * xȂ΁A[vĂ͂܂B(ŉiv[vɂȂĂ܂܂B)
						 */
						if((volume_envelope_position == instrument->volume_loop_end_point) &&
						   (instrument->volume_loop_start_point->x < instrument->volume_loop_end_point->x)) {
							volume_envelope_position = instrument->volume_loop_start_point;
							volume_envelope_progress = volume_envelope_position->x;
							goto ENVELOPE_LOOP;
						}

						/* ݂PointƎPoint̊Ԃy⊮ꍇ͂B */
						if(volume_envelope_position < instrument->volume_loop_end_point) {
							channel->envelope_volume = ((volume_envelope_position + 1)->y - volume_envelope_position->y)
										 * ( volume_envelope_progress         - volume_envelope_position->x)
										 / ((volume_envelope_position + 1)->x - volume_envelope_position->x)
										 +                                      volume_envelope_position->y;
							volume_envelope_progress++;

						/* ŌPointɓBĂāAVolume loop start point == Volume loop end point ̏ꍇ͂B */
						} else {
							channel->envelope_volume = volume_envelope_position->y;
							/* Volume envelope progress͂̂܂ */
						}
					}

					channel->volume_envelope_position = volume_envelope_position; /* ߂ */
					channel->volume_envelope_progress = volume_envelope_progress; /* ߂ */
				}

				/* NoteOffȂ΁AVolume fadeouts܂B */
				if(channel->stat == XMCHANNEL_NOTEOFF) {
					channel->fadeout_volume -= instrument->volume_fadeout;
					if(channel->fadeout_volume <= 0) {
						channel->stat = XMCHANNEL_SILENT;
					}
				}
			}
		}
	}

L_EXIT:
	return driver->stat;
}

int
xm_mix(XMDRIVER* driver, short wbuff[/*XMBUFLEN*/])
{
	static int mixbuf[XMBUFLEN]; /* ~LVOobt@Ars`shbłI */
	//
	int i;
	int i_channel;
	int frequency;
	int sample_output;
	int sample_direction;
	int progress;
	int final_volume;
	int period;
	const unsigned char* sample_position;
	const unsigned char* sample_end;
	const unsigned char* sample_loop_start;
	const unsigned char* sample_loop_end;
	XMCHANNEL* channel;
	XMSAMPLE* sample;
	int* p;

	if(driver->stat) goto L_EXIT;

	/* ܂A~LVOobt@NA܂B */
	memset(mixbuf, 0, sizeof mixbuf);

	/* ̊e`lɂ... */
	for(i_channel = 0, channel = driver->channels;
	    i_channel < driver->number_of_channels;
	    i_channel++, channel++) {

		/* SilentȂΔ΂܂B */
		if(!channel->stat) continue;

		/* ̂߁A悭gtB[hoĂ܂B
		 * ̃tB[h́AƂŏ߂Kv܂B
		 */
		sample_position = channel->sample_position;
		sample_output = channel->sample_output;
		progress = channel->progress;

		/* {[߂܂B */
		final_volume = (driver->global_volume         *	/*                       0` 64 ( 6bit) */
				channel->volume               *	/*                       0` 64 ( 6bit) */
				channel->envelope_volume      *	/*                       0` 64 ( 6bit) */
				(channel->fadeout_volume >>  8)	/*   0`65536 (16bit) => 0`256 ( 8bit) */
			       )                         >> 16;	/*            (26bit) =>        (10bit) */
		if(!final_volume) continue; /*  */

		/* Đg߂܂B */
		period = channel->period + (channel->finetune << 1);
		frequency = xm_linear_frequency_table[period % (12 * 256)]
						  << (period / (12 * 256));

		sample = channel->playing_sample;
		switch(sample->type & 0x13) {

		case 0x00: /* No loop, 8bit */
			sample_end = sample->sample_end;
			for(i = 0, p = mixbuf; i < XMBUFLEN; i++, p++) {
				progress += frequency;
				while(progress >= SPEAKER_FREQUENCY) {
					progress -= SPEAKER_FREQUENCY;
					sample_output += LEBYTE(sample_position) << 8; /* D31:16͕s */
					sample_position += 1;
					if(sample_position >= sample_end) {
						channel->stat = XMCHANNEL_SILENT;
						goto L_NEXT;
					}
				}
				*p += (short)sample_output * final_volume;
			}
			break;

		case 0x10: /* No loop, 16bit */
			sample_end = sample->sample_end;
			for(i = 0, p = mixbuf; i < XMBUFLEN; i++, p++) {
				progress += frequency;
				while(progress >= SPEAKER_FREQUENCY) {
					progress -= SPEAKER_FREQUENCY;
					sample_output += LEHALF(sample_position); /* D31:16͕s */
					sample_position += 2;
					if(sample_position >= sample_end) {
						channel->stat = XMCHANNEL_SILENT;
						goto L_NEXT;
					}
				}
				*p += (short)sample_output * final_volume;
			}
			break;

		case 0x01: /* Forward loop, 8bit */
			sample_loop_end = sample->sample_loop_end;
			for(i = 0, p = mixbuf; i < XMBUFLEN; i++, p++) {
				progress += frequency;
				while(progress >= SPEAKER_FREQUENCY) {
					progress -= SPEAKER_FREQUENCY;
					sample_output += LEBYTE(sample_position) << 8; /* D31:16͕s */
					sample_position += 1;
					if(sample_position >= sample_loop_end) {
						sample_position = sample->sample_loop_start;
						sample_output = sample->sample_loop_output;
					}
				}
				*p += (short)sample_output * final_volume;
			}
			break;

		case 0x11: /* Forward loop, 16bit */
			sample_loop_end = sample->sample_loop_end;
			for(i = 0, p = mixbuf; i < XMBUFLEN; i++, p++) {
				progress += frequency;
				while(progress >= SPEAKER_FREQUENCY) {
					progress -= SPEAKER_FREQUENCY;
					sample_output += LEHALF(sample_position); /* D31:16͕s */
					sample_position += 2;
					if(sample_position >= sample_loop_end) {
						sample_position = sample->sample_loop_start;
						sample_output = sample->sample_loop_output;
					}
				}
				*p += (short)sample_output * final_volume;
			}
			break;

		case 0x02: /* Ping-pong loop, 8bit */
			sample_direction = channel->sample_direction; /* o */
			sample_loop_start = sample->sample_loop_start;
			sample_loop_end = sample->sample_loop_end;
			for(i = 0, p = mixbuf; i < XMBUFLEN; i++, p++) {
				progress += frequency;
				while(progress >= SPEAKER_FREQUENCY) {
					progress -= SPEAKER_FREQUENCY;
					if(!sample_direction) {
						sample_output += LEBYTE(sample_position) << 8; /* D31:16͕s */
						sample_position += 1;
						if(sample_position >= sample_loop_end) {
							sample_direction = 1;
						}
					} else {
						sample_position -= 1;
						sample_output -= LEBYTE(sample_position) << 8; /* D31:16͕s */
						if(sample_position <= sample_loop_start) {
							sample_direction = 0;
						}
					}
				}
				*p += (short)sample_output * final_volume;
			}
			channel->sample_direction = sample_direction; /* ߂ */
			break;

		case 0x12: /* Ping-pong loop, 16bit */
			sample_direction = channel->sample_direction; /* o */
			sample_loop_start = sample->sample_loop_start;
			sample_loop_end = sample->sample_loop_end;
			for(i = 0, p = mixbuf; i < XMBUFLEN; i++, p++) {
				progress += frequency;
				while(progress >= SPEAKER_FREQUENCY) {
					progress -= SPEAKER_FREQUENCY;
					if(!sample_direction) {
						sample_output += LEHALF(sample_position); /* D31:16͕s */
						sample_position += 2;
						if(sample_position >= sample_loop_end) {
							sample_direction = 1;
						}
					} else {
						sample_position -= 2;
						sample_output -= LEHALF(sample_position); /* D31:16͕s */
						if(sample_position <= sample_loop_start) {
							sample_direction = 0;
						}
					}
				}
				*p += (short)sample_output * final_volume;
			}
			channel->sample_direction = sample_direction; /* ߂ */
			break;
		}
L_NEXT:
		/* otB[h߂܂B */
		channel->sample_position = sample_position;
		channel->sample_output = sample_output;
		channel->progress = progress;
	}

	/* ~LVOobt@NbsOāAo̓obt@֏݂܂B */
	for(i = 0, p = mixbuf; i < XMBUFLEN; i++, p++, wbuff++) {
		/*   final_volume      (10bit)
		 * x sample_output     (16bit)
		 * x max_channels(=32) ( 5bit)
		 * ---------------------------
		 *                     (31bit)
		 */
		sample_output = *p >> ((31 - 16) - 4/**/);
		if(sample_output < -32767) sample_output = -32767;
		if(sample_output >  32767) sample_output =  32767;
		*wbuff = sample_output;
	}

L_EXIT:
	return driver->stat;
}

