;
;	framw65a.s
;
;	P/ECE W65C02 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun Apr 10 06:09:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clipw65a.h"
;
;	clipw65a.h
;
;	P/ECE W65C02 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun Apr 10 06:09:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;

; clipw65a.sAframw65a.sɃCN[hĎg܂B

;****************************************************************************
;	W65C02\
;****************************************************************************

				; typedef struct _W65C02 {
;#define _A_		 0	; 	unsigned char a;	/* + 0,1          AAAAAAAA */
;#define C		 1	; 	unsigned char c;	/* + 1,1          -------C */
;#define _NZ_		 2	; 	unsigned short nz;	/* + 2,2 N------- NZZZZZZZ */
;#define DI		 4	; 	unsigned char di;	/* + 4,1          ----DI-- */
;#define V		 5	; 	unsigned char v;	/* + 5,1          V------- */
;#define _Y_		 6	; 	unsigned char y;	/* + 6,1          YYYYYYYY */
;#define _X_		 7	; 	unsigned char x;	/* + 7,1          XXXXXXXX */
;#define _PC_		 8	; 	unsigned short pc;	/* + 8,2 PCPCPCPC PCPCPCPC */
;#define _S_		10	; 	unsigned char s;	/* +10,1          SSSSSSSS */
;#define WI		11	; 	unsigned char wi;	/* +11,1          ------WI */
;#define _CYCLE_		12	; 	int cycle;		/* +12,4 cTCN    */
;#define SIZEOF_W65C02	16	; } W65C02;			/* =16 */

;#define CA		 0					;* + 0,2 -------C AAAAAAAA */

;* W65C02.wi */
;#define IRQ_BIT		 0	; IRQtÕrbgʒu
;#define WAI_BIT		 1	; WAItÕrbgʒu

;****************************************************************************
;	WX^蓖
;****************************************************************************

;#define addr	r0	; ݂̖߂AddressModeAAhXێ܂B
			; AddressMode()ݒ肵AAction()QƂ܂B
			; Operation()Ȃ̃[`́AƂĎgpsłB(O)
			; AddressMode𔺂Ȃ߂ɂẮA[NWX^ƂĎgp\łB
;#define data	r1	; ݂̖߂֓nf[^A߂̖߂f[^ێ܂B
			; ǂݍ݂𔺂߂̏ꍇAAction()ݒ肵AOperation()QƂ܂B
			; ݂𔺂߂̏ꍇAOperation()ݒ肵AAction()QƂ܂B
			; ǂݏȂ߂ɂẮA[NWX^ƂĎgp\łB
;#define pseq	r2	; ݂̖߂ɑΉw65c02seqGg̑|C^łB
			; w65c02_run()Aw65c02_run()Action()gp܂B
			; AddressMode()AOperation()Ȃ̃[`́AgpsłB
;#define s0	r3	; ėp[NWX^łB
			; ꎞIɎsReLXg𔲂ĂAlێ܂B
;#define A	r4	; AWX^̒lێ܂B($00..$FF)
;#define Y	r5	; XWX^̒lێ܂B($00..$FF)
;#define X	r6	; YWX^̒lێ܂B($00..$FF)
;#define NZ	r7	; P(N,~Z)\lێ܂B(N------- NZZZZZZZ)
			; P(N)=NZ[15]|NZ[7], P(Z)=(NZ[6:0]==0?1:0)
;		r8	; 
;		r9	; 
;#define PC	r10	; PCWX^̒lێ܂B($0000..$FFFF)
;#define S	r11	; SWX^̒lێ܂B($00..$FF)
;#define t0	r12	; ėp[NWX^łB
			; ꎞIɎsReLXg𔲂ƁAl͔j󂳂܂B
;#define t1	r13	; ėp[NWX^łB
			; ꎞIɎsReLXg𔲂ƁAl͔j󂳂܂B
;#define CPU	r14	; w65c02\̂̐擪AhXێ܂B
;#define CYCLE	r15	; csTCNێ܂B

;****************************************************************************
;	
;****************************************************************************

;* W65C02_TRACEV{`ƁAg[Xo͂s܂B */
;/#define W65C02_TRACE

;****************************************************************************
;	
;****************************************************************************

; ̂߁AW65C02\̂RAMɔzu܂B
; RAM֔zu邽߂ɁA.codeZNVƂ܂B
	.code
	.align	2
	.global	w65c02
w65c02:
	.space	16

;****************************************************************************
;	
;****************************************************************************

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

; sReLXg֓܂B
; [in]
;	܂B
; [out]
;	K̃WX^ݒ肵܂B
; [use]
;	K̃WX^ݒ肷邱ƈȊÓASWX^ۑ܂B
; [note]
;	* sReLXgÔ݌Ăяo\łB
;	  ̃[`ĂяoƁAsReLXg֓܂B
;
	.global	w65c02_enter
w65c02_enter:
	ext	w65c02+0x0@h	; 	xld.w	%r14  , w65c02
	ext	w65c02+0x0@m
	ld.w	%r14,w65c02+0x0@l
	ld.ub	%r4,[%r14]	; 	xld.ub	%r4    , [%r14+0x0    ]
	ext	0x6		; 	xld.ub	%r5    , [%r14+0x6    ]
	ld.ub	%r5,[%r14]
	ext	0x7		; 	xld.ub	%r6    , [%r14+0x7    ]
	ld.ub	%r6,[%r14]
	ext	0x2		; 	xld.uh	%r7   , [%r14+0x2   ]
	ld.uh	%r7,[%r14]
	ext	0x8		; 	xld.uh	%r10   , [%r14+0x8   ]
	ld.uh	%r10,[%r14]
	ext	0xa		; 	xld.ub	%r11    , [%r14+0xa    ]
	ld.ub	%r11,[%r14]
	ext	0xc		; 	xld.w	%r15, [%r14+0xc]
	ld.w	%r15,[%r14]
	ret

; sReLXg𔲂܂B
; [in]
;	K̃WX^ݒ肳Ă邱ƁB
; [out]
;	܂B
; [use]
;	SWX^ۑ܂B
; [note]
;	* sReLXĝ݌Ăяo\łB
;	  ̃[`ĂяoƁAsReLXg𔲂܂B
;
	.global	w65c02_leave
w65c02_leave:
	ld.b	[%r14],%r4	; 	xld.b	[%r14+0x0    ], %r4
	ext	0x6		; 	xld.b	[%r14+0x6    ], %r5
	ld.b	[%r14],%r5
	ext	0x7		; 	xld.b	[%r14+0x7    ], %r6
	ld.b	[%r14],%r6
	ext	0x2		; 	xld.h	[%r14+0x2   ], %r7
	ld.h	[%r14],%r7
	ext	0x8		; 	xld.h	[%r14+0x8   ], %r10
	ld.h	[%r14],%r10
	ext	0xa		; 	xld.b	[%r14+0xa    ], %r11
	ld.b	[%r14],%r11
	ext	0xc		; 	xld.w	[%r14+0xc], %r15
	ld.w	[%r14],%r15
	ret

;****************************************************************************
;	sReLXgO痘p֐
;****************************************************************************

	.global	w65c02_run
w65c02_run:
	pushn	%r3
	;
	ext	w65c02+0xc@ah	; 	xld.w	[w65c02+0xc], %r12		; Kv!!
	ext	w65c02+0xc@al
	ld.w	[%r8],%r12
	call	w65c02_enter	; 	xcall	w65c02_enter			; sReLXg֓܂B
	;
	ext	0xb		; 	xbtst	[%r14+0xb], 0x1		; WAIȂ΁AcsTCN0ɂāAɃ[v𔲂܂B
	btst	[%r14],0x1
	jreq	2				; (w65c02.cycle=0Ŋ֐𔲂邱ƁBK{!!)
	ld.w	%r15, 0			; (skip?)
	;
	jp	w65c02_run_LOOP	; 	xjp	w65c02_run_LOOP			; sTCN0w肳ꂽꍇ̂߂ɁA܂肩B
w65c02_run_DO:
;----------------------------------------------------------------------------
;#ifdef W65C02_TRACE
;	; g[XfobOsꍇ́ÃubNLɂĂB
;	; ̍ہAw65c02_trace()́AAvP[VɂĒ`ĂB
;	; w65c02_trace()́ACuł͒`Ă܂B
;	xcall  w65c02_leave
;	xcall  w65c02_trace
;	xcall  w65c02_enter
;#endif /*W65C02_TRACE*/
;----------------------------------------------------------------------------
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = OpCode = [PC]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			; *delay*
	add	%r10, 1				; PC++
	sll	%r1,0x4		; 	xsll	%r1, 4			; %pseq = &w65c02seq[OpCode].cycle
	ext	w65c02seq+0x3@ah
	ext	w65c02seq+0x3@al
	add	%r2, %r1
	ld.ub	%r12, [%r2]+			; %t0   = TCN
	ld.w	%r13, [%r2]+			; %t1   = Action or Operation
	call.d	%r13
	sub	%r15, %r12			; csTCN -= TCN *delay*
w65c02_run_LOOP:
	cmp	%r15,0x0	; 	xcmp	%r15, 0			; csTCN0ȉɂȂ܂ŌJԂ܂B
	jrgt	w65c02_run_DO	; 	xjrgt	w65c02_run_DO
	;
	call	w65c02_leave	; 	xcall	w65c02_leave			; sReLXg𔲂܂B
	;
	popn	%r3
	ret

;****************************************************************************
;	sReLXg痘p֐
;****************************************************************************

	.global	w65c02_push
w65c02_push:
	pushn	%r0				; Kv!!
	ext	0x100		; 	xoor	%r0, %r11, 0x100		; %addr = $100|S
	or	%r0,%r11
	ext	w65c02_write@rm	; 	xcall.d	w65c02_write			; [%addr] = %data
	call.d	w65c02_write@rl
	sub	%r11, 1				; S-- ($ffffffff,$00..$fe) *delay*
	popn	%r0				; Kv!!
	ret.d
	ld.ub	%r11, %r11				;     (      $ff,$00..$fe) *delay*

	.global	w65c02_pull
w65c02_pull:
	pushn	%r0				; Kv!!
	add	%r11,0x1	; 	xadd	%r11, %r11, 1			; S++ ($01..$ff,$100)
	ext	0x100		; 	xoor	%r0, %r11, 0x100		; %addr = $100|S
	or	%r0,%r11
	ext	w65c02_read@rm	; 	xcall	w65c02_read			; %data = [%addr]
	call	w65c02_read@rl
	popn	%r0				; Kv!!
	ret.d
	ld.ub	%r11, %r11				;     ($01..$ff, $00) *delay*

;****************************************************************************
;	Action
;****************************************************************************

	.global	w65c02_acc
w65c02_acc:
	ld.w	%r12, [%r2]			; %t0   = Operation
	call.d	%r12				; %data = Operation(data)
	ld.w	%r1, %r4			; %data = A			*delay*
	ret.d
	ld.w	%r4, %r1			; %A    = data			*delay*

	.global	w65c02_imm
w65c02_imm:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = imm = [PC]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			;				*delay*
	add	%r10, 1				; PC++
	ld.w	%r12, [%r2]			; %t0   = Operation
	jp	%r12				;         Operation(data)

	.global	w65c02_r
w65c02_r:
	ld.w	%r12, [%r2]+			; %t0   = AddressMode
	call	%r12				; %addr = AddressMode()
	ext	w65c02_read@rm	; 	xcall	w65c02_read			; %data = [addr]
	call	w65c02_read@rl
	ld.w	%r12, [%r2]			; %t0   = Operation
	jp	%r12				;         Operation(data)

	.global	w65c02_w
w65c02_w:
	ld.w	%r12, [%r2]+			; %t0    = AddressMode
	call	%r12				; %addr  = AddressMode()
	ld.w	%r12, [%r2]			; %t0    = Operation
	call	%r12				; %data  = Operation()
	ext	w65c02_write@rm	; 	xjp	w65c02_write			; [addr] = data
	jp	w65c02_write@rl

	.global	w65c02_rw
w65c02_rw:
	ld.w	%r12, [%r2]+			; %t0    = AddressMode
	call	%r12				; %addr  = AddressMode()
	ext	w65c02_read@rm	; 	xcall	w65c02_read			; %data  = [addr]
	call	w65c02_read@rl
	ld.w	%r12, [%r2]			; %t0    = Operation
	call	%r12				; %data  = Operation(data)
	ext	w65c02_write@rm	; 	xjp	w65c02_write			; [addr] = data
	jp	w65c02_write@rl

	.global	w65c02_bbr
	.global	w65c02_beq
w65c02_bbr:
	call	w65c02_zp	; 	xcall	w65c02_zp			; %addr   =  zp
	ext	w65c02_read@rm	; 	xcall	w65c02_read			; %data   = [zp]
	call	w65c02_read@rl
w65c02_beq:
	ld.w	%r12,[%r2]	; 	xld.w	%r12, [%r2]			; %t0     = Operation
	call	%r12				; %psr(Z) = Operation()
	jreq	w65c02_bcond	; 	xjreq	w65c02_bcond			; if Z then branch taken
	ret.d
	add	%r10, 1				; Skip rel			*delay*

	.global	w65c02_bbs
	.global	w65c02_bne
w65c02_bbs:
	call	w65c02_zp	; 	xcall	w65c02_zp			; %addr   =  zp
	ext	w65c02_read@rm	; 	xcall	w65c02_read			; %data   = [zp]
	call	w65c02_read@rl
w65c02_bne:
	ld.w	%r12,[%r2]	; 	xld.w	%r12, [%r2]			; %t0     = Operation
	call	%r12				; %psr(Z) = Operation()
	jrne	w65c02_bcond	; 	xjrne	w65c02_bcond			; if !Z then branch taken
	ret.d
	add	%r10, 1				; Skip rel			*delay*

	.global	w65c02_bcond
	.global	w65c02_bra
w65c02_bcond:
	sub	%r15, 1			; More 1 cycle
w65c02_bra:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = rel = [PC]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			;				*delay*
	add	%r10, 1				; PC++
	ld.b	%r1, %r1			; %data =   }rel
	add	%r10, %r1			; %PC   = PC}rel
	ret.d
	ld.uh	%r10, %r10			; ($0000..$FFFF)		*delay*

	.global	w65c02_jmp
w65c02_jmp:
	ld.w	%r12, [%r2]			; %t0   = AddressMode
	call	%r12				; %addr = AddressMode()
	ret.d
	ld.w	%r10, %r0			; %PC   = addr			*delay*

	.global	w65c02_jsr
w65c02_jsr:
	ld.w	%r12, [%r2]			; %t0   = AddressMode
	call	%r12				; %addr = AddressMode()
	sub	%r10, 1				; PC-- (dl)
	ld.w	%r1, %r10
	call.d	w65c02_push	; 	xcall.d	w65c02_push			; Push HI(PC)
	srl	%r1, 8			;				*delay*
	call.d	w65c02_push	; 	xcall.d	w65c02_push			; Push LO(PC)
	ld.ub	%r1, %r10			;				*delay*
	ret.d
	ld.w	%r10, %r0			; %PC   = addr			*delay*

;****************************************************************************
;	AddressMode
;****************************************************************************

	.global	w65c02_zp
w65c02_zp:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = zp = [PC]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			;				*delay*
	add	%r10, 1				; PC++
	ret.d
	ld.w	%r0, %r1			; %addr = zp			*delay*

	.global	w65c02_zp_x
w65c02_zp_x:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = zp = [PC]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			;				*delay*
	add	%r10, 1				; PC++
	add	%r1, %r6			; %data = zp+X
	ret.d
	ld.ub	%r0, %r1			; %addr = zp+X ($00..$FF)	*delay*

	.global	w65c02_zp_y
w65c02_zp_y:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = zp = [PC]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			;				*delay*
	add	%r10, 1				; PC++
	add	%r1, %r5			; %data = zp+Y
	ret.d
	ld.ub	%r0, %r1			; %addr = zp+Y ($00..$FF)	*delay*

	.global	w65c02_a
w65c02_a:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [PC+0]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			; %addr =  PC+0			*delay*
	ld.w	%r3, %r1			; %s0   = [PC+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =        [PC+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =         PC+1		*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =        [PC+1]<<8
	or	%r3, %r1			; %s0   = [PC+0]|[PC+1]<<8
	add	%r10, 2				; PC+=2
	ret.d
	ld.w	%r0, %r3			; %addr = a			*delay*

	.global	w65c02_a_x
w65c02_a_x:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [PC+0]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			; %addr =  PC+0			*delay*
	ld.w	%r3, %r1			; %s0   = [PC+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =        [PC+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =         PC+1		*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =        [PC+1]<<8
	or	%r3, %r1			; %s0   = [PC+0]|[PC+1]<<8
	add	%r10, 2				; PC+=2
	add	%r3, %r6				; %s0   = a+X
	ret.d
	ld.uh	%r0, %r3			; %addr = a+X ($0000..$FFFF)	*delay*

	.global	w65c02_a_y
w65c02_a_y:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [PC+0]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			; %addr =  PC+0			*delay*
	ld.w	%r3, %r1			; %s0   = [PC+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =        [PC+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =         PC+1		*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =        [PC+1]<<8
	or	%r3, %r1			; %s0   = [PC+0]|[PC+1]<<8
	add	%r10, 2				; PC+=2
	add	%r3, %r5				; %s0   = a+Y
	ret.d
	ld.uh	%r0, %r3			; %addr = a+Y ($0000..$FFFF)	*delay*

	.global	w65c02_IzpI
w65c02_IzpI:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =  zp = [PC]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			; *delay*
	add	%r10, 1				; PC++
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [zp+0]
	call.d	w65c02_read@rl
	ld.w	%r0, %r1			; %addr =  zp+0			*delay*
	ld.w	%r3, %r1			; %s0   = [zp+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =        [zp+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =         zp+1		*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =        [zp+1]<<8
	or	%r3, %r1			; %s0   = [zp+0]|[zp+1]<<8
	ret.d
	ld.w	%r0, %r3			; %addr = (zp)			*delay*

	.global	w65c02_Izp_xI
w65c02_Izp_xI:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =  zp = [PC]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			;				*delay*
	add	%r10, 1				; PC++
	add	%r1, %r6			; %data =  zp+X
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [zp+X+0]
	call.d	w65c02_read@rl
	ld.ub	%r0, %r1			; %addr =  zp+X ($00..$FF)	*delay*
	ld.w	%r3, %r1			; %s0   = [zp+X+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =          [zp+X+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =           zp+X+1	*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =          [zp+X+1]<<8
	or	%r3, %r1			; %s0   = [zp+X+0]|[zp+X+1]<<8
	ret.d
	ld.w	%r0, %r3			; %addr = (zp+X)		*delay*

	.global	w65c02_IzpI_y
w65c02_IzpI_y:
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =  zp = [PC]
	call.d	w65c02_read@rl
	ld.w	%r0, %r10			;				*delay*
	add	%r10, 1				; PC++
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data = [zp+0]
	call.d	w65c02_read@rl
	ld.w	%r0, %r1			; %addr =  zp+0			*delay*
	ld.w	%r3, %r1			; %s0   = [zp+0]
	ext	w65c02_read@rm	; 	xcall.d	w65c02_read			; %data =        [zp+1]
	call.d	w65c02_read@rl
	add	%r0, 1			; %addr =         zp+1		*delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data =        [zp+1]<<8
	or	%r3, %r1			; %s0   = [zp+0]|[zp+1]<<8
	add	%r3, %r5				; %s0   = (zp)+Y
	ret.d
	ld.uh	%r0, %r3			; %addr = (zp)+Y ($0000..$FFFF)	*delay*

;****************************************************************************
;	Operation
;****************************************************************************

	.global	w65c02_LDA
w65c02_LDA:
	ld.w	%r4, %r1
	ret.d
	ld.w	%r7, %r4				; *delay*

	.global	w65c02_LDX
w65c02_LDX:
	ld.w	%r6, %r1
	ret.d
	ld.w	%r7, %r6				; *delay*

	.global	w65c02_LDY
w65c02_LDY:
	ld.w	%r5, %r1
	ret.d
	ld.w	%r7, %r5				; *delay*

;----------------------------------------------------------------------------

	.global	w65c02_STA
w65c02_STA:
	ret.d
	ld.w	%r1, %r4			; *delay*

	.global	w65c02_STX
w65c02_STX:
	ret.d
	ld.w	%r1, %r6			; *delay*

	.global	w65c02_STY
w65c02_STY:
	ret.d
	ld.w	%r1, %r5			; *delay*

	.global	w65c02_STZ
w65c02_STZ:
	ret.d
	ld.w	%r1, 0			; *delay*

;----------------------------------------------------------------------------

	.global	w65c02_TXA
w65c02_TXA:
	ld.w	%r4, %r6
	ret.d
	ld.w	%r7, %r4				; *delay*

	.global	w65c02_TAX
w65c02_TAX:
	ld.w	%r6, %r4
	ret.d
	ld.w	%r7, %r6				; *delay*

	.global	w65c02_TYA
w65c02_TYA:
	ld.w	%r4, %r5
	ret.d
	ld.w	%r7, %r4				; *delay*

	.global	w65c02_TAY
w65c02_TAY:
	ld.w	%r5, %r4
	ret.d
	ld.w	%r7, %r5				; *delay*

	.global	w65c02_TSX
w65c02_TSX:
	ld.w	%r6, %r11
	ret.d
	ld.w	%r7, %r6				; *delay*

	.global	w65c02_TXS
w65c02_TXS:
	ret.d
	ld.w	%r11, %r6				; *delay*
	; no P affected

;----------------------------------------------------------------------------

	.global	w65c02_PHA
w65c02_PHA:
	ext	w65c02_push@rm	; 	xjp.d	w65c02_push			; Push A
	jp.d	w65c02_push@rl
	ld.w	%r1, %r4			; *delay*

	.global	w65c02_PHX
w65c02_PHX:
	ext	w65c02_push@rm	; 	xjp.d	w65c02_push			; Push X
	jp.d	w65c02_push@rl
	ld.w	%r1, %r6			; *delay*

	.global	w65c02_PHY
w65c02_PHY:
	ext	w65c02_push@rm	; 	xjp.d	w65c02_push			; Push Y
	jp.d	w65c02_push@rl
	ld.w	%r1, %r5			; *delay*

	.global	w65c02_PHP
w65c02_PHP:
	ext	w65c02_get_p@rm	; 	xcall	w65c02_get_p			; Push P (NV11DIZC)
	call	w65c02_get_p@rl
	ext	w65c02_push@rm	; 	xjp	w65c02_push
	jp	w65c02_push@rl

	.global	w65c02_PLA
w65c02_PLA:
	ext	w65c02_pull@rm	; 	xcall	w65c02_pull			; Pull A
	call	w65c02_pull@rl
	ld.w	%r4, %r1
	ret.d
	ld.w	%r7, %r4				; *delay*

	.global	w65c02_PLX
w65c02_PLX:
	ext	w65c02_pull@rm	; 	xcall	w65c02_pull			; Pull X
	call	w65c02_pull@rl
	ld.w	%r6, %r1
	ret.d
	ld.w	%r7, %r6				; *delay*

	.global	w65c02_PLY
w65c02_PLY:
	ext	w65c02_pull@rm	; 	xcall	w65c02_pull			; Pull Y
	call	w65c02_pull@rl
	ld.w	%r5, %r1
	ret.d
	ld.w	%r7, %r5				; *delay*

	.global	w65c02_PLP
w65c02_PLP:
	ext	w65c02_pull@rm	; 	xcall	w65c02_pull			; Pull P (NV??DIZC)
	call	w65c02_pull@rl
	ext	w65c02_set_p@rm	; 	xcall	w65c02_set_p
	call	w65c02_set_p@rl
	ext	w65c02_check_pending@rm	; 	xjp	w65c02_check_pending		; ۗĂIRQv𒲂ׂ܂B
	jp	w65c02_check_pending@rl

;----------------------------------------------------------------------------

	.global	w65c02_ADC
w65c02_ADC:
	ext	0x4		; 	xbtst	[%r14+0x4], 0x3			; if D then ADCD
	btst	[%r14],0x3
	ext	w65c02_ADCD@rm	; 	xjrne	w65c02_ADCD
	jrne	w65c02_ADCD@rl
	;
	ld.w	%r12, %r4				; %t0 = A+data+C
	ext	0x1		; 	xbtst	[%r14+0x1], 0x0
	btst	[%r14],0x0
	jreq.d	3
	add	%r12, %r1			; *delay*
	add	%r12, 1				; (skip?)
	;
	ld.h	[%r14],%r12	; 	xld.h	[%r14+0x0], %r12			; C = (A+data+C)[8]
	;
	xor	%r1, %r4			; %data =  (A^data)
	not	%r1, %r1			; %data = ~(A^data)
	xor	%r4, %r12				; %A    =           (A^(A+data+C))
	and	%r1, %r4			; %data = ~(A^data)&(A^(A+data+C))
	ext	0x5		; 	xld.b	[%r14+0x5], %r1			; V     = ~(A^data)&(A^(A+data+C))[7]
	ld.b	[%r14],%r1
	;
	ld.ub	%r4, %r12				; %A = A+data+C ($00..$FF)
	ret.d
	ld.w	%r7, %r4				; *delay*

	.global	w65c02_SBC
w65c02_SBC:
	ext	0x4		; 	xbtst	[%r14+0x4], 0x3			; if D then SBCD
	btst	[%r14],0x3
	ext	w65c02_SBCD@rm	; 	xjrne	w65c02_SBCD
	jrne	w65c02_SBCD@rl
	;
	ld.w	%r12, %r4				; %t0 = A-data-~C
	ext	0x1		; 	xbtst	[%r14+0x1], 0x0
	btst	[%r14],0x0
	jrne.d	3
	sub	%r12, %r1			; *delay*
	sub	%r12, 1				; (skip?)
	;
	not	%r13, %r12			; C = ~(A-data-~C)[8]
	ld.h	[%r14],%r13	; 	xld.h	[%r14+0x0], %r13
	;
	xor	%r1, %r4			; %data = (A^data)
	xor	%r4, %r12				; %A    =          (A^(A-data-~C))
	and	%r1, %r4			; %data = (A^data)&(A^(A-data-~C))
	ext	0x5		; 	xld.b	[%r14+0x5], %r1			; V     = (A^data)&(A^(A-data-~C))[7]
	ld.b	[%r14],%r1
	;
	ld.ub	%r4, %r12				; %A = A-data-~C ($00..$FF)
	ret.d
	ld.w	%r7, %r4				; *delay*

	.global	w65c02_CMP
w65c02_CMP:
	ld.w	%r7, %r4				; %NZ = A-data
	sub	%r7, %r1
	not	%r12, %r7			; C = ~(A-data)[8]
	ld.h	[%r14],%r12	; 	xld.h	[%r14+0x0], %r12
	ret.d
	ld.ub	%r7, %r7			; Kv!! *delay*

	.global	w65c02_CPX
w65c02_CPX:
	ld.w	%r7, %r6				; %NZ = X-data
	sub	%r7, %r1
	not	%r12, %r7			; C = ~(X-data)[8]
	ld.h	[%r14],%r12	; 	xld.h	[%r14+0x0], %r12
	ret.d
	ld.ub	%r7, %r7			; Kv!! *delay*

	.global	w65c02_CPY
w65c02_CPY:
	ld.w	%r7, %r5				; %NZ = Y-data
	sub	%r7, %r1
	not	%r12, %r7			; C = ~(Y-data)[8]
	ld.h	[%r14],%r12	; 	xld.h	[%r14+0x0], %r12
	ret.d
	ld.ub	%r7, %r7			; Kv!! *delay*

;----------------------------------------------------------------------------

	.global	w65c02_INC
w65c02_INC:
	add	%r1,0x1		; 	xadd	%r1, %r1, 1
	ld.ub	%r1, %r1			; Kv!!
	ret.d
	ld.w	%r7, %r1			; *delay*

	.global	w65c02_INX
w65c02_INX:
	add	%r6,0x1		; 	xadd	%r6, %r6, 1
	ld.ub	%r6, %r6				; Kv!!
	ret.d
	ld.w	%r7, %r6				; *delay*

	.global	w65c02_INY
w65c02_INY:
	add	%r5,0x1		; 	xadd	%r5, %r5, 1
	ld.ub	%r5, %r5				; Kv!!
	ret.d
	ld.w	%r7, %r5				; *delay*

	.global	w65c02_DEC
w65c02_DEC:
	sub	%r1,0x1		; 	xsub	%r1, %r1, 1
	ld.ub	%r1, %r1			; Kv!!
	ret.d
	ld.w	%r7, %r1			; *delay*

	.global	w65c02_DEX
w65c02_DEX:
	sub	%r6,0x1		; 	xsub	%r6, %r6, 1
	ld.ub	%r6, %r6				; Kv!!
	ret.d
	ld.w	%r7, %r6				; *delay*

	.global	w65c02_DEY
w65c02_DEY:
	sub	%r5,0x1		; 	xsub	%r5, %r5, 1
	ld.ub	%r5, %r5				; Kv!!
	ret.d
	ld.w	%r7, %r5				; *delay*

;----------------------------------------------------------------------------

	.global	w65c02_AND
w65c02_AND:
	and	%r4, %r1
	ret.d
	ld.w	%r7, %r4				; *delay*

	.global	w65c02_ORA
w65c02_ORA:
	or	%r4, %r1
	ret.d
	ld.w	%r7, %r4				; *delay*

	.global	w65c02_EOR
w65c02_EOR:
	xor	%r4, %r1
	ret.d
	ld.w	%r7, %r4				; *delay*

	.global	w65c02_ASL
w65c02_ASL:
	sll	%r1,0x1		; 	xsll	%r1, 1			; %data = -------7 6543210-
	ld.h	[%r14],%r1	; 	xld.h	[%r14+0x0], %r1		;                +------------> C
	ld.ub	%r1, %r1			; %data = -------- 6543210-
	ret.d
	ld.w	%r7, %r1			; *delay*

	.global	w65c02_LSR
w65c02_LSR:
	ext	0x1		; 	xld.b	[%r14+0x1], %r1			; %data = -------- 76543210 +-> C
	ld.b	[%r14],%r1
	srl	%r1,0x1		; 	xsrl	%r1, 1			; %data = -------- -7654321
	ret.d
	ld.w	%r7, %r1			; *delay *

	.global	w65c02_ROL
w65c02_ROL:
	ext	0x1		; 	xld.ub	%r12, [%r14+0x1]			; %t0   = -------- -------C
	ld.ub	%r12,[%r14]
	and	%r12,0x1	; 	xand	%r12, %r12, 1
	sll	%r1,0x1		; 	xsll	%r1, 1			; %data = -------7 6543210-
	ld.h	[%r14],%r1	; 	xld.h	[%r14+0x0], %r1		;                +------------> C
	ld.ub	%r1, %r1			; %data = -------- 6543210-
	or	%r1, %r12			; %data = -------- 6543210C
	ret.d
	ld.w	%r7, %r1			; *delay*

	.global	w65c02_ROR
w65c02_ROR:
	ext	0x1		; 	xld.ub	%r12, [%r14+0x1]			; %t0   = -------- -------C
	ld.ub	%r12,[%r14]
	and	%r12,0x1	; 	xand	%r12, %r12, 1
	sll	%r12,0x7	; 	xsll	%r12, 7				; %t0   = -------- C-------
	ext	0x1		; 	xld.b	[%r14+0x1], %r1			; %data = -------- 76543210 +-> C
	ld.b	[%r14],%r1
	srl	%r1,0x1		; 	xsrl	%r1, 1			; %data = -------- -7654321
	or	%r1, %r12			; %data = -------- C7654321
	ret.d
	ld.w	%r7, %r1			; *delay*

	.global	w65c02_BIT
w65c02_BIT:
	ld.w	%r7, %r1			; V   =          V-------
	sll	%r7,0x1		; 	xsll	%r7, 1				;                +-------- (  data)[6]
	ext	0x5		; 	xld.b	[%r14+0x5], %r7			; %NZ = N------- NZZZZZZZ
	ld.b	[%r14],%r7
	sll	%r7,0x7		; 	xsll	%r7, 7				;       |        ++++++++- (A&data)
	and	%r1, %r4			;       |        +-------- (A&data)[7]
	ret.d					;       +----------------- (  data)[7]
	or	%r7, %r1			; *delay*

;----------------------------------------------------------------------------

	.global	w65c02_CLC
w65c02_CLC:
	ext	0x1		; 	xbclr	[%r14+0x1], 0x0
	bclr	[%r14],0x0
	ret

	.global	w65c02_SEC
w65c02_SEC:
	ext	0x1		; 	xbset	[%r14+0x1], 0x0
	bset	[%r14],0x0
	ret

;----------------------------------------------------------------------------

	.global	w65c02_BCC
w65c02_BCC:
	.global	w65c02_BCS
w65c02_BCS:
	ext	0x1		; 	xbtst	[%r14+0x1], 0x0
	btst	[%r14],0x0
	ret

	.global	w65c02_BEQ
w65c02_BEQ:
	.global	w65c02_BNE
w65c02_BNE:
	ext	0xff		; 	xand	%r9, %r7, 0xff
	and	%r9,%r7
	ret

	.global	w65c02_BPL
w65c02_BPL:
	.global	w65c02_BMI
w65c02_BMI:
	ext	0x4		; 	xand	%r9, %r7, 0x8080
	ext	0x80
	and	%r9,%r7
	ret

	.global	w65c02_BVC
w65c02_BVC:
	.global	w65c02_BVS
w65c02_BVS:
	ext	0x5		; 	xbtst	[%r14+0x5], 0x7
	btst	[%r14],0x7
	ret

;----------------------------------------------------------------------------

	.global	w65c02_RTS
w65c02_RTS:
	ext	w65c02_pull@rm	; 	xcall	w65c02_pull			; Pull LO(PC)
	call	w65c02_pull@rl
	ext	w65c02_pull@rm	; 	xcall.d	w65c02_pull			; Pull HI(PC)
	call.d	w65c02_pull@rl
	ld.w	%r10, %r1			; *delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %PC = PC
	or	%r10, %r1
	ret.d
	add	%r10, 1				; PC++ (dl) *delay*

;****************************************************************************
;	
;****************************************************************************
