;	
;	framtiaa.s
;
;	P/ECE TIA (Television Interface Adapter) Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Fri Mar 11 03:00:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
;#define TIA_DEFINE_OFFSET
;#include "cliptiaa.h"
;/	
;/	cliptiaa.h
;/
;/	P/ECE TIA (Television Interface Adapter) Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2005 Naoyuki Sawa
;/
;/	* Fri Mar 11 03:00:00 JST 2005 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define TIA_ASM

;* cliptiaa.sAframtiaa.sincludê݁Aȉ̒`Lɂ܂B */
;#ifdef TIA_DEFINE_OFFSET
;****************************************************************************
;	
;****************************************************************************

;#define TIA_CLOCK	((68+160)*(3+37+192+30)*60)	; -> cliptia.h
;#define VCS_CLOCK	(TIA_CLOCK/3)			; -> cliptia.h
;#define TIABUFLEN		320			; -> cliptia.h
;#define TIA_VOLUME_SHIFT	((16-6)+1)		; -> cliptia.c
;#define SPEAKER_FREQUENCY	16000			; -> clipmisc.h

;-----------------------------------------------; typedef struct _TIA {
;#define NOW			  0		; 	int now;				/* +  0, 4: TIANbNJE^ (N̒ʎZ) */
;#define LAST_X			  4		; 	int last_x;				/* +  4, 4: XVJnXW (0..(  68+160   -1)) */
;#define LAST_Y			  8		; 	int last_y;				/* +  8, 4:             Y     (0..(3+37+192+30-1)) */
;#define SCAN_X			 12		; 	int scan_x;				/* + 12, 4: ݂̑XW (0..(  68+160   -1)) */
;#define SCAN_Y			 16		; 	int scan_y;				/* + 16, 4:             Y     (0..(3+37+192+30-1)) */
;#define CLUT			 20		; 	unsigned char clut[4];			/* + 20, 4: [0]=COLUP0, [1]=COLUP1, [2]=COLUPF, [3]=COLUBK */
;#define COLLISION		 24		; 	unsigned short collision;		/* + 24, 2: D01=M0-P1  (CXM0P [7]), D00=M0-P0  (CXM0P [6]) */
						; 						/*          D03=M1-P0  (CXM1P [7]), D02=M1-P1  (CXM1P [6]) */
						; 						/*          D05=P0-PF  (CXP0FB[7]), D04=P0-BL  (CXP0FB[6]) */
						; 						/*          D07=P1-PF  (CXP1FB[7]), D06=P1-BL  (CXP1FB[6]) */
						; 						/*          D09=M0-PF  (CXM0FB[7]), D08=M0-BL  (CXM0FB[6]) */
						; 						/*          D11=M1-PF  (CXM1FB[7]), D10=M1-BL  (CXM1FB[6]) */
						; 						/*          D13=BL-PF  (CXBLPF[7]), D12=unused (CXBLPF[6]) */
						; 						/*          D15=P0-P1  (CXPPMM[7]), D14=M0-M1  (CXPPMM[6]) */
;#define I4			 26		; 	unsigned char i4;			/* + 26, 1: INPT4̓̓|[g (1=Hi=Off,0=Lo=On) */
;#define I5			 27		; 	unsigned char i5;			/* + 27, 1: INPT5̓̓|[g (1=Hi=Off,0=Lo=On) */
;#define VBUFF			 28		; 	unsigned char* vbuff/*[160*192]*/;	/* + 28, 4: zʃobt@ (O`Atia_reset()Ŏw) */
						; 
						;	unsigned char _resv[24];		/* + 32,24: */
						; 
						;	/*{{movable objects*/
;#define PLAYER			 56		;	TIAPLAYER player[2];			/* + 56,16: Player0, Player1 */
;#define MISSILE			 72		;	TIAMISSILE missile[2];			/* + 72, 8: Missile0, Missile1 */
;#define BALL			 80		;	TIABALL ball;				/* + 80, 8: Ball */
;#define PLAYFIELD		 88		;	TIAPLAYFIELD playfield;			/* + 88, 8: Playfield */
						;	/*}}movable objects*/
						; 
						;	/*{{AUDIO==========*/
;#define AUDIO			 96		;	TIAAUDIO audio[2];			/* + 96,32: Audio circuits */
						;	/*}}AUDIO==========*/
						; 
						; 	/*{{݃WX^*/
;#define VSYNC			128		; 	unsigned char VSYNC;			// +128, 1: $00  VSYNC   0000 00x0  vertical sync set-clear
;#define VBLANK			129		; 	unsigned char VBLANK;			// +129, 1: $01  VBLANK  xx00 00x0  vertical blank set-clear
						; 	//unsigned char WSYNC;			//          $02  WSYNC   ---- ----  wait for leading edge of horizontal blank
						; 	//unsigned char RSYNC;			//          $03  RSYNC   ---- ----  reset horizontal sync counter
;#define NUSIZ0			130		; 	unsigned char NUSIZ0;			// +130, 1: $04  NUSIZ0  00xx 0xxx  number-size player-missile 0
;#define NUSIZ1			131		; 	unsigned char NUSIZ1;			// +131, 1: $05  NUSIZ1  00xx 0xxx  number-size player-missile 1
;#define COLUP0			132		; 	unsigned char COLUP0;			// +132, 1: $06  COLUP0  xxxx xxx0  color-lum player 0
;#define COLUP1			133		; 	unsigned char COLUP1;			// +133, 1: $07  COLUP1  xxxx xxx0  color-lum player 1
;#define COLUPF			134		; 	unsigned char COLUPF;			// +134, 1: $08  COLUPF  xxxx xxx0  color-lum playfield
;#define COLUBK			135		; 	unsigned char COLUBK;			// +135, 1: $09  COLUBK  xxxx xxx0  color-lum background
;#define CTRLPF			136		; 	unsigned char CTRLPF;			// +136, 1: $0A  CTRLPF  00xx 0xxx  control playfield ball size & collisions
;#define REFP0			137		; 	unsigned char REFP0;			// +137, 1: $0B  REFP0   0000 x000  reflect player 0
;#define REFP1			138		; 	unsigned char REFP1;			// +138, 1: $0C  REFP1   0000 x000  reflect player 1
;#define PF0			139		; 	unsigned char PF0;			// +139, 1: $0D  PF0     xxxx 0000  playfield register byte 0
;#define PF1			140		; 	unsigned char PF1;			// +140, 1: $0E  PF1     xxxx xxxx  playfield register byte 1
;#define PF2			141		; 	unsigned char PF2;			// +141, 1: $0F  PF2     xxxx xxxx  playfield register byte 2
						; 	//unsigned char RESP0;			//          $10  RESP0   ---- ----  reset player 0
						; 	//unsigned char RESP1;			//          $11  RESP1   ---- ----  reset player 1
						; 	//unsigned char RESM0;			//          $12  RESM0   ---- ----  reset missile 0
						; 	//unsigned char RESM1;			//          $13  RESM1   ---- ----  reset missile 1
						; 	//unsigned char RESBL;			//          $14  RESBL   ---- ----  reset ball
;#define AUDC0			142		; 	unsigned char AUDC0;			// +142, 1: $15  AUDC0   0000 xxxx  audio control 0
;#define AUDC1			143		; 	unsigned char AUDC1;			// +143, 1: $16  AUDC1   0000 xxxx  audio control 1
;#define AUDF0			144		; 	unsigned char AUDF0;			// +144, 1: $17  AUDF0   000x xxxx  audio frequency 0
;#define AUDF1			145		; 	unsigned char AUDF1;			// +145, 1: $18  AUDF1   000x xxxx  audio frequency 1
;#define AUDV0			146		; 	unsigned char AUDV0;			// +146, 1: $19  AUDV0   0000 xxxx  audio volume 0
;#define AUDV1			147		; 	unsigned char AUDV1;			// +147, 1: $1A  AUDV1   0000 xxxx  audio volume 1
						; 	//unsigned char GRP0;			//          $1B  GRP0    xxxx xxxx  graphics player 0
						; 	//unsigned char GRP1;			//          $1C  GRP1    xxxx xxxx  graphics player 1
;#define ENAM0			148		; 	unsigned char ENAM0;			// +148, 1: $1D  ENAM0   0000 00x0  graphics (enable) missile 0
;#define ENAM1			149		; 	unsigned char ENAM1;			// +149, 1: $1E  ENAM1   0000 00x0  graphics (enable) missile 1
;#define ENABL			150		; 	unsigned char ENABL;			// +150, 1: $1F  ENABL   0000 00x0  graphics (enable) ball
;#define HMP0			151		; 	unsigned char HMP0;			// +151, 1: $20  HMP0    xxxx 0000  horizontal motion player 0
;#define HMP1			152		; 	unsigned char HMP1;			// +152, 1: $21  HMP1    xxxx 0000  horizontal motion player 1
;#define HMM0			153		; 	unsigned char HMM0;			// +153, 1: $22  HMM0    xxxx 0000  horizontal motion missile 0
;#define HMM1			154		; 	unsigned char HMM1;			// +154, 1: $23  HMM1    xxxx 0000  horizontal motion missile 1
;#define HMBL			155		; 	unsigned char HMBL;			// +155, 1: $24  HMBL    xxxx 0000  horizontal motion ball
						; 	//unsigned char VDELP0;			//          $25  VDELP0  0000 000x  vertical delay player 0
						; 	//unsigned char VDELP1;			//          $26  VDELP1  0000 000x  vertical delay player 1
						; 	//unsigned char VDELBL;			//          $27  VDELBL  0000 000x  vertical delay ball
;#define RESMP0			156		; 	unsigned char RESMP0;			// +156, 1: $28  RESMP0  0000 00x0  reset missile 0 to player 0
;#define RESMP1			157		; 	unsigned char RESMP1;			// +157, 1: $29  RESMP1  0000 00x0  reset missile 1 to player 1
						; 	//unsigned char HMOVE;			//          $2A  HMOVE   ---- ----  apply horizontal motion
						; 	//unsigned char HMCLR;			//          $2B  HMCLR   ---- ----  clear horizontal motion registers
						; 	//unsigned char CXCLR;			//          $2C  CXCLR   ---- ----  clear collision latches
						; 	/*}}݃WX^*/
						; 
						; 	/*{{ǂݏoWX^*/
						; 	//unsigned char CXM0P;			//          $0   CXM0P   xx00 0000  read collision M0-P1 M0-P0
						; 	//unsigned char CXM1P;			//          $1   CXM1P   xx00 0000  read collision M1-P0 M1-P1
						; 	//unsigned char CXP0FB;			//          $2   CXP0FB  xx00 0000  read collision P0-PF P0-BL
						; 	//unsigned char CXP1FB;			//          $3   CXP1FB  xx00 0000  read collision P1-PF P1-BL
						; 	//unsigned char CXM0FB;			//          $4   CXM0FB  xx00 0000  read collision M0-PF M0-BL
						; 	//unsigned char CXM1FB;			//          $5   CXM1FB  xx00 0000  read collision M1-PF M1-BL
						; 	//unsigned char CXBLPF;			//          $6   CXBLPF  x000 0000  read collision BL-PF unused
						; 	//unsigned char CXPPMM;			//          $7   CXPPMM  xx00 0000  read collision P0-P1 M0-M1
;#define INPT0			158		; 	unsigned char INPT0;			// +158, 1: $8   INPT0   x000 0000  read pot port
;#define INPT1			159		; 	unsigned char INPT1;			// +159, 1: $9   INPT1   x000 0000  read pot port
;#define INPT2			160		; 	unsigned char INPT2;			// +160, 1: $A   INPT2   x000 0000  read pot port
;#define INPT3			161		; 	unsigned char INPT3;			// +161, 1: $B   INPT3   x000 0000  read pot port
;#define INPT4			162		; 	unsigned char INPT4;			// +162, 1: $C   INPT4   x000 0000  read input
;#define INPT5			163		; 	unsigned char INPT5;			// +163, 1: $D   INPT5   x000 0000  read input
						; 	/*}}ǂݏoWX^*/
;-----------------------------------------------; } TIA;					// =164
						; #define SIZEOF_TIA				    164 /* tia_reset()ɃTCY܂ */

;-----------------------------------------------; typedef struct _TIAPLAYER {
;#define PLAYER0_POSITION	(PLAYER+0+0)	; 	unsigned char position;			/* +0,1: 0..159 */
;#define PLAYER0_SIZE		(PLAYER+0+1)	; 	unsigned char size;			/* +1,1: 0=x, 1=x_x, 2=x___x, 3=x_x_x, 4=x_______x, 5=XX, 6=x___x___x, 7=XXXX */
;#define PLAYER0_REFLECT		(PLAYER+0+2)	; 	unsigned char reflect;			/* +2,1: 0=no reflect, 1=reflect */
;#define PLAYER0_DELAY		(PLAYER+0+3)	; 	unsigned char delay;			/* +3,1: 0=no delay, 1=delay */
;#define PLAYER0_GRAPHICS	(PLAYER+0+4)	; 	unsigned char graphics[2];		/* +4,2: 8bit graphics ([0]=no delay, [1]=delay) */
						; 	unsigned char _resv[2];			/* +6,2: (\) */
;-----------------------------------------------; } TIAPLAYER;					/* =8 */

;-----------------------------------------------; typedef struct _TIAPLAYER {
;#define PLAYER1_POSITION	(PLAYER+8+0)	; 	unsigned char position;			/* +0,1: 0..159 */
;#define PLAYER1_SIZE		(PLAYER+8+1)	; 	unsigned char size;			/* +1,1: 0=x, 1=x_x, 2=x___x, 3=x_x_x, 4=x_______x, 5=XX, 6=x___x___x, 7=XXXX */
;#define PLAYER1_REFLECT		(PLAYER+8+2)	; 	unsigned char reflect;			/* +2,1: 0=no reflect, 1=reflect */
;#define PLAYER1_DELAY		(PLAYER+8+3)	; 	unsigned char delay;			/* +3,1: 0=no delay, 1=delay */
;#define PLAYER1_GRAPHICS	(PLAYER+8+4)	; 	unsigned char graphics[2];		/* +4,2: 8bit graphics ([0]=no delay, [1]=delay) */
						; 	unsigned char _resv[2];			/* +6,2: (\) */
;-----------------------------------------------; } TIAPLAYER;					/* =8 */

;-----------------------------------------------; typedef struct _TIAMISSILE {
;#define MISSILE0_POSITION	(MISSILE+0+0)	; 	unsigned char position;			/* +0,1: 0..159 */
;#define MISSILE0_SIZE		(MISSILE+0+1)	; 	unsigned char size;			/* +1,1: 0=1clock, 1=2clock, 2=4clock, 3=8clock */
;#define MISSILE0_RESET		(MISSILE+0+2)	; 	unsigned char reset;			/* +2,1: 0=no missile-player reset, 1=missile-player reset */
;#define MISSILE0_GRAPHICS	(MISSILE+0+3)	; 	unsigned char graphics;			/* +3,1: 0=disable, 1=enable */
;-----------------------------------------------; } TIAMISSILE;					/* =4 */

;-----------------------------------------------; typedef struct _TIAMISSILE {
;#define MISSILE1_POSITION	(MISSILE+4+0)	; 	unsigned char position;			/* +0,1: 0..159 */
;#define MISSILE1_SIZE		(MISSILE+4+1)	; 	unsigned char size;			/* +1,1: 0=1clock, 1=2clock, 2=4clock, 3=8clock */
;#define MISSILE1_RESET		(MISSILE+4+2)	; 	unsigned char reset;			/* +2,1: 0=no missile-player reset, 1=missile-player reset */
;#define MISSILE1_GRAPHICS	(MISSILE+4+3)	; 	unsigned char graphics;			/* +3,1: 0=disable, 1=enable */
;-----------------------------------------------; } TIAMISSILE;					/* =4 */

;-----------------------------------------------; typedef struct _TIABALL {
;#define BALL_POSITION		(BALL+0)	; 	unsigned char position;			/* +0,1: 0..159 */
;#define BALL_SIZE		(BALL+1)	; 	unsigned char size;			/* +1,1: 0=1clock, 1=2clock, 2=4clock, 3=8clock */
;#define BALL_DELAY		(BALL+2)	; 	unsigned char delay;			/* +2,1: 0=no delay, 1=delay */
;#define BALL_GRAPHICS		(BALL+3)	; 	unsigned char graphics[2];		/* +3,2: 0=disable, 1=enable ([0]=no delay, [1]=delay) */
						; 	unsigned char _resv[3];			/* +5,3: (\) */
;-----------------------------------------------; } TIABALL;					/* =8 */

;-----------------------------------------------; typedef struct _TIAPLAYFIELD {
;#define PLAYFIELD_REFLECT	(PLAYFIELD+0)	; 	unsigned char reflect;			/* +0,1: 0=no relfect, 1=reflect */
						; 	unsigned char _resv[3];			/* +1,3: (\) */
;#define PLAYFIELD_GRAPHICS	(PLAYFIELD+4)	; 	unsigned int graphics;			/* +4,4: 20bit graphics */
;-----------------------------------------------; } TIAPLAYFIELD;				/* =8 */

;-----------------------------------------------; typedef struct _TIAAUDIO {
;#define AUDIO_VOLUME		 0		; 	unsigned char volume;			/* + 0,1: lowest:0..15:highest */
;#define AUDIO_FREQUENCY		 1		; 	unsigned char frequency;		/* + 1,1: frequency divider 1..32 */
						; 	//
;#define AUDIO_POLAR		 2		; 	unsigned char  polar;			/* + 2,1: 0:minus or 1:plus */
;#define AUDIO_DIV31		 3		; 	unsigned char  div31;			/* + 3,1: 30..0, 0or13->pluse */
;#define AUDIO_COUNT		 4		; 	         int   count;			/* + 4,4: frequency counter */
;#define AUDIO_LFSR9		 8		; 	unsigned short lfsr9;			/* + 8,2: 9-bit LFSR (tap=0,5) */
;#define AUDIO_LFSR5		10		; 	unsigned char  lfsr5;			/* +10,1: 5-bit LFSR (tap=0,3) */
;#define AUDIO_LFSR4		11		; 	unsigned char  lfsr4;			/* +11,1: 4-bit LFSR (tap=0,1) */
						; 	//
						; 	unsigned char _resv[4];			/* +12,4: (\) */
;-----------------------------------------------; } TIAAUDIO;					/* =16 */

;****************************************************************************
;	
;****************************************************************************
;#endif /*TIA_DEFINE_OFFSET*/
;#ifdef TIA_ASM

	.code
	.align	1

;****************************************************************************
;	
;****************************************************************************

;
;	int tia_write(int now, int addr, int data)
;
	.global	tia_write
tia_write:
	call.d	tia_scan_progress	; 	xcall.d	tia_scan_progress	; tia_scan_progress(now) (tia_scan_progress()̃AZúA%r13-15j󂵂܂)
	 sll	%r13, 2			; *delay* <----------------------+
	;				;                                |
	ext	0x2		; 	xcmp	%r13, 0xb0		; if(addr*4 > 0x2c*4) goto EXIT  |
	cmp	%r13,0x30
	jrgt	tia_write_EXIT	; 	xjrgt	tia_write_EXIT		;                                |
	;				;                                |
	;sll	%r13, 2			; -------------------------------+
	ext	tia_write_table@ah	; return tia_write_table[addr](data)
	ext	tia_write_table@al
	ld.w	%r13, [%r13]
	ld.w	%r12, %r14		; *anti-interlock*
	jp	%r13			; (jp.dCPUoOɂgps!!)
	;
tia_write_EXIT:
	ret.d				; return 0
	ld.w	%r10, 0

;****************************************************************************
;	
;****************************************************************************

;
;	void tia_scan_progress(int now)
;
; [in]
;	%r12		now
; [use]
;	%r4-7,%r12
; [note]
;	* %r10-11,%r13-15j󂵂܂B
;	- tia_write()tia_read()̃AZúAtia_scan_progress()̃AZu
;	  %r13-15j󂵂ȂƂOƂčĂ܂B(2005/03/22)
;	- Atia_scan_progress()̃AZuύXꍇ́A
;	  %r10-11j󂵂Ă\܂񂪁A%r13-15j󂷂悤ȕύX͂ȂłB
;
	.global	tia_scan_progress
tia_scan_progress:
	ext	tia+0x0@h	; 	xld.w	%r4, tia			; %r4 = p_tia = &tia
	ext	tia+0x0@m
	ld.w	%r4,tia+0x0@l
	ext	0x3		; 	xld.w	%r5, 0xe4			; %r5 = 68/*Hblank*/ + 160
	ld.w	%r5,0x24
	;
	ext	0xc		; 	xld.w	%r6, [%r4+0xc]		; %r6 = scan_x = p_tia->scan_x /* o */
	ld.w	%r6,[%r4]
	;
	ld.w	%r7,[%r4]	; 	xld.w	%r7, [%r4+0x0]			; %r7 = p_tia->now
	ld.w	[%r4],%r12	; 	xld.w	[%r4+0x0], %r12			; p_tia->now = now (Ɋi[Ă܂) *anti-interlock*
	sub	%r12, %r7			; %r12 = (now - p_tia->now)
	ld.w	%r7, %r12			; %r7  = (now - p_tia->now)
	add	%r7, %r7			; %r7  = (now - p_tia->now) * 2
	add	%r7, %r12			; %r7  = (now - p_tia->now) * 3 = clock
	;
	ext	0x3a5		; 	xcmp	%r7, 0xe958		; if(clock > TIA_CLOCK / 60) {
	cmp	%r7,0x18
	jrule	tia_scan_progress_NO_SAFETY	; 	xjrule	tia_scan_progress_NO_SAFETY
	ext	0x3a5		; 	xld.w	%r7, 0xe958		;   clock = TIA_CLOCK / 60
	ld.w	%r7,0x18
tia_scan_progress_NO_SAFETY:			; }
	;
	add	%r6, %r7			; scan_x += clock
	cmp	%r6, %r5			; if(scan_x >= 68/*Hblank*/ + 160) {
	jrlt	tia_scan_progress_NO_HSYNC	; 	xjrlt	tia_scan_progress_NO_HSYNC
	;
	ext	0x10		; 	xld.w	%r7, [%r4+0x10]		;   %r7 = scan_y = p_tia->scan_y; /* o */
	ld.w	%r7,[%r4]
	;
tia_scan_progress_DO_HSYNC:			;   do {
	sub	%r6, %r5			;     scan_x -= 68/*Hblank*/ + 160
	cmp	%r6, %r5			;   } while(scan_x >= 68/*Hblank*/ + 160)
	jrge.d	tia_scan_progress_DO_HSYNC	; 	xjrge.d	tia_scan_progress_DO_HSYNC
	add	%r7, 1				;     scan_y++ *delay*
	;
	ext	0x80		; 	xbtst	[%r4+0x80], 0x1			;   if((p_tia->VSYNC & (1<<1)) &&
	btst	[%r4],0x1
	jreq	tia_scan_progress_NO_VSYNC	; 	xjreq	tia_scan_progress_NO_VSYNC
	ext	0x0		; 	xcmp	%r7, 0x28			;      (scan_y >= (3/*Vsync*/ + 37/*Vblank*/)) {
	cmp	%r7,0x28
	jrlt	tia_scan_progress_NO_VSYNC	; 	xjrlt	tia_scan_progress_NO_VSYNC
	ld.w	%r7,0x0		; 	xld.w	%r7, 0				;              scan_y = 0
	ext	0x4		; 	xld.w	[%r4+0x4], %r7		;       p_tia->last_x = 0
	ld.w	[%r4],%r7
	ext	0x8		; 	xld.w	[%r4+0x8], %r7		;       p_tia->last_y = 0
	ld.w	[%r4],%r7
tia_scan_progress_NO_VSYNC:			;   }
	;
	ext	0x10		; 	xld.w	[%r4+0x10], %r7		;   p_tia->scan_y = scan_y; /* ߂ */
	ld.w	[%r4],%r7
	;
tia_scan_progress_NO_HSYNC:			; }
	;
	ext	0xc		; 	xld.w	[%r4+0xc], %r6		; p_tia->scan_x = scan_x /* ߂ */
	ld.w	[%r4],%r6
	;
	ret

;****************************************************************************
;	
;****************************************************************************

;
;	void tia_partial_update()
;
	.global	tia_partial_update
tia_partial_update:
	pushn	%r3
	;
	ext	tia+0x0@h	; 	xld.w	%r0, tia			; %r0 = p_tia = &tia
	ext	tia+0x0@m
	ld.w	%r0,tia+0x0@l
	ext	0xc		; 	xld.w	%r1, [%r0+0xc]		; %r1 = scan_x = p_tia->scan_x
	ld.w	%r1,[%r0]
	ext	0x10		; 	xld.w	%r2, [%r0+0x10]		; %r2 = scan_y = p_tia->scan_y
	ld.w	%r2,[%r0]
	;
	ext	0x81		; 	xbtst	[%r0+0x81], 0x1			; if(!(p_tia->VBLANK & (1<<1))) { /* Vblank=Off */
	btst	[%r0],0x1
	jrne	tia_partial_update_VBLANK	; 	xjrne	tia_partial_update_VBLANK
	;---------------------------------------;
	ext	0x4		; 	xld.w	%r13, [%r0+0x4]		; %r13 = last_x = p_tia->last_x
	ld.w	%r13,[%r0]
	ext	0x8		; 	xld.w	%r3 , [%r0+0x8]		; %r3  = last_y = p_tia->last_y
	ld.w	%r3,[%r0]
	;
	jp	tia_partial_update_L20	; 	xjp	tia_partial_update_L20		; if(last_y < scan_y) {
tia_partial_update_L10:				;   do {
	ext	0x3		; 	xld.w	%r14, 0xe4
	ld.w	%r14,0x24
	call.d	tia_line_update	; 	xcall.d	tia_line_update			;     tia_line_update(last_y, last_x, 68/*Hblank*/ + 160)
	ld.w	%r12, %r3			;     *delay*
	ld.w	%r13,0x0	; 	xld.w	%r13, 0				;     last_x = 0
	add	%r3,0x1		; 	xadd	%r3, %r3, 1			;     last_y++
tia_partial_update_L20:
	cmp	%r3, %r2			;   } while(last_y < scan_y)
	jrlt	tia_partial_update_L10	; 	xjrlt	tia_partial_update_L10		; }
	;
	ld.w	%r14, %r1
	call.d	tia_line_update	; 	xcall.d	tia_line_update			; tia_line_update(last_y, last_x, scan_x)
	ld.w	%r12, %r3			; *delay*
	;---------------------------------------;
tia_partial_update_VBLANK:
	;
	ext	0x4		; 	xld.w	[%r0+0x4], %r1		; p_tia->last_x = scan_x
	ld.w	[%r0],%r1
	ext	0x8		; 	xld.w	[%r0+0x8], %r2		; p_tia->last_y = scan_y
	ld.w	[%r0],%r2
	;
	popn	%r3
	ret

;****************************************************************************
;	
;****************************************************************************

;
;	void tia_line_update(unsigned y, unsigned x1, unsigned x2)
;
;	%r12	y
;	%r13	x1
;	%r14	x2
;
	.global	tia_line_update
tia_line_update:
	sub	%r12,0x28	; 	xsub	%r12, %r12, 0x28		; y -= (3/*Vsync*/ + 37/*Vblank*/)
	ext	0x2		; 	xcmp	%r12, 191			; if(y > 191) return
	cmp	%r12,0x3f
	ext	tia_line_update_EXIT@rm	; 	xjrugt	tia_line_update_EXIT
	jrugt	tia_line_update_EXIT@rl
	;
	ext	0x1		; 	xsub	%r13, %r13, 68			; x1 -= 68/*Hblank*/
	sub	%r13,0x4
	jruge	2				; if(Carry) x1 = 0
	ld.w	%r13, 0				; (skip?)
	ext	0x1		; 	xsub	%r14, %r14, 68			; x2 -= 68/*Hblank*/
	sub	%r14,0x4
	jruge	2				; if(Carry) x2 = 0
	ld.w	%r14, 0				; (skip?)
	cmp	%r13, %r14			; if(x1 >= x2) return
	ext	tia_line_update_EXIT@rm	; 	xjruge	tia_line_update_EXIT
	jruge	tia_line_update_EXIT@rl
	;---------------------------------------;
	pushn	%r3
	sub	%sp,0x4		; 	xsub	%sp, %sp, 16			; [%sp+ 0].w  = switch(player[0].size)
	;					; [%sp+ 4].w  = switch(player[1].size)
	;					; [%sp+ 8].ub = player[0].position
	;					; [%sp+ 9].ub = player[1].position
	;					; [%sp+10].ub = missile[0].position
	;					; [%sp+11].ub = missile[0].size
	;					; [%sp+12].ub = missile[1].position
	;					; [%sp+13].ub = missile[1].size
	;					; [%sp+14].ub = ball.position
	;					; [%sp+15].ub = ball.size
	;
	ext	tia+0x0@h	; 	xld.w	%r0, tia			; %r0 = p_tia = &tia
	ext	tia+0x0@m
	ld.w	%r0,tia+0x0@l
	;
	ext	0x1c		; 	xld.w	%r1, [%r0+0x1c]		; %r1 = vbuff = p_tia->vbuff
	ld.w	%r1,[%r0]
	sll	%r12,0x5	; 	xsll	%r12, 5				; vbuff += y *  32 ---+
	add	%r1, %r12			;                     |
	sll	%r12,0x2	; 	xsll	%r12, 0x2			; vbuff += y * 128 ---+-- y * 160 + x
	add	%r1, %r12			;                     |
	add	%r1, %r13			; vbuff += x *delay* -+
	ext	0x88		; 	xld.ub	%r12, [%r0+0x88]		; %r12 = CTRLPF (00xx 0xxx)
	ld.ub	%r12,[%r0]
	ext	0x4		; 	xand	%r9, %r12, 0x4
	and	%r9,%r12
	sll	%r9,0x4		; 	xsll	%r9, 0x4
	ext	tia_priority_table@ah		; %r2 = priority = tia_priority_table[CTRLPF[2:PFP]]
	ext	tia_priority_table@al
	add	%r2, %r9
	and	%r12,0x2	; 	xand	%r12, %r12, 0x2		; %r12 = CTRLPF[1:SCORE] ? 2 : -1
	cmp	%r12,0x1	; 	xcmp	%r12, 1				; -+
	sbc	%r12, %r8			; -+- 2s"if(%r12==0) %r12--;"̏łB
	;
	ext	0x18		; 	xld.uh	%r3, [%r0+0x18]		; %r3 = collision = p_tia->collision /* o */
	ld.uh	%r3,[%r0]
	;
	ext	0x3b		; 	xld.ub	%r4, [%r0+0x3b]	; %r4[7:0] = g = player[0].graphics[player[0].delay]
	ld.ub	%r4,[%r0]
	add	%r4, %r0
	ext	0x3c		; 	xld.ub	%r4, [%r4+0x3c]
	ld.ub	%r4,[%r4]
	cmp	%r4,0x0		; 	xcmp	%r4, 0				; if(g) {
	jreq	tia_line_update_NO_PLAYER0	; 	xjreq	tia_line_update_NO_PLAYER0
	ext	0x38		; 	xld.ub	%r9,  [%r0+0x38]	;   %r9  = player[0].position
	ld.ub	%r9,[%r0]
	ext	0x39		; 	xld.ub	%r10, [%r0+0x39]	;   %r10 = player[0].size
	ld.ub	%r10,[%r0]
	ext	0x3a		; 	xbtst	[%r0+0x3a], 0x0	;   if(!player[0].reflect) {
	btst	[%r0],0x0
	jrne.d	3				;     g = mirror(g)
	sll	%r10, 2				;     *delay*
	mirror	%r4, %r4			;   } (skip?)
	ext	tia_line_update_PLAYER0_SWITCH@ah
	ext	tia_line_update_PLAYER0_SWITCH@al
	ld.w	%r10, [%r10]
	ld.b	[%sp+0x8],%r9	; 	xld.b	[%sp+0x8], %r9			;   [%sp+8] = player[0].position
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp+0x0], %r10			;   [%sp+0] = switch(player[0].size)
tia_line_update_NO_PLAYER0:			; }
	;
	ext	0x4b		; 	xbtst	[%r0+0x4b], 0x0	; %r4[31:8] = g = missile[0].graphics && !missile[0].reset
	btst	[%r0],0x0
	jreq	tia_line_update_NO_MISSILE0	; 	xjreq	tia_line_update_NO_MISSILE0
	ext	0x4a		; 	xbtst	[%r0+0x4a], 0x0
	btst	[%r0],0x0
	jrne	tia_line_update_NO_MISSILE0	; 	xjrne	tia_line_update_NO_MISSILE0	; if(g) {
	ext	0x1ffc		; 	xoor	%r4, %r4, -256
	or	%r4,0x0
	ext	0x48		; 	xld.ub	%r9,  [%r0+0x48]	;   [%sp+10] = missile[0].position
	ld.ub	%r9,[%r0]
	ext	0x49		; 	xld.ub	%r10, [%r0+0x49]	;   [%sp+11] = missile[0].size
	ld.ub	%r10,[%r0]
	ld.b	[%sp+0xa],%r9	; 	xld.b	[%sp+0xa], %r9
	ld.b	[%sp+0xb],%r10	; 	xld.b	[%sp+0xb], %r10
tia_line_update_NO_MISSILE0:			; }
	;
	ext	0x43		; 	xld.ub	%r5, [%r0+0x43]	; %r5[7:0] = g = player[1].graphics[player[1].delay]
	ld.ub	%r5,[%r0]
	add	%r5, %r0
	ext	0x44		; 	xld.ub	%r5, [%r5+0x44]
	ld.ub	%r5,[%r5]
	cmp	%r5,0x0		; 	xcmp	%r5, 0				; if(g) {
	jreq	tia_line_update_NO_PLAYER1	; 	xjreq	tia_line_update_NO_PLAYER1
	ext	0x40		; 	xld.ub	%r9,  [%r0+0x40]	;   %r9  = player[1].position
	ld.ub	%r9,[%r0]
	ext	0x41		; 	xld.ub	%r10, [%r0+0x41]	;   %r10 = player[1].size
	ld.ub	%r10,[%r0]
	ext	0x42		; 	xbtst	[%r0+0x42], 0x0	;   if(!player[1].reflect) {
	btst	[%r0],0x0
	jrne.d	3				;     g = mirror(g)
	sll	%r10, 2				;     *delay*
	mirror	%r5, %r5			;   } (skip?)
	ext	tia_line_update_PLAYER1_SWITCH@ah
	ext	tia_line_update_PLAYER1_SWITCH@al
	ld.w	%r10, [%r10]
	ld.b	[%sp+0x9],%r9	; 	xld.b	[%sp+0x9], %r9			;   [%sp+9] = player[1].position
	ld.w	[%sp+0x1],%r10	; 	xld.w	[%sp+0x4], %r10			;   [%sp+4] = switch(player[1].size)
tia_line_update_NO_PLAYER1:			; }
	;
	ext	0x4f		; 	xbtst	[%r0+0x4f], 0x0	; %r5[31:8] = g = missile[1].graphics && !missile[1].reset
	btst	[%r0],0x0
	jreq	tia_line_update_NO_MISSILE1	; 	xjreq	tia_line_update_NO_MISSILE1
	ext	0x4e		; 	xbtst	[%r0+0x4e], 0x0
	btst	[%r0],0x0
	jrne	tia_line_update_NO_MISSILE1	; 	xjrne	tia_line_update_NO_MISSILE1	; if(g) {
	ext	0x1ffc		; 	xoor	%r5, %r5, -256
	or	%r5,0x0
	ext	0x4c		; 	xld.ub	%r9,  [%r0+0x4c]	;   [%sp+12] = missile[1].position
	ld.ub	%r9,[%r0]
	ext	0x4d		; 	xld.ub	%r10, [%r0+0x4d]	;   [%sp+13] = missile[1].size
	ld.ub	%r10,[%r0]
	ld.b	[%sp+0xc],%r9	; 	xld.b	[%sp+0xc], %r9
	ld.b	[%sp+0xd],%r10	; 	xld.b	[%sp+0xd], %r10
tia_line_update_NO_MISSILE1:			; }
	;
	ext	0x52		; 	xld.ub	%r6, [%r0+0x52]		; %r6 = g = ball.graphics[ball.delay]
	ld.ub	%r6,[%r0]
	add	%r6, %r0
	ext	0x53		; 	xld.ub	%r6, [%r6+0x53]
	ld.ub	%r6,[%r6]
	cmp	%r6,0x0		; 	xcmp	%r6, 0				; if(g) {
	jreq	tia_line_update_NO_BALL	; 	xjreq	tia_line_update_NO_BALL
	ext	0x50		; 	xld.ub	%r9,  [%r0+0x50]	;   [%sp+14] = ball.position
	ld.ub	%r9,[%r0]
	ext	0x51		; 	xld.ub	%r10, [%r0+0x51]		;   [%sp+15] = ball.size
	ld.ub	%r10,[%r0]
	ld.b	[%sp+0xe],%r9	; 	xld.b	[%sp+0xe], %r9
	ld.b	[%sp+0xf],%r10	; 	xld.b	[%sp+0xf], %r10
tia_line_update_NO_BALL:			; }
	;
	ext	0x5c		; 	xld.w	%r7, [%r0+0x5c]	; %r7[19: 0] = playfield.graphics
	ld.w	%r7,[%r0]
	ext	0x58		; 	xbtst	[%r0+0x58], 0x0	; %r7[31:20] = playfield.reflect
	btst	[%r0],0x0
	jreq	tia_line_update_NO_PF_REFLECT	; 	xjreq	tia_line_update_NO_PF_REFLECT
	ext	0x1ffe		; 	xoor	%r7, %r7, -1048576
	ext	0x0
	or	%r7,0x0
tia_line_update_NO_PF_REFLECT:
	;
	sub	%r14, %r13			; i = x2 - x1
tia_line_update_DO:				; do {
	;---------------------------------------;
	;	Player0
	;---------------------------------------;
	ext	0xff		; 	xand	%r10, %r4, 0xff		;   %r10 = g = player[0].graphics
	and	%r10,%r4
	jreq.d	tia_line_update_PLAYER0_EXIT	; 	xjreq.d	tia_line_update_PLAYER0_EXIT	;   if(g) {
	ld.w	%r15, 0				;     %r15 = 0 *delay*
	;
	ld.ub	%r9,[%sp+0x8]	; 	xld.ub	%r9, [%sp+0x8]			;     %r11 = x = x1 - player[0].position
	ld.w	%r11, %r13
	sub	%r11, %r9
	ld.w	%r9,[%sp+0x0]	; 	 xld.w	%r9, [%sp+0x0]			;     <-------------------+
	jruge	tia_line_update_PLAYER0_L10	; 	xjruge	tia_line_update_PLAYER0_L10	;     if(Carry) x += 160  |
	ext	0x2		; 	xadd	%r11, %r11, 160			;                         |
	add	%r11,0x20
tia_line_update_PLAYER0_L10:			;                         |
	;					;                         |
	;xld.w	%r9, [%sp+0]			;     ֈړ -----------+
	jp	%r9				;     switch(player[0].size) {
	;
	.align	2 ;(Kv!!)
tia_line_update_PLAYER0_SWITCH:
	.word	tia_line_update_PLAYER0_SIZE0
	.word	tia_line_update_PLAYER0_SIZE1
	.word	tia_line_update_PLAYER0_SIZE2
	.word	tia_line_update_PLAYER0_SIZE3
	.word	tia_line_update_PLAYER0_SIZE4
	.word	tia_line_update_PLAYER0_SIZE5
	.word	tia_line_update_PLAYER0_SIZE6
	.word	tia_line_update_PLAYER0_SIZE7
	;
tia_line_update_PLAYER0_SIZE7:			;     case 7:
	srl	%r11,0x1	; 	xsrl	%r11, 1
	; FALLTHRU
tia_line_update_PLAYER0_SIZE5:			;     case 5:
	cmp	%r11,0x10	; 	xcmp	%r11, 16
	jruge	tia_line_update_PLAYER0_EXIT	; 	xjruge	tia_line_update_PLAYER0_EXIT
	jp.d	tia_line_update_PLAYER0_L20	; 	xjp.d	tia_line_update_PLAYER0_L20
	srl	%r11, 1				;     *delay*
	;
tia_line_update_PLAYER0_SIZE4:			;     case 4:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER0_L20	; 	xjrult	tia_line_update_PLAYER0_L20
	ext	0x1		; 	xsub	%r11, %r11, 64
	sub	%r11,0x0
	jp	tia_line_update_PLAYER0_SIZE0	; 	xjp	tia_line_update_PLAYER0_SIZE0
	;
tia_line_update_PLAYER0_SIZE6:			;     case 6:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER0_L20	; 	xjrult	tia_line_update_PLAYER0_L20
	sub	%r11,0x20	; 	xsub	%r11, %r11, 32
	; FALLTHRU
tia_line_update_PLAYER0_SIZE2:			;     case 2:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER0_L20	; 	xjrult	tia_line_update_PLAYER0_L20
	jp.d	tia_line_update_PLAYER0_SIZE0	; 	xjp.d	tia_line_update_PLAYER0_SIZE0
	sub	%r11, 32			;     *delay*
	;
tia_line_update_PLAYER0_SIZE3:			;     case 3:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER0_L20	; 	xjrult	tia_line_update_PLAYER0_L20
	sub	%r11,0x10	; 	xsub	%r11, %r11, 16
	; FALLTHRU
tia_line_update_PLAYER0_SIZE1:			;     case 1:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER0_L20	; 	xjrult	tia_line_update_PLAYER0_L20
	sub	%r11,0x10	; 	xsub	%r11, %r11, 16
	; FALLTHRU
tia_line_update_PLAYER0_SIZE0:			;     case 0:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jruge	tia_line_update_PLAYER0_EXIT	; 	xjruge	tia_line_update_PLAYER0_EXIT
	; FALLTHRU
tia_line_update_PLAYER0_L20:			;     }
	;
	srl	%r10, %r11			;     %r15 |= (g >> x) & 1 (%r11=0..7Ȃ̂ŁAsrlŏ[)
	and	%r10,0x1	; 	xand	%r10, %r10, 1
	or	%r15, %r10
	;
tia_line_update_PLAYER0_EXIT:			;   }
	;---------------------------------------;
	;	Missile0
	;---------------------------------------;
	cmp	%r4,0x0		; 	xcmp	%r4, 0				;   if(%r4[31:8]) {
	jrge.d	tia_line_update_MISSILE0_EXIT	; 	xjrge.d	tia_line_update_MISSILE0_EXIT
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	ld.ub	%r9,[%sp+0xa]	; 	xld.ub	%r9,  [%sp+0xa]			;     %r9  = missile[0].position
	ld.ub	%r10,[%sp+0xb]	; 	xld.ub	%r10, [%sp+0xb]			;     %r10 = missile[0].size
	;
	ld.w	%r11, %r13			;     %r11 = x = x1 - missile[0].position
	sub	%r11, %r9
	jruge	tia_line_update_MISSILE0_L10	; 	xjruge	tia_line_update_MISSILE0_L10	;     if(Carry) x += 160
	ext	0x2		; 	xadd	%r11, %r11, 160
	add	%r11,0x20
tia_line_update_MISSILE0_L10:
	;
	srl	%r11, %r10			;     %r15 |= !(x >> missile[0].size) (%r10=0..3Ȃ̂ŁAsrlŏ[)
	jrne	tia_line_update_MISSILE0_EXIT	; 	xjrne	tia_line_update_MISSILE0_EXIT
	or	%r15,0x1	; 	xoor	%r15, %r15, 1
	;
tia_line_update_MISSILE0_EXIT:			;   }
	;---------------------------------------;
	;	Player1
	;---------------------------------------;
	ext	0xff		; 	xand	%r10, %r5, 0xff		;   %r10 = g = player[1].graphics
	and	%r10,%r5
	jreq.d	tia_line_update_PLAYER1_EXIT	; 	xjreq.d	tia_line_update_PLAYER1_EXIT	;   if(g) {
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	ld.ub	%r9,[%sp+0x9]	; 	xld.ub	%r9, [%sp+0x9]			;     %r11 = x = x1 - player[1].position
	ld.w	%r11, %r13
	sub	%r11, %r9
	ld.w	%r9,[%sp+0x1]	; 	 xld.w	%r9, [%sp+0x4]			;     <-------------------+
	jruge	tia_line_update_PLAYER1_L10	; 	xjruge	tia_line_update_PLAYER1_L10	;     if(Carry) x += 160  |
	ext	0x2		; 	xadd	%r11, %r11, 160			;                         |
	add	%r11,0x20
tia_line_update_PLAYER1_L10:			;                         |
	;					;                         |
	;xld.w	%r9, [%sp+4]			;     ֈړ -----------+
	jp	%r9				;     switch(player[1].size) {
	;
	.align	2 ;(Kv!!)
tia_line_update_PLAYER1_SWITCH:
	.word	tia_line_update_PLAYER1_SIZE0
	.word	tia_line_update_PLAYER1_SIZE1
	.word	tia_line_update_PLAYER1_SIZE2
	.word	tia_line_update_PLAYER1_SIZE3
	.word	tia_line_update_PLAYER1_SIZE4
	.word	tia_line_update_PLAYER1_SIZE5
	.word	tia_line_update_PLAYER1_SIZE6
	.word	tia_line_update_PLAYER1_SIZE7
	;
tia_line_update_PLAYER1_SIZE7:			;     case 7:
	srl	%r11,0x1	; 	xsrl	%r11, 1
	; FALLTHRU
tia_line_update_PLAYER1_SIZE5:			;     case 5:
	cmp	%r11,0x10	; 	xcmp	%r11, 16
	jruge	tia_line_update_PLAYER1_EXIT	; 	xjruge	tia_line_update_PLAYER1_EXIT
	jp.d	tia_line_update_PLAYER1_L20	; 	xjp.d	tia_line_update_PLAYER1_L20
	srl	%r11, 1				;     *delay*
	;
tia_line_update_PLAYER1_SIZE4:			;     case 4:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER1_L20	; 	xjrult	tia_line_update_PLAYER1_L20
	ext	0x1		; 	xsub	%r11, %r11, 64
	sub	%r11,0x0
	jp	tia_line_update_PLAYER1_SIZE0	; 	xjp	tia_line_update_PLAYER1_SIZE0
	;
tia_line_update_PLAYER1_SIZE6:			;     case 6:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER1_L20	; 	xjrult	tia_line_update_PLAYER1_L20
	sub	%r11,0x20	; 	xsub	%r11, %r11, 32
	; FALLTHRU
tia_line_update_PLAYER1_SIZE2:			;     case 2:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER1_L20	; 	xjrult	tia_line_update_PLAYER1_L20
	jp.d	tia_line_update_PLAYER1_SIZE0	; 	xjp.d	tia_line_update_PLAYER1_SIZE0
	sub	%r11, 32			;     *delay*
	;
tia_line_update_PLAYER1_SIZE3:			;     case 3:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER1_L20	; 	xjrult	tia_line_update_PLAYER1_L20
	sub	%r11,0x10	; 	xsub	%r11, %r11, 16
	; FALLTHRU
tia_line_update_PLAYER1_SIZE1:			;     case 1:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jrult	tia_line_update_PLAYER1_L20	; 	xjrult	tia_line_update_PLAYER1_L20
	sub	%r11,0x10	; 	xsub	%r11, %r11, 16
	; FALLTHRU
tia_line_update_PLAYER1_SIZE0:			;     case 0:
	cmp	%r11,0x8	; 	xcmp	%r11, 8
	jruge	tia_line_update_PLAYER1_EXIT	; 	xjruge	tia_line_update_PLAYER1_EXIT
	; FALLTHRU
tia_line_update_PLAYER1_L20:			;     }
	;
	srl	%r10, %r11			;     %r15 |= (g >> x) & 1 (%r11=0..7Ȃ̂ŁAsrlŏ[)
	and	%r10,0x1	; 	xand	%r10, %r10, 1
	or	%r15, %r10
	;
tia_line_update_PLAYER1_EXIT:			;   }
	;---------------------------------------;
	;	Missile1
	;---------------------------------------;
	cmp	%r5,0x0		; 	xcmp	%r5, 0				;   if(%r5[31:8]) {
	jrge.d	tia_line_update_MISSILE1_EXIT	; 	xjrge.d	tia_line_update_MISSILE1_EXIT
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	ld.ub	%r9,[%sp+0xc]	; 	xld.ub	%r9,  [%sp+0xc]			;     %r9  = missile[1].position
	ld.ub	%r10,[%sp+0xd]	; 	xld.ub	%r10, [%sp+0xd]			;     %r10 = missile[1].size
	;
	ld.w	%r11, %r13			;     %r11 = x = x1 - missile[1].position
	sub	%r11, %r9
	jruge	tia_line_update_MISSILE1_L10	; 	xjruge	tia_line_update_MISSILE1_L10	;     if(Carry) x += 160
	ext	0x2		; 	xadd	%r11, %r11, 160
	add	%r11,0x20
tia_line_update_MISSILE1_L10:
	;
	srl	%r11, %r10			;     %r15 |= !(x >> missile[1].size) (%r10=0..3Ȃ̂ŁAsrlŏ[)
	jrne	tia_line_update_MISSILE1_EXIT	; 	xjrne	tia_line_update_MISSILE1_EXIT
	or	%r15,0x1	; 	xoor	%r15, %r15, 1
	;
tia_line_update_MISSILE1_EXIT:			;   }
	;---------------------------------------;
	;	Ball
	;---------------------------------------;
	cmp	%r6,0x0		; 	xcmp	%r6, 0				;   if(%r6) {
	jreq.d	tia_line_update_BALL_EXIT	; 	xjreq.d	tia_line_update_BALL_EXIT
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	ld.ub	%r9,[%sp+0xe]	; 	xld.ub	%r9,  [%sp+0xe]			;     %r9  = ball.position
	ld.ub	%r10,[%sp+0xf]	; 	xld.ub	%r10, [%sp+0xf]			;     %r10 = ball.size
	;
	ld.w	%r11, %r13			;     %r11 = x = x1 - ball.position
	sub	%r11, %r9
	jruge	tia_line_update_BALL_L10	; 	xjruge	tia_line_update_BALL_L10	;     if(Carry) x += 160
	ext	0x2		; 	xadd	%r11, %r11, 160
	add	%r11,0x20
tia_line_update_BALL_L10:
	;
	srl	%r11, %r10			;     %r15 |= !(x >> ball.size) (%r10=0..3Ȃ̂ŁAsrlŏ[)
	jrne	tia_line_update_BALL_EXIT	; 	xjrne	tia_line_update_BALL_EXIT
	or	%r15,0x1	; 	xoor	%r15, %r15, 1
	;
tia_line_update_BALL_EXIT:			;   }
	;---------------------------------------;
	;	Playfield
	;---------------------------------------;
	ext	0x7f		; 	xand	%r10, %r7, 0xfffff		;   %r10 = g = playfield.graphics
	ext	0x1fff
	and	%r10,%r7
	jreq.d	tia_line_update_PLAYFIELD_EXIT	; 	xjreq.d	tia_line_update_PLAYFIELD_EXIT	;   if(g) {
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	ld.w	%r11, %r13			;     %r11 = x = x1 >> 2
	srl	%r11,0x2	; 	xsrl	%r11, 2
	;
	sub	%r11,0x14	; 	xsub	%r11, %r11, 20			;     x -= 20
	jrult	tia_line_update_PLAYFIELD_L10	; 	xjrult	tia_line_update_PLAYFIELD_L10	;     if(Carry) x = 19-(x+20) = -1-x = -(x+ 1) = ~(x+ 1)+1 = ~((x+ 1)-1) = ~(x   )
	cmp	%r7,0x0		; 	xcmp	%r7, 0				;     if(!playfield.reflect) {
	jrlt	tia_line_update_PLAYFIELD_L20	; 	xjrlt	tia_line_update_PLAYFIELD_L20	;               x = 39-(x+20) = 19-x = -(x-19) = ~(x-19)+1 = ~((x-19)-1) = ~(x-20)
	sub	%r11,0x14	; 	xsub	%r11, %r11, 20			;     }
tia_line_update_PLAYFIELD_L10:
	not	%r11, %r11
tia_line_update_PLAYFIELD_L20:
	;
	;xsrl	%r10, %r11			;     %r15 |= (g >> x) & 1 (%r11=0..19Ȃ̂ŁAxsrlKv!!)
	;* "xsrl %rd,%rs"ext33̎WJɔCƁA璷ŒxR[hɓWJĂ܂܂B
	;  %rd%rsʃWX^ŁA%rsj\ŁA%rs0..23͈̔͂ł邱Ƃ킩ĂȂ΁A
	;  Ƃňȉ̂悤ɓWJ邱ƂɂAext33̎WJR[hł܂B
	;- ̏ꏊł́A%r11͈̔͂0..19ł邱Ƃ킩Ă̂ŁA̕@Kp\łB
	;  Ȃȉ̂悤ɓWJł邩ɂẮAq̐QƂĂB
	;- - - - - - - - - - - - - - - - - - - -;
	cmp	%r11, 8				;
	jrle.d	6				; --------+
	srl	%r10, %r11			; *delay* |
	sub	%r11, 8				; (skip?) |
	srl	%r10, %r11			; (skip?) |
	and	%r11, 8				; (skip?) |
	srl	%r10, %r11			; (skip?) V
	;- - - - - - - - - - - - - - - - - - - -;
	and	%r10,0x1	; 	xand	%r10, %r10, 1
	or	%r15, %r10
	;
tia_line_update_PLAYFIELD_EXIT:			;   }
	;---------------------------------------;
	ld.w	%r9, %r15			;   collision |= tia_collision_table[v]
	sll	%r9,0x1		; 	xsll	%r9, 1
	;ext	tia_collision_table@ah		;   ֈړ܂ ------------------+
	;ext	tia_collision_table@al		;   ֈړ܂ ------------------+
	;xld.uh	%r9, [%r9]			;   ֈړ܂ ------------------+
	;or	%r3, %r9			;   ֈړ܂ ------------------|--+
	;					;                                      |  |
	add	%r15, %r2			;   v = priority[v]                    |  |
	ld.ub	%r15, [%r15]			;                                      |  |
	 ext	tia_collision_table@ah		;   *anti-interlock* <-----------------+  |
	 ext	tia_collision_table@al		;   *anti-interlock* <-----------------+  |
	ld.uh	%r9,[%r9]	; 	 xld.uh	%r9, [%r9]			;   *anti-interlock* <-----------------+  |
	cmp	%r15, %r12			;   if(CTRLPF[1:SCORE] && (v == 2)) {     |
	jrne.d	tia_line_update_NO_SCORE	; 	xjrne.d	tia_line_update_NO_SCORE	;                                         |
	 or	%r3, %r9			;     *delay* <---------------------------+
	ext	0x1		; 	xcmp	%r13, 80			;     v = (x1 < 80) ? 0 : 1
	cmp	%r13,0x10
	ld.w	%r15,0x1	; 	xld.w	%r15, 1
	sbc	%r15, %r8
tia_line_update_NO_SCORE:			;   }
	ext	tia+0x14@ah			;   *vbuff++ = p_tia->clut[v]
	ext	tia+0x14@al
	ld.ub	%r15, [%r15]
	sub	%r14,0x1	; 	 xsub	%r14, %r14, 1			;   *anti-interlock* <------------+
	ld.b	[%r1]+, %r15			;                                 |
	;---------------------------------------;                                 |
	;xsub	%r14, %r14, 1			; } while(--i) ֈړ܂ --+
	ext	tia_line_update_DO@rm	; 	xjrne.d	tia_line_update_DO
	jrne.d	tia_line_update_DO@rl
	add	%r13, 1				; x1++ *delay*
	;
	ext	0x18		; 	xld.h	[%r0+0x18], %r3		; p_tia->collision = collision /* ߂ */
	ld.h	[%r0],%r3
	;
	add	%sp,0x4		; 	xadd	%sp, %sp, 16
	popn	%r3
	;---------------------------------------;
tia_line_update_EXIT:
	ret

;****************************************************************************
;	
;****************************************************************************

	.global	tia_reduce
tia_reduce:
	ext	tia_div3_table+0x0@h	; 	xld.w	%r9, tia_div3_table		; ̃[`ŁA%r9j󂷂g߂gȂ悤AӂĂ!!
	ext	tia_div3_table+0x0@m
	ld.w	%r9,tia_div3_table+0x0@l
	;
	ld.w	%r10,0x8	; 	xld.w	%r10, 8				; z = 8
tia_reduce_DO_Z:				; do {
	;
	ld.w	%r11,0xb	; 	xld.w	%r11, 11			;   y = 11
	ld.w	%r15,0x4	; 	xld.w	%r15, 4				;   i = 4
tia_reduce_DO_Y:				;   do {
	;
	ext	0x0		; 	xld.w	%r14, 32			;     x = 32
	ld.w	%r14,0x20
	sub	%r15,0x1	; 	xsub	%r15, %r15, 1			;     if(!--i) {
	jrne	tia_reduce_DO_X1	; 	xjrne	tia_reduce_DO_X1
	;---------------------------------------;
tia_reduce_DO_X0:				;       do {
	ext	0x140		; 	xld.ub	%r4, [%r13+0x140]			;         %r4    =                                      src[320]
	ld.ub	%r4,[%r13]
	ext	0xa0		; 	xld.ub	%r5, [%r13+0xa0]			;         %r5    =                           src[160]
	ld.ub	%r5,[%r13]
	 ld.ub	%r6, [%r13]+			;         %r6    =                  src[0]
	add	%r4, %r5			;         %r4    =                           src[160] + src[320]
	add	%r4, %r6			;         %r4    =                  src[0] + src[160] + src[320]
	add	%r4, %r9			;         %r4    = &tia_div3_table[(src[0] + src[160] + src[320])];
	ld.ub	%r4, [%r4]			;         %r4    =  tia_div3_table[(src[0] + src[160] + src[320])];
	ld.b	[%r12]+, %r4			;         dst[0] =  tia_div3_table[(src[0] + src[160] + src[320])];
	;
	ext	0x140		; 	xld.ub	%r4, [%r13+0x140]			;         %r4    =                                      src[321]
	ld.ub	%r4,[%r13]
	ext	0xa0		; 	xld.ub	%r5, [%r13+0xa0]			;         %r5    =                           src[161]
	ld.ub	%r5,[%r13]
	 ld.ub	%r6, [%r13]+			;         %r6    =                  src[1]
	add	%r4, %r5			;         %r4    =                           src[161] + src[321]
	add	%r4, %r6			;         %r4    =                  src[1] + src[161] + src[321]
	add	%r4, %r9			;         %r4    = &tia_div3_table[(src[1] + src[161] + src[321])];
	ld.ub	%r4, [%r4]			;         %r4    =  tia_div3_table[(src[1] + src[161] + src[321])];
	ld.b	[%r12]+, %r4			;         dst[1] =  tia_div3_table[(src[1] + src[161] + src[321])];
	;
	ext	0x140		; 	xld.ub	%r4, [%r13+0x140]			;         %r4    =                                      src[322]
	ld.ub	%r4,[%r13]
	ext	0xa0		; 	xld.ub	%r5, [%r13+0xa0]			;         %r5    =                           src[162]
	ld.ub	%r5,[%r13]
	 ld.ub	%r6, [%r13]+			;         %r6    =                  src[2]
	add	%r4, %r5			;         %r4    =                           src[162] + src[322]
	add	%r4, %r6			;         %r4    =                  src[2] + src[162] + src[322]
	add	%r4, %r9			;         %r4    = &tia_div3_table[(src[2] + src[162] + src[322])];
	ld.ub	%r4, [%r4]			;         %r4    =  tia_div3_table[(src[2] + src[162] + src[322])];
	ld.b	[%r12]+, %r4			;         dst[2] =  tia_div3_table[(src[2] + src[162] + src[322])];
	;
	ext	0x140		; 	xld.ub	%r4, [%r13+0x140]			;         %r4    =                                      src[323]
	ld.ub	%r4,[%r13]
	ext	0xa0		; 	xld.ub	%r5, [%r13+0xa0]			;         %r5    =                           src[163]
	ld.ub	%r5,[%r13]
	 ld.ub	%r6, [%r13]+			;         %r6    =                  src[3]
	add	%r4, %r5			;         %r4    =                           src[163] + src[323]
	add	%r4, %r6			;         %r4    =                  src[3] + src[163] + src[323]
	ext	0x140		; 	xld.ub	%r5, [%r13+0x140]			;         %r5    =                                                                     src[324]
	ld.ub	%r5,[%r13]
	ext	0xa0		; 	xld.ub	%r6, [%r13+0xa0]			;         %r6    =                                                          src[164]
	ld.ub	%r6,[%r13]
	 ld.ub	%r7, [%r13]+			;         %r7    =                                                 src[4]
	add	%r4, %r5			;         %r4    =                  src[3] + src[163] + src[323] +                     src[324]
	add	%r4, %r6			;         %r4    =                  src[3] + src[163] + src[323] +          src[164] + src[324]
	add	%r4, %r7			;         %r4    =                  src[3] + src[163] + src[323] + src[4] + src[164] + src[324]
	srl	%r4,0x1		; 	xsrl	%r4, 1				;         %r4    =                 (src[3] + src[163] + src[323] + src[4] + src[164] + src[324]) >> 1
	add	%r4, %r9			;         %r4    = &tia_div3_table[(src[3] + src[163] + src[323] + src[4] + src[164] + src[324]) >> 1]
	ld.ub	%r4, [%r4]			;         %r4    =  tia_div3_table[(src[3] + src[163] + src[323] + src[4] + src[164] + src[324]) >> 1]
	ld.b	[%r12]+, %r4			;         dst[3] =  tia_div3_table[(src[3] + src[163] + src[323] + src[4] + src[164] + src[324]) >> 1]
	;
	sub	%r14,0x1	; 	xsub	%r14, %r14, 1			;       } while(x)
	jrne	tia_reduce_DO_X0	; 	xjrne	tia_reduce_DO_X0
	ext	0x5		; 	xadd	%r13, %r13, 320			;       src += 320
	add	%r13,0x0
	jp.d	tia_reduce_LOOP_Y	; 	xjp.d	tia_reduce_LOOP_Y
	ld.w	%r15, 4				;       i = 4 *delay*
	;---------------------------------------;     } else {
tia_reduce_DO_X1:				;       do {
	ext	0xa0		; 	xld.ub	%r4, [%r13+0xa0]			;         %r4    =           src[160]
	ld.ub	%r4,[%r13]
	 ld.ub	%r5, [%r13]+			;         %r5    =  src[0]
	add	%r4, %r5			;         %r4    =  src[0] + src[160]
	srl	%r4,0x1		; 	xsrl	%r4, 1				;         %r4    = (src[0] + src[160]) >> 1
	ld.b	[%r12]+, %r4			;         dst[0] = (src[0] + src[160]) >> 1
	;
	ext	0xa0		; 	xld.ub	%r4, [%r13+0xa0]			;         %r4    =           src[161]
	ld.ub	%r4,[%r13]
	 ld.ub	%r5, [%r13]+			;         %r5    =  src[1]
	add	%r4, %r5			;         %r4    =  src[1] + src[161]
	srl	%r4,0x1		; 	xsrl	%r4, 1				;         %r4    = (src[1] + src[161]) >> 1
	ld.b	[%r12]+, %r4			;         dst[1] = (src[1] + src[161]) >> 1
	;
	ext	0xa0		; 	xld.ub	%r4, [%r13+0xa0]			;         %r4    =           src[162]
	ld.ub	%r4,[%r13]
	 ld.ub	%r5, [%r13]+			;         %r5    =  src[2]
	add	%r4, %r5			;         %r4    =  src[2] + src[162]
	srl	%r4,0x1		; 	xsrl	%r4, 1				;         %r4    = (src[2] + src[162]) >> 1
	ld.b	[%r12]+, %r4			;         dst[2] = (src[2] + src[162]) >> 1
	;
	ext	0xa0		; 	xld.ub	%r4, [%r13+0xa0]			;         %r4    =           src[163]
	ld.ub	%r4,[%r13]
	 ld.ub	%r5, [%r13]+			;         %r5    =  src[3]
	ext	0xa0		; 	xld.ub	%r6, [%r13+0xa0]			;         %r4    =                               src[164]
	ld.ub	%r6,[%r13]
	 ld.ub	%r7, [%r13]+			;         %r5    =                      src[4]
	add	%r4, %r5			;         %r4    =  src[3] + src[163]
	add	%r4, %r6			;         %r4    =  src[3] + src[163]          + src[164]
	add	%r4, %r7			;         %r4    =  src[3] + src[163] + src[4] + src[164]
	srl	%r4,0x2		; 	xsrl	%r4, 2				;         %r4    = (src[3] + src[163] + src[4] + src[164]) >> 2
	ld.b	[%r12]+, %r4			;         dst[3] = (src[3] + src[163] + src[4] + src[164]) >> 2
	;
	sub	%r14,0x1	; 	xsub	%r14, %r14, 1			;       } while(x)
	jrne	tia_reduce_DO_X1	; 	xjrne	tia_reduce_DO_X1
	ext	0x2		; 	xadd	%r13, %r13, 160			;       src += 160
	add	%r13,0x20
	;---------------------------------------;     }
tia_reduce_LOOP_Y:
	sub	%r11,0x1	; 	xsub	%r11, %r11, 1			;   } while(y)
	jrne	tia_reduce_DO_Y	; 	xjrne	tia_reduce_DO_Y
	;
	sub	%r10,0x1	; 	xsub	%r10, %r10, 1			; } while(z)
	jrne	tia_reduce_DO_Z	; 	xjrne	tia_reduce_DO_Z
	ret

;****************************************************************************
;	
;****************************************************************************

;------------------------------------------------------------------------------------------------------------------------
;
;	========================================================
;	"xsrl %rd,%rs"̍ɂ (2005/03/22 Naoyuki Sawa)
;	========================================================
;
;	1. %rd%rsWX^łȂƁB(ʏA肦Ȃ͂)
;	2. xsrlɁA%rs̒lςĂĂ\ȂƁB
;	3. %rs͈̔͂0..23ł邱Ƃ炩߂킩Ă邱ƁB
;
;	ȏ3̏𖞂ꍇAȉ̂悤ɓWJčł܂B
;
;		cmp	%rs, 8
;		jrle.d	7		; ------------------+
;		srl	%rd, %rs	; *delay*           |
;		sub	%rs, 8		; (skip?)           |
;		cmp	%rs, 8		; (skip?)           |
;		jrlt.d	3		; (skip?) --------+ |
;		srl	%rd, %rs	; (skip?) *delay* | |
;		srl	%rd, %rs	; (skip?) (skip?) V V
;
;	̕@́Asrl߂̎VtgA%rs[3:0]̃rbgp^[ɂĂ̂݌肳邱Ƃ𗘗pĂ܂B
;
;		%rs[3:0]	Vtg
;		--------	--------
;		  0000		   0
;		  0001		   1
;		  0010		   2
;		  0011		   3
;		  0100		   4
;		  0101		   5
;		  0110		   6
;		  0111		   7
;		  1xxx		   8		(%rs[3]=1Ȃ΁A%rs[2:0]̃p^[ɂ炸8rbgVtg)
;		--------	--------
;
;	Oq̓WJR[hɂāA%rs̏l0..23ɑΉ鏈̗́Â悤ɂȂ܂B
;
;	=========================================================================================
;	%rs	l	1ڂ		8ϲŽ	8ϲŽ	2ڂ		3ڂ
;	l	ޯ	Đ	̒l	ޯ	Đ	Đ
;	=========================================================================================
;	 0	00000000	>>0
;	 1	00000001	>>1
;	 2	00000010	>>2
;	 3	00000011	>>3
;	 4	00000100	>>4
;	 5	00000101	>>5
;	 6	00000110	>>6
;	 7	00000111	>>7
;	 8	00001000	>>8
;	-----------------------------------------------------------------------------------------
;	 9	00001001	>>8		 1	00000001	>>1
;	10	00001010	>>8		 2	00000010	>>2
;	11	00001011	>>8		 3	00000011	>>3
;	12	00001100	>>8		 4	00000100	>>4
;	13	00001101	>>8		 5	00000101	>>5
;	14	00001110	>>8		 6	00000110	>>6
;	15	00001111	>>8		 7	00000111	>>7
;	-----------------------------------------------------------------------------------------
;	16	00010000	>>0		 8	00001000	>>8		>>8
;	17	00010001	>>1		 9	00001001	>>8		>>8
;	18	00010010	>>2		10	00001010	>>8		>>8
;	19	00010011	>>3		11	00001011	>>8		>>8
;	20	00010100	>>4		12	00001100	>>8		>>8
;	21	00010101	>>5		13	00001101	>>8		>>8
;	22	00010110	>>6		14	00001110	>>8		>>8
;	23	00010111	>>7		15	00001111	>>8		>>8
;	=========================================================================================
;
;	%rs͈̔͂15̏ꍇA31̏ꍇAR[hύXāA̍Z@KpłƎv܂B
;
;------------------------------------------------------------------------------------------------------------------------
;2005/03/23 ǋL: Ɨǂ@܂B
;------------------------------------------------------------------------------------------------------------------------
;
;	========================================================
;	"xsrl %rd,%rs"̍ɂ (2005/03/23 Naoyuki Sawa)
;	========================================================
;
;	1. %rd%rsWX^łȂƁB(ʏA肦Ȃ͂)
;	2. xsrlɁA%rs̒lςĂĂ\ȂƁB
;	3. %rs͈̔͂0..23ł邱Ƃ炩߂킩Ă邱ƁB
;
;	ȏ3̏𖞂ꍇAȉ̂悤ɓWJčł܂B
;
;		cmp	%rs, 8
;		jrle.d	6		; --------+
;		srl	%rd, %rs	; *delay* |
;		sub	%rs, 8		; (skip?) |
;		srl	%rd, %rs	; (skip?) |
;		and	%rs, 8		; (skip?) |
;		srl	%rd, %rs	; (skip?) V
;
;	̕@́Asrl߂̎VtgA%rs[3:0]̃rbgp^[ɂĂ̂݌肳邱Ƃ𗘗pĂ܂B
;
;		%rs[3:0]	Vtg
;		--------	--------
;		  0000		   0
;		  0001		   1
;		  0010		   2
;		  0011		   3
;		  0100		   4
;		  0101		   5
;		  0110		   6
;		  0111		   7
;		  1xxx		   8		(%rs[3]=1Ȃ΁A%rs[2:0]̃p^[ɂ炸8rbgVtg)
;		--------	--------
;
;	Oq̓WJR[hɂāA%rs̏l0..23ɑΉ鏈̗́Â悤ɂȂ܂B
;
;	=================================================================================================================
;	%rs	l	1ڂ		8ϲŽ	8ϲŽ	2ڂ		And8	And8	3ڂ
;	l	ޯ	Đ	̒l	ޯ	Đ	̒l	ޯ	Đ
;	=================================================================================================================
;	 0	00000000	>>0
;	 1	00000001	>>1
;	 2	00000010	>>2
;	 3	00000011	>>3
;	 4	00000100	>>4
;	 5	00000101	>>5
;	 6	00000110	>>6
;	 7	00000111	>>7
;	 8	00001000	>>8
;	-----------------------------------------------------------------------------------------------------------------
;	 9	00001001	>>8		 1	00000001	>>1		0	00000000	>>0
;	10	00001010	>>8		 2	00000010	>>2		0	00000000	>>0
;	11	00001011	>>8		 3	00000011	>>3		0	00000000	>>0
;	12	00001100	>>8		 4	00000100	>>4		0	00000000	>>0
;	13	00001101	>>8		 5	00000101	>>5		0	00000000	>>0
;	14	00001110	>>8		 6	00000110	>>6		0	00000000	>>0
;	15	00001111	>>8		 7	00000111	>>7		0	00000000	>>0
;	-----------------------------------------------------------------------------------------------------------------
;	16	00010000	>>0		 8	00001000	>>8		8	00001000	>>8
;	17	00010001	>>1		 9	00001001	>>8		8	00001000	>>8
;	18	00010010	>>2		10	00001010	>>8		8	00001000	>>8
;	19	00010011	>>3		11	00001011	>>8		8	00001000	>>8
;	20	00010100	>>4		12	00001100	>>8		8	00001000	>>8
;	21	00010101	>>5		13	00001101	>>8		8	00001000	>>8
;	22	00010110	>>6		14	00001110	>>8		8	00001000	>>8
;	23	00010111	>>7		15	00001111	>>8		8	00001000	>>8
;	=================================================================================================================
;
;------------------------------------------------------------------------------------------------------------------------

;****************************************************************************
;	
;****************************************************************************

	.global tia_volume_shift
tia_volume_shift:
	; %r12 = wbuff
	ext	0x5		; 	xld.w %r13, 320
	ld.w	%r13,0x0
	ext	0x1ff		; 	xld.w %r4, 32767
	ld.w	%r4,0x3f
	not %r5, %r4			; -32768
tia_volume_shift_DO:
	ld.h %r6, [%r12]
	sll	%r6,0x8		; 	xsll %r6, 0xb 
	sll	%r6,0x3
	cmp %r6, %r4
	jrle.d 3
	cmp %r6, %r5			; *delay*
	ld.w %r6, %r4			; (skip?)
	jrge.d 3
	sub %r13, 1			; *delay*
	ld.w %r6, %r5			; (skip?)
	ld.h [%r12]+, %r6
	jrne	tia_volume_shift_DO	; 	xjrne tia_volume_shift_DO
	ret

;****************************************************************************
;	
;****************************************************************************

;#endif /*TIA_ASM*/
