/*	
 *	framtia.c
 *
 *	P/ECE TIA (Television Interface Adapter) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Fri Mar 11 03:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

#ifndef TIA_ASM

/****************************************************************************
 *
 ****************************************************************************/

/* ATARI VCS̃vÓATIAւ̏ݕpxɍ̂ŁA
 * tia_write()邱ƂAŜ̍ɑ傫e܂B
 */
int
tia_write(int now, int addr, int data)
{
	tia_scan_progress(now);

	ASSERT(addr >= 0);
	if(addr <= 0x2c) {
		return tia_write_table[addr](data);
	}

	return 0;
}

/****************************************************************************
 *
 ****************************************************************************/

/* 1. O񎞍(tia.now)ƌݎ(now)̍Aʒui܂B
 * 2. ݎ(now)ÁuO񎞍(tia.now)vƂĊi[܂B
 */
void
tia_scan_progress(int now)
{
	TIA* p_tia = &tia;
	//
	int scan_x;
	int scan_y;
	//
	unsigned clock;

	scan_x = p_tia->scan_x;		/* o */

	clock = (now - p_tia->now) * 3; /* 3 clock counts per machine cycle */
	if(clock > TIA_CLOCK / 60) { /* Safety */
		clock = TIA_CLOCK / 60;
	}
	p_tia->now = now;

	/* ^C~OAo߃NbNƓPixelAE֐i߂܂B */
	scan_x += clock;
	if(scan_x >= 68/*Hblank*/ + 160) { /* ݂̑̉E[𒴂... */

		scan_y = p_tia->scan_y;	/* o */

		/* Hsync retrace */
		do {
			scan_y++;
			scan_x -= 68/*Hblank*/ + 160;
		} while(scan_x >= 68/*Hblank*/ + 160);

		/* Vsync retrace */
		if(p_tia->VSYNC & (1<<1)) {
			/* WIȃ^C~Oł́AVSYNC=On̏Ԃ3Lineێ܂B
			 * VSYNC=On̏Vsync retraceƁA3AĂ܂܂B
			 * ̖h߂ɁAVt[JnȂԂ́A
			 * VSYNC=OnłĂVsync retraceȂƂɂ܂B
			 */
			if(scan_y >= (3/*Vsync*/ + 37/*Vblank*/)) {
				//     scan_x = 0;  ƂĂ̓_!! ^C~O͌p!!
				       scan_y = 0;
				p_tia->last_x = 0;
				p_tia->last_y = 0;
			}
		}

		p_tia->scan_y = scan_y;	/* ߂ */
	}

	p_tia->scan_x = scan_x;		/* ߂ */
}

/****************************************************************************
 *	
 ****************************************************************************/

/* 1. ȎIʒu(tia.last_x,y)Ȃ݂ʒu(tia.scan_x,y)܂ł̋Ԃ`悵܂B
 * 2. ݂̑ʒu(tia.scan_x,y)ÁuIʒu(tia.last_x,y)vƂĊi[܂B
 */
void
tia_partial_update()
{
	TIA* p_tia = &tia;
	//
	const int scan_x = p_tia->scan_x;
	const int scan_y = p_tia->scan_y;
	//
	int last_x;
	int last_y;

	if(!(p_tia->VBLANK & (1<<1))) {	/* Vblank=Off */

		last_x = p_tia->last_x;
		last_y = p_tia->last_y;

		while(last_y < scan_y) {
			tia_line_update(last_y, last_x, 68/*Hblank*/ + 160);
			last_x = 0;
			last_y++;
		}
		tia_line_update(last_y, last_x, scan_x);

	} else { /* Vblank=On */
		/* ̈Vblank=On͋HȂ̂ŁAhԂȗ邱Ƃɂ܂B */
	}

	p_tia->last_x = scan_x;
	p_tia->last_y = scan_y;
}

/****************************************************************************
 *
 ****************************************************************************/

static __inline int
tia_player_serial_output(TIAPLAYER* player, unsigned x)
{
	int g;

	/* DelayݒɑΉGraphicso܂B
	 * ̂߂ɁA܂NullGraphicsۂ𔻒fANullGraphicsȂ΂ɋA܂B
	 * (Sʂ̂APlayer\LineA\ȂLine̕Ɨ\z܂)
	 */
	g = player->graphics[player->delay];
	if(!g) {
		return 0;
	}

	/* wPixelWɑ΂鑊Position߂܂B
	 * ʍE[͉~ɂȂĂāAЕɔg悤ȕ\͂ł܂B
	 */
	ASSERT(x <= 159);
	x -= player->position;
	if(x > 159) {
		x += 160;
	}
	ASSERT(x <= 159);

	/* SizeݒɂāAwPixelWɑΉAGraphicsbitʒu߂܂B
	 * Graphics͈̔͊OȂ΁AA܂B
	 */
	switch(player->size) {
	default: /* 0=x */
		if(x < 8) break;
		return 0;
	case 1:  /* 1=x_x */
		if(x < 8) break;
		x -= 16;
		if(x < 8) break;
		return 0;
	case 2:  /* 2=x___x */
		if(x < 8) break;
		x -= 32;
		if(x < 8) break;
		return 0;
	case 3:  /* 3=x_x_x */
		if(x < 8) break;
		x -= 16;
		if(x < 8) break;
		x -= 16;
		if(x < 8) break;
		return 0;
	case 4:  /* 4=x_______x */
		if(x < 8) break;
		x -= 64;
		if(x < 8) break;
		return 0;
	case 5:  /* 5=XX */
		if(x < 16) {
			x >>= 1;
			break;
		}
		return 0;
	case 6:  /* 6=x___x___x */
		if(x < 8) break;
		x -= 32;
		if(x < 8) break;
		x -= 32;
		if(x < 8) break;
		return 0;
	case 7:  /* 7=XXXX */
		if(x < 32) {
			x >>= 2;
			break;
		}
		return 0;
	}
	ASSERT(x <= 7);

	/* Reflect=0Ȃ(:D7..D0:E)AReflect=1Ȃ(:D0..D7:E)łB */
	if(!player->reflect) {
		x = 7 - x;
	}
	ASSERT(x <= 7);

	/* GraphicsbitԂ܂B */
	return (g >> x) & 1;
}

static __inline int
tia_missile_serial_output(TIAMISSILE* missile, unsigned x)
{
	/* \OffȂ΁AɋA܂B */
	if(!missile->graphics || /* 0=graphics disable     */
	    missile->reset) {    /* 1=missile-player reset */
		return 0;
	}

	/* wPixelWɑ΂鑊Position߂܂B
	 * ʍE[͉~ɂȂĂāAЕɔg悤ȕ\͂ł܂B
	 */
	ASSERT(x <= 159);
	x -= missile->position;
	if(x > 159) {
		x += 160;
	}
	ASSERT(x <= 159);

	/* Size=0(1clock)̏ꍇA(x=0   )Ȃbit=1AȂ킿!(x>>0)Ȃbit=1łB
	 * Size=1(2clock)̏ꍇA(x=0..1)Ȃbit=1AȂ킿!(x>>1)Ȃbit=1łB
	 * Size=2(4clock)̏ꍇA(x=0..3)Ȃbit=1AȂ킿!(x>>2)Ȃbit=1łB
	 * Size=3(8clock)̏ꍇA(x=0..7)Ȃbit=1AȂ킿!(x>>3)Ȃbit=1łB
	 */
	return !(x >> missile->size);
}

static __inline int
tia_ball_serial_output(TIABALL* ball, unsigned x)
{
	/* DelayݒɑΉ\OffȂ΁AɋA܂B */
	if(!ball->graphics[ball->delay]) {
		return 0;
	}

	/* wPixelWɑ΂鑊Position߂܂B
	 * ʍE[͉~ɂȂĂāAЕɔg悤ȕ\͂ł܂B
	 */
	ASSERT(x <= 159);
	x -= ball->position;
	if(x > 159) {
		x += 160;
	}
	ASSERT(x <= 159);

	/* Size=0(1clock)̏ꍇA(x=0   )Ȃbit=1AȂ킿!(x>>0)Ȃbit=1łB
	 * Size=1(2clock)̏ꍇA(x=0..1)Ȃbit=1AȂ킿!(x>>1)Ȃbit=1łB
	 * Size=2(4clock)̏ꍇA(x=0..3)Ȃbit=1AȂ킿!(x>>2)Ȃbit=1łB
	 * Size=3(8clock)̏ꍇA(x=0..7)Ȃbit=1AȂ킿!(x>>3)Ȃbit=1łB
	 */
	return !(x >> ball->size);
}

static __inline int
tia_playfield_serial_output(TIAPLAYFIELD* playfield, unsigned x)
{
	int g;

	/* Graphicso܂B
	 * ̂߂ɁA܂NullGraphicsۂ𔻒fANullGraphicsȂ΂ɋA܂B
	 * (Sʂ̂APlayfield\LineA\ȂLine̕Ɨ\z܂)
	 */
	g = playfield->graphics;
	if(!g) {
		return 0;
	}

	/* Playfield̉𑜓x1/4̑eŁAGraphics1bitʏ4PixelɑΉ܂B */
	ASSERT(x <= 159);
	x >>= 2;
	ASSERT(x <= 39);

	/* ʍ80Pixel(80/4=20bit)ƁAE80bitɁAGraphics\܂B
	 * bitт́AReflectɍS炸(:D19..D0:E)łB
	 * Ebitт́AReflect=0Ȃ(:D19..D0:E)AReflect=1Ȃ(:D0..D19:E)łB
	 */
	if(x < 20) { /* left half */
		x = 19 - x;
	} else {     /* right half */
		if(!playfield->reflect) {
			x = 39 - x;
		} else {
			x = x - 20;
		}
	}
	ASSERT(x <= 19);

	/* GraphicsbitԂ܂B */
	return (g >> x) & 1;
}

void
tia_line_update(unsigned y, unsigned x1, unsigned x2)
{
	TIA* p_tia = &tia;
	//
	//
	int v;
	int collision;
	unsigned char* vbuff;
	const unsigned char* priority;

	ASSERT(x1 <= 68/*Hblank*/ + 160);
	ASSERT(x2 <= 68/*Hblank*/ + 160);
	ASSERT(x1 <= x2);

	/* ýAVsync(0..2)AVblank(3..39)AOverscan(232..)܂LineWłB
	 * VsyncԂVblankԂāA̈LineW(0..191)ɕϊ܂B
	 * ϊ̌ʁAOverscan(192..)Ȃ΁AɋA܂B
	 */
	y -= (3/*Vsync*/ + 37/*Vblank*/);
	if(y > 191) return;

	/* x1,x2́AHblank(0..67)܂PixelW(0..227)łB
	 * HblankԂāA̈PixelW(0..159)ɕϊ܂B
	 */
	x1 -= 68/*Hblank*/;
	if(x1 > 160) x1 = 0;
	x2 -= 68/*Hblank*/;
	if(x2 > 160) x2 = 0;
	if(x1 >= x2) return;

	/* `Jnʒủzʃobt@AhXƁA
	 * PriorityݒɑΉAObject̏dȂp^[->`Findex ϊe[u擾܂B
	 */
	vbuff = p_tia->vbuff + 160 * y + x1;
	priority = tia_priority_table[(p_tia->CTRLPF >> 2) & 1];

	collision = p_tia->collision; /* o */

	/* `Ԃ̊ePixelɂ... */
	ASSERT(x1 < x2);
	do {
		/* Object̏dȂp^[߂܂B */
		v =          tia_player_serial_output(&p_tia->player[0], x1);    /* Player0   */
		v = v << 1 | tia_missile_serial_output(&p_tia->missile[0], x1);  /* Missile0  */
		v = v << 1 | tia_player_serial_output(&p_tia->player[1], x1);    /* Player1   */
		v = v << 1 | tia_missile_serial_output(&p_tia->missile[1], x1);  /* Missile1  */
		v = v << 1 | tia_ball_serial_output(&p_tia->ball, x1);           /* Ball      */
		v = v << 1 | tia_playfield_serial_output(&p_tia->playfield, x1); /* Playfield */

		/* PixelɂObject̏Փ˂ȀՓ˃tOɃ}[W܂B */
		collision |= tia_collision_table[v];

		/* Pixel̕`F肵Azʃobt@֏݂܂B */
		v = priority[v];
		if(p_tia->CTRLPF & (1<<1)) {	/* score */
			if(v == 2) {		/* COLUPF -> */
				if(x1 < 80) {	/* left half */
					v = 0;	/* -> COLUP0 */
				} else {	/* right half */
					v = 1;	/* -> COLUP1 */
				}
			}
		}
		*vbuff++ = p_tia->clut[v];

		/* PixelցB */
		x1++;
	} while(x1 < x2);

	p_tia->collision = collision; /* ߂ */
}

/****************************************************************************
 *
 ****************************************************************************/

#ifdef TIA_GRAYSCALE
/*
 * * k 160pixel -> 128pixel ́A4/5kłB
 *   ]5pixel]4pixelɈkƂA1line32JԂ܂B
 *   ]pixelƓ]pixel̑Ή́A̒ʂłB
 * 
 * 	]pixel	]pixel
 * 	-----------	-----------
 * 	   0		     0
 * 	   1		     1
 * 	   2		     2
 * 	   3 + 4	     3
 * 	-----------	-----------
 * 	   5		     4
 * 	   6		     5
 * 	   7		     6
 * 	   8 + 9	     7
 * 	-----------	-----------
 * 	     .		     .
 * 	     .		     .
 * 	     .		     .
 * 
 * * k 192line -> 88line ́A11/24kłB
 *   ]24line]11lineɈkƂA1frame8JԂ܂B
 *   ]lineƓ]linȇΉ́A̒ʂłB
 * 
 * 	]line	]line	i=4
 * 	----------	----------	---------
 * 	 0 + 1		     0		i=4->3
 * 	 2 + 3		     1		i=3->2
 * 	 4 + 5		     2		i=2->1
 * 	 6 + 7 + 8	     3		i=1->0->4
 * 	 9 +10		     4		i=4->3
 * 	11 +12		     5		i=3->2
 * 	13 +14		     6		i=2->1
 * 	15 +16 +17	     7		i=1->0->4
 * 	18 +19		     8		i=4->3
 * 	20 +21		     9		i=3->2
 * 	22 +23		    10		i=2->1
 * 	----------	----------	---------
 * 	24 +25		    11		i=4->3
 * 	26 +27		    12		i=3->2
 * 	28 +29		    13		i=2->1
 * 	30 +31 +32	    14		i=1->0->4
 * 	33 +34		    15		i=4->3
 * 	35 +36		    16		i=3->2
 * 	37 +38		    17		i=2->1
 * 	39 +40 +41	    18		i=1->0->4
 * 	42 +43		    19		i=4->3
 * 	44 +45		    20		i=3->2
 * 	46 +47		    21		i=2->1
 * 	----------	----------	---------
 * 	     .		     .		    .
 * 	     .		     .		    .
 * 	     .		     .		    .
 */
void
tia_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*160*192*/])
{
	int i;
	int x;
	int y;
	int z;

	z = 8;
	do {
		y = 11;
		i = 4;
		do {
			x = 32;
			if(!--i) {
				do {
					dst[0] = tia_div3_table[(src[0] + src[160] + src[320])];
					dst[1] = tia_div3_table[(src[1] + src[161] + src[321])];
					dst[2] = tia_div3_table[(src[2] + src[162] + src[322])];
					dst[3] = tia_div3_table[(src[3] + src[163] + src[323] +
								 src[4] + src[164] + src[324]) >> 1];
					dst += 4;
					src += 5;
				} while(--x);
				src += 320;
				i = 4;
			} else {
				do {
					dst[0] = (src[0] + src[160]) >> 1;
					dst[1] = (src[1] + src[161]) >> 1;
					dst[2] = (src[2] + src[162]) >> 1;
					dst[3] = (src[3] + src[163] +
						  src[4] + src[164]) >> 2;
					dst += 4;
					src += 5;
				} while(--x);
				src += 160;
			}
		} while(--y);
	} while(--z);
}
#endif TIA_GRAYSCALE

/****************************************************************************
 *	AUDIO
 ****************************************************************************/

/* Audio0: (-15..+15) = t5bit
 * Audio1: (-15..+15) = t5bit
 * =v=:            = t6bit
 */
#define TIA_VOLUME_SHIFT ((16-6)+1/**/) /* =11 */
 
void
tia_volume_shift(short wbuff[/*TIABUFLEN*/])
{
	int i;
	int v;

	i = TIABUFLEN;
	do {
		v = *wbuff;
		v <<= TIA_VOLUME_SHIFT;
		if(v >  32767) v =  32767;
		if(v < -32768) v = -32768;
		*wbuff++ = v;
	} while(--i);
}

/****************************************************************************
 *
 ****************************************************************************/

#endif /*TIA_ASM*/

