;	
;	framt18a.s
;
;	P/ECE TMS9918(A) Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Mon Jan 4 21:50:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
#include "clipt18a.h"
#ifdef TMS9918_ASM

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

;
;	TMS9918\
;
			;typedef struct _TMS9918 {
#define ADDR	 0	;	unsigned short addr;		/* + 0,  2: Address (0x0000-0x3fff) gppx̂1߂ŃANZXł悤擪ɔzu */
#define LATCH	 2	;	         short latch;		/* + 2,  2: Port#1ւ̏ݒlێ (-1:) */
#define REG	 4	;	unsigned char  reg[8];		/* + 4,  8: Register */
#define STATUS	12	;	unsigned char  status;		/* +12,  1: Status */
#define RESV	13	;	unsigned char  resv[3];		/* +13,  3: (\) */
#define VRAM	16	;	unsigned char  vram[0x4000];	/* +16,16K: VRAM (16KB) */
			;} TMS9918;

;****************************************************************************
;	tms9918_reduce
;****************************************************************************

	.global tms9918_reduce
tms9918_reduce:
	xld.w %r14, 256*(2-1)
	xld.w %r15, 256*(3-1)
	;
	xld.w %r10, 192/24			; z = 192 / 24
tms9918_reduce_do_z:				; do {
	;
	xld.w %r11, 24/2-1			;   y = 24 / 2 - 1
tms9918_reduce_do_y:				;   do {
	;
	xld.w %r4, 256/2			;     x = 256 / 2
	xcmp %r11, 4				;     switch(y) {
	xjreq tms9918_reduce_case4_8_do_x	;     
	xcmp %r11, 8				;     
	xjreq tms9918_reduce_case4_8_do_x	;     
	;
tms9918_reduce_default_do_x:			;     default: do {
	xld.uh %r5, [%r13+256]			;         c = tmp[0] + tmp[256 / 2]
	 ld.uh %r6, [%r13]+			;         tmp++
	add %r5, %r6
	ld.ub %r6, %r5				;         c = (c & 0xff) + (c >> 8)
	xsrl %r5, 8				;         
	add %r5, %r6				;         
	xsrl %r5, 2				;         *dst++ = c / 4
	xsub %r4, %r4, 1			;         x--
	ld.b [%r12]+, %r5			;         
	xjrne tms9918_reduce_default_do_x	;       } while(x)
	xjp.d tms9918_reduce_while_y		;       break;
	add %r13, %r14		  		;       tmp += (256 * (2 - 1)) / 2 *delay*
	;
tms9918_reduce_case4_8_do_x:			;     case 4: case 8: do {
	xld.uh %r5, [%r13+512]			;         c = tmp[0] + tmp[256 / 2] + tmp[512 / 2]
	xld.uh %r6, [%r13+256]			;         
	 ld.uh %r7, [%r13]+			;         tmp++
	add %r5, %r6				;         
	add %r5, %r7				;         
	ld.ub %r6, %r5				;         c = (c & 0xff) + (c >> 8)
	xsrl %r5, 8				;         
	add %r5, %r6				;         
	ext tms9918_div6_table@ah		;         *dst++ = tms9918_div6_table[c]
	ext tms9918_div6_table@al		;         
	ld.ub %r5, [%r5]			;         
	xsub %r4, %r4, 1			;         x-- *anti-interlock*
	ld.b [%r12]+, %r5			;         
	xjrne tms9918_reduce_case4_8_do_x	;       } while(x)
	add %r13, %r15				;       tmp += (256 * (3 - 1)) / 2
	;					;     }
	;
tms9918_reduce_while_y:				;   } while(--y)
	xsub %r11, %r11, 1
	xjrne tms9918_reduce_do_y
	;
	xsub %r10, %r10, 1			; } while(--z)
	xjrne tms9918_reduce_do_z
	ret

;****************************************************************************
;	tms9918_update_graphics2
;****************************************************************************

	.global tms9918_update_graphics2
tms9918_update_graphics2:
	pushn %r3
	;
	xld.ub %r0, [%r12+REG+2]		; name_table        = &vram[(reg[2] & 0x0f) << 10]
	xld.ub %r1, [%r12+REG+3]		; color_table       = &vram[(reg[3] & 0x80) <<  6]
	xld.ub %r2, [%r12+REG+4]		; pattern_generator = &vram[(reg[4] & 0x04) << 11]
	xld.ub %r3, [%r12+REG+7]		; backdrop          =        reg[7] & 0x0f
	xand %r0, %r0, 0x0f
	xand %r1, %r1, 0x80
	xand %r2, %r2, 0x04
	xand %r3, %r3, 0x0f
	xsll %r0, 10
	xsll %r1, 6
	xsll %r2, 11
	xadd %r12, %r12, VRAM
	add %r0, %r12
	add %r1, %r12
	add %r2, %r12
	;
	xld.w %r4, 3				; block = 3
tms9918_update_graphics2_do_block:		; do {
	;
	xld.w %r5, 8				; row = 8
tms9918_update_graphics2_do_row:		; do {
	;
	xld.w %r6, 32				; col = 32
tms9918_update_graphics2_do_col:		; do {
	;
	ld.ub %r7, [%r0]+			; code = *name_table++
	;
	ld.w %r10, %r1				; color   = color_table       + code * 8
	ld.w %r11, %r2				; pattern = pattern_generator + code * 8
	xsll %r7, 3
	add %r10, %r7
	add %r11, %r7
	;
	xld.w %r7, 8				; line = 8
tms9918_update_graphics2_do_line:		; do {
	;
	ld.ub %r15, [%r10]+			; c1 = *color++
	xand %r14, %r15, 0xf			; c0 = c1 & 0xf
	xjrne.d tms9918_update_graphics2_c0	; if(!c0) c0 = backdrop
	srl %r15, 4				; c1 >>= 4 *delay*
	ld.w %r14, %r3
tms9918_update_graphics2_c0:
	xjrne tms9918_update_graphics2_c1	; if(!c1) c1 = backdrop
	ld.w %r15, %r3
tms9918_update_graphics2_c1:
	;
	ext tms9918_grayscale_table@ah		; c0 = tms9918_grayscale_table[c0]
	ext tms9918_grayscale_table@al
	ld.ub %r14, [%r14]
	ext tms9918_grayscale_table@ah		; c1 = tms9918_grayscale_table[c1]
	ext tms9918_grayscale_table@al
	ld.ub %r15, [%r15]
	;
	ld.ub %r12, [%r11]+			; v = *pattern++
	xrr %r12, 8				; (%r12[31:24] = v)
	;
	add %r12, %r12				; if(v & 0x80) { *vbuff++ = c1; } else { *vbuff++ = c0; }
	jruge.d 3
	ld.w %r9, %r14
	ld.w %r9, %r15
	ld.b [%r13]+, %r9
	add %r12, %r12				; if(v & 0x40) { *vbuff++ = c1; } else { *vbuff++ = c0; }
	jruge.d 3
	ld.w %r9, %r14
	ld.w %r9, %r15
	ld.b [%r13]+, %r9
	add %r12, %r12				; if(v & 0x20) { *vbuff++ = c1; } else { *vbuff++ = c0; }
	jruge.d 3
	ld.w %r9, %r14
	ld.w %r9, %r15
	ld.b [%r13]+, %r9
	add %r12, %r12				; if(v & 0x10) { *vbuff++ = c1; } else { *vbuff++ = c0; }
	jruge.d 3
	ld.w %r9, %r14
	ld.w %r9, %r15
	ld.b [%r13]+, %r9
	add %r12, %r12				; if(v & 0x08) { *vbuff++ = c1; } else { *vbuff++ = c0; }
	jruge.d 3
	ld.w %r9, %r14
	ld.w %r9, %r15
	ld.b [%r13]+, %r9
	add %r12, %r12				; if(v & 0x04) { *vbuff++ = c1; } else { *vbuff++ = c0; }
	jruge.d 3
	ld.w %r9, %r14
	ld.w %r9, %r15
	ld.b [%r13]+, %r9
	add %r12, %r12				; if(v & 0x02) { *vbuff++ = c1; } else { *vbuff++ = c0; }
	jruge.d 3
	ld.w %r9, %r14
	ld.w %r9, %r15
	ld.b [%r13]+, %r9
	add %r12, %r12				; if(v & 0x01) { *vbuff++ = c1; } else { *vbuff++ = c0; }
	jruge.d 3
	ld.w %r9, %r14
	ld.w %r9, %r15
	ld.b [%r13]+, %r9
	;
	xadd %r13, %r13, 256-8			; vbuff += 256 - 8
	;
	xsub %r7, %r7, 1			; } while(--line)
	xjrne tms9918_update_graphics2_do_line
	;
	xsub %r13, %r13, 256*8-8		; vbuff -= 256 * 8 - 8
	;
	xsub %r6, %r6, 1			; } while(--col)
	xjrne tms9918_update_graphics2_do_col
	;
	xadd %r13, %r13, 256*8-256		; vbuff += 256 * 8 - 256
	;
	xsub %r5, %r5, 1			; } while(--row)
	xjrne tms9918_update_graphics2_do_row
	;
	xadd %r1, %r1, 0x800			; color_table       += 0x800
	xadd %r2, %r2, 0x800			; pattern_generator += 0x800
	;
	xsub %r4, %r4, 1			; } while(--block)
	xjrne tms9918_update_graphics2_do_block
	;
	popn %r3
	ret

;****************************************************************************
;	tms9918_update_sprite10
;****************************************************************************

	.global tms9918_update_sprite10
tms9918_update_sprite10:
	pushn %r3
	;
	xsub %r13, %r13, 1			; `惋[vp++PSETO̒xXbgɓ邽߂ɁApre-incrementŏ܂B
	;					; pre-incrementɕ``̍㌴_w悤A炩1Ă܂B
	;
	xld.w %r14, 256-8			; pɂɎglWX^ɕێ
	xld.w %r15, 256*16-8			; pɂɎglWX^ɕێ
	;
	xld.ub %r0, [%r12+REG+5]		; attribute_table   = &vram[(reg[5] & 0x7f) <<  7]
	xld.ub %r1, [%r12+REG+6]		; pattern_generator = &vram[(reg[6] & 0x07) << 11]
	xand %r0, %r0, 0x7f
	xand %r1, %r1, 0x07
	xsll %r0, 7
	xsll %r1, 11
	xadd %r12, %r12, VRAM
	add %r0, %r12
	add %r1, %r12
	;
	xld.w %r2, 32				; sprite = 32
tms9918_update_sprite10_L10:			; do { /*sprite*/
	;
	ld.ub %r3, [%r0]+			;   y    = *attribute_table++
	ld.ub %r4, [%r0]+			;   x    = *attribute_table++
	ld.ub %r5, [%r0]+			;   code = *attribute_table++
	ld.ub %r6, [%r0]+			;   c    = *attribute_table++
	;
	xcmp %r3, 192				;   if(y >= 192) {
	xjrlt tms9918_update_sprite10_L20	;     
	xcmp %r3, 256-16			;     if(y <= 256 - 16) {
	xjrgt tms9918_update_sprite10_L21	;       
	xcmp %r3, 208				;       if(y == 208) break
	xjreq tms9918_update_sprite10_EXIT	;       
	xjp   tms9918_update_sprite10_NEXT	;       continue
tms9918_update_sprite10_L21:			;     }
	xsub %r3, %r3, 256			;     y -= 256
tms9918_update_sprite10_L20:			;   }
	;
	xand %r6, %r6, 0x8f			;   c &= 0x8f
	;
	xcmp %r6, 15				;   if(c > 15) {
	xjrle tms9918_update_sprite10_L30	;     
	xand %r6, %r6, 15			;     c &= 15
	xsub %r4, %r4, 32			;     x -= 32
	xcmp %r4, 0-16				;     if(x <= 0 - 16) continue
	xjrle tms9918_update_sprite10_NEXT	;     
tms9918_update_sprite10_L30:			;   }
	;
	xcmp %r6, 0				;   if(!c) continue
	xjreq tms9918_update_sprite10_NEXT
	;
	ext tms9918_grayscale_table@ah		;   c = tms9918_grayscale_table[c]
	ext tms9918_grayscale_table@al
	ld.ub %r6, [%r6]
	;
	xand %r5, %r5, ~3			;   code &= ~3
	;
	xsll %r5, 3				;   pattern = pattern_generator + code * 8
	add %r5, %r1
	;
	ld.w %r7, %r3				;   p = (vbuff - 1) + y * 256 + x
	xsll %r7, 8
	add %r7, %r4
	add %r7, %r13
	;
	xcmp %r3, 192-16			;   if((unsigned)y > 192 - 16) goto L50
	xjrugt.d tms9918_update_sprite10_L50	;   
	ld.w %r10, 2				;   side = 2 *delay*
	xcmp %r4, 256-16			;   if((unsigned)x > 256 - 16) goto L50
	xjrugt   tms9918_update_sprite10_L50
	;
tms9918_update_sprite10_L40:			;   do { /*side*/
	xld.w %r11, 16				;     line = 16
tms9918_update_sprite10_L41:			;     do { /*line*/
	ld.ub %r9, [%r5]+			;       v = *pattern++
	xrr %r9, 8				;       (%r9[31:24] = v)
	add %r9, %r9				;       p++, if(v & 0x80) PSET
	jruge.d 3				;       
	add %r7, 1				;       *delay*
	ld.b [%r7], %r6				;       
	add %r9, %r9				;       p++, if(v & 0x40) PSET
	jruge.d 3				;       
	add %r7, 1				;       *delay*
	ld.b [%r7], %r6				;       
	add %r9, %r9				;       p++, if(v & 0x20) PSET
	jruge.d 3				;       
	add %r7, 1				;       *delay*
	ld.b [%r7], %r6				;       
	add %r9, %r9				;       p++, if(v & 0x10) PSET
	jruge.d 3				;       
	add %r7, 1				;       *delay*
	ld.b [%r7], %r6				;       
	add %r9, %r9				;       p++, if(v & 0x08) PSET
	jruge.d 3				;       
	add %r7, 1				;       *delay*
	ld.b [%r7], %r6				;       
	add %r9, %r9				;       p++, if(v & 0x04) PSET
	jruge.d 3				;       
	add %r7, 1				;       *delay*
	ld.b [%r7], %r6				;       
	add %r9, %r9				;       p++, if(v & 0x02) PSET
	jruge.d 3				;       
	add %r7, 1				;       *delay*
	ld.b [%r7], %r6				;       
	add %r9, %r9				;       p++, if(v & 0x01) PSET
	jruge.d 3				;       
	add %r7, 1				;       *delay*
	ld.b [%r7], %r6				;       
	xsub %r11, %r11, 1			;       line--
	xjrne.d tms9918_update_sprite10_L41	;     } while(line)
	add %r7, %r14				;       p += 256 - 8 *delay*
	xsub %r10, %r10, 1			;     side--
	xjrne.d tms9918_update_sprite10_L40	;   } while(side)
	sub %r7, %r15				;     p -= 256 * 16 - 8 *delay*
	xjp   tms9918_update_sprite10_NEXT	;   goto NEXT
	;
tms9918_update_sprite10_L50:			;   do { /*side*/
	xld.w %r11, 16				;     line = 16
tms9918_update_sprite10_L51:			;     do { /*line*/
	ld.ub %r9, [%r5]+			;       v = *pattern++
	xrr %r9, 8				;       (%r9[31:24] = v)
	xld.w %r12, 8				;       i = 8
tms9918_update_sprite10_L52:			;       do { /*i*/
	add %r9, %r9				;         if(!(v & 0x80)) goto L43
	xjruge.d tms9918_update_sprite10_L53	;         
	add %r7, 1				;         p++ *delay*
	xcmp %r3, 191				;         if((unsigned)y > 191) goto L53
	xjrugt   tms9918_update_sprite10_L53	;         
	xcmp %r4, 255				;         if((unsigned)x > 255) goto L53
	xjrugt   tms9918_update_sprite10_L53	;         
	ld.b [%r7], %r6				;         PSET
tms9918_update_sprite10_L53:			;         
	xsub %r12, %r12, 1			;         i--
	xjrne.d tms9918_update_sprite10_L52	;       } while(i)
	add %r4, 1				;         x++ *delay*
	xadd %r3, %r3, 1			;       y += 1
	xsub %r4, %r4, 8			;       x -= 8
	xsub %r11, %r11, 1			;       line--
	xjrne.d tms9918_update_sprite10_L51	;     } while(line)
	add %r7, %r14				;       p += 256 - 8 *delay*
	xsub %r3, %r3, 16			;     y -= 16
	xadd %r4, %r4, 8			;     x +=  8
	xsub %r10, %r10, 1			;     side--
	xjrne.d tms9918_update_sprite10_L50	;   } while(side)
	sub %r7, %r15				;     p -= 256 * 16 - 8 *delay*
	;
tms9918_update_sprite10_NEXT:
	xsub %r2, %r2, 1			;   sprite--
	xjrne tms9918_update_sprite10_L10	; } while(sprite)
	;
tms9918_update_sprite10_EXIT:
	popn %r3
	ret

;****************************************************************************
;	
;****************************************************************************

#endif /*TMS9918_ASM*/
