/*	
 *	framt18.c
 *
 *	P/ECE TMS9918(A) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Mon Jan 4 21:50:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

#ifndef TMS9918_ASM

#ifdef TMS9918_GRAYSCALE
void
tms9918_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*256*192*/])
{
	const unsigned short* tmp = (const unsigned short*)src;
	//
	int c;
	int x;
	int y;
	int z;

	/* ]192C24CÂA8ubNɕď܂B */
	z = 192 / 24;
	do {
		/* ]24C]11CɈk܂B */
		y = 24 / 2 - 1;
		do {
			/* y=11: ]C 0+ 1    => ]惉C 0
			 * y=10: ]C 2+ 3    => ]惉C 1
			 * y= 9: ]C 4+ 5    => ]惉C 2
			 * y= 8: ]C 6+ 7+ 8 => ]惉C 3
			 * y= 7: ]C 9+10    => ]惉C 4
			 * y= 6: ]C11+12    => ]惉C 5
			 * y= 5: ]C13+14    => ]惉C 6
			 * y= 4: ]C15+16+17 => ]惉C 7
			 * y= 3: ]C18+19    => ]惉C 8
			 * y= 2: ]C20+21    => ]惉C 9
			 * y= 1: ]C22+23    => ]惉C10
			 */
			x = 256 / 2;
			switch(y) {
			case 4:
			case 8:
				/* 2x3sNZ̕ς߂܂B */
				do {
					/* c[ 7-0] = (0,0)+(0,1)+(0,2) */
					/* c[15-8] = (1,0)+(1,1)+(1,2) */
					c = tmp[0] + tmp[256 / 2] + tmp[512 / 2];
					/* c = (0,0)+(1,0)+(0,1)+(1,1)+(0,2)+(1,2) */
					c = (c & 0xff) + (c >> 8);
					*dst++ = tms9918_div6_table[c]; /* 6sNZ */
					tmp++;
				} while(--x);
				tmp += (256 * (3 - 1)) / 2; /* 3C */
				break;
			default:
				/* 2x2sNZ̕ς߂܂B */
				do {
					/* c[ 7-0] = (0,0)+(0,1) */
					/* c[15-8] = (1,0)+(1,1) */
					c = tmp[0] + tmp[256 / 2];
					/* c = (0,0)+(1,0)+(0,1)+(1,1) */
					c = (c & 0xff) + (c >> 8);
					*dst++ = c / 4; /* 4sNZ */
					tmp++;
				} while(--x);
				tmp += (256 * (2 - 1)) / 2; /* 2C */
				break;
			}
		} while(--y);
	} while(--z);
}
#endif /*TMS9918_GRAYSCALE*/

void
tms9918_update_graphics2(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/])
{
	unsigned char* reg  = tms9918->reg;
	unsigned char* vram = tms9918->vram;
	//
	int backdrop;
	int block;
	int row;
	int col;
	int code;
	int line;
	int c0;
	int c1;
	int v;
	const unsigned char* name_table;
	const unsigned char* color_table;
	const unsigned char* pattern_generator;
	const unsigned char* pattern;
	const unsigned char* color;

	/* e[uAhX擾܂B */
	name_table        = &vram[(reg[2] & 0x0f) << 10]; /* 1KBEɐ */
	color_table       = &vram[(reg[3] & 0x80) <<  6]; /* 8KBEɐ */
	pattern_generator = &vram[(reg[4] & 0x04) << 11]; /* 8KBEɐ */

	/* obNhbvJ[擾܂B */
	backdrop = reg[7] & 0x0f;

	/* 256x192256x64ÂA3ubNɕď܂B
	 * p^[WFl[^ƃJ[e[úAubNɈΉ܂B
	 */
	for(block = 0; block < 3; block++) {

		/* 1ubNA256x64sNZ32x8Zɂ... */
		for(row = 0; row < 8; row++) {
			for(col = 0; col < 32; col++) {

				/* p^[ԍ擾܂B */
				code = *name_table++;

				/* p^[f[^AJ[f[^̐擪AhX߂܂B */
				pattern = pattern_generator + code * 8;
				color = color_table + code * 8;

				/* 1Z8Cɂ... */
				for(line = 0; line < 8; line++) {

					/* p^[f[^01ɑΉJ[擾܂B */
					c1 = *color++;
					c0 = c1 & 0xf;
					c1 >>= 4;

					/* J[R[h0Ȃ΁AobNhbvJ[g܂B */
					if(!c0) c0 = backdrop;
					if(!c1) c1 = backdrop;

#ifdef TMS9918_GRAYSCALE
					/* OCXP[́AJ[OCXP[ɕϊ܂B */
					c0 = tms9918_grayscale_table[c0];
					c1 = tms9918_grayscale_table[c1];
#endif /*TMS9918_GRAYSCALE*/

					/* p^[f[^擾܂B */
					v = *pattern++;

					/* p^[`܂B */
					if(v & 0x80) { *vbuff++ = c1; } else { *vbuff++ = c0; }
					if(v & 0x40) { *vbuff++ = c1; } else { *vbuff++ = c0; }
					if(v & 0x20) { *vbuff++ = c1; } else { *vbuff++ = c0; }
					if(v & 0x10) { *vbuff++ = c1; } else { *vbuff++ = c0; }
					if(v & 0x08) { *vbuff++ = c1; } else { *vbuff++ = c0; }
					if(v & 0x04) { *vbuff++ = c1; } else { *vbuff++ = c0; }
					if(v & 0x02) { *vbuff++ = c1; } else { *vbuff++ = c0; }
					if(v & 0x01) { *vbuff++ = c1; } else { *vbuff++ = c0; }

					/* ̃C֐i߂܂B */
					vbuff += 256 - 8;
				}

				/* ̃Z֐i߂܂B */
				vbuff -= 256 * 8 - 8;
			}

			/* [̉̃Z֐i߂܂B */
			vbuff += 256 * 8 - 256;
		}

		/* p^[WFl[^AJ[e[ũubN֐i߂܂B */
		pattern_generator += 0x800;
		color_table += 0x800;
	}
}

#define TMS9918_SPRITE_IMPLEMENT
void tms9918_update_sprite10(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]) {
#define SIZE 16 /* 16x16 */
#define MAG   1 /* W  */
#include "clipt18i.h"
#undef SIZE
#undef MAG
}
#undef TMS9918_SPRITE_IMPLEMENT

#endif /*TMS9918_ASM*/
