/*	
 *	framsv.c
 *
 *	P/ECE SUPERVISION Video/Sound Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Thu Apr 14 05:55:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	Video
 ****************************************************************************/

void
svvideo_update(unsigned char vbuff[/*160*160*/])
{
	SVVIDEO* video = &svvideo;
	unsigned char* ram = video->ram;
	unsigned char* vram = &ram[0x4000];
	//
	int xscrl;
	int yscrl;
	int ofs;
	int x;
	int y;
	int v;

	xscrl = ram[0x2002];
	yscrl = ram[0x2003];
	ofs = (yscrl * 192 + xscrl) / 4; /* 0..12303 */
	xscrl &= 3;

	if(!xscrl) {
		/* قƂǂ̃Q[́A4sNZPʂ̃XN[g܂B(xscrl[1:0]=0)
		 * 4sNZPʂ̃XN[́AʍE̒[sNZ߁Aɏł܂B
		 */
		y = 160;
		do {
			x = 160 / 4;
			do {
				if(ofs >= (192 * 170) / 4) { /* 0..8159 */
					ofs -= (192 * 170) / 4;
				}
				v = vram[ofs++];
				*vbuff++ = v & 3; v >>= 2;
				*vbuff++ = v & 3; v >>= 2;
				*vbuff++ = v & 3; v >>= 2;
				*vbuff++ = v;
			} while(--x);
			ofs += (192 - 160) / 4; /* Gap */
		} while(--y);
	} else {
		/* ꕔ̃Q[(SSSnake)̂݁A1sNZPʂ̃XN[g܂B(xscrl[1:0]=1..3)
		 * 1sNZPʂ̃XN[́AʍE̒[sNZ̏KvŁAxȂ܂B
		 */
		y = 160;
		do {
			if(ofs >= (192 * 170) / 4) { /* 0..8159 */
				ofs -= (192 * 170) / 4;
			}
			v = vram[ofs++] >> xscrl * 2;
			x = 4 - xscrl;
			do {
				*vbuff++ = v & 3; v >>= 2;
			} while(--x);
			//
			x = 160 / 4 - 1;
			do {
				if(ofs >= (192 * 170) / 4) { /* 0..8159 */
					ofs -= (192 * 170) / 4;
				}
				v = vram[ofs++];
				*vbuff++ = v & 3; v >>= 2;
				*vbuff++ = v & 3; v >>= 2;
				*vbuff++ = v & 3; v >>= 2;
				*vbuff++ = v;
			} while(--x);
			//
			if(ofs >= (192 * 170) / 4) { /* 0..8159 */
				ofs -= (192 * 170) / 4;
			}
			v = vram[ofs/*++_!*/];
			x = xscrl;
			do {
				*vbuff++ = v & 3; v >>= 2;
			} while(--x);
			ofs += (192 - 160) / 4; /* Gap */
		} while(--y);
	}
}

#ifndef PIECE

/*
 * (]  5sNZ -> ]  4sNZ) x 32
 * (] c20C   -> ] c11C  ) x  8
 *
 * 20C -> 11C̈kp^[́ÂƂłB
 *
 *			]Line#	]Line#
 *	i=3		-----------	-----------
 *	i=3->2		 0+ 1		 0
 *	i=2->1		 2+ 3		 1
 *	i=1->0->6	 4   		 2
 *	i=6->5		 5+ 6		 3
 *	i=5->4		 7+ 8		 4
 *	i=4->3		 9+10		 5
 *	i=3->2		11+12		 6
 *	i=2->1		13+14		 7
 *	i=1->0->6	15   		 8
 *	i=6->5		16+17		 9
 *	i=5->4		18+19		10
 *
 * [note]
 *	* framdmv.cdmgvideo_reduce()قƂǂ̂܂ܗp܂B
 *	  ύX_́Aȉl(1->3)ƍĐݒl(3->6)łB
 */
void
svvideo_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*160*160*/])
{
	int i;
	int x;
	int y;
	int z;

	z = 8;
	do {
		y = 11;
		i = 3;
		do {
			x = 32;
			if(!--i) {
				do {
					dst[0] =  src[0];
					dst[1] =  src[1];
					dst[2] =  src[2];
					dst[3] = (src[3] + src[4] + 1) >> 1;
					dst += 4;
					src += 5;
				} while(--x);
				i = 6;
			} else {
				do {
					dst[0] = (src[0] + src[160] + 1) >> 1;
					dst[1] = (src[1] + src[161] + 1) >> 1;
					dst[2] = (src[2] + src[162] + 1) >> 1;
					dst[3] = (src[3] + src[163] +
					          src[4] + src[164] + 2) >> 2;
					dst += 4;
					src += 5;
				} while(--x);
				src += 160;
			}
		} while(--y);
	} while(--z);
}

#endif /*PIECE*/

/****************************************************************************
 *	Sound
 ****************************************************************************/

#ifndef PIECE

/*   Tone 0  t5bit
 * + Tone 1  t5bit
 * + Noise   t5bit
 * + DMA     t5bit (Ή)
 * =         t7bit
 */
#define SVSOUND_VOLUME_SHIFT	((16-7)+1/**/)

void
svsound_tone_mix(SVSOUNDTONE* tone, short wbuff[/*SVSOUNDBUFLEN*/])
{
	int i;
	int volume;
	int period;
	int polar;
	int count;
	int output;

	volume = tone->volume;
	if(!volume) {
		return;
	}

	period = tone->period;
	if(!period) {
		return;
	}

	polar = tone->polar;	/* o */
	count = tone->count;	/* o */

	output = polar ? volume : -volume;

	i = SVSOUNDBUFLEN;
	do {
		count -= (4000000 / SPEAKER_FREQUENCY) * 2/*ɐ]͔g`2{*/;
		if(count < 0) {
			do {
				polar ^= 1;
			} while((count += period) < 0);
			output = polar ? volume : -volume;
		}
		*wbuff++ += output;
	} while(--i);

	tone->polar = polar;	/* ߂ */
	tone->count = count;	/* ߂ */
}

void
svsound_noise_mix(SVSOUNDNOISE* noise, short wbuff[/*SVSOUNDBUFLEN*/])
{
	int i;
	int x;
	int volume;
	int period;
	int lfsr;
	int count;
	int output;

	if(!noise->on) {
		return;
	}

	volume = noise->volume;
	if(!volume) {
		return;
	}

	period = noise->period;
	if(!period) {
		return;
	}

	lfsr = noise->lfsr;	/* o */
	count = noise->count;	/* o */

	output = (lfsr & 1) ? volume : -volume;

	i = SVSOUNDBUFLEN;
	do {
		count--; /* f = 16KHz/period (dlsBƒfł) */
		if(count < 0) {
			do {
				/* 9bit: tap=0,5 (dlsBƒfł) */
				x = (lfsr ^ (lfsr >> 5)) & 1;
				lfsr = (lfsr >> 1) | (x << 8);
			} while((count += period) < 0);
			output = (lfsr & 1) ? volume : -volume;
		}
		*wbuff++ += output;
	} while(--i);

	noise->lfsr = lfsr;	/* ߂ */
	noise->count = count;	/* ߂ */
}

void
svsound_volume_shift(short wbuff[/*SVSOUNDBUFLEN*/])
{
	int i;
	int v;

	i = SVSOUNDBUFLEN;
	do {
		v = *wbuff;
		v <<= SVSOUND_VOLUME_SHIFT;
		if(v >  32767) v =  32767;
		if(v < -32768) v = -32768;
		*wbuff++ = v;
	} while(--i);
}

#endif /*PIECE*/
