/*	
 *	framsid.c
 *
 *	P/ECE SID(MOS6581) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Dec 28 21:25:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

/* o: Ȃ8bit */
int
sidto_process(SIDTO* to, int step)
{
	/* SIDdl
	 *	Fout = Fn * Fclk / 16777216 [Hz]
	 *	     = Fn * Fclk >> 24
	 * g[IV[^o͂24bitƂƁA
	 *	TOout = Fn * Fclk
	 * g[IV[^o͂8bitƂƁA
	 *	TOout = Fn * Fclk >> 16
	 * Fn = freq, Fclk = step Ȃ̂ŁA
	 *	progress += freq * step
	 *	TOout = (short)(progress >> 16)
	 */
	to->progress += to->freq/*16bit*/ * step/*7bit(1M/16K=62O)*/;
	return (unsigned char)(to->progress >> 16);
}

/* o: t8bit */
int
sidwg_process(SIDWG* wg, int value)
{
	int wf = wg->wf;

	/* TODO: Waveform̑gݍ킹͖ΉłB */
	if(wf & SIDWG_TRIANGLE) {
		//					/*    0`127,128` 255 */
		if(value > 127) value = 255 - value;	/*    0`127,127`   0 */
		value -= 64;				/*  -64` 63, 63` -64 */
		value <<= 1;				/* -128`126,126`-128 */
		value++;				/* -127`127,127`-127 */
	} else if(wf & SIDWG_SAWTOOTH) {
		//					/* 0`127, 128` 255 */
		value = (char)value;			/* 0`127,-128`  -1 */
	} else if(wf & SIDWG_PULSE) {
		//					/*   0` 255 */
		value <<= 4;				/*   0`4080 */
		value = value < wg->pw ? 127 : -127;	/* 127`-127 */
	} else if(wf & SIDWG_NOISE) {
		value = sid_noise_table[value];
	} else {
		value = 0;
	}

	return value;
}

/* o: Ȃ4bit */
int
sideg_process(SIDEG* eg, int step)
{
	int value;
	int progress;
	int rate;

	/* Ǝ蔲ȎŁA񏜎ZĂ܂Ă܂c */

	progress = eg->progress + step;
	switch(eg->cycle) {
	case SIDEG_ATTACK:
		rate = sid_attack_table[eg->atk];
		if(progress < rate) {
			value = 16/*15Ȃ!*/ * progress / rate;
			break;
		}
		progress -= rate;
		eg->cycle = SIDEG_DECAY;
		/* FALL THRU */
	case SIDEG_DECAY:
		rate = sid_decay_release_table[eg->dcy];
		if(progress < rate) {
			value = 15 - (15 - eg->stn) * progress / rate;
			break;
		}
		progress -= rate;
		eg->cycle = SIDEG_SUSTAIN;
		/* FALL THRU */
	case SIDEG_SUSTAIN:
		value = eg->stn;
		break;
	case SIDEG_RELEASE:
		rate = sid_decay_release_table[eg->rls];
		if(progress < rate) {
			value = eg->stn - eg->stn * progress / rate;
			break;
		}
		eg->cycle = 0;
		/* FALL THRU */
	default:
		value = 0;
		break;
	}
	eg->progress = progress;

	return value;
}

/* * sideg_process()Z𑽗p̂ŁAZCuRAMɒu܂B
 *   ܂A__divsi3sideg_process()̑O256oCgȓɂ΁Acall߂extsvɂȂ܂B
 *   ł邾sideg_process()́uvɒuĂB
 *   uOvłȂuvƂŔA__divsi3̃TCYɉZȂA
 *   uv̕߂Ȃ\łB
 *   SĂ__divsi3ĂяoA256oCgȓƂȂĂ邱ƂmF܂B(2003/12/28)
 * * Œ`__divsi3́AO[o__divsi3u܂񁚁B
 *   u.global __divsi3v錾ĂȂ̂ŁÃW[ł̂ݗLłB
 *   u.global __divsi3v錾ƁAEPSONCuƂԂĂ܂܂B
 */
#ifdef PIECE
asm("
	.code
	.align 2
	; .global 錾_!
__divsi3:
	ld.w %alr, %r12
	div0s %r13
	div1 %r13		;  1
	div1 %r13		;  2
	div1 %r13		;  3
	div1 %r13		;  4
	div1 %r13		;  5
	div1 %r13		;  6
	div1 %r13		;  7
	div1 %r13		;  8
	div1 %r13		;  9
	div1 %r13		; 10
	div1 %r13		; 11
	div1 %r13		; 12
	div1 %r13		; 13
	div1 %r13		; 14
	div1 %r13		; 15
	div1 %r13		; 16
	div1 %r13		; 17
	div1 %r13		; 18
	div1 %r13		; 19
	div1 %r13		; 20
	div1 %r13		; 21
	div1 %r13		; 22
	div1 %r13		; 23
	div1 %r13		; 24
	div1 %r13		; 25
	div1 %r13		; 26
	div1 %r13		; 27
	div1 %r13		; 28
	div1 %r13		; 29
	div1 %r13		; 30
	div1 %r13		; 31
	div1 %r13		; 32
	div2s %r13
	div3s
	ret.d
	ld.w %r10, %alr		; *delay*(undoc'd)
");
#endif /*PIECE*/

/* o: t12bit */
int
sid_voice_process(SIDVOICE* voice, int step)
{
	int value;

	value = sidto_process(&voice->to, step);	/* Ȃ 8bit */
	value = sidwg_process(&voice->wg, value);	/* t 8bit */
	value *= sideg_process(&voice->eg, step);	/* t12bit */

	return value;
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

int
sid_mix1(SID* sid, int* pstep)
{
	int step;
	int value;
	int i_voice;
	SIDVOICE* voice;

	/* NbNiނ? */
	step = sid->clock.u;
	sid->clock.d += sid->clock.n;
	if(sid->clock.d >= 0) {
		sid->clock.d -= SPEAKER_FREQUENCY;
		step++;
	}
	*pstep = step; /* o߃NbNi[ */

	/* VOICE1`3̏o͂܂B */
	value = 0;
	voice = sid->voice;
	for(i_voice = 0; i_voice < 3; i_voice++) {
		value += sid_voice_process(voice, step);
		voice++;
	}
	/* value: t12bit ~ 3 = t13.5bit */
	/* vol  : Ȃ 4bit */
	value *= sid->vol; /* t17.5bit */

	return value;
}

