/*	
 *	framsds.c
 *
 *	P/ECE S-DSP Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Jan 06 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

void
sdsp_mix(SDSP* sdsp, short wbuff[/*count*/], int count)
{
#define MIXBUFLEN	64	/* PʁB傫łAX^bNɒ!! */

	static int mixbuf[MIXBUFLEN];	/* X^bN̂߁ASTATIC! */
	//
	int subcnt;
	int value;
	int i_voice;
	SDSPVOICE* voice;
	//
	int mvol = sdsp->mvol;
	short* dst = wbuff;
	int* src;

	/* vꂽcountTvAMIXBUFLENTvÂɕď܂B */
	while(count > 0) {
		/* Tv邩? */
		subcnt = count;
		if(subcnt > MIXBUFLEN) subcnt = MIXBUFLEN;
		count -= subcnt;

		/* ܂NAB */
		memset(mixbuf, 0, sizeof(int) * subcnt);

		/* Voice-0`7̏o͂܂B */
		value = 0;
		for(i_voice = 0, voice = sdsp->voice; i_voice < 8; i_voice++, voice++) {
			sdsp_voice_mix(sdsp, voice, mixbuf, subcnt); /* t16bit */
		}
		/* t16bit~8 => t19bit */

		/* XP[OB */
		src = mixbuf;
		do {
			/* C{[𔽉f܂B */
			value = *src++;
			value *= mvol; /* t19bit~Ȃ8bit => t27bit */
			value >>= 27 - 16 - 1/**/;

			/* NbsOĊi[܂B */
			if(value < -0x7fff) value = -0x7fff;
			if(value >  0x7fff) value =  0x7fff;
			*dst++ = value;
		} while(--subcnt);
	}

#undef MIXBUFLEN
}

//񂺂񖢎BƂ肠mRMgŎĂ݂܂B
void
sdsp_voice_mix(SDSP* sdsp, SDSPVOICE* voice, int* mixbuf, int count)
{
	int progress;
	int p;
	int offset;
	int value;

	if(!voice->vol) return;
	if(voice->state <= SDSVOICE_RELEASE) return;

	progress = voice->progress;
	p = voice->p;
	do {
		progress += p;
		offset = progress >> 11;
		value = (char)((offset & 31) << 3) << 8; /* t16bit */
		*mixbuf++ += value;
	} while(--count);
	voice->progress = progress;
}

