/*	
 *	frampsid.c
 *
 *	P/ECE PSID Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Dec 28 21:38:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	M6502G~[VpO֐
 ****************************************************************************/

void
psid_m6502_write(M6502* m6502, unsigned short addr, unsigned char data)
{
	PSIDDRIVER* psid = (PSIDDRIVER*)m6502;
	unsigned char* mem = psid->mem;

	/* * mem[0x0001](bit2`0)̃oN؂芷WX^ɂ:
	 *   I/Ö($d000-dfff)̃oN؂芷ƓłB
	 *
	 *	mem[1](2-0)	$a000-$bfff	$d000-dfff	$e000-$ffff
	 *	       000	RAM		RAM		RAM
	 *	       001	RAM		Character ROM	RAM
	 *	       010	RAM		Character ROM	Kernel ROM
	 *	       011	BASIC ROM	Character ROM	Kernel ROM
	 *	       100	RAM		I/O		RAM
	 *	       101	RAM		I/O		RAM
	 *	       110	RAM		I/O		Kernel ROM
	 *	       111	BASIC ROM	I/O		Kernel ROM
	 */
	if((addr >= 0xd000 && addr <= 0xdfff) &&	/* I/O Area access */
	   (mem[0x0001] & 4)) {				/* I/O Switched in */
		psid_m6502_out(m6502, addr, data);
		return;
	}

	/* Main Memory */
	mem[addr] = data;
}

/****************************************************************************
 *	PSIDhCo֐
 ****************************************************************************/

int
psid_mix(PSIDDRIVER* psid, short* wbuff)
{
	M6502* m6502 = &psid->m6502;
	SID* sid = &psid->sid;
	int i_sample;
	int value;
	int step;

	for(i_sample = 0; i_sample < SIDBUFLEN; i_sample++) {
		/* 1TvAo߃NbN擾B */
		value  = sid_mix1(sid, &step);		/* Real SID    : t17.5bit */
		value += psid_xsid_process(psid, step);	/* Extended SID: t17.5bit */

		/* XP[OENbsOĊi[B */
		value >>= 1; /*  */
		if(value < -0x7fff) value = -0x7fff;
		if(value >  0x7fff) value =  0x7fff;
		*wbuff++ = value;

		/* IRQ`FbNB
		 * PSIDhCocia_count=0Ȃ̂ŁA񃋁[vŕKIRQ܂B
		 */
		psid->cia_count -= step;
		//while(psid->cia_count <= 0) {
		//cia_timer͏㉺oCgʁXɏނ߁AύXr̒l̉\܂B
		//  ^C~Ocia_timer=0ɂȂĂƖ[v̋ꂪ̂ŁAwhile()͂߂܂B
		if(psid->cia_count <= 0) {
			psid->cia_count += psid->cia_timer;
			/* tĂяoZbgAbvB */
			psid_m6502_setup(psid, 0, psid->play_addr);
		}

		/* o߃NbN̕ACPUs܂B */
		m6502_run(m6502, m6502->cycle + step);
	}
	/* play_addr̂荞ݏȂ̂ŁAm6502_int()͕svłB */

	return 0;
}

