/*	
 *	framppu.c
 *
 *	P/ECE PPU (RICOH RP2C02) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun Jan 30 21:25:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

#ifndef PPU_ASM

#ifdef PPU_GRAYSCALE
/*
 * * k 256pixel -> 128pixel ́A1/2kłB
 *
 * * k 240pixel ->  88pixel ́A1/3kłB
 *   88~3=264łAP1/3kł͓]pixel܂B
 *   ŁA]lineꕔI[o[bv邱Ƃɂ܂B
 *   ]30line -> ]11line ̈kA8ubNJԂ܂B
 *   ŏ̃ubŃA]30line]11lineւ̑Ή́A̒ʂłB
 *   (..)tlinéAI[o[bvĂ邱Ƃ\܂B
 *
 *	]line	]line
 *	----------	----------
 *	  0  1  2	  0		3C (i=3->2)
 *	  3  4  5	  1		3C (i=2->1)
 *	  6  7( 8)	  2		2C (i=1->0->3)
 *	( 8) 9 10	  3		3C (i=3->2)
 *	 11 12 13	  4		3C (i=2->1)
 *	 14 15(16)	  5		2C (i=1->0->3)
 *	(16)17 18	  6		3C (i=3->2)
 *	 19 20 21	  7		3C (i=2->1)
 *	 22 23(24)	  8		2C (i=1->0->3)
 *	(24)25 26	  9		3C (i=3->2)
 *	 27 28 29	 10		3C (i=2->1)
 *	----------	----------
 *
 *   ̃ubŃA]30line]11lineւ̑Ή́A̒ʂłB
 *   ŏ̃ubN̓]line+30A]line+11ƂAp^[łB
 *
 *	]line	]line
 *	----------	----------
 *	 30 31 32	 11		3C (i=3->2)
 *	 33 34 35	 12		3C (i=2->1)
 *	 36 37(38)	 13		2C (i=1->0->3)
 *	(38)39 40	 14		3C (i=3->2)
 *	 41 42 43	 15		3C (i=2->1)
 *	 44 45(46)	 16		2C (i=1->0->3)
 *	(46)47 48	 17		3C (i=3->2)
 *	 49 50 51	 18		3C (i=2->1)
 *	 52 53(54)	 19		2C (i=1->0->3)
 *	(54)55 56	 20		3C (i=3->2)
 *	 57 58 59	 21		3C (i=2->1)
 *	----------	----------
 *
 *   ȍ~̃ubNɂĂlłB
 *
 * * ȏ̂悤ɁA1/2A1/3ňks܂B
 *   Ȃ킿A]6pixel -> ]1pixel Ɉk܂B
 *   OCXP[̕`pixelĺA(p*6)/16  0..15 ͈̔͂ɂȂ悤ɐݒ肵Ă܂B
 *   (ppu_grayscale_table[]̃RgQƂĂB)
 *   6pixel̍vAE4bitVtg΁A0..15̌ʂ܂B
 *   `pixell 0..42 Ȃ̂ŁA6pixelvĂ 0..252 ŁA1byteŉZł܂B
 *   𗘗pāAsNZ܂Ƃ߂ĉZ邱Ƃł܂B
 */
void
ppu_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*256*240*/])
{
	const unsigned int* tmp = (const unsigned int*)src;
	      unsigned int  v;
	//
	int c;
	int i;
	int x;
	int y;
	int z;

	z = 240 / 30;
	do {
		i = 3; /* ʏ3CցB312C */
		y = 11;
		do {
			x = 256 / 4;
			do {
				/* v[ 7: 0] = (0,0)+(0,1)+(0,2) */
				/* v[15: 8] = (1,0)+(1,1)+(1,2) */
				/* v[23:16] = (2,0)+(2,1)+(2,2) */
				/* v[31:14] = (3,0)+(3,1)+(3,2) */
				v = tmp[0] + tmp[256 / 4] + tmp[512 / 4];

				/* c = (0,0)+(1,0)+(0,1)+(1,1)+(0,2)+(1,2) */
				c   = v;
				v >>= 8;
				c  += v;
				*dst++ = (unsigned char)c >> 4; /* 0..15 */

				v >>= 8;

				/* c = (2,0)+(3,0)+(2,1)+(3,1)+(2,2)+(3,2) */
				c   = v;
				v >>= 8;
				c  += v;
				*dst++ = (unsigned char)c >> 4; /* 0..15 */

				tmp++;
			} while(--x);
			if(--i) {
				tmp += (256 * (3 - 1)) / 4; /* 3C */
			} else {
				tmp += (256 * (2 - 1)) / 4; /* 2C */
				i = 3; /* ܂32C */
			}
		} while(--y);
	} while(--z);
}
#endif PPU_GRAYSCALE

#endif /*PPU_ASM*/

