/*	
 *	frampp4.c
 *
 *	P/ECE PPU (RICOH RP2C02) Emulator (1/4𑜓x)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed Feb 09 04:34:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

#ifndef PPU_ASM

#ifdef PPU_GRAYSCALE
/*
 * *  128pixel -> 128pixel ŁAkłB
 *
 * * k 120pixel ->  88pixel ́A1/2kłB
 *   88~2=176łAP1/2kł͓]pixel܂B
 *   ŁA]lineꕔI[o[bv邱Ƃɂ܂B
 *   ]15line -> ]11line ̈kA8ubNJԂ܂B
 *   ŏ̃ubŃA]15line]11lineւ̑Ή́A̒ʂłB
 *   (..)tlinéAI[o[bvĂ邱Ƃ\܂B
 *
 *	]line	]line
 *	----------	----------	            (i=l2)
 *	  0  ( 1)	  0		1C (i=2->1)
 *	( 1)   2 	  1		2C (i=1->0->3)
 *	  3  ( 4)	  2		1C (i=3->2)
 *	( 4) ( 5)	  3		1C (i=2->1)
 *	( 5)   6 	  4		2C (i=1->0->3)
 *	  7  ( 8)	  5		1C (i=3->2)
 *	( 8) ( 9)	  6		1C (i=2->1)
 *	( 9)  10 	  7		2C (i=1->0->3)
 *	 11  (12)	  8		1C (i=3->2)
 *	(12) (13)	  9		1C (i=2->1)
 *	(13)  14 	 10		2C (i=1->0->3)
 *	----------	----------
 *
 *   ̃ubŃA]15line]11lineւ̑Ή́A̒ʂłB
 *   ŏ̃ubN̓]line+15A]line+11ƂAp^[łB
 *
 *	]line	]line
 *	----------	----------	            (i=l2)
 *	 15  (16)	 11		1C (i=2->1)
 *	(16)  17 	 12		2C (i=1->0->3)
 *	 18  (19)	 13		1C (i=3->2)
 *	(19) (20)	 14		1C (i=2->1)
 *	(20)  21 	 15		2C (i=1->0->3)
 *	 22  (23)	 16		1C (i=3->2)
 *	(23) (24)	 17		1C (i=2->1)
 *	(24)  25 	 18		2C (i=1->0->3)
 *	 26  (27)	 19		1C (i=3->2)
 *	(27) (28)	 20		1C (i=2->1)
 *	(28)  29 	 21		2C (i=1->0->3)
 *	----------	----------
 *
 *   ȍ~̃ubNɂĂlłB
 */
void
ppu4_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*128*120*/])
{
	const unsigned int* tmp = (const unsigned int*)src;
	      unsigned int  v;
	//
	int i;
	int x;
	int y;
	int z;

	z = 120 / 15;
	do {
		i = 2; /* ʏ1CցB312CցBŏ22CցB */
		y = 11;
		do {
			x = 128 / 4;
			do {
				/* v[ 7: 0] = (0,0)+(0,1) */
				/* v[15: 8] = (1,0)+(1,1) */
				/* v[23:16] = (2,0)+(2,1) */
				/* v[31:14] = (3,0)+(3,1) */
				v = tmp[0] + tmp[128 / 4];

				*dst++ = (unsigned char)v >> 1; /* ((0,0)+(0,1))/2 */
				v >>= 8;
				*dst++ = (unsigned char)v >> 1; /* ((1,0)+(1,1))/2 */
				v >>= 8;
				*dst++ = (unsigned char)v >> 1; /* ((2,0)+(2,1))/2 */
				v >>= 8;
				*dst++ = (unsigned char)v >> 1; /* ((3,0)+(3,1))/2 */

				tmp++;
			} while(--x);
			if(--i) {
			//	tmp += (128 * (1 - 1)) / 4; /* 1C */ -> "tmp+=0"Ɠł
			} else {
				tmp += (128 * (2 - 1)) / 4; /* 2C */
				i = 3; /* ܂32C */
			}
		} while(--y);
	} while(--z);
}
#endif PPU_GRAYSCALE

#endif /*PPU_ASM*/

