/*	
 *	framp62.c
 *
 *	P/ECE HuC6280-PSG Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
huc6280psg_mix(HUC6280PSG* psg, short wbuff[/*count*/], int count)
{
	DDA clock_progress;
	int cycle;
	int sample;

	clock_progress = psg->clock_progress; /* ̂߁Aꎞo */
	while(count > 0) {
		/* o߃TCN߂܂B */
		cycle = clock_progress.u;
		clock_progress.d += clock_progress.n;
		if(clock_progress.d >= 0) {
			clock_progress.d -= SPEAKER_FREQUENCY;
			cycle++;
		}

		/* 1Tv~LVO܂B */
		sample = huc6280psg_process(psg, cycle);
		sample >>= (23 - 16) - 2/*(₷Ɖʑ傫Ȃ܂)*/;

		/* NbsOĊi[܂B */
		if(sample < -0x7fff) sample = -0x7fff;
		if(sample >  0x7fff) sample =  0x7fff;
		*wbuff++ = sample;

		/* cTv炵܂B */
		count--;
	}
	psg->clock_progress = clock_progress; /* ߂BYꂸȂ!! */
}

/****************************************************************************
 *	֐
 ****************************************************************************/

/* `lo:t20bit ~ 6`l  t22.6bit */
int
huc6280psg_process(HUC6280PSG* psg, int cycle)
{
	return huc6280psg_channel_process(psg, &psg->channel[0], cycle)
	     + huc6280psg_channel_process(psg, &psg->channel[1], cycle)
	     + huc6280psg_channel_process(psg, &psg->channel[2], cycle)
	     + huc6280psg_channel_process(psg, &psg->channel[3], cycle)
	     + huc6280psg_channel_process(psg, &psg->channel[4], cycle)
	     + huc6280psg_channel_process(psg, &psg->channel[5], cycle);
}

#ifndef PIECE

/* g`f[^:t5bit ~ `l{[:15bit  t20bit */
int
huc6280psg_channel_process(HUC6280PSG* psg, HUC6280PSGCHANNEL* channel, int cycle)
{
	char sample;

	if(!channel->enable) return 0;

	/* enable=0̑volume=0Ń`lOffsHESt@C܂B
	 * ̍ہAperiodɏȒl(1)ɐݒ肳Ă邱Ƃ悤łB
	 * ("Aero Blasters.hes","Spin Pair.hes"̈ꕔ̃gbN)
	 * periodƏԂɍȂȂ̂ŁAvolume=0𒲂ׂĒeƂɂ܂B
	 */
	if(!channel->volume) return 0;

	if(!channel->dda) {
		if(!channel->noise) { /* Tone mode */
			channel->tone_progress -= cycle;
			while(channel->tone_progress <= 0) {
				channel->tone_progress += channel->tone_period;
				channel->tone_index++;
			}
			sample = channel->wave[channel->tone_index & 0x1f];

		} else { /* Noise mode */
			channel->noise_progress -= cycle;
			while(channel->noise_progress <= 0) {
				channel->noise_progress += channel->noise_period;
				/* @̓̎dl킩Ȃ̂ŁA[9bit tap=0x11]Mn񗐐gƂɂ܂B */
				channel->noise_lfsr = (channel->noise_lfsr >> 1) |
						    (((channel->noise_lfsr >> 0) ^ (channel->noise_lfsr >> 4)) & 1) << 8;
			}
			sample = channel->noise_lfsr & 1 ? 15 : -16;
		}

	} else { /* Direct D/A mode */
		sample = channel->wave[0];
	}

	return sample * channel->volume; /* AZúAshort~shortō */
}

#else /*PIECE*/

/* * ̂߁ACłƃAZułł͋͂ɏo͂قȂ܂B
 *   CłƃAZułŏقȂĂ_́ÂƂłB
 *
 * - isJE^̂قȂ܂B
 *
 *   [C]
 *	o߃TCNZāAu0ȉvɂȂƂ[vɓAu0߁vɂȂ܂ŎlZ܂B
 *
 *   [AZu]
 *	o߃TCNZāAu0vɂȂƂ[vɓAu0ȏvɂȂ܂ŎlZ܂B
 *
 *   ̈ႢɂAo͔g`̈ʑő1Tv(=1/SPEAKER_FREQUENCY[b])\܂B
 *
 * - mCYWFl[^̐UقȂ܂B
 *
 *   [C]
 *	mCYWFl[^̏o̓Tv́A-16`+15łB
 *   [AZu]
 *	mCYWFl[^̏o̓Tv́A-16`+16łB
 *
 *   ̈ႢɂAmCY{[33/32{(=3%)ɂȂ܂B
 */
asm("
	.code
	.align 1
	.global huc6280psg_channel_process
huc6280psg_channel_process:
	xld.ub %r10, [%r13+6]				; %r10 = channel->enable					| + 6, 1: unsigned char enable
	xcmp %r10, 0					; if(!channel->enable) return 0 !INTERLOCK!
	xjreq huc6280psg_channel_process_disable
	;
	xld.h %r10, [%r13+10]				; %r10 = channel->volume					| +10, 2: short volume
	xcmp %r10, 0					; if(!channel->volume) return 0 !INTERLOCK!
	xjreq huc6280psg_channel_process_disable
	;
	xbtst [%r13+7], 0				; if(channel->dda) goto huc6280psg_channel_process_dda		| + 7, 1: unsigned char dda
	xjrne huc6280psg_channel_process_dda
	;
	xbtst [%r13+8], 0				; if(channel->noise) goto huc6280psg_channel_process_noise	| + 8, 1: unsigned char noise
	xjrne huc6280psg_channel_process_noise
	;
	;/*===== Tone mode =====*/
	xld.w %r4, [%r13+16]				; %r4 = channel->tone_progress					| +16, 4: int tone_progress
	xld.uh %r5, [%r13+28]				; %r5 = channel->tone_index *anti-interlock*			| +28, 2: unsigned short tone_index
	sub %r4, %r14					; channel->tone_progress -= cycle
	xjruge huc6280psg_channel_process_tone_break	; if(!%psr(C)) goto huc6280psg_channel_process_tone_break
	;
	xld.w %r6, [%r13+12]				; %r6 = channel->tone_period					| +12, 4: int tone_period
huc6280psg_channel_process_tone_loop:
	add %r4, %r6					; channel->tone_progress += channel->tone_period
	xjruge.d huc6280psg_channel_process_tone_loop	; if(!%psr(C)) goto huc6280psg_channel_process_tone_loop
	add %r5, 1					; channel->tone_index++ *delay*
	xld.h [%r13+28], %r5				; (store channel->tone_index)					| +28, 2: unsigned short tone_index
	;
huc6280psg_channel_process_tone_break:
	xld.w [%r13+16], %r4				; (store channel->tone_progress)				| +16, 4: int tone_progress
	;
	xand %r5, %r5, 0x1f				; %r11 = channel->wave[channel->tone_index & 0x1f]
	xadd %r5, %r5, 32				;								| +32,32: char wave[32]
	add %r5, %r13
	xld.b %r11, [%r5]
	;
	mlt.h %r10, %r11				; %alr = volume * sample !INTERLOCK!
	ret.d
	ld.w %r10, %alr					; %r10 = output *delay*(undoc'd)
	;
	;/*===== Noise mode =====*/
huc6280psg_channel_process_noise:
	xld.w %r4, [%r13+24]				; %r4 = channel->noise_progress					| +24, 4: int noise_progress
	xld.uh %r5, [%r13+30]				; %r5 = channel->noise_lfsr *anti-interlock*			| +30, 2: unsigned short noise_lfsr
	sub %r4, %r14					; channel->noise_progress -= cycle
	xjruge huc6280psg_channel_process_noise_break	; if(!%psr(C)) goto huc6280psg_channel_process_noise_break
	;
	xld.w %r6, [%r13+20]				; %r6 = channel->noise_period					| +20, 4: int noise_period
huc6280psg_channel_process_noise_loop:
	ld.w %r7, %r5					; lfsr = lfsr>>1 | ((lfsr^(lfsr>>4))&1)<<8
	xsrl %r7, 4
	xor %r7, %r5
	xand %r7, %r7, 1
	xsll %r7, 8
	xsrl %r5, 1
	add %r4, %r6					; channel->noise_progress += channel->noise_period
	xjruge.d huc6280psg_channel_process_noise_loop	; if(!%psr(C)) goto huc6280psg_channel_process_noise_loop
	or %r5, %r7					; *delay*
	xld.h [%r13+30], %r5				; (store channel->noise_lfsr)					| +30, 2: unsigned short noise_lfsr
	;
huc6280psg_channel_process_noise_break:
	xld.w [%r13+24], %r4				; (store channel->noise_progress)				| +24, 4: int noise_progress
	;
	xand %r5, %r5, 1				; %r5 =  1 or   0
	xsll %r5, 5					; %r5 = 32 or   0
	xsub %r5, %r5, 16				; %r5 = 16 or -16
	mlt.h %r10, %r5					; %alr = volume * sample
	ret.d
	ld.w %r10, %alr					; %r10 = output *delay*(undoc'd)
	;
	;/*===== Direct D/A mode =====*/
huc6280psg_channel_process_dda:
	xld.b %r11, [%r13+32]				; %r11 = channel->wave[0]					| +32,32: char wave[32]
	;
	mlt.h %r10, %r11				; %alr = volume * sample !INTERLOCK!
	ret.d
	ld.w %r10, %alr					; %r10 = output *delay*(undoc'd)
	;
	;/*===== Disabled channel =====*/
huc6280psg_channel_process_disable:
	ret						;  %r10=0 ɂȂĂ܂B
");

#endif /*PIECE*/

