/*	
 *	framn2.c
 *
 *	P/ECE YM2612(OPN2) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Dec 05 03:03:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

#ifndef YM2612_ASM

/****************************************************************************
 *
 ****************************************************************************/

int
ym2612op_env_attack(YM2612OP* op, int eg_cnt)
{
	eg_cnt += op->eg_ar;
	if(eg_cnt >= op->eg_tl) {
		op->eg_env = ym2612op_env_decay;
		eg_cnt = op->eg_tl;
	}
	return eg_cnt;
}

int
ym2612op_env_decay(YM2612OP* op, int eg_cnt)
{
	eg_cnt -= op->eg_dr;
	if(eg_cnt <= op->eg_sl) {
		op->eg_env = ym2612op_env_sustain;
		eg_cnt = op->eg_sl;
	}
	return eg_cnt;
}

int
ym2612op_env_sustain(YM2612OP* op, int eg_cnt)
{
	eg_cnt -= op->eg_sr;
	if(eg_cnt <= 0) {
		op->eg_env = ym2612op_env_silent;
		eg_cnt = 0;
	}
	return eg_cnt;
}

int
ym2612op_env_release(YM2612OP* op, int eg_cnt)
{
	eg_cnt -= op->eg_rr;
	if(eg_cnt <= 0) {
		op->eg_env = ym2612op_env_silent;
		eg_cnt = 0;
	}
	return eg_cnt;
}

int
ym2612op_env_silent(YM2612OP* op, int eg_cnt)
{
	return 0;
}

/****************************************************************************
 *
 ****************************************************************************/

#define ym2612op_mix_begin() {		\
	int pg_cnt[4];			\
	int eg_cnt[4];			\
	pg_cnt[0] = ch->op[0].pg_cnt;	\
	pg_cnt[1] = ch->op[1].pg_cnt;	\
	pg_cnt[2] = ch->op[2].pg_cnt;	\
	pg_cnt[3] = ch->op[3].pg_cnt;	\
	eg_cnt[0] = ch->op[0].eg_cnt;	\
	eg_cnt[1] = ch->op[1].eg_cnt;	\
	eg_cnt[2] = ch->op[2].eg_cnt;	\
	eg_cnt[3] = ch->op[3].eg_cnt;

#define ym2612op_mix_end()		\
	ch->op[0].pg_cnt = pg_cnt[0];	\
	ch->op[1].pg_cnt = pg_cnt[1];	\
	ch->op[2].pg_cnt = pg_cnt[2];	\
	ch->op[3].pg_cnt = pg_cnt[3];	\
	ch->op[0].eg_cnt = eg_cnt[0];	\
	ch->op[1].eg_cnt = eg_cnt[1];	\
	ch->op[2].eg_cnt = eg_cnt[2];	\
	ch->op[3].eg_cnt = eg_cnt[3]; }	\

#define ym2612op_mix(i_op, op_in, op_out) do {						\
	YM2612OP* op = &ch->op[i_op];							\
											\
	short pg_out;									\
	short eg_out;									\
											\
	pg_cnt[i_op] += op->pg_spd;							\
	pg_out = ym2612op_pg_table[((pg_cnt[i_op] + (op_in)) >> 16) & 255];		\
	/*			     ~~~~~~~~~~~~   ~~~~~~~			*/	\
	/*			     u8.16          s8.16			*/	\
	/*			   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~		*/	\
	/*							 u8		*/	\
	/*	 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	*/	\
	/*								s9	*/	\
											\
	eg_cnt[i_op] = op->eg_env(op, eg_cnt[i_op]);					\
	eg_out = eg_cnt[i_op] >> 8;							\
	/*	 ~~~~~~~~~~~		*/						\
	/*	 u7.16			*/						\
	/*	 ~~~~~~~~~~~~~~~~~	*/						\
	/*		       u15	*/						\
											\
	op_out = pg_out * eg_out; /* mlt.h */						\
	/*	 ~~~~~~   ~~~~~~	*/						\
	/*	 s9       u15		*/						\
	/*	 ~~~~~~~~~~~~~~~	*/						\
	/*		   s8.16	*/						\
} while(0)

#define ym2612op_fb() do {				\
	if(ch->fb) ch->fb_in = op_out1 << ch->fb >> 6;	\
} while(0)

/****************************************************************************
 *
 ****************************************************************************/

/* Algorithm = 0
 *
 *	[1]-[2]-[3]-[4]->
 */
void
ym2612ch_mix0(YM2612CH* ch, int mixbuf[/*count*/], int count)
{
	int op_out1;
	int op_out2;
	int op_out3;
	int op_out4;

	ASSERT(count > 0);

	ym2612op_mix_begin();
	do {

		ym2612op_mix(0, ch->fb_in, op_out1); ym2612op_fb();
		ym2612op_mix(1, op_out1  , op_out2);
		ym2612op_mix(2, op_out2  , op_out3);
		ym2612op_mix(3, op_out3  , op_out4);

		*mixbuf++ += op_out4;

	} while(--count);
	ym2612op_mix_end();
}

/* Algorithm = 1
 *
 *	[1]-+
 *	    +-[3]-[4]->
 *	[2]-+
 */
void
ym2612ch_mix1(YM2612CH* ch, int mixbuf[/*count*/], int count)
{
	int op_out1;
	int op_out2;
	int op_out3;
	int op_out4;

	ASSERT(count > 0);

	ym2612op_mix_begin();
	do {

		ym2612op_mix(0, ch->fb_in        , op_out1); ym2612op_fb();
		ym2612op_mix(1, 0                , op_out2);
		ym2612op_mix(2, op_out1 + op_out2, op_out3);
		ym2612op_mix(3, op_out3          , op_out4);

		*mixbuf++ += op_out4;

	} while(--count);
	ym2612op_mix_end();
}

/* Algorithm = 2
 *
 *	[1]-----+
 *	        +-[4]->
 *	[2]-[3]-+
 */
void
ym2612ch_mix2(YM2612CH* ch, int mixbuf[/*count*/], int count)
{
	int op_out1;
	int op_out2;
	int op_out3;
	int op_out4;

	ASSERT(count > 0);

	ym2612op_mix_begin();
	do {

		ym2612op_mix(0, ch->fb_in        , op_out1); ym2612op_fb();
		ym2612op_mix(1, 0                , op_out2);
		ym2612op_mix(2, op_out2          , op_out3);
		ym2612op_mix(3, op_out1 + op_out3, op_out4);

		*mixbuf++ += op_out4;

	} while(--count);
	ym2612op_mix_end();
}

/* Algorithm = 3
 *
 *	[1]-[2]-+
 *	        +-[4]->
 *	[3]-----+
 */
void
ym2612ch_mix3(YM2612CH* ch, int mixbuf[/*count*/], int count)
{
	int op_out1;
	int op_out2;
	int op_out3;
	int op_out4;

	ASSERT(count > 0);

	ym2612op_mix_begin();
	do {

		ym2612op_mix(0, ch->fb_in        , op_out1); ym2612op_fb();
		ym2612op_mix(1, op_out1          , op_out2);
		ym2612op_mix(2, 0                , op_out3);
		ym2612op_mix(3, op_out2 + op_out3, op_out4);

		*mixbuf++ += op_out4;

	} while(--count);
	ym2612op_mix_end();
}

/* Algorithm = 4
 *
 *	[1]-[2]-+
 *	        +->
 *	[3]-[4]-+
 */
void
ym2612ch_mix4(YM2612CH* ch, int mixbuf[/*count*/], int count)
{
	int op_out1;
	int op_out2;
	int op_out3;
	int op_out4;

	ASSERT(count > 0);

	ym2612op_mix_begin();
	do {

		ym2612op_mix(0, ch->fb_in, op_out1); ym2612op_fb();
		ym2612op_mix(1, op_out1  , op_out2);
		ym2612op_mix(2, 0        , op_out3);
		ym2612op_mix(3, op_out3  , op_out4);

		*mixbuf++ += op_out2 + op_out4;

	} while(--count);
	ym2612op_mix_end();
}

/* Algorithm = 5
 *
 *	    +-[2]-+
 *	    |     |
 *	[1]-+-[3]-+->
 *	    |     |
 *	    +-[4]-+
 */
void
ym2612ch_mix5(YM2612CH* ch, int mixbuf[/*count*/], int count)
{
	int op_out1;
	int op_out2;
	int op_out3;
	int op_out4;

	ASSERT(count > 0);

	ym2612op_mix_begin();
	do {

		ym2612op_mix(0, ch->fb_in, op_out1); ym2612op_fb();
		ym2612op_mix(1, op_out1  , op_out2);
		ym2612op_mix(2, op_out1  , op_out3);
		ym2612op_mix(3, op_out1  , op_out4);

		*mixbuf++ += op_out2 + op_out3 + op_out4;

	} while(--count);
	ym2612op_mix_end();
}

/* Algorithm = 6
 *
 *	[1]-[2]-+
 *	        |
 *	[3]-----+->
 *	        |
 *	[4]-----+
 */
void
ym2612ch_mix6(YM2612CH* ch, int mixbuf[/*count*/], int count)
{
	int op_out1;
	int op_out2;
	int op_out3;
	int op_out4;

	ASSERT(count > 0);

	ym2612op_mix_begin();
	do {

		ym2612op_mix(0, ch->fb_in, op_out1); ym2612op_fb();
		ym2612op_mix(1, op_out1  , op_out2);
		ym2612op_mix(2, 0        , op_out3);
		ym2612op_mix(3, 0        , op_out4);

		*mixbuf++ += op_out2 + op_out3 + op_out4;

	} while(--count);
	ym2612op_mix_end();
}

/* Algorithm = 7
 *
 *	[1]-+
 *	    |
 *	[2]-+
 *	    +->
 *	[3]-+
 *	    |
 *	[4]-+
 */
void
ym2612ch_mix7(YM2612CH* ch, int mixbuf[/*count*/], int count)
{
	int op_out1;
	int op_out2;
	int op_out3;
	int op_out4;

	ASSERT(count > 0);

	ym2612op_mix_begin();
	do {

		ym2612op_mix(0, ch->fb_in, op_out1); ym2612op_fb();
		ym2612op_mix(1, 0        , op_out2);
		ym2612op_mix(2, 0        , op_out3);
		ym2612op_mix(3, 0        , op_out4);

		*mixbuf++ += op_out1 + op_out2 + op_out3 + op_out4;

	} while(--count);
	ym2612op_mix_end();
}

/****************************************************************************
 *
 ****************************************************************************/

short*
ym2612_copy(short* wbuff, const int* mixbuf, int count)
{
	int v;

	ASSERT(count > 0);

	do {
		v = *mixbuf++;
		v >>= COPY_SHIFT;
		if(v >  32767) v =  32767;
		if(v < -32768) v = -32768;
		*wbuff++ = v;
	} while(--count);

	return wbuff;
}

/****************************************************************************
 *
 ****************************************************************************/

#endif /*YM2612_ASM*/
