/*	
 *	frammod1.c
 *
 *	RAMɓ]郂W[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2002 Naoyuki Sawa
 *
 *	* Tue Nov 19 12:30:00 JST 2002 Naoyuki Sawa
 *	- clipdobj.cclipmod.cARs[ECĐVK쐬܂B
 *	* Sun Dec 8 05:43:00 JST 2002 Naoyuki Sawa
 *	- mod_mix()̃[voOCB
 *	- e|GtFNgΉB
 *	* Fri Jan 31 21:57:00 JST 2003 Naoyuki Sawa
 *	- new_LCDDrawObject()PIXEL(p,m)}Nmask蕔ǁB
 *	 u(mask >> (m) & 1)vu(mask & (1 << (m)))vɕύX܂B
 *	  3%(Sʓ])AR[hTCY20oCgȂȂ܂B
 *	  ̉ǂ́uryuǩOH[v(http://www.interq.or.jp/earth/ryuk/)ɂ̂łB
 *	- new_LCDDrawObject()̃NbsOʊO菈ǁB
 *	  ܂ŁA]Ȃ/肻ꂼ̏̒ōsĂ̂AʉĂ܂Ƃ߂܂B
 *	  R[hTCY4oCgȂȂ܂B
 *	- ȏ̕ύXsʁA_̃R[hTCY0xfe0(4064)oCgłB
 *	* Sat Feb 1 14:08:00 JST 2003 Naoyuki Sawa
 *	- new_LCDDrawObject()ɂāAc胉C̎擾uy = obj.dhvʉAeʐߖ񂵂܂B
 *	- MODhCoσ`lɑΉ܂B
 *	* Tue Apr 1 19:00:00 JST 2003 Naoyuki Sawa
 *	- clipfram.c𕪊Ãt@CV݂܂B
 */
#include "clip.h"

/****************************************************************************
 *	P/ECE MOD Driver (V[PT[)
 ****************************************************************************/

int
mod_seq(MODDRIVER* driver)
{
	MODHEADER* header = driver->header;
	MODSAMPLE* sample;
	MODCHANNEL* channel;
	int chno, smpno, period, effect, eff_ff, eff_0f, eff_f0;
	unsigned int *row, note;

	/* `bNi߂܂B */
	driver->tick += driver->tempo;
	if(driver->tick >= driver->speed * 125) {
		driver->tick -= driver->speed * 125;

		/* [擾܂B
		 * * [V[PXԍ́AGtFNgɂĕύX\̂ŁA
		 *   [V[PXԍւ̌JグÍA[擾Oɍs܂B
		 */
		if(driver->rowno >= 64) {
			driver->rowno = 0;
			driver->seqno++;
		}
		if(driver->seqno >= header->seqlen) {
			if(header->seqrep < 127) { /* CR[127̏ꍇtIłI */
				driver->seqno = header->seqrep;
			} else {
				return 1; /* V[PXI */
			}
		}
		row = driver->pattern[header->sequence[driver->seqno]] + (driver->chans * driver->rowno);
		driver->rowno++; /* ̂߂Ƀ[i߂Ă܂ */

		/* e`l̃m[g܂B */
		for(chno = 0, channel = driver->channel; chno < driver->chans; chno++, channel++, row++) {
			note = SWAPW(*row);

			/* TvԍύX܂B */
			smpno = (note >> 24 & 0xf0) | (note >> 12 & 0xf);
			if(smpno) {
				smpno--; /* m[g̃Tvԍ#1x[XȂ̂ŁA#0x[Xɕ␳ */
				sample = &header->sample[smpno];
				channel->smpno = smpno;
				channel->volume = sample->volume;
			}

			/* sIhlύX܂B */
			period = note >> 16 & 0xfff;
			if(period) {
				channel->period = period; /* Jn */
				channel->offset = 0;
			}

			/* GtFNgi[܂B */
			effect = note & 0xfff;
			channel->effect = effect;
		}
	}

	/* e`l̃GtFNg܂B */
	for(chno = 0, channel = driver->channel; chno < driver->chans; chno++, channel++) {
		effect = channel->effect;
		if(effect) {
			eff_ff = effect      & 0xff;	/* bit 7`0 */
			eff_0f = effect      & 0x0f;	/* bit 3`0 */
			eff_f0 = effect >> 4 & 0x0f;	/* bit 7`4 */
			switch(  effect >> 8 & 0x0f) {	/* bit11`8 */
			/*---------- ɊւGtFNg ----------*/
			case 0x1: /* Slide Up */
				channel->period -= eff_ff;
				if(channel->period < 0) channel->period = 0;
				/* GtFNgp */
				break;
			case 0x2: /* Slide Down */
				channel->period += eff_ff;
				if(channel->period > 0xfff) channel->period = 0xfff;
				/* GtFNgp */
				break;
			/*---------- ʂɊւGtFNg ----------*/
			case 0x5: /* Tone Portamento + Volume Slide */
			case 0x6: /* Vibrato + Volume Slide */
			case 0xa: /* Volume Slide */
				/* g[|^gEru[g͖ΉłB */
				if(eff_0f) {
					channel->volume -= eff_0f;
					if(channel->volume < 0) channel->volume = 0;
				} else {
					channel->volume += eff_f0;
					if(channel->volume > 64) channel->volume = 64;
				}
				/* GtFNgp */
				break;
			case 0xc: /* Set Volume */
				channel->volume = eff_ff;
				channel->effect = 0; /* GtFNg */
				break;
			/*---------- tʒuɊւGtFNg ----------*/
			case 0x9: /* Set Sample Offset */
				channel->offset = eff_ff << (8/*MODdl*/ + 8/*Œ菬*/);
				channel->effect = 0; /* GtFNg */
				break;
			case 0xb: /* Position Jump */
				driver->seqno = eff_ff;
				driver->rowno = 0;
				channel->effect = 0; /* GtFNg */
				break;
			case 0xd: /* Pattern Break */
				/* ӁIROWɓȏPattern BreakuȂŉI
				 * ROWɓPattern BreakƁAxɓ̃p^[֐ił܂܂B
				 * Mod Plug Trackerł́AROWɓȏPattern BreakĂA֐i܂Ȃ̂łA
				 * P/ECE MOD Driverł́Aeʐ߁Ã`FbNsƂł܂łB
				 * f[^쐬ɒӂāAROWɓȏPattern BreakuȂ悤ɂĂB
				 */
				driver->seqno++;
				driver->rowno = eff_ff;
				channel->effect = 0; /* GtFNg */
				break;
			case 0xf: /* Set Speed */
				if(eff_ff <= 32) {
					driver->speed = eff_ff; /*  0`32:Xs[hݒ */
				} else {
					driver->tempo = eff_ff; /* 33`255:e|ݒ  */
				}
				channel->effect = 0; /* GtFNg */
				break;
			/*{{ΉGtFNg*/
			//case 0x0: /* Arpeggio */
			//case 0x3: /* Tone Portamento */
			//case 0x4: /* Vibrato */
			//case 0x7: /* Tremolo */
			//case 0x8: /* Set Panning Position */
			/**/#ifdef WIN32
			/**/default:
			/**/	fprintf(stderr, "IGN-EFF: %03x\n", effect);
			/**/	break;
			/**/#endif /*WIN32*/
			/*}}ΉGtFNg*/
			case 0xe: /* Extended Effects */
				switch(eff_f0) {
				/*---------- ɊւgGtFNg ----------*/
				case 0x1: /* Fine Slide Up */
					channel->period -= eff_0f;
					if(channel->period < 0) channel->period = 0;
					channel->effect = 0; /* GtFNg */
					break;
				case 0x2: /* Fine Slide Down */
					channel->period += eff_0f;
					if(channel->period > 0xfff) channel->period = 0xfff;
					channel->effect = 0; /* GtFNg */
					break;
				/*---------- ʂɊւgGtFNg ----------*/
				case 0xa: /* Fine Volume Slide Up */
					channel->volume += eff_0f;
					if(channel->volume > 64) channel->volume = 64;
					channel->effect = 0; /* GtFNg */
					break;
				case 0xb: /* Fine Volume Slide Down */
					channel->volume -= eff_0f;
					if(channel->volume < 0) channel->volume = 0;
					channel->effect = 0; /* GtFNg */
					break;
				/*{{ΉgGtFNg*/
				//case 0x0: /* Set Filter */
				//case 0x3: /* Glissando Control */
				//case 0x4: /* Set Vibrato Waveform */
				//case 0x5: /* Set Fine Tune */
				//case 0x6: /* Set/Jump to Loop */
				//case 0x7: /* Set Tremolo Waveform */
				//case 0x8: /* NOT USED */
				//case 0x9: /* Retrig Note */
				//case 0xc: /* Note Cut */
				//case 0xd: /* Note Delay */
				//case 0xe: /* Pattern Delay */
				//case 0xf: /* Invert Loop */
				/**/#ifdef WIN32
				/**/default:
				/**/	fprintf(stderr, "IGN-EFF: %03x\n", effect);
				/**/	break;
				/**/#endif /*WIN32*/
				/*}}ΉgGtFNg*/
				}
				break;
			}
		}
	}

	return 0;
}

