;
;	framm69a.s
;
;	P/ECE M6809 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Wed Feb 11 17:45:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
#include "clipm69a.h"
#ifdef M6809_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	M6809\
;
/*===== WX^ =====*/
#define CC	 0
#define DP	 1
#define D	 2
#define X	 4
#define Y	 6
#define U	 8
#define S	10
#define PC	12
/*=====  =====*/
#define PENDING	14
#define WAIT	15
#define CYCLE	16
/*===== O֐ =====*/
#define READ	20
#define WRITE	24

;
;	16rbgWX^̏/8rbgANZX
;	G~[VzXg(S1C33,Pentium,etc)Ȃ̂ŁALittleEndianłB
;
#define A	 3	; HI(D), LittleEndian
#define B	 2	; LO(D), LittleEndian

;
;	S1C33=>M6809tOϊ
;
;	* ϊ\͕svłB
;	  S1C33M6809{N,Z,V,C}tO͕тĂ̂ŁA
;	  ̂悤Ȏ菇ŕϊł܂B
;
;	S1C33̃tO:	  MD-ICVZN
;				      ||||
;				      VVVV
;	M6809̃tO:	  EFHINZVC
;
;	ld.w %r10, %psr		; MD-ICVZN
;	xsll %r10, 4		; CVZN0000
;	mirror %r10, %r10	; 0000NZVC
;

;****************************************************************************
;	
;****************************************************************************

	.global	m6809_run
m6809_run:
	pushn %r2
	;
	xld.w [%r12+CYCLE], %r13	; CYCLE = cycle
	ld.w %r0, %r12			; %r0 = m6809
	xld.w %r1, m6809_one		; %r1 = m6809_one
	xld.w %r2, m6809_op_table	; %r2 = m6809_op_table
	xjp m6809_run_L20
	;
m6809_run_L10:
	;//ld.w %r13, %r2		; [vI[̒xXbgֈړ
	call.d %r1			; m6809_one(m6809, m6809_op_table)
	ld.w %r12, %r0			; *delay*
	;
m6809_run_L20:
	xld.ub %r10, [%r0+WAIT]
	xld.w %r11, [%r0+CYCLE]		; *anti-interlock*
	xcmp %r10, 0			; if(WAIT) break
	xjrne m6809_run_L30
	xcmp %r11, 0			; if(CYCLE > 0) continue
	xjrgt.d m6809_run_L10
	ld.w %r13, %r2			; [v擪ړ *delay*
	;
m6809_run_L30:
	popn %r2
	ret

;****************************************************************************
;	
;****************************************************************************

	.global m6809_one
m6809_one:
	pushn %r3
	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; %r0 = m6809
	xld.w %r1, [%r0+PC]		; %r1 = PC
	ld.w %r2, %r13			; %r2 = op_table
	xld.w %r3, [%r0+READ]		; %r3 = READ
	;
	ld.uh %r13, %r1			; code = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.w %r13, %r10
	;
	xsll %r10, 3			; op = &op_table[code]
	add %r2, %r10
	;
	xld.ub %r10, [%r2+4]		; switch(op->addr)
	xld.w %r11, m6809_one_table	; *anti-interlock*
	xsll %r10, 2
	add %r10, %r11
	xld.w %r10, [%r10]
	xadd %r1, %r1, 1		; PC++ *anti-interlock*
	jp %r10
	;
m6809_one_immediate1:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10			; arg = arg1
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d m6809_one_exec
	add %r1, 1			; PC++ *delay*
	;
m6809_one_direct:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%r0+DP]		; arg = DP << 8 | arg1
	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	xsll %r14, 8
	or %r14, %r10
	;
	xjp.d m6809_one_exec
	add %r1, 1			; PC++ *delay*
	;
m6809_one_relative1:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	ld.b %r14, %r10			; arg = PC + (char)arg1
	add %r14, %r1
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp m6809_one_exec		; !NO-DELAY!
	;
m6809_one_immediate2:
m6809_one_extended:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	xld.b [%sp+1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	xsll %r14, 8			; arg = arg1 << 8 | arg2
	or %r14, %r10
	;
	xjp.d m6809_one_exec
	add %r1, 1			; PC++ *delay*
	;
m6809_one_relative2:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	xld.b [%sp+1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
	xadd %r1, %r1, 1		; PC++ *anti-interlock*
	xsll %r14, 8			; arg = PC + (arg1 << 8 | arg2)
	or %r14, %r10
	add %r14, %r1
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp m6809_one_exec		; !NO-DELAY!
	;
m6809_one_indexed:
	xld.b [%sp+0], %r13		; (save code)
	;
	xld.h [%r0+PC], %r1		; m6809_indexed()ւPCnBYȂ!!
	xcall.d m6809_indexed		; arg = m6809_indexed(m6809)
	ld.w %r12, %r0			; *delay*
	xld.uh %r1, [%r0+PC]		; m6809_indexed()PC߂BYȂ!!
	ld.w %r14, %r10
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	;** fall thru **
	;
m6809_one_inherent:
m6809_one_exec:
	xld.w %r10, [%r2+0]		; op->proc(arg)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11			; !INTERLOCK!
	xld.w [%r0+CYCLE], %r10
	;
	xadd %sp, %sp, 4
	popn %r3
	ret
	;
	.align 2
m6809_one_table:
	/*==== operand bytes=0 ====*/
	.word m6809_one_inherent	; 0
	/*==== operand bytes=1 ====*/
	.word m6809_one_immediate1	; 1
	.word m6809_one_direct		; 2
	.word m6809_one_relative1	; 3
	/*==== operand bytes=2 ====*/
	.word m6809_one_immediate2	; 4
	.word m6809_one_extended	; 5
	.word m6809_one_relative2	; 6
	/*==== operand bytes=? ====*/
	.word m6809_one_indexed		; 7
	.align 1

;****************************************************************************
;	
;****************************************************************************

	.global m6809_ADD
m6809_ADD:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	add %r10, %r4			; %r10[31:24] = a + b
	ld.w %r5, %psr			; %r5 = %psr(MD-ICVZN)
	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	xand %r11, %r11, ~0x2f		; %r11 = CC(EF0I0000)
	or %r11, %r5			; %r11 = CC(EF0INZVC)
	;
	xand %r13, %r13, 0xf		; %r13 = (a & 0xf) + (b & 0xf)
	xand %r14, %r14, 0xf
	add %r13, %r14
	xand %r13, %r13, 0x10		; %r13 = CC(H)
	xsll %r13, 1
	or %r11, %r13			; %r11 = CC(EFHINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a + b *delay*

	.global m6809_ADC
m6809_ADC:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	xand %r15, %r11, 1		; %r15 = CC(C)
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	add %r10, %r4			; %r10[31:24] = a + b
	ld.w %r5, %psr			; %r5 = %psr(1)
	;
	swap %r4, %r15			; %r4[31:24] = c
	add %r10, %r4			; %r10[31:24] = a + b + c
	ld.w %r6, %psr			; %r6 = %psr(2)
	;
	xand %r5, %r5, 0xc		; %r5 = %psr(C1,V1)
	xand %r7, %r6, 4		; %r7 = %psr(V2)
	xor %r5, %r7			; %r5 = %psr(C1,V1^V2)
	xand %r6, %r6, 0xb		; %r6 = %psr(C2,Z2,N2)
	or %r5, %r6			; %r5 = %psr(C1|C2,V1^V2,Z2,N2)
	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	xand %r11, %r11, ~0x2f		; %r11 = CC(EF0I0000)
	or %r11, %r5			; %r11 = CC(EF0INZVC)
	;
	xand %r13, %r13, 0xf		; %r13 = (a & 0xf) + (b & 0xf)
	xand %r14, %r14, 0xf
	add %r13, %r14
	add %r13, %r15			; %r13 = (a & 0xf) + (b & 0xf) + c
	xand %r13, %r13, 0x10		; %r13 = CC(H)
	xsll %r13, 1
	or %r11, %r13			; %r11 = CC(EFHINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a + b + c *delay*

	.global m6809_SUB
m6809_SUB:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	sub %r10, %r4			; %r10[31:24] = a - b
	ld.w %r5, %psr			; %r5 = %psr(MD-ICVZN)
	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	xand %r11, %r11, ~0xf		; %r11 = CC(EFHI0000)
	or %r11, %r5			; %r11 = CC(EFHINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a - b *delay*

	.global m6809_SBC
m6809_SBC:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	xand %r15, %r11, 1		; %r15 = CC(C)
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	sub %r10, %r4			; %r10[31:24] = a - b
	ld.w %r5, %psr			; %r5 = %psr(1)
	;
	swap %r4, %r15			; %r4[31:24] = c
	sub %r10, %r4			; %r10[31:24] = a - b - c
	ld.w %r6, %psr			; %r6 = %psr(2)
	;
	xand %r5, %r5, 0xc		; %r5 = %psr(C1,V1)
	xand %r7, %r6, 4		; %r7 = %psr(V2)
	xor %r5, %r7			; %r5 = %psr(C1,V1^V2)
	xand %r6, %r6, 0xb		; %r6 = %psr(C2,Z2,N2)
	or %r5, %r6			; %r5 = %psr(C1|C2,V1^V2,Z2,N2)
	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	xand %r11, %r11, ~0xf		; %r11 = CC(EFHI0000)
	or %r11, %r5			; %r11 = CC(EFHINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a - b - c *delay*

	.global m6809_ADDW
m6809_ADDW:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xsll %r13, 16			; %r13[31:16] = a
	xsll %r14, 16			; %r14[31:16] = b
	add %r13, %r14			; %r13[31:16] = a + b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	xand %r11, %r11, ~0xf		; %r11 = CC(EFHI0000)
	or %r11, %r10			; %r11 = CC(EFHINZVC)
	xld.b [%r12+CC], %r11
	;
	xsrl %r13, 16			; %r13 = a + b
	ret.d
	ld.w %r10, %r13			; %r10 = a + b *delay*

	.global m6809_SUBW
m6809_SUBW:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xsll %r13, 16			; %r13[31:16] = a
	xsll %r14, 16			; %r14[31:16] = b
	sub %r13, %r14			; %r13[31:16] = a - b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	xand %r11, %r11, ~0xf		; %r11 = CC(EFHI0000)
	or %r11, %r10			; %r11 = CC(EFHINZVC)
	xld.b [%r12+CC], %r11
	;
	xsrl %r13, 16			; %r13 = a - b
	ret.d
	ld.w %r10, %r13			; %r10 = a - b *delay*

	.global m6809_AND
m6809_AND:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	and %r13, %r14			; %r13 = a & b
	xrr %r13, 8			; %r13[31:24] = a & b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a & b *delay*

	.global m6809_OR
m6809_OR:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	or %r13, %r14			; %r13 = a | b
	xrr %r13, 8			; %r13[31:24] = a | b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a | b *delay*

	.global m6809_EOR
m6809_EOR:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xor %r13, %r14			; %r13 = a ^ b
	xrr %r13, 8			; %r13[31:24] = a ^ b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a ^ b *delay*

	.global m6809_INC
m6809_INC:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	swap %r13, %r13			; %r13[31:24] = a
	xadd %r13, %r13, 1<<24		; %r13[31:24] = a + 1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 7		; %r10 = %psr(00000VZN)
	xsll %r10, 4			; %r10 = %psr(0VZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZV0)
	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a + 1 *delay*

	.global m6809_DEC
m6809_DEC:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	swap %r13, %r13			; %r13[31:24] = a
	xsub %r13, %r13, 1<<24		; %r13[31:24] = a - 1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 7		; %r10 = %psr(00000VZN)
	xsll %r10, 4			; %r10 = %psr(0VZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZV0)
	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a - 1 *delay*

	.global m6809_COM
m6809_COM:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xxor %r13, %r13, 0xff		; %r13 = ~a
	xrr %r13, 8			; %r13[31:24] = ~a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xf		; %r11 = CC(EFHI0000)
	or %r11, %r10			; %r11 = CC(EFHINZ00)
	xoor %r11, %r11, 1		; %r11 = CC(EFHINZ01)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = ~a *delay*

	.global m6809_NEG
m6809_NEG:
	ld.w %r14, %r13			; 0 - a
	xjp.d m6809_SUB
	ld.w %r13, 0			; *delay*

	.global m6809_TST
m6809_TST:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xrr %r13, 8			; %r13[31:24] = a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret

;****************************************************************************
;	$1($2)
;****************************************************************************

#macro S1IS2I $1, $2
	xld.ub %r13, [%r12+$2]
	xjp m6809_$1
#endm

	.global m6809op_TSTA_INHERENT
m6809op_TSTA_INHERENT:
	S1IS2I TST, A
	.global m6809op_TSTB_INHERENT
m6809op_TSTB_INHERENT:
	S1IS2I TST, B

;****************************************************************************
;	$1(READ(arg))
;****************************************************************************

#macro S1IREADIargII $1
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	xcall.d m6809_$1
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
#endm

	.global m6809op_TST_ADDRESS
m6809op_TST_ADDRESS:
	S1IREADIargII TST

;****************************************************************************
;	$1($3,$2)
;****************************************************************************

#macro S1IS3_S2I $1, $2, $3
	xld.ub %r13, [%r12+$3]
	xld.ub %r14, [%r12+$2]
	xjp m6809_$1
#endm

//gȂΏ

;****************************************************************************
;	$1($2,arg)
;****************************************************************************

#macro S1IS2_argI $1, $2
	xld.ub %r13, [%r12+$2]
	xjp m6809_$1
#endm

	.global m6809op_CMPA_DATA
m6809op_CMPA_DATA:
	S1IS2_argI SUB, A
	.global m6809op_CMPB_DATA
m6809op_CMPB_DATA:
	S1IS2_argI SUB, B
	.global m6809op_BITA_DATA
m6809op_BITA_DATA:
	S1IS2_argI AND, A
	.global m6809op_BITB_DATA
m6809op_BITB_DATA:
	S1IS2_argI AND, B

;****************************************************************************
;	$1($2,READ(arg))
;****************************************************************************

#macro S1IS2_READIargII $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	xld.ub %r13, [%r0+$2]
	xcall.d m6809_$1		; *delay*
	ld.w %r12, %r0
	;
	popn %r0
	ret
#endm

	.global m6809op_CMPA_ADDRESS
m6809op_CMPA_ADDRESS:
	S1IS2_READIargII SUB, A
	.global m6809op_CMPB_ADDRESS
m6809op_CMPB_ADDRESS:
	S1IS2_READIargII SUB, B
	.global m6809op_BITA_ADDRESS
m6809op_BITA_ADDRESS:
	S1IS2_READIargII AND, A
	.global m6809op_BITB_ADDRESS
m6809op_BITB_ADDRESS:
	S1IS2_READIargII AND, B

;****************************************************************************
;	$2=$1($2)
;****************************************************************************

#macro S2_S1I$2I $1, $2
	pushn %r0
	;
	xld.ub %r13, [%r12+$2]
	xcall.d m6809_$1
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

	.global m6809op_INCA_INHERENT
m6809op_INCA_INHERENT:
	S2_S1I$2I INC, A
	.global m6809op_INCB_INHERENT
m6809op_INCB_INHERENT:
	S2_S1I$2I INC, B
	.global m6809op_DECA_INHERENT
m6809op_DECA_INHERENT:
	S2_S1I$2I DEC, A
	.global m6809op_DECB_INHERENT
m6809op_DECB_INHERENT:
	S2_S1I$2I DEC, B
	.global m6809op_COMA_INHERENT
m6809op_COMA_INHERENT:
	S2_S1I$2I COM, A
	.global m6809op_COMB_INHERENT
m6809op_COMB_INHERENT:
	S2_S1I$2I COM, B
	.global m6809op_NEGA_INHERENT
m6809op_NEGA_INHERENT:
	S2_S1I$2I NEG, A
	.global m6809op_NEGB_INHERENT
m6809op_NEGB_INHERENT:
	S2_S1I$2I NEG, B
	.global m6809op_ROLA_INHERENT
m6809op_ROLA_INHERENT:
	S2_S1I$2I ROL, A
	.global m6809op_ROLB_INHERENT
m6809op_ROLB_INHERENT:
	S2_S1I$2I ROL, B
	.global m6809op_RORA_INHERENT
m6809op_RORA_INHERENT:
	S2_S1I$2I ROR, A
	.global m6809op_RORB_INHERENT
m6809op_RORB_INHERENT:
	S2_S1I$2I ROR, B
	.global m6809op_ASLA_INHERENT
m6809op_ASLA_INHERENT:
	S2_S1I$2I ASL, A
	.global m6809op_ASLB_INHERENT
m6809op_ASLB_INHERENT:
	S2_S1I$2I ASL, B
	.global m6809op_ASRA_INHERENT
m6809op_ASRA_INHERENT:
	S2_S1I$2I ASR, A
	.global m6809op_ASRB_INHERENT
m6809op_ASRB_INHERENT:
	S2_S1I$2I ASR, B
	.global m6809op_LSRA_INHERENT
m6809op_LSRA_INHERENT:
	S2_S1I$2I LSR, A
	.global m6809op_LSRB_INHERENT
m6809op_LSRB_INHERENT:
	S2_S1I$2I LSR, B

;****************************************************************************
;	$2=$1($2,arg)
;****************************************************************************

#macro S2_S1IS2_argI $1, $2
	pushn %r0
	;
	xld.ub %r13, [%r12+$2]
	xcall.d m6809_$1
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

	.global m6809op_ADDA_DATA
m6809op_ADDA_DATA:
	S2_S1IS2_argI ADD, A
	.global m6809op_ADDB_DATA
m6809op_ADDB_DATA:
	S2_S1IS2_argI ADD, B
	.global m6809op_ADCA_DATA
m6809op_ADCA_DATA:
	S2_S1IS2_argI ADC, A
	.global m6809op_ADCB_DATA
m6809op_ADCB_DATA:
	S2_S1IS2_argI ADC, B
	.global m6809op_SUBA_DATA
m6809op_SUBA_DATA:
	S2_S1IS2_argI SUB, A
	.global m6809op_SUBB_DATA
m6809op_SUBB_DATA:
	S2_S1IS2_argI SUB, B
	.global m6809op_SBCA_DATA
m6809op_SBCA_DATA:
	S2_S1IS2_argI SBC, A
	.global m6809op_SBCB_DATA
m6809op_SBCB_DATA:
	S2_S1IS2_argI SBC, B
	.global m6809op_ANDA_DATA
m6809op_ANDA_DATA:
	S2_S1IS2_argI AND, A
	.global m6809op_ANDB_DATA
m6809op_ANDB_DATA:
	S2_S1IS2_argI AND, B
	.global m6809op_ORA_DATA
m6809op_ORA_DATA:
	S2_S1IS2_argI OR, A
	.global m6809op_ORB_DATA
m6809op_ORB_DATA:
	S2_S1IS2_argI OR, B
	.global m6809op_EORA_DATA
m6809op_EORA_DATA:
	S2_S1IS2_argI EOR, A
	.global m6809op_EORB_DATA
m6809op_EORB_DATA:
	S2_S1IS2_argI EOR, B

;****************************************************************************
;	$3=$1($3,$2)
;****************************************************************************

#macro S3_S1IS3_S2I $1, $2, $3
	pushn %r0
	;
	xld.ub %r13, [%r12+$3]
	xld.ub %r14, [%r12+$2]
	xcall.d m6809_$1
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$3], %r10
	;
	popn %r0
	ret
#endm

	.global m6809op_ABA_INHERENT
m6809op_ABA_INHERENT:
	S3_S1IS3_S2I ADD, B, A
	.global m6809op_SBA_INHERENT
m6809op_SBA_INHERENT:
	S3_S1IS3_S2I SUB, B, A

;****************************************************************************
;	$2=$1($2,READ(arg))
;****************************************************************************

#macro S2_S1IS2_READIargII $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	xld.ub %r13, [%r0+$2]
	xcall.d m6809_$1		; *delay*
	ld.w %r12, %r0
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

	.global m6809op_ADDA_ADDRESS
m6809op_ADDA_ADDRESS:
	S2_S1IS2_READIargII ADD, A
	.global m6809op_ADDB_ADDRESS
m6809op_ADDB_ADDRESS:
	S2_S1IS2_READIargII ADD, B
	.global m6809op_ADCA_ADDRESS
m6809op_ADCA_ADDRESS:
	S2_S1IS2_READIargII ADC, A
	.global m6809op_ADCB_ADDRESS
m6809op_ADCB_ADDRESS:
	S2_S1IS2_READIargII ADC, B
	.global m6809op_SUBA_ADDRESS
m6809op_SUBA_ADDRESS:
	S2_S1IS2_READIargII SUB, A
	.global m6809op_SUBB_ADDRESS
m6809op_SUBB_ADDRESS:
	S2_S1IS2_READIargII SUB, B
	.global m6809op_SBCA_ADDRESS
m6809op_SBCA_ADDRESS:
	S2_S1IS2_READIargII SBC, A
	.global m6809op_SBCB_ADDRESS
m6809op_SBCB_ADDRESS:
	S2_S1IS2_READIargII SBC, B
	.global m6809op_ANDA_ADDRESS
m6809op_ANDA_ADDRESS:
	S2_S1IS2_READIargII AND, A
	.global m6809op_ANDB_ADDRESS
m6809op_ANDB_ADDRESS:
	S2_S1IS2_READIargII AND, B
	.global m6809op_ORA_ADDRESS
m6809op_ORA_ADDRESS:
	S2_S1IS2_READIargII OR, A
	.global m6809op_ORB_ADDRESS
m6809op_ORB_ADDRESS:
	S2_S1IS2_READIargII OR, B
	.global m6809op_EORA_ADDRESS
m6809op_EORA_ADDRESS:
	S2_S1IS2_READIargII EOR, A
	.global m6809op_EORB_ADDRESS
m6809op_EORB_ADDRESS:
	S2_S1IS2_READIargII EOR, B

;****************************************************************************
;	WRITE(arg,$1(READ(arg)))
;****************************************************************************

#macro WRITEIarg_S1IREADIargIII $1
	pushn %r1
	ld.w %r1, %r14
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	xcall.d m6809_$1
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	xld.w %r10, [%r0+WRITE]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
#endm

	.global m6809op_INC_ADDRESS
m6809op_INC_ADDRESS:
	WRITEIarg_S1IREADIargIII INC
	.global m6809op_DEC_ADDRESS
m6809op_DEC_ADDRESS:
	WRITEIarg_S1IREADIargIII DEC
	.global m6809op_COM_ADDRESS
m6809op_COM_ADDRESS:
	WRITEIarg_S1IREADIargIII COM
	.global m6809op_NEG_ADDRESS
m6809op_NEG_ADDRESS:
	WRITEIarg_S1IREADIargIII NEG
	.global m6809op_ROL_ADDRESS
m6809op_ROL_ADDRESS:
	WRITEIarg_S1IREADIargIII ROL
	.global m6809op_ROR_ADDRESS
m6809op_ROR_ADDRESS:
	WRITEIarg_S1IREADIargIII ROR
	.global m6809op_ASL_ADDRESS
m6809op_ASL_ADDRESS:
	WRITEIarg_S1IREADIargIII ASL
	.global m6809op_ASR_ADDRESS
m6809op_ASR_ADDRESS:
	WRITEIarg_S1IREADIargIII ASR
	.global m6809op_LSR_ADDRESS
m6809op_LSR_ADDRESS:
	WRITEIarg_S1IREADIargIII LSR

;****************************************************************************
;	Others
;****************************************************************************

#macro LDr_DATA $1
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xld.b [%r12+$1], %r14		; $1 = arg
	;
	xrr %r14, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret
#endm

	.global m6809op_LDA_DATA
m6809op_LDA_DATA:
	LDr_DATA A
	.global m6809op_LDB_DATA
m6809op_LDB_DATA:
	LDr_DATA B

;****************************************************************************

#macro LDr_ADDRESS $1
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.b [%r0+$1], %r10		; $1 = READ(arg)
	;
	xld.ub %r11, [%r0+CC]		; %r11 = CC
	;
	xrr %r10, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	xld.b [%r0+CC], %r11
	;
	popn %r0
	ret
#endm

	.global m6809op_LDA_ADDRESS
m6809op_LDA_ADDRESS:
	LDr_ADDRESS A
	.global m6809op_LDB_ADDRESS
m6809op_LDB_ADDRESS:
	LDr_ADDRESS B

;****************************************************************************

#macro STr_ADDRESS $1
	pushn %r0
	;
	xld.w %r10, [%r12+WRITE]	; WRITE(arg, $1)
	ld.w %r13, %r14
	xld.ub %r14, [%r12+$1]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.ub %r10, [%r0+$1]		; %r10 = $1
	xld.ub %r11, [%r0+CC]		; %r11 = CC *anti-interlock*
	xrr %r10, 8			; %r10[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	xld.b [%r0+CC], %r11
	;
	popn %r0
	ret
#endm

	.global m6809op_STA_ADDRESS
m6809op_STA_ADDRESS:
	STr_ADDRESS A
	.global m6809op_STB_ADDRESS
m6809op_STB_ADDRESS:
	STr_ADDRESS B

;****************************************************************************
;	JUMP AND BRANCH
;****************************************************************************

/* Branch if Flag is Clear */
#macro Bfc_ADDRESS $1
	xbtst [%r12+CC], $1
	xjrne $$1			; if(flag is 1) no-jump
	xld.w %r10, [%r12+CYCLE]
	xld.h [%r12+PC], %r14		; *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
$$1:
	ret
#endm

	.global m6809op_BHS_ADDRESS
m6809op_BHS_ADDRESS:
	Bfc_ADDRESS 0
	.global m6809op_BVC_ADDRESS
m6809op_BVC_ADDRESS:
	Bfc_ADDRESS 1
	.global m6809op_BNE_ADDRESS
m6809op_BNE_ADDRESS:
	Bfc_ADDRESS 2
	.global m6809op_BPL_ADDRESS
m6809op_BPL_ADDRESS:
	Bfc_ADDRESS 3

;****************************************************************************

/* Branch if Flag is Set */
#macro Bfs_ADDRESS $1
	xbtst [%r12+CC], $1
	xjreq $$1			; if(flag is 0) no-jump
	xld.w %r10, [%r12+CYCLE]
	xld.h [%r12+PC], %r14		; *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
$$1:
	ret
#endm

	.global m6809op_BLO_ADDRESS
m6809op_BLO_ADDRESS:
	Bfs_ADDRESS 0
	.global m6809op_BVS_ADDRESS
m6809op_BVS_ADDRESS:
	Bfs_ADDRESS 1
	.global m6809op_BEQ_ADDRESS
m6809op_BEQ_ADDRESS:
	Bfs_ADDRESS 2
	.global m6809op_BMI_ADDRESS
m6809op_BMI_ADDRESS:
	Bfs_ADDRESS 3

;****************************************************************************

;
	.global m6809op_BGE_ADDRESS
m6809op_BGE_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = EFHINZVC
	ld.w %r11, %r10			; %r11 = EFHINZVC
	xrr %r11, 2			; %r11 = 00EFHINZ
	xor %r10, %r11			;              +- N^V
	xand %r10, %r10, 2
	xjrne m6809op_BGE_ADDRESS_L10	; if(N^V is 1) no-jump
	xld.w %r10, [%r12+CYCLE]
	xld.h [%r12+PC], %r14		; *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
m6809op_BGE_ADDRESS_L10:
	ret

;
	.global m6809op_BLT_ADDRESS
m6809op_BLT_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = EFHINZVC
	ld.w %r11, %r10			; %r11 = EFHINZVC
	xrr %r11, 2			; %r11 = 00EFHINZ
	xor %r10, %r11			;              +- N^V
	xand %r10, %r10, 2
	xjreq m6809op_BLT_ADDRESS_L10	; if(N^V is 0) no-jump
	xld.w %r10, [%r12+CYCLE]
	xld.h [%r12+PC], %r14		; *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
m6809op_BLT_ADDRESS_L10:
	ret

;
	.global m6809op_BGT_ADDRESS
m6809op_BGT_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = EFHINZVC
	ld.w %r11, %r10			; %r11 = EFHINZVC
	xrr %r11, 2			; %r11 = 00EFHINZ
	xor %r10, %r11			;              +- N^V
	xrl %r11, 1			; %r11 = 0EFHINZV
	or %r10, %r11			;              +- (N^V)|Z
	xand %r10, %r10, 2
	xjrne m6809op_BGT_ADDRESS_L10	; if((N^V)|Z is 1) no-jump
	xld.w %r10, [%r12+CYCLE]
	xld.h [%r12+PC], %r14		; *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
m6809op_BGT_ADDRESS_L10:
	ret

;
	.global m6809op_BLE_ADDRESS
m6809op_BLE_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = EFHINZVC
	ld.w %r11, %r10			; %r11 = EFHINZVC
	xrr %r11, 2			; %r11 = 00EFHINZ
	xor %r10, %r11			;              +- N^V
	xrl %r11, 1			; %r11 = 0EFHINZV
	or %r10, %r11			;              +- (N^V)|Z
	xand %r10, %r10, 2
	xjreq m6809op_BLE_ADDRESS_L10	; if((N^V)|Z is 0) no-jump
	xld.w %r10, [%r12+CYCLE]
	xld.h [%r12+PC], %r14		; *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
m6809op_BLE_ADDRESS_L10:
	ret

;
	.global m6809op_BHI_ADDRESS
m6809op_BHI_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = EFHINZVC
	xand %r10, %r10, 5		; %r10 = 00000Z0C
	xjrne m6809op_BHI_ADDRESS_L10	; if(Z|C is 1) no-jump
	xld.w %r10, [%r12+CYCLE]
	xld.h [%r12+PC], %r14		; *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
m6809op_BHI_ADDRESS_L10:
	ret

;
	.global m6809op_BLS_ADDRESS
m6809op_BLS_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = EFHINZVC
	xand %r10, %r10, 5		; %r10 = 00000Z0C
	xjreq m6809op_BLS_ADDRESS_L10	; if(Z|C is 0) no-jump
	xld.w %r10, [%r12+CYCLE]
	xld.h [%r12+PC], %r14		; *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
m6809op_BLS_ADDRESS_L10:
	ret

;****************************************************************************

	.global m6809op_BSR_ADDRESS
m6809op_BSR_ADDRESS:
	pushn %r2
	;
	xld.uh %r1, [%r12+S]		; S
	xld.uh %r2, [%r12+PC]		; PC
	;
	xld.h [%r12+PC], %r14		; PC <= arg
	;
	xsub %r1, %r1, 1		; S--
	xld.w %r10, [%r12+WRITE]	; PUSH(PCL)
	ld.uh %r13, %r1
	ld.ub %r14, %r2
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xsub %r1, %r1, 1		; S--
	xld.w %r10, [%r0+WRITE]		; PUSH(PCH)
	ld.uh %r13, %r1
	ld.uh %r14, %r2
	xsrl %r14, 8
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.h [%r0+S], %r1		; S
	;
	popn %r2
	ret

;****************************************************************************

	.global m6809op_RTS_INHERENT
m6809op_RTS_INHERENT:
	pushn %r2
	;
	xld.uh %r1, [%r12+S]		; S
	;
	xld.w %r10, [%r12+READ]		; POP(PCH)
	ld.w %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xadd %r1, %r1, 1		; S++
	;
	ld.w %r2, %r10			; (save PCH)
	;
	xld.w %r10, [%r0+READ]		; POP(PCL)
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; S++
	;
	xsll %r2, 8			; PC <= PCH << 8 | PCL
	or %r2, %r10
	xld.h [%r0+PC], %r2
	;
	xld.h [%r0+S], %r1		; S
	;
	popn %r2
	ret

;****************************************************************************
;	
;****************************************************************************

#endif /*M6809_ASM*/
