;
;	framm69a.s
;
;	P/ECE M6809 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Wed Feb 11 17:45:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clipm69a.h"
;/	
;/	clipm69a.h
;/
;/	P/ECE M6809 Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2004 Naoyuki Sawa
;/
;/	* Wed Feb 11 17:45:00 JST 2004 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define M6809_ASM
;#ifdef M6809_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	M6809\
;
;*===== WX^ =====*/
;#define CC	 0
;#define DP	 1
;#define D	 2
;#define X	 4
;#define Y	 6
;#define U	 8
;#define S	10
;#define PC	12
;*=====  =====*/
;#define PENDING	14
;#define WAIT	15
;#define CYCLE	16
;*===== O֐ =====*/
;#define READ	20
;#define WRITE	24

;
;	16rbgWX^̏/8rbgANZX
;	G~[VzXg(S1C33,Pentium,etc)Ȃ̂ŁALittleEndianłB
;
;#define A	 3	; HI(D), LittleEndian
;#define B	 2	; LO(D), LittleEndian

;
;	S1C33=>M6809tOϊ
;
;	* ϊ\͕svłB
;	  S1C33M6809{N,Z,V,C}tO͕тĂ̂ŁA
;	  ̂悤Ȏ菇ŕϊł܂B
;
;	S1C33̃tO:	  MD-ICVZN
;				      ||||
;				      VVVV
;	M6809̃tO:	  EFHINZVC
;
;	ld.w %r10, %psr		; MD-ICVZN
;	xsll %r10, 4		; CVZN0000
;	mirror %r10, %r10	; 0000NZVC
;

;****************************************************************************
;	
;****************************************************************************

	.global	m6809_run
m6809_run:
	pushn %r2
	;
	ext	0x10		; 	xld.w [%r12+0x10], %r13	; CYCLE = cycle
	ld.w	[%r12],%r13
	ld.w %r0, %r12			; %r0 = m6809
	ext	m6809_one+0x0@h	; 	xld.w %r1, m6809_one		; %r1 = m6809_one
	ext	m6809_one+0x0@m
	ld.w	%r1,m6809_one+0x0@l
	ext	m6809_op_table+0x0@h	; 	xld.w %r2, m6809_op_table	; %r2 = m6809_op_table
	ext	m6809_op_table+0x0@m
	ld.w	%r2,m6809_op_table+0x0@l
	jp	m6809_run_L20	; 	xjp m6809_run_L20
	;
m6809_run_L10:
	;//ld.w %r13, %r2		; [vI[̒xXbgֈړ
	call.d %r1			; m6809_one(m6809, m6809_op_table)
	ld.w %r12, %r0			; *delay*
	;
m6809_run_L20:
	ext	0xf		; 	xld.ub %r10, [%r0+0xf]
	ld.ub	%r10,[%r0]
	ext	0x10		; 	xld.w %r11, [%r0+0x10]		; *anti-interlock*
	ld.w	%r11,[%r0]
	cmp	%r10,0x0	; 	xcmp %r10, 0			; if(WAIT) break
	jrne	m6809_run_L30	; 	xjrne m6809_run_L30
	cmp	%r11,0x0	; 	xcmp %r11, 0			; if(CYCLE > 0) continue
	jrgt.d	m6809_run_L10	; 	xjrgt.d m6809_run_L10
	ld.w %r13, %r2			; [v擪ړ *delay*
	;
m6809_run_L30:
	popn %r2
	ret

;****************************************************************************
;	
;****************************************************************************

	.global m6809_one
m6809_one:
	pushn %r3
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; %r0 = m6809
	ext	0xc		; 	xld.w %r1, [%r0+0xc]		; %r1 = PC
	ld.w	%r1,[%r0]
	ld.w %r2, %r13			; %r2 = op_table
	ext	0x14		; 	xld.w %r3, [%r0+0x14]		; %r3 = READ
	ld.w	%r3,[%r0]
	;
	ld.uh %r13, %r1			; code = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.w %r13, %r10
	;
	sll	%r10,0x3	; 	xsll %r10, 3			; op = &op_table[code]
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; switch(op->addr)
	ld.ub	%r10,[%r2]
	ext	m6809_one_table+0x0@h	; 	xld.w %r11, m6809_one_table	; *anti-interlock*
	ext	m6809_one_table+0x0@m
	ld.w	%r11,m6809_one_table+0x0@l
	sll	%r10,0x2	; 	xsll %r10, 2
	add %r10, %r11
	ld.w	%r10,[%r10]	; 	xld.w %r10, [%r10]
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++ *anti-interlock*
	jp %r10
	;
m6809_one_immediate1:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10			; arg = arg1
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	m6809_one_exec	; 	xjp.d m6809_one_exec
	add %r1, 1			; PC++ *delay*
	;
m6809_one_direct:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x1		; 	xld.ub %r14, [%r0+0x1]		; arg = DP << 8 | arg1
	ld.ub	%r14,[%r0]
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r14, %r10
	;
	jp.d	m6809_one_exec	; 	xjp.d m6809_one_exec
	add %r1, 1			; PC++ *delay*
	;
m6809_one_relative1:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b %r14, %r10			; arg = PC + (char)arg1
	add %r14, %r1
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp	m6809_one_exec	; 	xjp m6809_one_exec		; !NO-DELAY!
	;
m6809_one_immediate2:
m6809_one_extended:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	sll	%r14,0x8	; 	xsll %r14, 8			; arg = arg1 << 8 | arg2
	or %r14, %r10
	;
	jp.d	m6809_one_exec	; 	xjp.d m6809_one_exec
	add %r1, 1			; PC++ *delay*
	;
m6809_one_relative2:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6809->read(m6809, PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++ *anti-interlock*
	sll	%r14,0x8	; 	xsll %r14, 8			; arg = PC + (arg1 << 8 | arg2)
	or %r14, %r10
	add %r14, %r1
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp	m6809_one_exec	; 	xjp m6809_one_exec		; !NO-DELAY!
	;
m6809_one_indexed:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ext	0xc		; 	xld.h [%r0+0xc], %r1		; m6809_indexed()ւPCnBYȂ!!
	ld.h	[%r0],%r1
	ext	m6809_indexed@rm	; 	xcall.d m6809_indexed		; arg = m6809_indexed(m6809)
	call.d	m6809_indexed@rl
	ld.w %r12, %r0			; *delay*
	ext	0xc		; 	xld.uh %r1, [%r0+0xc]		; m6809_indexed()PC߂BYȂ!!
	ld.uh	%r1,[%r0]
	ld.w %r14, %r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	;** fall thru **
	;
m6809_one_inherent:
m6809_one_exec:
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(arg)
	ext	0xc		; 	xld.h [%r0+0xc], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11			; !INTERLOCK!
	ext	0x10		; 	xld.w [%r0+0x10], %r10
	ld.w	[%r0],%r10
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r3
	ret
	;
	.align 2
m6809_one_table:
	;*==== operand bytes=0 ====*/
	.word m6809_one_inherent	; 0
	;*==== operand bytes=1 ====*/
	.word m6809_one_immediate1	; 1
	.word m6809_one_direct		; 2
	.word m6809_one_relative1	; 3
	;*==== operand bytes=2 ====*/
	.word m6809_one_immediate2	; 4
	.word m6809_one_extended	; 5
	.word m6809_one_relative2	; 6
	;*==== operand bytes=? ====*/
	.word m6809_one_indexed		; 7
	.align 1

;****************************************************************************
;	
;****************************************************************************

	.global m6809_ADD
m6809_ADD:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	add %r10, %r4			; %r10[31:24] = a + b
	ld.w %r5, %psr			; %r5 = %psr(MD-ICVZN)
	sll	%r5,0x4		; 	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	ext	0x1fff		; 	xand %r11, %r11, -48		; %r11 = CC(EF0I0000)
	and	%r11,0x10
	or %r11, %r5			; %r11 = CC(EF0INZVC)
	;
	and	%r13,0xf	; 	xand %r13, %r13, 0xf		; %r13 = (a & 0xf) + (b & 0xf)
	and	%r14,0xf	; 	xand %r14, %r14, 0xf
	add %r13, %r14
	and	%r13,0x10	; 	xand %r13, %r13, 0x10		; %r13 = CC(H)
	sll	%r13,0x1	; 	xsll %r13, 1
	or %r11, %r13			; %r11 = CC(EFHINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a + b *delay*

	.global m6809_ADC
m6809_ADC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	ext	0x1		; 	xand %r15, %r11, 1		; %r15 = CC(C)
	and	%r15,%r11
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	add %r10, %r4			; %r10[31:24] = a + b
	ld.w %r5, %psr			; %r5 = %psr(1)
	;
	swap %r4, %r15			; %r4[31:24] = c
	add %r10, %r4			; %r10[31:24] = a + b + c
	ld.w %r6, %psr			; %r6 = %psr(2)
	;
	and	%r5,0xc		; 	xand %r5, %r5, 0xc		; %r5 = %psr(C1,V1)
	ext	0x4		; 	xand %r7, %r6, 4		; %r7 = %psr(V2)
	and	%r7,%r6
	xor %r5, %r7			; %r5 = %psr(C1,V1^V2)
	and	%r6,0xb		; 	xand %r6, %r6, 0xb		; %r6 = %psr(C2,Z2,N2)
	or %r5, %r6			; %r5 = %psr(C1|C2,V1^V2,Z2,N2)
	sll	%r5,0x4		; 	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	ext	0x1fff		; 	xand %r11, %r11, -48		; %r11 = CC(EF0I0000)
	and	%r11,0x10
	or %r11, %r5			; %r11 = CC(EF0INZVC)
	;
	and	%r13,0xf	; 	xand %r13, %r13, 0xf		; %r13 = (a & 0xf) + (b & 0xf)
	and	%r14,0xf	; 	xand %r14, %r14, 0xf
	add %r13, %r14
	add %r13, %r15			; %r13 = (a & 0xf) + (b & 0xf) + c
	and	%r13,0x10	; 	xand %r13, %r13, 0x10		; %r13 = CC(H)
	sll	%r13,0x1	; 	xsll %r13, 1
	or %r11, %r13			; %r11 = CC(EFHINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a + b + c *delay*

	.global m6809_SUB
m6809_SUB:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	sub %r10, %r4			; %r10[31:24] = a - b
	ld.w %r5, %psr			; %r5 = %psr(MD-ICVZN)
	sll	%r5,0x4		; 	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(EFHI0000)
	or %r11, %r5			; %r11 = CC(EFHINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a - b *delay*

	.global m6809_SBC
m6809_SBC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	ext	0x1		; 	xand %r15, %r11, 1		; %r15 = CC(C)
	and	%r15,%r11
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	sub %r10, %r4			; %r10[31:24] = a - b
	ld.w %r5, %psr			; %r5 = %psr(1)
	;
	swap %r4, %r15			; %r4[31:24] = c
	sub %r10, %r4			; %r10[31:24] = a - b - c
	ld.w %r6, %psr			; %r6 = %psr(2)
	;
	and	%r5,0xc		; 	xand %r5, %r5, 0xc		; %r5 = %psr(C1,V1)
	ext	0x4		; 	xand %r7, %r6, 4		; %r7 = %psr(V2)
	and	%r7,%r6
	xor %r5, %r7			; %r5 = %psr(C1,V1^V2)
	and	%r6,0xb		; 	xand %r6, %r6, 0xb		; %r6 = %psr(C2,Z2,N2)
	or %r5, %r6			; %r5 = %psr(C1|C2,V1^V2,Z2,N2)
	sll	%r5,0x4		; 	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(EFHI0000)
	or %r11, %r5			; %r11 = CC(EFHINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a - b - c *delay*

	.global m6809_ADDW
m6809_ADDW:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	sll	%r13,0x8	; 	xsll %r13, 16			; %r13[31:16] = a
	sll	%r13,0x8
	sll	%r14,0x8	; 	xsll %r14, 16			; %r14[31:16] = b
	sll	%r14,0x8
	add %r13, %r14			; %r13[31:16] = a + b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(EFHI0000)
	or %r11, %r10			; %r11 = CC(EFHINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	srl	%r13,0x8	; 	xsrl %r13, 16			; %r13 = a + b
	srl	%r13,0x8
	ret.d
	ld.w %r10, %r13			; %r10 = a + b *delay*

	.global m6809_SUBW
m6809_SUBW:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	sll	%r13,0x8	; 	xsll %r13, 16			; %r13[31:16] = a
	sll	%r13,0x8
	sll	%r14,0x8	; 	xsll %r14, 16			; %r14[31:16] = b
	sll	%r14,0x8
	sub %r13, %r14			; %r13[31:16] = a - b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(EFHI0000)
	or %r11, %r10			; %r11 = CC(EFHINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	srl	%r13,0x8	; 	xsrl %r13, 16			; %r13 = a - b
	srl	%r13,0x8
	ret.d
	ld.w %r10, %r13			; %r10 = a - b *delay*

	.global m6809_AND
m6809_AND:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	and %r13, %r14			; %r13 = a & b
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = a & b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	srl	%r10,0x4	; 	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a & b *delay*

	.global m6809_OR
m6809_OR:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	or %r13, %r14			; %r13 = a | b
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = a | b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	srl	%r10,0x4	; 	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a | b *delay*

	.global m6809_EOR
m6809_EOR:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	xor %r13, %r14			; %r13 = a ^ b
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = a ^ b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	srl	%r10,0x4	; 	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a ^ b *delay*

	.global m6809_INC
m6809_INC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	swap %r13, %r13			; %r13[31:24] = a
	ext	0x20		; 	xadd %r13, %r13, 0x1000000		; %r13[31:24] = a + 1
	ext	0x0
	add	%r13,0x0
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x7	; 	xand %r10, %r10, 7		; %r10 = %psr(00000VZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(0VZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZV0)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a + 1 *delay*

	.global m6809_DEC
m6809_DEC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	swap %r13, %r13			; %r13[31:24] = a
	ext	0x20		; 	xsub %r13, %r13, 0x1000000		; %r13[31:24] = a - 1
	ext	0x0
	sub	%r13,0x0
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x7	; 	xand %r10, %r10, 7		; %r10 = %psr(00000VZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(0VZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZV0)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZVC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a - 1 *delay*

	.global m6809_COM
m6809_COM:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	ext	0x3		; 	xxor %r13, %r13, 0xff		; %r13 = ~a
	xor	%r13,0x3f
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = ~a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x30	; 	xand %r11, %r11, -16		; %r11 = CC(EFHI0000)
	or %r11, %r10			; %r11 = CC(EFHINZ00)
	or	%r11,0x1	; 	xoor %r11, %r11, 1		; %r11 = CC(EFHINZ01)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = ~a *delay*

	.global m6809_NEG
m6809_NEG:
	ld.w %r14, %r13			; 0 - a
	ext	m6809_SUB@rm	; 	xjp.d m6809_SUB
	jp.d	m6809_SUB@rl
	ld.w %r13, 0			; *delay*

	.global m6809_TST
m6809_TST:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC
	;
	rr	%r13,0x8	; 	xrr %r13, 8			; %r13[31:24] = a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	srl	%r10,0x4	; 	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************
;	$1($2)
;****************************************************************************

;#macro S1IS2I $1, $2
;	xld.ub %r13, [%r12+$2]
;	xjp m6809_$1
;#endm

	.global m6809op_TSTA_INHERENT
m6809op_TSTA_INHERENT:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	S1IS2I TST, A
	ld.ub	%r13,[%r12]
	jp	m6809_TST	; 	xjp m6809_TST
	.global m6809op_TSTB_INHERENT
m6809op_TSTB_INHERENT:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	S1IS2I TST, B
	ld.ub	%r13,[%r12]
	jp	m6809_TST	; 	xjp m6809_TST

;****************************************************************************
;	$1(READ(arg))
;****************************************************************************

;#macro S1IREADIargII $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	xcall.d m6809_$1
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r0
;	ret
;#endm

	.global m6809op_TST_ADDRESS
m6809op_TST_ADDRESS:
	pushn %r0	; 	S1IREADIargII TST
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	call.d	m6809_TST	; 	xcall.d m6809_TST
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret

;****************************************************************************
;	$1($3,$2)
;****************************************************************************

;#macro S1IS3_S2I $1, $2, $3
;	xld.ub %r13, [%r12+$3]
;	xld.ub %r14, [%r12+$2]
;	xjp m6809_$1
;#endm

;/gȂΏ

;****************************************************************************
;	$1($2,arg)
;****************************************************************************

;#macro S1IS2_argI $1, $2
;	xld.ub %r13, [%r12+$2]
;	xjp m6809_$1
;#endm

	.global m6809op_CMPA_DATA
m6809op_CMPA_DATA:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	S1IS2_argI SUB, A
	ld.ub	%r13,[%r12]
	ext	m6809_SUB@rm	; 	xjp m6809_SUB
	jp	m6809_SUB@rl
	.global m6809op_CMPB_DATA
m6809op_CMPB_DATA:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	S1IS2_argI SUB, B
	ld.ub	%r13,[%r12]
	ext	m6809_SUB@rm	; 	xjp m6809_SUB
	jp	m6809_SUB@rl
	.global m6809op_BITA_DATA
m6809op_BITA_DATA:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	S1IS2_argI AND, A
	ld.ub	%r13,[%r12]
	jp	m6809_AND	; 	xjp m6809_AND
	.global m6809op_BITB_DATA
m6809op_BITB_DATA:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	S1IS2_argI AND, B
	ld.ub	%r13,[%r12]
	jp	m6809_AND	; 	xjp m6809_AND

;****************************************************************************
;	$1($2,READ(arg))
;****************************************************************************

;#macro S1IS2_READIargII $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r14, %r10
;	xld.ub %r13, [%r0+$2]
;	xcall.d m6809_$1		; *delay*
;	ld.w %r12, %r0
	;
;	popn %r0
;	ret
;#endm

	.global m6809op_CMPA_ADDRESS
m6809op_CMPA_ADDRESS:
	pushn %r0	; 	S1IS2_READIargII SUB, A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6809_SUB@rm	; 	xcall.d m6809_SUB		; *delay*
	call.d	m6809_SUB@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret
	.global m6809op_CMPB_ADDRESS
m6809op_CMPB_ADDRESS:
	pushn %r0	; 	S1IS2_READIargII SUB, B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6809_SUB@rm	; 	xcall.d m6809_SUB		; *delay*
	call.d	m6809_SUB@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret
	.global m6809op_BITA_ADDRESS
m6809op_BITA_ADDRESS:
	pushn %r0	; 	S1IS2_READIargII AND, A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6809_AND@rm	; 	xcall.d m6809_AND		; *delay*
	call.d	m6809_AND@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret
	.global m6809op_BITB_ADDRESS
m6809op_BITB_ADDRESS:
	pushn %r0	; 	S1IS2_READIargII AND, B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6809_AND@rm	; 	xcall.d m6809_AND		; *delay*
	call.d	m6809_AND@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret

;****************************************************************************
;	$2=$1($2)
;****************************************************************************

;#macro S2_S1I$2I $1, $2
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$2]
;	xcall.d m6809_$1
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

	.global m6809op_INCA_INHERENT
m6809op_INCA_INHERENT:
	pushn %r0	; 	S2_S1I$2I INC, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_INC@rm	; 	xcall.d m6809_INC
	call.d	m6809_INC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_INCB_INHERENT
m6809op_INCB_INHERENT:
	pushn %r0	; 	S2_S1I$2I INC, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_INC@rm	; 	xcall.d m6809_INC
	call.d	m6809_INC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_DECA_INHERENT
m6809op_DECA_INHERENT:
	pushn %r0	; 	S2_S1I$2I DEC, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_DEC@rm	; 	xcall.d m6809_DEC
	call.d	m6809_DEC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_DECB_INHERENT
m6809op_DECB_INHERENT:
	pushn %r0	; 	S2_S1I$2I DEC, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_DEC@rm	; 	xcall.d m6809_DEC
	call.d	m6809_DEC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_COMA_INHERENT
m6809op_COMA_INHERENT:
	pushn %r0	; 	S2_S1I$2I COM, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_COM@rm	; 	xcall.d m6809_COM
	call.d	m6809_COM@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_COMB_INHERENT
m6809op_COMB_INHERENT:
	pushn %r0	; 	S2_S1I$2I COM, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_COM@rm	; 	xcall.d m6809_COM
	call.d	m6809_COM@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_NEGA_INHERENT
m6809op_NEGA_INHERENT:
	pushn %r0	; 	S2_S1I$2I NEG, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_NEG@rm	; 	xcall.d m6809_NEG
	call.d	m6809_NEG@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_NEGB_INHERENT
m6809op_NEGB_INHERENT:
	pushn %r0	; 	S2_S1I$2I NEG, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_NEG@rm	; 	xcall.d m6809_NEG
	call.d	m6809_NEG@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ROLA_INHERENT
m6809op_ROLA_INHERENT:
	pushn %r0	; 	S2_S1I$2I ROL, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_ROL@rm	; 	xcall.d m6809_ROL
	call.d	m6809_ROL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ROLB_INHERENT
m6809op_ROLB_INHERENT:
	pushn %r0	; 	S2_S1I$2I ROL, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_ROL@rm	; 	xcall.d m6809_ROL
	call.d	m6809_ROL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_RORA_INHERENT
m6809op_RORA_INHERENT:
	pushn %r0	; 	S2_S1I$2I ROR, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_ROR@rm	; 	xcall.d m6809_ROR
	call.d	m6809_ROR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_RORB_INHERENT
m6809op_RORB_INHERENT:
	pushn %r0	; 	S2_S1I$2I ROR, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_ROR@rm	; 	xcall.d m6809_ROR
	call.d	m6809_ROR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ASLA_INHERENT
m6809op_ASLA_INHERENT:
	pushn %r0	; 	S2_S1I$2I ASL, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_ASL@rm	; 	xcall.d m6809_ASL
	call.d	m6809_ASL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ASLB_INHERENT
m6809op_ASLB_INHERENT:
	pushn %r0	; 	S2_S1I$2I ASL, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_ASL@rm	; 	xcall.d m6809_ASL
	call.d	m6809_ASL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ASRA_INHERENT
m6809op_ASRA_INHERENT:
	pushn %r0	; 	S2_S1I$2I ASR, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_ASR@rm	; 	xcall.d m6809_ASR
	call.d	m6809_ASR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ASRB_INHERENT
m6809op_ASRB_INHERENT:
	pushn %r0	; 	S2_S1I$2I ASR, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_ASR@rm	; 	xcall.d m6809_ASR
	call.d	m6809_ASR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_LSRA_INHERENT
m6809op_LSRA_INHERENT:
	pushn %r0	; 	S2_S1I$2I LSR, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_LSR@rm	; 	xcall.d m6809_LSR
	call.d	m6809_LSR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_LSRB_INHERENT
m6809op_LSRB_INHERENT:
	pushn %r0	; 	S2_S1I$2I LSR, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_LSR@rm	; 	xcall.d m6809_LSR
	call.d	m6809_LSR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	$2=$1($2,arg)
;****************************************************************************

;#macro S2_S1IS2_argI $1, $2
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$2]
;	xcall.d m6809_$1
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

	.global m6809op_ADDA_DATA
m6809op_ADDA_DATA:
	pushn %r0	; 	S2_S1IS2_argI ADD, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_ADD@rm	; 	xcall.d m6809_ADD
	call.d	m6809_ADD@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ADDB_DATA
m6809op_ADDB_DATA:
	pushn %r0	; 	S2_S1IS2_argI ADD, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_ADD@rm	; 	xcall.d m6809_ADD
	call.d	m6809_ADD@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ADCA_DATA
m6809op_ADCA_DATA:
	pushn %r0	; 	S2_S1IS2_argI ADC, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_ADC@rm	; 	xcall.d m6809_ADC
	call.d	m6809_ADC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ADCB_DATA
m6809op_ADCB_DATA:
	pushn %r0	; 	S2_S1IS2_argI ADC, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_ADC@rm	; 	xcall.d m6809_ADC
	call.d	m6809_ADC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_SUBA_DATA
m6809op_SUBA_DATA:
	pushn %r0	; 	S2_S1IS2_argI SUB, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_SUB@rm	; 	xcall.d m6809_SUB
	call.d	m6809_SUB@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_SUBB_DATA
m6809op_SUBB_DATA:
	pushn %r0	; 	S2_S1IS2_argI SUB, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_SUB@rm	; 	xcall.d m6809_SUB
	call.d	m6809_SUB@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_SBCA_DATA
m6809op_SBCA_DATA:
	pushn %r0	; 	S2_S1IS2_argI SBC, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_SBC@rm	; 	xcall.d m6809_SBC
	call.d	m6809_SBC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_SBCB_DATA
m6809op_SBCB_DATA:
	pushn %r0	; 	S2_S1IS2_argI SBC, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_SBC@rm	; 	xcall.d m6809_SBC
	call.d	m6809_SBC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ANDA_DATA
m6809op_ANDA_DATA:
	pushn %r0	; 	S2_S1IS2_argI AND, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_AND@rm	; 	xcall.d m6809_AND
	call.d	m6809_AND@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ANDB_DATA
m6809op_ANDB_DATA:
	pushn %r0	; 	S2_S1IS2_argI AND, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_AND@rm	; 	xcall.d m6809_AND
	call.d	m6809_AND@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ORA_DATA
m6809op_ORA_DATA:
	pushn %r0	; 	S2_S1IS2_argI OR, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_OR@rm	; 	xcall.d m6809_OR
	call.d	m6809_OR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ORB_DATA
m6809op_ORB_DATA:
	pushn %r0	; 	S2_S1IS2_argI OR, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_OR@rm	; 	xcall.d m6809_OR
	call.d	m6809_OR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_EORA_DATA
m6809op_EORA_DATA:
	pushn %r0	; 	S2_S1IS2_argI EOR, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	m6809_EOR@rm	; 	xcall.d m6809_EOR
	call.d	m6809_EOR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_EORB_DATA
m6809op_EORB_DATA:
	pushn %r0	; 	S2_S1IS2_argI EOR, B
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	m6809_EOR@rm	; 	xcall.d m6809_EOR
	call.d	m6809_EOR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	$3=$1($3,$2)
;****************************************************************************

;#macro S3_S1IS3_S2I $1, $2, $3
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$3]
;	xld.ub %r14, [%r12+$2]
;	xcall.d m6809_$1
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$3], %r10
	;
;	popn %r0
;	ret
;#endm

	.global m6809op_ABA_INHERENT
m6809op_ABA_INHERENT:
	pushn %r0	; 	S3_S1IS3_S2I ADD, B, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	ext	m6809_ADD@rm	; 	xcall.d m6809_ADD
	call.d	m6809_ADD@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_SBA_INHERENT
m6809op_SBA_INHERENT:
	pushn %r0	; 	S3_S1IS3_S2I SUB, B, A
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	ext	m6809_SUB@rm	; 	xcall.d m6809_SUB
	call.d	m6809_SUB@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	$2=$1($2,READ(arg))
;****************************************************************************

;#macro S2_S1IS2_READIargII $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r14, %r10
;	xld.ub %r13, [%r0+$2]
;	xcall.d m6809_$1		; *delay*
;	ld.w %r12, %r0
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

	.global m6809op_ADDA_ADDRESS
m6809op_ADDA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ADD, A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6809_ADD@rm	; 	xcall.d m6809_ADD		; *delay*
	call.d	m6809_ADD@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ADDB_ADDRESS
m6809op_ADDB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ADD, B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6809_ADD@rm	; 	xcall.d m6809_ADD		; *delay*
	call.d	m6809_ADD@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ADCA_ADDRESS
m6809op_ADCA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ADC, A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6809_ADC@rm	; 	xcall.d m6809_ADC		; *delay*
	call.d	m6809_ADC@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ADCB_ADDRESS
m6809op_ADCB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII ADC, B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6809_ADC@rm	; 	xcall.d m6809_ADC		; *delay*
	call.d	m6809_ADC@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_SUBA_ADDRESS
m6809op_SUBA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII SUB, A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6809_SUB@rm	; 	xcall.d m6809_SUB		; *delay*
	call.d	m6809_SUB@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_SUBB_ADDRESS
m6809op_SUBB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII SUB, B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6809_SUB@rm	; 	xcall.d m6809_SUB		; *delay*
	call.d	m6809_SUB@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_SBCA_ADDRESS
m6809op_SBCA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII SBC, A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6809_SBC@rm	; 	xcall.d m6809_SBC		; *delay*
	call.d	m6809_SBC@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_SBCB_ADDRESS
m6809op_SBCB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII SBC, B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6809_SBC@rm	; 	xcall.d m6809_SBC		; *delay*
	call.d	m6809_SBC@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ANDA_ADDRESS
m6809op_ANDA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII AND, A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6809_AND@rm	; 	xcall.d m6809_AND		; *delay*
	call.d	m6809_AND@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ANDB_ADDRESS
m6809op_ANDB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII AND, B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6809_AND@rm	; 	xcall.d m6809_AND		; *delay*
	call.d	m6809_AND@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ORA_ADDRESS
m6809op_ORA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII OR, A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6809_OR@rm	; 	xcall.d m6809_OR		; *delay*
	call.d	m6809_OR@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_ORB_ADDRESS
m6809op_ORB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII OR, B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6809_OR@rm	; 	xcall.d m6809_OR		; *delay*
	call.d	m6809_OR@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_EORA_ADDRESS
m6809op_EORA_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII EOR, A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	m6809_EOR@rm	; 	xcall.d m6809_EOR		; *delay*
	call.d	m6809_EOR@rl
	ld.w %r12, %r0
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global m6809op_EORB_ADDRESS
m6809op_EORB_ADDRESS:
	pushn %r0	; 	S2_S1IS2_READIargII EOR, B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	m6809_EOR@rm	; 	xcall.d m6809_EOR		; *delay*
	call.d	m6809_EOR@rl
	ld.w %r12, %r0
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	WRITE(arg,$1(READ(arg)))
;****************************************************************************

;#macro WRITEIarg_S1IREADIargIII $1
;	pushn %r1
;	ld.w %r1, %r14
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	xcall.d m6809_$1
;	ld.w %r12, %r0			; *delay*
	;
;	ld.w %r14, %r10
;	xld.w %r10, [%r0+WRITE]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r1
;	ret
;#endm

	.global m6809op_INC_ADDRESS
m6809op_INC_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII INC
	ld.w %r1, %r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6809_INC@rm	; 	xcall.d m6809_INC
	call.d	m6809_INC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6809op_DEC_ADDRESS
m6809op_DEC_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII DEC
	ld.w %r1, %r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6809_DEC@rm	; 	xcall.d m6809_DEC
	call.d	m6809_DEC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6809op_COM_ADDRESS
m6809op_COM_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII COM
	ld.w %r1, %r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6809_COM@rm	; 	xcall.d m6809_COM
	call.d	m6809_COM@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6809op_NEG_ADDRESS
m6809op_NEG_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII NEG
	ld.w %r1, %r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6809_NEG@rm	; 	xcall.d m6809_NEG
	call.d	m6809_NEG@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6809op_ROL_ADDRESS
m6809op_ROL_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ROL
	ld.w %r1, %r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6809_ROL@rm	; 	xcall.d m6809_ROL
	call.d	m6809_ROL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6809op_ROR_ADDRESS
m6809op_ROR_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ROR
	ld.w %r1, %r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6809_ROR@rm	; 	xcall.d m6809_ROR
	call.d	m6809_ROR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6809op_ASL_ADDRESS
m6809op_ASL_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ASL
	ld.w %r1, %r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6809_ASL@rm	; 	xcall.d m6809_ASL
	call.d	m6809_ASL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6809op_ASR_ADDRESS
m6809op_ASR_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ASR
	ld.w %r1, %r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6809_ASR@rm	; 	xcall.d m6809_ASR
	call.d	m6809_ASR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global m6809op_LSR_ADDRESS
m6809op_LSR_ADDRESS:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII LSR
	ld.w %r1, %r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	m6809_LSR@rm	; 	xcall.d m6809_LSR
	call.d	m6809_LSR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

;****************************************************************************
;	Others
;****************************************************************************

;#macro LDr_DATA $1
;	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
;	xld.b [%r12+$1], %r14		; $1 = arg
	;
;	xrr %r14, 8			; %r14[31:24] = $1
;	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
;	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
;	xsll %r10, 4			; %r10 = %psr(00ZN0000)
;	mirror %r10, %r10		; %r10 = CC(0000NZ00)
;	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
;	or %r11, %r10			; %r11 = CC(EFHINZ0C)
;	xld.b [%r12+CC], %r11
	;
;	ret
;#endm

	.global m6809op_LDA_DATA
m6809op_LDA_DATA:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC	; 	LDr_DATA A
	;
	ext	0x3		; 	xld.b [%r12+0x3], %r14		; $1 = arg
	ld.b	[%r12],%r14
	;
	rr	%r14,0x8	; 	xrr %r14, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global m6809op_LDB_DATA
m6809op_LDB_DATA:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; %r11 = CC	; 	LDr_DATA B
	;
	ext	0x2		; 	xld.b [%r12+0x2], %r14		; $1 = arg
	ld.b	[%r12],%r14
	;
	rr	%r14,0x8	; 	xrr %r14, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************

;#macro LDr_ADDRESS $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.b [%r0+$1], %r10		; $1 = READ(arg)
	;
;	xld.ub %r11, [%r0+CC]		; %r11 = CC
	;
;	xrr %r10, 8			; %r14[31:24] = $1
;	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
;	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
;	xsll %r10, 4			; %r10 = %psr(00ZN0000)
;	mirror %r10, %r10		; %r10 = CC(0000NZ00)
;	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
;	or %r11, %r10			; %r11 = CC(EFHINZ0C)
;	xld.b [%r0+CC], %r11
	;
;	popn %r0
;	ret
;#endm

	.global m6809op_LDA_ADDRESS
m6809op_LDA_ADDRESS:
	pushn %r0	; 	LDr_ADDRESS A
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x3		; 	xld.b [%r0+0x3], %r10		; $1 = READ(arg)
	ld.b	[%r0],%r10
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]		; %r11 = CC
	;
	rr	%r10,0x8	; 	xrr %r10, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global m6809op_LDB_ADDRESS
m6809op_LDB_ADDRESS:
	pushn %r0	; 	LDr_ADDRESS B
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x2		; 	xld.b [%r0+0x2], %r10		; $1 = READ(arg)
	ld.b	[%r0],%r10
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]		; %r11 = CC
	;
	rr	%r10,0x8	; 	xrr %r10, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret

;****************************************************************************

;#macro STr_ADDRESS $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+WRITE]	; WRITE(arg, $1)
;	ld.w %r13, %r14
;	xld.ub %r14, [%r12+$1]
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.ub %r10, [%r0+$1]		; %r10 = $1
;	xld.ub %r11, [%r0+CC]		; %r11 = CC *anti-interlock*
;	xrr %r10, 8			; %r10[31:24] = $1
;	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
;	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
;	xsll %r10, 4			; %r10 = %psr(00ZN0000)
;	mirror %r10, %r10		; %r10 = CC(0000NZ00)
;	xand %r11, %r11, ~0xe		; %r11 = CC(EFHI000C)
;	or %r11, %r10			; %r11 = CC(EFHINZ0C)
;	xld.b [%r0+CC], %r11
	;
;	popn %r0
;	ret
;#endm

	.global m6809op_STA_ADDRESS
m6809op_STA_ADDRESS:
	pushn %r0	; 	STr_ADDRESS A
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]	; WRITE(arg, $1)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x3		; 	xld.ub %r10, [%r0+0x3]		; %r10 = $1
	ld.ub	%r10,[%r0]
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]		; %r11 = CC *anti-interlock*
	rr	%r10,0x8	; 	xrr %r10, 8			; %r10[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global m6809op_STB_ADDRESS
m6809op_STB_ADDRESS:
	pushn %r0	; 	STr_ADDRESS B
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]	; WRITE(arg, $1)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x2		; 	xld.ub %r10, [%r0+0x2]		; %r10 = $1
	ld.ub	%r10,[%r0]
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]		; %r11 = CC *anti-interlock*
	rr	%r10,0x8	; 	xrr %r10, 8			; %r10[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	and	%r10,0x3	; 	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	sll	%r10,0x4	; 	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	and	%r11,0x31	; 	xand %r11, %r11, -15		; %r11 = CC(EFHI000C)
	or %r11, %r10			; %r11 = CC(EFHINZ0C)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret

;****************************************************************************
;	JUMP AND BRANCH
;****************************************************************************

;* Branch if Flag is Clear */
;#macro Bfc_ADDRESS $1
;	xbtst [%r12+CC], $1
;	xjrne $$1			; if(flag is 1) no-jump
;	xld.w %r10, [%r12+CYCLE]
;	xld.h [%r12+PC], %r14		; *anti-interlock*
;	xsub %r10, %r10, 1
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

	.global m6809op_BHS_ADDRESS
m6809op_BHS_ADDRESS:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	Bfc_ADDRESS 0
	jrne	__LX0001	; 	xjrne __L0001			; if(flag is 1) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0001:				; __L0001:
	ret
	.global m6809op_BVC_ADDRESS
m6809op_BVC_ADDRESS:
	btst	[%r12],0x1	; 	xbtst [%r12+0x0], 0x1	; 	Bfc_ADDRESS 1
	jrne	__LX0002	; 	xjrne __L0002			; if(flag is 1) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0002:				; __L0002:
	ret
	.global m6809op_BNE_ADDRESS
m6809op_BNE_ADDRESS:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	Bfc_ADDRESS 2
	jrne	__LX0003	; 	xjrne __L0003			; if(flag is 1) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0003:				; __L0003:
	ret
	.global m6809op_BPL_ADDRESS
m6809op_BPL_ADDRESS:
	btst	[%r12],0x3	; 	xbtst [%r12+0x0], 0x3	; 	Bfc_ADDRESS 3
	jrne	__LX0004	; 	xjrne __L0004			; if(flag is 1) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0004:				; __L0004:
	ret

;****************************************************************************

;* Branch if Flag is Set */
;#macro Bfs_ADDRESS $1
;	xbtst [%r12+CC], $1
;	xjreq $$1			; if(flag is 0) no-jump
;	xld.w %r10, [%r12+CYCLE]
;	xld.h [%r12+PC], %r14		; *anti-interlock*
;	xsub %r10, %r10, 1
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

	.global m6809op_BLO_ADDRESS
m6809op_BLO_ADDRESS:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	Bfs_ADDRESS 0
	jreq	__LX0005	; 	xjreq __L0005			; if(flag is 0) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0005:				; __L0005:
	ret
	.global m6809op_BVS_ADDRESS
m6809op_BVS_ADDRESS:
	btst	[%r12],0x1	; 	xbtst [%r12+0x0], 0x1	; 	Bfs_ADDRESS 1
	jreq	__LX0006	; 	xjreq __L0006			; if(flag is 0) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0006:				; __L0006:
	ret
	.global m6809op_BEQ_ADDRESS
m6809op_BEQ_ADDRESS:
	btst	[%r12],0x2	; 	xbtst [%r12+0x0], 0x2	; 	Bfs_ADDRESS 2
	jreq	__LX0007	; 	xjreq __L0007			; if(flag is 0) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0007:				; __L0007:
	ret
	.global m6809op_BMI_ADDRESS
m6809op_BMI_ADDRESS:
	btst	[%r12],0x3	; 	xbtst [%r12+0x0], 0x3	; 	Bfs_ADDRESS 3
	jreq	__LX0008	; 	xjreq __L0008			; if(flag is 0) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0008:				; __L0008:
	ret

;****************************************************************************

;
	.global m6809op_BGE_ADDRESS
m6809op_BGE_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = EFHINZVC
	ld.w %r11, %r10			; %r11 = EFHINZVC
	rr	%r11,0x2	; 	xrr %r11, 2			; %r11 = 00EFHINZ
	xor %r10, %r11			;              +- N^V
	and	%r10,0x2	; 	xand %r10, %r10, 2
	jrne	m6809op_BGE_ADDRESS_L10	; 	xjrne m6809op_BGE_ADDRESS_L10	; if(N^V is 1) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
m6809op_BGE_ADDRESS_L10:
	ret

;
	.global m6809op_BLT_ADDRESS
m6809op_BLT_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = EFHINZVC
	ld.w %r11, %r10			; %r11 = EFHINZVC
	rr	%r11,0x2	; 	xrr %r11, 2			; %r11 = 00EFHINZ
	xor %r10, %r11			;              +- N^V
	and	%r10,0x2	; 	xand %r10, %r10, 2
	jreq	m6809op_BLT_ADDRESS_L10	; 	xjreq m6809op_BLT_ADDRESS_L10	; if(N^V is 0) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
m6809op_BLT_ADDRESS_L10:
	ret

;
	.global m6809op_BGT_ADDRESS
m6809op_BGT_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = EFHINZVC
	ld.w %r11, %r10			; %r11 = EFHINZVC
	rr	%r11,0x2	; 	xrr %r11, 2			; %r11 = 00EFHINZ
	xor %r10, %r11			;              +- N^V
	rl	%r11,0x1	; 	xrl %r11, 1			; %r11 = 0EFHINZV
	or %r10, %r11			;              +- (N^V)|Z
	and	%r10,0x2	; 	xand %r10, %r10, 2
	jrne	m6809op_BGT_ADDRESS_L10	; 	xjrne m6809op_BGT_ADDRESS_L10	; if((N^V)|Z is 1) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
m6809op_BGT_ADDRESS_L10:
	ret

;
	.global m6809op_BLE_ADDRESS
m6809op_BLE_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = EFHINZVC
	ld.w %r11, %r10			; %r11 = EFHINZVC
	rr	%r11,0x2	; 	xrr %r11, 2			; %r11 = 00EFHINZ
	xor %r10, %r11			;              +- N^V
	rl	%r11,0x1	; 	xrl %r11, 1			; %r11 = 0EFHINZV
	or %r10, %r11			;              +- (N^V)|Z
	and	%r10,0x2	; 	xand %r10, %r10, 2
	jreq	m6809op_BLE_ADDRESS_L10	; 	xjreq m6809op_BLE_ADDRESS_L10	; if((N^V)|Z is 0) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
m6809op_BLE_ADDRESS_L10:
	ret

;
	.global m6809op_BHI_ADDRESS
m6809op_BHI_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = EFHINZVC
	and	%r10,0x5	; 	xand %r10, %r10, 5		; %r10 = 00000Z0C
	jrne	m6809op_BHI_ADDRESS_L10	; 	xjrne m6809op_BHI_ADDRESS_L10	; if(Z|C is 1) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
m6809op_BHI_ADDRESS_L10:
	ret

;
	.global m6809op_BLS_ADDRESS
m6809op_BLS_ADDRESS:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; %r10 = EFHINZVC
	and	%r10,0x5	; 	xand %r10, %r10, 5		; %r10 = 00000Z0C
	jreq	m6809op_BLS_ADDRESS_L10	; 	xjreq m6809op_BLS_ADDRESS_L10	; if(Z|C is 0) no-jump
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
m6809op_BLS_ADDRESS_L10:
	ret

;****************************************************************************

	.global m6809op_BSR_ADDRESS
m6809op_BSR_ADDRESS:
	pushn %r2
	;
	ext	0xa		; 	xld.uh %r1, [%r12+0xa]		; S
	ld.uh	%r1,[%r12]
	ext	0xc		; 	xld.uh %r2, [%r12+0xc]		; PC
	ld.uh	%r2,[%r12]
	;
	ext	0xc		; 	xld.h [%r12+0xc], %r14		; PC <= arg
	ld.h	[%r12],%r14
	;
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; S--
	ext	0x18		; 	xld.w %r10, [%r12+0x18]	; PUSH(PCL)
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1
	ld.ub %r14, %r2
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; S--
	ext	0x18		; 	xld.w %r10, [%r0+0x18]		; PUSH(PCH)
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	ld.uh %r14, %r2
	srl	%r14,0x8	; 	xsrl %r14, 8
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0xa		; 	xld.h [%r0+0xa], %r1		; S
	ld.h	[%r0],%r1
	;
	popn %r2
	ret

;****************************************************************************

	.global m6809op_RTS_INHERENT
m6809op_RTS_INHERENT:
	pushn %r2
	;
	ext	0xa		; 	xld.uh %r1, [%r12+0xa]		; S
	ld.uh	%r1,[%r12]
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]		; POP(PCH)
	ld.w	%r10,[%r12]
	ld.w %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; S++
	;
	ld.w %r2, %r10			; (save PCH)
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; POP(PCL)
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; S++
	;
	sll	%r2,0x8		; 	xsll %r2, 8			; PC <= PCH << 8 | PCL
	or %r2, %r10
	ext	0xc		; 	xld.h [%r0+0xc], %r2
	ld.h	[%r0],%r2
	;
	ext	0xa		; 	xld.h [%r0+0xa], %r1		; S
	ld.h	[%r0],%r1
	;
	popn %r2
	ret

;****************************************************************************
;	
;****************************************************************************

;#endif /*M6809_ASM*/
