/*	
 *	framm68.c
 *
 *	P/ECE M6809 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Wed Feb 11 17:45:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipm69i.h"	/*M6809G~[^p}N*/

/****************************************************************************
 *	M6809RÃCREAD/WRITEO֐
 ****************************************************************************/

/* M6809\(28oCg)̒ɃCzuĂ邱Ƃ肵܂B
 * oCiCAEgقȂꍇAoNؑւȂǂ̓ᏈKvȏꍇ́A
 * AvP[V`̊O֐pӂĂB
 */

#ifndef M6809_ASM	/****************************************************/

unsigned char
m6809_internal_read(M6809* m6809, unsigned short addr)
{
	return ((unsigned char*)(m6809 + 1))[addr];
}
void
m6809_internal_write(M6809* m6809, unsigned short addr, unsigned char data)
{
	((unsigned char*)(m6809 + 1))[addr] = data;
}

#else	/********************************************************************/

asm("
	.code
	.align 1
	.global m6809_internal_read
m6809_internal_read:
	add %r12, %r13
	xld.ub %r10, [%r12+28]
	ret
");
asm("
	.code
	.align 1
	.global m6809_internal_write
m6809_internal_write:
	add %r12, %r13
	xld.b [%r12+28], %r14
	ret
");

#endif	/********************************************************************/

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef M6809_ASM

void
m6809_run(M6809* m6809, int cycle)
{
	CYCLE = cycle;
	while(!WAIT && CYCLE > 0) {
		m6809_one(m6809, m6809_op_table);
	}
}

void
m6809_one(M6809* m6809, const M6809OP op_table[/*256*/])
{
	const M6809OP* op;
	int code;
	int arg = 0; /* x} */

#ifdef M6809_TRACE
	m6809_dump(m6809);
#endif /*M6809_TRACE*/
	M6809TRACE("%04x: ", PC);
	FETCH(code);

	op = &op_table[code];
	switch(op->addr) {
	/*==== operand bytes=0 ====*/
	case M6809_INHERENT:
		break;
	/*==== operand bytes=1 ====*/
	case M6809_IMMEDIATE1:
		FETCH(arg);
		break;
	case M6809_DIRECT:
		FETCH(arg);
		arg |= DP << 8;
		break;
	case M6809_RELATIVE1:
		FETCH(arg);
		arg = (PC + (char)arg) & 0xffff;
		break;
	/*==== operand bytes=2 ====*/
	case M6809_IMMEDIATE2:
	case M6809_EXTENDED:
		FETCHW(arg);
		break;
	case M6809_RELATIVE2:
		FETCHW(arg);
		arg = (PC + arg) & 0xffff;
		break;
	/*==== operand bytes=? ====*/
	case M6809_INDEXED:
		arg = m6809_indexed(m6809);
		break;
#ifndef PIECE /* P/ECEł͍RAMŝ߃Jbg */
	default:
		DIE();
#endif /*PIECE*/
	}

	EXEC();
	M6809TRACE("\n");
}

#endif /*M6809_ASM*/

/* * Sun Feb 15 11:46:00 JST 2004 Naoyuki Sawa
 * - CfNXAhbVȌ[`Aލ܂B
 *   㑤ȃᑬłŁAeʍłłB
 *   ꉞAmF܂B(܂ԒxȂ̂ŁA܂莩M܂c)
 * - ȃᑬłȂ΁ARAMɒu܂B
 *   eʍłSRAMɔzuAeʒᑬłRAMɔzuꊄ炢łB
 *   ]2004/02/15݂́Aȃᑬł̗pĂ܂B
 *   ȃᑬł炢̃TCYȂ΁AAZučłłB(TODO:̉ۑ)
 * - eʍłɐ؂芷ꍇ́ARAMɓȂ̂SRAMW[ֈڂĂB
 */
#if 1	/************************************************************/
int
m6809_indexed(M6809* m6809)
{
	int postbyte;
	unsigned short arg;
	unsigned short* reg;

	FETCH(postbyte);

	/* -RR-----: 0:X/1:Y/2:U/3:S */
	switch((postbyte >> 5) & 3) {
	case 0:       reg = &X; break;
	case 1:       reg = &Y; break;
	case 2:       reg = &U; break;
	default/*3*/: reg = &S; break;
	}
	if(!(postbyte & 0x80)) {
		/************************************************************
		 * Constant Offset from Register (twos Complement Offset)
		 ************************************************************/
		/* 0RRnnnnn: 5-Bit Offset (Direct only) */
		arg = *reg + ((char)(postbyte << 3) >> 3);
		CYCLE -= 1;
	} else {
		switch(postbyte & 0xf) {
		/************************************************************
		 * Constant Offset from Register (twos Complement Offset)
		 ************************************************************/
		/* 1RR-0100: No-Offset */
		case 0x4:
			arg = *reg;
			CYCLE -= 0;
			break;
		/* 1RR-1000: 8-Bit Offset */
		case 0x8:
			FETCH(arg);
			arg = *reg + (char)arg;
			CYCLE -= 1;
			break;
		/* 1RR-1001: 16-Bit Offset */
		case 0x9:
			FETCHW(arg);
			arg = *reg + arg;
			CYCLE -= 4;
			break;
		/************************************************************
		 * Accumulator Offset from Register (twos Complement Offset)
		 ************************************************************/
		/* 1RR-0110: A Accumulator Offset */
		case 0x6:
			arg = *reg + (char)A;
			CYCLE -= 1;
			break;
		/* 1RR-0101: B Accumulator Offset */
		case 0x5:
			arg = *reg + (char)B;
			CYCLE -= 1;
			break;
		/* 1RR-1011: D Accumulator Offset */
		case 0xb:
			arg = *reg + D;
			CYCLE -= 4;
			break;
		/************************************************************
		 * Auto Increment/Decrement from Register
		 ************************************************************/
		/* 1RR00000: Increment by 1 (Direct only) */
		case 0x0:
			arg = *reg;
			*reg += 1; /* PostIncrement */
			CYCLE -= 2;
			break;
		/* 1RR-0001: Increment by 2 */
		case 0x1:
			arg = *reg;
			*reg += 2; /* PostIncrement */
			CYCLE -= 3;
			break;
		/* 1RR00010: Decrement by 1 (Direct only) */
		case 0x2:
			*reg -= 1; /* PreDecrement */
			arg = *reg;
			CYCLE -= 2;
			break;
		/* 1RR-0011: Decrement by 2 */
		case 0x3:
			*reg -= 2; /* PreDecrement */
			arg = *reg;
			CYCLE -= 3;
			break;
		/************************************************************
		 * Constant Offset from Program Counter
		 ************************************************************/
		/* 1XX-1100: 8-Bit Offset */
		case 0xc:
			FETCH(arg);
			arg = PC + (char)arg;
			CYCLE -= 1;
			break;
		/* 1XX-1101: 16-Bit Offset */
		case 0xd:
			FETCHW(arg);
			arg = PC + arg;
			CYCLE -= 5;
			break;
		/************************************************************
		 * Extended Indirect
		 ************************************************************/
		/* 10011111: 16-Bit Address (Indirect only) */
		case 0xf:
			FETCHW(arg);
			CYCLE -= 5 - 3/*Ƃň*/;
			break;
		/************************************************************
		 *
		 ************************************************************/
		default:
#ifndef PIECE
			DIE();
#endif /*PIECE*/
			arg = 0; /* x} */
			break;
		}
		/* ---I----: 0:Direct/1:Indirect */
		if(postbyte & 0x10) {
			arg = READW(arg);
			CYCLE -= 3;
		}
	}

	return arg;
}
#else	/************************************************************/
int
m6809_indexed(M6809* m6809)
{
	int postbyte;
	unsigned short arg;

	FETCH(postbyte);

	switch(postbyte) {
	/************************************************************
	 * Constant Offset from Register (twos Complement Offset)
	 ************************************************************/
	/* 0RRnnnnn: 5-Bit Offset (Direct only) */
	case 0x00: arg = X +  0; CYCLE -= 1; break;
	case 0x01: arg = X +  1; CYCLE -= 1; break;
	case 0x02: arg = X +  2; CYCLE -= 1; break;
	case 0x03: arg = X +  3; CYCLE -= 1; break;
	case 0x04: arg = X +  4; CYCLE -= 1; break;
	case 0x05: arg = X +  5; CYCLE -= 1; break;
	case 0x06: arg = X +  6; CYCLE -= 1; break;
	case 0x07: arg = X +  7; CYCLE -= 1; break;
	case 0x08: arg = X +  8; CYCLE -= 1; break;
	case 0x09: arg = X +  9; CYCLE -= 1; break;
	case 0x0a: arg = X + 10; CYCLE -= 1; break;
	case 0x0b: arg = X + 11; CYCLE -= 1; break;
	case 0x0c: arg = X + 12; CYCLE -= 1; break;
	case 0x0d: arg = X + 13; CYCLE -= 1; break;
	case 0x0e: arg = X + 14; CYCLE -= 1; break;
	case 0x0f: arg = X + 15; CYCLE -= 1; break;
	case 0x10: arg = X - 16; CYCLE -= 1; break;
	case 0x11: arg = X - 15; CYCLE -= 1; break;
	case 0x12: arg = X - 14; CYCLE -= 1; break;
	case 0x13: arg = X - 13; CYCLE -= 1; break;
	case 0x14: arg = X - 12; CYCLE -= 1; break;
	case 0x15: arg = X - 11; CYCLE -= 1; break;
	case 0x16: arg = X - 10; CYCLE -= 1; break;
	case 0x17: arg = X -  9; CYCLE -= 1; break;
	case 0x18: arg = X -  8; CYCLE -= 1; break;
	case 0x19: arg = X -  7; CYCLE -= 1; break;
	case 0x1a: arg = X -  6; CYCLE -= 1; break;
	case 0x1b: arg = X -  5; CYCLE -= 1; break;
	case 0x1c: arg = X -  4; CYCLE -= 1; break;
	case 0x1d: arg = X -  3; CYCLE -= 1; break;
	case 0x1e: arg = X -  2; CYCLE -= 1; break;
	case 0x1f: arg = X -  1; CYCLE -= 1; break;
	//
	case 0x20: arg = Y +  0; CYCLE -= 1; break;
	case 0x21: arg = Y +  1; CYCLE -= 1; break;
	case 0x22: arg = Y +  2; CYCLE -= 1; break;
	case 0x23: arg = Y +  3; CYCLE -= 1; break;
	case 0x24: arg = Y +  4; CYCLE -= 1; break;
	case 0x25: arg = Y +  5; CYCLE -= 1; break;
	case 0x26: arg = Y +  6; CYCLE -= 1; break;
	case 0x27: arg = Y +  7; CYCLE -= 1; break;
	case 0x28: arg = Y +  8; CYCLE -= 1; break;
	case 0x29: arg = Y +  9; CYCLE -= 1; break;
	case 0x2a: arg = Y + 10; CYCLE -= 1; break;
	case 0x2b: arg = Y + 11; CYCLE -= 1; break;
	case 0x2c: arg = Y + 12; CYCLE -= 1; break;
	case 0x2d: arg = Y + 13; CYCLE -= 1; break;
	case 0x2e: arg = Y + 14; CYCLE -= 1; break;
	case 0x2f: arg = Y + 15; CYCLE -= 1; break;
	case 0x30: arg = Y - 16; CYCLE -= 1; break;
	case 0x31: arg = Y - 15; CYCLE -= 1; break;
	case 0x32: arg = Y - 14; CYCLE -= 1; break;
	case 0x33: arg = Y - 13; CYCLE -= 1; break;
	case 0x34: arg = Y - 12; CYCLE -= 1; break;
	case 0x35: arg = Y - 11; CYCLE -= 1; break;
	case 0x36: arg = Y - 10; CYCLE -= 1; break;
	case 0x37: arg = Y -  9; CYCLE -= 1; break;
	case 0x38: arg = Y -  8; CYCLE -= 1; break;
	case 0x39: arg = Y -  7; CYCLE -= 1; break;
	case 0x3a: arg = Y -  6; CYCLE -= 1; break;
	case 0x3b: arg = Y -  5; CYCLE -= 1; break;
	case 0x3c: arg = Y -  4; CYCLE -= 1; break;
	case 0x3d: arg = Y -  3; CYCLE -= 1; break;
	case 0x3e: arg = Y -  2; CYCLE -= 1; break;
	case 0x3f: arg = Y -  1; CYCLE -= 1; break;
	//
	case 0x40: arg = U +  0; CYCLE -= 1; break;
	case 0x41: arg = U +  1; CYCLE -= 1; break;
	case 0x42: arg = U +  2; CYCLE -= 1; break;
	case 0x43: arg = U +  3; CYCLE -= 1; break;
	case 0x44: arg = U +  4; CYCLE -= 1; break;
	case 0x45: arg = U +  5; CYCLE -= 1; break;
	case 0x46: arg = U +  6; CYCLE -= 1; break;
	case 0x47: arg = U +  7; CYCLE -= 1; break;
	case 0x48: arg = U +  8; CYCLE -= 1; break;
	case 0x49: arg = U +  9; CYCLE -= 1; break;
	case 0x4a: arg = U + 10; CYCLE -= 1; break;
	case 0x4b: arg = U + 11; CYCLE -= 1; break;
	case 0x4c: arg = U + 12; CYCLE -= 1; break;
	case 0x4d: arg = U + 13; CYCLE -= 1; break;
	case 0x4e: arg = U + 14; CYCLE -= 1; break;
	case 0x4f: arg = U + 15; CYCLE -= 1; break;
	case 0x50: arg = U - 16; CYCLE -= 1; break;
	case 0x51: arg = U - 15; CYCLE -= 1; break;
	case 0x52: arg = U - 14; CYCLE -= 1; break;
	case 0x53: arg = U - 13; CYCLE -= 1; break;
	case 0x54: arg = U - 12; CYCLE -= 1; break;
	case 0x55: arg = U - 11; CYCLE -= 1; break;
	case 0x56: arg = U - 10; CYCLE -= 1; break;
	case 0x57: arg = U -  9; CYCLE -= 1; break;
	case 0x58: arg = U -  8; CYCLE -= 1; break;
	case 0x59: arg = U -  7; CYCLE -= 1; break;
	case 0x5a: arg = U -  6; CYCLE -= 1; break;
	case 0x5b: arg = U -  5; CYCLE -= 1; break;
	case 0x5c: arg = U -  4; CYCLE -= 1; break;
	case 0x5d: arg = U -  3; CYCLE -= 1; break;
	case 0x5e: arg = U -  2; CYCLE -= 1; break;
	case 0x5f: arg = U -  1; CYCLE -= 1; break;
	//
	case 0x60: arg = S +  0; CYCLE -= 1; break;
	case 0x61: arg = S +  1; CYCLE -= 1; break;
	case 0x62: arg = S +  2; CYCLE -= 1; break;
	case 0x63: arg = S +  3; CYCLE -= 1; break;
	case 0x64: arg = S +  4; CYCLE -= 1; break;
	case 0x65: arg = S +  5; CYCLE -= 1; break;
	case 0x66: arg = S +  6; CYCLE -= 1; break;
	case 0x67: arg = S +  7; CYCLE -= 1; break;
	case 0x68: arg = S +  8; CYCLE -= 1; break;
	case 0x69: arg = S +  9; CYCLE -= 1; break;
	case 0x6a: arg = S + 10; CYCLE -= 1; break;
	case 0x6b: arg = S + 11; CYCLE -= 1; break;
	case 0x6c: arg = S + 12; CYCLE -= 1; break;
	case 0x6d: arg = S + 13; CYCLE -= 1; break;
	case 0x6e: arg = S + 14; CYCLE -= 1; break;
	case 0x6f: arg = S + 15; CYCLE -= 1; break;
	case 0x70: arg = S - 16; CYCLE -= 1; break;
	case 0x71: arg = S - 15; CYCLE -= 1; break;
	case 0x72: arg = S - 14; CYCLE -= 1; break;
	case 0x73: arg = S - 13; CYCLE -= 1; break;
	case 0x74: arg = S - 12; CYCLE -= 1; break;
	case 0x75: arg = S - 11; CYCLE -= 1; break;
	case 0x76: arg = S - 10; CYCLE -= 1; break;
	case 0x77: arg = S -  9; CYCLE -= 1; break;
	case 0x78: arg = S -  8; CYCLE -= 1; break;
	case 0x79: arg = S -  7; CYCLE -= 1; break;
	case 0x7a: arg = S -  6; CYCLE -= 1; break;
	case 0x7b: arg = S -  5; CYCLE -= 1; break;
	case 0x7c: arg = S -  4; CYCLE -= 1; break;
	case 0x7d: arg = S -  3; CYCLE -= 1; break;
	case 0x7e: arg = S -  2; CYCLE -= 1; break;
	case 0x7f: arg = S -  1; CYCLE -= 1; break;
	//
	/* 1RR00100: No-Offset (Direct) */
	case 0x84: arg = X; CYCLE -= 0; break;
	case 0xa4: arg = Y; CYCLE -= 0; break;
	case 0xc4: arg = U; CYCLE -= 0; break;
	case 0xe4: arg = S; CYCLE -= 0; break;
	//
	/* 1RR10100: No-Offset (Indirect) */
	case 0x94: arg = X; arg = READW(arg); CYCLE -= 3; break;
	case 0xb4: arg = Y; arg = READW(arg); CYCLE -= 3; break;
	case 0xd4: arg = U; arg = READW(arg); CYCLE -= 3; break;
	case 0xf4: arg = S; arg = READW(arg); CYCLE -= 3; break;
	//
	/* 1RR01000: 8-Bit Offset (Direct) */
	case 0x88: FETCH(arg); arg = X + (char)arg; CYCLE -= 1; break;
	case 0xa8: FETCH(arg); arg = Y + (char)arg; CYCLE -= 1; break;
	case 0xc8: FETCH(arg); arg = U + (char)arg; CYCLE -= 1; break;
	case 0xe8: FETCH(arg); arg = S + (char)arg; CYCLE -= 1; break;
	//
	/* 1RR11000: 8-Bit Offset (Indirect) */
	case 0x98: FETCH(arg); arg = X + (char)arg; arg = READW(arg); CYCLE -= 4; break;
	case 0xb8: FETCH(arg); arg = Y + (char)arg; arg = READW(arg); CYCLE -= 4; break;
	case 0xd8: FETCH(arg); arg = U + (char)arg; arg = READW(arg); CYCLE -= 4; break;
	case 0xf8: FETCH(arg); arg = S + (char)arg; arg = READW(arg); CYCLE -= 4; break;
	//
	/* 1RR01001: 16-Bit Offset (Direct) */
	case 0x89: FETCHW(arg); arg = X + arg; CYCLE -= 4; break;
	case 0xa9: FETCHW(arg); arg = Y + arg; CYCLE -= 4; break;
	case 0xc9: FETCHW(arg); arg = U + arg; CYCLE -= 4; break;
	case 0xe9: FETCHW(arg); arg = S + arg; CYCLE -= 4; break;
	//
	/* 1RR11001: 16-Bit Offset (Indirect) */
	case 0x99: FETCHW(arg); arg = X + arg; arg = READW(arg); CYCLE -= 7; break;
	case 0xb9: FETCHW(arg); arg = Y + arg; arg = READW(arg); CYCLE -= 7; break;
	case 0xd9: FETCHW(arg); arg = U + arg; arg = READW(arg); CYCLE -= 7; break;
	case 0xf9: FETCHW(arg); arg = S + arg; arg = READW(arg); CYCLE -= 7; break;
	//
	/************************************************************
	 * Auto Increment/Decrement from Register
	 ************************************************************/
	/* 1RR00000: Increment by 1 (Direct only) */
	case 0x80: arg = X; X += 1; CYCLE -= 2; break;
	case 0xa0: arg = Y; Y += 1; CYCLE -= 2; break;
	case 0xc0: arg = U; U += 1; CYCLE -= 2; break;
	case 0xe0: arg = S; S += 1; CYCLE -= 2; break;
	//
	/* 1RR00001: Increment by 2 (Direct) */
	case 0x81: arg = X; X += 2; CYCLE -= 3; break;
	case 0xa1: arg = Y; Y += 2; CYCLE -= 3; break;
	case 0xc1: arg = U; U += 2; CYCLE -= 3; break;
	case 0xe1: arg = S; S += 2; CYCLE -= 3; break;
	//
	/* 1RR10001: Increment by 2 (Indirect) */
	case 0x91: arg = X; X += 2; arg = READW(arg); CYCLE -= 6; break;
	case 0xb1: arg = Y; Y += 2; arg = READW(arg); CYCLE -= 6; break;
	case 0xd1: arg = U; U += 2; arg = READW(arg); CYCLE -= 6; break;
	case 0xf1: arg = S; S += 2; arg = READW(arg); CYCLE -= 6; break;
	//
	/* 1RR00010: Decrement by 1 (Direct only) */
	case 0x82: X -= 1; arg = X; CYCLE -= 2; break;
	case 0xa2: Y -= 1; arg = Y; CYCLE -= 2; break;
	case 0xc2: U -= 1; arg = U; CYCLE -= 2; break;
	case 0xe2: S -= 1; arg = S; CYCLE -= 2; break;
	//
	/* 1RR00011: Decrement by 2 (Direct) */
	case 0x83: X -= 2; arg = X; CYCLE -= 3; break;
	case 0xa3: Y -= 2; arg = Y; CYCLE -= 3; break;
	case 0xc3: U -= 2; arg = U; CYCLE -= 3; break;
	case 0xe3: S -= 2; arg = S; CYCLE -= 3; break;
	//
	/* 1RR10011: Decrement by 2 (Indirect) */
	case 0x93: X -= 2; arg = X; arg = READW(arg); CYCLE -= 6; break;
	case 0xb3: Y -= 2; arg = Y; arg = READW(arg); CYCLE -= 6; break;
	case 0xd3: U -= 2; arg = U; arg = READW(arg); CYCLE -= 6; break;
	case 0xf3: S -= 2; arg = S; arg = READW(arg); CYCLE -= 6; break;
	//
	/************************************************************
	 * Accumulator Offset from Register (twos Complement Offset)
	 ************************************************************/
	/* 1RR00110: A Accumulator Offset (Direct) */
	case 0x86: arg = X + (char)A; CYCLE -= 1; break;
	case 0xa6: arg = Y + (char)A; CYCLE -= 1; break;
	case 0xc6: arg = U + (char)A; CYCLE -= 1; break;
	case 0xe6: arg = S + (char)A; CYCLE -= 1; break;
	//
	/* 1RR10110: A Accumulator Offset (Indirect) */
	case 0x96: arg = X + (char)A; arg = READW(arg); CYCLE -= 4; break;
	case 0xb6: arg = Y + (char)A; arg = READW(arg); CYCLE -= 4; break;
	case 0xd6: arg = U + (char)A; arg = READW(arg); CYCLE -= 4; break;
	case 0xf6: arg = S + (char)A; arg = READW(arg); CYCLE -= 4; break;
	//
	/* 1RR00101: B Accumulator Offset (Direct) */
	case 0x85: arg = X + (char)B; CYCLE -= 1; break;
	case 0xa5: arg = Y + (char)B; CYCLE -= 1; break;
	case 0xc5: arg = U + (char)B; CYCLE -= 1; break;
	case 0xe5: arg = S + (char)B; CYCLE -= 1; break;
	//
	/* 1RR10101: B Accumulator Offset (Indirect) */
	case 0x95: arg = X + (char)B; arg = READW(arg); CYCLE -= 4; break;
	case 0xb5: arg = Y + (char)B; arg = READW(arg); CYCLE -= 4; break;
	case 0xd5: arg = U + (char)B; arg = READW(arg); CYCLE -= 4; break;
	case 0xf5: arg = S + (char)B; arg = READW(arg); CYCLE -= 4; break;
	//
	/* 1RR00101: D Accumulator Offset (Direct) */
	case 0x8b: arg = X + D; CYCLE -= 4; break;
	case 0xab: arg = Y + D; CYCLE -= 4; break;
	case 0xcb: arg = U + D; CYCLE -= 4; break;
	case 0xeb: arg = S + D; CYCLE -= 4; break;
	//
	/* 1RR10101: D Accumulator Offset (Indirect) */
	case 0x9b: arg = X + D; arg = READW(arg); CYCLE -= 7; break;
	case 0xbb: arg = Y + D; arg = READW(arg); CYCLE -= 7; break;
	case 0xdb: arg = U + D; arg = READW(arg); CYCLE -= 7; break;
	case 0xfb: arg = S + D; arg = READW(arg); CYCLE -= 7; break;
	//
	/************************************************************
	 * Constant Offset from Program Counter
	 ************************************************************/
	/* 1XX01100: 8-Bit Offset (Direct) */
	case 0x8c:
	case 0xac:
	case 0xcc:
	case 0xec: FETCH(arg); arg = PC + (char)arg; CYCLE -= 1; break;
	//
	/* 1XX11100: 8-Bit Offset (Indirect) */
	case 0x9c:
	case 0xbc:
	case 0xdc:
	case 0xfc: FETCH(arg); arg = PC + (char)arg; arg = READW(arg); CYCLE -= 4; break;
	//
	/* 1XX01101: 8-Bit Offset (Direct) */
	case 0x8d:
	case 0xad:
	case 0xcd:
	case 0xed: FETCHW(arg); arg = PC + arg; CYCLE -= 5; break;
	//
	/* 1XX11101: 8-Bit Offset (Indirect) */
	case 0x9d:
	case 0xbd:
	case 0xdd:
	case 0xfd: FETCHW(arg); arg = PC + arg; arg = READW(arg); CYCLE -= 8; break;
	//
	/************************************************************
	 * Extended Indirect
	 ************************************************************/
	/* 10011111: 16-Bit Address (Indirect only) */
	case 0x9f: FETCHW(arg); arg = READW(arg); CYCLE -= 5; break;
	//
	/************************************************************
	 *
	 ************************************************************/
	default:
#ifndef PIECE
		DIE();
#endif /*PIECE*/
		arg = 0; /* x} */
		break;
	}

	return arg;
}
#endif	/************************************************************/

/****************************************************************************
 *	
 ****************************************************************************/

