;
;	framm68a.s
;
;	P/ECE M6800 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Sun Feb 01 06:23:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
#include "clipm68a.h"
#ifdef M6800_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	M6800\
;
/*===== WX^ =====*/
#define CC	 0
#define D	 2
#define X	 4
#define S	 6
#define PC	 8
/*=====  =====*/
#define PENDING	10
#define WAIT	11
#define CYCLE	12
/*===== O֐ =====*/
#define READ	16
#define WRITE	20

;
;	16rbgWX^̏/8rbgANZX
;	G~[VzXg(S1C33,Pentium,etc)Ȃ̂ŁALittleEndianłB
;
#define A	 3	; HI(D), LittleEndian
#define B	 2	; LO(D), LittleEndian

;
;	S1C33=>M6800tOϊ
;
;	* ϊ\͕svłB
;	  S1C33M6800{N,Z,V,C}tO͕тĂ̂ŁA
;	  ̂悤Ȏ菇ŕϊł܂B
;
;	S1C33̃tO:	  MD-ICVZN
;				      ||||
;				      VVVV
;	M6800̃tO:	  11HINZVC
;
;	ld.w %r10, %psr		; MD-ICVZN
;	xsll %r10, 4		; CVZN0000
;	mirror %r10, %r10	; 0000NZVC
;

;****************************************************************************
;	
;****************************************************************************

	.global m6800_run
m6800_run:
	pushn %r3
	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; m6800
	xld.w %r3, [%r0+READ]		; m6800->read
	xld.w [%r0+CYCLE], %r13		; CYCLE
	xcmp %r13, 0			; if(CYCLE <= 0) break
	xjrle m6800_run_exit
	;
m6800_run_L10:
	xld.ub %r10, [%r0+WAIT]		; if(WAIT) break
	xld.uh %r1, [%r0+PC]		; PC *anti-interlock*
	xcmp %r10, 0
	xjrne m6800_run_exit
	;
	ld.uh %r13, %r1			; code = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, m6800_op_table	; op = &m6800_op_table[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.ub %r10, [%r2+4]		; switch(op->addr)
	xld.w %r11, m6800_run_table	; *anti-interlock*
	xsll %r10, 2
	add %r10, %r11
	xld.w %r10, [%r10]
	xadd %r1, %r1, 1		; *anti-interlock*
	jp %r10
	;
m6800_run_immediate1:
m6800_run_direct:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub %r14, %r10		; arg = arg1
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d m6800_run_exec
	add %r1, 1			; *delay*
	;
m6800_run_indexed:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.uh %r14, [%r0+X]		; arg = X + arg1
	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.uh %r14, %r14
	;
	xjp.d m6800_run_exec
	add %r1, 1			; *delay*
	;
m6800_run_immediate2:
m6800_run_extended:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1
	;
	xld.b [%sp+1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	xsll %r14, 8			; arg = arg1 << 8 | arg2
	or %r14, %r10
	;
	xjp.d m6800_run_exec
	add %r1, 1			; *delay*
	;
m6800_run_relative:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6800->read(m6800, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1
	;
	ld.b %r14, %r10			; arg = PC + (char)arg1
	add %r14, %r1
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	;** fall thru **
	;
m6800_run_inherent:
m6800_run_exec:
	xld.w %r10, [%r2+0]		; op->proc(arg)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11			; !INTERLOCK!
	xld.w [%r0+CYCLE], %r10
	xjrgt m6800_run_L10		; if(CYCLE <= 0) break
m6800_run_exit:
	;
	xadd %sp, %sp, 4
	popn %r3
	ret
	;
	.align 2
m6800_run_table:
	;===== operand bytes=0 =====
	.word m6800_run_inherent	; 0
	;===== operand bytes=1 =====
	.word m6800_run_immediate1	; 1
	.word m6800_run_direct		; 2
	.word m6800_run_indexed		; 3
	.word m6800_run_relative	; 4
	;===== operand bytes=2 =====
	.word m6800_run_immediate2	; 5
	.word m6800_run_extended	; 6
	.align 1

;****************************************************************************
;	
;****************************************************************************

	.global m6800_ADD
m6800_ADD:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	add %r10, %r4			; %r10[31:24] = a + b
	ld.w %r5, %psr			; %r5 = %psr(MD-ICVZN)
	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	xand %r11, %r11, ~0x2f		; %r11 = CC(110I0000)
	or %r11, %r5			; %r11 = CC(110INZVC)
	;
	xand %r13, %r13, 0xf		; %r13 = (a & 0xf) + (b & 0xf)
	xand %r14, %r14, 0xf
	add %r13, %r14
	xand %r13, %r13, 0x10		; %r13 = CC(H)
	xsll %r13, 1
	or %r11, %r13			; %r11 = CC(11HINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a + b *delay*

	.global m6800_ADC
m6800_ADC:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	xand %r15, %r11, 1		; %r15 = CC(C)
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	add %r10, %r4			; %r10[31:24] = a + b
	ld.w %r5, %psr			; %r5 = %psr(1)
	;
	swap %r4, %r15			; %r4[31:24] = c
	add %r10, %r4			; %r10[31:24] = a + b + c
	ld.w %r6, %psr			; %r6 = %psr(2)
	;
	xand %r5, %r5, 0xc		; %r5 = %psr(C1,V1)
	xand %r7, %r6, 4		; %r7 = %psr(V2)
	xor %r5, %r7			; %r5 = %psr(C1,V1^V2)
	xand %r6, %r6, 0xb		; %r6 = %psr(C2,Z2,N2)
	or %r5, %r6			; %r5 = %psr(C1|C2,V1^V2,Z2,N2)
	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	xand %r11, %r11, ~0x2f		; %r11 = CC(110I0000)
	or %r11, %r5			; %r11 = CC(110INZVC)
	;
	xand %r13, %r13, 0xf		; %r13 = (a & 0xf) + (b & 0xf)
	xand %r14, %r14, 0xf
	add %r13, %r14
	add %r13, %r15			; %r13 = (a & 0xf) + (b & 0xf) + c
	xand %r13, %r13, 0x10		; %r13 = CC(H)
	xsll %r13, 1
	or %r11, %r13			; %r11 = CC(11HINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a + b + c *delay*

	.global m6800_SUB
m6800_SUB:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	sub %r10, %r4			; %r10[31:24] = a - b
	ld.w %r5, %psr			; %r5 = %psr(MD-ICVZN)
	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000)
	or %r11, %r5			; %r11 = CC(11HINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a - b *delay*

	.global m6800_SBC
m6800_SBC:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	xand %r15, %r11, 1		; %r15 = CC(C)
	;
	swap %r10, %r13			; %r10[31:24] = a
	swap %r4, %r14			; %r4[31:24] = b
	sub %r10, %r4			; %r10[31:24] = a - b
	ld.w %r5, %psr			; %r5 = %psr(1)
	;
	swap %r4, %r15			; %r4[31:24] = c
	sub %r10, %r4			; %r10[31:24] = a - b - c
	ld.w %r6, %psr			; %r6 = %psr(2)
	;
	xand %r5, %r5, 0xc		; %r5 = %psr(C1,V1)
	xand %r7, %r6, 4		; %r7 = %psr(V2)
	xor %r5, %r7			; %r5 = %psr(C1,V1^V2)
	xand %r6, %r6, 0xb		; %r6 = %psr(C2,Z2,N2)
	or %r5, %r6			; %r5 = %psr(C1|C2,V1^V2,Z2,N2)
	xsll %r5, 4			; %r5 = %psr(CVZN0000)
	mirror %r5, %r5			; %r5 = CC(0000NZVC)
	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000)
	or %r11, %r5			; %r11 = CC(11HINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r10			; %r10 = a - b - c *delay*

	.global m6800_ADDW
m6800_ADDW:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xsll %r13, 16			; %r13[31:16] = a
	xsll %r14, 16			; %r14[31:16] = b
	add %r13, %r14			; %r13[31:16] = a + b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	xld.b [%r12+CC], %r11
	;
	xsrl %r13, 16			; %r13 = a + b
	ret.d
	ld.w %r10, %r13			; %r10 = a + b *delay*

	.global m6800_SUBW
m6800_SUBW:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xsll %r13, 16			; %r13[31:16] = a
	xsll %r14, 16			; %r14[31:16] = b
	sub %r13, %r14			; %r13[31:16] = a - b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	xld.b [%r12+CC], %r11
	;
	xsrl %r13, 16			; %r13 = a - b
	ret.d
	ld.w %r10, %r13			; %r10 = a - b *delay*

	.global m6800_AND
m6800_AND:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	and %r13, %r14			; %r13 = a & b
	xrr %r13, 8			; %r13[31:24] = a & b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a & b *delay*

	.global m6800_ORA
m6800_ORA:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	or %r13, %r14			; %r13 = a | b
	xrr %r13, 8			; %r13[31:24] = a | b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a | b *delay*

	.global m6800_EOR
m6800_EOR:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xor %r13, %r14			; %r13 = a ^ b
	xrr %r13, 8			; %r13[31:24] = a ^ b
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	mirror %r10, %r10		; %r10 = CC(NZ000000)
	xsrl %r10, 4			; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a ^ b *delay*

	.global m6800_INC
m6800_INC:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	swap %r13, %r13			; %r13[31:24] = a
	xadd %r13, %r13, 1<<24		; %r13[31:24] = a + 1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 7		; %r10 = %psr(00000VZN)
	xsll %r10, 4			; %r10 = %psr(0VZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZV0)
	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a + 1 *delay*

	.global m6800_DEC
m6800_DEC:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	swap %r13, %r13			; %r13[31:24] = a
	xsub %r13, %r13, 1<<24		; %r13[31:24] = a - 1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 7		; %r10 = %psr(00000VZN)
	xsll %r10, 4			; %r10 = %psr(0VZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZV0)
	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = a - 1 *delay*

	.global m6800_COM
m6800_COM:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xxor %r13, %r13, 0xff		; %r13 = ~a
	xrr %r13, 8			; %r13[31:24] = ~a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZ00)
	xoor %r11, %r11, 1		; %r11 = CC(11HINZ01)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = ~a *delay*

	; [1]
	; ʂ0̏ꍇ̂CC(Z)=1,CC(C)=1AȊO͑SCC(Z)=0,CC(C)=0ƂdlłB
	; ʂ0ɂȂ̂́Aa=0̏ꍇłB
	; a=0̏ꍇ̂%psr(C)=0ƂȂAȊO͑S%psr(C)=1ƂȂ܂B
	; Ȃ킿 CC(C)=!%psr(C) łB
	; CC(Z)ɂ%psr(Z)̂܂܎g܂B
	.global m6800_NEG
m6800_NEG:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	swap %r10, %r13			; %r10[31:24] = a
	xld.w %r13, 0			; %r13[31:24] = 0
	sub %r13, %r10			; %r13[31:24] = -a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xxor %r10, %r10, 8		; %r10 = %psr(MD-ICVZN) [1]
	xsll %r10, 4			; %r10 = %psr(CVZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZVC)
	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZVC)
	xld.b [%r12+CC], %r11
	;
	ret.d
	swap %r10, %r13			; %r10 = -a *delay*

	.global m6800_TST
m6800_TST:
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xrr %r13, 8			; %r13[31:24] = a
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000)
	or %r11, %r10			; %r11 = CC(11HINZ00)
	xld.b [%r12+CC], %r11
	;
	ret

;****************************************************************************
;	$1($2)
;****************************************************************************

#macro S1IS2I $1, $2
	xld.ub %r13, [%r12+$2]
	xjp m6800_$1
#endm

	.global m6800op_TSTA_INHERENT
m6800op_TSTA_INHERENT:
	S1IS2I TST, A
	.global m6800op_TSTB_INHERENT
m6800op_TSTB_INHERENT:
	S1IS2I TST, B

;****************************************************************************
;	$1(READ(arg))
;****************************************************************************

#macro S1IREADIargII $1
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	xcall.d m6800_$1
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
#endm

	.global m6800op_TST_ADDRESS
m6800op_TST_ADDRESS:
	S1IREADIargII TST

;****************************************************************************
;	$1($3,$2)
;****************************************************************************

#macro S1IS3_S2I $1, $2, $3
	xld.ub %r13, [%r12+$3]
	xld.ub %r14, [%r12+$2]
	xjp m6800_$1
#endm

	.global m6800op_CBA_INHERENT
m6800op_CBA_INHERENT:
	S1IS3_S2I SUB, B, A

;****************************************************************************
;	$1($2,arg)
;****************************************************************************

#macro S1IS2_argI $1, $2
	xld.ub %r13, [%r12+$2]
	xjp m6800_$1
#endm

	.global m6800op_CMPA_DATA
m6800op_CMPA_DATA:
	S1IS2_argI SUB, A
	.global m6800op_CMPB_DATA
m6800op_CMPB_DATA:
	S1IS2_argI SUB, B
	.global m6800op_BITA_DATA
m6800op_BITA_DATA:
	S1IS2_argI AND, A
	.global m6800op_BITB_DATA
m6800op_BITB_DATA:
	S1IS2_argI AND, B

;****************************************************************************
;	$1($2,READ(arg))
;****************************************************************************

#macro S1IS2_READIargII $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	xld.ub %r13, [%r0+$2]
	xcall.d m6800_$1		; *delay*
	ld.w %r12, %r0
	;
	popn %r0
	ret
#endm

	.global m6800op_CMPA_ADDRESS
m6800op_CMPA_ADDRESS:
	S1IS2_READIargII SUB, A
	.global m6800op_CMPB_ADDRESS
m6800op_CMPB_ADDRESS:
	S1IS2_READIargII SUB, B
	.global m6800op_BITA_ADDRESS
m6800op_BITA_ADDRESS:
	S1IS2_READIargII AND, A
	.global m6800op_BITB_ADDRESS
m6800op_BITB_ADDRESS:
	S1IS2_READIargII AND, B

;****************************************************************************
;	$2=$1($2)
;****************************************************************************

#macro S2_S1I$2I $1, $2
	pushn %r0
	;
	xld.ub %r13, [%r12+$2]
	xcall.d m6800_$1
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

	.global m6800op_INCA_INHERENT
m6800op_INCA_INHERENT:
	S2_S1I$2I INC, A
	.global m6800op_INCB_INHERENT
m6800op_INCB_INHERENT:
	S2_S1I$2I INC, B
	.global m6800op_DECA_INHERENT
m6800op_DECA_INHERENT:
	S2_S1I$2I DEC, A
	.global m6800op_DECB_INHERENT
m6800op_DECB_INHERENT:
	S2_S1I$2I DEC, B
	.global m6800op_COMA_INHERENT
m6800op_COMA_INHERENT:
	S2_S1I$2I COM, A
	.global m6800op_COMB_INHERENT
m6800op_COMB_INHERENT:
	S2_S1I$2I COM, B
	.global m6800op_NEGA_INHERENT
m6800op_NEGA_INHERENT:
	S2_S1I$2I NEG, A
	.global m6800op_NEGB_INHERENT
m6800op_NEGB_INHERENT:
	S2_S1I$2I NEG, B
	.global m6800op_ROLA_INHERENT
m6800op_ROLA_INHERENT:
	S2_S1I$2I ROL, A
	.global m6800op_ROLB_INHERENT
m6800op_ROLB_INHERENT:
	S2_S1I$2I ROL, B
	.global m6800op_RORA_INHERENT
m6800op_RORA_INHERENT:
	S2_S1I$2I ROR, A
	.global m6800op_RORB_INHERENT
m6800op_RORB_INHERENT:
	S2_S1I$2I ROR, B
	.global m6800op_ASLA_INHERENT
m6800op_ASLA_INHERENT:
	S2_S1I$2I ASL, A
	.global m6800op_ASLB_INHERENT
m6800op_ASLB_INHERENT:
	S2_S1I$2I ASL, B
	.global m6800op_ASRA_INHERENT
m6800op_ASRA_INHERENT:
	S2_S1I$2I ASR, A
	.global m6800op_ASRB_INHERENT
m6800op_ASRB_INHERENT:
	S2_S1I$2I ASR, B
	.global m6800op_LSRA_INHERENT
m6800op_LSRA_INHERENT:
	S2_S1I$2I LSR, A
	.global m6800op_LSRB_INHERENT
m6800op_LSRB_INHERENT:
	S2_S1I$2I LSR, B

;****************************************************************************
;	$2=$1($2,arg)
;****************************************************************************

#macro S2_S1IS2_argI $1, $2
	pushn %r0
	;
	xld.ub %r13, [%r12+$2]
	xcall.d m6800_$1
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

	.global m6800op_ADDA_DATA
m6800op_ADDA_DATA:
	S2_S1IS2_argI ADD, A
	.global m6800op_ADDB_DATA
m6800op_ADDB_DATA:
	S2_S1IS2_argI ADD, B
	.global m6800op_ADCA_DATA
m6800op_ADCA_DATA:
	S2_S1IS2_argI ADC, A
	.global m6800op_ADCB_DATA
m6800op_ADCB_DATA:
	S2_S1IS2_argI ADC, B
	.global m6800op_SUBA_DATA
m6800op_SUBA_DATA:
	S2_S1IS2_argI SUB, A
	.global m6800op_SUBB_DATA
m6800op_SUBB_DATA:
	S2_S1IS2_argI SUB, B
	.global m6800op_SBCA_DATA
m6800op_SBCA_DATA:
	S2_S1IS2_argI SBC, A
	.global m6800op_SBCB_DATA
m6800op_SBCB_DATA:
	S2_S1IS2_argI SBC, B
	.global m6800op_ANDA_DATA
m6800op_ANDA_DATA:
	S2_S1IS2_argI AND, A
	.global m6800op_ANDB_DATA
m6800op_ANDB_DATA:
	S2_S1IS2_argI AND, B
	.global m6800op_ORAA_DATA
m6800op_ORAA_DATA:
	S2_S1IS2_argI ORA, A
	.global m6800op_ORAB_DATA
m6800op_ORAB_DATA:
	S2_S1IS2_argI ORA, B
	.global m6800op_EORA_DATA
m6800op_EORA_DATA:
	S2_S1IS2_argI EOR, A
	.global m6800op_EORB_DATA
m6800op_EORB_DATA:
	S2_S1IS2_argI EOR, B

;****************************************************************************
;	$3=$1($3,$2)
;****************************************************************************

#macro S3_S1IS3_S2I $1, $2, $3
	pushn %r0
	;
	xld.ub %r13, [%r12+$3]
	xld.ub %r14, [%r12+$2]
	xcall.d m6800_$1
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$3], %r10
	;
	popn %r0
	ret
#endm

	.global m6800op_ABA_INHERENT
m6800op_ABA_INHERENT:
	S3_S1IS3_S2I ADD, B, A
	.global m6800op_SBA_INHERENT
m6800op_SBA_INHERENT:
	S3_S1IS3_S2I SUB, B, A

;****************************************************************************
;	$2=$1($2,READ(arg))
;****************************************************************************

#macro S2_S1IS2_READIargII $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	xld.ub %r13, [%r0+$2]
	xcall.d m6800_$1		; *delay*
	ld.w %r12, %r0
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

	.global m6800op_ADDA_ADDRESS
m6800op_ADDA_ADDRESS:
	S2_S1IS2_READIargII ADD, A
	.global m6800op_ADDB_ADDRESS
m6800op_ADDB_ADDRESS:
	S2_S1IS2_READIargII ADD, B
	.global m6800op_ADCA_ADDRESS
m6800op_ADCA_ADDRESS:
	S2_S1IS2_READIargII ADC, A
	.global m6800op_ADCB_ADDRESS
m6800op_ADCB_ADDRESS:
	S2_S1IS2_READIargII ADC, B
	.global m6800op_SUBA_ADDRESS
m6800op_SUBA_ADDRESS:
	S2_S1IS2_READIargII SUB, A
	.global m6800op_SUBB_ADDRESS
m6800op_SUBB_ADDRESS:
	S2_S1IS2_READIargII SUB, B
	.global m6800op_SBCA_ADDRESS
m6800op_SBCA_ADDRESS:
	S2_S1IS2_READIargII SBC, A
	.global m6800op_SBCB_ADDRESS
m6800op_SBCB_ADDRESS:
	S2_S1IS2_READIargII SBC, B
	.global m6800op_ANDA_ADDRESS
m6800op_ANDA_ADDRESS:
	S2_S1IS2_READIargII AND, A
	.global m6800op_ANDB_ADDRESS
m6800op_ANDB_ADDRESS:
	S2_S1IS2_READIargII AND, B
	.global m6800op_ORAA_ADDRESS
m6800op_ORAA_ADDRESS:
	S2_S1IS2_READIargII ORA, A
	.global m6800op_ORAB_ADDRESS
m6800op_ORAB_ADDRESS:
	S2_S1IS2_READIargII ORA, B
	.global m6800op_EORA_ADDRESS
m6800op_EORA_ADDRESS:
	S2_S1IS2_READIargII EOR, A
	.global m6800op_EORB_ADDRESS
m6800op_EORB_ADDRESS:
	S2_S1IS2_READIargII EOR, B

;****************************************************************************
;	WRITE(arg,$1(READ(arg)))
;****************************************************************************

#macro WRITEIarg_S1IREADIargIII $1
	pushn %r1
	ld.w %r1, %r14
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	xcall.d m6800_$1
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	xld.w %r10, [%r0+WRITE]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
#endm

	.global m6800op_INC_ADDRESS
m6800op_INC_ADDRESS:
	WRITEIarg_S1IREADIargIII INC
	.global m6800op_DEC_ADDRESS
m6800op_DEC_ADDRESS:
	WRITEIarg_S1IREADIargIII DEC
	.global m6800op_COM_ADDRESS
m6800op_COM_ADDRESS:
	WRITEIarg_S1IREADIargIII COM
	.global m6800op_NEG_ADDRESS
m6800op_NEG_ADDRESS:
	WRITEIarg_S1IREADIargIII NEG
	.global m6800op_ROL_ADDRESS
m6800op_ROL_ADDRESS:
	WRITEIarg_S1IREADIargIII ROL
	.global m6800op_ROR_ADDRESS
m6800op_ROR_ADDRESS:
	WRITEIarg_S1IREADIargIII ROR
	.global m6800op_ASL_ADDRESS
m6800op_ASL_ADDRESS:
	WRITEIarg_S1IREADIargIII ASL
	.global m6800op_ASR_ADDRESS
m6800op_ASR_ADDRESS:
	WRITEIarg_S1IREADIargIII ASR
	.global m6800op_LSR_ADDRESS
m6800op_LSR_ADDRESS:
	WRITEIarg_S1IREADIargIII LSR

;****************************************************************************
;	Others
;****************************************************************************

#macro Trr_INHERENT $1, $2
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xld.ub %r10, [%r12+$1]		; $2 = $1
	xld.b [%r12+$2], %r10
	;
	xrr %r10, 8			; %r10[31:24] = $2
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret
#endm

	.global m6800op_TAB_INHERENT
m6800op_TAB_INHERENT:
	Trr_INHERENT A, B
	.global m6800op_TBA_INHERENT
m6800op_TBA_INHERENT:
	Trr_INHERENT B, A

;****************************************************************************

#macro CLRr_INHERENT $1
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xld.b [%r12+$1], %r8		; $1 = 0 *anti-interlock*
	;
	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000)
	xoor %r11, %r11, 4		; %r11 = CC(11HI0Z00)
	xld.b [%r12+CC], %r11
	;
	ret
#endm

	.global m6800op_CLRA_INHERENT
m6800op_CLRA_INHERENT:
	CLRr_INHERENT A
	.global m6800op_CLRB_INHERENT
m6800op_CLRB_INHERENT:
	CLRr_INHERENT B

;****************************************************************************

#macro CLR_ADDRESS
	pushn %r0
	;
	xld.w %r10, [%r12+WRITE]	; WRITE(arg, 0)
	ld.w %r13, %r14
	xld.w %r14, 0
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.ub %r11, [%r0+CC]		; %r11 = CC
	xand %r11, %r11, ~0xf		; %r11 = CC(11HI0000) !INTERLOCK!
	xoor %r11, %r11, 4		; %r11 = CC(11HI0Z00)
	xld.b [%r0+CC], %r11
	;
	popn %r0
	ret
#endm

	.global m6800op_CLR_ADDRESS
m6800op_CLR_ADDRESS:
	CLR_ADDRESS

;****************************************************************************

#macro STAr_ADDRESS $1
	pushn %r0
	;
	xld.w %r10, [%r12+WRITE]	; WRITE(arg, $1)
	ld.w %r13, %r14
	xld.ub %r14, [%r12+$1]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.ub %r10, [%r0+$1]		; %r10 = $1
	xld.ub %r11, [%r0+CC]		; %r11 = CC *anti-interlock*
	xrr %r10, 8			; %r10[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	xld.b [%r0+CC], %r11
	;
	popn %r0
	ret
#endm

	.global m6800op_STAA_ADDRESS
m6800op_STAA_ADDRESS:
	STAr_ADDRESS A
	.global m6800op_STAB_ADDRESS
m6800op_STAB_ADDRESS:
	STAr_ADDRESS B

;****************************************************************************

#macro LDAr_DATA $1
	xld.ub %r11, [%r12+CC]		; %r11 = CC
	;
	xld.b [%r12+$1], %r14		; $1 = arg
	;
	xrr %r14, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	xld.b [%r12+CC], %r11
	;
	ret
#endm

	.global m6800op_LDAA_DATA
m6800op_LDAA_DATA:
	LDAr_DATA A
	.global m6800op_LDAB_DATA
m6800op_LDAB_DATA:
	LDAr_DATA B

;****************************************************************************

#macro LDAr_ADDRESS $1
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.b [%r0+$1], %r10		; $1 = READ(arg)
	;
	xld.ub %r11, [%r0+CC]		; %r11 = CC
	;
	xrr %r10, 8			; %r14[31:24] = $1
	ld.w %r10, %psr			; %r10 = %psr(MD-ICVZN)
	xand %r10, %r10, 3		; %r10 = %psr(000000ZN)
	xsll %r10, 4			; %r10 = %psr(00ZN0000)
	mirror %r10, %r10		; %r10 = CC(0000NZ00)
	xand %r11, %r11, ~0xe		; %r11 = CC(11HI000C)
	or %r11, %r10			; %r11 = CC(11HINZ0C)
	xld.b [%r0+CC], %r11
	;
	popn %r0
	ret
#endm

	.global m6800op_LDAA_ADDRESS
m6800op_LDAA_ADDRESS:
	LDAr_ADDRESS A
	.global m6800op_LDAB_ADDRESS
m6800op_LDAB_ADDRESS:
	LDAr_ADDRESS B

;****************************************************************************

#macro PSHr_INHERENT $1
	xld.w %r10, [%r12+WRITE]
	xld.uh %r13, [%r12+S]
	xld.ub %r14, [%r12+$1]		; *anti-interlock*
	xsub %r11, %r13, 1
	xld.h [%r12+S], %r11
	call %r10
	ret
#endm

	.global m6800op_PSHA_INHERENT
m6800op_PSHA_INHERENT:
	PSHr_INHERENT A
	.global m6800op_PSHB_INHERENT
m6800op_PSHB_INHERENT:
	PSHr_INHERENT B

;****************************************************************************

#macro PULr_INHERENT $1
	pushn %r0
	;
	xld.uh %r13, [%r12+S]
	xld.w %r10, [%r12+READ]		; *anti-interlock*
	xadd %r13, %r13, 1
	xld.h [%r12+S], %r13
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$1], %r10
	;
	popn %r0
	ret
#endm

	.global m6800op_PULA_INHERENT
m6800op_PULA_INHERENT:
	PULr_INHERENT A
	.global m6800op_PULB_INHERENT
m6800op_PULB_INHERENT:
	PULr_INHERENT B

;****************************************************************************
;	JUMP AND BRANCH
;****************************************************************************

	.global m6800op_JMP_ADDRESS
	.global m6800op_BRA_ADDRESS
m6800op_JMP_ADDRESS:
m6800op_BRA_ADDRESS:
	xld.h [%r12+PC], %r14
	ret

;****************************************************************************

	.global m6800op_JSR_ADDRESS
	.global m6800op_BSR_ADDRESS
m6800op_BSR_ADDRESS:
m6800op_JSR_ADDRESS:
	pushn %r2
	;
	xld.uh %r1, [%r12+S]		; S
	xld.uh %r2, [%r12+PC]		; PC
	;
	xld.h [%r12+PC], %r14		; PC <= arg
	;
	xld.w %r10, [%r12+WRITE]	; PUSH(PCL)
	ld.uh %r13, %r1
	ld.ub %r14, %r2
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xsub %r1, %r1, 1		; S--
	;
	xld.w %r10, [%r0+WRITE]		; PUSH(PCH)
	ld.uh %r13, %r1
	ld.uh %r14, %r2
	xsrl %r14, 8
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xsub %r1, %r1, 1		; S--
	xld.h [%r0+S], %r1
	;
	popn %r2
	ret

;****************************************************************************

	.global m6800op_RTS_INHERENT
m6800op_RTS_INHERENT:
	pushn %r2
	;
	xld.uh %r1, [%r12+S]		; S
	;
	xld.w %r10, [%r12+READ]		; POP(PCH)
	xadd %r1, %r1, 1		; S++
	ld.w %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r2, %r10			; (save PCH)
	;
	xld.w %r10, [%r0+READ]		; POP(PCL)
	xadd %r1, %r1, 1		; S++
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xsll %r2, 8			; PC <= PCH << 8 | PCL
	or %r2, %r10
	xld.h [%r0+PC], %r2
	;
	xld.h [%r0+S], %r1		; S
	;
	popn %r2
	ret

;****************************************************************************

/* Branch if Flag is Clear */
#macro Bfc_ADDRESS $1
	xbtst [%r12+CC], $1
	xjrne $$1			; if(flag is 1) no-jump
	xld.h [%r12+PC], %r14
$$1:
	ret
#endm

	.global m6800op_BCC_ADDRESS
m6800op_BCC_ADDRESS:
	Bfc_ADDRESS 0
	.global m6800op_BVC_ADDRESS
m6800op_BVC_ADDRESS:
	Bfc_ADDRESS 1
	.global m6800op_BNE_ADDRESS
m6800op_BNE_ADDRESS:
	Bfc_ADDRESS 2
	.global m6800op_BPL_ADDRESS
m6800op_BPL_ADDRESS:
	Bfc_ADDRESS 3

;****************************************************************************

/* Branch if Flag is Set */
#macro Bfs_ADDRESS $1
	xbtst [%r12+CC], $1
	xjreq $$1			; if(flag is 0) no-jump
	xld.h [%r12+PC], %r14
$$1:
	ret
#endm

	.global m6800op_BCS_ADDRESS
m6800op_BCS_ADDRESS:
	Bfs_ADDRESS 0
	.global m6800op_BVS_ADDRESS
m6800op_BVS_ADDRESS:
	Bfs_ADDRESS 1
	.global m6800op_BEQ_ADDRESS
m6800op_BEQ_ADDRESS:
	Bfs_ADDRESS 2
	.global m6800op_BMI_ADDRESS
m6800op_BMI_ADDRESS:
	Bfs_ADDRESS 3

;****************************************************************************

	.global m6800op_BGE_ADDRESS
m6800op_BGE_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = 11HINZVC
	ld.w %r11, %r10			; %r11 = 11HINZVC
	xrr %r11, 2			; %r11 = 0011HINZ
	xor %r10, %r11			;              +- N^V
	xand %r10, %r10, 2
	xjrne m6800op_BGE_ADDRESS_L10	; if(N^V is 1) no-jump
	xld.h [%r12+PC], %r14
m6800op_BGE_ADDRESS_L10:
	ret

	.global m6800op_BLT_ADDRESS
m6800op_BLT_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = 11HINZVC
	ld.w %r11, %r10			; %r11 = 11HINZVC
	xrr %r11, 2			; %r11 = 0011HINZ
	xor %r10, %r11			;              +- N^V
	xand %r10, %r10, 2
	xjreq m6800op_BLT_ADDRESS_L10	; if(N^V is 0) no-jump
	xld.h [%r12+PC], %r14
m6800op_BLT_ADDRESS_L10:
	ret

;
	.global m6800op_BGT_ADDRESS
m6800op_BGT_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = 11HINZVC
	ld.w %r11, %r10			; %r11 = 11HINZVC
	xrr %r11, 2			; %r11 = 0011HINZ
	xor %r10, %r11			;              +- N^V
	xrl %r11, 1			; %r11 = 011HINZV
	or %r10, %r11			;              +- (N^V)|Z
	xand %r10, %r10, 2
	xjrne m6800op_BGT_ADDRESS_L10	; if((N^V)|Z is 1) no-jump
	xld.h [%r12+PC], %r14
m6800op_BGT_ADDRESS_L10:
	ret

;
	.global m6800op_BLE_ADDRESS
m6800op_BLE_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = 11HINZVC
	ld.w %r11, %r10			; %r11 = 11HINZVC
	xrr %r11, 2			; %r11 = 0011HINZ
	xor %r10, %r11			;              +- N^V
	xrl %r11, 1			; %r11 = 011HINZV
	or %r10, %r11			;              +- (N^V)|Z
	xand %r10, %r10, 2
	xjreq m6800op_BLE_ADDRESS_L10	; if((N^V)|Z is 0) no-jump
	xld.h [%r12+PC], %r14
m6800op_BLE_ADDRESS_L10:
	ret

;
	.global m6800op_BHI_ADDRESS
m6800op_BHI_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = 11HINZVC
	xand %r10, %r10, 5		; %r10 = 00000Z0C
	xjrne m6800op_BHI_ADDRESS_L10	; if(Z|C is 1) no-jump
	xld.h [%r12+PC], %r14
m6800op_BHI_ADDRESS_L10:
	ret

;
	.global m6800op_BLS_ADDRESS
m6800op_BLS_ADDRESS:
	xld.ub %r10, [%r12+CC]		; %r10 = 11HINZVC
	xand %r10, %r10, 5		; %r10 = 00000Z0C
	xjreq m6800op_BLS_ADDRESS_L10	; if(Z|C is 0) no-jump
	xld.h [%r12+PC], %r14
m6800op_BLS_ADDRESS_L10:
	ret

;****************************************************************************
;
;****************************************************************************

#endif /*M6800_ASM*/
