;	
;	framm65a.s
;
;	P/ECE MOS6502 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2003 Naoyuki Sawa
;
;	* Sat Dec 08 06:00:00 JST 2003 Naoyuki Sawa
;	- 쐬JnB
;	* Wed Mar 16 07:13:00 JST 2005 Naoyuki Sawa
;	- m6502_ruńACłAsmł̑ɂāARgǉB
;	  Cł̃vO͕ύXς݁AAsmł̃vO͖ύXłB
;	  2005/03/16݁ACłAsmłƂŁATCNJEg̓삪قȂĂ܂B
;
#include "clipm65a.h"
#ifdef M6502_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	M6502\
;
/*===== WX^ =====*/
#define A	 0
#define X	 1
#define Y	 2
#define PC	 4
#define SP	 6
#define PSR	 7
/*=====  =====*/
#define CYCLE	 8
#define WAIT	12
/*===== O֐ =====*/
#define READ	16
#define WRITE	20

;
;	C33=>M6502tOϊ\
;
				; C33(C,V,Z,N) => M6502(S,Z,V,C)
				; ====C33====     ===M6502===
m6502_FLAG_CONV:		; ----CVZN        NV----ZC
	.byte	0x00		; 00000000 00     00000000 00
	.byte	0x80		; 00000001 01     10000000 80
	.byte	0x02		; 00000010 02     00000010 02
	.byte	0x82		; 00000011 03     10000010 82
	.byte	0x40		; 00000100 04     01000000 40
	.byte	0xc0		; 00000101 05     11000000 c0
	.byte	0x42		; 00000110 06     01000010 42
	.byte	0xc2		; 00000111 07     11000010 c2
	.byte	0x01		; 00001000 08     00000001 01
	.byte	0x81		; 00001001 09     10000001 81
	.byte	0x03		; 00001010 0a     00000011 03
	.byte	0x83		; 00001011 0b     10000011 83
	.byte	0x41		; 00001100 0c     01000001 41
	.byte	0xc1		; 00001101 0d     11000001 c1
	.byte	0x43		; 00001110 0e     01000011 43
	.byte	0xc3		; 00001111 0f     11000011 c3

;****************************************************************************
;
;****************************************************************************

	.global m6502_run
m6502_run:
	pushn %r3
	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; m6502
	xld.w %r3, [%r0+READ]		; m6502->read
	xld.w [%r0+CYCLE], %r13		; CYCLE
	xcmp %r13, 0			; if(CYCLE <= 0) break
	xjrle m6502_run_exit
	;
m6502_run_L10:
	xld.ub %r10, [%r0+WAIT]		; if(WAIT) break
	xld.uh %r1, [%r0+PC]		; PC *anti-interlock*
	xcmp %r10, 0
	xjrne m6502_run_exit
	;
	ld.uh %r13, %r1			; code = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, m6502_op_table	; op = &m6502_op_table[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.ub %r10, [%r2+4]		; switch(op->mode)
	xld.w %r11, m6502_run_table	; *anti-interlock*
	xsll %r10, 2
	add %r10, %r11
	;{{==================================================================
	;S1C33RÃoO!?
	;RAMɒux򖽗߂C^[bNƁAxXbgsȂ݂łB
	;2003/12/19ǋL
	;C^[bN͊֌WȂ݂łB
	;  RAMɒuujp.d %rbv̒OɃANZX߂ƁAxXbgsȂ悤łB
	;  ÕANZX߂F
	;	Eǂݍ݂łĂ݂łĂA(uld.w %rd,[%rb]v/uld.w [%rb],%rsv/etc...)
	;	Eext߂𔺂ĂĂȂĂA(uld.w [%rb],%rsv/uld.w [%rb+disp],%rsv/etc...)
	;	EANZX̃TCYłA(uld.w [%rb],%rsv/uld.h/uh [%rb],%rsv/uld.b/ub [%rb],%rsv/etc...)
	;	EANZX惁RAMłSRAMłFLASHłA
	;  ̑gݍ킹̏ꍇǂAxXbgs܂B
	;  Ⴆ΁Â悤ȃR[hłxXbgs܂B
	;	ld.b [%sp+0], %r13	; ANZX
	;	jp.d %r10		; C^[bNĂȂc
	;	add %r1, 1		; xXbg͎sȂ!!
	;  ujp.d %rbvł͂Ȃucall.d %rbvȂΑv݂łB(؂łAɉӏgĐĂ̂)
	;  ڂׂKv܂A܂͎̃[ɏ]Ă̂SȂ悤łB
	;	wujp.d %rbv̒Oɂ̓ANZX߂uȂƁx
	;--------------------------------------------------------------------
	;xld.w %r10, [%r10]
	;jp.d %r10			; !INTERLOCK! <= ꂪRAMɂƁEEE
	;add %r1, 1			; *delay*     <= ꂪsȂB
	;--------------------------------------------------------------------
	;Ƒv
	;--------------------------------------------------------------------
	xld.w %r10, [%r10]
	add %r1, 1			; *anti-interlock*
	jp %r10
	;--------------------------------------------------------------------
	;ł (̕@̕đ̂ŁA܂Ӗ͂Ȃł)
	;--------------------------------------------------------------------
	;xld.w %r10, [%r10]
	;nop				; *anti-interlock*
	;jp.d %r10
	;add %r1, 1			; *delay*
	;}}==================================================================
	;
m6502_run_immediate:
m6502_run_zeropage:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub %r14, %r10		; arg = arg1
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_relative:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1
	;
	ld.b %r14, %r10			; arg = PC + (char)arg1
	add %r14, %r1
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp m6502_run_exec		; !NO-DELAY!
	;
m6502_run_zeropage_x:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%r0+X]		; arg = arg1 + X
	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	;
	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_zeropage_y:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%r0+Y]		; arg = arg1 + Y
	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	;
	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_indirect_x:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r13, [%r0+X]		; arg1+X
	add %r13, %r10			; !INTERLOCK!
	ld.ub %r13, %r13
	xld.b [%sp+1], %r13		; (save arg1+X)
	call.d %r3			; LO(arg) = m6502->read(m6502, arg1+X)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r13, [%sp+1]		; (restore arg1+X)
	xld.b [%sp+1], %r10		; (save LO(arg)) *anti-interlock*
	xadd %r13, %r13, 1		; arg1+X+1
	ld.ub %r13, %r13
	call.d %r3			; HI(arg) = m6502->read(m6502, arg1+X+1)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore LO(arg))
	xsll %r10, 8			; arg = LO(arg) | HI(arg) << 8 *anti-interlock*
	or %r14, %r10
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_indirect_y:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.b [%sp+1], %r10		; (save arg1)
	ld.ub %r13, %r10
	call.d %r3			; LO(arg) = m6502->read(m6502, arg1)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r13, [%sp+1]		; (restore arg1)
	xld.b [%sp+1], %r10		; (save LO(arg)) *anti-interlock*
	xadd %r13, %r13, 1		; arg1+1
	ld.ub %r13, %r13
	call.d %r3			; HI(arg) = m6502->read(m6502, arg1+1)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore LO(arg))
	xsll %r10, 8			; arg = LO(arg) | HI(arg) << 8
	xld.ub %r11, [%r0+Y]		; arg += Y
	or %r14, %r10			; *anti-interlock*
	add %r14, %r11
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_absolute:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1
	;
	xld.b [%sp+1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
	xsll %r10, 8			; arg = arg1 | arg2 << 8 *anti-interlock*
	or %r14, %r10
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_absolute_x:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1
	;
	xld.b [%sp+1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
	xsll %r10, 8			; arg = arg1 | arg2 << 8
	xld.ub %r11, [%r0+X]		; arg += X
	or %r14, %r10			; *anti-interlock*
	add %r14, %r11
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_absolute_y:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1
	;
	xld.b [%sp+1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
	xsll %r10, 8			; arg = arg1 | arg2 << 8
	xld.ub %r11, [%r0+Y]		; arg += Y
	or %r14, %r10			; *anti-interlock*
	add %r14, %r11
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_indirect:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1
	;
	xld.b [%sp+1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1
	;
	xld.ub %r13, [%sp+1]		; (restore arg1)
	xsll %r10, 8			; ptr = arg1 | arg2 << 8 *anti-interlock*
	or %r13, %r10
	;
	xld.h [%sp+2], %r13		; (save ptr)
	call.d %r3			; arg1 = m6502->read(m6502, ptr)
	ld.w %r12, %r0			; *delay*
	;
	xld.uh %r13, [%sp+2]		; (restore ptr)
	xld.b [%sp+1], %r10		; (save LO(arg)) *anti-interlock*
	xadd %r13, %r13, 1		; ptr+1
	ld.uh %r13, %r13
	call.d %r3			; HI(arg) = m6502->read(m6502, ptr+1)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore LO(arg))
	xsll %r10, 8			; arg = LO(arg) | HI(arg) << 8 *anti-interlock*
	or %r14, %r10
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	;** fall thru **
	;
m6502_run_implied:
m6502_run_accumulator:
m6502_run_exec:
	xld.w %r10, [%r2+0]		; op->proc(arg)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	; 2005/03/16
	; Cł́ATCNJEgɌ炷悤ύX܂B(clipm65i.hQ)
	; Asmł͖ύXȂ̂ŁACłAsmł̓삪Ă܂B(2005/03/16)
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11			; !INTERLOCK!
	xld.w [%r0+CYCLE], %r10
	xjrgt m6502_run_L10		; if(CYCLE <= 0) break
m6502_run_exit:
	;
	xadd %sp, %sp, 4
	popn %r3
	ret
	;
	.align 2
m6502_run_table:
	;===== bytes=1 =====
	.word m6502_run_implied		;  0
	.word m6502_run_accumulator	;  1
	;===== bytes=2 =====
	.word m6502_run_immediate	;  2
	.word m6502_run_relative	;  3
	.word m6502_run_zeropage	;  4
	.word m6502_run_zeropage_x	;  5
	.word m6502_run_zeropage_y	;  6
	.word m6502_run_indirect_x	;  7
	.word m6502_run_indirect_y	;  8
	;===== bytes=3 =====
	.word m6502_run_absolute	;  9
	.word m6502_run_absolute_x	; 10
	.word m6502_run_absolute_y	; 11
	.word m6502_run_indirect	; 12
	.align 1

;****************************************************************************
;	f[^]
;****************************************************************************

#macro LDr_IMMEDIATE $1
	xld.ub %r11, [%r12+PSR]
	xld.b [%r12+$1], %r14		; *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	xsrl %r14, 7			; ????????_??????ZN
	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	xld.b [%r12+PSR], %r11
	ret
#endm

#macro LDr_ADDRESS $1
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.ub %r11, [%r0+PSR]
	xld.b [%r0+$1], %r10		; *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r0+PSR], %r11
	;
	popn %r0
	ret
#endm

#macro STr_ADDRESS $1
	xld.w %r10, [%r12+WRITE]
	ld.w %r13, %r14
	xld.ub %r14, [%r12+$1]
	call %r10
	ret
#endm

#macro Trr_IMPLIED $1, $2
	xld.ub %r14, [%r12+$1]
	xld.ub %r11, [%r12+PSR]		; *anti-interlock*
	xld.b [%r12+$2], %r14		; *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	xsrl %r14, 7			; ????????_??????ZN
	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	xld.b [%r12+PSR], %r11
	ret
#endm

#macro PHr_IMPLIED $1
	xld.w %r10, [%r12+WRITE]
	xld.ub %r13, [%r12+SP]
	xld.ub %r14, [%r12+$1]		; *anti-interlock*
	xsub %r11, %r13, 1
	xld.b [%r12+SP], %r11
	xoor %r13, %r13, 0x100
	call %r10
	ret
#endm

#macro PLr_IMPLIED $1
	pushn %r0
	;
	xld.ub %r13, [%r12+SP]
	xld.w %r10, [%r12+READ]		; *anti-interlock*
	xadd %r13, %r13, 1
	xld.b [%r12+SP], %r13
	ld.ub %r13, %r13		; v:vȂƎv
	xoor %r13, %r13, 0x100
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.ub %r11, [%r0+PSR]
	xld.b [%r0+$1], %r10		; *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r0+PSR], %r11
	;
	popn %r0
	ret
#endm

;****************************************************************************

	.global m6502op_LDA_IMMEDIATE
m6502op_LDA_IMMEDIATE:
	LDr_IMMEDIATE A
	.global m6502op_LDX_IMMEDIATE
m6502op_LDX_IMMEDIATE:
	LDr_IMMEDIATE X
	.global m6502op_LDY_IMMEDIATE
m6502op_LDY_IMMEDIATE:
	LDr_IMMEDIATE Y

	.global m6502op_LDA_ADDRESS
m6502op_LDA_ADDRESS:
	LDr_ADDRESS A
	.global m6502op_LDX_ADDRESS
m6502op_LDX_ADDRESS:
	LDr_ADDRESS X
	.global m6502op_LDY_ADDRESS
m6502op_LDY_ADDRESS:
	LDr_ADDRESS Y

	.global m6502op_STA_ADDRESS
m6502op_STA_ADDRESS:
	STr_ADDRESS A
	.global m6502op_STX_ADDRESS
m6502op_STX_ADDRESS:
	STr_ADDRESS X
	.global m6502op_STY_ADDRESS
m6502op_STY_ADDRESS:
	STr_ADDRESS Y

	.global m6502op_TXA_IMPLIED
m6502op_TXA_IMPLIED:
	Trr_IMPLIED X, A
	.global m6502op_TYA_IMPLIED
m6502op_TYA_IMPLIED:
	Trr_IMPLIED Y, A
	.global m6502op_TAX_IMPLIED
m6502op_TAX_IMPLIED:
	Trr_IMPLIED A, X
	.global m6502op_TAY_IMPLIED
m6502op_TAY_IMPLIED:
	Trr_IMPLIED A, Y
	.global m6502op_TSX_IMPLIED
m6502op_TSX_IMPLIED:
	Trr_IMPLIED SP, X
	.global m6502op_TXS_IMPLIED
m6502op_TXS_IMPLIED:
	xld.ub %r10, [%r12+X]
	xld.b [%r12+SP], %r10
	/* NO FLAGS AFFECTED */
	ret

	.global m6502op_PHA_IMPLIED
m6502op_PHA_IMPLIED:
	PHr_IMPLIED A
	.global m6502op_PHP_IMPLIED
m6502op_PHP_IMPLIED:
	PHr_IMPLIED PSR
	.global m6502op_PLA_IMPLIED
m6502op_PLA_IMPLIED:
	PLr_IMPLIED A
	.global m6502op_PLP_IMPLIED
m6502op_PLP_IMPLIED:
	pushn %r0
	;
	xld.ub %r13, [%r12+SP]
	xld.w %r10, [%r12+READ]		; *anti-interlock*
	xadd %r13, %r13, 1
	xld.b [%r12+SP], %r13
	ld.ub %r13, %r13		; v:vȂƎv
	xoor %r13, %r13, 0x100
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xoor %r10, %r10, 0x20		; PSR(R)
	xld.b [%r0+PSR], %r10
	;
	popn %r0
	ret

;****************************************************************************
;	ZpZ
;****************************************************************************

	.global m6502_ADC
m6502_ADC:
	xld.ub %r11, [%r12+PSR]		; PSR
	xld.ub %r10, [%r12+A]		; A *anti-interlock*
	ld.w %r15, %r11			; c = PSR(C)
	xand %r15, %r15, 1
	xand %r11, %r11, ~0xc3		; PSR(N,V,Z,C) = 0
	;
	swap %r10, %r10			; A + n
	swap %r13, %r13
	add %r10, %r13
	;
	ld.w %r13, %psr			; %psr(C1,V1)
	xand %r13, %r13, 0xc
	;
	swap %r15, %r15			; A + n + c
	add %r10, %r15
	;
	ld.w %r14, %psr			; %psr(C1|C2,V1^V2,Z2,N2)
	xand %r15, %r14, 0x4
	xor %r13, %r15
	xand %r14, %r14, 0xb
	or %r13, %r14
	xld.ub %r13, [%r13+m6502_FLAG_CONV]	; PSR(N,V,Z,C)
	;
	swap %r10, %r10			; A
	xld.b [%r12+A], %r10
	;
	or %r11, %r13			; PSR
	xld.b [%r12+PSR], %r11
	;
	ret

	.global m6502_SBC
m6502_SBC:
	xld.ub %r11, [%r12+PSR]		; PSR
	xld.ub %r10, [%r12+A]		; A *anti-interlock*
	not %r15, %r11			; c = ~PSR(C)
	xand %r15, %r15, 1
	xand %r11, %r11, ~0xc3		; PSR(N,V,Z,C) = 0
	;
	swap %r10, %r10			; A - n
	swap %r13, %r13
	sub %r10, %r13
	;
	ld.w %r13, %psr			; %psr(C1,V1)
	xand %r13, %r13, 0xc
	;
	swap %r15, %r15			; A - n - c
	sub %r10, %r15
	;
	ld.w %r14, %psr			; %psr(C1|C2,V1^V2,Z2,N2)
	xand %r15, %r14, 0x4
	xor %r13, %r15
	xand %r14, %r14, 0xb
	or %r13, %r14
	xld.ub %r13, [%r13+m6502_FLAG_CONV]	; PSR(N,V,Z,C)
	;
	swap %r10, %r10			; A
	xld.b [%r12+A], %r10
	;
	xxor %r13, %r13, 1		; PSR(C) = ~PSR(C)
	or %r11, %r13			; PSR
	xld.b [%r12+PSR], %r11
	;
	ret

	.global m6502_CMP
m6502_CMP:
	xld.ub %r11, [%r12+PSR]		; PSR
	swap %r13, %r13			; a - b
	swap %r14, %r14
	xand %r11, %r11, ~0x83		; PSR(N,Z,C) = 0
	sub %r13, %r14
	;
	ld.w %r13, %psr			; %psr(C,Z,N)
	xand %r13, %r13, 0xb
	xld.ub %r13, [%r13+m6502_FLAG_CONV]	; PSR(N,Z,C)
	;
	xxor %r13, %r13, 1		; PSR(C) = ~PSR(C) !INTERLOCK!
	or %r11, %r13			; PSR
	xld.b [%r12+PSR], %r11
	;
	ret

;****************************************************************************

; ANZX́ujp.d %rbv͌듮삵AxXbgs܂񂪁A
;   ANZX́ujr<cond>.d sign8v͑vƔf܂B
;   ANZX́ujr<cond>.d sign8vgĂ܂B
;   Ă悤Ȃ̂ővƎv܂A
;   AVC邱Ƃ炱^ĂB

; ANZX́ucall.d %rbv͌듮삵܂Bi؍ς݁j

#macro ADC_IMMEDIATE
	xbtst [%r12+PSR], 3
	xjreq.d m6502_ADC
	ld.ub %r13, %r14		; *delay*
	xjp m6502_ADCD
#endm

#macro SBC_IMMEDIATE
	xbtst [%r12+PSR], 3
	xjreq.d m6502_SBC
	ld.ub %r13, %r14		; *delay*
	xjp m6502_SBCD
#endm

#macro CPr_IMMEDIATE $1
	xld.ub %r13, [%r12+$1]
	xjp m6502_CMP
#endm

#macro ADC_ADDRESS
	xsub %sp, %sp, 4
	xld.w %r10, [%r12+READ]
	xld.w [%sp+0], %r12		; (save m6502)
	call.d %r10
	ld.w %r13, %r14			; *delay*
	xld.w %r12, [%sp+0]		; (restore m6502)
	xadd %sp, %sp, 4
	;
	xbtst [%r12+PSR], 3
	xjreq.d m6502_ADC
	ld.ub %r13, %r10		; *delay*
	xjp m6502_ADCD
#endm

#macro SBC_ADDRESS
	xsub %sp, %sp, 4
	xld.w %r10, [%r12+READ]
	xld.w [%sp+0], %r12		; (save m6502)
	call.d %r10
	ld.w %r13, %r14			; *delay*
	xld.w %r12, [%sp+0]		; (restore m6502)
	xadd %sp, %sp, 4
	;
	xbtst [%r12+PSR], 3
	xjreq.d m6502_SBC
	ld.ub %r13, %r10		; *delay*
	xjp m6502_SBCD
#endm

#macro CPr_ADDRESS $1
	xsub %sp, %sp, 4
	xld.w %r10, [%r12+READ]
	xld.w [%sp+0], %r12		; (save m6502)
	call.d %r10
	ld.w %r13, %r14			; *delay*
	xld.w %r12, [%sp+0]		; (restore m6502)
	xadd %sp, %sp, 4
	;
	xld.ub %r13, [%r12+$1]
	xjp.d m6502_CMP
	ld.w %r14, %r10			; *delay*
#endm

#macro INr_IMPLIED $1
	xld.ub %r14, [%r12+$1]
	xld.ub %r11, [%r12+PSR]		; *anti-interlock*
	xadd %r14, %r14, 1		; *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xld.b [%r12+$1], %r14
	ld.ub %r14, %r14		; YȂŁI
	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	xsrl %r14, 7			; ????????_??????ZN
	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	xld.b [%r12+PSR], %r11
	ret
#endm

#macro DEr_IMPLIED $1
	xld.ub %r14, [%r12+$1]
	xld.ub %r11, [%r12+PSR]		; *anti-interlock*
	xsub %r14, %r14, 1		; *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xld.b [%r12+$1], %r14
	ld.ub %r14, %r14		; YȂŁI
	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	xsrl %r14, 7			; ????????_??????ZN
	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	xld.b [%r12+PSR], %r11
	ret
#endm

;****************************************************************************

	.global m6502op_ADC_IMMEDIATE
m6502op_ADC_IMMEDIATE:
	ADC_IMMEDIATE
	.global m6502op_SBC_IMMEDIATE
m6502op_SBC_IMMEDIATE:
	SBC_IMMEDIATE
	.global m6502op_CMP_IMMEDIATE
m6502op_CMP_IMMEDIATE:
	CPr_IMMEDIATE A
	.global m6502op_CPX_IMMEDIATE
m6502op_CPX_IMMEDIATE:
	CPr_IMMEDIATE X
	.global m6502op_CPY_IMMEDIATE
m6502op_CPY_IMMEDIATE:
	CPr_IMMEDIATE Y

	.global m6502op_ADC_ADDRESS
m6502op_ADC_ADDRESS:
	ADC_ADDRESS
	.global m6502op_SBC_ADDRESS
m6502op_SBC_ADDRESS:
	SBC_ADDRESS
	.global m6502op_CMP_ADDRESS
m6502op_CMP_ADDRESS:
	CPr_ADDRESS A
	.global m6502op_CPX_ADDRESS
m6502op_CPX_ADDRESS:
	CPr_ADDRESS X
	.global m6502op_CPY_ADDRESS
m6502op_CPY_ADDRESS:
	CPr_ADDRESS Y

	.global m6502op_INC_ADDRESS
m6502op_INC_ADDRESS:
	pushn %r1
	;
	ld.w %r1, %r14			; addr
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xadd %r10, %r10, 1
	ld.ub %r10, %r10		; YȂŁI
	;
	xld.ub %r11, [%r0+PSR]
	ld.w %r14, %r10			; *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r0+PSR], %r11
	;
	xld.w %r10, [%r0+WRITE]
	ld.w %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global m6502op_DEC_ADDRESS
m6502op_DEC_ADDRESS:
	pushn %r1
	;
	ld.w %r1, %r14			; addr
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xsub %r10, %r10, 1
	ld.ub %r10, %r10		; YȂŁI
	;
	xld.ub %r11, [%r0+PSR]
	ld.w %r14, %r10			; *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r0+PSR], %r11
	;
	xld.w %r10, [%r0+WRITE]
	ld.w %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global m6502op_INX_IMPLIED
m6502op_INX_IMPLIED:
	INr_IMPLIED X
	.global m6502op_INY_IMPLIED
m6502op_INY_IMPLIED:
	INr_IMPLIED Y
	.global m6502op_DEX_IMPLIED
m6502op_DEX_IMPLIED:
	DEr_IMPLIED X
	.global m6502op_DEY_IMPLIED
m6502op_DEY_IMPLIED:
	DEr_IMPLIED Y

;****************************************************************************
;	_Z
;****************************************************************************

	.global m6502op_AND_IMMEDIATE
m6502op_AND_IMMEDIATE:
	xld.ub %r10, [%r12+A]
	xld.ub %r11, [%r12+PSR]		; *anti-interlock*
	and %r10, %r14			; A &= arg *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xld.b [%r12+A], %r10
	;
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r12+PSR], %r11
	;
	ret

	.global m6502op_ORA_IMMEDIATE
m6502op_ORA_IMMEDIATE:
	xld.ub %r10, [%r12+A]
	xld.ub %r11, [%r12+PSR]		; *anti-interlock*
	or %r10, %r14			; A |= arg *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xld.b [%r12+A], %r10
	;
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r12+PSR], %r11
	;
	ret

	.global m6502op_EOR_IMMEDIATE
m6502op_EOR_IMMEDIATE:
	xld.ub %r10, [%r12+A]
	xld.ub %r11, [%r12+PSR]		; *anti-interlock*
	xor %r10, %r14			; A ^= arg *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xld.b [%r12+A], %r10
	;
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r12+PSR], %r11
	;
	ret

	.global m6502op_AND_ADDRESS
m6502op_AND_ADDRESS:
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.ub %r14, [%r0+A]
	xld.ub %r11, [%r0+PSR]		; *anti-interlock*
	and %r10, %r14			; A &= READ(arg) *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xld.b [%r0+A], %r10
	;
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r0+PSR], %r11
	;
	popn %r0
	ret

	.global m6502op_ORA_ADDRESS
m6502op_ORA_ADDRESS:
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.ub %r14, [%r0+A]
	xld.ub %r11, [%r0+PSR]		; *anti-interlock*
	or %r10, %r14			; A |= READ(arg) *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xld.b [%r0+A], %r10
	;
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r0+PSR], %r11
	;
	popn %r0
	ret

	.global m6502op_EOR_ADDRESS
m6502op_EOR_ADDRESS:
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.ub %r14, [%r0+A]
	xld.ub %r11, [%r0+PSR]		; *anti-interlock*
	xor %r10, %r14			; A ^= READ(arg) *anti-interlock*
	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
	xld.b [%r0+A], %r10
	;
	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	xsrl %r10, 7			; ????????_??????ZN
	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	xld.b [%r0+PSR], %r11
	;
	popn %r0
	ret

;****************************************************************************
;	t[
;****************************************************************************

#macro Bcc_ADDRESS $1
	xbtst [%r12+PSR], $1
	xjreq $$1
	;
	xld.w %r10, [%r12+CYCLE]	; CYCLE--
	xld.h [%r12+PC], %r14		; PC *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
$$1:
	ret
#endm

#macro BNcc_ADDRESS $1
	xbtst [%r12+PSR], $1
	xjrne $$1
	;
	xld.w %r10, [%r12+CYCLE]	; CYCLE--
	xld.h [%r12+PC], %r14		; PC *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
$$1:
	ret
#endm

;****************************************************************************

	.global m6502op_BCC_ADDRESS
m6502op_BCC_ADDRESS:
	BNcc_ADDRESS 0
	.global m6502op_BCS_ADDRESS
m6502op_BCS_ADDRESS:
	Bcc_ADDRESS 0
	.global m6502op_BNE_ADDRESS
m6502op_BNE_ADDRESS:
	BNcc_ADDRESS 1
	.global m6502op_BEQ_ADDRESS
m6502op_BEQ_ADDRESS:
	Bcc_ADDRESS 1
	.global m6502op_BVC_ADDRESS
m6502op_BVC_ADDRESS:
	BNcc_ADDRESS 6
	.global m6502op_BVS_ADDRESS
m6502op_BVS_ADDRESS:
	Bcc_ADDRESS 6
	.global m6502op_BPL_ADDRESS
m6502op_BPL_ADDRESS:
	BNcc_ADDRESS 7
	.global m6502op_BMI_ADDRESS
m6502op_BMI_ADDRESS:
	Bcc_ADDRESS 7

	.global m6502op_BRK_IMPLIED
m6502op_BRK_IMPLIED:
	xcall m6502_brk
	ret
	.global m6502op_JMP_ADDRESS
m6502op_JMP_ADDRESS:
	xld.h [%r12+PC], %r14
	ret

	.global m6502op_JSR_ADDRESS
m6502op_JSR_ADDRESS:
	pushn %r2
	;
	xld.ub %r1, [%r12+SP]		; SP|0x100
	xld.uh %r2, [%r12+PC]		; PC--(dl) *anti-interlock*
	xoor %r1, %r1, 0x100		;            *anti-interlock*
	xsub %r2, %r2, 1
	;
	xld.h [%r12+PC], %r14		; PC <= arg
	;
	xld.w %r10, [%r12+WRITE]	; PUSH(PCH)
	ld.w %r13, %r1
	ld.uh %r14, %r2
	xsrl %r14, 8
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	;				; SP|0x100 == 0x100      `0x1ff
	xsub %r1, %r1, 1		; -1       => 0x0ff      `0x1fe
	xoor %r1, %r1, 0x100		;   |0x100 => 0x1ff,0x100`0x1fe
	;
	xld.w %r10, [%r0+WRITE]		; PUSH(PCL)
	ld.w %r13, %r1
	ld.ub %r14, %r2
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xsub %r1, %r1, 1		; SP--
	xld.b [%r0+SP], %r1
	;
	popn %r2
	ret

	.global m6502op_RTS_IMPLIED
m6502op_RTS_IMPLIED:
	pushn %r2
	;
	xld.ub %r1, [%r12+SP]		; SP         == 0x000`      0x0ff
	xld.w %r10, [%r12+READ]		; *anti-interlock*
	xadd %r1, %r1, 1		; SP++       => 0x001`      0x100
	xoor %r1, %r1, 0x100		; SP++|0x100 => 0x101`0x1ff,0x100
	;
	ld.w %r13, %r1			; POP(PCL)
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r2, %r10			; (save PCL)
	;
	;				; SP|0x100 == 0x100`      0x1ff
	xadd %r1, %r1, 1		; +1       => 0x101`      0x200
	ld.ub %r1, %r1			;          => 0x001`0x0ff,0x000
	xoor %r1, %r1, 0x100		;   |0x100 => 0x101`0x1ff,0x100
	;
	xld.w %r10, [%r0+READ]		; POP(PCH)
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xsll %r10, 8			; PC = PCL | PCH << 8
	or %r10, %r2
	xadd %r10, %r10, 1		; PC++(dl)
	xld.h [%r0+PC], %r10
	;
	xld.b [%r0+SP], %r1		; SP
	;
	popn %r2
	ret

	.global m6502op_RTI_IMPLIED
m6502op_RTI_IMPLIED:
	pushn %r1
	;
	xld.ub %r1, [%r12+SP]		; SP         == 0x000`      0x0ff
	xld.w %r10, [%r12+READ]		; *anti-interlock*
	xadd %r1, %r1, 1		; SP++       => 0x001`      0x100
	xoor %r1, %r1, 0x100		; SP++|0x100 => 0x101`0x1ff,0x100
	;
	ld.w %r13, %r1			; POP(PSR)
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xoor %r10, %r10, 0x20		; PSR(R) = 1
	xld.b [%r0+PSR], %r10
	;
	;				; SP|0x100 == 0x100`      0x1ff
	xadd %r1, %r1, 1		; +1       => 0x101`      0x200
	ld.ub %r1, %r1			;          => 0x001`0x0ff,0x000
	xoor %r1, %r1, 0x100		;   |0x100 => 0x101`0x1ff,0x100
	;
	xld.w %r10, [%r0+READ]		; POP(PCL)
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.b [%r0+(PC+0)], %r10	; PCL
	;
	;				; SP|0x100 == 0x100`      0x1ff
	xadd %r1, %r1, 1		; +1       => 0x101`      0x200
	ld.ub %r1, %r1			;          => 0x001`0x0ff,0x000
	xoor %r1, %r1, 0x100		;   |0x100 => 0x101`0x1ff,0x100
	;
	xld.w %r10, [%r0+READ]		; POP(PCH)
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.b [%r0+(PC+1)], %r10	; PCH
	;
	xld.b [%r0+SP], %r1		; SP
	;
	popn %r1
	ret

;****************************************************************************
;	
;****************************************************************************

#endif /*M6502_ASM*/
