;	
;	framm65a.s
;
;	P/ECE MOS6502 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2003 Naoyuki Sawa
;
;	* Sat Dec 08 06:00:00 JST 2003 Naoyuki Sawa
;	- 쐬JnB
;	* Wed Mar 16 07:13:00 JST 2005 Naoyuki Sawa
;	- m6502_ruńACłAsmł̑ɂāARgǉB
;	  Cł̃vO͕ύXς݁AAsmł̃vO͖ύXłB
;	  2005/03/16݁ACłAsmłƂŁATCNJEg̓삪قȂĂ܂B
;
;#include "clipm65a.h"
;/	
;/	clipm65a.h
;/
;/	P/ECE MOS6502 Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2003 Naoyuki Sawa
;/
;/	* Sat Dec 07 12:00:00 JST 2003 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define M6502_ASM
;#ifdef M6502_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	M6502\
;
;*===== WX^ =====*/
;#define A	 0
;#define X	 1
;#define Y	 2
;#define PC	 4
;#define SP	 6
;#define PSR	 7
;*=====  =====*/
;#define CYCLE	 8
;#define WAIT	12
;*===== O֐ =====*/
;#define READ	16
;#define WRITE	20

;
;	C33=>M6502tOϊ\
;
				; C33(C,V,Z,N) => M6502(S,Z,V,C)
				; ====C33====     ===M6502===
m6502_FLAG_CONV:		; ----CVZN        NV----ZC
	.byte	0x00		; 00000000 00     00000000 00
	.byte	0x80		; 00000001 01     10000000 80
	.byte	0x02		; 00000010 02     00000010 02
	.byte	0x82		; 00000011 03     10000010 82
	.byte	0x40		; 00000100 04     01000000 40
	.byte	0xc0		; 00000101 05     11000000 c0
	.byte	0x42		; 00000110 06     01000010 42
	.byte	0xc2		; 00000111 07     11000010 c2
	.byte	0x01		; 00001000 08     00000001 01
	.byte	0x81		; 00001001 09     10000001 81
	.byte	0x03		; 00001010 0a     00000011 03
	.byte	0x83		; 00001011 0b     10000011 83
	.byte	0x41		; 00001100 0c     01000001 41
	.byte	0xc1		; 00001101 0d     11000001 c1
	.byte	0x43		; 00001110 0e     01000011 43
	.byte	0xc3		; 00001111 0f     11000011 c3

;****************************************************************************
;
;****************************************************************************

	.global m6502_run
m6502_run:
	pushn %r3
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; m6502
	ext	0x10		; 	xld.w %r3, [%r0+0x10]		; m6502->read
	ld.w	%r3,[%r0]
	ext	0x8		; 	xld.w [%r0+0x8], %r13		; CYCLE
	ld.w	[%r0],%r13
	cmp	%r13,0x0	; 	xcmp %r13, 0			; if(CYCLE <= 0) break
	ext	m6502_run_exit@rm	; 	xjrle m6502_run_exit
	jrle	m6502_run_exit@rl
	;
m6502_run_L10:
	ext	0xc		; 	xld.ub %r10, [%r0+0xc]		; if(WAIT) break
	ld.ub	%r10,[%r0]
	ext	0x4		; 	xld.uh %r1, [%r0+0x4]		; PC *anti-interlock*
	ld.uh	%r1,[%r0]
	cmp	%r10,0x0	; 	xcmp %r10, 0
	ext	m6502_run_exit@rm	; 	xjrne m6502_run_exit
	jrne	m6502_run_exit@rl
	;
	ld.uh %r13, %r1			; code = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.ub %r13, %r10
	;
	ext	m6502_op_table+0x0@h	; 	xld.w %r2, m6502_op_table	; op = &m6502_op_table[code]
	ext	m6502_op_table+0x0@m
	ld.w	%r2,m6502_op_table+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; switch(op->mode)
	ld.ub	%r10,[%r2]
	ext	m6502_run_table+0x0@h	; 	xld.w %r11, m6502_run_table	; *anti-interlock*
	ext	m6502_run_table+0x0@m
	ld.w	%r11,m6502_run_table+0x0@l
	sll	%r10,0x2	; 	xsll %r10, 2
	add %r10, %r11
	;{{==================================================================
	;S1C33RÃoO!?
	;RAMɒux򖽗߂C^[bNƁAxXbgsȂ݂łB
	;2003/12/19ǋL
	;C^[bN͊֌WȂ݂łB
	;  RAMɒuujp.d %rbv̒OɃANZX߂ƁAxXbgsȂ悤łB
	;  ÕANZX߂F
	;	Eǂݍ݂łĂ݂łĂA(uld.w %rd,[%rb]v/uld.w [%rb],%rsv/etc...)
	;	Eext߂𔺂ĂĂȂĂA(uld.w [%rb],%rsv/uld.w [%rb+disp],%rsv/etc...)
	;	EANZX̃TCYłA(uld.w [%rb],%rsv/uld.h/uh [%rb],%rsv/uld.b/ub [%rb],%rsv/etc...)
	;	EANZX惁RAMłSRAMłFLASHłA
	;  ̑gݍ킹̏ꍇǂAxXbgs܂B
	;  Ⴆ΁Â悤ȃR[hłxXbgs܂B
	;	ld.b [%sp+0], %r13	; ANZX
	;	jp.d %r10		; C^[bNĂȂc
	;	add %r1, 1		; xXbg͎sȂ!!
	;  ujp.d %rbvł͂Ȃucall.d %rbvȂΑv݂łB(؂łAɉӏgĐĂ̂)
	;  ڂׂKv܂A܂͎̃[ɏ]Ă̂SȂ悤łB
	;	wujp.d %rbv̒Oɂ̓ANZX߂uȂƁx
	;--------------------------------------------------------------------
	;xld.w %r10, [%r10]
	;jp.d %r10			; !INTERLOCK! <= ꂪRAMɂƁEEE
	;add %r1, 1			; *delay*     <= ꂪsȂB
	;--------------------------------------------------------------------
	;Ƒv
	;--------------------------------------------------------------------
	ld.w	%r10,[%r10]	; 	xld.w %r10, [%r10]
	add %r1, 1			; *anti-interlock*
	jp %r10
	;--------------------------------------------------------------------
	;ł (̕@̕đ̂ŁA܂Ӗ͂Ȃł)
	;--------------------------------------------------------------------
	;xld.w %r10, [%r10]
	;nop				; *anti-interlock*
	;jp.d %r10
	;add %r1, 1			; *delay*
	;}}==================================================================
	;
m6502_run_immediate:
m6502_run_zeropage:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub %r14, %r10		; arg = arg1
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	m6502_run_exec@rm	; 	xjp.d m6502_run_exec
	jp.d	m6502_run_exec@rl
	add %r1, 1			; *delay*
	;
m6502_run_relative:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1
	;
	ld.b %r14, %r10			; arg = PC + (char)arg1
	add %r14, %r1
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	m6502_run_exec@rm	; 	xjp m6502_run_exec		; !NO-DELAY!
	jp	m6502_run_exec@rl
	;
m6502_run_zeropage_x:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x1		; 	xld.ub %r14, [%r0+0x1]		; arg = arg1 + X
	ld.ub	%r14,[%r0]
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	;
	ext	m6502_run_exec@rm	; 	xjp.d m6502_run_exec
	jp.d	m6502_run_exec@rl
	add %r1, 1			; *delay*
	;
m6502_run_zeropage_y:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x2		; 	xld.ub %r14, [%r0+0x2]		; arg = arg1 + Y
	ld.ub	%r14,[%r0]
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	;
	ext	m6502_run_exec@rm	; 	xjp.d m6502_run_exec
	jp.d	m6502_run_exec@rl
	add %r1, 1			; *delay*
	;
m6502_run_indirect_x:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x1		; 	xld.ub %r13, [%r0+0x1]		; arg1+X
	ld.ub	%r13,[%r0]
	add %r13, %r10			; !INTERLOCK!
	ld.ub %r13, %r13
	ld.b	[%sp+0x1],%r13	; 	xld.b [%sp+0x1], %r13		; (save arg1+X)
	call.d %r3			; LO(arg) = m6502->read(m6502, arg1+X)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r13,[%sp+0x1]	; 	xld.ub %r13, [%sp+0x1]		; (restore arg1+X)
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save LO(arg)) *anti-interlock*
	add	%r13,0x1	; 	xadd %r13, %r13, 1		; arg1+X+1
	ld.ub %r13, %r13
	call.d %r3			; HI(arg) = m6502->read(m6502, arg1+X+1)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore LO(arg))
	sll	%r10,0x8	; 	xsll %r10, 8			; arg = LO(arg) | HI(arg) << 8 *anti-interlock*
	or %r14, %r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	m6502_run_exec	; 	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_indirect_y:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save arg1)
	ld.ub %r13, %r10
	call.d %r3			; LO(arg) = m6502->read(m6502, arg1)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r13,[%sp+0x1]	; 	xld.ub %r13, [%sp+0x1]		; (restore arg1)
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save LO(arg)) *anti-interlock*
	add	%r13,0x1	; 	xadd %r13, %r13, 1		; arg1+1
	ld.ub %r13, %r13
	call.d %r3			; HI(arg) = m6502->read(m6502, arg1+1)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore LO(arg))
	sll	%r10,0x8	; 	xsll %r10, 8			; arg = LO(arg) | HI(arg) << 8
	ext	0x2		; 	xld.ub %r11, [%r0+0x2]		; arg += Y
	ld.ub	%r11,[%r0]
	or %r14, %r10			; *anti-interlock*
	add %r14, %r11
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	m6502_run_exec	; 	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_absolute:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
	sll	%r10,0x8	; 	xsll %r10, 8			; arg = arg1 | arg2 << 8 *anti-interlock*
	or %r14, %r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	m6502_run_exec	; 	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_absolute_x:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
	sll	%r10,0x8	; 	xsll %r10, 8			; arg = arg1 | arg2 << 8
	ext	0x1		; 	xld.ub %r11, [%r0+0x1]		; arg += X
	ld.ub	%r11,[%r0]
	or %r14, %r10			; *anti-interlock*
	add %r14, %r11
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	m6502_run_exec	; 	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_absolute_y:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
	sll	%r10,0x8	; 	xsll %r10, 8			; arg = arg1 | arg2 << 8
	ext	0x2		; 	xld.ub %r11, [%r0+0x2]		; arg += Y
	ld.ub	%r11,[%r0]
	or %r14, %r10			; *anti-interlock*
	add %r14, %r11
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	m6502_run_exec	; 	xjp.d m6502_run_exec
	add %r1, 1			; *delay*
	;
m6502_run_indirect:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; arg1 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save arg1)
	ld.uh %r13, %r1			; arg2 = m6502->read(m6502, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1
	;
	ld.ub	%r13,[%sp+0x1]	; 	xld.ub %r13, [%sp+0x1]		; (restore arg1)
	sll	%r10,0x8	; 	xsll %r10, 8			; ptr = arg1 | arg2 << 8 *anti-interlock*
	or %r13, %r10
	;
	ld.h	[%sp+0x1],%r13	; 	xld.h [%sp+0x2], %r13		; (save ptr)
	call.d %r3			; arg1 = m6502->read(m6502, ptr)
	ld.w %r12, %r0			; *delay*
	;
	ld.uh	%r13,[%sp+0x1]	; 	xld.uh %r13, [%sp+0x2]		; (restore ptr)
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save LO(arg)) *anti-interlock*
	add	%r13,0x1	; 	xadd %r13, %r13, 1		; ptr+1
	ld.uh %r13, %r13
	call.d %r3			; HI(arg) = m6502->read(m6502, ptr+1)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore LO(arg))
	sll	%r10,0x8	; 	xsll %r10, 8			; arg = LO(arg) | HI(arg) << 8 *anti-interlock*
	or %r14, %r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	;** fall thru **
	;
m6502_run_implied:
m6502_run_accumulator:
m6502_run_exec:
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(arg)
	ext	0x4		; 	xld.h [%r0+0x4], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	; 2005/03/16
	; Cł́ATCNJEgɌ炷悤ύX܂B(clipm65i.hQ)
	; Asmł͖ύXȂ̂ŁACłAsmł̓삪Ă܂B(2005/03/16)
	ext	0x8		; 	xld.w %r10, [%r0+0x8]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11			; !INTERLOCK!
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	m6502_run_L10@rm	; 	xjrgt m6502_run_L10		; if(CYCLE <= 0) break
	jrgt	m6502_run_L10@rl
m6502_run_exit:
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r3
	ret
	;
	.align 2
m6502_run_table:
	;===== bytes=1 =====
	.word m6502_run_implied		;  0
	.word m6502_run_accumulator	;  1
	;===== bytes=2 =====
	.word m6502_run_immediate	;  2
	.word m6502_run_relative	;  3
	.word m6502_run_zeropage	;  4
	.word m6502_run_zeropage_x	;  5
	.word m6502_run_zeropage_y	;  6
	.word m6502_run_indirect_x	;  7
	.word m6502_run_indirect_y	;  8
	;===== bytes=3 =====
	.word m6502_run_absolute	;  9
	.word m6502_run_absolute_x	; 10
	.word m6502_run_absolute_y	; 11
	.word m6502_run_indirect	; 12
	.align 1

;****************************************************************************
;	f[^]
;****************************************************************************

;#macro LDr_IMMEDIATE $1
;	xld.ub %r11, [%r12+PSR]
;	xld.b [%r12+$1], %r14		; *anti-interlock*
;	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
;	xrr %r14, 8
;	ld.w %r14, %psr			; ????????_??????ZN
;	xsll %r14, 7			; ???????Z_N0000000
;	or %r11, %r14			; PSR(N)
;	xsrl %r14, 7			; ????????_??????ZN
;	xand %r14, %r14, 2		; 00000000_000000Z0
;	or %r11, %r14			; PSR(Z)
;	xld.b [%r12+PSR], %r11
;	ret
;#endm

;#macro LDr_ADDRESS $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.ub %r11, [%r0+PSR]
;	xld.b [%r0+$1], %r10		; *anti-interlock*
;	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
;	xrr %r10, 8
;	ld.w %r10, %psr			; ????????_??????ZN
;	xsll %r10, 7			; ???????Z_N0000000
;	or %r11, %r10			; PSR(N)
;	xsrl %r10, 7			; ????????_??????ZN
;	xand %r10, %r10, 2		; 00000000_000000Z0
;	or %r11, %r10			; PSR(Z)
;	xld.b [%r0+PSR], %r11
	;
;	popn %r0
;	ret
;#endm

;#macro STr_ADDRESS $1
;	xld.w %r10, [%r12+WRITE]
;	ld.w %r13, %r14
;	xld.ub %r14, [%r12+$1]
;	call %r10
;	ret
;#endm

;#macro Trr_IMPLIED $1, $2
;	xld.ub %r14, [%r12+$1]
;	xld.ub %r11, [%r12+PSR]		; *anti-interlock*
;	xld.b [%r12+$2], %r14		; *anti-interlock*
;	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
;	xrr %r14, 8
;	ld.w %r14, %psr			; ????????_??????ZN
;	xsll %r14, 7			; ???????Z_N0000000
;	or %r11, %r14			; PSR(N)
;	xsrl %r14, 7			; ????????_??????ZN
;	xand %r14, %r14, 2		; 00000000_000000Z0
;	or %r11, %r14			; PSR(Z)
;	xld.b [%r12+PSR], %r11
;	ret
;#endm

;#macro PHr_IMPLIED $1
;	xld.w %r10, [%r12+WRITE]
;	xld.ub %r13, [%r12+SP]
;	xld.ub %r14, [%r12+$1]		; *anti-interlock*
;	xsub %r11, %r13, 1
;	xld.b [%r12+SP], %r11
;	xoor %r13, %r13, 0x100
;	call %r10
;	ret
;#endm

;#macro PLr_IMPLIED $1
;	pushn %r0
	;
;	xld.ub %r13, [%r12+SP]
;	xld.w %r10, [%r12+READ]		; *anti-interlock*
;	xadd %r13, %r13, 1
;	xld.b [%r12+SP], %r13
;	ld.ub %r13, %r13		; v:vȂƎv
;	xoor %r13, %r13, 0x100
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.ub %r11, [%r0+PSR]
;	xld.b [%r0+$1], %r10		; *anti-interlock*
;	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
;	xrr %r10, 8
;	ld.w %r10, %psr			; ????????_??????ZN
;	xsll %r10, 7			; ???????Z_N0000000
;	or %r11, %r10			; PSR(N)
;	xsrl %r10, 7			; ????????_??????ZN
;	xand %r10, %r10, 2		; 00000000_000000Z0
;	or %r11, %r10			; PSR(Z)
;	xld.b [%r0+PSR], %r11
	;
;	popn %r0
;	ret
;#endm

;****************************************************************************

	.global m6502op_LDA_IMMEDIATE
m6502op_LDA_IMMEDIATE:
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]	; 	LDr_IMMEDIATE A
	ld.ub	%r11,[%r12]
	ld.b	[%r12],%r14	; 	xld.b [%r12+0x0], %r14		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_LDX_IMMEDIATE
m6502op_LDX_IMMEDIATE:
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]	; 	LDr_IMMEDIATE X
	ld.ub	%r11,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_LDY_IMMEDIATE
m6502op_LDY_IMMEDIATE:
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]	; 	LDr_IMMEDIATE Y
	ld.ub	%r11,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret

	.global m6502op_LDA_ADDRESS
m6502op_LDA_ADDRESS:
	pushn %r0	; 	LDr_ADDRESS A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]
	ld.ub	%r11,[%r0]
	ld.b	[%r0],%r10	; 	xld.b [%r0+0x0], %r10		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r0+0x7], %r11
	ld.b	[%r0],%r11
	;
	popn %r0
	ret
	.global m6502op_LDX_ADDRESS
m6502op_LDX_ADDRESS:
	pushn %r0	; 	LDr_ADDRESS X
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]
	ld.ub	%r11,[%r0]
	ext	0x1		; 	xld.b [%r0+0x1], %r10		; *anti-interlock*
	ld.b	[%r0],%r10
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r0+0x7], %r11
	ld.b	[%r0],%r11
	;
	popn %r0
	ret
	.global m6502op_LDY_ADDRESS
m6502op_LDY_ADDRESS:
	pushn %r0	; 	LDr_ADDRESS Y
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]
	ld.ub	%r11,[%r0]
	ext	0x2		; 	xld.b [%r0+0x2], %r10		; *anti-interlock*
	ld.b	[%r0],%r10
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r0+0x7], %r11
	ld.b	[%r0],%r11
	;
	popn %r0
	ret

	.global m6502op_STA_ADDRESS
m6502op_STA_ADDRESS:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	STr_ADDRESS A
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ld.ub	%r14,[%r12]	; 	xld.ub %r14, [%r12+0x0]
	call %r10
	ret
	.global m6502op_STX_ADDRESS
m6502op_STX_ADDRESS:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	STr_ADDRESS X
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global m6502op_STY_ADDRESS
m6502op_STY_ADDRESS:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	STr_ADDRESS Y
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	call %r10
	ret

	.global m6502op_TXA_IMPLIED
m6502op_TXA_IMPLIED:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]	; 	Trr_IMPLIED X, A
	ld.ub	%r14,[%r12]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	ld.b	[%r12],%r14	; 	xld.b [%r12+0x0], %r14		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_TYA_IMPLIED
m6502op_TYA_IMPLIED:
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]	; 	Trr_IMPLIED Y, A
	ld.ub	%r14,[%r12]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	ld.b	[%r12],%r14	; 	xld.b [%r12+0x0], %r14		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_TAX_IMPLIED
m6502op_TAX_IMPLIED:
	ld.ub	%r14,[%r12]	; 	xld.ub %r14, [%r12+0x0]	; 	Trr_IMPLIED A, X
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_TAY_IMPLIED
m6502op_TAY_IMPLIED:
	ld.ub	%r14,[%r12]	; 	xld.ub %r14, [%r12+0x0]	; 	Trr_IMPLIED A, Y
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_TSX_IMPLIED
m6502op_TSX_IMPLIED:
	ext	0x6		; 	xld.ub %r14, [%r12+0x6]	; 	Trr_IMPLIED SP, X
	ld.ub	%r14,[%r12]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_TXS_IMPLIED
m6502op_TXS_IMPLIED:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]
	ld.ub	%r10,[%r12]
	ext	0x6		; 	xld.b [%r12+0x6], %r10
	ld.b	[%r12],%r10
	;* NO FLAGS AFFECTED */
	ret

	.global m6502op_PHA_IMPLIED
m6502op_PHA_IMPLIED:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	PHr_IMPLIED A
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ld.ub	%r14,[%r12]	; 	xld.ub %r14, [%r12+0x0]		; *anti-interlock*
	ext	0x1		; 	xsub %r11, %r13, 1
	sub	%r11,%r13
	ext	0x6		; 	xld.b [%r12+0x6], %r11
	ld.b	[%r12],%r11
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call %r10
	ret
	.global m6502op_PHP_IMPLIED
m6502op_PHP_IMPLIED:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	PHr_IMPLIED PSR
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	0x7		; 	xld.ub %r14, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r14,[%r12]
	ext	0x1		; 	xsub %r11, %r13, 1
	sub	%r11,%r13
	ext	0x6		; 	xld.b [%r12+0x6], %r11
	ld.b	[%r12],%r11
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call %r10
	ret
	.global m6502op_PLA_IMPLIED
m6502op_PLA_IMPLIED:
	pushn %r0	; 	PLr_IMPLIED A
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x6		; 	xld.b [%r12+0x6], %r13
	ld.b	[%r12],%r13
	ld.ub %r13, %r13		; v:vȂƎv
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]
	ld.ub	%r11,[%r0]
	ld.b	[%r0],%r10	; 	xld.b [%r0+0x0], %r10		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r0+0x7], %r11
	ld.b	[%r0],%r11
	;
	popn %r0
	ret
	.global m6502op_PLP_IMPLIED
m6502op_PLP_IMPLIED:
	pushn %r0
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x6		; 	xld.b [%r12+0x6], %r13
	ld.b	[%r12],%r13
	ld.ub %r13, %r13		; v:vȂƎv
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x0		; 	xoor %r10, %r10, 0x20		; PSR(R)
	or	%r10,0x20
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	ZpZ
;****************************************************************************

	.global m6502_ADC
m6502_ADC:
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; PSR
	ld.ub	%r11,[%r12]
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; A *anti-interlock*
	ld.w %r15, %r11			; c = PSR(C)
	and	%r15,0x1	; 	xand %r15, %r15, 1
	ext	0x1ffc		; 	xand %r11, %r11, -196		; PSR(N,V,Z,C) = 0
	and	%r11,0x3c
	;
	swap %r10, %r10			; A + n
	swap %r13, %r13
	add %r10, %r13
	;
	ld.w %r13, %psr			; %psr(C1,V1)
	and	%r13,0xc	; 	xand %r13, %r13, 0xc
	;
	swap %r15, %r15			; A + n + c
	add %r10, %r15
	;
	ld.w %r14, %psr			; %psr(C1|C2,V1^V2,Z2,N2)
	ext	0x4		; 	xand %r15, %r14, 0x4
	and	%r15,%r14
	xor %r13, %r15
	and	%r14,0xb	; 	xand %r14, %r14, 0xb
	or %r13, %r14
	ext	m6502_FLAG_CONV+0x0@h	; 	xld.ub %r13, [%r13+m6502_FLAG_CONV]	; PSR(N,V,Z,C)
	ext	m6502_FLAG_CONV+0x0@m
	ld.w	%r9,m6502_FLAG_CONV+0x0@l
	add	%r9,%r13
	ld.ub	%r13,[%r9]
	;
	swap %r10, %r10			; A
	ld.b	[%r12],%r10	; 	xld.b [%r12+0x0], %r10
	;
	or %r11, %r13			; PSR
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	;
	ret

	.global m6502_SBC
m6502_SBC:
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; PSR
	ld.ub	%r11,[%r12]
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]		; A *anti-interlock*
	not %r15, %r11			; c = ~PSR(C)
	and	%r15,0x1	; 	xand %r15, %r15, 1
	ext	0x1ffc		; 	xand %r11, %r11, -196		; PSR(N,V,Z,C) = 0
	and	%r11,0x3c
	;
	swap %r10, %r10			; A - n
	swap %r13, %r13
	sub %r10, %r13
	;
	ld.w %r13, %psr			; %psr(C1,V1)
	and	%r13,0xc	; 	xand %r13, %r13, 0xc
	;
	swap %r15, %r15			; A - n - c
	sub %r10, %r15
	;
	ld.w %r14, %psr			; %psr(C1|C2,V1^V2,Z2,N2)
	ext	0x4		; 	xand %r15, %r14, 0x4
	and	%r15,%r14
	xor %r13, %r15
	and	%r14,0xb	; 	xand %r14, %r14, 0xb
	or %r13, %r14
	ext	m6502_FLAG_CONV+0x0@h	; 	xld.ub %r13, [%r13+m6502_FLAG_CONV]	; PSR(N,V,Z,C)
	ext	m6502_FLAG_CONV+0x0@m
	ld.w	%r9,m6502_FLAG_CONV+0x0@l
	add	%r9,%r13
	ld.ub	%r13,[%r9]
	;
	swap %r10, %r10			; A
	ld.b	[%r12],%r10	; 	xld.b [%r12+0x0], %r10
	;
	xor	%r13,0x1	; 	xxor %r13, %r13, 1		; PSR(C) = ~PSR(C)
	or %r11, %r13			; PSR
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	;
	ret

	.global m6502_CMP
m6502_CMP:
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; PSR
	ld.ub	%r11,[%r12]
	swap %r13, %r13			; a - b
	swap %r14, %r14
	ext	0x1ffd		; 	xand %r11, %r11, -132		; PSR(N,Z,C) = 0
	and	%r11,0x3c
	sub %r13, %r14
	;
	ld.w %r13, %psr			; %psr(C,Z,N)
	and	%r13,0xb	; 	xand %r13, %r13, 0xb
	ext	m6502_FLAG_CONV+0x0@h	; 	xld.ub %r13, [%r13+m6502_FLAG_CONV]	; PSR(N,Z,C)
	ext	m6502_FLAG_CONV+0x0@m
	ld.w	%r9,m6502_FLAG_CONV+0x0@l
	add	%r9,%r13
	ld.ub	%r13,[%r9]
	;
	xor	%r13,0x1	; 	xxor %r13, %r13, 1		; PSR(C) = ~PSR(C) !INTERLOCK!
	or %r11, %r13			; PSR
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	;
	ret

;****************************************************************************

; ANZX́ujp.d %rbv͌듮삵AxXbgs܂񂪁A
;   ANZX́ujr<cond>.d sign8v͑vƔf܂B
;   ANZX́ujr<cond>.d sign8vgĂ܂B
;   Ă悤Ȃ̂ővƎv܂A
;   AVC邱Ƃ炱^ĂB

; ANZX́ucall.d %rbv͌듮삵܂Bi؍ς݁j

;#macro ADC_IMMEDIATE
;	xbtst [%r12+PSR], 3
;	xjreq.d m6502_ADC
;	ld.ub %r13, %r14		; *delay*
;	xjp m6502_ADCD
;#endm

;#macro SBC_IMMEDIATE
;	xbtst [%r12+PSR], 3
;	xjreq.d m6502_SBC
;	ld.ub %r13, %r14		; *delay*
;	xjp m6502_SBCD
;#endm

;#macro CPr_IMMEDIATE $1
;	xld.ub %r13, [%r12+$1]
;	xjp m6502_CMP
;#endm

;#macro ADC_ADDRESS
;	xsub %sp, %sp, 4
;	xld.w %r10, [%r12+READ]
;	xld.w [%sp+0], %r12		; (save m6502)
;	call.d %r10
;	ld.w %r13, %r14			; *delay*
;	xld.w %r12, [%sp+0]		; (restore m6502)
;	xadd %sp, %sp, 4
	;
;	xbtst [%r12+PSR], 3
;	xjreq.d m6502_ADC
;	ld.ub %r13, %r10		; *delay*
;	xjp m6502_ADCD
;#endm

;#macro SBC_ADDRESS
;	xsub %sp, %sp, 4
;	xld.w %r10, [%r12+READ]
;	xld.w [%sp+0], %r12		; (save m6502)
;	call.d %r10
;	ld.w %r13, %r14			; *delay*
;	xld.w %r12, [%sp+0]		; (restore m6502)
;	xadd %sp, %sp, 4
	;
;	xbtst [%r12+PSR], 3
;	xjreq.d m6502_SBC
;	ld.ub %r13, %r10		; *delay*
;	xjp m6502_SBCD
;#endm

;#macro CPr_ADDRESS $1
;	xsub %sp, %sp, 4
;	xld.w %r10, [%r12+READ]
;	xld.w [%sp+0], %r12		; (save m6502)
;	call.d %r10
;	ld.w %r13, %r14			; *delay*
;	xld.w %r12, [%sp+0]		; (restore m6502)
;	xadd %sp, %sp, 4
	;
;	xld.ub %r13, [%r12+$1]
;	xjp.d m6502_CMP
;	ld.w %r14, %r10			; *delay*
;#endm

;#macro INr_IMPLIED $1
;	xld.ub %r14, [%r12+$1]
;	xld.ub %r11, [%r12+PSR]		; *anti-interlock*
;	xadd %r14, %r14, 1		; *anti-interlock*
;	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
;	xld.b [%r12+$1], %r14
;	ld.ub %r14, %r14		; YȂŁI
;	xrr %r14, 8
;	ld.w %r14, %psr			; ????????_??????ZN
;	xsll %r14, 7			; ???????Z_N0000000
;	or %r11, %r14			; PSR(N)
;	xsrl %r14, 7			; ????????_??????ZN
;	xand %r14, %r14, 2		; 00000000_000000Z0
;	or %r11, %r14			; PSR(Z)
;	xld.b [%r12+PSR], %r11
;	ret
;#endm

;#macro DEr_IMPLIED $1
;	xld.ub %r14, [%r12+$1]
;	xld.ub %r11, [%r12+PSR]		; *anti-interlock*
;	xsub %r14, %r14, 1		; *anti-interlock*
;	xand %r11, %r11, ~0x82		; PSR(N,Z)=0
;	xld.b [%r12+$1], %r14
;	ld.ub %r14, %r14		; YȂŁI
;	xrr %r14, 8
;	ld.w %r14, %psr			; ????????_??????ZN
;	xsll %r14, 7			; ???????Z_N0000000
;	or %r11, %r14			; PSR(N)
;	xsrl %r14, 7			; ????????_??????ZN
;	xand %r14, %r14, 2		; 00000000_000000Z0
;	or %r11, %r14			; PSR(Z)
;	xld.b [%r12+PSR], %r11
;	ret
;#endm

;****************************************************************************

	.global m6502op_ADC_IMMEDIATE
m6502op_ADC_IMMEDIATE:
	ext	0x7		; 	xbtst [%r12+0x7], 0x3	; 	ADC_IMMEDIATE
	btst	[%r12],0x3
	jreq.d	m6502_ADC	; 	xjreq.d m6502_ADC
	ld.ub %r13, %r14		; *delay*
	ext	m6502_ADCD@rm	; 	xjp m6502_ADCD
	jp	m6502_ADCD@rl
	.global m6502op_SBC_IMMEDIATE
m6502op_SBC_IMMEDIATE:
	ext	0x7		; 	xbtst [%r12+0x7], 0x3	; 	SBC_IMMEDIATE
	btst	[%r12],0x3
	jreq.d	m6502_SBC	; 	xjreq.d m6502_SBC
	ld.ub %r13, %r14		; *delay*
	ext	m6502_SBCD@rm	; 	xjp m6502_SBCD
	jp	m6502_SBCD@rl
	.global m6502op_CMP_IMMEDIATE
m6502op_CMP_IMMEDIATE:
	ld.ub	%r13,[%r12]	; 	xld.ub %r13, [%r12+0x0]	; 	CPr_IMMEDIATE A
	jp	m6502_CMP	; 	xjp m6502_CMP
	.global m6502op_CPX_IMMEDIATE
m6502op_CPX_IMMEDIATE:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	CPr_IMMEDIATE X
	ld.ub	%r13,[%r12]
	jp	m6502_CMP	; 	xjp m6502_CMP
	.global m6502op_CPY_IMMEDIATE
m6502op_CPY_IMMEDIATE:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	CPr_IMMEDIATE Y
	ld.ub	%r13,[%r12]
	jp	m6502_CMP	; 	xjp m6502_CMP

	.global m6502op_ADC_ADDRESS
m6502op_ADC_ADDRESS:
	sub	%sp,0x1		; 	xsub %sp, %sp, 4	; 	ADC_ADDRESS
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w	[%sp+0x0],%r12	; 	xld.w [%sp+0x0], %r12		; (save m6502)
	call.d %r10
	ld.w %r13, %r14			; *delay*
	ld.w	%r12,[%sp+0x0]	; 	xld.w %r12, [%sp+0x0]		; (restore m6502)
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	;
	ext	0x7		; 	xbtst [%r12+0x7], 0x3
	btst	[%r12],0x3
	jreq.d	m6502_ADC	; 	xjreq.d m6502_ADC
	ld.ub %r13, %r10		; *delay*
	ext	m6502_ADCD@rm	; 	xjp m6502_ADCD
	jp	m6502_ADCD@rl
	.global m6502op_SBC_ADDRESS
m6502op_SBC_ADDRESS:
	sub	%sp,0x1		; 	xsub %sp, %sp, 4	; 	SBC_ADDRESS
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w	[%sp+0x0],%r12	; 	xld.w [%sp+0x0], %r12		; (save m6502)
	call.d %r10
	ld.w %r13, %r14			; *delay*
	ld.w	%r12,[%sp+0x0]	; 	xld.w %r12, [%sp+0x0]		; (restore m6502)
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	;
	ext	0x7		; 	xbtst [%r12+0x7], 0x3
	btst	[%r12],0x3
	jreq.d	m6502_SBC	; 	xjreq.d m6502_SBC
	ld.ub %r13, %r10		; *delay*
	ext	m6502_SBCD@rm	; 	xjp m6502_SBCD
	jp	m6502_SBCD@rl
	.global m6502op_CMP_ADDRESS
m6502op_CMP_ADDRESS:
	sub	%sp,0x1		; 	xsub %sp, %sp, 4	; 	CPr_ADDRESS A
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w	[%sp+0x0],%r12	; 	xld.w [%sp+0x0], %r12		; (save m6502)
	call.d %r10
	ld.w %r13, %r14			; *delay*
	ld.w	%r12,[%sp+0x0]	; 	xld.w %r12, [%sp+0x0]		; (restore m6502)
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	;
	ld.ub	%r13,[%r12]	; 	xld.ub %r13, [%r12+0x0]
	jp.d	m6502_CMP	; 	xjp.d m6502_CMP
	ld.w %r14, %r10			; *delay*
	.global m6502op_CPX_ADDRESS
m6502op_CPX_ADDRESS:
	sub	%sp,0x1		; 	xsub %sp, %sp, 4	; 	CPr_ADDRESS X
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w	[%sp+0x0],%r12	; 	xld.w [%sp+0x0], %r12		; (save m6502)
	call.d %r10
	ld.w %r13, %r14			; *delay*
	ld.w	%r12,[%sp+0x0]	; 	xld.w %r12, [%sp+0x0]		; (restore m6502)
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	jp.d	m6502_CMP	; 	xjp.d m6502_CMP
	ld.w %r14, %r10			; *delay*
	.global m6502op_CPY_ADDRESS
m6502op_CPY_ADDRESS:
	sub	%sp,0x1		; 	xsub %sp, %sp, 4	; 	CPr_ADDRESS Y
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w	[%sp+0x0],%r12	; 	xld.w [%sp+0x0], %r12		; (save m6502)
	call.d %r10
	ld.w %r13, %r14			; *delay*
	ld.w	%r12,[%sp+0x0]	; 	xld.w %r12, [%sp+0x0]		; (restore m6502)
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	jp.d	m6502_CMP	; 	xjp.d m6502_CMP
	ld.w %r14, %r10			; *delay*

	.global m6502op_INC_ADDRESS
m6502op_INC_ADDRESS:
	pushn %r1
	;
	ld.w %r1, %r14			; addr
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	add	%r10,0x1	; 	xadd %r10, %r10, 1
	ld.ub %r10, %r10		; YȂŁI
	;
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]
	ld.ub	%r11,[%r0]
	ld.w %r14, %r10			; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r0+0x7], %r11
	ld.b	[%r0],%r11
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global m6502op_DEC_ADDRESS
m6502op_DEC_ADDRESS:
	pushn %r1
	;
	ld.w %r1, %r14			; addr
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ld.ub %r10, %r10		; YȂŁI
	;
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]
	ld.ub	%r11,[%r0]
	ld.w %r14, %r10			; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r0+0x7], %r11
	ld.b	[%r0],%r11
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

	.global m6502op_INX_IMPLIED
m6502op_INX_IMPLIED:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]	; 	INr_IMPLIED X
	ld.ub	%r14,[%r12]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	add	%r14,0x1	; 	xadd %r14, %r14, 1		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ext	0x1		; 	xld.b [%r12+0x1], %r14
	ld.b	[%r12],%r14
	ld.ub %r14, %r14		; YȂŁI
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_INY_IMPLIED
m6502op_INY_IMPLIED:
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]	; 	INr_IMPLIED Y
	ld.ub	%r14,[%r12]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	add	%r14,0x1	; 	xadd %r14, %r14, 1		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ext	0x2		; 	xld.b [%r12+0x2], %r14
	ld.b	[%r12],%r14
	ld.ub %r14, %r14		; YȂŁI
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_DEX_IMPLIED
m6502op_DEX_IMPLIED:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]	; 	DEr_IMPLIED X
	ld.ub	%r14,[%r12]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	sub	%r14,0x1	; 	xsub %r14, %r14, 1		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ext	0x1		; 	xld.b [%r12+0x1], %r14
	ld.b	[%r12],%r14
	ld.ub %r14, %r14		; YȂŁI
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret
	.global m6502op_DEY_IMPLIED
m6502op_DEY_IMPLIED:
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]	; 	DEr_IMPLIED Y
	ld.ub	%r14,[%r12]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	sub	%r14,0x1	; 	xsub %r14, %r14, 1		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ext	0x2		; 	xld.b [%r12+0x2], %r14
	ld.b	[%r12],%r14
	ld.ub %r14, %r14		; YȂŁI
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSR(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	ret

;****************************************************************************
;	_Z
;****************************************************************************

	.global m6502op_AND_IMMEDIATE
m6502op_AND_IMMEDIATE:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	and %r10, %r14			; A &= arg *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ld.b	[%r12],%r10	; 	xld.b [%r12+0x0], %r10
	;
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	;
	ret

	.global m6502op_ORA_IMMEDIATE
m6502op_ORA_IMMEDIATE:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	or %r10, %r14			; A |= arg *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ld.b	[%r12],%r10	; 	xld.b [%r12+0x0], %r10
	;
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	;
	ret

	.global m6502op_EOR_IMMEDIATE
m6502op_EOR_IMMEDIATE:
	ld.ub	%r10,[%r12]	; 	xld.ub %r10, [%r12+0x0]
	ext	0x7		; 	xld.ub %r11, [%r12+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r12]
	xor %r10, %r14			; A ^= arg *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ld.b	[%r12],%r10	; 	xld.b [%r12+0x0], %r10
	;
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r12+0x7], %r11
	ld.b	[%r12],%r11
	;
	ret

	.global m6502op_AND_ADDRESS
m6502op_AND_ADDRESS:
	pushn %r0
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.ub	%r14,[%r0]	; 	xld.ub %r14, [%r0+0x0]
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r0]
	and %r10, %r14			; A &= READ(arg) *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ld.b	[%r0],%r10	; 	xld.b [%r0+0x0], %r10
	;
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r0+0x7], %r11
	ld.b	[%r0],%r11
	;
	popn %r0
	ret

	.global m6502op_ORA_ADDRESS
m6502op_ORA_ADDRESS:
	pushn %r0
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.ub	%r14,[%r0]	; 	xld.ub %r14, [%r0+0x0]
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r0]
	or %r10, %r14			; A |= READ(arg) *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ld.b	[%r0],%r10	; 	xld.b [%r0+0x0], %r10
	;
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r0+0x7], %r11
	ld.b	[%r0],%r11
	;
	popn %r0
	ret

	.global m6502op_EOR_ADDRESS
m6502op_EOR_ADDRESS:
	pushn %r0
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.ub	%r14,[%r0]	; 	xld.ub %r14, [%r0+0x0]
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]		; *anti-interlock*
	ld.ub	%r11,[%r0]
	xor %r10, %r14			; A ^= READ(arg) *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSR(N,Z)=0
	and	%r11,0x3d
	ld.b	[%r0],%r10	; 	xld.b [%r0+0x0], %r10
	;
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSR(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSR(Z)
	ext	0x7		; 	xld.b [%r0+0x7], %r11
	ld.b	[%r0],%r11
	;
	popn %r0
	ret

;****************************************************************************
;	t[
;****************************************************************************

;#macro Bcc_ADDRESS $1
;	xbtst [%r12+PSR], $1
;	xjreq $$1
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE--
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 1
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;#macro BNcc_ADDRESS $1
;	xbtst [%r12+PSR], $1
;	xjrne $$1
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE--
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 1
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;****************************************************************************

	.global m6502op_BCC_ADDRESS
m6502op_BCC_ADDRESS:
	ext	0x7		; 	xbtst [%r12+0x7], 0x0	; 	BNcc_ADDRESS 0
	btst	[%r12],0x0
	jrne	__LX0001	; 	xjrne __L0001
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0001:				; __L0001:
	ret
	.global m6502op_BCS_ADDRESS
m6502op_BCS_ADDRESS:
	ext	0x7		; 	xbtst [%r12+0x7], 0x0	; 	Bcc_ADDRESS 0
	btst	[%r12],0x0
	jreq	__LX0002	; 	xjreq __L0002
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0002:				; __L0002:
	ret
	.global m6502op_BNE_ADDRESS
m6502op_BNE_ADDRESS:
	ext	0x7		; 	xbtst [%r12+0x7], 0x1	; 	BNcc_ADDRESS 1
	btst	[%r12],0x1
	jrne	__LX0003	; 	xjrne __L0003
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0003:				; __L0003:
	ret
	.global m6502op_BEQ_ADDRESS
m6502op_BEQ_ADDRESS:
	ext	0x7		; 	xbtst [%r12+0x7], 0x1	; 	Bcc_ADDRESS 1
	btst	[%r12],0x1
	jreq	__LX0004	; 	xjreq __L0004
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0004:				; __L0004:
	ret
	.global m6502op_BVC_ADDRESS
m6502op_BVC_ADDRESS:
	ext	0x7		; 	xbtst [%r12+0x7], 0x6	; 	BNcc_ADDRESS 6
	btst	[%r12],0x6
	jrne	__LX0005	; 	xjrne __L0005
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0005:				; __L0005:
	ret
	.global m6502op_BVS_ADDRESS
m6502op_BVS_ADDRESS:
	ext	0x7		; 	xbtst [%r12+0x7], 0x6	; 	Bcc_ADDRESS 6
	btst	[%r12],0x6
	jreq	__LX0006	; 	xjreq __L0006
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0006:				; __L0006:
	ret
	.global m6502op_BPL_ADDRESS
m6502op_BPL_ADDRESS:
	ext	0x7		; 	xbtst [%r12+0x7], 0x7	; 	BNcc_ADDRESS 7
	btst	[%r12],0x7
	jrne	__LX0007	; 	xjrne __L0007
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0007:				; __L0007:
	ret
	.global m6502op_BMI_ADDRESS
m6502op_BMI_ADDRESS:
	ext	0x7		; 	xbtst [%r12+0x7], 0x7	; 	Bcc_ADDRESS 7
	btst	[%r12],0x7
	jreq	__LX0008	; 	xjreq __L0008
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0008:				; __L0008:
	ret

	.global m6502op_BRK_IMPLIED
m6502op_BRK_IMPLIED:
	ext	m6502_brk@rm	; 	xcall m6502_brk
	call	m6502_brk@rl
	ret
	.global m6502op_JMP_ADDRESS
m6502op_JMP_ADDRESS:
	ext	0x4		; 	xld.h [%r12+0x4], %r14
	ld.h	[%r12],%r14
	ret

	.global m6502op_JSR_ADDRESS
m6502op_JSR_ADDRESS:
	pushn %r2
	;
	ext	0x6		; 	xld.ub %r1, [%r12+0x6]		; SP|0x100
	ld.ub	%r1,[%r12]
	ext	0x4		; 	xld.uh %r2, [%r12+0x4]		; PC--(dl) *anti-interlock*
	ld.uh	%r2,[%r12]
	ext	0x4		; 	xoor %r1, %r1, 0x100		;            *anti-interlock*
	or	%r1,0x0
	sub	%r2,0x1		; 	xsub %r2, %r2, 1
	;
	ext	0x4		; 	xld.h [%r12+0x4], %r14		; PC <= arg
	ld.h	[%r12],%r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; PUSH(PCH)
	ld.w	%r10,[%r12]
	ld.w %r13, %r1
	ld.uh %r14, %r2
	srl	%r14,0x8	; 	xsrl %r14, 8
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	;				; SP|0x100 == 0x100      `0x1ff
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; -1       => 0x0ff      `0x1fe
	ext	0x4		; 	xoor %r1, %r1, 0x100		;   |0x100 => 0x1ff,0x100`0x1fe
	or	%r1,0x0
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; PUSH(PCL)
	ld.w	%r10,[%r0]
	ld.w %r13, %r1
	ld.ub %r14, %r2
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ext	0x6		; 	xld.b [%r0+0x6], %r1
	ld.b	[%r0],%r1
	;
	popn %r2
	ret

	.global m6502op_RTS_IMPLIED
m6502op_RTS_IMPLIED:
	pushn %r2
	;
	ext	0x6		; 	xld.ub %r1, [%r12+0x6]		; SP         == 0x000`      0x0ff
	ld.ub	%r1,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++       => 0x001`      0x100
	ext	0x4		; 	xoor %r1, %r1, 0x100		; SP++|0x100 => 0x101`0x1ff,0x100
	or	%r1,0x0
	;
	ld.w %r13, %r1			; POP(PCL)
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r2, %r10			; (save PCL)
	;
	;				; SP|0x100 == 0x100`      0x1ff
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; +1       => 0x101`      0x200
	ld.ub %r1, %r1			;          => 0x001`0x0ff,0x000
	ext	0x4		; 	xoor %r1, %r1, 0x100		;   |0x100 => 0x101`0x1ff,0x100
	or	%r1,0x0
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]		; POP(PCH)
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	sll	%r10,0x8	; 	xsll %r10, 8			; PC = PCL | PCH << 8
	or %r10, %r2
	add	%r10,0x1	; 	xadd %r10, %r10, 1		; PC++(dl)
	ext	0x4		; 	xld.h [%r0+0x4], %r10
	ld.h	[%r0],%r10
	;
	ext	0x6		; 	xld.b [%r0+0x6], %r1		; SP
	ld.b	[%r0],%r1
	;
	popn %r2
	ret

	.global m6502op_RTI_IMPLIED
m6502op_RTI_IMPLIED:
	pushn %r1
	;
	ext	0x6		; 	xld.ub %r1, [%r12+0x6]		; SP         == 0x000`      0x0ff
	ld.ub	%r1,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++       => 0x001`      0x100
	ext	0x4		; 	xoor %r1, %r1, 0x100		; SP++|0x100 => 0x101`0x1ff,0x100
	or	%r1,0x0
	;
	ld.w %r13, %r1			; POP(PSR)
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x0		; 	xoor %r10, %r10, 0x20		; PSR(R) = 1
	or	%r10,0x20
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	;				; SP|0x100 == 0x100`      0x1ff
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; +1       => 0x101`      0x200
	ld.ub %r1, %r1			;          => 0x001`0x0ff,0x000
	ext	0x4		; 	xoor %r1, %r1, 0x100		;   |0x100 => 0x101`0x1ff,0x100
	or	%r1,0x0
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]		; POP(PCL)
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10	; PCL
	ld.b	[%r0],%r10
	;
	;				; SP|0x100 == 0x100`      0x1ff
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; +1       => 0x101`      0x200
	ld.ub %r1, %r1			;          => 0x001`0x0ff,0x000
	ext	0x4		; 	xoor %r1, %r1, 0x100		;   |0x100 => 0x101`0x1ff,0x100
	or	%r1,0x0
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]		; POP(PCH)
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x5		; 	xld.b [%r0+0x5], %r10	; PCH
	ld.b	[%r0],%r10
	;
	ext	0x6		; 	xld.b [%r0+0x6], %r1		; SP
	ld.b	[%r0],%r1
	;
	popn %r1
	ret

;****************************************************************************
;	
;****************************************************************************

;#endif /*M6502_ASM*/
