/*	
 *	framm65.c
 *
 *	P/ECE MOS6502 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Dec 07 12:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Fri Dec 19 06:00:00 JST 2003 Naoyuki Sawa
 *	- WAI(W65C02g)̃T|[gǉB
 *	* Wed Mar 16 06:54:00 JST 2005 Naoyuki Sawa
 *	- m6502_SBCD()̃oOC܂B
 */
#include "clip.h"
#include "clipm65i.h"	/*M6502G~[^p}N*/

/* TODO: y[W܂̒ǉTCNlĂ܂B
 *         @ȂTCNŎsĂ܂܂B
 */

/****************************************************************************
 *	M6502RÃCREAD/WRITEO֐
 ****************************************************************************/

/* M6502\(24oCg)̒ɃCzuĂ邱Ƃ肵܂B
 * oCiCAEgقȂꍇAoNؑւȂǂ̓ᏈKvȏꍇ́A
 * AvP[V`̊O֐pӂĂB
 */

#ifndef M6502_ASM	/****************************************************/

unsigned char
m6502_internal_read(M6502* m6502, unsigned short addr)
{
	return ((unsigned char*)(m6502 + 1))[addr];
}
void
m6502_internal_write(M6502* m6502, unsigned short addr, unsigned char data)
{
	((unsigned char*)(m6502 + 1))[addr] = data;
}

#else	/********************************************************************/

asm("
	.code
	.align 1
	.global m6502_internal_read
m6502_internal_read:
	add %r12, %r13
	xld.ub %r10, [%r12+24]
	ret
");
asm("
	.code
	.align 1
	.global m6502_internal_write
m6502_internal_write:
	add %r12, %r13
	xld.b [%r12+24], %r14
	ret
");

#endif	/********************************************************************/

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef M6502_ASM

void
m6502_run(M6502* m6502, int cycle)
{
	unsigned char code;
	const M6502OP* op;
	unsigned char arg1;
	unsigned char arg2;
	unsigned short arg = 0; /* x} */

	CYCLE = cycle;
	while(!WAIT && CYCLE > 0) {
#ifdef M6502_TRACE
		m6502_dump(m6502);
#endif /*M6502_TRACE*/
		M6502TRACE("%04x: ", PC);
		FETCH(code);
		op = &m6502_op_table[code];
		switch(op->mode) {
		/*==== bytes=1 ====*/
		case M6502_IMPLIED:
			break;
		case M6502_ACCUMULATOR:
			break;
		/*==== bytes=2 ====*/
		case M6502_IMMEDIATE:
			FETCH(arg1);
			arg = arg1;
			break;
		case M6502_RELATIVE:
			FETCH(arg1);
			arg = PC + (char)arg1;
			break;
		case M6502_ZEROPAGE:
			FETCH(arg1);
			arg = arg1;
			break;
		case M6502_ZEROPAGE_X:
			FETCH(arg1);
			arg1 += X;
			arg = arg1;
			break;
		case M6502_ZEROPAGE_Y:
			FETCH(arg1);
			arg1 += Y;
			arg = arg1;
			break;
		case M6502_INDIRECT_X:
			FETCH(arg1);
			arg1 += X; /* (addr,X) */
			arg = READ(arg1) | READ((arg1 + 1) & 0xff) << 8;
			break;
		case M6502_INDIRECT_Y:
			FETCH(arg1);
			arg = READ(arg1) | READ((arg1 + 1) & 0xff) << 8;
			arg += Y; /* (addr),Y */
			break;
		/*==== bytes=3 ====*/
		case M6502_ABSOLUTE:
			FETCH(arg1);
			FETCH(arg2);
			arg = arg1 | arg2 << 8;
			break;
		case M6502_ABSOLUTE_X:
			FETCH(arg1);
			FETCH(arg2);
			arg = arg1 | arg2 << 8;
			arg += X;
			break;
		case M6502_ABSOLUTE_Y:
			FETCH(arg1);
			FETCH(arg2);
			arg = arg1 | arg2 << 8;
			arg += Y;
			break;
		case M6502_INDIRECT:
			FETCH(arg1);
			FETCH(arg2);
			arg = arg1 | arg2 << 8;
			arg = READ16(arg);
			break;
#ifndef PIECE /* P/ECEł͍RAMŝ߃Jbg */
		default:
			DIE();
#endif /*PIECE*/
		}
		EXEC();
		M6502TRACE("\n");
	}
}

#endif /*M6502_ASM*/

/****************************************************************************
 *	
 ****************************************************************************/

#define TEST(n)		do { PSR = (PSR & ~0x82) | ((n) & 0x80) | (!(n) << 1); } while(0)

/****************************************************************************
 *	f[^]
 ****************************************************************************/

#ifndef M6502_ASM

M6502FN_(LDA_IMMEDIATE  ) { A = (unsigned char)arg; TEST(A); }
M6502FN_(LDX_IMMEDIATE  ) { X = (unsigned char)arg; TEST(X); }
M6502FN_(LDY_IMMEDIATE  ) { Y = (unsigned char)arg; TEST(Y); }

M6502FN_(LDA_ADDRESS    ) { A = READ(arg); TEST(A); }
M6502FN_(LDX_ADDRESS    ) { X = READ(arg); TEST(X); }
M6502FN_(LDY_ADDRESS    ) { Y = READ(arg); TEST(Y); }

M6502FN_(STA_ADDRESS    ) { WRITE(arg, A); }
M6502FN_(STX_ADDRESS    ) { WRITE(arg, X); }
M6502FN_(STY_ADDRESS    ) { WRITE(arg, Y); }

M6502FN_(TXA_IMPLIED    ) { A = X; TEST(A); }
M6502FN_(TYA_IMPLIED    ) { A = Y; TEST(A); }
M6502FN_(TAX_IMPLIED    ) { X = A; TEST(X); }
M6502FN_(TAY_IMPLIED    ) { Y = A; TEST(Y); }
M6502FN_(TSX_IMPLIED    ) { X = SP; TEST(X); }
M6502FN_(TXS_IMPLIED    ) { SP = X; /* NO FLAGS AFFECTED */ }

M6502FN_(PHA_IMPLIED    ) { PUSH(A); }
M6502FN_(PHP_IMPLIED    ) { PUSH(PSR); }
M6502FN_(PLA_IMPLIED    ) { PULL(A); TEST(A); }
M6502FN_(PLP_IMPLIED    ) { PULL(PSR); PSR |= 0x20; }

#endif /*M6502_ASM*/

/****************************************************************************
 *	ZpZ
 ****************************************************************************/

#ifndef M6502_ASM

#define ADC(n)		m6502_ADC(m6502, (unsigned char)(n))
void m6502_ADC(M6502* m6502, unsigned char n) {
	int c = PSR & 1;
	int tmp = A + n + c;
	PSR = (PSR & ~0xc3) |
	      (tmp & 0x80) |				/* N */
	      ((~(A ^ n) & (A ^ tmp) & 0x80) >> 1) |	/* V */
	      (!(tmp & 0xff) << 1) |			/* Z */
	      ((tmp >> 8) & 1);				/* C */
	A = tmp;
}

#define SBC(n)		m6502_SBC(m6502, (unsigned char)(n))
void m6502_SBC(M6502* m6502, unsigned char n) {
	int c = ~PSR & 1;
	int tmp = A - n - c;
	PSR = (PSR & ~0xc3) |
	      (tmp & 0x80) |				/* N */
	      (((A ^ n) & (A ^ tmp) & 0x80) >> 1) |	/* V */
	      (!(tmp & 0xff) << 1) |			/* Z */
	      (~(tmp >> 8) & 1);			/* C */
	A = tmp;
}

#define CMP(a, b)	m6502_CMP(m6502, (unsigned char)(a), (unsigned char)(b))
void m6502_CMP(M6502* m6502, unsigned char a, unsigned char b) {
	int tmp = a - b;
	PSR = (PSR & ~0x83) |
	      (tmp & 0x80) |				/* N */
	      (!tmp << 1) |				/* Z */
	      (~(tmp >> 8) & 1);			/* C */
}

#endif /*M6502_ASM*/

#define ADCD(n)		m6502_ADCD(m6502, (unsigned char)(n))
void m6502_ADCD(M6502* m6502, unsigned char n) {
	int c = PSR & 1;
	int lo = (A & 0x0f) + (n & 0x0f) + c;
	int hi = (A & 0xf0) + (n & 0xf0);
	if(lo > 0x09) {
		lo += 0x06;
		hi += 0x10;
	}
	PSR = (PSR & ~0xc3) |
	      (hi & 0x80) |				/* N */
	      ((~(A ^ n) & (A ^ hi) & 0x80) >> 1);	/* V */
	if(hi > 0x90) {
		hi += 0x60;
	}
	A = (lo & 0x0f) | (hi & 0xf0);
	PSR |= (!A << 1) |				/* Z */
	       ((hi >> 8) & 1);				/* C */
}

#define SBCD(n)		m6502_SBCD(m6502, (unsigned char)(n))
void m6502_SBCD(M6502* m6502, unsigned char n) {
	int c = ~PSR & 1;
	int lo = (A & 0x0f) - (n & 0x0f) - c;
	int hi = (A & 0xf0) - (n & 0xf0);
	//if(lo > 0x09) {
	//2005/03/16C
	if(lo & 0x10) {
		lo -= 0x06;
		hi -= 0x10;
	}
	PSR = (PSR & ~0xc3) |
	      (hi & 0x80) |				/* N */
	      (((A ^ n) & (A ^ hi) & 0x80) >> 1);	/* V */
	//if(hi > 0x90) {
	//2005/03/16C
	if(hi & 0x100) {
		hi -= 0x60;
	}
	A = (lo & 0x0f) | (hi & 0xf0);
	PSR |= (!A << 1) |				/* Z */
	       (~(hi >> 8) & 1);			/* C */
}

/****************************************************************************/

#ifndef M6502_ASM

M6502FN_(ADC_IMMEDIATE  ) { if(!(PSR & 8)) { ADC(arg); } else { ADCD(arg); } }
M6502FN_(SBC_IMMEDIATE  ) { if(!(PSR & 8)) { SBC(arg); } else { SBCD(arg); } }
M6502FN_(CMP_IMMEDIATE  ) { CMP(A, arg); }
M6502FN_(CPX_IMMEDIATE  ) { CMP(X, arg); }
M6502FN_(CPY_IMMEDIATE  ) { CMP(Y, arg); }

M6502FN_(ADC_ADDRESS    ) { if(!(PSR & 8)) { ADC(READ(arg)); } else { ADCD(READ(arg)); } }
M6502FN_(SBC_ADDRESS    ) { if(!(PSR & 8)) { SBC(READ(arg)); } else { SBCD(READ(arg)); } }
M6502FN_(CMP_ADDRESS    ) { CMP(A, READ(arg)); }
M6502FN_(CPX_ADDRESS    ) { CMP(X, READ(arg)); }
M6502FN_(CPY_ADDRESS    ) { CMP(Y, READ(arg)); }

M6502FN_(INC_ADDRESS    ) { unsigned char n = READ(arg) + 1; TEST(n); WRITE(arg, n); }
M6502FN_(DEC_ADDRESS    ) { unsigned char n = READ(arg) - 1; TEST(n); WRITE(arg, n); }

M6502FN_(INX_IMPLIED    ) { X++; TEST(X); }
M6502FN_(INY_IMPLIED    ) { Y++; TEST(Y); }
M6502FN_(DEX_IMPLIED    ) { X--; TEST(X); }
M6502FN_(DEY_IMPLIED    ) { Y--; TEST(Y); }

#endif /*M6502_ASM*/

/****************************************************************************
 *	_Z
 ****************************************************************************/

#define ASLA()		m6502_ASLA(m6502)
void m6502_ASLA(M6502* m6502) {
	unsigned char tmp = A << 1;
	PSR = (PSR & ~0x83) |
	      (tmp & 0x80) |		/* N */
	      (!tmp << 1) |		/* Z */
	      (A >> 7);			/* C */
	A = tmp;
}

#define ASL(addr)	m6502_ASL(m6502, (unsigned short)(addr))
void m6502_ASL(M6502* m6502, unsigned short addr) {
	unsigned char n = READ(addr);
	unsigned char tmp = n << 1;
	PSR = (PSR & ~0x83) |
	      (tmp & 0x80) |		/* N */
	      (!tmp << 1) |		/* Z */
	      (n >> 7);			/* C */
	WRITE(addr, tmp);
}

#define LSRA()		m6502_LSRA(m6502)
void m6502_LSRA(M6502* m6502) {
	unsigned char tmp = A >> 1;
	PSR = (PSR & ~0x83) |
					/* N */
	      (!tmp << 1) |		/* Z */
	      (A & 1);			/* C */
	A = tmp;
}

#define LSR(addr)	m6502_LSR(m6502, (unsigned short)(addr))
void m6502_LSR(M6502* m6502, unsigned short addr) {
	unsigned char n = READ(addr);
	unsigned char tmp = n >> 1;
	PSR = (PSR & ~0x83) |
					/* N */
	      (!tmp << 1) |		/* Z */
	      (n & 1);			/* C */
	WRITE(addr, tmp);
}

#define ROLA()		m6502_ROLA(m6502)
void m6502_ROLA(M6502* m6502) {
	unsigned char tmp = (A << 1) | (PSR & 1);
	PSR = (PSR & ~0x83) |
	      (tmp & 0x80) |		/* N */
	      (!tmp << 1) |		/* Z */
	      (A >> 7);			/* C */
	A = tmp;
}

#define ROL(addr)	m6502_ROL(m6502, (unsigned short)(addr))
void m6502_ROL(M6502* m6502, unsigned short addr) {
	unsigned char n = READ(addr);
	unsigned char tmp = (n << 1) | (PSR & 1);
	PSR = (PSR & ~0x83) |
	      (tmp & 0x80) |		/* N */
	      (!tmp << 1) |		/* Z */
	      (n >> 7);			/* C */
	WRITE(addr, tmp);
}

#define RORA()		m6502_RORA(m6502)
void m6502_RORA(M6502* m6502) {
	unsigned char tmp = (A >> 1) | (PSR << 7);
	PSR = (PSR & ~0x83) |
	      (tmp & 0x80) |		/* N */
	      (!tmp << 1) |		/* Z */
	      (A & 1);			/* C */
	A = tmp;
}

#define ROR(addr)	m6502_ROR(m6502, (unsigned short)(addr))
void m6502_ROR(M6502* m6502, unsigned short addr) {
	unsigned char n = READ(addr);
	unsigned char tmp = (n >> 1) | (PSR << 7);
	PSR = (PSR & ~0x83) |
	      (tmp & 0x80) |		/* N */
	      (!tmp << 1) |		/* Z */
	      (n & 1);			/* C */
	WRITE(addr, tmp);
}

#define BIT(addr)	m6502_BIT(m6502, (unsigned short)(addr))
void m6502_BIT(M6502* m6502, unsigned short addr) {
	unsigned char tmp = READ(addr);
	PSR = (PSR & ~0xc2) |
	      (tmp & 0xc0) |		/* N,V */
	      (!(A & tmp) << 1);	/* Z */
}

/****************************************************************************/

#ifndef M6502_ASM

M6502FN_(AND_IMMEDIATE  ) { A &= arg; TEST(A); }
M6502FN_(ORA_IMMEDIATE  ) { A |= arg; TEST(A); }
M6502FN_(EOR_IMMEDIATE  ) { A ^= arg; TEST(A); }

M6502FN_(AND_ADDRESS    ) { A &= READ(arg); TEST(A); }
M6502FN_(ORA_ADDRESS    ) { A |= READ(arg); TEST(A); }
M6502FN_(EOR_ADDRESS    ) { A ^= READ(arg); TEST(A); }

#endif /*M6502_ASM*/

M6502FN_(ASL_ACCUMULATOR) { ASLA(); }
M6502FN_(LSR_ACCUMULATOR) { LSRA(); }
M6502FN_(ROL_ACCUMULATOR) { ROLA(); }
M6502FN_(ROR_ACCUMULATOR) { RORA(); }

M6502FN_(ASL_ADDRESS    ) { ASL(arg); }
M6502FN_(LSR_ADDRESS    ) { LSR(arg); }
M6502FN_(ROL_ADDRESS    ) { ROL(arg); }
M6502FN_(ROR_ADDRESS    ) { ROR(arg); }
M6502FN_(BIT_ADDRESS    ) { BIT(arg); }

/****************************************************************************
 *	t[
 ****************************************************************************/

#ifndef M6502_ASM

M6502FN_(BCC_ADDRESS    ) { if(!(PSR &    1)) { PC = arg; CYCLE--; } }
M6502FN_(BCS_ADDRESS    ) { if( (PSR &    1)) { PC = arg; CYCLE--; } }
M6502FN_(BNE_ADDRESS    ) { if(!(PSR &    2)) { PC = arg; CYCLE--; } }
M6502FN_(BEQ_ADDRESS    ) { if( (PSR &    2)) { PC = arg; CYCLE--; } }
M6502FN_(BVC_ADDRESS    ) { if(!(PSR & 0x40)) { PC = arg; CYCLE--; } }
M6502FN_(BVS_ADDRESS    ) { if( (PSR & 0x40)) { PC = arg; CYCLE--; } }
M6502FN_(BPL_ADDRESS    ) { if(!(PSR & 0x80)) { PC = arg; CYCLE--; } }
M6502FN_(BMI_ADDRESS    ) { if( (PSR & 0x80)) { PC = arg; CYCLE--; } }

M6502FN_(BRK_IMPLIED    ) { m6502_brk(m6502); }
M6502FN_(JMP_ADDRESS    ) { PC = arg; }
M6502FN_(JSR_ADDRESS    ) { PC--/*dl*/; PUSH(PCH); PUSH(PCL); PC = arg; }
M6502FN_(RTS_IMPLIED    ) { PULL(PCL); PULL(PCH); PC++/*dl*/; }
M6502FN_(RTI_IMPLIED    ) { PULL(PSR); PSR |= 0x20; PULL(PCL); PULL(PCH); }

#endif /*M6502_ASM*/

/****************************************************************************
 *	̑
 ****************************************************************************/

M6502FN_(SEC_IMPLIED    ) { PSR |= 1; }
M6502FN_(SEI_IMPLIED    ) { PSR |= 4; }
M6502FN_(SED_IMPLIED    ) { PSR |= 8; }

M6502FN_(CLC_IMPLIED    ) { PSR &= ~   1; }
M6502FN_(CLI_IMPLIED    ) { PSR &= ~   4; }
M6502FN_(CLD_IMPLIED    ) { PSR &= ~   8; }
M6502FN_(CLV_IMPLIED    ) { PSR &= ~0x40; }

M6502FN_(NOP_IMPLIED    ) { /* nop */ }
M6502FN_(WAI_IMPLIED    ) { WAIT = 1; }

