/*
 *	framhfm.c
 *
 *	Canonical Huffman Code
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Fri Nov 21 20:05:45 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- L̋LQlɂ܂B
 *	  uɕ^sŏ璷uCanonical Huffman Codevv(http://codezine.jp/article/detail/376)
 *	  (_E[hāukeep/ɕ^sŏ璷uCanonical Huffman Codev.7zvɕۑĂ܂B)
 *	  ASY͎Qlɂ܂ATv\[X̎͂悭łȂ̂ŁAقڐVKɎ܂B
 *	  Tv\[XAW[̎̕AfR[_̃tbgvgāAP/ECEɓKĂƎv܂B
 *	  ܂AkɊi[镄\ςނ悤Hv̂ŁATv\[XW[̎̕A͂ɈkłB
 *	  ɁATv\[X͌f[^̃TCYwb_Ɋi[Ă܂AW[͏I[Ŕf_ADĂƎv܂B
 *	* Sat Nov 22 10:24:01 JST 2014 Naoyuki Sawa
 *	- kf[^̍쐬́ADOSR}hCc[utool/dphfmv𗘗pĂB
 *	* Sat Nov 22 14:56:38 JST 2014 Naoyuki Sawa
 *	- HuffmanDecoder_Getc()AZu܂B
 *	  HuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA1.106b˖0.790bɍ܂B(Clock=48MHz,Code=SRAM,Stack=FRAM)
 *	* Sat Nov 22 16:01:39 JST 2014 Naoyuki Sawa
 *	- HuffmanDecoder_Init()AZu܂B
 *	  R[hTCY12oCgȂ܂Bxɂ͂قƂǉe܂B
 *	* Sat Nov 22 17:24:18 JST 2014 Naoyuki Sawa
 *	- HuffmanDecoder_Decode()AZu܂B
 *	  HuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA0.790b˖0.759bɍ܂B(Clock=48MHz,Code=SRAM,Stack=FRAM)
 *	* Sun Nov 23 01:00:09 JST 2014 Naoyuki Sawa
 *	- cliphfm.cAfR[_[framhfm.cɕ܂B
 *	  P/ECEł̓fR[_[gpȂƂ̂ŁAɃGR[_[Nėeʂ邱Ƃh߂łB
 *	  framhfm.cRAMɔzuāA邱Ƃ\łB
 *	  framhfm.cRAMɔzuƁAHuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA0.759b˖0.419bɍ܂B(Clock=48MHz,Code=FRAM,Stack=FRAM)
 *	* Sun Nov 23 21:49:53 JST 2014 Naoyuki Sawa
 *	- HuffmanDecoder_Getc()ɁAuHvvZvKp܂B(CłƃAZuł̗)
 *	  HuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA0.759b˖0.756bɍ܂B(Clock=48MHz,Code=SRAM,Stack=FRAM)
 */
#include "clip.h"

/****************************************************************************
 *	nt}fR[_[
 ****************************************************************************/
//kf[^ŜfR[hAkf[^쐬B
// - srćA32bitEɐ񂳂ꂽkf[^ł邱ƁBdst̓ACgsvB
// - kf[^dstBytes𒴂ꍇ́Az͊i[ȂB
//   i[̉ۂɊ֌WȂA߂ĺAkf[^̃oCgłB
//   ̐𗘗pāAڂ(dst=NULL,dstBytes=0)ŌĂяoAKvȃobt@TCYmF,mۂAēxĂяo@\łB
//   <>
//   dstBytes=HuffmanDecoder_Decode(src,NULL,0);
//   dst=malloc(dstBytes);
//   HuffmanDecoder_Decode(src,dst,dstBytes);
#ifndef PIECE
int HuffmanDecoder_Decode(const void* src, void* _dst, int dstBytes) {
	ST_HuffmanDecoder stHuffmanDecoder;
	unsigned char* dst = _dst;
	int value, dstPos = 0;
	HuffmanDecoder_Init(&stHuffmanDecoder, src);				//nt}fR[_[B
	while((value = HuffmanDecoder_Getc(&stHuffmanDecoder)) != -1) {		//PoCgfR[hB
		if(dstPos++ < dstBytes) { *dst++ = value; }			//kf[^i[B
	}
	return dstPos;								//kf[^̃oCgԂB
}
#else //PIECE
int HuffmanDecoder_Decode(const void* src, void* _dst, int dstBytes);
#if 0		//'fȎ''Hv'̂ǂgĂAʂ͓łB݂̂ƂA'Hv'gƂɂ܂B
//fȎB
asm("
		.code
		.align		1
		.global		HuffmanDecoder_Decode
HuffmanDecoder_Decode:
		pushn		%r2
		xsub		%sp, %sp, 8					;//%sp  := &stHuffmanDecoder
		ld.w		%r0, %r13					;//%r0  := dst
		ld.w		%r1, %r14					;//%r1  := dstBytes
		ld.w		%r13, %r12					;//%r13 := src
		ld.w		%r12, %sp					;//%r12 :=             &stHuffmanDecoder
		xcall.d		HuffmanDecoder_Init				;//HuffmanDecoder_Init(&stHuffmanDecoder, src)
		ld.w		%r2, 0						;//%r2  := dstPos = 0						*delay*
		;//%sp  := &stHuffmanDecoder
		;//%r0  := dst
		;//%r1  := dstBytes
		;//%r2  := dstPos
HuffmanDecoder_Decode_LOOP:							;//for(;;) {
		ld.w		%r12, %sp					;//  %r12 :=                             &stHuffmanDecoder
		xcall		HuffmanDecoder_Getc				;//  %r10 := value = HuffmanDecoder_Getc(&stHuffmanDecoder)
		cmp		%r10, -1					;//  if(value == -1) { break }
		jreq		HuffmanDecoder_Decode_RET
		cmp		%r2, %r1					;//  if(dstPos < dstBytes) {
		jrge.d		3
		 add		%r2, 1						;//  %r2  := dstPos++						*delay*
		 ld.b		[%r0]+, %r10					;//    *dst++ = value }
		jp		HuffmanDecoder_Decode_LOOP
HuffmanDecoder_Decode_RET:							;//}
		ld.w		%r10, %r2					;//%r10 := dstPos
		xadd		%sp, %sp, 8
		popn		%r2
		ret
");
#else
//HvBfȎ4oCg邪B
asm("
		.code
		.align		1
		.global		HuffmanDecoder_Decode
HuffmanDecoder_Decode:
		pushn		%r3
		xsub		%sp, %sp, 8					;//%sp  := &stHuffmanDecoder
		ld.w		%r0, %sp					;//%r0  := &stHuffmanDecoder							%sp̂܂܂ł́Acall̒xXbgŊɕωĂ̂ŁA%r0ɂRs[ĂB
		ld.w		%r1, %r13					;//%r1  := dst
		ld.w		%r2, %r14					;//%r2  := dstBytes
		ld.w		%r13, %r12					;//%r13 := src
		xcall.d		HuffmanDecoder_Init				;//HuffmanDecoder_Init(&stHuffmanDecoder, src)
		ld.w		%r12, %r0					;//%r12 :=             &stHuffmanDecoder			*delay*
		jp.d		HuffmanDecoder_Decode_START			;//goto START
		ld.w		%r3, -1						;//%r3  := dstPos = -1						*delay*		Ō̃[v𔲂鎞vCNg镪ƑE邽(-1)ɏB
		;//%sp  := &stHuffmanDecoder
		;//%r0  := &stHuffmanDecoder
		;//%r1  := dst
		;//%r2  := dstBytes
		;//%r3  := dstPos
HuffmanDecoder_Decode_LOOP:							;//do {
		cmp		%r3, %r2					;//  if(dstPos < dstBytes) {							vCNgł邪r(<=)ɕύXȂ悤ӂB(-1)ɏĂ̂ŃvCNgƂ͑Eς݂łB]Ĕr'fȎ'ƕςȂB
		jrge		2
		 ld.b		[%r1]+, %r10					;//    *dst++ = value }
HuffmanDecoder_Decode_START:
		xcall.d		HuffmanDecoder_Getc				;//  %r10 := value = HuffmanDecoder_Getc(&stHuffmanDecoder)
		ld.w		%r12, %r0					;//  %r12 :=                             &stHuffmanDecoder	*delay*
		cmp		%r10, -1					;//} while(value != -1)
		jrne.d		HuffmanDecoder_Decode_LOOP			;//
		add		%r3, 1						;//  %r3  := dstPos++						*delay*
		ld.w		%r10, %r3					;//%r10 := dstPos
		xadd		%sp, %sp, 8
		popn		%r3
		ret
");
#endif
#endif//PIECE
/*--------------------------------------------------------------------------*/
//nt}fR[_[B
#ifndef PIECE
void HuffmanDecoder_Init(ST_HuffmanDecoder* pHuffmanDecoder, const void* src) {
	const unsigned char* hdr;
	int codeLenMask, codeLenCount;
	//--- \ǂݔ΂ ---
	pHuffmanDecoder->src = src;						//\̃AhXi[B
	//\́̕Abitarray_msb1st_getł͂ȂA(codeLenMask+oCgz)ƌȂăANZXBGR[_ƃfR[_ŃANZX@킹ȂƁAoCgz񕔕̏vȂ̂ŒӂB
	hdr         = pHuffmanDecoder->src;
	codeLenMask = *(int*)hdr;
	hdr        += 4;
	do {									//codeLenMaskŏ0ꍇɂAʂ1񏈗Ă܂Auif(codeLenMask<0)vŏÔŁAʂ͐mł薳BAcodeLenMaskŏ0ɂȂ̂́Ak̃f[^0oCgꍇ݂̂łAʏ̉e͏͂BȃAP[XAʏ̏D悵Bwhile(){`}Ado{`}while()̕AB
		if(codeLenMask < 0) {						//fR[_asḿAuadd %rX,%rX;jruge `vŏB
			codeLenCount = *hdr++ + 1;				//GR[_(-1)ƃfR[_(+1)EāA(1`256)ɕB
			hdr += codeLenCount;					//Ɋ蓖ĂĂl̃Xgǂݔ΂B
		}
	} while(codeLenMask <<= 1);
	pHuffmanDecoder->srcPos = ((int)hdr - (int)pHuffmanDecoder->src) << 3;	//kf[^̃rbgʒu߂B	src̑
	pHuffmanDecoder->srcPos = (pHuffmanDecoder->srcPos + 31) & ~31;		//kf[^́̕Abitarray_msb1st_getŃANZX̂ŁA32bitE܂Ői߂ĂKvLB
}
#else //PIECE
void HuffmanDecoder_Init(ST_HuffmanDecoder* pHuffmanDecoder, const void* src);
asm("
		.code
		.align		1
		.global		HuffmanDecoder_Init
HuffmanDecoder_Init:
		ld.w		[%r12], %r13					;//pHuffmanDecoder->src = src,       %r13 := hdr
		ld.w		%r4, [%r13]+					;//%r4  := codeLenMask = *(int*)hdr, %r13 := hdr += 4
HuffmanDecoder_Init_LOOP:							;//do {
		add		%r4, %r4					;//  %psr(C) := (codeLenMask < 0), %r4  := codeLenMask <<= 1, %psr(Z) := !codeLenMask	
		jruge		HuffmanDecoder_Init_L10				;//  if(%psr(C)) {						@
		ld.ub		%r5, [%r13]+					;//    %r5  := codeLenCount-1 = *hdr++	@		//codeLenCount-1 := 0`255	@
		adc		%r13, %r5					;//    %r4  := hdr += codeLenCount-1 + 1						@	ł͕K%psr(C)=1ł邱Ƃ𗘗pāAadc𗘗p+1Hv܂B
		cmp		%r4, 0						;//                                                           %psr(Z) := !codeLenMask	
HuffmanDecoder_Init_L10:							;//  }											@
		jrne		HuffmanDecoder_Init_LOOP			;//} while(codeLenMask)	
		ld.w		%r4, [%r12]+					;//%r4  :=                                      pHuffmanDecoder->src
		sub		%r13, %r4					;//%r13 :=                     ((int)hdr - (int)pHuffmanDecoder->src)
		sla		%r13, 3						;//%r13 :=                     ((int)hdr - (int)pHuffmanDecoder->src) << 3
		add		%r13, 31					;//%r13 :=                    (((int)hdr - (int)pHuffmanDecoder->src) << 3) + 31
		and		%r13, -32					;//%r13 :=                   ((((int)hdr - (int)pHuffmanDecoder->src) << 3) + 31) & ~31
		ld.w		[%r12], %r13					;//pHuffmanDecoder->srcPos = ((((int)hdr - (int)pHuffmanDecoder->src) << 3) + 31) & ~31
		ret
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
//PoCgfR[hB
//kf[^̏I[Ȃ΁A(-1)ԂB
#ifndef PIECE
int HuffmanDecoder_Getc(ST_HuffmanDecoder* pHuffmanDecoder) {
	const unsigned char* hdr;
	int code, codeLenMask, codeLen, codeTmp1, codeTmp2, codeLenCount;
	//--- kf[^WJ鏈 ---
	code = bitarray_msb1st_get(pHuffmanDecoder->src, pHuffmanDecoder->srcPos, 32);	//ۂ̕ɂ炸Ã݂rbgʒu32bit擾B
	//\́̕Abitarray_msb1st_getł͂ȂA(codeLenMask+oCgz)ƌȂăANZXBGR[_ƃfR[_ŃANZX@킹ȂƁAoCgz񕔕̏vȂ̂ŒӂB
	hdr         = pHuffmanDecoder->src;
	codeLenMask = *(int*)hdr;
	hdr        += 4;
	codeLen     = 0;
	codeTmp1    = 0;							//\擾VtgC(H)ϐ
	codeTmp2    = 0;							//kf[^擾VtgCϐ
	do {									//codeLenMaskŏ0ꍇɂAʂ1񏈗Ă܂Auif(codeLenMask<0)vŏÔŁAʂ͐mł薳BAcodeLenMaskŏ0ɂȂ̂́Ak̃f[^0oCgꍇ݂̂łAʏ̉e͏͂BȃAP[XAʏ̏D悵Bwhile(){`}Ado{`}while()̕AB
		codeTmp1 <<= 1;							//\擾VtgC(H)		//fR[_asḿAucodeTmp1<<=1vɑ鏈AubÑ[v̒xXbgɒuč\ȂBcodeTmp̏l0ł邩AŏɃVtgĂŌɃVtgĂAʂɂȂ邩łB
		codeTmp2 = (codeTmp2 << 1) | (code < 0);			//kf[^擾VtgC		//fR[_asḿAuadd %rX,%rX;adc %rY,%rYvŏB
		code <<= 1;							//
		codeLen++;							//r镄𑝂₷B
		if(codeLenMask < 0) {						//fR[_asḿAuadd %rX,%rX;jruge `vŏB		˒:L̕@͂ł܂łBwhile()܂%psr(Z)ێłȂłB
//ufȌvZvƁuHvvZv̂ǂłʂ͓ɂȂB
#if 0	//fȌvZBASY𗝉ɂ͂QƂB
			codeLenCount = *hdr++ + 1;				//GR[_(-1)ƃfR[_(+1)EāA(1`256)ɕB
			codeTmp2 -= codeTmp1;					//
			if(codeTmp2 < 0) { DIE(); }	//oOo		//							//fR[_asḿÃoOsȂč\ȂB삪肵AoOAx̕dvł邩B
			if(codeTmp2 < codeLenCount) {				//̕ɑ镄Ȃ΁c		
				pHuffmanDecoder->srcPos += codeLen;		//ɓǂݏõrbgʒuXVB	
				return hdr[codeTmp2];				//lԂB				
			}							//						
			codeTmp2 += codeTmp1;					//̕ɑ镄łȂ΁Aň𑫂đEB
			hdr      += codeLenCount;				//wb_̑AhXA̕֐i߂B
			codeTmp1 += codeLenCount;				//r镄A̕ɑ镄̐A₷B
#else	//HvvZBAZu鎞͂̕ՂB
			codeLenCount = *hdr++ + 1;				//GR[_(-1)ƃfR[_(+1)EāA(1`256)ɕB	uHvvZv̎ό`
			hdr      += codeLenCount;				//wb_̑AhXA̕֐i߂B				hdr' = hdr+codeLenCount
			codeTmp1 += codeLenCount;				//r镄A̕ɑ镄̐A₷B			codeTmp1' = codeTmp1+codeLenCount
			codeTmp2 -= codeTmp1;					//			codeTmp2' = codeTmp2-codeTmp1' = codeTmp2-codeTmp1-codeLenCount
			if(codeTmp2 < 0) {					//̕ɑ镄Ȃ΁c					codeTmp2'<0  (codeTmp2-codeTmp1-codeLenCount)<0  (codeTmp2-codeTmp1)<codeLenCount
				pHuffmanDecoder->srcPos += codeLen;		//ɓǂݏõrbgʒuXVB				
				return hdr[codeTmp2];				//lԂB							hdr'[codeTmp2'] = (hdr+codeLenCount)[codeTmp2-codeTmp1-codeLenCount] = hdr[codeTmp2-codeTmp1]
			}							//									
			codeTmp2 += codeTmp1;					//̕ɑ镄łȂ΁Aň𑫂đEB	codeTmp2'' = codeTmp2'+codeTmp1' = codeTmp2-codeTmp1'+codeTmp1' = codeTmp2
#endif
		}
	} while(codeLenMask <<= 1);						//fR[_\Ō܂ŌĂvȂ΁AI[ƔfłB
	return -1;								//kf[^̏I[ł邱ƂA(-1)ԂBɓǂݏõrbgʒuXVȂƂɒӂBɓǂݏõrbgʒuXVȂƂɂāAȍ~HuffmanDecoder_Getc()ĂяoꂽAƓ(-1)ԂƂłB
}
#else //PIECE
int HuffmanDecoder_Getc(ST_HuffmanDecoder* pHuffmanDecoder);
#if 0		//'fȎ''Hv'̂ǂgĂAʂ͓łB݂̂ƂA'Hv'gƂɂ܂B
//fȎB
asm("
		.code
		.align		1
		.global		HuffmanDecoder_Getc
HuffmanDecoder_Getc:
		pushn		%r0
		ld.w		%r0, %r12					;//%r0  :=  pHuffmanDecoder
		ld.w		%r12, [%r0]+					;//%r12 :=                            pHuffmanDecoder->src, %r0 := &pHuffmanDecoder->srcPos
		ld.w		%r13, [%r0]					;//%r13 :=                                                  pHuffmanDecoder->srcPos
		xld.w		%r14, 32					;//%r14 :=                                                                           32
		xcall.d		bitarray_msb1st_get				;//%r10 := code = bitarray_msb1st_get(pHuffmanDecoder->src, pHuffmanDecoder->srcPos, 32)
		sub		%r0, 4						;//%r0  :=  pHuffmanDecoder									*delay*
		ld.w		%r4, %r0					;//%r4  :=  pHuffmanDecoder
		ld.w		%r5, [%r4]+					;//%r4  := &pHuffmanDecoder->srcPos, %r5 := hdr = pHuffmanDecoder->src
		popn		%r0
		;//X^bNgp̂͂܂ŁBȍ~͂retėǂB
		;//%r4  := &pHuffmanDecoder->srcPos
		;//%r5  := hdr
		;//%r10 := code
		ld.w		%r6, [%r5]+					;//%r6  := codeLenMask = *(int*)hdr, %r5 := hdr += 4
		ld.w		%r11, 0						;//%r11 := codeTmp1 = 0
		ld.w		%r12, 0						;//%r12 := codeTmp2 = 0
		ld.w		%r7, 0						;//%r7  := codeLen  = 0
		;//%r4  := &pHuffmanDecoder->srcPos
		;//%r5  := hdr
		;//%r6  := codeLenMask
		;//%r7  := codeLen
		;//%r10 := code
		;//%r11 := codeTmp1
		;//%r12 := codeTmp2
HuffmanDecoder_Getc_LOOP:							;//do {
		add		%r10, %r10					;//  %psr(C) :=                           (code < 0), %r10 := code <<= 1
		adc		%r12, %r12					;//  %r12 := codeTmp2 = (codeTmp2 << 1) | (code < 0)
		cmp		%r6, 0						;//  if(codeLenMask < 0) {
		jrge.d		HuffmanDecoder_Getc_L20
		add		%r7, 1						;//  %r7  := codeLen++										*delay*
		ld.ub		%r13, [%r5]+					;//    %r13 := codeLenCount-1 = *hdr++			//codeLenCount-1 := 0`255
		sub		%r12, %r11					;//    %r12 := codeTmp2 -= codeTmp1
		cmp		%r12, %r13					;//    if(codeTmp2 <= codeLenCount-1) {
		jrgt.d		HuffmanDecoder_Getc_L10
		add		%r13, 1						;//    %r13 := codeLenCount				//codeLenCount   := 1`256		*delay*
		add		%r5, %r12					;//      %r5  :=        &hdr[codeTmp2]
		ld.w		%r9, [%r4]					;//      %r9  := srcPos = pHuffmanDecoder->srcPos
		ld.ub		%r10, [%r5]					;//      %r10 := value = hdr[codeTmp2]								*anti-interlock*
		add		%r9, %r7					;//      %r9  := srcPos += codeLen
		ld.w		[%r4], %r9					;//      pHuffmanDecoder->srcPos = srcPos
		ret								;//      return  value
HuffmanDecoder_Getc_L10:							;//    }
		add		%r12, %r11					;//    %r12 := codeTmp2 += codeTmp1
		add		%r5, %r13					;//    %r5  := hdr      += codeLenCount
		add		%r11, %r13					;//    %r11 := codeTmp1 += codeLenCount
HuffmanDecoder_Getc_L20:							;//  }
		sla		%r6, 1						;//} while(codeLenMask <<= 1)
		jrne.d		HuffmanDecoder_Getc_LOOP
		sla		%r11, 1						;//  %r11 := codeTmp1 <<= 1									*delay*
		ret.d								;//return  -1
		ld.w		%r10, -1					;//%r10 := -1											*delay*
");
#elif 0
//HvBfȎ4oCg1%B
asm("
		.code
		.align		1
		.global		HuffmanDecoder_Getc
HuffmanDecoder_Getc:
		pushn		%r1
		ld.w		%r0, %r12					;//%r0  :=  pHuffmanDecoder
		ld.w		%r1, [%r0]+					;//%r0  := &pHuffmanDecoder->srcPos, %r1  := pHuffmanDecoder->src
		ld.w		%r13, [%r0]					;//%r13 :=                                                         pHuffmanDecoder->srcPos
		xld.w		%r14, 32					;//%r14 :=                                                                                  32
		xcall.d		bitarray_msb1st_get				;//%r10 := code = bitarray_msb1st_get(       pHuffmanDecoder->src, pHuffmanDecoder->srcPos, 32)
		ld.w		%r12, %r1					;//%r12 :=                                   pHuffmanDecoder->src					*delay*
		;//%r0  :=      &pHuffmanDecoder->srcPos
		;//%r1  := hdr = pHuffmanDecoder->src
		;//%r10 := code
		ld.w		%r4, [%r1]+					;//%r4  := codeLenMask = *(int*)hdr, %r1  := hdr += 4
		ld.w		%r5, 0						;//%r5  := codeLen  = 0
		ld.w		%r6, 0						;//%r6  := codeTmp1 = 0
		ld.w		%r7, 0						;//%r7  := codeTmp2 = 0
		;//%r0  := &pHuffmanDecoder->srcPos
		;//%r1  := hdr
		;//%r4  := codeLenMask
		;//%r5  := codeLen
		;//%r6  := codeTmp1
		;//%r7  := codeTmp2
		;//%r10 := code
HuffmanDecoder_Getc_LOOP:							;//do {
		add		%r10, %r10					;//  %psr(C) :=                           (code < 0), %r10 := code <<= 1
		adc		%r7, %r7					;//  %r7  := codeTmp2 = (codeTmp2 << 1) | (code < 0)
		cmp		%r4, 0						;//  if(codeLenMask < 0) {
		jrge.d		HuffmanDecoder_Getc_L20
		add		%r5, 1						;//  %r5  := codeLen++											*delay*
		ld.ub		%r11, [%r1]+					;//    %r11 := codeLenCount-1 = *hdr++			//codeLenCount-1 := 0`255
		sub		%r7, %r6					;//    %r7  := codeTmp2 -= codeTmp1
		cmp		%r7, %r11					;//    if(codeTmp2 <= codeLenCount-1) {
		jrgt.d		HuffmanDecoder_Getc_L10
		add		%r11, 1						;//    %r11 := codeLenCount				//codeLenCount   := 1`256			*delay*
		add		%r1, %r7					;//      %r1  :=        &hdr[codeTmp2]
		ld.w		%r9, [%r0]					;//      %r9  := srcPos = pHuffmanDecoder->srcPos
		ld.ub		%r10, [%r1]					;//      %r10 := value = hdr[codeTmp2]									*anti-interlock*
		add		%r9, %r5					;//      %r9  := srcPos += codeLen
		ld.w		[%r0], %r9					;//      pHuffmanDecoder->srcPos = srcPos
HuffmanDecoder_Getc_RET:
		popn		%r1						;//return  value
		ret
HuffmanDecoder_Getc_L10:							;//    }
		add		%r7, %r6					;//    %r7  := codeTmp2 += codeTmp1
		add		%r1, %r11					;//    %r1  := hdr      += codeLenCount
		add		%r6, %r11					;//    %r6  := codeTmp1 += codeLenCount
HuffmanDecoder_Getc_L20:							;//  }
		sla		%r4, 1						;//} while(codeLenMask <<= 1)
		jrne.d		HuffmanDecoder_Getc_LOOP
		sla		%r6, 1						;//  %r6  := codeTmp1 <<= 1										*delay*
		jp.d		HuffmanDecoder_Getc_RET
		ld.w		%r10, -1					;//%r10 := value = -1											*delay*
");
#else
//HvɉāuHvvZvKpB4oCg0.4%B
asm("
		.code
		.align		1
		.global		HuffmanDecoder_Getc
HuffmanDecoder_Getc:
		pushn		%r1
		ld.w		%r0, %r12					;//%r0  :=  pHuffmanDecoder
		ld.w		%r1, [%r0]+					;//%r0  := &pHuffmanDecoder->srcPos, %r1  := pHuffmanDecoder->src
		ld.w		%r13, [%r0]					;//%r13 :=                                                         pHuffmanDecoder->srcPos
		xld.w		%r14, 32					;//%r14 :=                                                                                  32
		xcall.d		bitarray_msb1st_get				;//%r10 := code = bitarray_msb1st_get(       pHuffmanDecoder->src, pHuffmanDecoder->srcPos, 32)
		ld.w		%r12, %r1					;//%r12 :=                                   pHuffmanDecoder->src					*delay*
		;//%r0  :=      &pHuffmanDecoder->srcPos
		;//%r1  := hdr = pHuffmanDecoder->src
		;//%r10 := code
		ld.w		%r4, [%r1]+					;//%r4  := codeLenMask = *(int*)hdr, %r1  := hdr += 4
		ld.w		%r5, 0						;//%r5  := codeLen  = 0
		ld.w		%r6, 0						;//%r6  := codeTmp1 = 0
		ld.w		%r7, 0						;//%r7  := codeTmp2 = 0
		;//%r0  := &pHuffmanDecoder->srcPos
		;//%r1  := hdr
		;//%r4  := codeLenMask
		;//%r5  := codeLen
		;//%r6  := codeTmp1
		;//%r7  := codeTmp2
		;//%r10 := code
HuffmanDecoder_Getc_LOOP:							;//do {
		add		%r10, %r10					;//  %psr(C) :=                           (code < 0), %r10 := code <<= 1
		adc		%r7, %r7					;//  %r7  := codeTmp2 = (codeTmp2 << 1) | (code < 0)
		cmp		%r4, 0						;//  if(codeLenMask < 0) {
		jrge.d		HuffmanDecoder_Getc_L20
		add		%r5, 1						;//  %r5  := codeLen++											*delay*
		ld.ub		%r11, [%r1]+					;//    %r11 := codeLenCount-1 = *hdr++			//codeLenCount-1 := 0`255
		add		%r11, 1						;//    %r11 := codeLenCount				//codeLenCount   := 1`256
	;//	add		%r1, %r11					;//    %r1  := hdr      += codeLenCount	
		add		%r6, %r11					;//    %r6  := codeTmp1 += codeLenCount	@
		sub		%r7, %r6					;//    %r7  := codeTmp2 -= codeTmp1	@
		jrge.d		HuffmanDecoder_Getc_L10				;//    if(codeTmp2 < 0) {		@
		add		%r1, %r11					;//    %r1  := hdr      += codeLenCount									*delay*
		add		%r7, %r1					;//      %r7  :=        &hdr[codeTmp2]
		ld.w		%r9, [%r0]					;//      %r9  := srcPos = pHuffmanDecoder->srcPos
		ld.ub		%r10, [%r7]					;//      %r10 := value = hdr[codeTmp2]									*anti-interlock*
		add		%r9, %r5					;//      %r9  := srcPos += codeLen
		ld.w		[%r0], %r9					;//      pHuffmanDecoder->srcPos = srcPos
HuffmanDecoder_Getc_RET:
		popn		%r1						;//return  value
		ret
HuffmanDecoder_Getc_L10:							;//    }
		add		%r7, %r6					;//    %r7  := codeTmp2 += codeTmp1
HuffmanDecoder_Getc_L20:							;//  }
		sla		%r4, 1						;//} while(codeLenMask <<= 1)
		jrne.d		HuffmanDecoder_Getc_LOOP
		sla		%r6, 1						;//  %r6  := codeTmp1 <<= 1										*delay*
		jp.d		HuffmanDecoder_Getc_RET
		ld.w		%r10, -1					;//%r10 := value = -1											*delay*
");
#endif
#endif//PIECE
