/*	
 *	framhes.h
 *
 *	P/ECE HES Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	HUC6280G~[VpO֐
 ****************************************************************************/

void
hes_huc6280_write(HUC6280* huc6280, unsigned short addr, unsigned char data)
{
	HESDRIVER* hes = (HESDRIVER*)huc6280;

	/* MPR0=$FFƉB
	 *   _AhX   0x0000`  0x1fff
	 * = AhX 0x1fe000`0x1fffff
	 * = I/O area
	 */
	if(addr <= 0x1fff) {
		hes_huc6280_out(huc6280, addr, data);
		return;
	}

	hes->mem[addr] = data;
}

/****************************************************************************
 *	HEShCo֐
 ****************************************************************************/

int
hes_mix(HESDRIVER* hes, short wbuff[/*HESBUFLEN*/])
{
	HUC6280* huc6280 = &hes->huc6280;
	unsigned char* mem = hes->mem;
	//
	int cnt1 = HESBUFLEN;	/* cTv */
	int cnt2;

	ASSERT(HES_CPU_CLOCK >= SPEAKER_FREQUENCY);
	do {
		/* 񊄂荞ݔ܂ł̎cTCNŁATv~LVOł邩? */
		if(hes->timer_start && !(mem[0x1402] & 4)) {
			if(hes->vblank_enable && !(mem[0x1402] & 2)) {
				/* TIMER,VBLANKƂL */
				if(hes->timer_progress <= hes->vblank_progress) {
					cnt2 = (hes->timer_progress * SPEAKER_FREQUENCY + HES_CPU_CLOCK - 1) / HES_CPU_CLOCK;
				} else {
					cnt2 = (hes->vblank_progress * SPEAKER_FREQUENCY + HES_CPU_CLOCK - 1) / HES_CPU_CLOCK;
				}
			} else {
				/* TIMER̂ݗL */
				cnt2 = (hes->timer_progress * SPEAKER_FREQUENCY + HES_CPU_CLOCK - 1) / HES_CPU_CLOCK;
			}
		} else {
			if(hes->vblank_enable && !(mem[0x1402] & 2)) {
				/* VBLANK̂ݗL */
				cnt2 = (hes->vblank_progress * SPEAKER_FREQUENCY + HES_CPU_CLOCK - 1) / HES_CPU_CLOCK;
			} else {
				/* TIMER,VBLANKƂ */
				cnt2 = cnt1;
			}
		}
		if(cnt2 > cnt1) cnt2 = cnt1;

		/* ~LVOB */
		huc6280psg_mix(&hes->psg, wbuff, cnt2);
		wbuff += cnt2;
		cnt1 -= cnt2;

		/* 񊄂荞ݔ܂ł̎cTCN炵āA0ɂȂ犄荞ݏB */
		if(hes->timer_start && !(mem[0x1402] & 4)) {
			hes->timer_progress -= cnt2 * HES_CPU_CLOCK / SPEAKER_FREQUENCY;
			while(hes->timer_progress <= 0) {
				hes->timer_progress += hes->timer_period;
				mem[0x1403] = 4; /* TIMER荞ݔ */
				huc6280_timer(huc6280);
				huc6280_run(huc6280, HES_CPU_CLOCK/*ňł1bȓɂ͊Ɖ*/);
			}
		}
		if(hes->vblank_enable && !(mem[0x1402] & 2)) {
			hes->vblank_progress -= cnt2 * HES_CPU_CLOCK / SPEAKER_FREQUENCY;
			while(hes->vblank_progress <= 0) {
				hes->vblank_progress += HES_VBLANK_PERIOD;
				mem[0x1403] = 2; /* IRQ1荞ݔ */
				huc6280_irq1(huc6280);
				huc6280_run(huc6280, HES_CPU_CLOCK/*ňł1bȓɂ͊Ɖ*/);
			}
		}
	} while(cnt1);

	return 0;
}

