/*	
 *	framgym.c
 *
 *	P/ECE GYM Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Dec 9 18:16:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/* * YM2612\̂RAMɒuȂƁAxԂɍ܂B
 * - {constł͂܂񂪁A.codeZNVɔzu邽߁AUconstƂĂ܂B
 *   (RAMɔzuw肵W[.codeZNV݂̂AۂɍRAMɒu܂B)
 * - P/ECE.code,.data,.bssׂĂRAMɓWJĎŝŁAconstł\łB
 *   Win32constϐł悤łAÔWin32łconstO܂B
 */
#ifdef PIECE
const YM2612 gym_ym2612 = { 0 }; /* qK{Bq.bssɓĂ܂ */
#else /*PIECE*/
      YM2612 gym_ym2612;
#endif /*PIECE*/

/****************************************************************************
 *	GYMhCo֐
 ****************************************************************************/

/* * Sun Dec 12 10:44:00 JST 2004 Naoyuki Sawa
 * - ܂RAMɂ]T̂ŁAgym_mix()RAMֈڂ܂B
 *   ㍂RAMsAgym_mix()SRAMɖ߂ĂB
 *   KvȊ֐̒ŁAgym_mix()ԏdvxႢ͂łB
 */
int
gym_mix(GYMDRIVER* driver, short wbuff[/*GYMBUFLEN*/])
{
	int result = -1;
	//
	static short dacbuf[GYMBUFLEN_DAC]; /* X^bNh~̂STATIC */
	int daccnt = 0;
	//
	YM2612* const ym2612 = driver->ym2612;
	SN76489* const sn76489 = driver->sn76489;
	unsigned char* const datbuf = driver->datbuf;
	short (*tmpbuf/*[3]*/)[GYMBUFLEN + GYMBUFLEN_60] = driver->tmpbuf;
	//
	int datlen = driver->datlen; /* o */
	int datpos = driver->datpos; /* o */
	int tmpcnt = driver->tmpcnt; /* o */
	//
	int op;
	int reg;
	int data;

	while(tmpcnt < GYMBUFLEN) {

		/* obt@̎cf[^ȂȂÃf[^ǂݍ݂܂B */
		ASSERT(datlen >= datpos);
		if(datlen - datpos < 3/*1ߓ̍őoCg*/) {
			datlen -= datpos;
			memmove(datbuf, &datbuf[datpos], datlen);
			datpos = 0;
			datlen += fread(&datbuf[datlen], 1, BLOCKSIZE, driver->fp);

			/* t@CI[Ȃ... (obt@̎cf[^0oCgŁAAt@Cǂ߂Ȃꍇ)
			 * !! t@C1oCgȏǂ߂ǂŔfĂ̓_!!
			 *        obt@1`2oCg̗Lf[^cĂȂāAt@Cǂ߂ȂĂA
			 *        1`2oCgR}hȂ΁A܂t@CI[܂ŏĂȂłB
			 */
			if(!datlen) {
				/* [vJnʒuoȂ΁A[v܂B */
				if(!driver->looppos) {
					goto L_EXIT; /* 񃋁[v */
				}
				/* [vJnʒuփV[N܂B */
				fseek(driver->fp, driver->looppos, SEEK_SET);
				/* [vJnʒuǃt@Cǂݍ݁B */
				datlen += fread(&datbuf[datlen], 1, BLOCKSIZE, driver->fp);
				/* łǂ߂Ȃ΁A[v܂B(t@C0oCgԂ̃[vݒ!?) */
				if(!datlen) {
					goto L_EXIT; /* [vs */
				}
			}
		}

		op = datbuf[datpos++];
		switch(op) {
		case 0: /* 1/60[sec]o ()*/

			/* 1/60[sec]~LVO܂B */
			ASSERT(tmpcnt + GYMBUFLEN_60 <= ARRAY_SIZE(tmpbuf));
			ym2612_mix(ym2612, &tmpbuf[0][tmpcnt], GYMBUFLEN_60);
			sn76489_mix(sn76489, &tmpbuf[1][tmpcnt], GYMBUFLEN_60);
			gym_dacmix(&tmpbuf[2][tmpcnt], dacbuf, daccnt);
			tmpcnt += GYMBUFLEN_60;

			/* [vJnʒuo܂B(񃋁[vGYMڂ̔svłBclipgym.hloopcnt̐Q) */
			if(!--driver->loopcnt) { /* "if(!driver->loopcnt--)"ł̓_!! 񃋁[vȂ̏ɊԈă[voĂ܂ */
				driver->looppos = ftell(driver->fp) - (datlen - datpos);
				//                                    ~~~~~~~~~~~~~~~~~obt@̂܂ĂȂf[^߂BYȂ!!
				ASSERT(driver->looppos >= 0);
			}

			break;

		case 1: /* YM2612 Part Io (=WX^ԍ, WX^l) */

			if(datlen - datpos < 2) {
				goto L_EXIT; /* f[^G[ */
			}
			reg  = datbuf[datpos++];
			data = datbuf[datpos++];
			if((reg == 0x2a) && (daccnt < GYMBUFLEN_DAC)) {
				/* * ̂߁AYM2612 EmulatorDAC@\͎g܂B
				 *   DACo͂肵ċL^AGYM Driverɂă~LVO܂B
				 * * DAC en(0x2b)̐ݒ͉肹YM2612 Emulator֓n܂B
				 *   DACgṕAYM2612Ch6o͂OffɂKv邩łB
				 */
				dacbuf[daccnt++] = (data - 128) << 7/*DACʁA*/;
			} else {
				ym2612_write_reg(ym2612, 0, reg, data);
			}

			break;

		case 2: /* YM2612 Part IIo (=WX^ԍ, WX^l) */

			if(datlen - datpos < 2) {
				goto L_EXIT; /* f[^G[ */
			}
			reg  = datbuf[datpos++];
			data = datbuf[datpos++];
			ym2612_write_reg(ym2612, 1, reg, data);

			break;

		case 3: /* SN76489o (=WX^l) */

			if(datlen - datpos < 1) {
				goto L_EXIT; /* f[^G[ */
			}
			data = datbuf[datpos++];
			sn76489_write(sn76489, (unsigned char)data);

			break;

		default:
			goto L_EXIT; /* f[^G[ */
		}
	}

	/* ꎞobt@o̓obt@փRs[܂B */
	gym_copy(tmpbuf[0], tmpbuf[1], tmpbuf[2], wbuff);

	/* Rs[Aꎞobt@O֋l߂܂B */
	tmpcnt -= GYMBUFLEN;
	memmove(tmpbuf[0], &tmpbuf[0][GYMBUFLEN], sizeof(short) * tmpcnt);
	memmove(tmpbuf[1], &tmpbuf[1][GYMBUFLEN], sizeof(short) * tmpcnt);
	memmove(tmpbuf[2], &tmpbuf[2][GYMBUFLEN], sizeof(short) * tmpcnt);

	result = 0; /*  */

L_EXIT:
	driver->datlen = datlen;	/* ߂ */
	driver->datpos = datpos;	/* ߂ */
	driver->tmpcnt = tmpcnt;	/* ߂ */

	return result;
}

/* daccntTvDACo͂GYMBUFLEN_60TvɈL΂܂B */
#ifndef PIECE
void
gym_dacmix(short dst[/*GYMBUFLEN_60*/], const short src[/*daccnt*/], int daccnt)
{
	int d;
	int n;
	short v;

	n = GYMBUFLEN_60;
	d = 0;
	v = 0; /* daccnt=0̏ꍇ̂ */
	do {
		d -= daccnt;
		if(d < 0) {
			d += GYMBUFLEN_60;
			v = *src++;
		}
		*dst++ = v;
	} while(--n);
}
#else /*PIECE*/
asm("
	.code
	.align 1
	.global gym_dacmix
gym_dacmix:
	; %r12 = dst
	; %r13 = src
	; %r14 = daccnt
	xld.w %r4, 267			; GYMBUFLEN_60 (clipgym.h̒`ƍĂ邱!!)
	ld.w %r5, %r4			; n = GYMBUFLEN_60
	xld.w %r6, 0			; d = 0
	xld.w %r7, 0			; v = 0
gym_dacmix_L10:				; do {
	sub %r6, %r14			;   d -= daccnt
	xjrge gym_dacmix_L20		;   if(d < 0) {
	add %r6, %r4			;     d += GYMBUFLEN_60
	ld.h %r7, [%r13]+		;     v = *src++
gym_dacmix_L20:				;   }
	ld.h [%r12]+, %r7		;   *dst++ = v
	xsub %r5, %r5, 1		; } while(--n)
	xjrne gym_dacmix_L10
	ret
");
#endif /*PIECE*/

/* YM2612:SN76489:DACK؂Ȕ䗦Ń~LVOāAo̓obt@փRs[܂B */
#ifndef PIECE
void
gym_copy(const short src1[/*GYMBUFLEN*/], const short src2[/*GYMBUFLEN*/], const short src3[/*GYMBUFLEN*/], short dst[/*GYMBUFLEN*/])
{
	int n;
	int v;

	n = GYMBUFLEN;
	do {
		v = (*src1++ >> 0/**/)	/* YM2612 */
		  + (*src2++ >> 2/**/)	/* SN76489 */
		  + (*src3++ >> 0/**/);	/* DAC */
		if(v >  32767) v =  32767;
		if(v < -32768) v = -32768;
		*dst++ = v;
	} while(--n);
}
#else /*PIECE*/
asm("
	.code
	.align 1
	.global gym_copy
gym_copy:
	; %r12 = src1 (YM2612)
	; %r13 = src2 (SN76489)
	; %r14 = src3 (DAC)
	; %r15 = dst
	xld.w %r4, 320			; GYMBUFLEN
	xld.w %r10, 32767
	not %r11, %r10			; -32768
gym_copy_L10:
	ld.h %r5, [%r12]+		; YM2612  = *src1++
	ld.h %r6, [%r13]+		; SN76489 = *src2++
	ld.h %r7, [%r14]+		; DAC     = *src3++
	xsra %r6, 2			; v = YM2612 + (SN76489 >> 2) + DAC
	add %r5, %r6
	add %r5, %r7
	cmp %r5, %r10
	xjrle.d gym_copy_L20
	cmp %r5, %r11			; *delay*
	ld.w %r5, %r10
gym_copy_L20:
	xjrge.d gym_copy_L30
	sub %r4, 1			; *delay*
	ld.w %r5, %r11
gym_copy_L30:
	ld.h [%r15]+, %r5
	xjrne gym_copy_L10
	ret
");
#endif /*PIECE*/
