/*	
 *	framdmv.c
 *
 *	P/ECE DMG-Video Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Fri Feb 18 20:18:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

#ifndef DMGVIDEO_ASM

/*
 * (]  5sNZ -> ]  4sNZ) x 32
 * (] c18C   -> ] c11C  ) x  8
 *
 * 18C -> 11C̈kp^[́ÂƂłB
 *
 *			]Line#	]Line#
 *	i=1		-----------	-----------
 *	i=1->0->3	 0		 0
 *	i=3->2		 1+ 2		 1
 *	i=2->1		 3+ 4		 2
 *	i=1->0->3	 5		 3
 *	i=3->2		 6+ 7		 4
 *	i=2->1		 8+ 9		 5
 *	i=1->0->3	10		 6
 *	i=3->2		11+12		 7
 *	i=2->1		13+14		 8
 *	i=1->0->3	15		 9
 *	i=3->2		16+17		10
 */
void
dmgvideo_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*160*144*/])
{
	int i;
	int x;
	int y;
	int z;

	z = 8;
	do {
		y = 11;
		i = 1;
		do {
			x = 32;
			if(!--i) {
				do {
					dst[0] =  src[0];
					dst[1] =  src[1];
					dst[2] =  src[2];
					dst[3] = (src[3] + src[4] + 1) >> 1;
					dst += 4;
					src += 5;
				} while(--x);
				i = 3;
			} else {
				do {
					dst[0] = (src[0] + src[160] + 1) >> 1;
					dst[1] = (src[1] + src[161] + 1) >> 1;
					dst[2] = (src[2] + src[162] + 1) >> 1;
					dst[3] = (src[3] + src[163] +
					          src[4] + src[164] + 2) >> 2;
					dst += 4;
					src += 5;
				} while(--x);
				src += 160;
			}
		} while(--y);
	} while(--z);
}

#endif /*DMGVIDEO_ASM*/

