/*	
 *	framdmg.c
 *
 *	P/ECE DMG-CPU Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipdmgi.h"	/*DMGG~[^p}N*/

/****************************************************************************
 *	DMGRÃCREAD/WRITEO֐
 ****************************************************************************/

/* DMG\(32oCg)̒ɃCzuĂ邱Ƃ肵܂B
 * oCiCAEgقȂꍇAoNؑւȂǂ̓ᏈKvȏꍇ́A
 * AvP[V`̊O֐pӂĂB
 */

#ifndef DMG_ASM	/****************************************************/

unsigned char
dmg_internal_read(DMG* dmg, unsigned short addr)
{
	return ((unsigned char*)(dmg + 1))[addr];
}
void
dmg_internal_write(DMG* dmg, unsigned short addr, unsigned char data)
{
	((unsigned char*)(dmg + 1))[addr] = data;
}

#else	/********************************************************************/

asm("
	.code
	.align 1
	.global dmg_internal_read
dmg_internal_read:
	add %r12, %r13
	xld.ub %r10, [%r12+32]
	ret
");
asm("
	.code
	.align 1
	.global dmg_internal_write
dmg_internal_write:
	add %r12, %r13
	xld.b [%r12+32], %r14
	ret
");

#endif	/********************************************************************/

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef DMG_ASM	/****************************************************/

void
dmg_run(DMG* dmg, int cycle)
{
	unsigned char code;
	const DMGOP* op;
	int arg = 0; /* x} */
	int tmp;

	CYCLE = cycle;
	while(!HALT && CYCLE > 0) {
#ifdef DMG_TRACE
		dmg_dump(dmg);
#endif /*DMG_TRACE*/
		DMGTRACE("%04x: ", PC);
		FETCH(code);
		op = &dmg_op_table[code];
		if(op->argc >= 1) {
			FETCH(arg);
			if(op->argc >= 2) {
				FETCH(tmp);
				arg |= tmp << 8;
			}
		}
		EXEC();
		DMGTRACE("\n");
	}
}

DMGFN_(CB)
{
	const DMGOP* op;

	FETCH(code);
	op = &dmg_op_table_CB[code];
	ASSERT(op->argc == 0); /* CBxx߂͈Ȃ */
	EXEC();
}

#endif	/********************************************************************/

