;	
;	framc62a.s
;
;	P/ECE HuC6280 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
#include "clipc62a.h"
#ifdef HUC6280_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	HUC6280\
;
/*===== WX^ =====*/
#define P	 0
#define A	 1
#define X	 2
#define Y	 3
#define PC	 4
#define S	 6
#define MPR_EN	 7
#define MPR	 8
/*=====  =====*/
#define CYCLE	16
#define HALT	20
#define PENDING	21
/*===== O֐ =====*/
#define READ	24
#define WRITE	28
#define MPRSET	32
#define VDCOUT	36

;
;	C33=>HuC6280tOϊ\
;
				; C33(C,V,Z,N) => HuC6280(S,Z,V,C)
				; ====C33====     ==HuC6280==
huc6280_FLAG_CONV:		; ----CVZN        NV----ZC
	.byte	0x00		; 00000000 00     00000000 00
	.byte	0x80		; 00000001 01     10000000 80
	.byte	0x02		; 00000010 02     00000010 02
	.byte	0x82		; 00000011 03     10000010 82
	.byte	0x40		; 00000100 04     01000000 40
	.byte	0xc0		; 00000101 05     11000000 c0
	.byte	0x42		; 00000110 06     01000010 42
	.byte	0xc2		; 00000111 07     11000010 c2
	.byte	0x01		; 00001000 08     00000001 01
	.byte	0x81		; 00001001 09     10000001 81
	.byte	0x03		; 00001010 0a     00000011 03
	.byte	0x83		; 00001011 0b     10000011 83
	.byte	0x41		; 00001100 0c     01000001 41
	.byte	0xc1		; 00001101 0d     11000001 c1
	.byte	0x43		; 00001110 0e     01000011 43
	.byte	0xc3		; 00001111 0f     11000011 c3

;****************************************************************************
;
;****************************************************************************

	.global huc6280_run
huc6280_run:
	pushn %r3
	xsub %sp, %sp, 12
	;
	ld.w %r0, %r12			; huc6280
	xld.w %r3, [%r0+READ]		; huc6280->read
	xld.w [%r0+CYCLE], %r13		; CYCLE
	xcmp %r13, 0			; if(CYCLE <= 0) break
	xjrle huc6280_run_exit
	;
huc6280_run_L10:
	xld.ub %r10, [%r0+HALT]		; if(HALT) break
	xld.uh %r1, [%r0+PC]		; PC *anti-interlock*
	xcmp %r10, 0
	xjrne huc6280_run_exit
	;
	ld.uh %r13, %r1			; code = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, huc6280_op_table	; op = &huc6280_op_table[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.ub %r10, [%r2+4]		; switch(op->addr)
	xld.w %r11, huc6280_run_table	; *anti-interlock*
	xsll %r10, 2
	add %r10, %r11
	xld.w %r10, [%r10]
	xadd %r1, %r1, 1		; PC++ *anti-interlock*
	jp %r10
	;
huc6280_run_imm:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10			; arg1 = imm
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zpg:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xoor %r14, %r10, 0x2000		; arg1 = zpg | 0x2000
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zpx:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%r0+X]		; arg1 = ((zpg+X)&0xff) | 0x2000
	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	xoor %r14, %r14, 0x2000
	;
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zpy:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%r0+Y]		; arg1 = ((zpg+Y)&0xff) | 0x2000
	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	xoor %r14, %r14, 0x2000
	;
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zpi:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xoor %r13, %r10, 0x2000		; zpg | 0x2000
	xadd %r10, %r10, 1		; (save (zpg+1)&0xff)
	xld.b [%sp+1], %r10
	;
	call.d %r3			; memLo = READ(zpg | 0x2000)
	ld.w %r12, %r0			; *delay*
	xld.ub %r13, [%sp+1]		; (restore (zpg+1)&0xff)
	;
	xld.b [%sp+1], %r10		; (save memLo)
	xoor %r13, %r13, 0x2000		; ((zpg+1)&0xff) | 0x2000
	call.d %r3			; memHi = READ(((zpg+1)&0xff) | 0x2000)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore memLo)
	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_idx:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r13, [%r0+X]		; (zpg+X)&0xff
	add %r10, %r13			; !INTERLOCK!
	ld.ub %r10, %r10
	;
	xoor %r13, %r10, 0x2000		; ((zpg+X)&0xff) | 0x2000
	xadd %r10, %r10, 1		; (save (zpg+X+1)&0xff)
	xld.b [%sp+1], %r10
	;
	call.d %r3			; memLo = READ((zpg+X)&0xff) | 0x2000
	ld.w %r12, %r0			; *delay*
	xld.ub %r13, [%sp+1]		; (restore (zpg+X+1)&0xff)
	;
	xld.b [%sp+1], %r10		; (save memLo)
	xoor %r13, %r13, 0x2000		; ((zpg+X+1)&0xff) | 0x2000
	call.d %r3			; memHi = READ(((zpg+X+1)&0xff) | 0x2000)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore memLo)
	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_idy:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xoor %r13, %r10, 0x2000		; zpg | 0x2000
	xadd %r10, %r10, 1		; (save (zpg+1)&0xff)
	xld.b [%sp+1], %r10
	;
	call.d %r3			; memLo = READ(zpg | 0x2000)
	ld.w %r12, %r0			; *delay*
	xld.ub %r13, [%sp+1]		; (restore (zpg+1)&0xff)
	;
	xld.b [%sp+1], %r10		; (save memLo)
	xoor %r13, %r13, 0x2000		; ((zpg+1)&0xff) | 0x2000
	call.d %r3			; memHi = READ(((zpg+1)&0xff) | 0x2000)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore memLo)
	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; mem = memLo | memHi<<8
	;
	xld.ub %r10, [%r0+Y]		; arg1 = (mem+Y)&0xffff
	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.uh %r14, %r14
	;
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_rel:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; rel = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	ld.b %r14, %r10			; arg1 = PC + (char)rel
	add %r14, %r1
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp huc6280_run_exec		; !NO-DELAY!
	;
huc6280_run_abs:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	xld.b [%sp+1], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore memLo)
	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_abx:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	xld.b [%sp+1], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore memLo)
	xld.ub %r11, [%r0+X]		; arg1 = ((memLo | memHi<<8)+X)&0xffff
	xsll %r10, 8
	or %r14, %r10
	add %r14, %r11
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_aby:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	xld.b [%sp+1], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore memLo)
	xld.ub %r11, [%r0+Y]		; arg1 = ((memLo | memHi<<8)+Y)&0xffff
	xsll %r10, 8
	or %r14, %r10
	add %r14, %r11
	ld.uh %r14, %r14
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_ind:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; ptrLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	xld.b [%sp+1], %r10		; (save ptrLo)
	ld.uh %r13, %r1			; ptrHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r13, [%sp+1]		; (restore ptrLo)
	xsll %r10, 8			; ptrHi<<8 *anti-interlock*
	or %r13, %r10			; ptr = ptrLo | ptrHi<<8
	;
	xld.h [%sp+2], %r13		; (save ptr)
	call.d %r3			; memLo = READ(ptr)
	ld.w %r12, %r0			; *delay*
	;
	xld.uh %r13, [%sp+2]		; (restore ptr)
	xld.b [%sp+1], %r10		; (save memLo) *anti-interlock*
	xadd %r13, %r13, 1		; (ptr+1)&0xffff
	ld.uh %r13, %r13
	call.d %r3			; memHi = READ((ptr+1)&0xffff)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore memLo)
	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_iax:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; ptrLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	xld.b [%sp+1], %r10		; (save ptrLo)
	ld.uh %r13, %r1			; ptrHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r13, [%sp+1]		; (restore ptrLo)
	xld.ub %r11, [%r0+X]		; ptr = ((ptrLo | ptrHi<<8)+X)&0xffff
	xsll %r10, 8
	or %r13, %r10
	add %r13, %r11
	ld.uh %r13, %r13
	;
	xld.h [%sp+2], %r13		; (save ptr)
	call.d %r3			; memLo = READ(ptr)
	ld.w %r12, %r0			; *delay*
	;
	xld.uh %r13, [%sp+2]		; (restore ptr)
	xld.b [%sp+1], %r10		; (save memLo) *anti-interlock*
	xadd %r13, %r13, 1		; (ptr+1)&0xffff
	ld.uh %r13, %r13
	call.d %r3			; HI(arg) = READ((ptr+1)&0xffff)
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r14, [%sp+1]		; (restore memLo)
	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_imz:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+1], %r10		; (save imm)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xoor %r15, %r10, 0x2000		; arg2 = zpg | 0x2000
	xld.ub %r14, [%sp+1]		; arg1 = imm
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_izx:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+1], %r10		; (save imm)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r15, [%r0+X]		; arg2 = ((zpg+X)&0xff) | 0x2000
	xld.ub %r14, [%sp+1]		; arg1 = imm *anti-interlock*
	add %r15, %r10
	ld.ub %r15, %r15
	xoor %r15, %r15, 0x2000
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zrl:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+1], %r10		; (save zpg)
	;
	ld.uh %r13, %r1			; rel = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	ld.b %r15, %r10			; arg2 = PC + (char)rel
	xld.ub %r14, [%sp+1]		; arg1 = zpg | 0x2000
	add %r15, %r1			; *anti-interlock*
	xoor %r14, %r14, 0x2000
	ld.uh %r15, %r15
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp huc6280_run_exec		; !NO-DELAY!
	;
huc6280_run_ima:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+1], %r10		; (save imm)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	xld.b [%sp+2], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r15, [%sp+2]		; (restore memLo)
	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r15, %r10			; arg2 = memLo | memHi<<8
	xld.ub %r14, [%sp+1]		; arg1 = imm
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_imx:
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+1], %r10		; (save imm)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	;
	xld.b [%sp+2], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	xld.ub %r15, [%sp+2]		; (restore memLo)
	xld.ub %r11, [%r0+X]		; arg2 = ((memLo | memHi<<8)+X)&0xffff
	xsll %r10, 8
	or %r15, %r10
	add %r15, %r11
	ld.uh %r15, %r15
	xld.ub %r14, [%sp+1]		; arg1 = imm
	;
	xld.ub %r13, [%sp+0]		; (restore code)
	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_blk:
	xld.b [%sp+8], %r13		; (save code)
	;
	ld.uh %r13, %r1			; SL = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+6], %r10		; (save SL)
	;
	ld.uh %r13, %r1			; SH = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+7], %r10		; (save SH)
	;
	ld.uh %r13, %r1			; DL = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+4], %r10		; (save DL)
	;
	ld.uh %r13, %r1			; DH = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+5], %r10		; (save DH)
	;
	ld.uh %r13, %r1			; LL = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.w [%sp+0], %r10		; (save LL, zero extend) => arg3
	;
	ld.uh %r13, %r1			; LH = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	xadd %r1, %r1, 1		; PC++
	xld.b [%sp+1], %r10		; (save LH             ) => arg3
	;
	xld.uh %r15, [%sp+4]		; arg2 = DHL
	xld.uh %r14, [%sp+6]		; arg1 = SHL
	xld.ub %r13, [%sp+8]		; (restore code)
	;** fall thru **
	;
huc6280_run_acc:
huc6280_run_imp:
huc6280_run_exec:
	xld.w %r10, [%r2+0]		; op->proc(arg)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11			; !INTERLOCK!
	xld.w [%r0+CYCLE], %r10
	xjrgt huc6280_run_L10		; if(CYCLE <= 0) break
huc6280_run_exit:
	;
	xadd %sp, %sp, 12
	popn %r3
	ret
	;
	.align 2
huc6280_run_table:			; Name                           | Syntax
	;===== operand bytes=0 =====	;                                |
	.word huc6280_run_acc	;  0	; accumulator                    | a
	.word huc6280_run_imp	;  1	; implied                        |
	;===== operand bytes=1 =====	;                                |
	.word huc6280_run_imm	;  2	; immediate                      | #$nn
	.word huc6280_run_zpg	;  3	; zero page                      | <$nn
	.word huc6280_run_zpx	;  4	; zero page, x-indexed           | <$nn,x
	.word huc6280_run_zpy	;  5	; zero page, y-indexed           | <$nn,y
	.word huc6280_run_zpi	;  6	; zero page indirect             | [$nn]
	.word huc6280_run_idx	;  7	; zero page pre-indexed          | [$nn,x]
	.word huc6280_run_idy	;  8	; zero page post-indexed         | [$nn],y
	.word huc6280_run_rel	;  9	; relative offset                | *
	;===== operand bytes=2 =====	;                                |
	.word huc6280_run_abs	; 10	; absolute                       | $nnnn
	.word huc6280_run_abx	; 11	; absolute x-indexed             | $nnnn,x
	.word huc6280_run_aby	; 12	; absolute y-indexed             | $nnnn,y
	.word huc6280_run_ind	; 13	; indirect                       | [$nnnn]
	.word huc6280_run_iax	; 14	; indirect, x-indexed            | [$nnnn,x]
	.word huc6280_run_imz	; 15	; immediate zero page            | #$nn,<$nn
	.word huc6280_run_izx	; 16	; immediate zero page, x-indexed | #$nn,<$nn,x
	.word huc6280_run_zrl	; 17	; zero page, relative offset     | <$nn,*
	;===== operand bytes=3 =====	;                                |
	.word huc6280_run_ima	; 18	; immediate absolute             | #$nn,$nnnn
	.word huc6280_run_imx	; 19	; immediate absolute, x-indexed  | #$nn,$nnnn,x
	;===== operand bytes=6 =====	;                                |
	.word huc6280_run_blk	; 20	; block transfer                 | $nnnn,$nnnn,$nnnn
	.align 1

;****************************************************************************
;	
;****************************************************************************

	.global huc6280_ADC
huc6280_ADC:
	xld.ub %r11, [%r12+P]			; %r11 = P
	xand %r15, %r11, 1			; %r15 = P(C)
	;
	swap %r13, %r13				; %r13[31:24] = a
	swap %r14, %r14				; %r14[31:24] = b
	add %r13, %r14				; %r13[31:24] = a + b
	ld.w %r4, %psr				; %r4 = %psr(1)
	;
	swap %r15, %r15				; %r15[31:24] = c
	add %r13, %r15				; %r13[31:24] = a + b + c
	ld.w %r5, %psr				; %r5 = %psr(2)
	;
	xand %r4, %r4, 0xc			; %r4 = %psr(C1,V1)
	xand %r6, %r5, 4			; %r6 = %psr(V2)
	xor %r4, %r6				; %r4 = %psr(C1,V1^V2)
	xand %r5, %r5, 0xb			; %r5 = %psr(C2,Z2,N2)
	or %r4, %r5				; %r4 = %psr(C1|C2,V1^V2,Z2,N2)
	xld.ub %r4, [%r4+huc6280_FLAG_CONV]	; %r4 = P(N,V,Z,C)
	xand %r11, %r11, ~0xe3			; %r11 = P(000BDI00)
	or %r11, %r4				; %r11 = P(NV0BDIZC)
	xld.b [%r12+P], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a + b + c *delay*

	.global huc6280_SBC
huc6280_SBC:
	xld.ub %r11, [%r12+P]			; %r11 = P
	xand %r15, %r11, 1			; %r15 = P(C)
	xxor %r15, %r15, 1			; P(C) = ~P(C)
	;
	swap %r13, %r13				; %r13[31:24] = a
	swap %r14, %r14				; %r14[31:24] = b
	sub %r13, %r14				; %r13[31:24] = a - b
	ld.w %r4, %psr				; %r4 = %psr(1)
	;
	swap %r15, %r15				; %r15[31:24] = c
	sub %r13, %r15				; %r13[31:24] = a - b - c
	ld.w %r5, %psr				; %r5 = %psr(2)
	;
	xand %r4, %r4, 0xc			; %r4 = %psr(C1,V1)
	xand %r6, %r5, 4			; %r6 = %psr(V2)
	xor %r4, %r6				; %r4 = %psr(C1,V1^V2)
	xand %r5, %r5, 0xb			; %r5 = %psr(C2,Z2,N2)
	or %r4, %r5				; %r4 = %psr(C1|C2,V1^V2,Z2,N2)
	xld.ub %r4, [%r4+huc6280_FLAG_CONV]	; %r4 = P(N,V,Z,C)
	xand %r11, %r11, ~0xe3			; %r11 = P(000BDI00)
	or %r11, %r4				; %r11 = P(NV0BDIZC)
	xxor %r11, %r11, 1			; P(C) = ~P(C)
	xld.b [%r12+P], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a - b - c *delay*

	.global huc6280_CMP
huc6280_CMP:
	xld.ub %r11, [%r12+P]			; %r11 = P
	;
	swap %r13, %r13				; %r13[31:24] = a
	swap %r14, %r14				; %r14[31:24] = b
	sub %r13, %r14				; %r13[31:24] = a - b
	ld.w %r10, %psr				; %r10 = %psr
	;
	xand %r10, %r10, 0xb			; %r10 = %psr(C,Z,N)
	xld.ub %r10, [%r10+huc6280_FLAG_CONV]	; P(N,Z,C)
	xand %r11, %r11, ~0xa3			; %r11 = P(0V0BDI00)
	or %r11, %r10				; %r11 = P(NV0BDIZC)
	xxor %r11, %r11, 1			; P(C) = ~P(C)
	xld.b [%r12+P], %r11
	;
	ret

	.global huc6280_AND
huc6280_AND:
	xld.ub %r11, [%r12+P]			; %r11 = P
	;
	and %r13, %r14				; %r13 = a & b
	xrr %r13, 8				; %r13[31:24] = a & b
	ld.w %r10, %psr				; ????????_??????ZN
	;
	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	xsrl %r10, 7				; ????????_??????ZN
	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	xld.b [%r12+P], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a & b *delay*

	.global huc6280_ORA
huc6280_ORA:
	xld.ub %r11, [%r12+P]			; %r11 = P
	;
	or %r13, %r14				; %r13 = a | b
	xrr %r13, 8				; %r13[31:24] = a & b
	ld.w %r10, %psr				; ????????_??????ZN
	;
	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	xsrl %r10, 7				; ????????_??????ZN
	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	xld.b [%r12+P], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a | b *delay*

	.global huc6280_EOR
huc6280_EOR:
	xld.ub %r11, [%r12+P]			; %r11 = P
	;
	xor %r13, %r14				; %r13 = a ^ b
	xrr %r13, 8				; %r13[31:24] = a & b
	ld.w %r10, %psr				; ????????_??????ZN
	;
	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	xsrl %r10, 7				; ????????_??????ZN
	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	xld.b [%r12+P], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a ^ b *delay*

	.global huc6280_BIT
huc6280_BIT:
	xld.ub %r11, [%r12+P]			; %r11 = P
	;
	and %r13, %r14				; %r13 = a & b
	ld.w %r10, %psr				; %r10 = %psr
	;
	xand %r11, %r11, ~0xe2			; P(N,V,T,Z)=0
	xand %r10, %r10, 2			; %r10 = %psr(Z)
	or %r11, %r10				; P(Z)
	xand %r14, %r14, 0xc0			; %r14 = b[7:6]
	or %r11, %r14				; P(N,V)=b[7:6](dl)
	xld.b [%r12+P], %r11
	;
	ret

	.global huc6280_INC
huc6280_INC:
	xld.ub %r11, [%r12+P]			; %r11 = P
	;
	swap %r13, %r13				; %r13[31:24] = a
	xadd %r13, %r13, 1<<24			; %r13[31:24] = a + 1
	ld.w %r10, %psr				; %r10 = %psr
	;
	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	xsrl %r10, 7				; ????????_??????ZN
	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	xld.b [%r12+P], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a + 1 *delay*

	.global huc6280_DEC
huc6280_DEC:
	xld.ub %r11, [%r12+P]			; %r11 = P
	;
	swap %r13, %r13				; %r13[31:24] = a
	xsub %r13, %r13, 1<<24			; %r13[31:24] = a - 1
	ld.w %r10, %psr				; %r10 = %psr
	;
	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	xsrl %r10, 7				; ????????_??????ZN
	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	xld.b [%r12+P], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a - 1 *delay*

;****************************************************************************
;	f[^]
;****************************************************************************

#macro LDr_IMM $1
	xld.ub %r11, [%r12+P]			; %r11 = P
	;
	xld.b [%r12+$1], %r14			; r = imm
	xrr %r14, 8				; %r14[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	xsrl %r10, 7				; ????????_??????ZN
	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	xld.b [%r12+P], %r11
	;
	ret
#endm

	.global huc6280op_LDA_IMM
huc6280op_LDA_IMM:
	LDr_IMM A
	.global huc6280op_LDX_IMM
huc6280op_LDX_IMM:
	LDr_IMM X
	.global huc6280op_LDY_IMM
huc6280op_LDY_IMM:
	LDr_IMM Y

;****************************************************************************

#macro LDr_MEM $1
	pushn %r0
	;
	xld.w %r10, [%r12+READ]			; %r10 = READ(mem)
	ld.w %r13, %r14				; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	xld.ub %r11, [%r0+P]			; %r11 = P
	;
	xld.b [%r0+$1], %r10			; r = READ(mem)
	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	xsrl %r10, 7				; ????????_??????ZN
	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	xld.b [%r0+P], %r11
	;
	popn %r0
	ret
#endm

	.global huc6280op_LDA_MEM
huc6280op_LDA_MEM:
	LDr_MEM A
	.global huc6280op_LDX_MEM
huc6280op_LDX_MEM:
	LDr_MEM X
	.global huc6280op_LDY_MEM
huc6280op_LDY_MEM:
	LDr_MEM Y

;****************************************************************************

#macro STr_MEM $1
	xbclr [%r12+P], 5			; P(T)=0
	;
	xld.w %r10, [%r12+WRITE]		; WRITE(mem, r)
	ld.w %r13, %r14
	xld.ub %r14, [%r12+$1]
	call %r10
	;
	ret
#endm

	.global huc6280op_STA_MEM
huc6280op_STA_MEM:
	STr_MEM A
	.global huc6280op_STX_MEM
huc6280op_STX_MEM:
	STr_MEM X
	.global huc6280op_STY_MEM
huc6280op_STY_MEM:
	STr_MEM Y

;****************************************************************************

#macro CLr_IMP $1
	xbclr [%r12+P], 5			; P(T)=0
	xld.b [%r12+$1], %r8			; r = 0
	ret
#endm

	.global huc6280op_CLA_IMP
huc6280op_CLA_IMP:
	CLr_IMP A
	.global huc6280op_CLX_IMP
huc6280op_CLX_IMP:
	CLr_IMP X
	.global huc6280op_CLY_IMP
huc6280op_CLY_IMP:
	CLr_IMP Y

;****************************************************************************

#macro Trr_IMP $1, $2
	xld.ub %r11, [%r12+P]			; %r11 = P
	;
	xld.ub %r10, [%r12+$1]			; r2 = r1
	xld.b [%r12+$2], %r10
	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	xsrl %r10, 7				; ????????_??????ZN
	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	xld.b [%r12+P], %r11
	;
	ret
#endm

	.global huc6280op_TXA_IMP
huc6280op_TXA_IMP:
	Trr_IMP X, A
	.global huc6280op_TYA_IMP
huc6280op_TYA_IMP:
	Trr_IMP Y, A
	.global huc6280op_TAX_IMP
huc6280op_TAX_IMP:
	Trr_IMP A, X
	.global huc6280op_TAY_IMP
huc6280op_TAY_IMP:
	Trr_IMP A, Y
	.global huc6280op_TSX_IMP
huc6280op_TSX_IMP:
	Trr_IMP S, X

;****************************************************************************

#macro Srr_IMP $1, $2
	xbclr [%r12+P], 5			; P(T)=0
	;
	xld.ub %r10, [%r12+$1]			; %r10 = r1
	xld.ub %r11, [%r12+$2]			; %r11 = r2
	xld.b [%r12+$2], %r10			; r2 = %r10
	xld.b [%r12+$1], %r11			; r1 = %r11
	;
	ret
#endm

	.global huc6280op_SAX_IMP
huc6280op_SAX_IMP:
	Srr_IMP A, X
	.global huc6280op_SAY_IMP
huc6280op_SAY_IMP:
	Srr_IMP A, Y
	.global huc6280op_SXY_IMP
huc6280op_SXY_IMP:
	Srr_IMP X, Y

;****************************************************************************

#macro PHr_IMP $1
	xbclr [%r12+P], 5			; P(T)=0
	;
	xld.w %r10, [%r12+WRITE]		; WRITE(S|0x2100, r)
	xld.ub %r13, [%r12+S]
	xld.ub %r14, [%r12+$1]			; *anti-interlock*
	xsub %r11, %r13, 1			; S--
	xld.b [%r12+S], %r11
	xoor %r13, %r13, 0x2100
	call %r10
	;
	ret
#endm

	.global huc6280op_PHA_IMP
huc6280op_PHA_IMP:
	PHr_IMP A
	.global huc6280op_PHX_IMP
huc6280op_PHX_IMP:
	PHr_IMP X
	.global huc6280op_PHY_IMP
huc6280op_PHY_IMP:
	PHr_IMP Y
	.global huc6280op_PHP_IMP
huc6280op_PHP_IMP:
	PHr_IMP P

;****************************************************************************

#macro PLr_IMP $1
	pushn %r0
	;
	xld.ub %r13, [%r12+S]			; S++
	xld.w %r10, [%r12+READ]			; *anti-interlock*
	xadd %r13, %r13, 1
	xld.b [%r12+S], %r13
	//ld.ub %r13, %r13			; ͕svB%r13[8]=1ŒȂ̂Ōオ肵ĂĂ֌WȂB
	xoor %r13, %r13, 0x2100			; %r10 = READ(S|0x2100)
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	xld.ub %r11, [%r0+P]			; %r11 = P
	;
	xld.b [%r0+$1], %r10			; r = READ(S|0x2100)
	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	xsrl %r10, 7				; ????????_??????ZN
	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	xld.b [%r0+P], %r11
	;
	popn %r0
	ret
#endm

	.global huc6280op_PLA_IMP
huc6280op_PLA_IMP:
	PLr_IMP A
	.global huc6280op_PLX_IMP
huc6280op_PLX_IMP:
	PLr_IMP X
	.global huc6280op_PLY_IMP
huc6280op_PLY_IMP:
	PLr_IMP Y

;****************************************************************************
;	t[
;****************************************************************************

	.global huc6280op_BRA_MEM
huc6280op_BRA_MEM:
	xbclr [%r12+P], 5			; P(T)=0
	xld.h [%r12+PC], %r14			; PC
	ret

	.global huc6280op_BSR_MEM
huc6280op_BSR_MEM:
	pushn %r2
	;
	xbclr [%r12+P], 5			; P(T)=0
	;
	xld.ub %r1, [%r12+S]			; S|0x2100
	xld.uh %r2, [%r12+PC]			; PC--(dl) *anti-interlock*
	xoor %r1, %r1, 0x2100			;            *anti-interlock*
	xsub %r2, %r2, 1
	;
	xld.h [%r12+PC], %r14			; PC
	;
	xld.w %r10, [%r12+WRITE]		; PUSH(PCH)
	ld.w %r13, %r1
	ld.uh %r14, %r2
	xsrl %r14, 8
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	;					; S|0x2100 == 0x2100       `0x21ff
	xsub %r1, %r1, 1			; -1       => 0x20ff       `0x21fe
	xoor %r1, %r1, 0x2100			;  |0x2100 => 0x21ff,0x2100`0x21fe
	;
	xld.w %r10, [%r0+WRITE]			; PUSH(PCL)
	ld.w %r13, %r1
	ld.ub %r14, %r2
	call.d %r10
	ld.w %r12, %r0				; *delay*
	;
	xsub %r1, %r1, 1			; S--
	xld.b [%r0+S], %r1
	;
	popn %r2
	ret

	.global huc6280op_RTS_IMP
huc6280op_RTS_IMP:
	pushn %r2
	;
	xbclr [%r12+P], 5			; P(T)=0
	;
	xld.ub %r1, [%r12+S]			; S        == 0x0000`       0x00ff
	xld.w %r10, [%r12+READ]			; *anti-interlock*
	xadd %r1, %r1, 1			; +1       => 0x0001`       0x0100
	xoor %r1, %r1, 0x2100			; S|0x2100 => 0x2101`0x21ff,0x2100
	;
	ld.w %r13, %r1				; POP(PCL)
	call.d %r10
	ld.w %r0, %r12				; *delay*
	ld.w %r2, %r10				; (save PCL)
	;
	;					; S|0x2100 == 0x2100`       0x21ff
	xadd %r1, %r1, 1			; +1       => 0x2101`       0x2200
	ld.ub %r1, %r1				;          => 0x0001`0x00ff,0x0000
	xoor %r1, %r1, 0x2100			;  |0x2100 => 0x2101`0x21ff,0x2100
	;
	xld.w %r10, [%r0+READ]			; POP(PCH)
	ld.w %r13, %r1				; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0				; *delay*
	;
	xsll %r10, 8				; PC = PCL | PCH << 8
	or %r10, %r2
	xadd %r10, %r10, 1			; PC++(dl)
	xld.h [%r0+PC], %r10
	;
	xld.b [%r0+S], %r1			; S
	;
	popn %r2
	ret

;****************************************************************************

#macro Bclr_MEM $1
	xbclr [%r12+P], 5			; P(T)=0
	;
	xbtst [%r12+P], $1			; if(P(?)) no-branch
	xjrne $$1
	;
	xld.w %r10, [%r12+CYCLE]		; CYCLE--
	xld.h [%r12+PC], %r14			; PC *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
$$1:
	ret
#endm

	.global huc6280op_BCC_MEM
huc6280op_BCC_MEM:
	Bclr_MEM 0
	.global huc6280op_BNE_MEM
huc6280op_BNE_MEM:
	Bclr_MEM 1
	.global huc6280op_BVC_MEM
huc6280op_BVC_MEM:
	Bclr_MEM 6
	.global huc6280op_BPL_MEM
huc6280op_BPL_MEM:
	Bclr_MEM 7

;****************************************************************************

#macro Bset_MEM $1
	xbclr [%r12+P], 5			; P(T)=0
	;
	xbtst [%r12+P], $1			; if(!P(?)) no-branch
	xjreq $$1
	;
	xld.w %r10, [%r12+CYCLE]		; CYCLE--
	xld.h [%r12+PC], %r14			; PC *anti-interlock*
	xsub %r10, %r10, 1
	xld.w [%r12+CYCLE], %r10
$$1:
	ret
#endm

	.global huc6280op_BCS_MEM
huc6280op_BCS_MEM:
	Bset_MEM 0
	.global huc6280op_BEQ_MEM
huc6280op_BEQ_MEM:
	Bset_MEM 1
	.global huc6280op_BVS_MEM
huc6280op_BVS_MEM:
	Bset_MEM 6
	.global huc6280op_BMI_MEM
huc6280op_BMI_MEM:
	Bset_MEM 7

;****************************************************************************
;	$1($2,arg)
;****************************************************************************

#macro S1IS2_argI $1, $2
	xld.ub %r13, [%r12+$2]
	xjp huc6280_$1
#endm

	.global huc6280op_CMP_IMM
huc6280op_CMP_IMM:
	S1IS2_argI CMP, A
	.global huc6280op_CPX_IMM
huc6280op_CPX_IMM:
	S1IS2_argI CMP, X
	.global huc6280op_CPY_IMM
huc6280op_CPY_IMM:
	S1IS2_argI CMP, Y

	.global huc6280op_BIT_IMM
huc6280op_BIT_IMM:
	S1IS2_argI BIT, A

;****************************************************************************
;	$1($2,READ(arg))
;****************************************************************************

#macro S1IS2_READIargII $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	xld.ub %r13, [%r0+$2]
	xcall.d huc6280_$1		; *delay*
	ld.w %r12, %r0
	;
	popn %r0
	ret
#endm

	.global huc6280op_CMP_MEM
huc6280op_CMP_MEM:
	S1IS2_READIargII CMP, A
	.global huc6280op_CPX_MEM
huc6280op_CPX_MEM:
	S1IS2_READIargII CMP, X
	.global huc6280op_CPY_MEM
huc6280op_CPY_MEM:
	S1IS2_READIargII CMP, Y

	.global huc6280op_BIT_MEM
huc6280op_BIT_MEM:
	S1IS2_READIargII BIT, A

;****************************************************************************
;	$2=$1($2)
;****************************************************************************

#macro S2_S1I$2I $1, $2
	pushn %r0
	;
	xld.ub %r13, [%r12+$2]
	xcall.d huc6280_$1
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

	.global huc6280op_INC_ACC
huc6280op_INC_ACC:
	S2_S1I$2I INC, A
	.global huc6280op_INX_IMP
huc6280op_INX_IMP:
	S2_S1I$2I INC, X
	.global huc6280op_INY_IMP
huc6280op_INY_IMP:
	S2_S1I$2I INC, Y
	.global huc6280op_DEC_ACC
huc6280op_DEC_ACC:
	S2_S1I$2I DEC, A
	.global huc6280op_DEX_IMP
huc6280op_DEX_IMP:
	S2_S1I$2I DEC, X
	.global huc6280op_DEY_IMP
huc6280op_DEY_IMP:
	S2_S1I$2I DEC, Y

	.global huc6280op_ASL_ACC
huc6280op_ASL_ACC:
	S2_S1I$2I ASL, A
	.global huc6280op_LSR_ACC
huc6280op_LSR_ACC:
	S2_S1I$2I LSR, A
	.global huc6280op_ROL_ACC
huc6280op_ROL_ACC:
	S2_S1I$2I ROL, A
	.global huc6280op_ROR_ACC
huc6280op_ROR_ACC:
	S2_S1I$2I ROR, A

;****************************************************************************
;	WRITE(arg,$1(READ(arg)))
;****************************************************************************

#macro WRITEIarg_S1IREADIargIII $1
	pushn %r1
	ld.w %r1, %r14
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	xcall.d huc6280_$1
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	xld.w %r10, [%r0+WRITE]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
#endm

	.global huc6280op_INC_MEM
huc6280op_INC_MEM:
	WRITEIarg_S1IREADIargIII INC
	.global huc6280op_DEC_MEM
huc6280op_DEC_MEM:
	WRITEIarg_S1IREADIargIII DEC
	.global huc6280op_ASL_MEM
huc6280op_ASL_MEM:
	WRITEIarg_S1IREADIargIII ASL
	.global huc6280op_LSR_MEM
huc6280op_LSR_MEM:
	WRITEIarg_S1IREADIargIII LSR
	.global huc6280op_ROL_MEM
huc6280op_ROL_MEM:
	WRITEIarg_S1IREADIargIII ROL
	.global huc6280op_ROR_MEM
huc6280op_ROR_MEM:
	WRITEIarg_S1IREADIargIII ROR

;****************************************************************************
;	$2=$1($2,arg)
;****************************************************************************

#macro S2_S1IS2_argI $1, $2
	pushn %r0
	;
	xld.ub %r13, [%r12+$2]
	xcall.d huc6280_$1
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

	.global huc6280op_AND_IMM
huc6280op_AND_IMM:
	S2_S1IS2_argI AND, A		/* P(T)Ή */
	.global huc6280op_ORA_IMM
huc6280op_ORA_IMM:
	S2_S1IS2_argI ORA, A		/* P(T)Ή */
	.global huc6280op_EOR_IMM
huc6280op_EOR_IMM:
	S2_S1IS2_argI EOR, A		/* P(T)Ή */

;****************************************************************************
;	$2=$1($2,READ(arg))
;****************************************************************************

#macro S2_S1IS2_READIargII $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	xld.ub %r13, [%r0+$2]
	xcall.d huc6280_$1		; *delay*
	ld.w %r12, %r0
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

	.global huc6280op_AND_MEM
huc6280op_AND_MEM:
	S2_S1IS2_READIargII AND, A	/* P(T)Ή */
	.global huc6280op_ORA_MEM
huc6280op_ORA_MEM:
	S2_S1IS2_READIargII ORA, A	/* P(T)Ή */
	.global huc6280op_EOR_MEM
huc6280op_EOR_MEM:
	S2_S1IS2_READIargII EOR, A	/* P(T)Ή */

;****************************************************************************
;	
;****************************************************************************

#endif /*HUC6280_ASM*/
