;	
;	framc62a.s
;
;	P/ECE HuC6280 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clipc62a.h"
;/	
;/	clipc62a.h
;/
;/	P/ECE HuC6280 Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2004 Naoyuki Sawa
;/
;/	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define HUC6280_ASM
;#ifdef HUC6280_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	HUC6280\
;
;*===== WX^ =====*/
;#define P	 0
;#define A	 1
;#define X	 2
;#define Y	 3
;#define PC	 4
;#define S	 6
;#define MPR_EN	 7
;#define MPR	 8
;*=====  =====*/
;#define CYCLE	16
;#define HALT	20
;#define PENDING	21
;*===== O֐ =====*/
;#define READ	24
;#define WRITE	28
;#define MPRSET	32
;#define VDCOUT	36

;
;	C33=>HuC6280tOϊ\
;
				; C33(C,V,Z,N) => HuC6280(S,Z,V,C)
				; ====C33====     ==HuC6280==
huc6280_FLAG_CONV:		; ----CVZN        NV----ZC
	.byte	0x00		; 00000000 00     00000000 00
	.byte	0x80		; 00000001 01     10000000 80
	.byte	0x02		; 00000010 02     00000010 02
	.byte	0x82		; 00000011 03     10000010 82
	.byte	0x40		; 00000100 04     01000000 40
	.byte	0xc0		; 00000101 05     11000000 c0
	.byte	0x42		; 00000110 06     01000010 42
	.byte	0xc2		; 00000111 07     11000010 c2
	.byte	0x01		; 00001000 08     00000001 01
	.byte	0x81		; 00001001 09     10000001 81
	.byte	0x03		; 00001010 0a     00000011 03
	.byte	0x83		; 00001011 0b     10000011 83
	.byte	0x41		; 00001100 0c     01000001 41
	.byte	0xc1		; 00001101 0d     11000001 c1
	.byte	0x43		; 00001110 0e     01000011 43
	.byte	0xc3		; 00001111 0f     11000011 c3

;****************************************************************************
;
;****************************************************************************

	.global huc6280_run
huc6280_run:
	pushn %r3
	sub	%sp,0x3		; 	xsub %sp, %sp, 12
	;
	ld.w %r0, %r12			; huc6280
	ext	0x18		; 	xld.w %r3, [%r0+0x18]		; huc6280->read
	ld.w	%r3,[%r0]
	ext	0x10		; 	xld.w [%r0+0x10], %r13		; CYCLE
	ld.w	[%r0],%r13
	cmp	%r13,0x0	; 	xcmp %r13, 0			; if(CYCLE <= 0) break
	ext	huc6280_run_exit@rm	; 	xjrle huc6280_run_exit
	jrle	huc6280_run_exit@rl
	;
huc6280_run_L10:
	ext	0x14		; 	xld.ub %r10, [%r0+0x14]		; if(HALT) break
	ld.ub	%r10,[%r0]
	ext	0x4		; 	xld.uh %r1, [%r0+0x4]		; PC *anti-interlock*
	ld.uh	%r1,[%r0]
	cmp	%r10,0x0	; 	xcmp %r10, 0
	ext	huc6280_run_exit@rm	; 	xjrne huc6280_run_exit
	jrne	huc6280_run_exit@rl
	;
	ld.uh %r13, %r1			; code = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.ub %r13, %r10
	;
	ext	huc6280_op_table+0x0@h	; 	xld.w %r2, huc6280_op_table	; op = &huc6280_op_table[code]
	ext	huc6280_op_table+0x0@m
	ld.w	%r2,huc6280_op_table+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; switch(op->addr)
	ld.ub	%r10,[%r2]
	ext	huc6280_run_table+0x0@h	; 	xld.w %r11, huc6280_run_table	; *anti-interlock*
	ext	huc6280_run_table+0x0@m
	ld.w	%r11,huc6280_run_table+0x0@l
	sll	%r10,0x2	; 	xsll %r10, 2
	add %r10, %r11
	ld.w	%r10,[%r10]	; 	xld.w %r10, [%r10]
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++ *anti-interlock*
	jp %r10
	;
huc6280_run_imm:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10			; arg1 = imm
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zpg:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x1		; 	xoor %r14, %r10, 0x2000		; arg1 = zpg | 0x2000
	ext	0x0
	or	%r14,%r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zpx:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x2		; 	xld.ub %r14, [%r0+0x2]		; arg1 = ((zpg+X)&0xff) | 0x2000
	ld.ub	%r14,[%r0]
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	ext	0x80		; 	xoor %r14, %r14, 0x2000
	or	%r14,0x0
	;
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zpy:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x3		; 	xld.ub %r14, [%r0+0x3]		; arg1 = ((zpg+Y)&0xff) | 0x2000
	ld.ub	%r14,[%r0]
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	ext	0x80		; 	xoor %r14, %r14, 0x2000
	or	%r14,0x0
	;
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zpi:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x1		; 	xoor %r13, %r10, 0x2000		; zpg | 0x2000
	ext	0x0
	or	%r13,%r10
	add	%r10,0x1	; 	xadd %r10, %r10, 1		; (save (zpg+1)&0xff)
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10
	;
	call.d %r3			; memLo = READ(zpg | 0x2000)
	ld.w %r12, %r0			; *delay*
	ld.ub	%r13,[%sp+0x1]	; 	xld.ub %r13, [%sp+0x1]		; (restore (zpg+1)&0xff)
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save memLo)
	ext	0x80		; 	xoor %r13, %r13, 0x2000		; ((zpg+1)&0xff) | 0x2000
	or	%r13,0x0
	call.d %r3			; memHi = READ(((zpg+1)&0xff) | 0x2000)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore memLo)
	sll	%r10,0x8	; 	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_idx:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]		; (zpg+X)&0xff
	ld.ub	%r13,[%r0]
	add %r10, %r13			; !INTERLOCK!
	ld.ub %r10, %r10
	;
	ext	0x1		; 	xoor %r13, %r10, 0x2000		; ((zpg+X)&0xff) | 0x2000
	ext	0x0
	or	%r13,%r10
	add	%r10,0x1	; 	xadd %r10, %r10, 1		; (save (zpg+X+1)&0xff)
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10
	;
	call.d %r3			; memLo = READ((zpg+X)&0xff) | 0x2000
	ld.w %r12, %r0			; *delay*
	ld.ub	%r13,[%sp+0x1]	; 	xld.ub %r13, [%sp+0x1]		; (restore (zpg+X+1)&0xff)
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save memLo)
	ext	0x80		; 	xoor %r13, %r13, 0x2000		; ((zpg+X+1)&0xff) | 0x2000
	or	%r13,0x0
	call.d %r3			; memHi = READ(((zpg+X+1)&0xff) | 0x2000)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore memLo)
	sll	%r10,0x8	; 	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_idy:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x1		; 	xoor %r13, %r10, 0x2000		; zpg | 0x2000
	ext	0x0
	or	%r13,%r10
	add	%r10,0x1	; 	xadd %r10, %r10, 1		; (save (zpg+1)&0xff)
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10
	;
	call.d %r3			; memLo = READ(zpg | 0x2000)
	ld.w %r12, %r0			; *delay*
	ld.ub	%r13,[%sp+0x1]	; 	xld.ub %r13, [%sp+0x1]		; (restore (zpg+1)&0xff)
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save memLo)
	ext	0x80		; 	xoor %r13, %r13, 0x2000		; ((zpg+1)&0xff) | 0x2000
	or	%r13,0x0
	call.d %r3			; memHi = READ(((zpg+1)&0xff) | 0x2000)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore memLo)
	sll	%r10,0x8	; 	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; mem = memLo | memHi<<8
	;
	ext	0x3		; 	xld.ub %r10, [%r0+0x3]		; arg1 = (mem+Y)&0xffff
	ld.ub	%r10,[%r0]
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.uh %r14, %r14
	;
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_rel:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; rel = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b %r14, %r10			; arg1 = PC + (char)rel
	add %r14, %r1
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp huc6280_run_exec		; !NO-DELAY!
	jp	huc6280_run_exec@rl
	;
huc6280_run_abs:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore memLo)
	sll	%r10,0x8	; 	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_abx:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore memLo)
	ext	0x2		; 	xld.ub %r11, [%r0+0x2]		; arg1 = ((memLo | memHi<<8)+X)&0xffff
	ld.ub	%r11,[%r0]
	sll	%r10,0x8	; 	xsll %r10, 8
	or %r14, %r10
	add %r14, %r11
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_aby:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore memLo)
	ext	0x3		; 	xld.ub %r11, [%r0+0x3]		; arg1 = ((memLo | memHi<<8)+Y)&0xffff
	ld.ub	%r11,[%r0]
	sll	%r10,0x8	; 	xsll %r10, 8
	or %r14, %r10
	add %r14, %r11
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_ind:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; ptrLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save ptrLo)
	ld.uh %r13, %r1			; ptrHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r13,[%sp+0x1]	; 	xld.ub %r13, [%sp+0x1]		; (restore ptrLo)
	sll	%r10,0x8	; 	xsll %r10, 8			; ptrHi<<8 *anti-interlock*
	or %r13, %r10			; ptr = ptrLo | ptrHi<<8
	;
	ld.h	[%sp+0x1],%r13	; 	xld.h [%sp+0x2], %r13		; (save ptr)
	call.d %r3			; memLo = READ(ptr)
	ld.w %r12, %r0			; *delay*
	;
	ld.uh	%r13,[%sp+0x1]	; 	xld.uh %r13, [%sp+0x2]		; (restore ptr)
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save memLo) *anti-interlock*
	add	%r13,0x1	; 	xadd %r13, %r13, 1		; (ptr+1)&0xffff
	ld.uh %r13, %r13
	call.d %r3			; memHi = READ((ptr+1)&0xffff)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore memLo)
	sll	%r10,0x8	; 	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_iax:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; ptrLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save ptrLo)
	ld.uh %r13, %r1			; ptrHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r13,[%sp+0x1]	; 	xld.ub %r13, [%sp+0x1]		; (restore ptrLo)
	ext	0x2		; 	xld.ub %r11, [%r0+0x2]		; ptr = ((ptrLo | ptrHi<<8)+X)&0xffff
	ld.ub	%r11,[%r0]
	sll	%r10,0x8	; 	xsll %r10, 8
	or %r13, %r10
	add %r13, %r11
	ld.uh %r13, %r13
	;
	ld.h	[%sp+0x1],%r13	; 	xld.h [%sp+0x2], %r13		; (save ptr)
	call.d %r3			; memLo = READ(ptr)
	ld.w %r12, %r0			; *delay*
	;
	ld.uh	%r13,[%sp+0x1]	; 	xld.uh %r13, [%sp+0x2]		; (restore ptr)
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save memLo) *anti-interlock*
	add	%r13,0x1	; 	xadd %r13, %r13, 1		; (ptr+1)&0xffff
	ld.uh %r13, %r13
	call.d %r3			; HI(arg) = READ((ptr+1)&0xffff)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore memLo)
	sll	%r10,0x8	; 	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r14, %r10			; arg1 = memLo | memHi<<8
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	huc6280_run_exec@rm	; 	xjp.d huc6280_run_exec
	jp.d	huc6280_run_exec@rl
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_imz:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save imm)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x1		; 	xoor %r15, %r10, 0x2000		; arg2 = zpg | 0x2000
	ext	0x0
	or	%r15,%r10
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; arg1 = imm
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	huc6280_run_exec	; 	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_izx:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save imm)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x2		; 	xld.ub %r15, [%r0+0x2]		; arg2 = ((zpg+X)&0xff) | 0x2000
	ld.ub	%r15,[%r0]
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; arg1 = imm *anti-interlock*
	add %r15, %r10
	ld.ub %r15, %r15
	ext	0x80		; 	xoor %r15, %r15, 0x2000
	or	%r15,0x0
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	huc6280_run_exec	; 	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_zrl:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; zpg = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save zpg)
	;
	ld.uh %r13, %r1			; rel = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b %r15, %r10			; arg2 = PC + (char)rel
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; arg1 = zpg | 0x2000
	add %r15, %r1			; *anti-interlock*
	ext	0x80		; 	xoor %r14, %r14, 0x2000
	or	%r14,0x0
	ld.uh %r15, %r15
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp	huc6280_run_exec	; 	xjp huc6280_run_exec		; !NO-DELAY!
	;
huc6280_run_ima:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save imm)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b	[%sp+0x2],%r10	; 	xld.b [%sp+0x2], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r15,[%sp+0x2]	; 	xld.ub %r15, [%sp+0x2]		; (restore memLo)
	sll	%r10,0x8	; 	xsll %r10, 8			; memHi<<8 *anti-interlock*
	or %r15, %r10			; arg2 = memLo | memHi<<8
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; arg1 = imm
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	huc6280_run_exec	; 	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_imx:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.uh %r13, %r1			; imm = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save imm)
	;
	ld.uh %r13, %r1			; memLo = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b	[%sp+0x2],%r10	; 	xld.b [%sp+0x2], %r10		; (save memLo)
	ld.uh %r13, %r1			; memHi = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r15,[%sp+0x2]	; 	xld.ub %r15, [%sp+0x2]		; (restore memLo)
	ext	0x2		; 	xld.ub %r11, [%r0+0x2]		; arg2 = ((memLo | memHi<<8)+X)&0xffff
	ld.ub	%r11,[%r0]
	sll	%r10,0x8	; 	xsll %r10, 8
	or %r15, %r10
	add %r15, %r11
	ld.uh %r15, %r15
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; arg1 = imm
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	huc6280_run_exec	; 	xjp.d huc6280_run_exec
	add %r1, 1			; PC++ *delay*
	;
huc6280_run_blk:
	ld.b	[%sp+0x8],%r13	; 	xld.b [%sp+0x8], %r13		; (save code)
	;
	ld.uh %r13, %r1			; SL = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x6],%r10	; 	xld.b [%sp+0x6], %r10		; (save SL)
	;
	ld.uh %r13, %r1			; SH = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x7],%r10	; 	xld.b [%sp+0x7], %r10		; (save SH)
	;
	ld.uh %r13, %r1			; DL = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x4],%r10	; 	xld.b [%sp+0x4], %r10		; (save DL)
	;
	ld.uh %r13, %r1			; DH = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x5],%r10	; 	xld.b [%sp+0x5], %r10		; (save DH)
	;
	ld.uh %r13, %r1			; LL = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.w	[%sp+0x0],%r10	; 	xld.w [%sp+0x0], %r10		; (save LL, zero extend) => arg3
	;
	ld.uh %r13, %r1			; LH = READ(PC)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save LH             ) => arg3
	;
	ld.uh	%r15,[%sp+0x2]	; 	xld.uh %r15, [%sp+0x4]		; arg2 = DHL
	ld.uh	%r14,[%sp+0x3]	; 	xld.uh %r14, [%sp+0x6]		; arg1 = SHL
	ld.ub	%r13,[%sp+0x8]	; 	xld.ub %r13, [%sp+0x8]		; (restore code)
	;** fall thru **
	;
huc6280_run_acc:
huc6280_run_imp:
huc6280_run_exec:
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(arg)
	ext	0x4		; 	xld.h [%r0+0x4], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11			; !INTERLOCK!
	ext	0x10		; 	xld.w [%r0+0x10], %r10
	ld.w	[%r0],%r10
	ext	huc6280_run_L10@rm	; 	xjrgt huc6280_run_L10		; if(CYCLE <= 0) break
	jrgt	huc6280_run_L10@rl
huc6280_run_exit:
	;
	add	%sp,0x3		; 	xadd %sp, %sp, 12
	popn %r3
	ret
	;
	.align 2
huc6280_run_table:			; Name                           | Syntax
	;===== operand bytes=0 =====	;                                |
	.word huc6280_run_acc	;  0	; accumulator                    | a
	.word huc6280_run_imp	;  1	; implied                        |
	;===== operand bytes=1 =====	;                                |
	.word huc6280_run_imm	;  2	; immediate                      | #$nn
	.word huc6280_run_zpg	;  3	; zero page                      | <$nn
	.word huc6280_run_zpx	;  4	; zero page, x-indexed           | <$nn,x
	.word huc6280_run_zpy	;  5	; zero page, y-indexed           | <$nn,y
	.word huc6280_run_zpi	;  6	; zero page indirect             | [$nn]
	.word huc6280_run_idx	;  7	; zero page pre-indexed          | [$nn,x]
	.word huc6280_run_idy	;  8	; zero page post-indexed         | [$nn],y
	.word huc6280_run_rel	;  9	; relative offset                | *
	;===== operand bytes=2 =====	;                                |
	.word huc6280_run_abs	; 10	; absolute                       | $nnnn
	.word huc6280_run_abx	; 11	; absolute x-indexed             | $nnnn,x
	.word huc6280_run_aby	; 12	; absolute y-indexed             | $nnnn,y
	.word huc6280_run_ind	; 13	; indirect                       | [$nnnn]
	.word huc6280_run_iax	; 14	; indirect, x-indexed            | [$nnnn,x]
	.word huc6280_run_imz	; 15	; immediate zero page            | #$nn,<$nn
	.word huc6280_run_izx	; 16	; immediate zero page, x-indexed | #$nn,<$nn,x
	.word huc6280_run_zrl	; 17	; zero page, relative offset     | <$nn,*
	;===== operand bytes=3 =====	;                                |
	.word huc6280_run_ima	; 18	; immediate absolute             | #$nn,$nnnn
	.word huc6280_run_imx	; 19	; immediate absolute, x-indexed  | #$nn,$nnnn,x
	;===== operand bytes=6 =====	;                                |
	.word huc6280_run_blk	; 20	; block transfer                 | $nnnn,$nnnn,$nnnn
	.align 1

;****************************************************************************
;	
;****************************************************************************

	.global huc6280_ADC
huc6280_ADC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P
	ext	0x1		; 	xand %r15, %r11, 1			; %r15 = P(C)
	and	%r15,%r11
	;
	swap %r13, %r13				; %r13[31:24] = a
	swap %r14, %r14				; %r14[31:24] = b
	add %r13, %r14				; %r13[31:24] = a + b
	ld.w %r4, %psr				; %r4 = %psr(1)
	;
	swap %r15, %r15				; %r15[31:24] = c
	add %r13, %r15				; %r13[31:24] = a + b + c
	ld.w %r5, %psr				; %r5 = %psr(2)
	;
	and	%r4,0xc		; 	xand %r4, %r4, 0xc			; %r4 = %psr(C1,V1)
	ext	0x4		; 	xand %r6, %r5, 4			; %r6 = %psr(V2)
	and	%r6,%r5
	xor %r4, %r6				; %r4 = %psr(C1,V1^V2)
	and	%r5,0xb		; 	xand %r5, %r5, 0xb			; %r5 = %psr(C2,Z2,N2)
	or %r4, %r5				; %r4 = %psr(C1|C2,V1^V2,Z2,N2)
	ext	huc6280_FLAG_CONV+0x0@h	; 	xld.ub %r4, [%r4+huc6280_FLAG_CONV]	; %r4 = P(N,V,Z,C)
	ext	huc6280_FLAG_CONV+0x0@m
	ld.w	%r9,huc6280_FLAG_CONV+0x0@l
	add	%r9,%r4
	ld.ub	%r4,[%r9]
	ext	0x1ffc		; 	xand %r11, %r11, -228			; %r11 = P(000BDI00)
	and	%r11,0x1c
	or %r11, %r4				; %r11 = P(NV0BDIZC)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a + b + c *delay*

	.global huc6280_SBC
huc6280_SBC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P
	ext	0x1		; 	xand %r15, %r11, 1			; %r15 = P(C)
	and	%r15,%r11
	xor	%r15,0x1	; 	xxor %r15, %r15, 1			; P(C) = ~P(C)
	;
	swap %r13, %r13				; %r13[31:24] = a
	swap %r14, %r14				; %r14[31:24] = b
	sub %r13, %r14				; %r13[31:24] = a - b
	ld.w %r4, %psr				; %r4 = %psr(1)
	;
	swap %r15, %r15				; %r15[31:24] = c
	sub %r13, %r15				; %r13[31:24] = a - b - c
	ld.w %r5, %psr				; %r5 = %psr(2)
	;
	and	%r4,0xc		; 	xand %r4, %r4, 0xc			; %r4 = %psr(C1,V1)
	ext	0x4		; 	xand %r6, %r5, 4			; %r6 = %psr(V2)
	and	%r6,%r5
	xor %r4, %r6				; %r4 = %psr(C1,V1^V2)
	and	%r5,0xb		; 	xand %r5, %r5, 0xb			; %r5 = %psr(C2,Z2,N2)
	or %r4, %r5				; %r4 = %psr(C1|C2,V1^V2,Z2,N2)
	ext	huc6280_FLAG_CONV+0x0@h	; 	xld.ub %r4, [%r4+huc6280_FLAG_CONV]	; %r4 = P(N,V,Z,C)
	ext	huc6280_FLAG_CONV+0x0@m
	ld.w	%r9,huc6280_FLAG_CONV+0x0@l
	add	%r9,%r4
	ld.ub	%r4,[%r9]
	ext	0x1ffc		; 	xand %r11, %r11, -228			; %r11 = P(000BDI00)
	and	%r11,0x1c
	or %r11, %r4				; %r11 = P(NV0BDIZC)
	xor	%r11,0x1	; 	xxor %r11, %r11, 1			; P(C) = ~P(C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a - b - c *delay*

	.global huc6280_CMP
huc6280_CMP:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P
	;
	swap %r13, %r13				; %r13[31:24] = a
	swap %r14, %r14				; %r14[31:24] = b
	sub %r13, %r14				; %r13[31:24] = a - b
	ld.w %r10, %psr				; %r10 = %psr
	;
	and	%r10,0xb	; 	xand %r10, %r10, 0xb			; %r10 = %psr(C,Z,N)
	ext	huc6280_FLAG_CONV+0x0@h	; 	xld.ub %r10, [%r10+huc6280_FLAG_CONV]	; P(N,Z,C)
	ext	huc6280_FLAG_CONV+0x0@m
	ld.w	%r9,huc6280_FLAG_CONV+0x0@l
	add	%r9,%r10
	ld.ub	%r10,[%r9]
	ext	0x1ffd		; 	xand %r11, %r11, -164			; %r11 = P(0V0BDI00)
	and	%r11,0x1c
	or %r11, %r10				; %r11 = P(NV0BDIZC)
	xor	%r11,0x1	; 	xxor %r11, %r11, 1			; P(C) = ~P(C)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

	.global huc6280_AND
huc6280_AND:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P
	;
	and %r13, %r14				; %r13 = a & b
	rr	%r13,0x8	; 	xrr %r13, 8				; %r13[31:24] = a & b
	ld.w %r10, %psr				; ????????_??????ZN
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a & b *delay*

	.global huc6280_ORA
huc6280_ORA:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P
	;
	or %r13, %r14				; %r13 = a | b
	rr	%r13,0x8	; 	xrr %r13, 8				; %r13[31:24] = a & b
	ld.w %r10, %psr				; ????????_??????ZN
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a | b *delay*

	.global huc6280_EOR
huc6280_EOR:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P
	;
	xor %r13, %r14				; %r13 = a ^ b
	rr	%r13,0x8	; 	xrr %r13, 8				; %r13[31:24] = a & b
	ld.w %r10, %psr				; ????????_??????ZN
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a ^ b *delay*

	.global huc6280_BIT
huc6280_BIT:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P
	;
	and %r13, %r14				; %r13 = a & b
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffc		; 	xand %r11, %r11, -227			; P(N,V,T,Z)=0
	and	%r11,0x1d
	and	%r10,0x2	; 	xand %r10, %r10, 2			; %r10 = %psr(Z)
	or %r11, %r10				; P(Z)
	ext	0x3		; 	xand %r14, %r14, 0xc0			; %r14 = b[7:6]
	and	%r14,0x0
	or %r11, %r14				; P(N,V)=b[7:6](dl)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

	.global huc6280_INC
huc6280_INC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P
	;
	swap %r13, %r13				; %r13[31:24] = a
	ext	0x20		; 	xadd %r13, %r13, 0x1000000			; %r13[31:24] = a + 1
	ext	0x0
	add	%r13,0x0
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a + 1 *delay*

	.global huc6280_DEC
huc6280_DEC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P
	;
	swap %r13, %r13				; %r13[31:24] = a
	ext	0x20		; 	xsub %r13, %r13, 0x1000000			; %r13[31:24] = a - 1
	ext	0x0
	sub	%r13,0x0
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret.d
	swap %r10, %r13				; %r10 = a - 1 *delay*

;****************************************************************************
;	f[^]
;****************************************************************************

;#macro LDr_IMM $1
;	xld.ub %r11, [%r12+P]			; %r11 = P
	;
;	xld.b [%r12+$1], %r14			; r = imm
;	xrr %r14, 8				; %r14[31:24] = r
;	ld.w %r10, %psr				; %r10 = %psr
	;
;	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
;	xsll %r10, 7				; ???????Z_N0000000
;	or %r11, %r10				; P(N)
;	xsrl %r10, 7				; ????????_??????ZN
;	xand %r10, %r10, 2			; 00000000_000000Z0
;	or %r11, %r10				; P(Z)
;	xld.b [%r12+P], %r11
	;
;	ret
;#endm

	.global huc6280op_LDA_IMM
huc6280op_LDA_IMM:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P	; 	LDr_IMM A
	;
	ext	0x1		; 	xld.b [%r12+0x1], %r14			; r = imm
	ld.b	[%r12],%r14
	rr	%r14,0x8	; 	xrr %r14, 8				; %r14[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global huc6280op_LDX_IMM
huc6280op_LDX_IMM:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P	; 	LDr_IMM X
	;
	ext	0x2		; 	xld.b [%r12+0x2], %r14			; r = imm
	ld.b	[%r12],%r14
	rr	%r14,0x8	; 	xrr %r14, 8				; %r14[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global huc6280op_LDY_IMM
huc6280op_LDY_IMM:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P	; 	LDr_IMM Y
	;
	ext	0x3		; 	xld.b [%r12+0x3], %r14			; r = imm
	ld.b	[%r12],%r14
	rr	%r14,0x8	; 	xrr %r14, 8				; %r14[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************

;#macro LDr_MEM $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]			; %r10 = READ(mem)
;	ld.w %r13, %r14				; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12				; *delay*
	;
;	xld.ub %r11, [%r0+P]			; %r11 = P
	;
;	xld.b [%r0+$1], %r10			; r = READ(mem)
;	xrr %r10, 8				; %r10[31:24] = r
;	ld.w %r10, %psr				; %r10 = %psr
	;
;	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
;	xsll %r10, 7				; ???????Z_N0000000
;	or %r11, %r10				; P(N)
;	xsrl %r10, 7				; ????????_??????ZN
;	xand %r10, %r10, 2			; 00000000_000000Z0
;	or %r11, %r10				; P(Z)
;	xld.b [%r0+P], %r11
	;
;	popn %r0
;	ret
;#endm

	.global huc6280op_LDA_MEM
huc6280op_LDA_MEM:
	pushn %r0	; 	LDr_MEM A
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]			; %r10 = READ(mem)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14				; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]			; %r11 = P
	;
	ext	0x1		; 	xld.b [%r0+0x1], %r10			; r = READ(mem)
	ld.b	[%r0],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global huc6280op_LDX_MEM
huc6280op_LDX_MEM:
	pushn %r0	; 	LDr_MEM X
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]			; %r10 = READ(mem)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14				; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]			; %r11 = P
	;
	ext	0x2		; 	xld.b [%r0+0x2], %r10			; r = READ(mem)
	ld.b	[%r0],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global huc6280op_LDY_MEM
huc6280op_LDY_MEM:
	pushn %r0	; 	LDr_MEM Y
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]			; %r10 = READ(mem)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14				; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]			; %r11 = P
	;
	ext	0x3		; 	xld.b [%r0+0x3], %r10			; r = READ(mem)
	ld.b	[%r0],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret

;****************************************************************************

;#macro STr_MEM $1
;	xbclr [%r12+P], 5			; P(T)=0
	;
;	xld.w %r10, [%r12+WRITE]		; WRITE(mem, r)
;	ld.w %r13, %r14
;	xld.ub %r14, [%r12+$1]
;	call %r10
	;
;	ret
;#endm

	.global huc6280op_STA_MEM
huc6280op_STA_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	STr_MEM A
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]		; WRITE(mem, r)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	;
	ret
	.global huc6280op_STX_MEM
huc6280op_STX_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	STr_MEM X
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]		; WRITE(mem, r)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	call %r10
	;
	ret
	.global huc6280op_STY_MEM
huc6280op_STY_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	STr_MEM Y
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]		; WRITE(mem, r)
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]
	ld.ub	%r14,[%r12]
	call %r10
	;
	ret

;****************************************************************************

;#macro CLr_IMP $1
;	xbclr [%r12+P], 5			; P(T)=0
;	xld.b [%r12+$1], %r8			; r = 0
;	ret
;#endm

	.global huc6280op_CLA_IMP
huc6280op_CLA_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	CLr_IMP A
	ext	0x1		; 	xld.b [%r12+0x1], %r8			; r = 0
	ld.b	[%r12],%r8
	ret
	.global huc6280op_CLX_IMP
huc6280op_CLX_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	CLr_IMP X
	ext	0x2		; 	xld.b [%r12+0x2], %r8			; r = 0
	ld.b	[%r12],%r8
	ret
	.global huc6280op_CLY_IMP
huc6280op_CLY_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	CLr_IMP Y
	ext	0x3		; 	xld.b [%r12+0x3], %r8			; r = 0
	ld.b	[%r12],%r8
	ret

;****************************************************************************

;#macro Trr_IMP $1, $2
;	xld.ub %r11, [%r12+P]			; %r11 = P
	;
;	xld.ub %r10, [%r12+$1]			; r2 = r1
;	xld.b [%r12+$2], %r10
;	xrr %r10, 8				; %r10[31:24] = r
;	ld.w %r10, %psr				; %r10 = %psr
	;
;	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
;	xsll %r10, 7				; ???????Z_N0000000
;	or %r11, %r10				; P(N)
;	xsrl %r10, 7				; ????????_??????ZN
;	xand %r10, %r10, 2			; 00000000_000000Z0
;	or %r11, %r10				; P(Z)
;	xld.b [%r12+P], %r11
	;
;	ret
;#endm

	.global huc6280op_TXA_IMP
huc6280op_TXA_IMP:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P	; 	Trr_IMP X, A
	;
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]			; r2 = r1
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global huc6280op_TYA_IMP
huc6280op_TYA_IMP:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P	; 	Trr_IMP Y, A
	;
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]			; r2 = r1
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global huc6280op_TAX_IMP
huc6280op_TAX_IMP:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P	; 	Trr_IMP A, X
	;
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]			; r2 = r1
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global huc6280op_TAY_IMP
huc6280op_TAY_IMP:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P	; 	Trr_IMP A, Y
	;
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]			; r2 = r1
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret
	.global huc6280op_TSX_IMP
huc6280op_TSX_IMP:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; %r11 = P	; 	Trr_IMP S, X
	;
	ext	0x6		; 	xld.ub %r10, [%r12+0x6]			; r2 = r1
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************

;#macro Srr_IMP $1, $2
;	xbclr [%r12+P], 5			; P(T)=0
	;
;	xld.ub %r10, [%r12+$1]			; %r10 = r1
;	xld.ub %r11, [%r12+$2]			; %r11 = r2
;	xld.b [%r12+$2], %r10			; r2 = %r10
;	xld.b [%r12+$1], %r11			; r1 = %r11
	;
;	ret
;#endm

	.global huc6280op_SAX_IMP
huc6280op_SAX_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Srr_IMP A, X
	;
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]			; %r10 = r1
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.ub %r11, [%r12+0x2]			; %r11 = r2
	ld.ub	%r11,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10			; r2 = %r10
	ld.b	[%r12],%r10
	ext	0x1		; 	xld.b [%r12+0x1], %r11			; r1 = %r11
	ld.b	[%r12],%r11
	;
	ret
	.global huc6280op_SAY_IMP
huc6280op_SAY_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Srr_IMP A, Y
	;
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]			; %r10 = r1
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.ub %r11, [%r12+0x3]			; %r11 = r2
	ld.ub	%r11,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10			; r2 = %r10
	ld.b	[%r12],%r10
	ext	0x1		; 	xld.b [%r12+0x1], %r11			; r1 = %r11
	ld.b	[%r12],%r11
	;
	ret
	.global huc6280op_SXY_IMP
huc6280op_SXY_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Srr_IMP X, Y
	;
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]			; %r10 = r1
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.ub %r11, [%r12+0x3]			; %r11 = r2
	ld.ub	%r11,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10			; r2 = %r10
	ld.b	[%r12],%r10
	ext	0x2		; 	xld.b [%r12+0x2], %r11			; r1 = %r11
	ld.b	[%r12],%r11
	;
	ret

;****************************************************************************

;#macro PHr_IMP $1
;	xbclr [%r12+P], 5			; P(T)=0
	;
;	xld.w %r10, [%r12+WRITE]		; WRITE(S|0x2100, r)
;	xld.ub %r13, [%r12+S]
;	xld.ub %r14, [%r12+$1]			; *anti-interlock*
;	xsub %r11, %r13, 1			; S--
;	xld.b [%r12+S], %r11
;	xoor %r13, %r13, 0x2100
;	call %r10
	;
;	ret
;#endm

	.global huc6280op_PHA_IMP
huc6280op_PHA_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	PHr_IMP A
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]		; WRITE(S|0x2100, r)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; *anti-interlock*
	ld.ub	%r14,[%r12]
	ext	0x1		; 	xsub %r11, %r13, 1			; S--
	sub	%r11,%r13
	ext	0x6		; 	xld.b [%r12+0x6], %r11
	ld.b	[%r12],%r11
	ext	0x84		; 	xoor %r13, %r13, 0x2100
	or	%r13,0x0
	call %r10
	;
	ret
	.global huc6280op_PHX_IMP
huc6280op_PHX_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	PHr_IMP X
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]		; WRITE(S|0x2100, r)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]			; *anti-interlock*
	ld.ub	%r14,[%r12]
	ext	0x1		; 	xsub %r11, %r13, 1			; S--
	sub	%r11,%r13
	ext	0x6		; 	xld.b [%r12+0x6], %r11
	ld.b	[%r12],%r11
	ext	0x84		; 	xoor %r13, %r13, 0x2100
	or	%r13,0x0
	call %r10
	;
	ret
	.global huc6280op_PHY_IMP
huc6280op_PHY_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	PHr_IMP Y
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]		; WRITE(S|0x2100, r)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]			; *anti-interlock*
	ld.ub	%r14,[%r12]
	ext	0x1		; 	xsub %r11, %r13, 1			; S--
	sub	%r11,%r13
	ext	0x6		; 	xld.b [%r12+0x6], %r11
	ld.b	[%r12],%r11
	ext	0x84		; 	xoor %r13, %r13, 0x2100
	or	%r13,0x0
	call %r10
	;
	ret
	.global huc6280op_PHP_IMP
huc6280op_PHP_IMP:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	PHr_IMP P
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]		; WRITE(S|0x2100, r)
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	ld.ub	%r14,[%r12]	; 	xld.ub %r14, [%r12+0x0]			; *anti-interlock*
	ext	0x1		; 	xsub %r11, %r13, 1			; S--
	sub	%r11,%r13
	ext	0x6		; 	xld.b [%r12+0x6], %r11
	ld.b	[%r12],%r11
	ext	0x84		; 	xoor %r13, %r13, 0x2100
	or	%r13,0x0
	call %r10
	;
	ret

;****************************************************************************

;#macro PLr_IMP $1
;	pushn %r0
	;
;	xld.ub %r13, [%r12+S]			; S++
;	xld.w %r10, [%r12+READ]			; *anti-interlock*
;	xadd %r13, %r13, 1
;	xld.b [%r12+S], %r13
	;/ld.ub %r13, %r13			; ͕svB%r13[8]=1ŒȂ̂Ōオ肵ĂĂ֌WȂB
;	xoor %r13, %r13, 0x2100			; %r10 = READ(S|0x2100)
;	call.d %r10
;	ld.w %r0, %r12				; *delay*
	;
;	xld.ub %r11, [%r0+P]			; %r11 = P
	;
;	xld.b [%r0+$1], %r10			; r = READ(S|0x2100)
;	xrr %r10, 8				; %r10[31:24] = r
;	ld.w %r10, %psr				; %r10 = %psr
	;
;	xand %r11, %r11, ~0xa2			; P(N,T,Z)=0
;	xsll %r10, 7				; ???????Z_N0000000
;	or %r11, %r10				; P(N)
;	xsrl %r10, 7				; ????????_??????ZN
;	xand %r10, %r10, 2			; 00000000_000000Z0
;	or %r11, %r10				; P(Z)
;	xld.b [%r0+P], %r11
	;
;	popn %r0
;	ret
;#endm

	.global huc6280op_PLA_IMP
huc6280op_PLA_IMP:
	pushn %r0	; 	PLr_IMP A
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]			; S++
	ld.ub	%r13,[%r12]
	ext	0x18		; 	xld.w %r10, [%r12+0x18]			; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x6		; 	xld.b [%r12+0x6], %r13
	ld.b	[%r12],%r13
	;/ld.ub %r13, %r13			; ͕svB%r13[8]=1ŒȂ̂Ōオ肵ĂĂ֌WȂB
	ext	0x84		; 	xoor %r13, %r13, 0x2100			; %r10 = READ(S|0x2100)
	or	%r13,0x0
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]			; %r11 = P
	;
	ext	0x1		; 	xld.b [%r0+0x1], %r10			; r = READ(S|0x2100)
	ld.b	[%r0],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global huc6280op_PLX_IMP
huc6280op_PLX_IMP:
	pushn %r0	; 	PLr_IMP X
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]			; S++
	ld.ub	%r13,[%r12]
	ext	0x18		; 	xld.w %r10, [%r12+0x18]			; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x6		; 	xld.b [%r12+0x6], %r13
	ld.b	[%r12],%r13
	;/ld.ub %r13, %r13			; ͕svB%r13[8]=1ŒȂ̂Ōオ肵ĂĂ֌WȂB
	ext	0x84		; 	xoor %r13, %r13, 0x2100			; %r10 = READ(S|0x2100)
	or	%r13,0x0
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]			; %r11 = P
	;
	ext	0x2		; 	xld.b [%r0+0x2], %r10			; r = READ(S|0x2100)
	ld.b	[%r0],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global huc6280op_PLY_IMP
huc6280op_PLY_IMP:
	pushn %r0	; 	PLr_IMP Y
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]			; S++
	ld.ub	%r13,[%r12]
	ext	0x18		; 	xld.w %r10, [%r12+0x18]			; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x6		; 	xld.b [%r12+0x6], %r13
	ld.b	[%r12],%r13
	;/ld.ub %r13, %r13			; ͕svB%r13[8]=1ŒȂ̂Ōオ肵ĂĂ֌WȂB
	ext	0x84		; 	xoor %r13, %r13, 0x2100			; %r10 = READ(S|0x2100)
	or	%r13,0x0
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]			; %r11 = P
	;
	ext	0x3		; 	xld.b [%r0+0x3], %r10			; r = READ(S|0x2100)
	ld.b	[%r0],%r10
	rr	%r10,0x8	; 	xrr %r10, 8				; %r10[31:24] = r
	ld.w %r10, %psr				; %r10 = %psr
	;
	ext	0x1ffd		; 	xand %r11, %r11, -163			; P(N,T,Z)=0
	and	%r11,0x1d
	sll	%r10,0x7	; 	xsll %r10, 7				; ???????Z_N0000000
	or %r11, %r10				; P(N)
	srl	%r10,0x7	; 	xsrl %r10, 7				; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2			; 00000000_000000Z0
	or %r11, %r10				; P(Z)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret

;****************************************************************************
;	t[
;****************************************************************************

	.global huc6280op_BRA_MEM
huc6280op_BRA_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC
	ld.h	[%r12],%r14
	ret

	.global huc6280op_BSR_MEM
huc6280op_BSR_MEM:
	pushn %r2
	;
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0
	;
	ext	0x6		; 	xld.ub %r1, [%r12+0x6]			; S|0x2100
	ld.ub	%r1,[%r12]
	ext	0x4		; 	xld.uh %r2, [%r12+0x4]			; PC--(dl) *anti-interlock*
	ld.uh	%r2,[%r12]
	ext	0x84		; 	xoor %r1, %r1, 0x2100			;            *anti-interlock*
	or	%r1,0x0
	sub	%r2,0x1		; 	xsub %r2, %r2, 1
	;
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC
	ld.h	[%r12],%r14
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]		; PUSH(PCH)
	ld.w	%r10,[%r12]
	ld.w %r13, %r1
	ld.uh %r14, %r2
	srl	%r14,0x8	; 	xsrl %r14, 8
	call.d %r10
	ld.w %r0, %r12				; *delay*
	;
	;					; S|0x2100 == 0x2100       `0x21ff
	sub	%r1,0x1		; 	xsub %r1, %r1, 1			; -1       => 0x20ff       `0x21fe
	ext	0x84		; 	xoor %r1, %r1, 0x2100			;  |0x2100 => 0x21ff,0x2100`0x21fe
	or	%r1,0x0
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]			; PUSH(PCL)
	ld.w	%r10,[%r0]
	ld.w %r13, %r1
	ld.ub %r14, %r2
	call.d %r10
	ld.w %r12, %r0				; *delay*
	;
	sub	%r1,0x1		; 	xsub %r1, %r1, 1			; S--
	ext	0x6		; 	xld.b [%r0+0x6], %r1
	ld.b	[%r0],%r1
	;
	popn %r2
	ret

	.global huc6280op_RTS_IMP
huc6280op_RTS_IMP:
	pushn %r2
	;
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0
	;
	ext	0x6		; 	xld.ub %r1, [%r12+0x6]			; S        == 0x0000`       0x00ff
	ld.ub	%r1,[%r12]
	ext	0x18		; 	xld.w %r10, [%r12+0x18]			; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r1,0x1		; 	xadd %r1, %r1, 1			; +1       => 0x0001`       0x0100
	ext	0x84		; 	xoor %r1, %r1, 0x2100			; S|0x2100 => 0x2101`0x21ff,0x2100
	or	%r1,0x0
	;
	ld.w %r13, %r1				; POP(PCL)
	call.d %r10
	ld.w %r0, %r12				; *delay*
	ld.w %r2, %r10				; (save PCL)
	;
	;					; S|0x2100 == 0x2100`       0x21ff
	add	%r1,0x1		; 	xadd %r1, %r1, 1			; +1       => 0x2101`       0x2200
	ld.ub %r1, %r1				;          => 0x0001`0x00ff,0x0000
	ext	0x84		; 	xoor %r1, %r1, 0x2100			;  |0x2100 => 0x2101`0x21ff,0x2100
	or	%r1,0x0
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]			; POP(PCH)
	ld.w	%r10,[%r0]
	ld.w %r13, %r1				; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0				; *delay*
	;
	sll	%r10,0x8	; 	xsll %r10, 8				; PC = PCL | PCH << 8
	or %r10, %r2
	add	%r10,0x1	; 	xadd %r10, %r10, 1			; PC++(dl)
	ext	0x4		; 	xld.h [%r0+0x4], %r10
	ld.h	[%r0],%r10
	;
	ext	0x6		; 	xld.b [%r0+0x6], %r1			; S
	ld.b	[%r0],%r1
	;
	popn %r2
	ret

;****************************************************************************

;#macro Bclr_MEM $1
;	xbclr [%r12+P], 5			; P(T)=0
	;
;	xbtst [%r12+P], $1			; if(P(?)) no-branch
;	xjrne $$1
	;
;	xld.w %r10, [%r12+CYCLE]		; CYCLE--
;	xld.h [%r12+PC], %r14			; PC *anti-interlock*
;	xsub %r10, %r10, 1
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

	.global huc6280op_BCC_MEM
huc6280op_BCC_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Bclr_MEM 0
	;
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0			; if(P(?)) no-branch
	jrne	__LX0001	; 	xjrne __L0001
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0001:				; __L0001:
	ret
	.global huc6280op_BNE_MEM
huc6280op_BNE_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Bclr_MEM 1
	;
	btst	[%r12],0x1	; 	xbtst [%r12+0x0], 0x1			; if(P(?)) no-branch
	jrne	__LX0002	; 	xjrne __L0002
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0002:				; __L0002:
	ret
	.global huc6280op_BVC_MEM
huc6280op_BVC_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Bclr_MEM 6
	;
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6			; if(P(?)) no-branch
	jrne	__LX0003	; 	xjrne __L0003
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0003:				; __L0003:
	ret
	.global huc6280op_BPL_MEM
huc6280op_BPL_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Bclr_MEM 7
	;
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7			; if(P(?)) no-branch
	jrne	__LX0004	; 	xjrne __L0004
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0004:				; __L0004:
	ret

;****************************************************************************

;#macro Bset_MEM $1
;	xbclr [%r12+P], 5			; P(T)=0
	;
;	xbtst [%r12+P], $1			; if(!P(?)) no-branch
;	xjreq $$1
	;
;	xld.w %r10, [%r12+CYCLE]		; CYCLE--
;	xld.h [%r12+PC], %r14			; PC *anti-interlock*
;	xsub %r10, %r10, 1
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

	.global huc6280op_BCS_MEM
huc6280op_BCS_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Bset_MEM 0
	;
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0			; if(!P(?)) no-branch
	jreq	__LX0005	; 	xjreq __L0005
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0005:				; __L0005:
	ret
	.global huc6280op_BEQ_MEM
huc6280op_BEQ_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Bset_MEM 1
	;
	btst	[%r12],0x1	; 	xbtst [%r12+0x0], 0x1			; if(!P(?)) no-branch
	jreq	__LX0006	; 	xjreq __L0006
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0006:				; __L0006:
	ret
	.global huc6280op_BVS_MEM
huc6280op_BVS_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Bset_MEM 6
	;
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6			; if(!P(?)) no-branch
	jreq	__LX0007	; 	xjreq __L0007
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0007:				; __L0007:
	ret
	.global huc6280op_BMI_MEM
huc6280op_BMI_MEM:
	bclr	[%r12],0x5	; 	xbclr [%r12+0x0], 0x5			; P(T)=0	; 	Bset_MEM 7
	;
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7			; if(!P(?)) no-branch
	jreq	__LX0008	; 	xjreq __L0008
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; CYCLE--
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.h [%r12+0x4], %r14			; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x10		; 	xld.w [%r12+0x10], %r10
	ld.w	[%r12],%r10
__LX0008:				; __L0008:
	ret

;****************************************************************************
;	$1($2,arg)
;****************************************************************************

;#macro S1IS2_argI $1, $2
;	xld.ub %r13, [%r12+$2]
;	xjp huc6280_$1
;#endm

	.global huc6280op_CMP_IMM
huc6280op_CMP_IMM:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	S1IS2_argI CMP, A
	ld.ub	%r13,[%r12]
	ext	huc6280_CMP@rm	; 	xjp huc6280_CMP
	jp	huc6280_CMP@rl
	.global huc6280op_CPX_IMM
huc6280op_CPX_IMM:
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]	; 	S1IS2_argI CMP, X
	ld.ub	%r13,[%r12]
	ext	huc6280_CMP@rm	; 	xjp huc6280_CMP
	jp	huc6280_CMP@rl
	.global huc6280op_CPY_IMM
huc6280op_CPY_IMM:
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]	; 	S1IS2_argI CMP, Y
	ld.ub	%r13,[%r12]
	ext	huc6280_CMP@rm	; 	xjp huc6280_CMP
	jp	huc6280_CMP@rl

	.global huc6280op_BIT_IMM
huc6280op_BIT_IMM:
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]	; 	S1IS2_argI BIT, A
	ld.ub	%r13,[%r12]
	ext	huc6280_BIT@rm	; 	xjp huc6280_BIT
	jp	huc6280_BIT@rl

;****************************************************************************
;	$1($2,READ(arg))
;****************************************************************************

;#macro S1IS2_READIargII $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r14, %r10
;	xld.ub %r13, [%r0+$2]
;	xcall.d huc6280_$1		; *delay*
;	ld.w %r12, %r0
	;
;	popn %r0
;	ret
;#endm

	.global huc6280op_CMP_MEM
huc6280op_CMP_MEM:
	pushn %r0	; 	S1IS2_READIargII CMP, A
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1		; 	xld.ub %r13, [%r0+0x1]
	ld.ub	%r13,[%r0]
	ext	huc6280_CMP@rm	; 	xcall.d huc6280_CMP		; *delay*
	call.d	huc6280_CMP@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret
	.global huc6280op_CPX_MEM
huc6280op_CPX_MEM:
	pushn %r0	; 	S1IS2_READIargII CMP, X
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x2		; 	xld.ub %r13, [%r0+0x2]
	ld.ub	%r13,[%r0]
	ext	huc6280_CMP@rm	; 	xcall.d huc6280_CMP		; *delay*
	call.d	huc6280_CMP@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret
	.global huc6280op_CPY_MEM
huc6280op_CPY_MEM:
	pushn %r0	; 	S1IS2_READIargII CMP, Y
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x3		; 	xld.ub %r13, [%r0+0x3]
	ld.ub	%r13,[%r0]
	ext	huc6280_CMP@rm	; 	xcall.d huc6280_CMP		; *delay*
	call.d	huc6280_CMP@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret

	.global huc6280op_BIT_MEM
huc6280op_BIT_MEM:
	pushn %r0	; 	S1IS2_READIargII BIT, A
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1		; 	xld.ub %r13, [%r0+0x1]
	ld.ub	%r13,[%r0]
	ext	huc6280_BIT@rm	; 	xcall.d huc6280_BIT		; *delay*
	call.d	huc6280_BIT@rl
	ld.w %r12, %r0
	;
	popn %r0
	ret

;****************************************************************************
;	$2=$1($2)
;****************************************************************************

;#macro S2_S1I$2I $1, $2
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$2]
;	xcall.d huc6280_$1
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

	.global huc6280op_INC_ACC
huc6280op_INC_ACC:
	pushn %r0	; 	S2_S1I$2I INC, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	huc6280_INC@rm	; 	xcall.d huc6280_INC
	call.d	huc6280_INC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_INX_IMP
huc6280op_INX_IMP:
	pushn %r0	; 	S2_S1I$2I INC, X
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	huc6280_INC@rm	; 	xcall.d huc6280_INC
	call.d	huc6280_INC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_INY_IMP
huc6280op_INY_IMP:
	pushn %r0	; 	S2_S1I$2I INC, Y
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	huc6280_INC@rm	; 	xcall.d huc6280_INC
	call.d	huc6280_INC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_DEC_ACC
huc6280op_DEC_ACC:
	pushn %r0	; 	S2_S1I$2I DEC, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	huc6280_DEC@rm	; 	xcall.d huc6280_DEC
	call.d	huc6280_DEC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_DEX_IMP
huc6280op_DEX_IMP:
	pushn %r0	; 	S2_S1I$2I DEC, X
	;
	ext	0x2		; 	xld.ub %r13, [%r12+0x2]
	ld.ub	%r13,[%r12]
	ext	huc6280_DEC@rm	; 	xcall.d huc6280_DEC
	call.d	huc6280_DEC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_DEY_IMP
huc6280op_DEY_IMP:
	pushn %r0	; 	S2_S1I$2I DEC, Y
	;
	ext	0x3		; 	xld.ub %r13, [%r12+0x3]
	ld.ub	%r13,[%r12]
	ext	huc6280_DEC@rm	; 	xcall.d huc6280_DEC
	call.d	huc6280_DEC@rl
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

	.global huc6280op_ASL_ACC
huc6280op_ASL_ACC:
	pushn %r0	; 	S2_S1I$2I ASL, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	huc6280_ASL@rm	; 	xcall.d huc6280_ASL
	call.d	huc6280_ASL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_LSR_ACC
huc6280op_LSR_ACC:
	pushn %r0	; 	S2_S1I$2I LSR, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	huc6280_LSR@rm	; 	xcall.d huc6280_LSR
	call.d	huc6280_LSR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_ROL_ACC
huc6280op_ROL_ACC:
	pushn %r0	; 	S2_S1I$2I ROL, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	huc6280_ROL@rm	; 	xcall.d huc6280_ROL
	call.d	huc6280_ROL@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_ROR_ACC
huc6280op_ROR_ACC:
	pushn %r0	; 	S2_S1I$2I ROR, A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	huc6280_ROR@rm	; 	xcall.d huc6280_ROR
	call.d	huc6280_ROR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	WRITE(arg,$1(READ(arg)))
;****************************************************************************

;#macro WRITEIarg_S1IREADIargIII $1
;	pushn %r1
;	ld.w %r1, %r14
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	xcall.d huc6280_$1
;	ld.w %r12, %r0			; *delay*
	;
;	ld.w %r14, %r10
;	xld.w %r10, [%r0+WRITE]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r1
;	ret
;#endm

	.global huc6280op_INC_MEM
huc6280op_INC_MEM:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII INC
	ld.w %r1, %r14
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	huc6280_INC@rm	; 	xcall.d huc6280_INC
	call.d	huc6280_INC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global huc6280op_DEC_MEM
huc6280op_DEC_MEM:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII DEC
	ld.w %r1, %r14
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	huc6280_DEC@rm	; 	xcall.d huc6280_DEC
	call.d	huc6280_DEC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global huc6280op_ASL_MEM
huc6280op_ASL_MEM:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ASL
	ld.w %r1, %r14
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	huc6280_ASL@rm	; 	xcall.d huc6280_ASL
	call.d	huc6280_ASL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global huc6280op_LSR_MEM
huc6280op_LSR_MEM:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII LSR
	ld.w %r1, %r14
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	huc6280_LSR@rm	; 	xcall.d huc6280_LSR
	call.d	huc6280_LSR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global huc6280op_ROL_MEM
huc6280op_ROL_MEM:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ROL
	ld.w %r1, %r14
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	huc6280_ROL@rm	; 	xcall.d huc6280_ROL
	call.d	huc6280_ROL@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
	.global huc6280op_ROR_MEM
huc6280op_ROR_MEM:
	pushn %r1	; 	WRITEIarg_S1IREADIargIII ROR
	ld.w %r1, %r14
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ext	huc6280_ROR@rm	; 	xcall.d huc6280_ROR
	call.d	huc6280_ROR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

;****************************************************************************
;	$2=$1($2,arg)
;****************************************************************************

;#macro S2_S1IS2_argI $1, $2
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$2]
;	xcall.d huc6280_$1
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

	.global huc6280op_AND_IMM
huc6280op_AND_IMM:
	pushn %r0	; 	S2_S1IS2_argI AND, A		;* P(T)Ή */
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	huc6280_AND@rm	; 	xcall.d huc6280_AND
	call.d	huc6280_AND@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_ORA_IMM
huc6280op_ORA_IMM:
	pushn %r0	; 	S2_S1IS2_argI ORA, A		;* P(T)Ή */
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	huc6280_ORA@rm	; 	xcall.d huc6280_ORA
	call.d	huc6280_ORA@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_EOR_IMM
huc6280op_EOR_IMM:
	pushn %r0	; 	S2_S1IS2_argI EOR, A		;* P(T)Ή */
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	huc6280_EOR@rm	; 	xcall.d huc6280_EOR
	call.d	huc6280_EOR@rl
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	$2=$1($2,READ(arg))
;****************************************************************************

;#macro S2_S1IS2_READIargII $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r14, %r10
;	xld.ub %r13, [%r0+$2]
;	xcall.d huc6280_$1		; *delay*
;	ld.w %r12, %r0
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

	.global huc6280op_AND_MEM
huc6280op_AND_MEM:
	pushn %r0	; 	S2_S1IS2_READIargII AND, A	;* P(T)Ή */
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1		; 	xld.ub %r13, [%r0+0x1]
	ld.ub	%r13,[%r0]
	ext	huc6280_AND@rm	; 	xcall.d huc6280_AND		; *delay*
	call.d	huc6280_AND@rl
	ld.w %r12, %r0
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_ORA_MEM
huc6280op_ORA_MEM:
	pushn %r0	; 	S2_S1IS2_READIargII ORA, A	;* P(T)Ή */
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1		; 	xld.ub %r13, [%r0+0x1]
	ld.ub	%r13,[%r0]
	ext	huc6280_ORA@rm	; 	xcall.d huc6280_ORA		; *delay*
	call.d	huc6280_ORA@rl
	ld.w %r12, %r0
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global huc6280op_EOR_MEM
huc6280op_EOR_MEM:
	pushn %r0	; 	S2_S1IS2_READIargII EOR, A	;* P(T)Ή */
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x1		; 	xld.ub %r13, [%r0+0x1]
	ld.ub	%r13,[%r0]
	ext	huc6280_EOR@rm	; 	xcall.d huc6280_EOR		; *delay*
	call.d	huc6280_EOR@rl
	ld.w %r12, %r0
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	
;****************************************************************************

;#endif /*HUC6280_ASM*/
