/*	
 *	framc17.c
 *
 *	P/ECE EPSON S1C17702 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2010 Naoyuki Sawa
 *
 *	* Wed Jan 13 22:17:37 JST 2010 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	CPU
 ****************************************************************************/

#ifndef PIECE
void s1c17_cpu_exec() { /* 1ߎs */
	int x16;
	s1c17_op** next;
	s1c17_op* op;

	/* ߃tFb` */
	x16 = s1c17_bcu_read(2, s1c17_cpu.pc);

	/* %pci߂B
	 * S1C17́AS1C33ƈāA߂sO%pci݂܂B(Z80Ɠlł)
	 * %pcΕ򖽗߂ȂǂɂāÄႢɒӂĂB
	 */
	s1c17_cpu.pc += 2;
	s1c17_cpu.pc = (unsigned)(s1c17_cpu.pc << 8) >> 8;

	/* ߃e[u */
	next = &s1c17_op_root;
	while((op = *next) != NULL) {
		if((x16 & op->mask) == op->code) {
			/*{{LRU*/
			/* s1c17_op_root=op̏ꍇȉ̏ővłB */
			*next = op->next;
			op->next = s1c17_op_root;
			s1c17_op_root = op;
			/*}}LRU*/
#ifdef S1C17_TRACE
			/* g[Xo */
			printf("%06x %04x %s\n", s1c17_cpu.pc - 2, x16, op->name);
#endif /*S1C17_TRACE*/
			/* ߎs */
			op->fn1(x16, op->fn2);
			return; /* ܂ */
		}
		next = &op->next;
	}

	/* sȖ */
#ifdef S1C17_TRACE
	printf("%06x %04x ?\n", s1c17_cpu.pc - 2, x16);
#endif /*S1C17_TRACE*/
#ifdef DEBUG
	DIE();
#endif /*DEBUG*/
}
#else /*PIECE*/
void s1c17_cpu_exec(); /* 1ߎs */
asm("
		.code
		.align		1
		.global		s1c17_cpu_exec
s1c17_cpu_exec:
		Xld.w		%r4, s1c17_cpu+40		;// %r4  := &s1c17_cpu.pc
		ld.w		%r5, [%r4]			;// %r5  := pc = s1c17_cpu.pc
		ld.w		%r13, %r5			;// %r13 := pc					!INTERLOCK!
		add		%r5, 2				;// %r5  := pc + 2
		sll		%r5, 8				;// %r5  := (pc + 2) << 8
		srl		%r5, 8				;// %r5  := ((pc + 2) << 8) >> 8
		ld.w		[%r4], %r5			;// s1c17_cpu.pc = ((pc + 2) << 8) >> 8
		Xcall.d		s1c17_bcu_read			;// %r10 := x16 = s1c17_bcu_read(2, pc)
		ld.w		%r12, 2				;// %r12 := 2					*delay*
		;//
		Xld.w		%r11, s1c17_op_root		;// %r11 := &s1c17_op_root
		ld.w		%r4, %r11			;// %r4  := next = &s1c17_op_root
s1c17_cpu_exec_LOOP:
		ld.w		%r5, [%r4]			;// %r5  := op = *next
		cmp		%r5, 0				;// if(!op)					!INTERLOCK!
		jreq		s1c17_cpu_exec_RET		;//   return
		;//
		ld.uh		%r6, [%r5]+			;// %r6  := mask = op->mask
		ld.uh		%r7, [%r5]+			;// %r7  := code = op->code
		and		%r6, %r10			;// %r6  := x16 & mask
		cmp		%r6, %r7			;// if((x16 & mask) == code)
		jreq		s1c17_cpu_exec_HIT		;//   goto HIT
		;//
		add		%r5, 8				;// %r5  := &op->next
		jp.d		s1c17_cpu_exec_LOOP		;// goto LOOP
		ld.w		%r4, %r5			;// %r4  := next = &op->next			*delay*
		;//---------------------------------------------;//
s1c17_cpu_exec_HIT:
		ld.w		%r6, [%r5]+			;// %r6  := op->fn1
		ld.w		%r13, [%r5]+			;// %r13 := op->fn2, %r5  := &op->next
		;//{{LRU
		ld.w		%r7, [%r5]			;// %r7  := op->next
		ld.w		[%r4], %r7			;// *next = op->next				!INTERLOCK!
		ld.w		%r7, [%r11]			;// %r7  := s1c17_op_root
		ld.w		[%r5], %r7			;// op->next = s1c17_op_root			!INTERLOCK!
		sub		%r5, 12				;// %r5  := op
		ld.w		[%r11], %r5			;// s1c17_op_root = op
		;//}}LRU
		ld.w		%r12, %r10			;// %r12 := x16
		jp		%r6				;// op->fn1(x16, op->fn2)			(jp.d %rb͕s)
		;//---------------------------------------------;//
s1c17_cpu_exec_RET:
		ret
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/
/* ߃fR[h */

#ifndef PIECE
typedef union _s1c17_code {
	unsigned short x16;
	struct {
		unsigned short imm7  : 7;
		unsigned short       : 9;
	} x9_imm7;
	struct {
		unsigned short imm13 :13;
		unsigned short       : 3;
	} x3_imm13;
	struct {
		unsigned short       : 2;
		unsigned short imm5  : 5;
		unsigned short       : 9;
	} x9_imm5_x2;
	struct {
		unsigned short       : 2;
		unsigned short imm5  : 5;
		unsigned short imm3  : 3;
		unsigned short       : 6;
	} x6_imm3_imm5_x2;
	struct {
		unsigned short       : 7;
		unsigned short d     : 1;
		unsigned short       : 8;
	} x8_d_x7;
	struct {
		unsigned short imm7  : 7;
		unsigned short d     : 1;
		unsigned short       : 8;
	} x8_d_imm7;
	struct {
		         short sign7 : 7;
		unsigned short d     : 1;
		unsigned short       : 8;
	} x8_d_sign7;
	struct {
		         short sign10:10;
		unsigned short d     : 1;
		unsigned short       : 5;
	} x5_d_sign10;
	struct {
		unsigned short rb    : 3;
		unsigned short       : 4;
		unsigned short d     : 1;
		unsigned short       : 8;
	} x8_d_x4_rb;
	struct {
		unsigned short rs    : 3;
		unsigned short       :13;
	} x13_rs;
	struct {
		unsigned short       : 7;
		unsigned short rd    : 3;
		unsigned short       : 6;
	} x6_rd_x7;
	struct {
		unsigned short       : 7;
		unsigned short rs    : 3;
		unsigned short       : 6;
	} x6_rs_x7;
	struct {
		unsigned short imm7  : 7;
		unsigned short rd    : 3;
		unsigned short       : 6;
	} x6_rd_imm7;
	struct {
		unsigned short imm7  : 7;
		unsigned short rs    : 3;
		unsigned short       : 6;
	} x6_rs_imm7;
	struct {
		         short sign7 : 7;
		unsigned short rd    : 3;
		unsigned short       : 6;
	} x6_rd_sign7;
	struct {
		unsigned short rs    : 3;
		unsigned short       : 4;
		unsigned short rd    : 3;
		unsigned short       : 6;
	} x6_rd_x4_rs;
	struct {
		unsigned short rb    : 3;
		unsigned short       : 4;
		unsigned short rd    : 3;
		unsigned short       : 6;
	} x6_rd_x4_rb;
	struct {
		unsigned short rb    : 3;
		unsigned short       : 4;
		unsigned short rs    : 3;
		unsigned short       : 6;
	} x6_rs_x4_rb;
} s1c17_code;
void s1c17_x16(int x16, void (*fn2)()) {
	fn2();
}
void s1c17_x9_imm7(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(code.x9_imm7.imm7);
}
void s1c17_x3_imm13(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(code.x3_imm13.imm13);
}
void s1c17_x9_imm5_x2(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(code.x9_imm5_x2.imm5);
}
void s1c17_x6_imm3_imm5_x2(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(code.x6_imm3_imm5_x2.imm3, code.x6_imm3_imm5_x2.imm5);
}
void s1c17_x8_d_x7(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(code.x8_d_x7.d);
}
void s1c17_x8_d_imm7(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(code.x8_d_imm7.d, code.x8_d_imm7.imm7);
}
void s1c17_x8_d_sign7(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(code.x8_d_sign7.d, code.x8_d_sign7.sign7);
}
void s1c17_x5_d_sign10(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(code.x5_d_sign10.d, code.x5_d_sign10.sign10);
}
void s1c17_x8_d_x4_rb(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(code.x8_d_x4_rb.d, &s1c17_cpu.r[code.x8_d_x4_rb.rb]);
}
void s1c17_x13_rs(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(&s1c17_cpu.r[code.x13_rs.rs]);
}
void s1c17_x6_rd_x7(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(&s1c17_cpu.r[code.x6_rd_x7.rd]);
}
void s1c17_x6_rs_x7(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(&s1c17_cpu.r[code.x6_rs_x7.rs]);
}
void s1c17_x6_rd_imm7(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(&s1c17_cpu.r[code.x6_rd_imm7.rd], code.x6_rd_imm7.imm7);
}
void s1c17_x6_rs_imm7(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(&s1c17_cpu.r[code.x6_rs_imm7.rs], code.x6_rs_imm7.imm7);
}
void s1c17_x6_rd_sign7(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(&s1c17_cpu.r[code.x6_rd_sign7.rd], code.x6_rd_sign7.sign7);
}
void s1c17_x6_rd_x4_rs(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(&s1c17_cpu.r[code.x6_rd_x4_rs.rd], &s1c17_cpu.r[code.x6_rd_x4_rs.rs]);
}
void s1c17_x6_rd_x4_rb(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(&s1c17_cpu.r[code.x6_rd_x4_rb.rd], &s1c17_cpu.r[code.x6_rd_x4_rb.rb]);
}
void s1c17_x6_rs_x4_rb(int x16, void (*fn2)()) {
	s1c17_code code = { x16 };
	fn2(&s1c17_cpu.r[code.x6_rs_x4_rb.rs], &s1c17_cpu.r[code.x6_rs_x4_rb.rb]);
}
#else /*PIECE*/
void s1c17_x16(int x16, void (*fn2)());
void s1c17_x9_imm7(int x16, void (*fn2)());
void s1c17_x3_imm13(int x16, void (*fn2)());
void s1c17_x9_imm5_x2(int x16, void (*fn2)());
void s1c17_x6_imm3_imm5_x2(int x16, void (*fn2)());
void s1c17_x8_d_x7(int x16, void (*fn2)());
void s1c17_x8_d_imm7(int x16, void (*fn2)());
void s1c17_x8_d_sign7(int x16, void (*fn2)());
void s1c17_x5_d_sign10(int x16, void (*fn2)());
void s1c17_x8_d_x4_rb(int x16, void (*fn2)());
void s1c17_x13_rs(int x16, void (*fn2)());
void s1c17_x6_rd_x7(int x16, void (*fn2)());
void s1c17_x6_rs_x7(int x16, void (*fn2)());
void s1c17_x6_rd_imm7(int x16, void (*fn2)());
void s1c17_x6_rs_imm7(int x16, void (*fn2)());
void s1c17_x6_rd_sign7(int x16, void (*fn2)());
void s1c17_x6_rd_x4_rs(int x16, void (*fn2)());
void s1c17_x6_rd_x4_rb(int x16, void (*fn2)());
void s1c17_x6_rs_x4_rb(int x16, void (*fn2)());
asm("
		.code
		.align		1
		.global		s1c17_x16
		.global		s1c17_x9_imm7
		.global		s1c17_x3_imm13
		.global		s1c17_x9_imm5_x2
		.global		s1c17_x6_imm3_imm5_x2
		.global		s1c17_x8_d_x7
		.global		s1c17_x8_d_imm7
		.global		s1c17_x8_d_sign7
		.global		s1c17_x5_d_sign10
		.global		s1c17_x8_d_x4_rb
		.global		s1c17_x13_rs
		.global		s1c17_x6_rd_x7
		.global		s1c17_x6_rs_x7
		.global		s1c17_x6_rd_imm7
		.global		s1c17_x6_rs_imm7
		.global		s1c17_x6_rd_sign7
		.global		s1c17_x6_rd_x4_rs
		.global		s1c17_x6_rd_x4_rb
		.global		s1c17_x6_rs_x4_rb
s1c17_x16:
		jp		%r13
s1c17_x9_imm7:							;// %r12 := 00000000 00000000 ???????? 0xxxxxxx
		Xand		%r12, %r12, 0x7F		;// %r12 := 00000000 00000000 00000000 0xxxxxxx
		jp		%r13
s1c17_x3_imm13:							;// %r12 := 00000000 00000000 ???xxxxx xxxxxxxx
		Xand		%r12, %r12, 0x1FFF		;// %r12 := 00000000 00000000 000xxxxx xxxxxxxx
		jp		%r13
s1c17_x9_imm5_x2:						;// %r12 := 00000000 00000000 ???????? ?xxxxx??
		sra		%r12, 2				;// %r12 := 00000000 00000000 00?????? ???xxxxx
		and		%r12, 0x1F			;// %r12 := 00000000 00000000 00000000 000xxxxx
		jp		%r13
s1c17_x6_imm3_imm5_x2:						;// %r12 := 00000000 00000000 ??????xx xyyyyy??
		ld.w		%r4, %r13
		sra		%r12, 2				;// %r12 := 00000000 00000000 00?????? xxxyyyyy
		Xand		%r13, %r12, 0x1F		;// %r13 := 00000000 00000000 00000000 000yyyyy
		sra		%r12, 5				;// %r12 := 00000000 00000000 0000000? ?????xxx
		and		%r12, 7				;// %r12 := 00000000 00000000 00000000 00000xxx
		jp		%r4
s1c17_x8_d_x7:							;// %r12 := 00000000 00000000 ???????? x???????
		sra		%r12, 7				;// %r12 := 00000000 00000000 0000000? ???????x
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r13
s1c17_x8_d_imm7:						;// %r12 := 00000000 00000000 ???????? xyyyyyyy
		ld.w		%r4, %r13
		Xand		%r13, %r12, 0x7F		;// %r13 := 00000000 00000000 00000000 0yyyyyyy
		sra		%r12, 7				;// %r12 := 00000000 00000000 0000000? ???????x
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r4
s1c17_x8_d_sign7:						;// %r12 := 00000000 00000000 ???????? xyyyyyyy
		ld.w		%r4, %r13
		sla		%r12, 1				;// %r12 := 00000000 0000000? ???????x yyyyyyy0
		ld.b		%r13, %r12			;// %r13 := ssssssss ssssssss ssssssss yyyyyyy0
		sra		%r13, 1				;// %r13 := ssssssss ssssssss ssssssss syyyyyyy
		sra		%r12, 8				;// %r12 := 00000000 00000000 0000000? ???????x
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r4
s1c17_x5_d_sign10:						;// %r12 := 00000000 00000000 ?????xyy yyyyyyyy
		ld.w		%r4, %r13
		sla		%r12, 6				;// %r12 := 00000000 00?????x yyyyyyyy yy000000
		ld.h		%r13, %r12			;// %r13 := ssssssss ssssssss yyyyyyyy yy000000
		sra		%r13, 6				;// %r13 := ssssssss ssssssss ssssssyy yyyyyyyy
		Xsra		%r12, 16			;// %r12 := 00000000 00000000 00000000 00?????x
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r4
s1c17_x8_d_x4_rb:						;// %r12 := 00000000 00000000 ???????? x????yyy
		ld.w		%r4, %r13
		Xand		%r13, %r12, 7			;// %r13 := 00000000 00000000 00000000 00000yyy
		sla		%r13, 2				;// %r13 := 00000000 00000000 00000000 000yyy00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r13, %r13			;// %r13 := 00000000 00000000 00000000 000yyy00 + s1c17_cpu.r
		sra		%r12, 7				;// %r12 := 00000000 00000000 0000000? ???????x
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r4
s1c17_x13_rs:							;// %r12 := 00000000 00000000 ???????? ?????xxx
		and		%r12, 7				;// %r12 := 00000000 00000000 00000000 00000xxx
		sla		%r12, 2				;// %r12 := 00000000 00000000 00000000 000xxx00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r12, %r12			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r13
s1c17_x6_rd_x7:
s1c17_x6_rs_x7:							;// %r12 := 00000000 00000000 ??????xx x???????
		sra		%r12, 5				;// %r12 := 00000000 00000000 00000??? ???xxx??
		and		%r12, 0x1C			;// %r12 := 00000000 00000000 00000000 000xxx00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r12, %r12			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r13
s1c17_x6_rd_imm7:
s1c17_x6_rs_imm7:						;// %r12 := 00000000 00000000 ??????xx xyyyyyyy
		ld.w		%r4, %r13
		Xand		%r13, %r12, 0x7F		;// %r13 := 00000000 00000000 00000000 0yyyyyyy
		sra		%r12, 5				;// %r12 := 00000000 00000000 00000??? ???xxxyy
		and		%r12, 0x1C			;// %r12 := 00000000 00000000 00000000 000xxx00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r12, %r12			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r4
s1c17_x6_rd_sign7:						;// %r12 := 00000000 00000000 ??????xx xyyyyyyy
		ld.w		%r4, %r13
		sla		%r12, 1				;// %r12 := 00000000 0000000? ?????xxx yyyyyyy0
		ld.b		%r13, %r12			;// %r13 := ssssssss ssssssss ssssssss yyyyyyy0
		sra		%r13, 1				;// %r13 := ssssssss ssssssss ssssssss syyyyyyy
		sra		%r12, 6				;// %r12 := 00000000 00000000 00000??? ???xxxyy
		and		%r12, 0x1C			;// %r12 := 00000000 00000000 00000000 000xxx00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r12, %r12			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r4
s1c17_x6_rd_x4_rs:
s1c17_x6_rd_x4_rb:
s1c17_x6_rs_x4_rb:						;// %r12 := 00000000 00000000 ??????xx x????yyy
		ld.w		%r4, %r13
		Xld.w		%r5, s1c17_cpu
		Xand		%r13, %r12, 7			;// %r13 := 00000000 00000000 00000000 00000yyy
		sla		%r13, 2				;// %r13 := 00000000 00000000 00000000 000yyy00
		add		%r13, %r5			;// %r13 := 00000000 00000000 00000000 000yyy00 + s1c17_cpu.r
		sra		%r12, 5				;// %r12 := 00000000 00000000 00000??? ???xxx??
		and		%r12, 0x1C			;// %r12 := 00000000 00000000 00000000 000xxx00
		add		%r12, %r5			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r4
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/
/* extg̋ʏ */

#ifndef PIECE
int s1c17_0_imm13_imm24() {
	int x = 0;						/* 00000000 00000000 00000000 00000000 */
	if(s1c17_cpu.ext1 != -1) {
		x = s1c17_cpu.ext1;				/* 00000000 00000000 000yyyyy yyyyyyyy */ 
		if(s1c17_cpu.ext2 != -1) {
			x |= s1c17_cpu.ext2 << 13;		/* 000000?? zzzzzzzz zzzyyyyy yyyyyyyy */
			x = (unsigned)(x << 8) >> 8;		/* 00000000 zzzzzzzz zzzyyyyy yyyyyyyy */
		}
	}
	return x;
}
int s1c17_0_imm13_imm16() {
	return (unsigned short)s1c17_0_imm13_imm24();
}
int s1c17_rb_rb_imm13_rb_imm24(int* rb) {
	int x = *rb + s1c17_0_imm13_imm24();
	return (unsigned)(x << 8) >> 8;
}
int s1c17_sp_sp_imm13_sp_imm24() {
	return s1c17_rb_rb_imm13_rb_imm24(&s1c17_cpu.sp);
}
void s1c17_increment_rb_x_imm13_imm24(int* rb, int x) {
	*rb += (s1c17_cpu.ext1 == -1) ? x : s1c17_0_imm13_imm24();
	*rb = (unsigned)(*rb << 8) >> 8;
}
void s1c17_decrement_rb_x_imm13_imm24(int* rb, int x) {
	*rb -= (s1c17_cpu.ext1 == -1) ? x : s1c17_0_imm13_imm24();
	*rb = (unsigned)(*rb << 8) >> 8;
}
void s1c17_increment_sp_4_imm13_imm24() {
	s1c17_increment_rb_x_imm13_imm24(&s1c17_cpu.sp, 4);
}
void s1c17_decrement_sp_4_imm13_imm24() {
	s1c17_decrement_rb_x_imm13_imm24(&s1c17_cpu.sp, 4);
}
#else /*PIECE*/
int s1c17_0_imm13_imm24();
int s1c17_0_imm13_imm16();
int s1c17_rb_rb_imm13_rb_imm24(int* rb);
int s1c17_sp_sp_imm13_sp_imm24();
void s1c17_increment_rb_x_imm13_imm24(int* rb, int x);
void s1c17_decrement_rb_x_imm13_imm24(int* rb, int x);
void s1c17_increment_sp_4_imm13_imm24();
void s1c17_decrement_sp_4_imm13_imm24();
asm("
		.code
		.align		1
		.global		s1c17_0_imm13_imm24
		.global		s1c17_0_imm13_imm16
		.global		s1c17_rb_rb_imm13_rb_imm24
		.global		s1c17_sp_sp_imm13_sp_imm24
		.global		s1c17_increment_rb_x_imm13_imm24
		.global		s1c17_decrement_rb_x_imm13_imm24
		.global		s1c17_increment_sp_4_imm13_imm24
		.global		s1c17_decrement_sp_4_imm13_imm24
		;//-----------------------------------------------------;//
s1c17_0_imm13_imm24:
		Xld.w		%r4, s1c17_cpu+44			;// %r4  := &s1c17_cpu.ext1
		ld.h		%r10, [%r4]+				;// %r10 := ext1
		cmp		%r10, -1				;// if(ext1 != -1)
		jrne		s1c17_0_imm13_imm24_EXT1		;//   goto EXT1
		ret.d							;// return 0
		ld.w		%r10, 0					;//						*delay*
s1c17_0_imm13_imm24_EXT1:
		ld.h		%r5, [%r4]				;// %r5  := ext2
		cmp		%r5, -1					;// if(ext2 != -1)				!INTERLOCK!
		jrne		s1c17_0_imm13_imm24_EXT2		;//   goto EXT2
		ret							;// return ext1
s1c17_0_imm13_imm24_EXT2:
		Xsla		%r5, 13					;// %r5  :=           ext2 << 13
		or		%r10, %r5				;// %r10 :=   ext1 | (ext2 << 13)
		sll		%r10, 8					;// %r10 :=  (ext1 | (ext2 << 13)) << 8
		ret.d							;// return  ((ext1 | (ext2 << 13)) << 8) >> 8
		srl		%r10, 8					;// %r10 := ((ext1 | (ext2 << 13)) << 8) >> 8	*delay*
		;//-----------------------------------------------------;//
s1c17_0_imm13_imm16:
		call		s1c17_0_imm13_imm24			;// %r10 := x = s1c17_0_imm13_imm24()
		ret.d
		ld.uh		%r10, %r10				;// %r10 := (unsigned short)x			*delay*
		;//-----------------------------------------------------;//
s1c17_rb_rb_imm13_rb_imm24:
		pushn		%r0
		ld.w		%r0, [%r12]				;// %r0  := *rb
		call		s1c17_0_imm13_imm24			;// %r10 := x = s1c17_0_imm13_imm24()
		add		%r10, %r0				;// %r10 := x += *rb
		popn		%r0
		sll		%r10, 8					;// %r10 := x <<= 8
		ret.d
		srl		%r10, 8					;// %r10 := x >>= 8				*delay*
		;//-----------------------------------------------------;//
s1c17_sp_sp_imm13_sp_imm24:
		Xld.w		%r12, s1c17_cpu+36			;// %r12 := rb = &s1c17_cpu.sp
		jp		s1c17_rb_rb_imm13_rb_imm24		;// return s1c17_rb_rb_imm13_rb_imm24(rb)
		;//-----------------------------------------------------;//
s1c17_increment_rb_x_imm13_imm24:
		Xbtst		[s1c17_cpu+45], 7			;// if(ext1 < 0) {
		jrne		s1c17_increment_rb_x_imm13_imm24_L10	;//   
		 pushn		%r0					;//   
		 call.d		s1c17_0_imm13_imm24			;//   %r10 := x = s1c17_0_imm13_imm24()
		 ld.w		%r0, %r12				;//   %r0  := rb				*delay*
		 ld.w		%r12, %r0				;//   %r12 := rb
		 popn		%r0					;//   
		 ld.w		%r13, %r10				;//   %r13 := x
s1c17_increment_rb_x_imm13_imm24_L10:					;// }
		ld.w		%r10, [%r12]				;// %r10 :=      *rb
		add		%r10, %r13				;// %r10 := x += *rb				!INTERLOCK!
		sll		%r10, 8					;// %r10 := x <<= 8
		srl		%r10, 8					;// %r10 := x >>= 8
		ld.w		[%r12], %r10				;// *rb  := x
		ret
		;//-----------------------------------------------------;//
s1c17_decrement_rb_x_imm13_imm24:
		Xbtst		[s1c17_cpu+45], 7			;// if(ext1 < 0) {
		jrne		s1c17_decrement_rb_x_imm13_imm24_L10	;//   
		 pushn		%r0					;//   
		 call.d		s1c17_0_imm13_imm24			;//   %r10 := x = s1c17_0_imm13_imm24()
		 ld.w		%r0, %r12				;//   %r0  := rb				*delay*
		 ld.w		%r12, %r0				;//   %r12 := rb
		 popn		%r0					;//   
		 ld.w		%r13, %r10				;//   %r13 := x
s1c17_decrement_rb_x_imm13_imm24_L10:					;// }
		ld.w		%r10, [%r12]				;// %r10 :=      *rb
		sub		%r10, %r13				;// %r10 := x -= *rb				!INTERLOCK!
		sll		%r10, 8					;// %r10 := x <<= 8
		srl		%r10, 8					;// %r10 := x >>= 8
		ld.w		[%r12], %r10				;// *rb  := x
		ret
		;//-----------------------------------------------------;//
s1c17_increment_sp_4_imm13_imm24:
		Xld.w		%r12, s1c17_cpu+36			;// %r12 := rb = &s1c17_cpu.sp
		jp.d		s1c17_increment_rb_x_imm13_imm24	;// s1c17_increment_rb_x_imm13_imm24(rb, 4)
		ld.w		%r13, 4					;// %r13 := 4					*delay*
		;//-----------------------------------------------------;//
s1c17_decrement_sp_4_imm13_imm24:
		Xld.w		%r12, s1c17_cpu+36			;// %r12 := rb = &s1c17_cpu.sp
		jp.d		s1c17_decrement_rb_x_imm13_imm24	;// s1c17_decrement_rb_x_imm13_imm24(rb, 4)
		ld.w		%r13, 4					;// %r13 := 4					*delay*
");
#endif /*PIECE*/

#ifndef PIECE
int s1c17_imm7_imm20_imm24(int imm7) {
	int x = imm7;						/* 00000000 00000000 00000000 0xxxxxxx */
	if(s1c17_cpu.ext1 != -1) {
		x |= s1c17_cpu.ext1 << 7;			/* 00000000 0000yyyy yyyyyyyy yxxxxxxx */
		if(s1c17_cpu.ext2 != -1) {
			x |= s1c17_cpu.ext2 << 20;		/* ???????? zzzzyyyy yyyyyyyy yxxxxxxx */
			x = (unsigned)(x << 8) >> 8;		/* 00000000 zzzzyyyy yyyyyyyy yxxxxxxx */
		}
	}
	return x;
}
int s1c17_imm7_imm16(int imm7) {
	return (unsigned short)s1c17_imm7_imm20_imm24(imm7);
}
int s1c17_sp_imm7_sp_imm20_sp_imm24(int imm7) {
	int x = s1c17_cpu.sp + s1c17_imm7_imm20_imm24(imm7);
	return (unsigned)(x << 8) >> 8;
}
#else /*PIECE*/
int s1c17_imm7_imm20_imm24(int imm7);
int s1c17_imm7_imm16(int imm7);
int s1c17_sp_imm7_sp_imm20_sp_imm24(int imm7);
asm("
		.code
		.align		1
		.global		s1c17_imm7_imm20_imm24
		.global		s1c17_imm7_imm16
		.global		s1c17_sp_imm7_sp_imm20_sp_imm24
		;//---------------------------------------------;//
s1c17_imm7_imm20_imm24:
		Xld.w		%r4, s1c17_cpu+44		;// %r4  := &s1c17_cpu.ext1
		ld.h		%r5, [%r4]+			;// %r5  := ext1
		cmp		%r5, -1				;// if(ext1 != -1)
		jrne.d		s1c17_imm7_imm20_imm24_EXT1	;//   goto EXT1
		ld.w		%r10, %r12			;// %r10 := x = imm7				*delay*
		ret						;// return x
s1c17_imm7_imm20_imm24_EXT1:
		ld.h		%r6, [%r4]			;// %r6  := ext2
		sla		%r5, 7				;// %r5  := ext1 << 7				*anti-interlock*
		cmp		%r6, -1				;// if(ext2 != -1)
		jrne.d		s1c17_imm7_imm20_imm24_EXT2	;//   goto EXT2
		or		%r10, %r5			;// %r10 := x |= ext1 << 7			*delay*
		ret						;// return x
s1c17_imm7_imm20_imm24_EXT2:
		Xsla		%r6, 20				;// %r6  := ext2 << 20
		or		%r10, %r6			;// %r10 := x |= ext2 << 20
		sll		%r10, 8				;// %r10 := x <<= 8
		ret.d						;// return x
		srl		%r10, 8				;// %r10 := x >>= 8				*delay*
		;//---------------------------------------------;//
s1c17_imm7_imm16:
		call		s1c17_imm7_imm20_imm24		;// %r10 := x = s1c17_imm7_imm20_imm24(imm7)
		ret.d						;// return x
		ld.uh		%r10, %r10			;// %r10 := (unsigned short)x			*delay*
		;//---------------------------------------------;//
s1c17_sp_imm7_sp_imm20_sp_imm24:
		call		s1c17_imm7_imm20_imm24		;// %r10 := x = s1c17_imm7_imm20_imm24(imm7)
		Xld.w		%r4, [s1c17_cpu+36]		;// %r4  := sp
		add		%r10, %r4			;// %r10 := x += sp				!INTERLOCK!
		sll		%r10, 8				;// %r10 := x <<= 8
		ret.d						;// return x
		srl		%r10, 8				;// %r10 := x >>= 8				*delay*
");
#endif /*PIECE*/

#ifndef PIECE
int s1c17_sign7_sign16(int sign7) {
	int x = sign7;						/* ssssssss ssssssss ssssssss sxxxxxxx */
	if(s1c17_cpu.ext1 != -1) {
		x &= 0x7F;					/* 00000000 00000000 00000000 0xxxxxxx */
		x |= s1c17_cpu.ext1 << 7;			/* 00000000 0000???? yyyyyyyy yxxxxxxx */
		x = (short)x;					/* ssssssss ssssssss yyyyyyyy yxxxxxxx */
	}
	return x;
}
#else /*PIECE*/
int s1c17_sign7_sign16(int sign7);
asm("
		.code
		.align		1
		.global		s1c17_sign7_sign16
s1c17_sign7_sign16:
		Xld.h		%r4, [s1c17_cpu+44]		;// %r4  := ext1
		cmp		%r4, -1				;// if(ext1 != -1)
		jrne		s1c17_sign7_sign16_EXT1		;//   goto EXT1
		ret.d						;// return x
		ld.w		%r10, %r12			;// %r10 := x = sign7		*delay*
s1c17_sign7_sign16_EXT1:
		Xand		%r10, %r12, 0x7F		;// %r10 := x = sign7 & 0x7F
		sla		%r4, 7				;// %r4  :=      ext1 << 7
		or		%r10, %r4			;// %r10 := x |= ext1 << 7
		ret.d						;// return x
		ld.h		%r10, %r10			;// %r10 := (short)x		*delay*
");
#endif /*PIECE*/

#ifndef PIECE
int s1c17_sign11_sign24(int sign10) {
	int x = sign10 << 1;					/* ssssssss ssssssss sssssxxx xxxxxxx0 */
	if(s1c17_cpu.ext1 != -1) {
		x &= 0x7FF;					/* 00000000 00000000 00000xxx xxxxxxx0 */
		x |= s1c17_cpu.ext1 << 11;			/* 00000000 yyyyyyyy yyyyyxxx xxxxxxx0 */
		x = (x << 8) >> 8;				/* ssssssss yyyyyyyy yyyyyxxx xxxxxxx0 */
	}
	return x;
}
#else /*PIECE*/
int s1c17_sign11_sign24(int sign10);
asm("
		.code
		.align		1
		.global		s1c17_sign11_sign24
s1c17_sign11_sign24:
		Xld.h		%r4, [s1c17_cpu+44]		;// %r4  := ext1
		cmp		%r4, -1				;// if(ext1 != -1)
		jrne.d		s1c17_sign11_sign24_EXT1	;//   goto EXT1
		sla		%r12, 1				;// %r12 := x = sign10 << 1	*delay*
		ret.d						;// return x
		ld.w		%r10, %r12			;// %r10 := x			*delay*
s1c17_sign11_sign24_EXT1:
		Xand		%r10, %r12, 0x7FF		;// %r10 := x &= 0x7FF
		Xsla		%r4, 11				;// %r4  :=      ext1 << 11
		or		%r10, %r4			;// %r10 := x |= ext1 << 11
		sla		%r10, 8				;// %r10 := x <<= 8
		ret.d						;// return x
		sra		%r10, 8				;// %r10 := x >>= 8		*delay*
");
#endif /*PIECE*/

#ifndef PIECE
int s1c17_sign8_sign21_sign24(int sign7) {
	int x = sign7 << 1;					/* ssssssss ssssssss ssssssss xxxxxxx0 */
	if(s1c17_cpu.ext1 != -1) {
		x = (unsigned char)x;				/* 00000000 00000000 00000000 xxxxxxx0 */
		x |= s1c17_cpu.ext1 << 8;			/* 00000000 000yyyyy yyyyyyyy xxxxxxx0 */
		if(s1c17_cpu.ext2 == -1) {
			x = (x << 11) >> 11;			/* ssssssss sssyyyyy yyyyyyyy xxxxxxx0 */
		} else {
			x |= s1c17_cpu.ext2 << 21;		/* ???????? zzzyyyyy yyyyyyyy xxxxxxx0 */
			x = (x << 8) >> 8;			/* ssssssss zzzyyyyy yyyyyyyy xxxxxxx0 */
		}
	}
	return x;
}
#else /*PIECE*/
int s1c17_sign8_sign21_sign24(int sign7);
asm("
		.code
		.align		1
		.global		s1c17_sign8_sign21_sign24
s1c17_sign8_sign21_sign24:
		Xld.w		%r4, s1c17_cpu+44		;// %r4  := &s1c17_cpu.ext1
		ld.h		%r5, [%r4]+			;// %r5  := ext1
		cmp		%r5, -1				;// if(ext1 != -1)
		jrne.d		s1c17_sign8_sign21_sign24_EXT1	;//   goto EXT1
		sla		%r12, 1				;// %r12 := x = sign7 << 1	*delay*
		ret.d						;// return x
		ld.w		%r10, %r12			;// %r10 := x			*delay*
s1c17_sign8_sign21_sign24_EXT1:
		ld.ub		%r10, %r12			;// %r10 := x = (unsigned char)x
		ld.h		%r6, [%r4]			;// %r6  := ext2
		sla		%r5, 8				;// %r5  := ext1 << 8		*anti-interlock*
		cmp		%r6, -1				;// if(ext2 != -1)
		jrne.d		s1c17_sign8_sign21_sign24_EXT2	;//   goto EXT2
		or		%r10, %r5			;// %r10 := x |= ext1 << 8	*delay*
		Xsla		%r10, 11			;// %r10 := x <<= 11
		sra		%r10, 8				;// %r10 := x >>= 8
		ret.d						;// return x
		sra		%r10, 3				;// %r10 := x >>= 3		*delay*
s1c17_sign8_sign21_sign24_EXT2:
		Xsla		%r6, 21				;// %r6  := ext2 << 21
		or		%r10, %r6			;// %r10 := x |= ext2 << 21
		sla		%r10, 8				;// %r10 := x <<= 8
		ret.d						;// return x
		sra		%r10, 8				;// %r10 := x >>= 8		*delay*
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/
/* ZpZ߂̋ʏ */

#ifndef PIECE
int s1c17_add(int x, int y) {
	s1c17_cpu.psr.c = 0;
	return s1c17_adc(x, y);
}
int s1c17_adc(int x, int y) {
	int t = (x <<= 16) + (y <<= 16);
	int z = t + s1c17_cpu.psr.c + 0xFFFF;
	s1c17_cpu.psr.n = z < 0;
	s1c17_cpu.psr.v = (~(x ^ y) & (x ^ z)) < 0;
	s1c17_cpu.psr.c = ((unsigned)t < (unsigned)x) || ((unsigned)z < (unsigned)x);
	z = (unsigned)z >> 16;
	s1c17_cpu.psr.z = !z;
	return z;
}
int s1c17_sub(int x, int y) {
	s1c17_cpu.psr.c = 0;
	return s1c17_sbc(x, y);
}
int s1c17_sbc(int x, int y) {
	int t = (x <<= 16) - (y <<= 16);
	int z = t - s1c17_cpu.psr.c;
	s1c17_cpu.psr.n = z < 0;
	s1c17_cpu.psr.v = ((x ^ y) & (x ^ z)) < 0;
	s1c17_cpu.psr.c = ((unsigned)t > (unsigned)x) || ((unsigned)z > (unsigned)x);
	z = (unsigned)z >> 16;
	s1c17_cpu.psr.z = !z;
	return z;
}
#else /*PIECE*/
int s1c17_add(int x, int y);
int s1c17_adc(int x, int y);
int s1c17_sub(int x, int y);
int s1c17_sbc(int x, int y);
asm("
		.code
		.align		1
		.global		s1c17_add
		.global		s1c17_adc
		.global		s1c17_sub
		.global		s1c17_sbc
s1c17_add:
		Xbclr		[s1c17_cpu+32], 3		;// s1c17_cpu.psr.c = 0
s1c17_adc:	;//---------------------------------------------;//
		Xld.w		%r4, s1c17_cpu+32		;// %r4  := &s1c17_cpu.psr
		ld.ub		%r5, [%r4]			;// %r5  := old_psr
		Xand		%r6, %r5, 0xF0			;// %r6  := old_psr &= ~CVZN
		;//
		Xsll		%r12, 16			;// %r12[31:16] := x
		Xsll		%r13, 16			;// %r13[31:16] := y
		Xoor		%r13, %r13, 0xFFFF		;// %r13[15: 0] := 0xFFFF
		rr		%r5, 4				;// %r5[31]     := C
		add		%r5, %r5			;// %psr[C]     := C
		jp.d		s1c17_adc_sbc
		adc		%r12, %r13			;// %r12[31:16] := z = x + y + C	*delay*
s1c17_sub:	;//---------------------------------------------;//
		Xbclr		[s1c17_cpu+32], 3		;// s1c17_cpu.psr.c = 0
s1c17_sbc:	;//---------------------------------------------;//
		Xld.w		%r4, s1c17_cpu+32		;// %r4  := &s1c17_cpu.psr
		ld.ub		%r5, [%r4]			;// %r5  := old_psr
		Xand		%r6, %r5, 0xF0			;// %r6  := old_psr &= ~CVZN
		;//
		Xsll		%r12, 16			;// %r12[31:16] := x
		Xsll		%r13, 16			;// %r13[31:16] := y
		rr		%r5, 4				;// %r5[31]     := C
		add		%r5, %r5			;// %psr[C]     := C
		sbc		%r12, %r13			;// %r12[31:16] := z = x - y - C
s1c17_adc_sbc:	;//---------------------------------------------;//
		ld.w		%r5, %psr			;// %r5  := new_psr
		Xsrl		%r12, 16			;// %r12 := z
		jrne.d		3				;// if(!z)
		 and		%r5, 0x0D			;// %r5  := new_psr &= CV0N		*delay*
		 or		%r5, 0x02			;//   %r5  := new_psr |= 00Z0
		or		%r5, %r6			;// %r5  := new_psr |= old_psr
		ld.b		[%r4], %r5			;// s1c17_cpu.psr := new_psr
		ret.d
		ld.w		%r10, %r12			;// %r10 := z				*delay*
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/
/* AhXZ߂̋ʏ */

#ifndef PIECE
int s1c17_add_a(int x, int y) {
	x += y;
	return (unsigned)(x << 8) >> 8;
}
int s1c17_sub_a(int x, int y) {
	x -= y;
	return (unsigned)(x << 8) >> 8;
}
void s1c17_cmp_a(int x, int y) {
	x -= y;
	s1c17_cpu.psr.z = !x;
	s1c17_cpu.psr.c = x < 0;
}
#else /*PIECE*/
int s1c17_add_a(int x, int y);
int s1c17_sub_a(int x, int y);
void s1c17_cmp_a(int x, int y);
asm("
		.code
		.align		1
		.global		s1c17_add_a
		.global		s1c17_sub_a
		.global		s1c17_cmp_a
s1c17_sub_a:
		not		%r13, %r13			;// %r13 := y = -y
		add		%r13, 1
s1c17_add_a:
		add		%r12, %r13			;// %r12 := x += y
		sll		%r12, 8				;// %r12 := x <<= 8
		srl		%r12, 8				;// %r12 := x >>= 8
		ret.d
		ld.w		%r10, %r12			;// %r10 := x			*delay*
s1c17_cmp_a:
		Xld.w		%r4, s1c17_cpu+32		;// %r4  := &s1c17_cpu.psr
		cmp		%r12, %r13			;// %psr := new_psr = x - y
		ld.w		%r5, %psr			;// %r5  := new_psr
		ld.ub		%r6, [%r4]			;// %r6  := old_psr
		and		%r5, 0x0000000A			;// %r5  := new_psr &=  C0Z0	*anti-interlock*
		and		%r6, 0xFFFFFFF5			;// %r6  := old_psr &= ~C0Z0
		or		%r5, %r6			;// %r5  := new_psr |= old_psr
		ld.b		[%r4], %r5			;// s1c17_cpu.psr := new_psr
		ret
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/
/* _Z߂̋ʏ */

#ifndef PIECE
int s1c17_and(int x, int y) {
	x = (short)x & (short)y;
	s1c17_cpu.psr.n = x < 0;
	s1c17_cpu.psr.z = !x;
	s1c17_cpu.psr.v = 0;
	return (unsigned short)x;
}
int s1c17_or(int x, int y) {
	x = (short)x | (short)y;
	s1c17_cpu.psr.n = x < 0;
	s1c17_cpu.psr.z = !x;
	s1c17_cpu.psr.v = 0;
	return (unsigned short)x;
}
int s1c17_xor(int x, int y) {
	x = (short)x ^ (short)y;
	s1c17_cpu.psr.n = x < 0;
	s1c17_cpu.psr.z = !x;
	s1c17_cpu.psr.v = 0;
	return (unsigned short)x;
}
int s1c17_not(int x) {
	x = ~(short)x;
	s1c17_cpu.psr.n = x < 0;
	s1c17_cpu.psr.z = !x;
	s1c17_cpu.psr.v = 0;
	return (unsigned short)x;
}
#else /*PIECE*/
int s1c17_and(int x, int y);
int s1c17_or(int x, int y);
int s1c17_xor(int x, int y);
int s1c17_not(int x);
asm("
		.code
		.align		1
		.global		s1c17_and
		.global		s1c17_or
		.global		s1c17_xor
		.global		s1c17_not
s1c17_and:	;//---------------------------------------------;//
		ld.h		%r12, %r12			;// %r12 := x = (short)x
		ld.h		%r13, %r13			;// %r13 := y = (short)y
		jp.d		s1c17_and_or_xor_not
		and		%r12, %r13			;// %r12 := x &= y				*delay*
s1c17_or:	;//---------------------------------------------;//
		ld.h		%r12, %r12			;// %r12 := x = (short)x
		ld.h		%r13, %r13			;// %r13 := y = (short)y
		jp.d		s1c17_and_or_xor_not
		or		%r12, %r13			;// %r12 := x |= y				*delay*
s1c17_xor:	;//---------------------------------------------;//
		ld.h		%r12, %r12			;// %r12 := x = (short)x
		ld.h		%r13, %r13			;// %r13 := y = (short)y
		jp.d		s1c17_and_or_xor_not
		xor		%r12, %r13			;// %r12 := x ^= y				*delay*
s1c17_not:	;//---------------------------------------------;//
		ld.h		%r12, %r12			;// %r12 := x = (short)x
		not		%r12, %r12			;// %r12 := x = ~x
		;//---------------------------------------------;//
s1c17_and_or_xor_not:
		Xld.w		%r4, s1c17_cpu+32		;// %r4  :=                     &s1c17_cpu.psr
		ld.w		%r5, %psr			;// %r5  := new_psr
		ld.ub		%r6, [%r4]			;// %r6  :=            old_psr = s1c17_cpu.psr
		and		%r5, 0x0000000B			;// %r5  := new_psr &= C0ZN
		and		%r6, 0xFFFFFFF0			;// %r6  :=            old_psr &= ~CVZN
		or		%r5, %r6			;// %r5  := new_psr |= old_psr
		ld.b		[%r4], %r5			;// s1c17_cpu.psr := new_psr
		ret.d
		ld.uh		%r10, %r12			;// %r10 := (unsigned short)x			*delay*
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/
/* 򖽗߂̋ʏ */

#ifndef PIECE
void s1c17_jpa(int x, int d) {
	if(d) {
		s1c17_cpu.ext1 = s1c17_cpu.ext2 = -1; /* 򖽗߂ɑ΂extxXbgɉeȂ悤Bs1c17_ext_imm13()extOɂ֗邽ߕKv */
		s1c17_cpu_exec();
	}
	s1c17_cpu.pc = x & ~1;
}
void s1c17_jpr(int x, int d) {
	x += s1c17_cpu.pc;
	x = (unsigned)(x << 8) >> 8;
	s1c17_jpa(x, d);
}
#else /*PIECE*/
void s1c17_jpa(int x, int d);
void s1c17_jpr(int x, int d);
asm("
		.code
		.align		1
		.global		s1c17_jpa
		.global		s1c17_jpr
		;//---------------------------------------------;//
s1c17_jpa:
		cmp		%r13, 0				;// if(!d)
		jreq.d		s1c17_jpa_NO_DELAY		;//   goto NO_DELAY
		and		%r12, 0xFFFFFFFE		;// %r12 := x &= ~1		*delay*
		;//{{DELAY
		pushn		%r0
		ld.w		%r4, -1				;// %r4  := -1
		Xld.w		[s1c17_cpu+44], %r4		;// s1c17_cpu.ext1 = s1c17_cpu.ext2 = -1
		Xcall.d		s1c17_cpu_exec			;// s1c17_cpu_exec()
		ld.w		%r0, %r12			;// %r0  := x			*delay*
		ld.w		%r12, %r0			;// %r12 := x
		popn		%r0
		;//}}DELAY
s1c17_jpa_NO_DELAY:
		Xld.w		[s1c17_cpu+40], %r12		;// s1c17_cpu.pc := x
		ret
		;//---------------------------------------------;//
s1c17_jpr:
		Xld.w		%r4, [s1c17_cpu+40]		;// %r4  := s1c17_cpu.pc
		add		%r12, %r4			;// %r12 := x += s1c17_cpu.pc	!INTERLOCK!
		sll		%r12, 8				;// %r12 := x <<= 8
		jp.d		s1c17_jpa			;// s1c17_jpa(x, d)
		srl		%r12, 8				;// %r12 := x >>= 8		*delay*
");
#endif /*PIECE*/

#ifndef PIECE
void s1c17_calla(int x, int d) {
	s1c17_cpu.sp -= 4;
	if(d) {
		s1c17_cpu.ext1 = s1c17_cpu.ext2 = -1; /* 򖽗߂ɑ΂extxXbgɉeȂ悤Bs1c17_ext_imm13()extOɂ֗邽ߕKv */
		s1c17_cpu_exec();
	}
	s1c17_bcu_write(4, s1c17_cpu.sp, s1c17_cpu.pc);
	s1c17_cpu.pc = x & ~1;
}
void s1c17_call(int x, int d) {
	x += s1c17_cpu.pc;
	x = (unsigned)(x << 8) >> 8;
	s1c17_calla(x, d);
}
#else /*PIECE*/
void s1c17_calla(int x, int d);
void s1c17_call(int x, int d);
asm("
		.code
		.align		1
		.global		s1c17_calla
		.global		s1c17_call
		;//---------------------------------------------;//
s1c17_calla:
		pushn		%r1
		Xld.w		%r0, s1c17_cpu+36		;// %r0  := &s1c17_cpu.sp
		ld.w		%r4, [%r0]			;// %r4  := sp
		ld.w		%r1, %r12			;// %r1  := x			*anti-interlock*
		sub		%r4, 4				;// %r4  := sp -= 4
		ld.w		[%r0], %r4			;// s1c17_cpu.sp := sp
		cmp		%r13, 0				;// if(!d)
		jreq.d		s1c17_calla_NO_DELAY		;//   goto NO_DELAY
		and		%r1, 0xFFFFFFFE			;// %r1  := x &= ~1		*delay*
		;//{{DELAY
		ld.w		%r4, -1				;// %r4  := -1
		Xld.w		[%r0+8], %r4			;// s1c17_cpu.ext1 = s1c17_cpu.ext2 = -1
		Xcall		s1c17_cpu_exec			;// s1c17_cpu_exec()
		;//}}DELAY
s1c17_calla_NO_DELAY:
		ld.w		%r13, [%r0]+			;// %r13 := sp
		ld.w		%r14, [%r0]			;// %r14 := pc
		ld.w		[%r0], %r1			;// s1c17_cpu.pc := x
		popn		%r1
		Xjp.d		s1c17_bcu_write			;// s1c17_bcu_write(4, sp, pc)
		ld.w		%r12, 4				;// %r12 := 4			*delay*
		;//---------------------------------------------;//
s1c17_call:
		Xld.w		%r4, [s1c17_cpu+40]		;// %r4  := s1c17_cpu.pc
		add		%r12, %r4			;// %r12 := x += s1c17_cpu.pc	!INTERLOCK!
		sll		%r12, 8				;// %r12 := x <<= 8
		jp.d		s1c17_calla			;// s1c17_calla(x, d)
		srl		%r12, 8				;// %r12 := x >>= 8		*delay*
");
#endif /*PIECE*/

void s1c17_int(int no) {
	s1c17_cpu.sp -= 4;
	s1c17_bcu_write(4, s1c17_cpu.sp, s1c17_cpu.pc | (*(unsigned char*)&s1c17_cpu.psr << 24));
	s1c17_cpu.pc = s1c17_bcu_read(4, s1c17_bcu_read(4, 0xFFFF80/*TTBR*/) + no * 4);
	s1c17_cpu.pc = (unsigned)(s1c17_cpu.pc << 8) >> 8;
	s1c17_cpu.pc &= ~1;
	s1c17_cpu.psr.ie = 0;
}

/*--------------------------------------------------------------------------*/
/* Vtg߂̋ʏ */

int s1c17_sr(int x, int y) {
	y = (y < 4) ? y : (y < 8) ? 4 : 8;
	s1c17_cpu.psr.c = (x & 0x0001) ? 1 : 0;
	x = (unsigned short)x;
	x >>= y;
	s1c17_cpu.psr.z = !x;
	s1c17_cpu.psr.n = (x & 0x8000) ? 1 : 0;
	return x;
}
int s1c17_sa(int x, int y) {
	y = (y < 4) ? y : (y < 8) ? 4 : 8;
	s1c17_cpu.psr.c = (x & 0x0001) ? 1 : 0;
	x = (short)x;
	x >>= y;
	x = (unsigned short)x;
	s1c17_cpu.psr.z = !x;
	s1c17_cpu.psr.n = (x & 0x8000) ? 1 : 0;
	return x;
}
int s1c17_sl(int x, int y) {
	y = (y < 4) ? y : (y < 8) ? 4 : 8;
	s1c17_cpu.psr.c = (x & 0x8000) ? 1 : 0;
	x <<= y;
	x = (unsigned short)x;
	s1c17_cpu.psr.z = !x;
	s1c17_cpu.psr.n = (x & 0x8000) ? 1 : 0;
	return x;
}

/****************************************************************************
 *	}bvAoX
 ****************************************************************************/

#ifndef PIECE
int s1c17_bcu_read(int size, int addr) {
	int data;
	s1c17_device* device = s1c17_device_select(size, addr);
	int ofs = addr - device->top;
	if(size <= device->size) {
		data = device->read(size, ofs);
	} else {
		/* CPUANZXTCYAfoCXTCYȉɕ */
		if(device->size == 1) {
			/* foCXTCY = 8rbg */
			if(size == 2) {
				/* CPUANZXTCY = 16rbg */
				data  = device->read(1, ofs);       ofs += 1;
				data |= device->read(1, ofs) <<  8;
			} else {
				/* CPUANZXTCY = 32rbg */
				data  = device->read(1, ofs);       ofs += 1;
				data |= device->read(1, ofs) <<  8; ofs += 1;
				data |= device->read(1, ofs) << 16; ofs += 1;
				data |= device->read(1, ofs) << 24;
			}
		} else {
			/* foCXTCY = 16rbg */
			/* CPUANZXTCY = 32rbg */
			data  = device->read(2, ofs);       ofs += 2;
			data |= device->read(2, ofs) << 16;
		}
	}
	return data;
}
#else /*PIECE*/
int s1c17_bcu_read(int size, int addr);
asm("
		.code
		.align		1
		.global		s1c17_bcu_read
s1c17_bcu_read:
		pushn		%r2
		ld.w		%r0, %r12			;// %r0  := size
		Xcall.d		s1c17_device_select		;// %r10 := device = s1c17_device_select(size, addr)
		ld.w		%r1, %r13			;// %r1  := addr					*delay*
		;//
		ld.w		%r4, [%r10]			;// %r4  := device->top
		Xld.w		%r5, [%r10+8]			;// %r5  := device->size
		Xld.w		%r2, [%r10+12]			;// %r2  := device->read
		;//
		cmp		%r0, %r5			;// if(size > device->size)
		jrgt.d		s1c17_bcu_read_SPLIT		;//   goto SPLIT
		sub		%r1, %r4			;// %r1  := ofs = addr - device->top			*delay*
		;//
		ld.w		%r12, %r0			;// %r12 := size
		call.d		%r2				;// %r10 := data = device->read(size, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
s1c17_bcu_read_RET:
		popn		%r2
		ret						;// return data
		;//---------------------------------------------;//
s1c17_bcu_read_SPLIT:
		cmp		%r5, 1				;// if(device->size != 1)
		jrne		s1c17_bcu_read_SPLIT_2_4	;//   goto SPLIT_2_4
		cmp		%r0, 2				;// if(size != 2)
		jrne		s1c17_bcu_read_SPLIT_1_4	;//   goto SPLIT_1_4
		;//---------------------------------------------;//
		;// foCXTCY = 8rbg, CPUANZXTCY = 16rbg
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		ld.w		%r0, %r10			;// %r0  := data = device->read(1, ofs)
		add		%r1, 1				;// %r1  := ofs += 1
		;//
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		sla		%r10, 8				;// %r10 := device->read(1, ofs) << 8
		jp.d		s1c17_bcu_read_RET		;// return data
		or		%r10, %r0			;// %r10 := data |= device->read(1, ofs) << 8		*delay*
		;//---------------------------------------------;//
s1c17_bcu_read_SPLIT_1_4:
		;// foCXTCY = 8rbg, CPUANZXTCY = 32rbg
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		ld.w		%r0, %r10			;// %r0  := data = device->read(1, ofs)
		add		%r1, 1				;// %r1  := ofs += 1
		;//
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		sla		%r10, 8				;// %r10 := device->read(1, ofs) << 8
		or		%r0, %r10			;// %r0  := data |= device->read(1, ofs) << 8
		add		%r1, 1				;// %r1  := ofs += 1
		;//
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		Xsla		%r10, 16			;// %r10 := device->read(1, ofs) << 16
		or		%r0, %r10			;// %r0  := data |= device->read(1, ofs) << 16
		add		%r1, 1				;// %r1  := ofs += 1
		;//
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		Xsla		%r10, 24			;// %r10 := device->read(1, ofs) << 24
		jp.d		s1c17_bcu_read_RET		;// return data
		or		%r10, %r0			;// %r10 := data |= device->read(1, ofs) << 24		*delay*
		;//---------------------------------------------;//
s1c17_bcu_read_SPLIT_2_4:
		;// foCXTCY = 16rbg, CPUANZXTCY = 32rbg
		ld.w		%r12, 2				;// %r12 := 2
		call.d		%r2				;// %r10 := device->read(2, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		ld.w		%r0, %r10			;// %r0  := data = device->read(2, ofs)
		add		%r1, 2				;// %r1  := ofs += 2
		;//
		ld.w		%r12, 2				;// %r12 := 2
		call.d		%r2				;// %r10 := device->read(2, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		Xsla		%r10, 16			;// %r10 := device->read(2, ofs) << 16
		jp.d		s1c17_bcu_read_RET		;// return data
		or		%r10, %r0			;// %r10 := data |= device->read(2, ofs) << 16		*delay*
");
#endif /*PIECE*/

#ifndef PIECE
void s1c17_bcu_write(int size, int addr, int data) {
	s1c17_device* device = s1c17_device_select(size, addr);
	int ofs = addr - device->top;
	if(size <= device->size) {
		device->write(size, ofs, data);
	} else {
		/* CPUANZXTCYAfoCXTCYȉɕ */
		if(device->size == 1) {
			/* foCXTCY = 8rbg */
			if(size == 2) {
				/* CPUANZXTCY = 16rbg */
				device->write(1, ofs, data); ofs += 1; data >>= 8;
				device->write(1, ofs, data);
			} else {
				/* CPUANZXTCY = 32rbg */
				device->write(1, ofs, data); ofs += 1; data >>= 8;
				device->write(1, ofs, data); ofs += 1; data >>= 8;
				device->write(1, ofs, data); ofs += 1; data >>= 8;
				device->write(1, ofs, data);
			}
		} else {
			/* foCXTCY = 16rbg */
			/* CPUANZXTCY = 32rbg */
			device->write(2, ofs, data); ofs += 2; data >>= 16;
			device->write(2, ofs, data);
		}
	}
}
#else /*PIECE*/
void s1c17_bcu_write(int size, int addr, int data);
asm("
		.code
		.align		1
		.global		s1c17_bcu_write
s1c17_bcu_write:
		pushn		%r3
		ld.w		%r0, %r12			;// %r0  := size
		ld.w		%r1, %r13			;// %r1  := addr
		Xcall.d		s1c17_device_select		;// %r10 := device = s1c17_device_select(size, addr)
		ld.w		%r2, %r14			;// %r2  := data					*delay*
		;//
		ld.w		%r4, [%r10]			;// %r4  := device->top
		Xld.w		%r5, [%r10+8]			;// %r5  := device->size
		Xld.w		%r3, [%r10+16]			;// %r3  := device->write
		;//
		cmp		%r0, %r5			;// if(size > device->size)
		jrgt.d		s1c17_bcu_write_SPLIT		;//   goto SPLIT
		sub		%r1, %r4			;// %r1  := ofs = addr - device->top			*delay*
		;//
		ld.w		%r12, %r0			;// %r12 := size
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(size, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
s1c17_bcu_write_RET:
		popn		%r3
		ret
		;//---------------------------------------------;//
s1c17_bcu_write_SPLIT:
		cmp		%r5, 1				;// if(device->size != 1)
		jrne		s1c17_bcu_write_SPLIT_2_4	;//   goto SPLIT_2_4
		cmp		%r0, 2				;// if(size != 2)
		jrne		s1c17_bcu_write_SPLIT_1_4	;//   goto SPLIT_1_4
		;//---------------------------------------------;//
		;// foCXTCY = 8rbg, CPUANZXTCY = 16rbg
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 1				;// %r1  := ofs += 1
		sra		%r2, 8				;// %r2  := data >>= 8
		;//
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		jp		s1c17_bcu_write_RET
		;//---------------------------------------------;//
s1c17_bcu_write_SPLIT_1_4:
		;// foCXTCY = 8rbg, CPUANZXTCY = 32rbg
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 1				;// %r1  := ofs += 1
		sra		%r2, 8				;// %r2  := data >>= 8
		;//
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 1				;// %r1  := ofs += 1
		sra		%r2, 8				;// %r2  := data >>= 8
		;//
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 1				;// %r1  := ofs += 1
		sra		%r2, 8				;// %r2  := data >>= 8
		;//
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		jp		s1c17_bcu_write_RET
		;//---------------------------------------------;//
s1c17_bcu_write_SPLIT_2_4:
		;// foCXTCY = 16rbg, CPUANZXTCY = 32rbg
		ld.w		%r12, 2				;// %r12 := 2
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(2, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 2				;// %r1  := ofs += 2
		Xsra		%r2, 16				;// %r2  := data >>= 16
		;//
		ld.w		%r12, 2				;// %r12 := 2
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(2, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		jp		s1c17_bcu_write_RET
");
#endif /*PIECE*/

#ifndef PIECE
s1c17_device* s1c17_device_select(int size, int addr) { /* foCX */
	s1c17_device** next;
	s1c17_device* device;
	/* sAhX */
	if(addr & (size - 1)) {
		DIE(); /* TODO:ʃrbg0Ƃăf[^]AAhXs荞݂𐶐 */
	}
	/* foCXe[u */
	next = &s1c17_device_root;
	while((device = *next) != NULL) {
		if((addr >= device->top) && (addr <= device->end)) {
			/*{{LRU*/
			/* s1c17_device_root=devicȅꍇȉ̏ővłB */
			*next = device->next;
			device->next = s1c17_device_root;
			s1c17_device_root = device;
			/*}}LRU*/
			return device; /*  */
		}
		next = &device->next;
	}
	return &s1c17_device_dummy; /* ȂA_~[foCXԂ */
}
#else /*PIECE*/
s1c17_device* s1c17_device_select(int size, int addr); /* foCX */
asm("
		.code
		.align		1
		.global		s1c17_device_select
s1c17_device_select:
		;// GAւ̃ANZXAꍇ̂ŁALRU̐擪GgƂ̔rœK܂B
		;// LRU̐擪GgŃqbgꍇ́ALRU̓ւsKv܂B
		;// %r12 := size -> gȂ
		;// %r13 := addr
		Xld.w		%r4, s1c17_device_root		;// %r4  := &s1c17_device_root
		ld.w		%r10, [%r4]			;// %r10 := device = s1c17_device_root
		ld.w		%r5, [%r10]			;// %r5  := device->top
		Xld.w		%r6, [%r10+4]			;// %r6  := device->end
		cmp		%r13, %r5			;// if(addr < device->top)
		jrlt		s1c17_device_select_SEARCH	;//   goto SEARCH
		cmp		%r13, %r6			;// if(addr > device->end)
		jrgt		s1c17_device_select_SEARCH	;//   goto SEARCH
		ret						;// 
		;//---------------------------------------------;//
s1c17_device_select_SEARCH:
		;// ȍ~́ALRU̐擪GgƂ̔r~Xꍇ́Aʏ̌łB
		;// %r4  := &s1c17_device_root
		;// %r13 := addr
		add		%r10, 20			;// %r10 := next = &device->next
s1c17_device_select_LOOP:
		;// %r4  := &s1c17_device_root
		;// %r10 := next
		;// %r13 := addr
		ld.w		%r7, %r10			;// %r7  := next
		ld.w		%r10, [%r7]			;// %r10 := device = *next
		cmp		%r10, 0				;// if(!device)							!INTERLOCK!
		jreq		s1c17_device_select_DUMMY	;//   return &s1c17_device_dummy
		;// %r4  := &s1c17_device_root
		;// %r7  := next
		;// %r10 := device
		;// %r13 := addr
		ld.w		%r5, [%r10]+			;// %r5  := device->top
		ld.w		%r6, [%r10]			;// %r6  := device->end
;//		add		%r10, 16			;// %r10 := &device->next ------------------------------+
		;// %r4  := &s1c17_device_root										|
		;// %r5  := device->top											|
		;// %r6  := device->end											|
		;// %r7  := next											|
		;// %r10 := &device->next										|
		;// %r13 := addr											|
		cmp		%r13, %r5			;// if(addr < device->top)				|
		jrlt.d		s1c17_device_select_LOOP	;//   { %r10 := next = &device->next; goto LOOP; }	|
		add		%r10, 16			;// %r10 := &device->next <-----------------------------+	*delay*
		cmp		%r13, %r6			;// if(addr > device->end)
		jrgt		s1c17_device_select_LOOP	;//   { %r10 := next = &device->next; goto LOOP; }
		;//{{LRU
		;// LRUւ́AdeviceLRU̐擪GgłȂ(next!=&s1c17_device_root)ƂOƂłB
		ld.w		%r5, [%r10]			;// %r5  := device->next
		ld.w		%r6, [%r4]			;// %r6  := s1c17_device_root					*anti-interlock*
		ld.w		[%r7], %r5			;// *next = device->next					*anti-interlock*
		ld.w		[%r10], %r6			;// device->next = s1c17_device_root
		sub		%r10, 20			;// %r10 := device
		ld.w		[%r4], %r10			;// s1c17_device_root = device
		;//}}LRU
		ret						;// return device
		;//---------------------------------------------;//
s1c17_device_select_DUMMY:
		Xld.w		%r10, s1c17_device_dummy	;// return &s1c17_device_dummy
		ret
");
#endif /*PIECE*/
