/*	
 *	framay3.c
 *
 *	P/ECE AY-3-8910 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sat Feb 07 19:08:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Mar 06 09:57:00 JST 2004 Naoyuki Sawa
 *	- ay38910_channel_process()ɁA0̑returnǉ܂B
 *	  S`lɔĂ悤ȋȂł́AĒxȂ܂B
 *	  ۂɂ́APSG~LVȎxɂȂ̂́APSG2ȏgĂP[XƎv܂B
 *	  PSG2ȏgĂP[Xł́A0̃`lcĂꍇA҂ł܂B
 *	* Sun Mar 06 19:52:00 JST 2004 Naoyuki Sawa
 *	- ʃJ[u̒s܂B
 *	  ܂ŁAamplitude_level,envelope_level0`15ŁAὠjAłA
 *	  ł̓Gx[v₩܂B
 *	  ŁAꂼ2悵 0`15^2 ̒li[邱Ƃɂ܂B
 */
#include "clip.h"

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
ay38910_mix(AY38910* ay, short wbuff[/*count*/], int count)
{
	DDA clock_progress;
	int cycle;
	int sample;

	clock_progress = ay->clock_progress; /* ̂߁Aꎞo */
	while(count > 0) {
		/* o߃TCN߂܂B */
		cycle = clock_progress.u;
		clock_progress.d += clock_progress.n;
		if(clock_progress.d >= 0) {
			clock_progress.d -= SPEAKER_FREQUENCY;
			cycle++;
		}

		/* 1Tv~LVO܂B */
		sample = ay38910_process(ay, cycle);	/* t11.5bit */
		sample <<= 16 - 10/**/;

		/* NbsOĊi[܂B */
		if(sample < -0x7fff) sample = -0x7fff;
		if(sample >  0x7fff) sample =  0x7fff;
		*wbuff++ = sample;

		/* cTv炵܂B */
		count--;
	}
	ay->clock_progress = clock_progress; /* ߂BYꂸȂ!! */
}

/****************************************************************************
 *	֐
 ****************************************************************************/

int
ay38910_process(AY38910* ay, int cycle)
{
	/*===== mCY =====*/
	if(ay->noise_enable) {
		ay->noise_progress -= cycle;
		while(ay->noise_progress <= 0) {
			ay->noise_progress += ay->noise_period;
			/* @̓̎dl킩Ȃ̂ŁA[9bit tap=0x11]Mn񗐐gƂɂ܂B */
			ay->noise_lfsr = (ay->noise_lfsr >> 1) |
					 (((ay->noise_lfsr >> 0) ^ (ay->noise_lfsr >> 4)) & 1) << 8;
			ay->noise_output = ay->noise_lfsr & 1;
		}
	}

	/*===== Gx[v =====*/
	if(ay->envelope_enable) {
		ay->envelope_progress -= cycle;
		while(ay->envelope_progress <= 0) {
			ay->envelope_progress += ay->envelope_period;
			ay->envelope_counter++;
			/* Gx[vxݒB
			 * Gx[vZbg͕K֗āAGx[vxݒ肳܂B
			 * ay38910_write()֐Reg#13̕QƂĂB
			 */
			ay->envelope_level = ay->envelope_counter & 15;
			if(ay->envelope_shape_cycle & 1/*Hold*/) {
				if(ay->envelope_counter >= 16) {
					ay->envelope_counter = 16;
					ay->envelope_level = 15;
				}
			}
			if(ay->envelope_shape_cycle & 2/*Alternate*/) {
				if(ay->envelope_counter & 16) {
					ay->envelope_level ^= 15;
				}
			}
			if(!(ay->envelope_shape_cycle & 4/*Attack*/)) {
				ay->envelope_level ^= 15;
			}
			if(!(ay->envelope_shape_cycle & 8/*Continue*/)) {
				if(ay->envelope_counter >= 16) {
					ay->envelope_level = 0;
				}
			}
			ay->envelope_level *= ay->envelope_level;  /* ʃJ[u̒ */
		}
	}

	/*===== `l =====*/
	return ay38910_channel_process(ay, &ay->channel[0], cycle)	/*  t10bit */
	     + ay38910_channel_process(ay, &ay->channel[1], cycle)	/* +t10bit */
	     + ay38910_channel_process(ay, &ay->channel[2], cycle);	/* +t10bit */
}									/* =t11.5bit */

int
ay38910_channel_process(AY38910* ay, AY38910CHANNEL* channel, int cycle)
{
	int output = 0;
	int level = channel->amplitude_mode ? ay->envelope_level : channel->amplitude_level;
	if(!level) return 0; /* 2004/03/07ǉ: 0Ȃ牽܂B */

	/*===== g[ =====*/
	if(channel->tone_enable) {
		channel->tone_progress -= cycle;
		while(channel->tone_progress <= 0) {
			channel->tone_progress += channel->tone_period;
			channel->tone_output = !channel->tone_output;
		}
		if(channel->tone_output) {
			output += level;
		} else {
			output -= level;
		}
	}

	/*===== mCY =====*/
	if(channel->noise_enable) {
		if(ay->noise_output) {
			output += level;
		} else {
			output -= level;
		}
	}

	return output;	/* t9bit~2 = t10bit */
}

