;	
;	framapua.s
;
;	P/ECE APU (RICOH RP2A03) Emulator
;	
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;	
;	* Sun Feb 06 18:39:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
#include "clipapua.h"
#ifdef APU_ASM

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

#define SPEAKER_FREQUENCY	16000	; -> clipmisc.h
#define	NTSC_COLOR_SUBCARRIER	3579545	; -> clipemu.h
#define APU_CLOCK		(NTSC_COLOR_SUBCARRIER/2)

;****************************************************************************
;	
;****************************************************************************

					; /* OXJE^ (60Hz) */
					; typedef struct _APULENGTH {
#define APULENGTH_FLAGS		 0	; 	unsigned char flags;		/* + 0,1: D0: 0 = OXJE^ */
					; 					/*            1 = OXJE^L */
#define APULENGTH_COUNT		 1	; 	unsigned char count;		/* + 1,1: OXJE^ (0..127) */
#define SIZEOF_APULENGTH	 2	; } APULENGTH;				/* = 2 */
 
					; /* jAJE^ (240Hz) */
					; typedef struct _APULINEAR {
#define APULINEAR_FLAGS		 0	; 	unsigned char flags;		/* + 0,1: D0: 0 = jAJE^ */
					; 					/*            1 = jAJE^L */
#define APULINEAR_COUNT		 1	; 	unsigned char count;		/* + 1,1: jAJE^ (0..127) */
#define SIZEOF_APULINEAR	 2	; } APULINEAR;				/* = 2 */
 
					; /* Gx[v (240Hz) */
					; typedef struct _APUENVELOPE {
#define APUENVELOPE_FLAGS	 0	; 	unsigned char flags;		/* + 0,1: D0: 0 = Gx[v */
					; 					/*            1 = Gx[vL */
					; 					/*        D1: 0 = [v */
					; 					/*            1 = [vL */
#define APUENVELOPE_PERIOD	 1	; 	unsigned char period;		/* + 1,1: XV (1..16) */
#define APUENVELOPE_COUNT	 2	; 	unsigned char count;		/* + 2,1: isJE^ (0..16) */
#define APUENVELOPE_VOLUME	 3	; 	unsigned char volume;		/* + 3,1: {[ (0..15) */
#define SIZEOF_APUENVELOPE	 4	; } APUENVELOPE;			/* = 4 */
 
					; /* XC[v (120Hz) */
					; typedef struct _APUSWEEP {
#define APUSWEEP_FLAGS		 0	; 	unsigned char flags;		/* + 0,1: D0: 0 = XC[v */
					; 					/*            1 = XC[vL */
					; 					/*        D1: 0 =  */
					; 					/*            1 =  */
#define APUSWEEP_SHIFT		 1	; 	unsigned char shift;		/* + 1,1: gʂ̃Vtg */
#define APUSWEEP_PERIOD		 2	; 	unsigned char period;		/* + 2,1: XV (1..8) */
#define APUSWEEP_COUNT		 3	; 	unsigned char count;		/* + 3,1: isJE^ (0..8) */
#define APUSWEEP_WAVELENGTH	 4	; 	short wavelength;		/* + 4,2: g ($000..$800) */
#define SIZEOF_APUSWEEP		 6	; } APUSWEEP;				/* = 6 */
 
					; /* `g (Ch0,Ch1) */
					; typedef struct _APUSQUARE {
#define APUSQUARE_LENGTH	 0	; 	APULENGTH length;		/* + 0,2: OXJE^ */
#define APUSQUARE_ENVELOPE	 2	; 	APUENVELOPE envelope;		/* + 2,4: Gx[v */
#define APUSQUARE_SWEEP		 6	; 	APUSWEEP sweep;			/* + 6,6: XC[v */
#define APUSQUARE_DUTY		12	; 	unsigned char duty;		/* +12,1: f[eBTCN (2,4,8,12) */
#define APUSQUARE_WAVEINDEX	13	; 	unsigned char waveindex;	/* +13,1: g`CfNX (0..15) */
					; 					/* +14,2: (pfBO) */
#define APUSQUARE_WAVECOUNT	16	; 	int wavecount;			/* +16,4: g`isJE^ */
#define SIZEOF_APUSQUARE	20	; } APUSQUARE;				/* =20 */
 
					; /* Opg (Ch2) */
					; typedef struct _APUTRIANGLE {
#define APUTRIANGLE_LENGTH	 0	; 	APULENGTH length;		/* + 0,2: OXJE^ */
#define APUTRIANGLE_LINEAR	 2	; 	APULINEAR linear;		/* + 2,2: jAJE^ */
#define APUTRIANGLE_WAVELENGTH	 4	; 	short wavelength;		/* + 4,2: g ($000..$7ff) */
#define APUTRIANGLE_WAVEINDEX	 6	; 	unsigned char waveindex;	/* + 6,1: g`CfNX (0..31) */
					; 					/* + 7,1: (pfBO) */
#define APUTRIANGLE_WAVECOUNT	 8	; 	int wavecount;			/* + 8,4: g`isJE^ */
#define SIZEOF_APUTRIANGLE	12	; } APUTRIANGLE;			/* =12 */
 
					; /* mCY (Ch3) */
					; typedef struct _APUNOISE {
#define APUNOISE_LENGTH		 0	; 	APULENGTH length;		/* + 0,2: OXJE^ */
#define APUNOISE_ENVELOPE	 2	; 	APUENVELOPE envelope;		/* + 2,4: Gx[v */
#define APUNOISE_MODE		 6	; 	unsigned char mode;		/* + 6,1: 0 = long mode, 1 = short mode */
					; 					/* + 7,1: (pfBO) */
#define APUNOISE_LFSR		 8	; 	unsigned short lfsr;		/* + 8,2: LFSR (Linear Feedback Shift Register) */
#define APUNOISE_WAVELENGTH	10	; 	short wavelength;		/* +10,2: g ($000..$fff) */
#define APUNOISE_WAVECOUNT	12	; 	int wavecount;			/* +12,4: g`isJE^ */
#define SIZEOF_APUNOISE		16	; } APUNOISE;				/* =16 */

					; /* f^PCM (Ch4) */
					; typedef struct _APUDMC {
#define APUDMC_FLAGS		 0	; 	unsigned char flags;		/* + 0,1: D0: 0 = [v */
					; 					/*            1 = [vL */
					; 					/*        D7: JnɁAapu_write()  Zbg(1)܂B */
					; 					/*            ɁAapu_dmc_mix()NA(0)܂B */
#define APUDMC_INIT_OUTPUT	 1	; 	char init_output;		/* + 1,1: o͏l (-64..63) */
#define APUDMC_INIT_ADDRESS	 2	; 	unsigned short init_address;	/* + 2,2: TvAhXl ($C000..$FFC0) */
#define APUDMC_INIT_LENGTH	 4	; 	short init_length;		/* + 4,2: Tvf[^l ($001..$FF1) o͏l1JEgƌȂ */
#define APUDMC_WAVELENGTH	 6	; 	short wavelength;		/* + 6,2: g ($036..$1ac) */
					; 	//
					; 					/* + 8,1: (pfBO) */
#define APUDMC_OUTPUT		 9	; 	char output;			/* + 9,1: ݂̏o͒l (-64..63) */
#define APUDMC_ADDRESS		10	; 	unsigned short address;		/* +10,2: TvAhX (init_address->$FFFF->$8000->$FFFF) */
#define APUDMC_LENGTH		12	; 	short length;			/* +12,2: cTvf[^ (init_length->$000) */
#define APUDMC_SAMPLE		14	; 	unsigned short sample;		/* +14,2: Tvobt@ */
					; 					/*        Tv擾 (0x100|data) Zbg܂B */
					; 					/*        ŉʃrbg邽тɁAEVtg܂B */
					; 					/*        (sample<=1) Ȃ΁ATvobt@łB */
#define APUDMC_WAVECOUNT	16	; 	int wavecount;			/* +16,4: g`isJE^ */
					; 	//
#define APUDMC_MEMORY		20	; 	const unsigned char* memory;	/* +20,4: Tvf[^̐擪AhX */
#define SIZEOF_APUDMC		24	; } APUDMC;				/* =24 */

;****************************************************************************
;	
;****************************************************************************

;
;	void apu_square_mix(APUSQUARE* square, short wbuff[/*64*/])
;
	.global	apu_square_mix
apu_square_mix:
	xld.ub	%r9, [%r12+APUSQUARE_LENGTH+APULENGTH_COUNT]
	xcmp	%r9, 0							; if(!length->count) goto EXIT
	xjreq	apu_square_mix_EXIT
	;
	xld.ub	%r4, [%r12+APUSQUARE_ENVELOPE+APUENVELOPE_VOLUME]	; %r4 = volume = envelope->volume
	xcmp	%r4, 0							; if(!volume) goto EXIT
	xjreq	apu_square_mix_EXIT
	;
	xld.h	%r5, [%r12+APUSQUARE_SWEEP+APUSWEEP_WAVELENGTH]		; %r5 = wavelength = sweep->wavelength
	xcmp	%r5, 8							; if(wavelength <= 8) goto EXIT
	xjrle	apu_square_mix_EXIT
	xcmp	%r5, 0x7ff						; if(wavelength >= 0x7ff) goto EXIT
	xjrge	apu_square_mix_EXIT
	;
	xadd	%r5, %r5, 1						; wavelength = (wavelength + 1) * SPEAKER_FREQUENCY
	xld.w	%r9, SPEAKER_FREQUENCY
	mlt.h	%r5, %r9
	ld.w	%r5, %alr
	;
	xld.ub	%r6, [%r12+APUSQUARE_DUTY]				; %r6 = duty = square->duty
	;
	xld.ub	%r14, [%r12+APUSQUARE_WAVEINDEX]			; %r14 = waveindex = square->waveindex
	xld.w	%r15, [%r12+APUSQUARE_WAVECOUNT]			; %r15 = wavecount = square->wavecount
	;
	cmp	%r14, %r6						; output = (waveindex < duty) ? volume : -volume
	jrge.d	4
	ld.w	%r7, %r4						; *delay*
	not	%r7, %r4						; (skip?)
	add	%r7, 1							; (skip?)
	;
	xld.w	%r10, APU_CLOCK						; %r10 = APU_CLOCK
	xld.w	%r11, 64						; %r11 = i = 64
apu_square_mix_DO:
	sub	%r15, %r10						; wavecount -= APU_CLOCK
	xjruge	apu_square_mix_NO_ADVANCE				; if(NonCarry) goto NO_ADVANCE
	;
apu_square_mix_ADVANCE:
	add	%r15, %r5						; wavecount += wavelength
	xjruge.d	apu_square_mix_ADVANCE				; if(NonCarry) goto ADVANCE
	add	%r14, 1							; waveindex++ *delay*
	;
	xand	%r14, %r14, 15						; waveindex &= 15
	;
	cmp	%r14, %r6						; output = (waveindex < duty) ? volume : -volume
	jrge.d	4
	ld.w	%r7, %r4						; *delay*
	not	%r7, %r4						; (skip?)
	add	%r7, 1							; (skip?)
	;
apu_square_mix_NO_ADVANCE:
	ld.h	%r9, [%r13]						; *wbuff++ += output
	add	%r9, %r7
	ld.h	[%r13]+, %r9
	;
	xsub	%r11, %r11, 1						; if(--i) goto DO
	xjrne	apu_square_mix_DO
	;
	xld.b	[%r12+APUSQUARE_WAVEINDEX], %r14			; square->waveindex = waveindex
	xld.w	[%r12+APUSQUARE_WAVECOUNT], %r15			; square->wavecount = wavecount
	;
apu_square_mix_EXIT:
	ret

;****************************************************************************
;	
;****************************************************************************

;
;	void apu_triangle_mix(APUTRIANGLE* triangle, short wbuff[/*64*/])
;
	.global	apu_triangle_mix
apu_triangle_mix:
	xld.ub	%r9, [%r12+APUTRIANGLE_LENGTH+APULENGTH_COUNT]
	xcmp	%r9, 0							; if(!length->count) goto EXIT
	xjreq	apu_triangle_mix_EXIT
	;
	xld.ub	%r9, [%r12+APUTRIANGLE_LINEAR+APULINEAR_COUNT]
	xcmp	%r9, 0							; if(!linear->count) goto EXIT
	xjreq	apu_triangle_mix_EXIT
	;
	xld.h	%r5, [%r12+APUTRIANGLE_WAVELENGTH]			; %r5 = wavelength = triangle->wavelength
	xcmp	%r5, 8							; if(wavelength <= 8) goto EXIT
	xjrle	apu_triangle_mix_EXIT
	xcmp	%r5, 0x7ff						; if(wavelength >= 0x7ff) goto EXIT
	xjrge	apu_triangle_mix_EXIT
	;
	xadd	%r5, %r5, 1						; wavelength = (wavelength + 1) * SPEAKER_FREQUENCY
	xld.w	%r9, SPEAKER_FREQUENCY
	mlt.h	%r5, %r9
	ld.w	%r5, %alr
	;
	xld.ub	%r14, [%r12+APUTRIANGLE_WAVEINDEX]			; %r14 = waveindex = triangle->waveindex
	xld.w	%r15, [%r12+APUTRIANGLE_WAVECOUNT]			; %r15 = wavecount = triangle->wavecount
	;
	ext	apu_triangle_waveform_table@ah				; output = apu_triangle_waveform_table[waveindex]
	ext	apu_triangle_waveform_table@al
	ld.b	%r7, [%r14]
	;
	xld.w	%r10, APU_CLOCK						; %r10 = APU_CLOCK
	xld.w	%r11, 64						; %r11 = i = 64
apu_triangle_mix_DO:
	sub	%r15, %r10						; wavecount -= APU_CLOCK
	xjruge	apu_triangle_mix_NO_ADVANCE				; if(NonCarry) goto NO_ADVANCE
	;
apu_triangle_mix_ADVANCE:
	add	%r15, %r5						; wavecount += wavelength
	xjruge.d	apu_triangle_mix_ADVANCE			; if(NonCarry) goto ADVANCE
	add	%r14, 1							; waveindex++ *delay*
	;
	xand	%r14, %r14, 31						; waveindex &= 31
	;
	ext	apu_triangle_waveform_table@ah				; output = apu_triangle_waveform_table[waveindex]
	ext	apu_triangle_waveform_table@al
	ld.b	%r7, [%r14]
	;
apu_triangle_mix_NO_ADVANCE:
	ld.h	%r9, [%r13]						; *wbuff++ += output
	add	%r9, %r7
	ld.h	[%r13]+, %r9
	;
	xsub	%r11, %r11, 1						; if(--i) goto DO
	xjrne	apu_triangle_mix_DO
	;
	xld.b	[%r12+APUTRIANGLE_WAVEINDEX], %r14			; triangle->waveindex = waveindex
	xld.w	[%r12+APUTRIANGLE_WAVECOUNT], %r15			; triangle->wavecount = wavecount
	;
apu_triangle_mix_EXIT:
	ret

;****************************************************************************
;	
;****************************************************************************

;
;	void apu_noise_mix(APUNOISE* noise, short wbuff[/*64*/])
;
	.global	apu_noise_mix
apu_noise_mix:
	xld.ub	%r9, [%r12+APUNOISE_LENGTH+APULENGTH_COUNT]
	xcmp	%r9, 0							; if(!length->count) goto EXIT
	xjreq	apu_noise_mix_EXIT
	;
	xld.ub	%r4, [%r12+APUNOISE_ENVELOPE+APUENVELOPE_VOLUME]	; %r4 = volume = envelope->volume
	xcmp	%r4, 0							; if(!volume) goto EXIT
	xjreq	apu_noise_mix_EXIT
	;
	xld.h	%r5, [%r12+APUNOISE_WAVELENGTH]				; %r5 = wavelength = noise->wavelength
	xcmp	%r5, 0							; if(!wavelength) goto EXIT
	xjreq	apu_noise_mix_EXIT
	;
	xld.w	%r9, SPEAKER_FREQUENCY					; wavelength = wavelength * SPEAKER_FREQUENCY
	mlt.h	%r5, %r9
	ld.w	%r5, %alr
	;
	xld.ub	%r6, [%r12+APUNOISE_MODE]				; %r6 = mode = noise->mode
	;
	xld.uh	%r14, [%r12+APUNOISE_LFSR     ]				; %r14 = lfsr      = noise->lfsr
	xld.w	%r15, [%r12+APUNOISE_WAVECOUNT]				; %r15 = wavecount = noise->wavecount
	;
	xand	%r9, %r14, 1						; output = !(lfsr & 1) ? volume : -volume
	jreq.d	4
	ld.w	%r7, %r4						; *delay*
	not	%r7, %r4						; (skip?)
	add	%r7, 1							; (skip?)
	;
	xld.w	%r10, APU_CLOCK						; %r10 = APU_CLOCK
	xld.w	%r11, 64						; %r11 = i = 64
apu_noise_mix_DO:
	sub	%r15, %r10						; wavecount -= APU_CLOCK
	xjruge	apu_noise_mix_NO_ADVANCE				; if(NonCarry) goto NO_ADVANCE
	;
apu_noise_mix_ADVANCE:
	ld.w	%r9, %r14						; %r9 = v = ((lfsr>>0) ^ (lfsr>>mode)) & 1
	srl	%r9, %r6						;  "xsrl %r9,%r6"ƂĂ͂܂!!
	xor	%r9, %r14						;  xsrlWJA%r9j󂳂Ă܂܂B
	and	%r9, 1							;  %r6=mode=1or6Ȃ̂ŁAxsrl͕Kv܂B
	;
	xsrl	%r14, 1
	xsll	%r9, 14							; lfsr = (lfsr >> 1) | (v << 14)
	;or	%r14, %r9						;  -> 4sֈړ܂B
	;
	add	%r15, %r5						; wavecount += wavelength
	xjruge.d	apu_noise_mix_ADVANCE				; if(NonCarry) goto ADVANCE
	or	%r14, %r9						;  <- 4sォڂ܂B *delay*
	;
	xand	%r9, %r14, 1						; output = !(lfsr & 1) ? volume : -volume
	jreq.d	4
	ld.w	%r7, %r4						; *delay*
	not	%r7, %r4						; (skip?)
	add	%r7, 1							; (skip?)
	;
apu_noise_mix_NO_ADVANCE:
	ld.h	%r9, [%r13]						; *wbuff++ += output
	add	%r9, %r7
	ld.h	[%r13]+, %r9
	;
	xsub	%r11, %r11, 1						; if(--i) goto DO
	xjrne	apu_noise_mix_DO
	;
	xld.h	[%r12+APUNOISE_LFSR     ], %r14				; noise->lfsr      = lfsr
	xld.w	[%r12+APUNOISE_WAVECOUNT], %r15				; noise->wavecount = wavecount
	;
apu_noise_mix_EXIT:
	ret

;****************************************************************************
;	
;****************************************************************************

;
;	void apu_dmc_mix(APUDMC* dmc, short wbuff[/*64*/])
;
	.global	apu_dmc_mix
apu_dmc_mix:
	pushn	%r0
	xld.w	%r0, [%r12+APUDMC_MEMORY]				; %r0 = memory = dmc->memory
	;
	xld.h	%r5, [%r12+APUDMC_WAVELENGTH]				; %r5 = wavelength = dmc->wavelength
	xcmp	%r5, 0							; if(!wavelength) goto STOP
	xjreq	apu_dmc_mix_STOP
	;
	xld.w	%r9, SPEAKER_FREQUENCY					; wavelength = wavelength * SPEAKER_FREQUENCY
	mlt.h	%r5, %r9
	ld.w	%r5, %alr
	;
	xld.b	%r7 , [%r12+APUDMC_OUTPUT   ]				; %r7  = output    = dmc->output
	xld.uh	%r4 , [%r12+APUDMC_ADDRESS  ]				; %r4  = address   = dmc->address
	xld.h	%r6 , [%r12+APUDMC_LENGTH   ]				; %r6  = length    = dmc->length
	xld.uh	%r14, [%r12+APUDMC_SAMPLE   ]				; %r14 = sample    = dmc->sample
	xld.w	%r15, [%r12+APUDMC_WAVECOUNT]				; %r15 = wavecount = dmc->wavecount
	;
	xld.w	%r10, APU_CLOCK						; %r10 = APU_CLOCK
	xld.w	%r11, 64						; %r11 = i = 64
apu_dmc_mix_DO:
	sub	%r15, %r10						; wavecount -= APU_CLOCK
	xjruge	apu_dmc_mix_NO_ADVANCE					; if(NonCarry) goto NO_ADVANCE
	;
apu_dmc_mix_ADVANCE:
	xcmp	%r14, 1							; if(sample <= 1) {
	xjrgt	apu_dmc_mix_SAMPLE_NOT_EMPTY				;   
	xsub	%r6, %r6, 1						;   length--
	xjrne	apu_dmc_mix_LENGTH_NOT_ZERO				;   if(!length) {
	xbtst	[%r12+APUDMC_FLAGS], 0					;     if(!(dmc->flags & (1<<0)))
	xjreq	apu_dmc_mix_STOP					;       goto STOP
	xld.b	%r7, [%r12+APUDMC_INIT_OUTPUT ]				;     output  = dmc->init_output
	xld.uh	%r4, [%r12+APUDMC_INIT_ADDRESS]				;     address = dmc->init_address
	xld.h	%r6, [%r12+APUDMC_INIT_LENGTH ]				;     length  = dmc->init_length
	xjp	apu_dmc_mix_ADVANCE_LOOP				;     continue
apu_dmc_mix_LENGTH_NOT_ZERO:						;   }
	add	%r4, %r0						;   sample = memory[address++] | 0x100
	ld.ub	%r14, [%r4]+						;   
	sub	%r4, %r0						;   
	xoor	%r14, %r14, 0x100					;   
	ld.uh	%r4, %r4						;   address = (unsigned short)address | 0x8000
	xoor	%r4, %r4, 0x8000					;   
apu_dmc_mix_SAMPLE_NOT_EMPTY:						; }
	;
	xand	%r9, %r14, 1						; if(!(sample & 1)) {
	xjrne.d	apu_dmc_mix_SAMPLE_LSB_1				; 
	srl	%r14, 1							; sample >>= 1 *delay*
	xcmp	%r7, -64+2						;
	xjrge.d	apu_dmc_mix_SAMPLE_LSB_DONE				;   if(output >= -64 + 2) {
	sub	%r7, 2							;     output -= 2 *delay*
	ld.w	%r7, -1							;   } else { output = -64 (=-1<<6) }
	xjp.d	apu_dmc_mix_SAMPLE_LSB_DONE				;   
	sll	%r7, 6							;                 *delay*
apu_dmc_mix_SAMPLE_LSB_1:						; } else {
	xcmp	%r7, 64-2						; 
	xjrle.d	apu_dmc_mix_SAMPLE_LSB_DONE				;   if(output <= 64 - 2) {
	add	%r7, 2							;     output += 2 *delay*
	xld.w	%r7, 63							;   } else { output = 63 }
apu_dmc_mix_SAMPLE_LSB_DONE:						; }
	;
apu_dmc_mix_ADVANCE_LOOP:
	add	%r15, %r5						; wavecount += wavelength
	xjruge	apu_dmc_mix_ADVANCE					; if(NonCarry) goto ADVANCE
	;
apu_dmc_mix_NO_ADVANCE:
	ld.h	%r9, [%r13]						; *wbuff++ += output
	add	%r9, %r7
	ld.h	[%r13]+, %r9
	;
	xsub	%r11, %r11, 1						; if(--i) goto DO
	xjrne	apu_dmc_mix_DO
	;
	xld.b	[%r12+APUDMC_OUTPUT   ], %r7				; dmc->output    = output
	xld.h	[%r12+APUDMC_ADDRESS  ], %r4				; dmc->address   = address
	xld.h	[%r12+APUDMC_LENGTH   ], %r6				; dmc->length    = length
	xld.h	[%r12+APUDMC_SAMPLE   ], %r14				; dmc->sample    = sample
	xld.w	[%r12+APUDMC_WAVECOUNT], %r15				; dmc->wavecount = wavecount
	;
apu_dmc_mix_EXIT:
	popn	%r0
	ret
	;
apu_dmc_mix_STOP:
	xbclr	[%r12+APUDMC_FLAGS], 7					; dmc->flags &= ~(1<<7)
	xjp	apu_dmc_mix_EXIT

;****************************************************************************
;	
;****************************************************************************

#endif /*APU_ASM*/
