/*	
 *	app.h
 *
 *	PceEth - P/ECE NDIS-WDM ~j|[ghCo
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Tue Aug 16 06:19:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 */
#ifndef __APP_H__
#define __APP_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ndis.h>
#include <usbdi.h>
#include <usbdlib.h>

#define VERBOSE /* ̃V{`ƁAڍׂȃfobOo͂s܂ */

/*****************************************************************************
 *	
 *****************************************************************************/

/*  ==========================[ Ethernetڰэ\ ]==========================
 *
 *           |<----- NDIS߰ײނ (60-1514 byte) ----->|
 *           |                                                       |
 *  +--------+--------------+--------------+--------+----------------+-----+
 *  | 8 byte |    6 byte    |    6 byte    | 2 byte |  46-1500 byte  |4byte|
 *  +--------+--------------+--------------+--------+----------------+-----+
 *  |ر|ĐMACڽ|MMACڽ|ڰ|      ް      | FCS |
 *  +--------+--------------+--------------+--------+----------------+-----+
 *       A                                                              A
 *       |                                                              |
 *       +-- NICʰ޳t/̂Ťײ޿ĳł͍lȂ --+
 */

/*****************************************************************************
 *	
 *****************************************************************************/

typedef struct _MINIPORT_ADAPTER {
	NDIS_HANDLE miniport_adapter_handle;		/* ~j|[gA_v^nh */

	DEVICE_OBJECT* physical_device_object;		/* foCXIuWFNg (USB?) */
	DEVICE_OBJECT* functional_device_object;	/* ̃foCXIuWFNg (NIC)  */
	DEVICE_OBJECT* next_device_object;		/* ʃfoCXIuWFNg (USBD) */

	KSPIN_LOCK spin_lock;				/* LXsbN */
	KEVENT abort_event;				/* fʒmCxg */

	unsigned char address[6];			/* MACAhX */
	int packet_filter;				/* pPbgtB^ */
	int xmit_ok;					/* MpPbg */
	int rcv_ok;					/* MpPbg */
	int xmit_error;					/* MspPbg */
	int rcv_error;					/* MspPbg */

	USBD_PIPE_INFORMATION tx_pipe;			/* oNMpCv */
	KEVENT tx_event;				/* MėpCxg */
	PKTHREAD tx_thread;				/* MXbh */
	LIST_ENTRY tx_queue;				/* MpPbgL[ */

	USBD_PIPE_INFORMATION rx_pipe;			/* oNMpCv */
	KEVENT rx_event;				/* MėpCxg */
	PKTHREAD rx_thread;				/* MXbh */
	NDIS_HANDLE rx_packet_pool_handle;		/* MpPbgv[ */
	NDIS_HANDLE rx_buffer_pool_handle;		/* Mobt@v[ */
} MINIPORT_ADAPTER;

/*****************************************************************************
 *	main.c
 *****************************************************************************/

extern NDIS_HANDLE ndis_wrapper_handle;

NDIS_STATUS miniport_initialize(
	NDIS_STATUS* open_error_status,
	UINT* selected_medium_index,
	NDIS_MEDIUM* medium_array,
	UINT medium_array_size,
	NDIS_HANDLE miniport_adapter_handle,
	NDIS_HANDLE wrapper_configuration_context);

NDIS_STATUS miniport_reset(
	BOOLEAN* addressing_reset,
	NDIS_HANDLE miniport_adapter_context);

void miniport_halt(
	NDIS_HANDLE miniport_adapter_context);

NDIS_STATUS miniport_query_information(
	NDIS_HANDLE miniport_adapter_context,
	NDIS_OID oid,
	void* information_buffer,
	ULONG information_buffer_length,
	ULONG* bytes_written,
	ULONG* bytes_needed);

NDIS_STATUS miniport_set_information(
	NDIS_HANDLE miniport_adapter_context,
	NDIS_OID oid,
	void* information_buffer,
	ULONG information_buffer_length,
	ULONG* bytes_read,
	ULONG* bytes_needed);

void miniport_send_packets(
	NDIS_HANDLE miniport_adapter_context,
	NDIS_PACKET* packet_array[],
	UINT number_of_packets);

void miniport_return_packet(
	NDIS_HANDLE miniport_adapter_context,
	NDIS_PACKET* packet);

/*****************************************************************************
 *	adapter.c
 *****************************************************************************/

MINIPORT_ADAPTER* create_miniport_adapter(
	NDIS_HANDLE miniport_adapter_handle,
	NDIS_HANDLE wrapper_configuration_context);

void delete_miniport_adapter(
	MINIPORT_ADAPTER* miniport_adapter);

/*****************************************************************************
 *	tx.c
 *****************************************************************************/

NTSTATUS tx_init(MINIPORT_ADAPTER* miniport_adapter);
void tx_exit(MINIPORT_ADAPTER* miniport_adapter);
void tx_cancel_packets(MINIPORT_ADAPTER* miniport_adapter);

/*****************************************************************************
 *	rx.c
 *****************************************************************************/

NTSTATUS rx_init(MINIPORT_ADAPTER* miniport_adapter);
void rx_exit(MINIPORT_ADAPTER* miniport_adapter);
NDIS_PACKET* rx_allocate_packet(MINIPORT_ADAPTER* miniport_adapter, const void* data, int length);
void rx_free_packet(MINIPORT_ADAPTER* miniport_adapter, NDIS_PACKET* packet);
void rx_recall_packets(MINIPORT_ADAPTER* miniport_adapter);

/*****************************************************************************
 *	util.c
 *****************************************************************************/

const char* oid_name(int code);
PKTHREAD create_thread(void (*start_routine)(void*), void* start_context);
void delete_thread(PKTHREAD thread_object);
NTSTATUS call_usbd(DEVICE_OBJECT* usbd, URB* urb);
USB_CONFIGURATION_DESCRIPTOR* get_configuration_descriptor(DEVICE_OBJECT* usbd, int i_configuration);
int set_configuration(DEVICE_OBJECT* usbd, USBD_PIPE_INFORMATION pipes[/*max_pipes*/], int max_pipes);
void clear_configuration(DEVICE_OBJECT* usbd);
NTSTATUS usb_transfer(DEVICE_OBJECT* device_object, URB* urb, KEVENT* cancel_event);
NTSTATUS set_device_address(DEVICE_OBJECT* usbd, const unsigned char address[6]);

/*****************************************************************************
 *	
 *****************************************************************************/

#endif /*__APP_H__*/
