/*	
 *	adapter.c
 *
 *	PceEth - P/ECE NDIS-WDM ~j|[ghCo
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Tue Aug 16 06:19:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/*****************************************************************************
 *	
 *****************************************************************************/

MINIPORT_ADAPTER*
create_miniport_adapter(
	NDIS_HANDLE miniport_adapter_handle,
	NDIS_HANDLE wrapper_configuration_context)
{
	static int device_index = -1;
	//
	NTSTATUS status;
	MINIPORT_ADAPTER* miniport_adapter;
	LARGE_INTEGER system_time;
	int user_code;
	unsigned char address[6];
	USBD_PIPE_INFORMATION pipes[2];

	KdPrint(("create_miniport_adapter called\n"));

	/* zXg/foCXɊUMACAhXUserCodéAVXeΎ琶邱Ƃɂ܂B
	 * lbg[NMACAhXd\͔ɒႢƎv܂A
	 * Adꍇ́AP/ECE𔲂AVMACAhXU邱ƂŉĂB
	 * 2005/08/18݂̎ł́AIȉ͍̂Ă܂B
	 */
	KeQuerySystemTime(&system_time);
	user_code = (int)(system_time.QuadPart / 10000); /* 100imb -> ~b */

	/* \̂̃mۂ܂B */
	miniport_adapter = ExAllocatePool(NonPagedPool, sizeof(MINIPORT_ADAPTER));
	if(miniport_adapter) {
		memset(miniport_adapter, 0, sizeof(MINIPORT_ADAPTER));

		/* ~j|[gA_v^nhi[܂B */
		miniport_adapter->miniport_adapter_handle = miniport_adapter_handle;

		/* LXsbN܂B */
		KeInitializeSpinLock(&miniport_adapter->spin_lock);

		/* fʒmCxg܂B */
		KeInitializeEvent(&miniport_adapter->abort_event, NotificationEvent, FALSE);

		/* zXgMACAhXݒ肵܂B */
		address[0] = 2;				/* VendorCode (I/G=0,U/L=1,Vendor=0) */
		address[1] = 0;
		address[2] = 0;
		address[3] = (user_code & ~1) >> 16;	/* UserCode */
		address[4] = (user_code & ~1) >>  8;
		address[5] = (user_code & ~1) >>  0;
		KdPrint(("host   address = %02x-%02x-%02x-%02x-%02x-%02x\n",
			address[0],address[1],address[2],address[3],address[4],address[5]));
		memcpy(miniport_adapter->address, address, 6);

		/* foCXIuWFNg擾܂B */
		NdisMGetDeviceProperty(
			miniport_adapter_handle,			/* MiniportAdapterHandle */
			&miniport_adapter->physical_device_object,	/* PhysicalDeviceObject */
			&miniport_adapter->functional_device_object,	/* FunctionalDeviceObject */
			&miniport_adapter->next_device_object,		/* NextDeviceObject */
			NULL,						/* AllocatedResources */
			NULL);						/* AllocatedResourcesTranslated */

		/* RtBM[VI܂B */
		if(set_configuration(miniport_adapter->next_device_object, pipes, 2) == 2) {
			miniport_adapter->rx_pipe = pipes[0];
			miniport_adapter->tx_pipe = pipes[1];

			/* foCXMACAhXݒ肵܂B */
			address[0] = 2;				/* VendorCode (I/G=0,U/L=1,Vendor=0) */
			address[1] = 0;
			address[2] = 0;
			address[3] = (user_code | 1) >> 16;	/* UserCode */
			address[4] = (user_code | 1) >>  8;
			address[5] = (user_code | 1) >>  0;
			KdPrint(("device address = %02x-%02x-%02x-%02x-%02x-%02x\n",
				address[0],address[1],address[2],address[3],address[4],address[5]));
			status = set_device_address(miniport_adapter->next_device_object, address);
			if(NT_SUCCESS(status)) {

				/* M܂B */
				status = tx_init(miniport_adapter);
				if(NT_SUCCESS(status)) {

					/* M܂B */
					status = rx_init(miniport_adapter);
					if(NT_SUCCESS(status)) {

						/* SĐ܂B */
						return miniport_adapter;

					} else {
						KdPrint(("rx_init failed\n"));
					}
					tx_exit(miniport_adapter);
				} else {
					KdPrint(("tx_init failed\n"));
				}
				/* set_device_address()͉sv */
			} else {
				KdPrint(("set_device_address failed\n"));
			}
			clear_configuration(miniport_adapter->next_device_object);
		} else {
			KdPrint(("set_configuration failed\n"));
		}
		ExFreePool(miniport_adapter);
		miniport_adapter = NULL;
	} else {
		KdPrint(("ExAllocatePool failed\n"));
	}

	return NULL;
}

/*****************************************************************************
 *	
 *****************************************************************************/

void
delete_miniport_adapter(
	MINIPORT_ADAPTER* miniport_adapter)
{
	KdPrint(("delete_miniport_adapter called\n"));

	/* MI܂B */
	rx_exit(miniport_adapter);

	/* MI܂B */
	tx_exit(miniport_adapter);

	/* RtBM[V𖢑Iɖ߂܂B */
	clear_configuration(miniport_adapter->next_device_object);

	/* \̂̃J܂B */
	ExFreePool(miniport_adapter);
}
